/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula;

import org.zkoss.poi.ss.SpreadsheetVersion;
import org.zkoss.poi.ss.formula.ptg.Area2DPtgBase;
import org.zkoss.poi.ss.formula.ptg.Area3DPtg;
import org.zkoss.poi.ss.formula.ptg.AreaErrPtg;
import org.zkoss.poi.ss.formula.ptg.AreaPtg;
import org.zkoss.poi.ss.formula.ptg.AreaPtgBase;
import org.zkoss.poi.ss.formula.ptg.DeletedArea3DPtg;
import org.zkoss.poi.ss.formula.ptg.DeletedRef3DPtg;
import org.zkoss.poi.ss.formula.ptg.Ptg;
import org.zkoss.poi.ss.formula.ptg.Ref3DPtg;
import org.zkoss.poi.ss.formula.ptg.RefErrorPtg;
import org.zkoss.poi.ss.formula.ptg.RefPtg;
import org.zkoss.poi.ss.formula.ptg.RefPtgBase;

public final class FormulaShifter {
    private final int _externSheetIndex;
    private final int _firstMovedIndex;
    private final int _lastMovedIndex;
    private final int _amountToMove;
    private final boolean _isRow;
    private final int _srcSheetIndex;
    private final int _dstSheetIndex;
    private final ShiftMode _mode;

    private FormulaShifter(int externSheetIndex, int firstMovedIndex, int lastMovedIndex, int amountToMove, boolean isRow) {
        if (amountToMove == 0) {
            throw new IllegalArgumentException("amountToMove must not be zero");
        }
        if (firstMovedIndex > lastMovedIndex) {
            throw new IllegalArgumentException("firstMovedIndex, lastMovedIndex out of order:" + firstMovedIndex + "," + lastMovedIndex);
        }
        this._externSheetIndex = externSheetIndex;
        this._firstMovedIndex = firstMovedIndex;
        this._lastMovedIndex = lastMovedIndex;
        this._amountToMove = amountToMove;
        this._mode = ShiftMode.Row;
        this._dstSheetIndex = -1;
        this._srcSheetIndex = -1;
        this._isRow = isRow;
    }

    private FormulaShifter(int srcSheetIndex, int dstSheetIndex) {
        this._amountToMove = -1;
        this._lastMovedIndex = -1;
        this._firstMovedIndex = -1;
        this._externSheetIndex = -1;
        this._isRow = true;
        this._srcSheetIndex = srcSheetIndex;
        this._dstSheetIndex = dstSheetIndex;
        this._mode = ShiftMode.Sheet;
    }

    public static FormulaShifter createForRowShift(int externSheetIndex, int firstMovedRowIndex, int lastMovedRowIndex, int numberOfRowsToMove) {
        return new FormulaShifter(externSheetIndex, firstMovedRowIndex, lastMovedRowIndex, numberOfRowsToMove, true);
    }

    public static FormulaShifter createForSheetShift(int srcSheetIndex, int dstSheetIndex) {
        return new FormulaShifter(srcSheetIndex, dstSheetIndex);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" [");
        sb.append(this._firstMovedIndex);
        sb.append(this._lastMovedIndex);
        sb.append(this._amountToMove);
        sb.append(this._isRow);
        return sb.toString();
    }

    public boolean adjustFormula(Ptg[] ptgs, int currentExternSheetIx) {
        boolean refsWereChanged = false;
        for (int i = 0; i < ptgs.length; ++i) {
            Ptg newPtg = this.adjustPtg(ptgs[i], currentExternSheetIx);
            if (newPtg == null) continue;
            refsWereChanged = true;
            ptgs[i] = newPtg;
        }
        return refsWereChanged;
    }

    private Ptg adjustPtg(Ptg ptg, int currentExternSheetIx) {
        switch (this._mode) {
            case Row: {
                return this._isRow ? this.adjustPtgDueToRowMove(ptg, currentExternSheetIx) : this.adjustPtgDueToColMove(ptg, currentExternSheetIx);
            }
            case Sheet: {
                return this.adjustPtgDueToShiftMove(ptg);
            }
        }
        throw new IllegalStateException("Unsupported shift mode: " + (Object)((Object)this._mode));
    }

    private Ptg adjustPtgDueToRowMove(Ptg ptg, int currentExternSheetIx) {
        if (ptg instanceof RefPtg) {
            if (currentExternSheetIx != this._externSheetIndex) {
                return null;
            }
            RefPtg rptg = (RefPtg)ptg;
            return this.rowMoveRefPtg(rptg);
        }
        if (ptg instanceof Ref3DPtg) {
            Ref3DPtg rptg = (Ref3DPtg)ptg;
            if (this._externSheetIndex != rptg.getExternSheetIndex()) {
                return null;
            }
            return this.rowMoveRefPtg(rptg);
        }
        if (ptg instanceof Area2DPtgBase) {
            if (currentExternSheetIx != this._externSheetIndex) {
                return ptg;
            }
            return this.rowMoveAreaPtg((Area2DPtgBase)ptg);
        }
        if (ptg instanceof Area3DPtg) {
            Area3DPtg aptg = (Area3DPtg)ptg;
            if (this._externSheetIndex != aptg.getExternSheetIndex()) {
                return null;
            }
            return this.rowMoveAreaPtg(aptg);
        }
        return null;
    }

    private Ptg adjustPtgDueToShiftMove(Ptg ptg) {
        Ref3DPtg updatedPtg = null;
        if (ptg instanceof Ref3DPtg) {
            Ref3DPtg ref = (Ref3DPtg)ptg;
            if (ref.getExternSheetIndex() == this._srcSheetIndex) {
                ref.setExternSheetIndex(this._dstSheetIndex);
                updatedPtg = ref;
            } else if (ref.getExternSheetIndex() == this._dstSheetIndex) {
                ref.setExternSheetIndex(this._srcSheetIndex);
                updatedPtg = ref;
            }
        }
        return updatedPtg;
    }

    private Ptg rowMoveRefPtg(RefPtgBase rptg) {
        int refRow = rptg.getRow();
        if (this._firstMovedIndex <= refRow && refRow <= this._lastMovedIndex) {
            return this.rptgSetRow(rptg, refRow + this._amountToMove);
        }
        int destFirstRowIndex = this._firstMovedIndex + this._amountToMove;
        int destLastRowIndex = this._lastMovedIndex + this._amountToMove;
        if (destLastRowIndex < refRow || refRow < destFirstRowIndex) {
            return null;
        }
        if (destFirstRowIndex <= refRow && refRow <= destLastRowIndex) {
            return FormulaShifter.createDeletedRef(rptg);
        }
        throw new IllegalStateException("Situation not covered: (" + this._firstMovedIndex + ", " + this._lastMovedIndex + ", " + this._amountToMove + ", " + refRow + ", " + refRow + ")");
    }

    private Ptg rowMoveAreaPtg(AreaPtgBase aptg) {
        int aFirstRow = aptg.getFirstRow();
        int aLastRow = aptg.getLastRow();
        if (this._firstMovedIndex <= aFirstRow && aLastRow <= this._lastMovedIndex) {
            this.aptgSetLastRow(aptg, aLastRow + this._amountToMove);
            return this.aptgSetFirstRow(aptg, aFirstRow + this._amountToMove);
        }
        int destFirstRowIndex = this._firstMovedIndex + this._amountToMove;
        int destLastRowIndex = this._lastMovedIndex + this._amountToMove;
        if (aFirstRow < this._firstMovedIndex && this._lastMovedIndex < aLastRow) {
            if (destFirstRowIndex < aFirstRow && aFirstRow <= destLastRowIndex) {
                return this.aptgSetFirstRow(aptg, destLastRowIndex + 1);
            }
            if (destFirstRowIndex <= aLastRow && aLastRow < destLastRowIndex) {
                this.aptgSetLastRow(aptg, destFirstRowIndex - 1);
                return aptg;
            }
            return null;
        }
        if (this._firstMovedIndex <= aFirstRow && aFirstRow <= this._lastMovedIndex) {
            if (this._amountToMove < 0) {
                return this.aptgSetFirstRow(aptg, aFirstRow + this._amountToMove);
            }
            if (destFirstRowIndex > aLastRow) {
                return null;
            }
            int newFirstRowIx = aFirstRow + this._amountToMove;
            if (destLastRowIndex < aLastRow) {
                return this.aptgSetFirstRow(aptg, newFirstRowIx);
            }
            int areaRemainingTopRowIx = this._lastMovedIndex + 1;
            if (destFirstRowIndex > areaRemainingTopRowIx) {
                newFirstRowIx = areaRemainingTopRowIx;
            }
            this.aptgSetLastRow(aptg, Math.max(aLastRow, destLastRowIndex));
            return this.aptgSetFirstRow(aptg, newFirstRowIx);
        }
        if (this._firstMovedIndex <= aLastRow && aLastRow <= this._lastMovedIndex) {
            if (this._amountToMove > 0) {
                this.aptgSetLastRow(aptg, aLastRow + this._amountToMove);
                return aptg;
            }
            if (destLastRowIndex < aFirstRow) {
                return null;
            }
            int newLastRowIx = aLastRow + this._amountToMove;
            if (destFirstRowIndex > aFirstRow) {
                this.aptgSetLastRow(aptg, newLastRowIx);
                return aptg;
            }
            int areaRemainingBottomRowIx = this._firstMovedIndex - 1;
            if (destLastRowIndex < areaRemainingBottomRowIx) {
                newLastRowIx = areaRemainingBottomRowIx;
            }
            this.aptgSetLastRow(aptg, newLastRowIx);
            return this.aptgSetFirstRow(aptg, Math.min(aFirstRow, destFirstRowIndex));
        }
        if (destLastRowIndex < aFirstRow || aLastRow < destFirstRowIndex) {
            return null;
        }
        if (destFirstRowIndex <= aFirstRow && aLastRow <= destLastRowIndex) {
            return FormulaShifter.createDeletedRef(aptg);
        }
        if (aFirstRow <= destFirstRowIndex && destLastRowIndex <= aLastRow) {
            return null;
        }
        if (destFirstRowIndex < aFirstRow && aFirstRow <= destLastRowIndex) {
            return this.aptgSetFirstRow(aptg, destLastRowIndex + 1);
        }
        if (destFirstRowIndex < aLastRow && aLastRow <= destLastRowIndex) {
            this.aptgSetLastRow(aptg, destFirstRowIndex - 1);
            return aptg;
        }
        throw new IllegalStateException("Situation not covered: (" + this._firstMovedIndex + ", " + this._lastMovedIndex + ", " + this._amountToMove + ", " + aFirstRow + ", " + aLastRow + ")");
    }

    private static Ptg createDeletedRef(Ptg ptg) {
        if (ptg instanceof RefPtg) {
            return new RefErrorPtg();
        }
        if (ptg instanceof Ref3DPtg) {
            Ref3DPtg rptg = (Ref3DPtg)ptg;
            return new DeletedRef3DPtg(rptg.getExternSheetIndex());
        }
        if (ptg instanceof AreaPtg) {
            return new AreaErrPtg();
        }
        if (ptg instanceof Area3DPtg) {
            Area3DPtg area3DPtg = (Area3DPtg)ptg;
            return new DeletedArea3DPtg(area3DPtg.getExternSheetIndex());
        }
        throw new IllegalArgumentException("Unexpected ref ptg class (" + ptg.getClass().getName() + ")");
    }

    private Ptg rptgSetRow(RefPtgBase rptg, int rowNum) {
        if (rowNum > SpreadsheetVersion.EXCEL97.getLastRowIndex()) {
            return FormulaShifter.createDeletedRef(rptg);
        }
        rptg.setRow(rowNum);
        return rptg;
    }

    private void aptgSetLastRow(AreaPtgBase aptg, int rowNum) {
        if (rowNum > SpreadsheetVersion.EXCEL97.getLastRowIndex()) {
            aptg.setLastRow(SpreadsheetVersion.EXCEL97.getLastRowIndex());
        } else {
            aptg.setLastRow(rowNum);
        }
    }

    private Ptg aptgSetFirstRow(AreaPtgBase aptg, int rowNum) {
        if (rowNum > SpreadsheetVersion.EXCEL97.getLastRowIndex()) {
            return FormulaShifter.createDeletedRef(aptg);
        }
        aptg.setFirstRow(rowNum);
        return aptg;
    }

    public static FormulaShifter createForColumnShift(int externSheetIndex, int firstMovedColIndex, int lastMovedColIndex, int numberOfColsToMove) {
        return new FormulaShifter(externSheetIndex, firstMovedColIndex, lastMovedColIndex, numberOfColsToMove, false);
    }

    private Ptg adjustPtgDueToColMove(Ptg ptg, int currentExternSheetIx) {
        if (ptg instanceof RefPtg) {
            if (currentExternSheetIx != this._externSheetIndex) {
                return null;
            }
            RefPtg rptg = (RefPtg)ptg;
            return this.colMoveRefPtg(rptg);
        }
        if (ptg instanceof Ref3DPtg) {
            Ref3DPtg rptg = (Ref3DPtg)ptg;
            if (this._externSheetIndex != rptg.getExternSheetIndex()) {
                return null;
            }
            return this.colMoveRefPtg(rptg);
        }
        if (ptg instanceof Area2DPtgBase) {
            if (currentExternSheetIx != this._externSheetIndex) {
                return ptg;
            }
            return this.colMoveAreaPtg((Area2DPtgBase)ptg);
        }
        if (ptg instanceof Area3DPtg) {
            Area3DPtg aptg = (Area3DPtg)ptg;
            if (this._externSheetIndex != aptg.getExternSheetIndex()) {
                return null;
            }
            return this.colMoveAreaPtg(aptg);
        }
        return null;
    }

    private Ptg colMoveRefPtg(RefPtgBase rptg) {
        int refCol = rptg.getColumn();
        if (this._firstMovedIndex <= refCol && refCol <= this._lastMovedIndex) {
            return this.rptgSetCol(rptg, refCol + this._amountToMove);
        }
        int destFirstColIndex = this._firstMovedIndex + this._amountToMove;
        int destLastColIndex = this._lastMovedIndex + this._amountToMove;
        if (destLastColIndex < refCol || refCol < destFirstColIndex) {
            return null;
        }
        if (destFirstColIndex <= refCol && refCol <= destLastColIndex) {
            return FormulaShifter.createDeletedRef(rptg);
        }
        throw new IllegalStateException("Situation not covered: (" + this._firstMovedIndex + ", " + this._lastMovedIndex + ", " + this._amountToMove + ", " + refCol + ", " + refCol + ")");
    }

    private Ptg colMoveAreaPtg(AreaPtgBase aptg) {
        int aFirstCol = aptg.getFirstColumn();
        int aLastCol = aptg.getLastColumn();
        if (this._firstMovedIndex <= aFirstCol && aLastCol <= this._lastMovedIndex) {
            this.aptgSetLastCol(aptg, aLastCol + this._amountToMove);
            return this.aptgSetFirstCol(aptg, aFirstCol + this._amountToMove);
        }
        int destFirstColIndex = this._firstMovedIndex + this._amountToMove;
        int destLastColIndex = this._lastMovedIndex + this._amountToMove;
        if (aFirstCol < this._firstMovedIndex && this._lastMovedIndex < aLastCol) {
            if (destFirstColIndex < aFirstCol && aFirstCol <= destLastColIndex) {
                return this.aptgSetFirstCol(aptg, destLastColIndex + 1);
            }
            if (destFirstColIndex <= aLastCol && aLastCol < destLastColIndex) {
                this.aptgSetLastCol(aptg, destFirstColIndex - 1);
                return aptg;
            }
            return null;
        }
        if (this._firstMovedIndex <= aFirstCol && aFirstCol <= this._lastMovedIndex) {
            if (this._amountToMove < 0) {
                return this.aptgSetFirstCol(aptg, aFirstCol + this._amountToMove);
            }
            if (destFirstColIndex > aLastCol) {
                return null;
            }
            int newFirstColIx = aFirstCol + this._amountToMove;
            if (destLastColIndex < aLastCol) {
                return this.aptgSetFirstCol(aptg, newFirstColIx);
            }
            int areaRemainingTopColIx = this._lastMovedIndex + 1;
            if (destFirstColIndex > areaRemainingTopColIx) {
                newFirstColIx = areaRemainingTopColIx;
            }
            this.aptgSetLastCol(aptg, Math.max(aLastCol, destLastColIndex));
            return this.aptgSetFirstCol(aptg, newFirstColIx);
        }
        if (this._firstMovedIndex <= aLastCol && aLastCol <= this._lastMovedIndex) {
            if (this._amountToMove > 0) {
                this.aptgSetLastCol(aptg, aLastCol + this._amountToMove);
                return aptg;
            }
            if (destLastColIndex < aFirstCol) {
                return null;
            }
            int newLastColIx = aLastCol + this._amountToMove;
            if (destFirstColIndex > aFirstCol) {
                this.aptgSetLastCol(aptg, newLastColIx);
                return aptg;
            }
            int areaRemainingBottomColIx = this._firstMovedIndex - 1;
            if (destLastColIndex < areaRemainingBottomColIx) {
                newLastColIx = areaRemainingBottomColIx;
            }
            this.aptgSetLastCol(aptg, newLastColIx);
            return this.aptgSetFirstCol(aptg, Math.min(aFirstCol, destFirstColIndex));
        }
        if (destLastColIndex < aFirstCol || aLastCol < destFirstColIndex) {
            return null;
        }
        if (destFirstColIndex <= aFirstCol && aLastCol <= destLastColIndex) {
            return FormulaShifter.createDeletedRef(aptg);
        }
        if (aFirstCol <= destFirstColIndex && destLastColIndex <= aLastCol) {
            return null;
        }
        if (destFirstColIndex < aFirstCol && aFirstCol <= destLastColIndex) {
            return this.aptgSetFirstCol(aptg, destLastColIndex + 1);
        }
        if (destFirstColIndex < aLastCol && aLastCol <= destLastColIndex) {
            this.aptgSetLastCol(aptg, destFirstColIndex - 1);
            return aptg;
        }
        throw new IllegalStateException("Situation not covered: (" + this._firstMovedIndex + ", " + this._lastMovedIndex + ", " + this._amountToMove + ", " + aFirstCol + ", " + aLastCol + ")");
    }

    private Ptg rptgSetCol(RefPtgBase rptg, int colNum) {
        if (colNum > SpreadsheetVersion.EXCEL97.getLastColumnIndex()) {
            return FormulaShifter.createDeletedRef(rptg);
        }
        rptg.setColumn(colNum);
        return rptg;
    }

    private void aptgSetLastCol(AreaPtgBase aptg, int colNum) {
        if (colNum > SpreadsheetVersion.EXCEL97.getLastColumnIndex()) {
            aptg.setLastColumn(SpreadsheetVersion.EXCEL97.getLastColumnIndex());
        } else {
            aptg.setLastColumn(colNum);
        }
    }

    private Ptg aptgSetFirstCol(AreaPtgBase aptg, int colNum) {
        if (colNum > SpreadsheetVersion.EXCEL97.getLastColumnIndex()) {
            return FormulaShifter.createDeletedRef(aptg);
        }
        aptg.setFirstColumn(colNum);
        return aptg;
    }

    static enum ShiftMode {
        Row,
        Sheet;

    }
}

