/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula;

import java.io.Serializable;
import java.util.Arrays;
import org.zkoss.poi.ss.SpreadsheetVersion;
import org.zkoss.poi.ss.formula.ptg.Ptg;
import org.zkoss.poi.ss.util.CellReference;
import org.zkoss.poi.util.LittleEndian;
import org.zkoss.poi.util.LittleEndianByteArrayInputStream;
import org.zkoss.poi.util.LittleEndianInput;
import org.zkoss.poi.util.LittleEndianOutput;

public class Formula
implements Serializable {
    private static final Formula EMPTY = new Formula(new byte[0], 0);
    private final byte[] _byteEncoding;
    private final int _encodedTokenLen;

    private Formula(byte[] byteEncoding, int encodedTokenLen) {
        this._byteEncoding = byteEncoding;
        this._encodedTokenLen = encodedTokenLen;
    }

    public static Formula read(int encodedTokenLen, LittleEndianInput in) {
        return Formula.read(encodedTokenLen, in, encodedTokenLen);
    }

    public static Formula read(int encodedTokenLen, LittleEndianInput in, int totalEncodedLen) {
        byte[] byteEncoding = new byte[totalEncodedLen];
        in.readFully(byteEncoding);
        return new Formula(byteEncoding, encodedTokenLen);
    }

    public Ptg[] getTokens(SpreadsheetVersion version) {
        LittleEndianByteArrayInputStream in = new LittleEndianByteArrayInputStream(this._byteEncoding);
        return Ptg.readTokens(this._encodedTokenLen, in, version);
    }

    public Ptg[] getTokens() {
        return this.getTokens(SpreadsheetVersion.EXCEL97);
    }

    public void serialize(LittleEndianOutput out) {
        out.writeShort(this._encodedTokenLen);
        out.write(this._byteEncoding);
    }

    public void serializeTokens(LittleEndianOutput out) {
        out.write(this._byteEncoding, 0, this._encodedTokenLen);
    }

    public void serializeArrayConstantData(LittleEndianOutput out) {
        int len = this._byteEncoding.length - this._encodedTokenLen;
        out.write(this._byteEncoding, this._encodedTokenLen, len);
    }

    public int getEncodedSize() {
        return 2 + this._byteEncoding.length;
    }

    public int getEncodedTokenSize() {
        return this._encodedTokenLen;
    }

    public static Formula create(Ptg[] ptgs) {
        if (ptgs == null || ptgs.length < 1) {
            return EMPTY;
        }
        int totalSize = Ptg.getEncodedSize(ptgs);
        byte[] encodedData = new byte[totalSize];
        Ptg.serializePtgs(ptgs, encodedData, 0);
        int encodedTokenLen = Ptg.getEncodedSizeWithoutArrayData(ptgs);
        return new Formula(encodedData, encodedTokenLen);
    }

    public static Formula createX(Ptg[] ptgs) {
        if (ptgs == null || ptgs.length < 1) {
            return EMPTY;
        }
        int totalSize = Ptg.getEncodedSize(ptgs, SpreadsheetVersion.EXCEL2007);
        byte[] encodedData = new byte[totalSize];
        Ptg.serializePtgs(ptgs, encodedData, 0, SpreadsheetVersion.EXCEL2007);
        int encodedTokenLen = Ptg.getEncodedSizeWithoutArrayData(ptgs, SpreadsheetVersion.EXCEL2007);
        return new Formula(encodedData, encodedTokenLen);
    }

    public static Ptg[] getTokens(Formula formula) {
        return Formula.getTokens(formula, SpreadsheetVersion.EXCEL97);
    }

    public static Ptg[] getTokens(Formula formula, SpreadsheetVersion version) {
        if (formula == null) {
            return null;
        }
        return formula.getTokens(version);
    }

    public Formula copy() {
        return this;
    }

    public CellReference getExpReference() {
        byte[] data = this._byteEncoding;
        if (data.length != 5) {
            return null;
        }
        switch (data[0]) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                return null;
            }
        }
        int firstRow = LittleEndian.getUShort(data, 1);
        int firstColumn = LittleEndian.getUShort(data, 3);
        return new CellReference(firstRow, firstColumn);
    }

    public boolean isSame(Formula other) {
        return Arrays.equals(this._byteEncoding, other._byteEncoding);
    }
}

