/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.format;

import java.util.Locale;
import java.util.regex.Matcher;
import org.zkoss.poi.ss.format.CellFormatPart;
import org.zkoss.poi.ss.format.CellFormatType;
import org.zkoss.poi.ss.format.CellFormatter;
import org.zkoss.util.Pair;

public class CellTextFormatter
extends CellFormatter {
    private final int[] textPos;
    private final String desc;

    static CellFormatter getFormatter(FormatterType ft, Locale locale) {
        Pair key = new Pair((Object)ft, (Object)locale);
        CellFormatter formatter = (CellFormatter)_formatters.get((Object)key);
        if (formatter != null) {
            return formatter;
        }
        switch (ft) {
            case SIMPLE_TEXT: {
                formatter = new CellTextFormatter("@", locale);
            }
        }
        _formatters.put((Object)key, (Object)formatter);
        return formatter;
    }

    public CellTextFormatter(String format, Locale locale) {
        super(format, locale);
        final int[] numPlaces = new int[1];
        this.desc = CellFormatPart.parseFormat(format, CellFormatType.TEXT, new CellFormatPart.PartHandler(){

            @Override
            public String handlePart(Matcher m, String part, CellFormatType type, StringBuffer desc) {
                if (part.equals("@")) {
                    numPlaces[0] = numPlaces[0] + 1;
                    return "\u0000";
                }
                return null;
            }
        }).toString();
        this.textPos = new int[numPlaces[0]];
        int pos = this.desc.length() - 1;
        for (int i = 0; i < this.textPos.length; ++i) {
            this.textPos[i] = this.desc.lastIndexOf("\u0000", pos);
            pos = this.textPos[i] - 1;
        }
    }

    @Override
    public void formatValue(StringBuffer toAppendTo, Object obj) {
        int start = toAppendTo.length();
        String text = obj.toString();
        if (obj instanceof Boolean) {
            text = text.toUpperCase();
        }
        if (!this.sectionFourTextFormat && obj instanceof String && this.textPos.length == 0) {
            toAppendTo.append(text);
        } else {
            toAppendTo.append(this.desc);
            for (int i = 0; i < this.textPos.length; ++i) {
                int pos = start + this.textPos[i];
                toAppendTo.replace(pos, pos + 1, text);
            }
        }
    }

    @Override
    public void simpleValue(StringBuffer toAppendTo, Object value) {
        CellTextFormatter.getFormatter(FormatterType.SIMPLE_TEXT, this.locale).formatValue(toAppendTo, value);
    }

    static enum FormatterType {
        SIMPLE_TEXT;

    }
}

