/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.usermodel;

import java.util.List;
import java.util.Map;
import org.zkoss.poi.ddf.EscherClientDataRecord;
import org.zkoss.poi.ddf.EscherContainerRecord;
import org.zkoss.poi.ddf.EscherOptRecord;
import org.zkoss.poi.ddf.EscherRecord;
import org.zkoss.poi.hssf.record.CommonObjectDataSubRecord;
import org.zkoss.poi.hssf.record.EmbeddedObjectRefSubRecord;
import org.zkoss.poi.hssf.record.EscherAggregate;
import org.zkoss.poi.hssf.record.ObjRecord;
import org.zkoss.poi.hssf.record.Record;
import org.zkoss.poi.hssf.record.SubRecord;
import org.zkoss.poi.hssf.record.TextObjectRecord;
import org.zkoss.poi.hssf.usermodel.HSSFChartShape;
import org.zkoss.poi.hssf.usermodel.HSSFCombobox;
import org.zkoss.poi.hssf.usermodel.HSSFComment;
import org.zkoss.poi.hssf.usermodel.HSSFObjectData;
import org.zkoss.poi.hssf.usermodel.HSSFPicture;
import org.zkoss.poi.hssf.usermodel.HSSFPolygon;
import org.zkoss.poi.hssf.usermodel.HSSFShapeContainer;
import org.zkoss.poi.hssf.usermodel.HSSFShapeGroup;
import org.zkoss.poi.hssf.usermodel.HSSFSimpleShape;
import org.zkoss.poi.hssf.usermodel.HSSFTextbox;
import org.zkoss.poi.poifs.filesystem.DirectoryNode;

public class HSSFShapeFactory {
    private static final short OBJECT_TYPE_LINE = 1;
    private static final short OBJECT_TYPE_RECTANGLE = 2;
    private static final short OBJECT_TYPE_OVAL = 3;
    private static final short OBJECT_TYPE_ARC = 4;
    private static final short OBJECT_TYPE_PICTURE = 8;

    public static void createShapeTree(EscherContainerRecord container, EscherAggregate agg, HSSFShapeContainer out, DirectoryNode root) {
        if (container.getRecordId() == -4093) {
            ObjRecord obj = null;
            EscherClientDataRecord clientData = (EscherClientDataRecord)((EscherContainerRecord)container.getChild(0)).getChildById((short)-4079);
            if (null != clientData) {
                obj = (ObjRecord)agg.getShapeToObjMapping().get(clientData);
            }
            HSSFShapeGroup group = new HSSFShapeGroup(container, obj);
            List<EscherContainerRecord> children = container.getChildContainers();
            for (int i = 0; i < children.size(); ++i) {
                EscherContainerRecord spContainer = children.get(i);
                if (i == 0) continue;
                HSSFShapeFactory.createShapeTree(spContainer, agg, group, root);
            }
            out.addShape(group);
        } else if (container.getRecordId() == -4092) {
            HSSFSimpleShape shape;
            Map<EscherRecord, Record> shapeToObj = agg.getShapeToObjMapping();
            ObjRecord objRecord = null;
            TextObjectRecord txtRecord = null;
            for (EscherRecord record : container.getChildRecords()) {
                switch (record.getRecordId()) {
                    case -4079: {
                        objRecord = (ObjRecord)shapeToObj.get(record);
                        break;
                    }
                    case -4083: {
                        txtRecord = (TextObjectRecord)shapeToObj.get(record);
                    }
                }
            }
            if (HSSFShapeFactory.isEmbeddedObject(objRecord)) {
                HSSFObjectData objectData = new HSSFObjectData(container, objRecord, root);
                out.addShape(objectData);
                return;
            }
            CommonObjectDataSubRecord cmo = (CommonObjectDataSubRecord)objRecord.getSubRecords().get(0);
            switch (cmo.getObjectType()) {
                case 8: {
                    shape = new HSSFPicture(container, objRecord);
                    break;
                }
                case 2: {
                    shape = new HSSFSimpleShape(container, objRecord, txtRecord);
                    break;
                }
                case 1: {
                    shape = new HSSFSimpleShape(container, objRecord);
                    break;
                }
                case 20: {
                    shape = new HSSFCombobox(container, objRecord);
                    break;
                }
                case 30: {
                    EscherOptRecord optRecord = (EscherOptRecord)container.getChildById((short)-4085);
                    Object property = optRecord.lookup(325);
                    if (null != property) {
                        shape = new HSSFPolygon(container, objRecord, txtRecord);
                        break;
                    }
                    shape = new HSSFSimpleShape(container, objRecord, txtRecord);
                    break;
                }
                case 6: {
                    shape = new HSSFTextbox(container, objRecord, txtRecord);
                    break;
                }
                case 25: {
                    shape = new HSSFComment(container, objRecord, txtRecord, agg.getNoteRecordByObj(objRecord));
                    break;
                }
                case 5: {
                    shape = new HSSFChartShape(container, objRecord, agg.getObjToChartBofMapping().get(objRecord));
                    break;
                }
                default: {
                    shape = new HSSFSimpleShape(container, objRecord, txtRecord);
                }
            }
            out.addShape(shape);
        }
    }

    private static boolean isEmbeddedObject(ObjRecord obj) {
        for (SubRecord sub : obj.getSubRecords()) {
            if (!(sub instanceof EmbeddedObjectRefSubRecord)) continue;
            return true;
        }
        return false;
    }
}

