/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.usermodel;

import org.zkoss.poi.hssf.model.InternalWorkbook;
import org.zkoss.poi.hssf.record.ExtendedFormatRecord;
import org.zkoss.poi.hssf.record.FontRecord;
import org.zkoss.poi.hssf.record.FullColorExt;
import org.zkoss.poi.hssf.record.StyleRecord;
import org.zkoss.poi.hssf.record.XFExtRecord;
import org.zkoss.poi.hssf.usermodel.HSSFDataFormat;
import org.zkoss.poi.hssf.usermodel.HSSFFont;
import org.zkoss.poi.hssf.usermodel.HSSFPalette;
import org.zkoss.poi.hssf.usermodel.HSSFWorkbook;
import org.zkoss.poi.hssf.util.HSSFColor;
import org.zkoss.poi.hssf.util.HSSFColorExt;
import org.zkoss.poi.ss.usermodel.CellStyle;
import org.zkoss.poi.ss.usermodel.Color;
import org.zkoss.poi.ss.usermodel.Font;
import org.zkoss.poi.ss.usermodel.Workbook;

public final class HSSFCellStyle
implements CellStyle {
    private ExtendedFormatRecord _format = null;
    private short _index = 0;
    private InternalWorkbook _workbook = null;
    private XFExtRecord _xfext;

    protected HSSFCellStyle(short index, ExtendedFormatRecord rec, HSSFWorkbook workbook) {
        this(index, rec, workbook.getWorkbook());
    }

    protected HSSFCellStyle(short index, ExtendedFormatRecord rec, InternalWorkbook workbook) {
        this._workbook = workbook;
        this._index = index;
        this._format = rec;
    }

    @Override
    public int getIndex() {
        return this._index;
    }

    public HSSFCellStyle getParentStyle() {
        short parentIndex = this._format.getParentIndex();
        if (parentIndex == 0 || parentIndex == 4095) {
            return null;
        }
        return new HSSFCellStyle(parentIndex, this._workbook.getExFormatAt(parentIndex), this._workbook);
    }

    @Override
    public void setDataFormat(short fmt) {
        this._format.setFormatIndex(fmt);
    }

    @Override
    public short getDataFormat() {
        return this._format.getFormatIndex();
    }

    @Override
    public String getDataFormatString() {
        return this.getDataFormatString(this._workbook);
    }

    @Override
    public String getRawDataFormatString() {
        HSSFDataFormat format = new HSSFDataFormat(this._workbook);
        return format.getRawFormat(this.getDataFormat());
    }

    @Override
    public boolean isBuiltinDataFormat() {
        HSSFDataFormat format = new HSSFDataFormat(this._workbook);
        return format.isBuiltinFormat(this.getDataFormat());
    }

    public String getDataFormatString(Workbook workbook) {
        HSSFDataFormat format = new HSSFDataFormat(((HSSFWorkbook)workbook).getWorkbook());
        short idx = this.getDataFormat();
        return idx == -1 ? "General" : format.getFormat(this.getDataFormat());
    }

    public String getDataFormatString(InternalWorkbook workbook) {
        HSSFDataFormat format = new HSSFDataFormat(workbook);
        return format.getFormat(this.getDataFormat());
    }

    @Override
    public void setFont(Font font) {
        this.setFont((HSSFFont)font);
    }

    public void setFont(HSSFFont font) {
        this._format.setIndentNotParentFont(true);
        short fontindex = font.getIndex();
        this._format.setFontIndex(fontindex);
    }

    @Override
    public short getFontIndex() {
        return this._format.getFontIndex();
    }

    public HSSFFont getFont(Workbook parentWorkbook) {
        return ((HSSFWorkbook)parentWorkbook).getFontAt(this.getFontIndex());
    }

    @Override
    public void setHidden(boolean hidden) {
        this._format.setIndentNotParentCellOptions(true);
        this._format.setHidden(hidden);
    }

    @Override
    public boolean getHidden() {
        return this._format.isHidden();
    }

    @Override
    public void setLocked(boolean locked) {
        this._format.setIndentNotParentCellOptions(true);
        this._format.setLocked(locked);
    }

    @Override
    public boolean getLocked() {
        return this._format.isLocked();
    }

    @Override
    public void setAlignment(short align) {
        this._format.setIndentNotParentAlignment(true);
        this._format.setAlignment(align);
    }

    @Override
    public short getAlignment() {
        return this._format.getAlignment();
    }

    @Override
    public void setWrapText(boolean wrapped) {
        this._format.setIndentNotParentAlignment(true);
        this._format.setWrapText(wrapped);
    }

    @Override
    public boolean getWrapText() {
        return this._format.getWrapText();
    }

    @Override
    public void setVerticalAlignment(short align) {
        this._format.setVerticalAlignment(align);
    }

    @Override
    public short getVerticalAlignment() {
        return this._format.getVerticalAlignment();
    }

    @Override
    public void setRotation(short rotation) {
        if (rotation != 255) {
            if (rotation < 0 && rotation >= -90) {
                rotation = (short)(90 - rotation);
            } else if (rotation < -90 || rotation > 90) {
                throw new IllegalArgumentException("The rotation must be between -90 and 90 degrees, or 0xff");
            }
        }
        this._format.setRotation(rotation);
    }

    @Override
    public short getRotation() {
        short rotation = this._format.getRotation();
        if (rotation == 255) {
            return rotation;
        }
        if (rotation > 90) {
            rotation = (short)(90 - rotation);
        }
        return rotation;
    }

    @Override
    public void setIndention(short indent) {
        this._format.setIndent(indent);
    }

    @Override
    public short getIndention() {
        return this._format.getIndent();
    }

    @Override
    public void setBorderLeft(short border) {
        this._format.setIndentNotParentBorder(true);
        this._format.setBorderLeft(border);
    }

    @Override
    public short getBorderLeft() {
        return this._format.getBorderLeft();
    }

    @Override
    public void setBorderRight(short border) {
        this._format.setIndentNotParentBorder(true);
        this._format.setBorderRight(border);
    }

    @Override
    public short getBorderRight() {
        return this._format.getBorderRight();
    }

    @Override
    public void setBorderTop(short border) {
        this._format.setIndentNotParentBorder(true);
        this._format.setBorderTop(border);
    }

    @Override
    public short getBorderTop() {
        return this._format.getBorderTop();
    }

    @Override
    public void setBorderBottom(short border) {
        this._format.setIndentNotParentBorder(true);
        this._format.setBorderBottom(border);
    }

    @Override
    public short getBorderBottom() {
        return this._format.getBorderBottom();
    }

    @Override
    public void setLeftBorderColor(short color) {
        this._format.setLeftBorderPaletteIdx(color);
    }

    @Override
    public short getLeftBorderColor() {
        return this._format.getLeftBorderPaletteIdx();
    }

    @Override
    public void setRightBorderColor(short color) {
        this._format.setRightBorderPaletteIdx(color);
    }

    @Override
    public short getRightBorderColor() {
        return this._format.getRightBorderPaletteIdx();
    }

    @Override
    public void setTopBorderColor(short color) {
        this._format.setTopBorderPaletteIdx(color);
    }

    @Override
    public short getTopBorderColor() {
        return this._format.getTopBorderPaletteIdx();
    }

    @Override
    public void setBottomBorderColor(short color) {
        this._format.setBottomBorderPaletteIdx(color);
    }

    @Override
    public short getBottomBorderColor() {
        return this._format.getBottomBorderPaletteIdx();
    }

    @Override
    public void setFillPattern(short fp) {
        this._format.setAdtlFillPattern(fp);
    }

    @Override
    public short getFillPattern() {
        return this._format.getAdtlFillPattern();
    }

    private void checkDefaultBackgroundFills() {
        if (this._format.getFillForeground() == 64) {
            if (this._format.getFillBackground() != 65) {
                this.setFillBackgroundColor((short)65);
            }
        } else if (this._format.getFillBackground() == 65 && this._format.getFillForeground() != 64) {
            this.setFillBackgroundColor((short)64);
        }
    }

    @Override
    public void setFillBackgroundColor(short bg) {
        this._format.setFillBackground(bg);
        this.checkDefaultBackgroundFills();
    }

    @Override
    public short getFillBackgroundColor() {
        short result = this._format.getFillBackground();
        if (result == 65) {
            return 64;
        }
        return result;
    }

    @Override
    public HSSFColor getFillBackgroundColorColor() {
        FullColorExt colorExt;
        XFExtRecord xfExt = this.getXFExt();
        FullColorExt fullColorExt = colorExt = xfExt == null ? null : xfExt.getFillBackgroundColor();
        if (colorExt == null || colorExt.isIndex()) {
            HSSFPalette pallette = new HSSFPalette(this._workbook.getCustomPalette());
            return pallette.getColor(this.getFillBackgroundColor());
        }
        return new HSSFColorExt(colorExt);
    }

    @Override
    public void setFillForegroundColor(short bg) {
        this._format.setFillForeground(bg);
        this.checkDefaultBackgroundFills();
    }

    @Override
    public short getFillForegroundColor() {
        return this._format.getFillForeground();
    }

    @Override
    public HSSFColor getFillForegroundColorColor() {
        FullColorExt colorExt;
        XFExtRecord xfExt = this.getXFExt();
        FullColorExt fullColorExt = colorExt = xfExt == null ? null : xfExt.getFillForegroundColor();
        if (colorExt == null || colorExt.isIndex()) {
            HSSFPalette pallette = new HSSFPalette(this._workbook.getCustomPalette());
            return pallette.getColor(this.getFillForegroundColor());
        }
        return new HSSFColorExt(colorExt);
    }

    public String getUserStyleName() {
        StyleRecord sr = this._workbook.getStyleRecord(this._index);
        if (sr == null) {
            return null;
        }
        if (sr.isBuiltin()) {
            return null;
        }
        return sr.getName();
    }

    public void setUserStyleName(String styleName) {
        StyleRecord sr = this._workbook.getStyleRecord(this._index);
        if (sr == null) {
            sr = this._workbook.createStyleRecord(this._index);
        }
        if (sr.isBuiltin() && this._index <= 20) {
            throw new IllegalArgumentException("Unable to set user specified style names for built in styles!");
        }
        sr.setName(styleName);
    }

    public void verifyBelongsToWorkbook(HSSFWorkbook wb) {
        if (wb.getWorkbook() != this._workbook) {
            throw new IllegalArgumentException("This Style does not belong to the supplied Workbook. Are you trying to assign a style from one workbook to the cell of a differnt workbook?");
        }
    }

    @Override
    public void cloneStyleFrom(CellStyle source) {
        if (!(source instanceof HSSFCellStyle)) {
            throw new IllegalArgumentException("Can only clone from one HSSFCellStyle to another, not between HSSFCellStyle and XSSFCellStyle");
        }
        this.cloneStyleFrom((HSSFCellStyle)source);
    }

    public void cloneStyleFrom(HSSFCellStyle source) {
        this._format.cloneStyleFrom(source._format);
        XFExtRecord extRecord = source._workbook.getXFExtAt(source._index);
        if (extRecord != null) {
            XFExtRecord target = this._workbook.getXFExtAt(this._index);
            if (target == null) {
                target = this._workbook.createCellXFExt(this._index);
            }
            target.cloneXFExtFrom(extRecord);
        }
        if (this._workbook != source._workbook) {
            short fmt = (short)this._workbook.createFormat(source.getDataFormatString());
            this.setDataFormat(fmt);
            FontRecord fr = this._workbook.createNewFont();
            fr.cloneStyleFrom(source._workbook.getFontRecordAt(source.getFontIndex()));
            HSSFFont font = new HSSFFont((short)this._workbook.getFontIndex(fr), fr);
            this.setFont(font);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._format == null ? 0 : this._format.hashCode());
        result = 31 * result + this._index;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof HSSFCellStyle) {
            HSSFCellStyle other = (HSSFCellStyle)obj;
            if (this._format == null ? other._format != null : !this._format.equals(other._format)) {
                return false;
            }
            return this._index == other._index;
        }
        return false;
    }

    @Override
    public HSSFColor getLeftBorderColorColor() {
        FullColorExt colorExt;
        XFExtRecord xfExt = this.getXFExt();
        FullColorExt fullColorExt = colorExt = xfExt == null ? null : xfExt.getLeftBorderColor();
        if (colorExt == null || colorExt.isIndex()) {
            HSSFPalette pallette = new HSSFPalette(this._workbook.getCustomPalette());
            return pallette.getColor(this.getLeftBorderColor());
        }
        return new HSSFColorExt(colorExt);
    }

    @Override
    public HSSFColor getRightBorderColorColor() {
        FullColorExt colorExt;
        XFExtRecord xfExt = this.getXFExt();
        FullColorExt fullColorExt = colorExt = xfExt == null ? null : xfExt.getRightBorderColor();
        if (colorExt == null || colorExt.isIndex()) {
            HSSFPalette pallette = new HSSFPalette(this._workbook.getCustomPalette());
            return pallette.getColor(this.getRightBorderColor());
        }
        return new HSSFColorExt(colorExt);
    }

    @Override
    public HSSFColor getTopBorderColorColor() {
        FullColorExt colorExt;
        XFExtRecord xfExt = this.getXFExt();
        FullColorExt fullColorExt = colorExt = xfExt == null ? null : xfExt.getTopBorderColor();
        if (colorExt == null || colorExt.isIndex()) {
            HSSFPalette pallette = new HSSFPalette(this._workbook.getCustomPalette());
            return pallette.getColor(this.getTopBorderColor());
        }
        return new HSSFColorExt(colorExt);
    }

    @Override
    public HSSFColor getBottomBorderColorColor() {
        FullColorExt colorExt;
        XFExtRecord xfExt = this.getXFExt();
        FullColorExt fullColorExt = colorExt = xfExt == null ? null : xfExt.getBottomBorderColor();
        if (colorExt == null || colorExt.isIndex()) {
            HSSFPalette pallette = new HSSFPalette(this._workbook.getCustomPalette());
            return pallette.getColor(this.getBottomBorderColor());
        }
        return new HSSFColorExt(colorExt);
    }

    public void setFillForegroundColor(HSSFColor color) {
        XFExtRecord ext = this.getXFExt();
        if (ext != null && !(color instanceof HSSFColorExt)) {
            short[] rgb = color.getTriplet();
            color = new HSSFColorExt(new FullColorExt(rgb[0], rgb[1], rgb[2]));
        }
        if (color instanceof HSSFColorExt) {
            this.getOrCreateXFExt().setFillForegroundColor(((HSSFColorExt)color).getFullColorExt());
            color = ((HSSFColorExt)color).getSimilarColor(new HSSFPalette(this._workbook.getCustomPalette()));
        }
        this.setFillForegroundColor(color.getIndex());
    }

    public void setFillBackgroundColor(HSSFColor color) {
        XFExtRecord ext = this.getXFExt();
        if (ext != null && !(color instanceof HSSFColorExt)) {
            short[] rgb = color.getTriplet();
            color = new HSSFColorExt(new FullColorExt(rgb[0], rgb[1], rgb[2]));
        }
        if (color instanceof HSSFColorExt) {
            this.getOrCreateXFExt().setFillBackgroundColor(((HSSFColorExt)color).getFullColorExt());
            color = ((HSSFColorExt)color).getSimilarColor(new HSSFPalette(this._workbook.getCustomPalette()));
        }
        this.setFillBackgroundColor(color.getIndex());
    }

    public HSSFColor getFontColorColor() {
        FullColorExt colorExt;
        XFExtRecord xfExt = this.getXFExt();
        FullColorExt fullColorExt = colorExt = xfExt == null ? null : xfExt.getTextColor();
        if (colorExt == null || colorExt.isIndex()) {
            FontRecord frec = this._workbook.getFontRecordAt(this.getFontIndex());
            short fontColor = frec.getColorPaletteIndex();
            HSSFPalette pallette = new HSSFPalette(this._workbook.getCustomPalette());
            return pallette.getColor(fontColor);
        }
        return new HSSFColorExt(colorExt);
    }

    @Override
    public void setFontColorColor(Color color) {
        this.setFontColorColor((HSSFColor)color);
    }

    private void setFontColorColor(HSSFColor color) {
        XFExtRecord ext = this.getXFExt();
        if (ext != null && !(color instanceof HSSFColorExt)) {
            short[] rgb = color.getTriplet();
            color = new HSSFColorExt(new FullColorExt(rgb[0], rgb[1], rgb[2]));
        }
        if (color instanceof HSSFColorExt) {
            this.getOrCreateXFExt().setTextColor(((HSSFColorExt)color).getFullColorExt());
            color = ((HSSFColorExt)color).getSimilarColor(new HSSFPalette(this._workbook.getCustomPalette()));
        }
        FontRecord frec = this._workbook.getFontRecordAt(this.getFontIndex());
        frec.setColorPaletteIndex(color.getIndex());
    }

    public void setTopBorderColor(HSSFColor color) {
        XFExtRecord ext = this.getXFExt();
        if (ext != null && !(color instanceof HSSFColorExt)) {
            short[] rgb = color.getTriplet();
            color = new HSSFColorExt(new FullColorExt(rgb[0], rgb[1], rgb[2]));
        }
        if (color instanceof HSSFColorExt) {
            this.getOrCreateXFExt().setTopBorderColor(((HSSFColorExt)color).getFullColorExt());
            color = ((HSSFColorExt)color).getSimilarColor(new HSSFPalette(this._workbook.getCustomPalette()));
        }
        this.setTopBorderColor(color.getIndex());
    }

    public void setBottomBorderColor(HSSFColor color) {
        XFExtRecord ext = this.getXFExt();
        if (ext != null && !(color instanceof HSSFColorExt)) {
            short[] rgb = color.getTriplet();
            color = new HSSFColorExt(new FullColorExt(rgb[0], rgb[1], rgb[2]));
        }
        if (color instanceof HSSFColorExt) {
            this.getOrCreateXFExt().setBottomBorderColor(((HSSFColorExt)color).getFullColorExt());
            color = ((HSSFColorExt)color).getSimilarColor(new HSSFPalette(this._workbook.getCustomPalette()));
        }
        this.setBottomBorderColor(color.getIndex());
    }

    public void setRightBorderColor(HSSFColor color) {
        XFExtRecord ext = this.getXFExt();
        if (ext != null && !(color instanceof HSSFColorExt)) {
            short[] rgb = color.getTriplet();
            color = new HSSFColorExt(new FullColorExt(rgb[0], rgb[1], rgb[2]));
        }
        if (color instanceof HSSFColorExt) {
            this.getOrCreateXFExt().setRightBorderColor(((HSSFColorExt)color).getFullColorExt());
            color = ((HSSFColorExt)color).getSimilarColor(new HSSFPalette(this._workbook.getCustomPalette()));
        }
        this.setRightBorderColor(color.getIndex());
    }

    public void setLeftBorderColor(HSSFColor color) {
        XFExtRecord ext = this.getXFExt();
        if (ext != null && !(color instanceof HSSFColorExt)) {
            short[] rgb = color.getTriplet();
            color = new HSSFColorExt(new FullColorExt(rgb[0], rgb[1], rgb[2]));
        }
        if (color instanceof HSSFColorExt) {
            this.getOrCreateXFExt().setLeftBorderColor(((HSSFColorExt)color).getFullColorExt());
            color = ((HSSFColorExt)color).getSimilarColor(new HSSFPalette(this._workbook.getCustomPalette()));
        }
        this.setLeftBorderColor(color.getIndex());
    }

    private XFExtRecord getXFExt() {
        if (this._xfext == null) {
            this._xfext = this._workbook.getXFExtAt(this._index);
        }
        return this._xfext;
    }

    private XFExtRecord getOrCreateXFExt() {
        XFExtRecord xfExt = this.getXFExt();
        if (xfExt == null) {
            this._xfext = this._workbook.createCellXFExt(this._index);
        }
        return this._xfext;
    }

    @Override
    public void setBorder(short left, Color leftColor, short top, Color topColor, short right, Color rightColor, short bottom, Color bottomColor) {
        this.setBorderRight(right);
        this.setBorderLeft(left);
        this.setBorderTop(top);
        this.setBorderBottom(bottom);
        this.setBottomBorderColor((HSSFColor)bottomColor);
        this.setTopBorderColor((HSSFColor)topColor);
        this.setRightBorderColor((HSSFColor)rightColor);
        this.setLeftBorderColor((HSSFColor)leftColor);
    }

    @Override
    public void setFill(Color fillColor, Color backColor, short pattern) {
        this.setFillForegroundColor((HSSFColor)fillColor);
        this.setFillBackgroundColor((HSSFColor)backColor);
        this.setFillPattern(pattern);
    }

    @Override
    @Deprecated
    public void setCellAlignment(short hAlign, short vAlign, boolean wrapText) {
        this.setCellAlignment(hAlign, vAlign, wrapText, (short)0);
    }

    @Override
    public void setCellAlignment(short hAlign, short vAlign, boolean wrapText, short rotation) {
        this.setAlignment(hAlign);
        this.setVerticalAlignment(vAlign);
        this.setWrapText(wrapText);
        this.setRotation(rotation);
    }

    @Override
    public void setProtection(boolean locked, boolean hidden) {
        this.setLocked(locked);
        this.setHidden(hidden);
    }

    @Override
    public void setBorder(short left, Color leftColor, short top, Color topColor, short right, Color rightColor, short bottom, Color bottomColor, short diagonal, Color diagonalColor, short horizontal, Color horizontalColor, short vertical, Color verticalColor, boolean diaUp, boolean diaDown) {
        this.setBorderRight(right);
        this.setBorderLeft(left);
        this.setBorderTop(top);
        this.setBorderBottom(bottom);
        this.setBorderDiagonal(diagonal);
        this.setBottomBorderColor((HSSFColor)bottomColor);
        this.setTopBorderColor((HSSFColor)topColor);
        this.setRightBorderColor((HSSFColor)rightColor);
        this.setLeftBorderColor((HSSFColor)leftColor);
        this.setDiagonalBorderColor((HSSFColor)diagonalColor);
    }

    @Override
    public void setBorderDiagonal(short border) {
        this._format.setIndentNotParentBorder(true);
        this._format.setAdtlDiagLineStyle(border);
    }

    @Override
    public short getBorderDiagonal() {
        return this._format.getAdtlDiagLineStyle();
    }

    @Override
    public Color getDiagonalBorderColorColor() {
        FullColorExt colorExt;
        XFExtRecord xfExt = this.getXFExt();
        FullColorExt fullColorExt = colorExt = xfExt == null ? null : xfExt.getDiagonalBorderColor();
        if (colorExt == null || colorExt.isIndex()) {
            HSSFPalette pallette = new HSSFPalette(this._workbook.getCustomPalette());
            return pallette.getColor(this.getDiagonalBorderColor());
        }
        return new HSSFColorExt(colorExt);
    }

    @Override
    public void setDiagonalBorderColor(short color) {
        this._format.setAdtlDiag(color);
    }

    @Override
    public short getDiagonalBorderColor() {
        return this._format.getAdtlDiag();
    }

    @Override
    public boolean isShowDiagonalUpBorder() {
        return (this._format.getDiag() & 2) != 0;
    }

    @Override
    public void setShowDiagonalUpBorder(boolean up) {
        int diag = this._format.getDiag();
        diag = up ? diag | 2 : diag & 1;
        this._format.setDiag((short)diag);
    }

    @Override
    public boolean isShowDiagonalDownBorder() {
        return (this._format.getDiag() & 1) != 0;
    }

    @Override
    public void setShowDiagonalDownBorder(boolean up) {
        int diag = this._format.getDiag();
        diag = up ? diag | 1 : diag & 2;
        this._format.setDiag((short)diag);
    }

    public void setDiagonalBorderColor(HSSFColor color) {
        XFExtRecord ext = this.getXFExt();
        if (ext != null && !(color instanceof HSSFColorExt)) {
            short[] rgb = color.getTriplet();
            color = new HSSFColorExt(new FullColorExt(rgb[0], rgb[1], rgb[2]));
        }
        if (color instanceof HSSFColorExt) {
            this.getOrCreateXFExt().setDiagonalBorderColor(((HSSFColorExt)color).getFullColorExt());
            color = ((HSSFColorExt)color).getSimilarColor(new HSSFPalette(this._workbook.getCustomPalette()));
        }
        this.setDiagonalBorderColor(color.getIndex());
    }
}

