/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record.common;

import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.util.HexDump;
import org.zkoss.poi.util.LittleEndianOutput;

public class BuiltInStyle {
    private byte istyBuiltIn;
    private byte iLevel;

    public BuiltInStyle(RecordInputStream in) {
        this.istyBuiltIn = in.readByte();
        this.iLevel = in.readByte();
    }

    public BuiltInStyle(int type, int level) {
        this.istyBuiltIn = (byte)type;
        this.iLevel = (byte)level;
    }

    public int getBuiltInType() {
        return this.istyBuiltIn & 0xFF;
    }

    public void setBuiltInType(int type) {
        this.istyBuiltIn = (byte)type;
    }

    public int getOutlineLevel() {
        return this.iLevel & 0xFF;
    }

    public void setOutlineLevel(int outlineLevel) {
        this.iLevel = (byte)outlineLevel;
    }

    public void serialize(LittleEndianOutput out) {
        out.writeByte(this.istyBuiltIn);
        out.writeByte(this.iLevel);
    }

    public int getDataSize() {
        return 2;
    }

    public void appendString(StringBuffer sb, String prefix) {
        sb.append(prefix).append("[BUILTINSTYLE]").append("\n");
        sb.append(prefix).append("    .istyBuiltIn = ").append(HexDump.byteToHex(this.istyBuiltIn)).append("\n");
        sb.append(prefix).append("    .iLevel      = ").append(HexDump.byteToHex(this.iLevel)).append("\n");
        sb.append(prefix).append("[/BUILTINSTYLE]").append("\n");
    }
}

