/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record.chart;

import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.StandardRecord;
import org.zkoss.poi.util.BitField;
import org.zkoss.poi.util.BitFieldFactory;
import org.zkoss.poi.util.HexDump;
import org.zkoss.poi.util.LittleEndianOutput;

public final class PieRecord
extends StandardRecord {
    public static final short sid = 4121;
    private short field_1_anStart;
    private short field_2_pcDonut;
    private short field_3_formatFlags;
    private static final BitField shadow = BitFieldFactory.getInstance(1);
    private static final BitField leaderLines = BitFieldFactory.getInstance(2);

    public PieRecord() {
    }

    public PieRecord(RecordInputStream in) {
        this.field_1_anStart = in.readShort();
        this.field_2_pcDonut = in.readShort();
        this.field_3_formatFlags = in.readShort();
    }

    @Override
    protected int getDataSize() {
        return 6;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[PIE]\n");
        buffer.append("    .anStart        = ").append("0x").append(HexDump.toHex(this.field_1_anStart)).append(" (").append(this.field_1_anStart).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .pcDonut        = ").append("0x").append(HexDump.toHex(this.field_2_pcDonut)).append(" (").append(this.field_2_pcDonut).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .formatFlags    = ").append("0x").append(HexDump.toHex(this.field_3_formatFlags)).append(" (").append(this.field_3_formatFlags).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("         .shadow                   = ").append(this.isShadow()).append('\n');
        buffer.append("         .showLdrLines             = ").append(this.isShowLdrLines()).append('\n');
        buffer.append("[/PIE]\n");
        return buffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.field_1_anStart);
        out.writeShort(this.field_2_pcDonut);
        out.writeShort(this.field_3_formatFlags);
    }

    @Override
    public short getSid() {
        return 4121;
    }

    @Override
    public Object clone() {
        PieRecord rec = new PieRecord();
        rec.field_1_anStart = this.field_1_anStart;
        rec.field_2_pcDonut = this.field_2_pcDonut;
        rec.field_3_formatFlags = this.field_3_formatFlags;
        return rec;
    }

    public short getFormatFlags() {
        return this.field_3_formatFlags;
    }

    public void setFormatFlags(short field_3_formatFlags) {
        this.field_3_formatFlags = field_3_formatFlags;
    }

    public short getAnStart() {
        return this.field_1_anStart;
    }

    public void setAnStart(short field_1_anStart) {
        this.field_1_anStart = field_1_anStart;
    }

    public short getPcDonut() {
        return this.field_2_pcDonut;
    }

    public void setPcDonut(short field_2_pcDonut) {
        this.field_2_pcDonut = field_2_pcDonut;
    }

    public void setShowLdrLines(boolean value) {
        this.field_3_formatFlags = leaderLines.setShortBoolean(this.field_3_formatFlags, value);
    }

    public boolean isShowLdrLines() {
        return leaderLines.isSet(this.field_3_formatFlags);
    }

    public void setShadow(boolean value) {
        this.field_3_formatFlags = shadow.setShortBoolean(this.field_3_formatFlags, value);
    }

    public boolean isShadow() {
        return shadow.isSet(this.field_3_formatFlags);
    }
}

