/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record.chart;

import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.StandardRecord;
import org.zkoss.poi.util.HexDump;
import org.zkoss.poi.util.LittleEndianOutput;

public final class Chart3DBarShapeRecord
extends StandardRecord {
    public static final short sid = 4191;
    private short field_1_riser;
    private short field_2_taper;

    public Chart3DBarShapeRecord() {
    }

    public Chart3DBarShapeRecord(RecordInputStream in) {
        this.field_1_riser = in.readByte();
        this.field_2_taper = in.readByte();
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[CHART3DBARSHAPE]\n");
        buffer.append("    .riser             = ").append("0x").append(HexDump.toHex(this.getRiser())).append(" (").append(this.getRiser()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .taper             = ").append("0x").append(HexDump.toHex(this.getTaper())).append(" (").append(this.getTaper()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/CHART3DBARSHAPE]\n");
        return buffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        out.writeByte(this.field_1_riser);
        out.writeByte(this.field_2_taper);
    }

    @Override
    protected int getDataSize() {
        return 2;
    }

    @Override
    public short getSid() {
        return 4191;
    }

    @Override
    public Object clone() {
        Chart3DBarShapeRecord rec = new Chart3DBarShapeRecord();
        rec.field_1_riser = this.field_1_riser;
        rec.field_2_taper = this.field_2_taper;
        return rec;
    }

    public short getRiser() {
        return this.field_1_riser;
    }

    public void setRiser(short field_1_riser) {
        this.field_1_riser = field_1_riser;
    }

    public short getTaper() {
        return this.field_2_taper;
    }

    public void setTaper(short field_2_taper) {
        this.field_2_taper = field_2_taper;
    }
}

