/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record;

import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.StandardRecord;
import org.zkoss.poi.hssf.record.common.FtrHeader;
import org.zkoss.poi.util.HexDump;
import org.zkoss.poi.util.LittleEndianOutput;

public final class XFCrcRecord
extends StandardRecord {
    public static final short sid = 2172;
    private FtrHeader futureHeader;
    private short reserved1;
    private int cxfs;
    private long crc;

    public XFCrcRecord() {
        this.futureHeader = new FtrHeader();
        this.futureHeader.setRecordType((short)2172);
    }

    @Override
    public short getSid() {
        return 2172;
    }

    public XFCrcRecord(RecordInputStream in) {
        this.futureHeader = new FtrHeader(in);
        this.reserved1 = in.readShort();
        this.cxfs = in.readUShort();
        this.crc = (long)in.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[XFCRC]\n");
        sb.append("    .cxfs =").append(this.cxfs).append("\n");
        sb.append("    .crc  =").append(HexDump.intToHex((int)this.crc)).append("\n");
        sb.append("[/XFCRC]\n");
        return sb.toString();
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        this.futureHeader.serialize(out);
        out.writeShort(this.reserved1);
        out.writeShort(this.cxfs);
        out.writeInt((int)this.crc);
    }

    @Override
    protected int getDataSize() {
        return 20;
    }

    public int getCxfs() {
        return this.cxfs;
    }

    public void setCxfs(int cxfs) {
        this.cxfs = cxfs;
    }

    public long getCrc() {
        return this.crc;
    }

    public void setCrc(long crc) {
        this.crc = crc;
    }

    @Override
    public Object clone() {
        return this.cloneViaReserialise();
    }
}

