/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record;

import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.StandardRecord;
import org.zkoss.poi.hssf.record.common.FtrHeader;
import org.zkoss.poi.util.LittleEndianOutput;

public class MTRSettingsRecord
extends StandardRecord {
    public static final short sid = 2202;
    private FtrHeader futureHeader;
    int fMTREnabled;
    int fUserSetThreadCount;
    int cUserThreadCount;

    public MTRSettingsRecord() {
        this.futureHeader = new FtrHeader();
        this.futureHeader.setRecordType((short)2202);
    }

    public MTRSettingsRecord(RecordInputStream in) {
        this.futureHeader = new FtrHeader(in);
        this.fMTREnabled = in.readInt();
        this.fUserSetThreadCount = in.readInt();
        this.cUserThreadCount = in.readInt();
    }

    @Override
    public short getSid() {
        return 2202;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[MTRSettings]\n");
        buffer.append(this.futureHeader.toString());
        buffer.append("    .fMTREnabled         = ").append(this.isMTREnabled()).append("\n");
        buffer.append("    .fUserSetThreadCount = ").append(this.isUserSetThreadCount()).append("\n");
        buffer.append("    .cUserThreadCount    = ").append(this.getUserThreadCount()).append("\n");
        buffer.append("[/MTRSettings]\n");
        return buffer.toString();
    }

    public int getUserThreadCount() {
        return this.cUserThreadCount;
    }

    public void setUserThreadCount(int count) {
        if (count < 1 || count > 1024) {
            count = 1;
        }
        this.cUserThreadCount = count;
    }

    public boolean isMTREnabled() {
        return this.fMTREnabled != 0;
    }

    public boolean isUserSetThreadCount() {
        return this.fUserSetThreadCount != 0;
    }

    public void setMTREnabled(boolean flag) {
        this.fMTREnabled = flag ? 1 : 0;
    }

    public void setUserSetThreadCount(boolean flag) {
        this.fUserSetThreadCount = flag ? 1 : 0;
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        this.futureHeader.serialize(out);
        out.writeInt(this.fMTREnabled);
        out.writeInt(this.fUserSetThreadCount);
        out.writeInt(this.cUserThreadCount);
    }

    @Override
    public Object clone() {
        return this.cloneViaReserialise();
    }

    @Override
    protected int getDataSize() {
        return 24;
    }
}

