/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record;

import org.zkoss.poi.hssf.record.RecordFormatException;
import org.zkoss.poi.hssf.record.SubRecord;
import org.zkoss.poi.util.BitField;
import org.zkoss.poi.util.BitFieldFactory;
import org.zkoss.poi.util.HexDump;
import org.zkoss.poi.util.LittleEndianInput;
import org.zkoss.poi.util.LittleEndianOutput;

public final class FtPioGrbitSubRecord
extends SubRecord {
    public static final short sid = 8;
    private static final BitField autopict = BitFieldFactory.getInstance(1);
    private static final BitField dde = BitFieldFactory.getInstance(2);
    private static final BitField printcalc = BitFieldFactory.getInstance(4);
    private static final BitField icon = BitFieldFactory.getInstance(8);
    private static final BitField ctl = BitFieldFactory.getInstance(16);
    private static final BitField prstm = BitFieldFactory.getInstance(32);
    private static final BitField camera = BitFieldFactory.getInstance(128);
    private static final BitField defaultsize = BitFieldFactory.getInstance(256);
    private static final BitField autoload = BitFieldFactory.getInstance(512);
    private short field_1_option;

    public FtPioGrbitSubRecord() {
    }

    public FtPioGrbitSubRecord(LittleEndianInput in, int size) {
        if (size != 2) {
            throw new RecordFormatException("Expected size 2 but got (" + size + ")");
        }
        this.field_1_option = in.readShort();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[ftPioGrbit]\n");
        buffer.append("    .option               = ").append("0x").append(HexDump.toHex(this.getOption())).append(" (").append(this.getOption()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("         .autopict                 = ").append(this.isAutoPict()).append('\n');
        buffer.append("         .dde                      = ").append(this.isDde()).append('\n');
        buffer.append("         .printcalc                = ").append(this.isPrintCalc()).append('\n');
        buffer.append("         .icon                     = ").append(this.isIcon()).append('\n');
        buffer.append("         .ctl                      = ").append(this.isCtl()).append('\n');
        buffer.append("         .prstm                    = ").append(this.isPrstm()).append('\n');
        buffer.append("         .camera                   = ").append(this.isCamera()).append('\n');
        buffer.append("         .defaultsize              = ").append(this.isDefaultSize()).append('\n');
        buffer.append("         .autoload                 = ").append(this.isAutoLoad()).append('\n');
        buffer.append("[/ftPioGrbit]\n");
        return buffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        out.writeShort(8);
        out.writeShort(this.getDataSize());
        out.writeShort(this.field_1_option);
    }

    @Override
    protected int getDataSize() {
        return 2;
    }

    public short getSid() {
        return 8;
    }

    @Override
    public Object clone() {
        FtPioGrbitSubRecord rec = new FtPioGrbitSubRecord();
        rec.field_1_option = this.field_1_option;
        return rec;
    }

    public short getOption() {
        return this.field_1_option;
    }

    public void setOption(short field_1_option) {
        this.field_1_option = field_1_option;
    }

    public void setAutoPict(boolean value) {
        this.field_1_option = autopict.setShortBoolean(this.field_1_option, value);
    }

    public boolean isAutoPict() {
        return autopict.isSet(this.field_1_option);
    }

    public void setIcon(boolean value) {
        this.field_1_option = icon.setShortBoolean(this.field_1_option, value);
    }

    public boolean isIcon() {
        return icon.isSet(this.field_1_option);
    }

    public void setAutoLoad(boolean value) {
        this.field_1_option = autoload.setShortBoolean(this.field_1_option, value);
    }

    public boolean isAutoLoad() {
        return autoload.isSet(this.field_1_option);
    }

    public void setCamera(boolean value) {
        this.field_1_option = camera.setShortBoolean(this.field_1_option, value);
    }

    public boolean isCamera() {
        return camera.isSet(this.field_1_option);
    }

    public void setDefaultSize(boolean value) {
        this.field_1_option = defaultsize.setShortBoolean(this.field_1_option, value);
    }

    public boolean isDefaultSize() {
        return defaultsize.isSet(this.field_1_option);
    }

    public void setPrstm(boolean value) {
        this.field_1_option = prstm.setShortBoolean(this.field_1_option, value);
    }

    public boolean isPrstm() {
        return prstm.isSet(this.field_1_option);
    }

    public void setCtl(boolean value) {
        this.field_1_option = ctl.setShortBoolean(this.field_1_option, value);
        if (value) {
            this.setDde(false);
        }
    }

    public boolean isCtl() {
        return ctl.isSet(this.field_1_option);
    }

    public void setPrintCalc(boolean value) {
        this.field_1_option = printcalc.setShortBoolean(this.field_1_option, value);
    }

    public boolean isPrintCalc() {
        return printcalc.isSet(this.field_1_option);
    }

    public void setDde(boolean value) {
        this.field_1_option = dde.setShortBoolean(this.field_1_option, value);
        if (value) {
            this.setCtl(false);
        }
    }

    public boolean isDde() {
        return dde.isSet(this.field_1_option);
    }
}

