/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record;

import org.zkoss.poi.hssf.record.RecordFormatException;
import org.zkoss.poi.hssf.record.SubRecord;
import org.zkoss.poi.util.HexDump;
import org.zkoss.poi.util.LittleEndianInput;
import org.zkoss.poi.util.LittleEndianOutput;

public final class FtCfSubRecord
extends SubRecord {
    public static final short sid = 7;
    private short field_1_cf;
    public static final short FORMAT_EMF = 2;
    public static final short FORMAT_BMP = 9;
    public static final short FORMAT_UNKNOWN = -1;

    public FtCfSubRecord() {
    }

    public FtCfSubRecord(LittleEndianInput in, int size) {
        if (size != 2) {
            throw new RecordFormatException("Expected size 2 but got (" + size + ")");
        }
        this.field_1_cf = in.readShort();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[ftCf]\n");
        buffer.append("    .cf           = ").append("0x").append(HexDump.toHex(this.getClipboardPictureFormat())).append(" (").append(this.getClipboardPictureFormat()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/ftCf]\n");
        return buffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        out.writeShort(7);
        out.writeShort(this.getDataSize());
        out.writeShort(this.field_1_cf);
    }

    @Override
    protected int getDataSize() {
        return 2;
    }

    public short getSid() {
        return 7;
    }

    @Override
    public Object clone() {
        FtCfSubRecord rec = new FtCfSubRecord();
        rec.field_1_cf = this.field_1_cf;
        return rec;
    }

    public short getClipboardPictureFormat() {
        return this.field_1_cf;
    }

    public void setClipboardPictureFormat(short field_1_cf) {
        this.field_1_cf = field_1_cf;
    }
}

