/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record;

import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.StandardRecord;
import org.zkoss.poi.hssf.record.common.FtrHeader;
import org.zkoss.poi.util.LittleEndianOutput;

public class ForceFullCalculationRecord
extends StandardRecord {
    public static final short sid = 2211;
    private FtrHeader futureHeader;
    int fNoDeps;

    public ForceFullCalculationRecord() {
        this.futureHeader = new FtrHeader();
        this.futureHeader.setRecordType((short)2211);
    }

    public ForceFullCalculationRecord(RecordInputStream in) {
        this.futureHeader = new FtrHeader(in);
        this.fNoDeps = in.readInt();
    }

    @Override
    public short getSid() {
        return 2211;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[FORCEFULLCALCULATION]\n");
        buffer.append(this.futureHeader.toString());
        buffer.append("    .fNoDeps         = ").append(this.isNoDeps()).append("\n");
        buffer.append("[/FORCEFULLCALCULATION]\n");
        return buffer.toString();
    }

    public boolean isNoDeps() {
        return this.fNoDeps != 0;
    }

    public void setNoDeps(boolean flag) {
        this.fNoDeps = flag ? 1 : 0;
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        this.futureHeader.serialize(out);
        out.writeInt(this.fNoDeps);
    }

    @Override
    public Object clone() {
        return this.cloneViaReserialise();
    }

    @Override
    protected int getDataSize() {
        return 16;
    }
}

