/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hslf.dev;

import java.io.ByteArrayOutputStream;
import java.util.Hashtable;
import org.zkoss.poi.hslf.HSLFSlideShow;
import org.zkoss.poi.hslf.record.Document;
import org.zkoss.poi.hslf.record.Notes;
import org.zkoss.poi.hslf.record.NotesAtom;
import org.zkoss.poi.hslf.record.PersistPtrHolder;
import org.zkoss.poi.hslf.record.PositionDependentRecord;
import org.zkoss.poi.hslf.record.Record;
import org.zkoss.poi.hslf.record.Slide;
import org.zkoss.poi.hslf.record.SlideAtom;
import org.zkoss.poi.hslf.record.SlideListWithText;
import org.zkoss.poi.hslf.record.SlidePersistAtom;
import org.zkoss.poi.hslf.usermodel.SlideShow;
import org.zkoss.poi.util.LittleEndian;

public final class SlideIdListing {
    private static byte[] fileContents;

    public static void main(String[] args) throws Exception {
        int i;
        if (args.length < 1) {
            System.err.println("Need to give a filename");
            System.exit(1);
        }
        HSLFSlideShow hss = new HSLFSlideShow(args[0]);
        SlideShow ss = new SlideShow(hss);
        fileContents = hss.getUnderlyingBytes();
        Record[] records = hss.getRecords();
        Record[] latestRecords = ss.getMostRecentCoreRecords();
        Document document = null;
        for (int i2 = 0; i2 < latestRecords.length; ++i2) {
            if (!(latestRecords[i2] instanceof Document)) continue;
            document = (Document)latestRecords[i2];
        }
        System.out.println("");
        SlideListWithText[] slwts = document.getSlideListWithTexts();
        for (i = 0; i < slwts.length; ++i) {
            Record[] cr = slwts[i].getChildRecords();
            for (int j = 0; j < cr.length; ++j) {
                if (!(cr[j] instanceof SlidePersistAtom)) continue;
                SlidePersistAtom spa = (SlidePersistAtom)cr[j];
                System.out.println("SlidePersistAtom knows about slide:");
                System.out.println("\t" + spa.getRefID());
                System.out.println("\t" + spa.getSlideIdentifier());
            }
        }
        System.out.println("");
        for (i = 0; i < latestRecords.length; ++i) {
            if (!(latestRecords[i] instanceof Slide)) continue;
            Slide s = (Slide)latestRecords[i];
            SlideAtom sa = s.getSlideAtom();
            System.out.println("Found the latest version of a slide record:");
            System.out.println("\tCore ID is " + s.getSheetId());
            System.out.println("\t(Core Records count is " + i + ")");
            System.out.println("\tDisk Position is " + s.getLastOnDiskOffset());
            System.out.println("\tMaster ID is " + sa.getMasterID());
            System.out.println("\tNotes ID is " + sa.getNotesID());
        }
        System.out.println("");
        for (i = 0; i < latestRecords.length; ++i) {
            if (!(latestRecords[i] instanceof Notes)) continue;
            Notes n = (Notes)latestRecords[i];
            NotesAtom na = n.getNotesAtom();
            System.out.println("Found the latest version of a notes record:");
            System.out.println("\tCore ID is " + n.getSheetId());
            System.out.println("\t(Core Records count is " + i + ")");
            System.out.println("\tDisk Position is " + n.getLastOnDiskOffset());
            System.out.println("\tMatching slide is " + na.getSlideID());
        }
        System.out.println("");
        int pos = 0;
        for (int i3 = 0; i3 < records.length; ++i3) {
            Record r = records[i3];
            if (r.getRecordType() == 6001L) {
                System.out.println("Found PersistPtrFullBlock at " + pos + " (" + Integer.toHexString(pos) + ")");
            }
            if (r.getRecordType() == 6002L) {
                System.out.println("Found PersistPtrIncrementalBlock at " + pos + " (" + Integer.toHexString(pos) + ")");
                PersistPtrHolder pph = (PersistPtrHolder)r;
                int[] sheetIDs = pph.getKnownSlideIDs();
                Hashtable<Integer, Integer> sheetOffsets = pph.getSlideLocationsLookup();
                for (int j = 0; j < sheetIDs.length; ++j) {
                    Integer id = sheetIDs[j];
                    Integer offset = sheetOffsets.get(id);
                    System.out.println("  Knows about sheet " + id);
                    System.out.println("    That sheet lives at " + offset);
                    Record atPos = SlideIdListing.findRecordAtPos(offset);
                    System.out.println("    The record at that pos is of type " + atPos.getRecordType());
                    System.out.println("    The record at that pos has class " + atPos.getClass().getName());
                    if (atPos instanceof PositionDependentRecord) continue;
                    System.out.println("    ** The record class isn't position aware! **");
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            r.writeOut(baos);
            pos += baos.size();
        }
        System.out.println("");
    }

    public static Record findRecordAtPos(int pos) {
        long type = LittleEndian.getUShort(fileContents, pos + 2);
        long rlen = LittleEndian.getUInt(fileContents, pos + 4);
        Record r = Record.createRecordForType(type, fileContents, pos, (int)rlen + 8);
        return r;
    }
}

