/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl.pdf;

import io.keikai.model.CellRegion;
import io.keikai.model.SFooter;
import io.keikai.model.SHeader;
import io.keikai.model.SPrintSetup;
import java.util.HashMap;
import java.util.Map;

final class OverrideSetup
implements SPrintSetup {
    SPrintSetup _internal;
    Map<String, Object> _data = new HashMap<String, Object>();

    OverrideSetup() {
    }

    public void setInternal(SPrintSetup internal) {
        this._internal = internal;
    }

    protected SPrintSetup getInternal() {
        if (this._internal == null) {
            throw new IllegalStateException("PrintSetup is not ready yet");
        }
        return this._internal;
    }

    public boolean isPrintGridlines() {
        return this._data.containsKey("gl") ? ((Boolean)this._data.get("gl")).booleanValue() : this.getInternal().isPrintGridlines();
    }

    public void setPrintGridlines(boolean enable) {
        this._data.put("gl", enable);
    }

    public double getHeaderMargin() {
        return this._data.containsKey("hm") ? ((Double)this._data.get("hm")).doubleValue() : this.getInternal().getHeaderMargin();
    }

    public void setHeaderMargin(double inches) {
        this._data.put("hm", inches);
    }

    public double getFooterMargin() {
        return this._data.containsKey("fm") ? ((Double)this._data.get("fm")).doubleValue() : this.getInternal().getFooterMargin();
    }

    public void setFooterMargin(double inches) {
        this._data.put("fm", inches);
    }

    public double getLeftMargin() {
        return this._data.containsKey("lm") ? ((Double)this._data.get("lm")).doubleValue() : this.getInternal().getLeftMargin();
    }

    public void setLeftMargin(double inches) {
        this._data.put("lm", inches);
    }

    public double getRightMargin() {
        return this._data.containsKey("rm") ? ((Double)this._data.get("rm")).doubleValue() : this.getInternal().getRightMargin();
    }

    public void setRightMargin(double inches) {
        this._data.put("rm", inches);
    }

    public double getTopMargin() {
        return this._data.containsKey("tm") ? ((Double)this._data.get("tm")).doubleValue() : this.getInternal().getTopMargin();
    }

    public void setTopMargin(double inches) {
        this._data.put("tm", inches);
    }

    public double getBottomMargin() {
        return this._data.containsKey("bm") ? ((Double)this._data.get("bm")).doubleValue() : this.getInternal().getBottomMargin();
    }

    public void setBottomMargin(double inches) {
        this._data.put("bm", inches);
    }

    public void setPaperSize(SPrintSetup.PaperSize size) {
        this._data.put("ps", size);
    }

    public SPrintSetup.PaperSize getPaperSize() {
        return this._data.containsKey("ps") ? (SPrintSetup.PaperSize)this._data.get("ps") : this.getInternal().getPaperSize();
    }

    public void setLandscape(boolean landscape) {
        this._data.put("ls", landscape);
    }

    public boolean isLandscape() {
        return this._data.containsKey("ls") ? ((Boolean)this._data.get("ls")).booleanValue() : this.getInternal().isLandscape();
    }

    public void setScale(int scale) {
        if (scale < 10 || scale > 400) {
            scale = 100;
        }
        this._data.put("sc", scale);
    }

    public int getScale() {
        return this._data.containsKey("sc") ? ((Integer)this._data.get("sc")).intValue() : this.getInternal().getScale();
    }

    public void setHeader(SHeader header) {
        this._data.put("hd", header);
    }

    public SHeader getHeader() {
        return this._data.containsKey("hd") ? (SHeader)this._data.get("hd") : this.getInternal().getHeader();
    }

    public void setEvenHeader(SHeader header) {
        this._data.put("ehd", header);
    }

    public SHeader getEvenHeader() {
        return this._data.containsKey("ehd") ? (SHeader)this._data.get("ehd") : this.getInternal().getEvenHeader();
    }

    public void setFirstHeader(SHeader header) {
        this._data.put("fhd", header);
    }

    public SHeader getFirstHeader() {
        return this._data.containsKey("fhd") ? (SHeader)this._data.get("fhd") : this.getInternal().getFirstHeader();
    }

    public void setFooter(SFooter footer) {
        this._data.put("ft", footer);
    }

    public SFooter getFooter() {
        return this._data.containsKey("ft") ? (SFooter)this._data.get("ft") : this.getInternal().getFooter();
    }

    public void setEvenFooter(SFooter footer) {
        this._data.put("eft", footer);
    }

    public SFooter getEvenFooter() {
        return this._data.containsKey("eft") ? (SFooter)this._data.get("eft") : this.getInternal().getEvenFooter();
    }

    public void setFirstFooter(SFooter footer) {
        this._data.put("fft", footer);
    }

    public SFooter getFirstFooter() {
        return this._data.containsKey("fft") ? (SFooter)this._data.get("fft") : this.getInternal().getFirstFooter();
    }

    public void setDifferentOddEvenPage(boolean flag) {
        this._data.put("dp", flag);
    }

    public boolean isDifferentOddEvenPage() {
        return this._data.containsKey("dp") ? ((Boolean)this._data.get("dp")).booleanValue() : this.getInternal().isDifferentOddEvenPage();
    }

    public void setDifferentFirstPage(boolean flag) {
        this._data.put("dfp", flag);
    }

    public boolean isDifferentFirstPage() {
        return this._data.containsKey("dfp") ? ((Boolean)this._data.get("dfp")).booleanValue() : this.getInternal().isDifferentFirstPage();
    }

    public void setScaleWithDoc(boolean flag) {
        this._data.put("sw", flag);
    }

    public boolean isScaleWithDoc() {
        return this._data.containsKey("sw") ? ((Boolean)this._data.get("sw")).booleanValue() : this.getInternal().isScaleWithDoc();
    }

    public void setAlignWithMargins(boolean flag) {
        this._data.put("aw", flag);
    }

    public boolean isAlignWithMargins() {
        return this._data.containsKey("aw") ? ((Boolean)this._data.get("aw")).booleanValue() : this.getInternal().isAlignWithMargins();
    }

    public void setHCenter(boolean center) {
        this._data.put("hc", center);
    }

    public boolean isHCenter() {
        return this._data.containsKey("hc") ? ((Boolean)this._data.get("hc")).booleanValue() : this.getInternal().isHCenter();
    }

    public void setVCenter(boolean vcenter) {
        this._data.put("vc", vcenter);
    }

    public boolean isVCenter() {
        return this._data.containsKey("vc") ? ((Boolean)this._data.get("vc")).booleanValue() : this.getInternal().isVCenter();
    }

    public void setPageStart(int start) {
        this._data.put("pst", start);
    }

    public int getPageStart() {
        return this._data.containsKey("pst") ? ((Integer)this._data.get("pst")).intValue() : this.getInternal().getPageStart();
    }

    public void setFitWidth(int numPages) {
        this._data.put("fw", numPages);
    }

    public int getFitWidth() {
        return this._data.containsKey("fw") ? ((Integer)this._data.get("fw")).intValue() : this.getInternal().getFitWidth();
    }

    public void setFitHeight(int numPages) {
        this._data.put("fh", numPages);
    }

    public int getFitHeight() {
        return this._data.containsKey("fh") ? ((Integer)this._data.get("fh")).intValue() : this.getInternal().getFitHeight();
    }

    public void setPrintArea(String formula) {
        this._data.put("pa", formula);
    }

    public String getPrintArea() {
        return this._data.containsKey("pa") ? (String)this._data.get("pa") : this.getInternal().getPrintArea();
    }

    public void setRepeatingRowsTitle(int firstRow, int lastRow) {
        this._data.put("rr1", firstRow);
        this._data.put("rr2", lastRow);
    }

    public CellRegion getRepeatingRowsTitle() {
        if (this._data.containsKey("rr1")) {
            int rr1 = (Integer)this._data.get("rr1");
            int rr2 = (Integer)this._data.get("rr2");
            return rr1 >= 0 && rr2 >= rr1 ? new CellRegion(rr1, 0, rr2, 0) : null;
        }
        return this.getInternal().getRepeatingRowsTitle();
    }

    public void setRepeatingColumnsTitle(int firstCol, int lastCol) {
        this._data.put("rc1", firstCol);
        this._data.put("rc2", lastCol);
    }

    public CellRegion getRepeatingColumnsTitle() {
        if (this._data.containsKey("rc1")) {
            int rc1 = (Integer)this._data.get("rc1");
            int rc2 = (Integer)this._data.get("rc2");
            return rc1 >= 0 && rc2 >= rc1 ? new CellRegion(0, rc1, 0, rc2) : null;
        }
        return this.getInternal().getRepeatingColumnsTitle();
    }

    public void setPrintHeadings(boolean flag) {
        this._data.put("ph", flag);
    }

    public boolean isPrintHeadings() {
        return this._data.containsKey("ph") ? ((Boolean)this._data.get("ph")).booleanValue() : this.getInternal().isPrintHeadings();
    }

    public void setCommentsMode(int mode) {
        this._data.put("cm", mode);
    }

    public int getCommentsMode() {
        return this._data.containsKey("cm") ? ((Integer)this._data.get("cm")).intValue() : this.getInternal().getCommentsMode();
    }

    public void setErrorPrintMode(int mode) {
        this._data.put("ep", mode);
    }

    public int getErrorPrintMode() {
        return this._data.containsKey("ep") ? ((Integer)this._data.get("ep")).intValue() : this.getInternal().getErrorPrintMode();
    }

    public void setLeftToRight(boolean flag) {
        this._data.put("lr", flag);
    }

    public boolean isLeftToRight() {
        return this._data.containsKey("lr") ? ((Boolean)this._data.get("lr")).booleanValue() : this.getInternal().isLeftToRight();
    }
}

