/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl.pdf;

import io.keikai.model.SBorder;
import io.keikai.model.SCellStyle;
import io.keikai.model.impl.pdf.BorderStyle;
import java.awt.Color;
import org.apache.poi.hssf.util.HSSFColor;

class StyleConversionUtil {
    public static float DEFAULT_ROW_HEADER_COLUMN_WIDTH = 25.0f;

    StyleConversionUtil() {
    }

    public static int getCorrespondingPdfPCellAlignment(SCellStyle.Alignment zssAlignment) {
        switch (zssAlignment) {
            case CENTER_SELECTION: 
            case CENTER: {
                return 1;
            }
            case LEFT: {
                return 0;
            }
            case RIGHT: {
                return 2;
            }
            case JUSTIFY: {
                return 3;
            }
            case FILL: {
                return 8;
            }
        }
        return -1;
    }

    public static int getCorrespondingPdfPCellVerticalAlignment(SCellStyle.VerticalAlignment zssAlignment) {
        switch (zssAlignment) {
            case CENTER: {
                return 5;
            }
            case TOP: {
                return 4;
            }
            case BOTTOM: {
                return 6;
            }
            case JUSTIFY: {
                return 7;
            }
        }
        return -1;
    }

    public static Color getBaseColor(HSSFColor hssfColor) {
        if (hssfColor == null) {
            return null;
        }
        short[] rgb = hssfColor.getTriplet();
        if (rgb[0] == 0 && rgb[1] == 0 && rgb[2] == 0) {
            return Color.white;
        }
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public static BorderStyle getBorderStyle(SBorder.BorderType borderStyle) {
        switch (borderStyle) {
            case DOTTED: {
                return new BorderStyle(1.0f, 0, new float[]{1.0f, 1.0f}, 0.0f);
            }
            case HAIR: {
                return new BorderStyle(1.5f, 0, new float[]{1.5f, 1.5f}, 0.0f);
            }
            case DASH_DOT_DOT: {
                return new BorderStyle(1.5f, 0, new float[]{10.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f}, 0.0f);
            }
            case MEDIUM_DASH_DOT_DOT: {
                return new BorderStyle(1.7f, 0, new float[]{10.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f}, 0.0f);
            }
            case DASH_DOT: {
                return new BorderStyle(1.5f, 0, new float[]{10.0f, 3.0f, 3.0f, 3.0f}, 0.0f);
            }
            case DASHED: {
                return new BorderStyle(1.0f, 0, new float[]{5.0f}, 0.0f);
            }
            case THIN: {
                return new BorderStyle(1.0f, 0, new float[0], 0.0f);
            }
            case SLANTED_DASH_DOT: {
                return new BorderStyle(2.0f, 0, new float[]{10.0f, 3.0f, 3.0f, 3.0f}, 0.0f);
            }
            case MEDIUM_DASH_DOT: {
                return new BorderStyle(1.7f, 0, new float[]{10.0f, 3.0f, 3.0f, 3.0f}, 0.0f);
            }
            case MEDIUM_DASHED: {
                return new BorderStyle(2.0f, 0, new float[]{5.0f}, 0.0f);
            }
            case MEDIUM: {
                return new BorderStyle(1.7f, 0, new float[0], 0.0f);
            }
            case THICK: {
                return new BorderStyle(2.2f, 0, new float[0], 0.0f);
            }
            case DOUBLE: {
                return new BorderStyle(0.6f, 0, new float[0], 0.0f);
            }
        }
        return null;
    }
}

