/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.html.WebColors;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import com.lowagie.text.pdf.PdfTemplate;
import io.keikai.model.CellRegion;
import io.keikai.model.SBorder;
import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SColor;
import io.keikai.model.SFill;
import io.keikai.model.SFont;
import io.keikai.model.SSheet;
import io.keikai.model.impl.FillImpl;
import io.keikai.model.impl.pdf.BorderStyle;
import io.keikai.model.impl.pdf.PdfExporter;
import io.keikai.model.impl.pdf.PixelInfo;
import io.keikai.model.impl.pdf.RenderInfo;
import io.keikai.model.impl.pdf.StyleConversionUtil;
import java.awt.Color;
import java.io.IOException;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CellRenderEvent
implements PdfPCellEvent,
Serializable {
    private static final long serialVersionUID = -7280463782329527875L;
    private static final Logger log = LoggerFactory.getLogger(CellRenderEvent.class);
    private SCellStyle style;
    private SCell zssCell;
    private SSheet sheet;
    private Phrase phrase;
    private CellRegion clipRegion;
    private CellRegion outlineRegion;
    private CellRegion renderRegion;
    private RenderInfo renderInfo;
    private PixelInfo pixelInfo;
    private RenderInfo clipInfo;
    private boolean printGridLines;
    private boolean printOutline;
    private static final float LINE_SPACING_RATIO = 1.325f;
    private static final float DOUBLE_LINE_HALF_SPACE = 0.7f;

    public SCell getZSSCell() {
        return this.zssCell;
    }

    public void setZSSCell(SCell zssCell) {
        this.zssCell = zssCell;
    }

    private CellRenderEvent(SSheet sheet, CellRegion clipRegion, RenderInfo clipInfo, CellRegion renderRegion, RenderInfo renderInfo, CellRegion outlineRegion, Phrase phrase) {
        this.sheet = sheet;
        this.clipRegion = clipRegion;
        this.outlineRegion = outlineRegion;
        this.phrase = phrase;
        this.renderInfo = renderInfo;
        this.clipInfo = clipInfo;
        this.renderRegion = renderRegion;
    }

    public static CellRenderEvent getCellRenderEvent(CellRegion clipRegion, RenderInfo clipInfo, CellRegion renderRegion, RenderInfo renderInfo, SCell zssCell, SCellStyle style, boolean printOutline, boolean printGridLines, CellRegion outlineRegion, PixelInfo pixelInfo, Phrase phrase, SSheet sheet) {
        CellRenderEvent event = new CellRenderEvent(sheet, clipRegion, clipInfo, renderRegion, renderInfo, outlineRegion, phrase);
        event.setZSSCell(zssCell);
        event.setStyle(style);
        event.setPrintGridLines(printGridLines);
        event.setPrintOutline(printOutline);
        event.setPixelInfo(pixelInfo);
        return event;
    }

    public void cellLayout(PdfPCell cell, Rectangle rect, PdfContentByte[] canvases) {
        SFill fill;
        Rectangle clipRect = null;
        if (this.clipInfo != null) {
            float top = rect.getTop();
            float bottom = (float)((double)top - this.clipInfo.getHeight());
            float left = rect.getLeft();
            float right = (float)((double)left + this.clipInfo.getWidth());
            clipRect = new Rectangle(left, bottom, right, top);
        } else {
            clipRect = rect;
        }
        SFill sFill = fill = this.style == null ? null : this.style.getFill();
        if (fill != null && fill.getFillPattern() != SFill.FillPattern.NONE && fill.getFillPattern() != SFill.FillPattern.SOLID) {
            PdfContentByte canvas = canvases[2];
            this.drawFillPattern(clipRect, fill, canvas);
        }
        if (this.phrase != null) {
            PdfContentByte txtCanvas = canvases[3];
            this.processPhrase(clipRect, rect, txtCanvas);
        }
        if (this.outlineRegion != null) {
            PdfContentByte lineCanvas = canvases[2];
            lineCanvas.setLineJoin(0);
            this.processBottomBorder(rect, lineCanvas, this.zssCell);
            this.processRightBorder(rect, lineCanvas, this.zssCell);
            this.processTopBorder(rect, lineCanvas, this.zssCell);
            this.processLeftBorder(rect, lineCanvas, this.zssCell);
        }
    }

    private BorderInfo getBorderInfo(BORDER border, SCell cell) {
        SCellStyle cellStyle;
        if (cell != null && (cellStyle = cell.getCellStyle()) != null) {
            Object type = border.getType(cellStyle);
            if (border == BORDER.BACKGROUND && SFill.FillPattern.NONE != type) {
                return new BorderInfo(type, border.getColor(cellStyle));
            }
            if (SBorder.BorderType.NONE != type && SFill.FillPattern.NONE != type) {
                return new BorderInfo(type, border.getColor(cellStyle));
            }
        }
        return null;
    }

    private boolean[] getDoubleBorderCornerInfo(BORDER border, SCell cell, int rowIdx, int colIdx) {
        boolean end;
        boolean start;
        switch (border) {
            case TOP: 
            case BOTTOM: {
                start = this.getLeftBorderType(cell, rowIdx, colIdx) == SBorder.BorderType.DOUBLE;
                end = this.getRightBorderType(cell, rowIdx, colIdx) == SBorder.BorderType.DOUBLE;
                break;
            }
            case RIGHT: 
            case LEFT: {
                start = this.getTopBorderType(cell, rowIdx, colIdx) == SBorder.BorderType.DOUBLE;
                end = this.getBottomBorderType(cell, rowIdx, colIdx) == SBorder.BorderType.DOUBLE;
                break;
            }
            default: {
                return null;
            }
        }
        return new boolean[]{start, end};
    }

    private SBorder.BorderType getLeftBorderType(SCell cell, int rowIdx, int colIdx) {
        SCell leftCell;
        SBorder.BorderType type;
        if (colIdx > 0 && (type = this.getBorderType(BORDER.RIGHT, leftCell = this.sheet.getCell(rowIdx, colIdx - 1))) != null && type != SBorder.BorderType.NONE) {
            return type;
        }
        return this.getBorderType(BORDER.LEFT, cell);
    }

    private SBorder.BorderType getTopBorderType(SCell cell, int rowIdx, int colIdx) {
        SCell leftCell;
        SBorder.BorderType type;
        if (rowIdx > 0 && (type = this.getBorderType(BORDER.BOTTOM, leftCell = this.sheet.getCell(rowIdx - 1, colIdx))) != null && type != SBorder.BorderType.NONE) {
            return type;
        }
        return this.getBorderType(BORDER.TOP, cell);
    }

    private SBorder.BorderType getRightBorderType(SCell cell, int rowIdx, int colIdx) {
        SBorder.BorderType type = this.getBorderType(BORDER.RIGHT, cell);
        if (type != null && type != SBorder.BorderType.NONE) {
            return type;
        }
        SCell rightCell = this.sheet.getCell(rowIdx, colIdx + 1);
        return this.getBorderType(BORDER.LEFT, rightCell);
    }

    private SBorder.BorderType getBottomBorderType(SCell cell, int rowIdx, int colIdx) {
        SBorder.BorderType type = this.getBorderType(BORDER.BOTTOM, cell);
        if (type != null && type != SBorder.BorderType.NONE) {
            return type;
        }
        SCell bottomCell = this.sheet.getCell(rowIdx + 1, colIdx);
        return this.getBorderType(BORDER.TOP, bottomCell);
    }

    private SBorder.BorderType getBorderType(BORDER border, SCell cell) {
        SCellStyle cellStyle;
        if (cell != null && (cellStyle = cell.getCellStyle()) != null) {
            return (SBorder.BorderType)border.getType(cellStyle);
        }
        return null;
    }

    private SCell.CellType getRealType(SCell zssCell) {
        if (zssCell == null) {
            return SCell.CellType.BLANK;
        }
        SCell.CellType type = zssCell.getType();
        if (type == SCell.CellType.FORMULA) {
            type = zssCell.getFormulaResultType();
        }
        return type;
    }

    private void processPhrase(Rectangle clipRect, Rectangle cellRect, PdfContentByte txtCanvas) {
        if (this.renderInfo == null) {
            this.renderInfo = new RenderInfo(0.0, 0.0, clipRect.getWidth(), clipRect.getHeight(), false, false);
        }
        try {
            boolean wrapText = this.style == null ? false : this.style.isWrapText() && this.getRealType(this.zssCell) == SCell.CellType.STRING;
            SCellStyle.Alignment align = PdfExporter.getRealAlignment(this.zssCell);
            double renderWidth = this.renderInfo.getWidth();
            double renderHeight = this.renderInfo.getHeight();
            double renderOffsetX = this.renderInfo.getOffsetX();
            double renderOffsetY = this.renderInfo.getOffsetY();
            double clipHeight = clipRect.getHeight();
            double wrapWidth = renderWidth - 1.5 - 1.5;
            ColumnText ct = new ColumnText(txtCanvas);
            ct.setLeading(0.0f, 1.325f);
            ct.setSimpleColumn(0.0f, 0.0f, wrapText ? (float)wrapWidth : 2000.0f, -2000.0f);
            ct.setAlignment(StyleConversionUtil.getCorrespondingPdfPCellAlignment(align));
            ct.setText(this.phrase);
            ct.go(true);
            double phraseDecender = -ct.getDescender();
            double phraseHeight = 0.0f - ct.getYLine();
            double realWidth = ColumnText.getWidth((Phrase)this.phrase);
            double phraseWidth = wrapText ? wrapWidth : Math.max(realWidth, renderWidth);
            SCellStyle.VerticalAlignment valign = PdfExporter.getRealVerticalAlignment(this.zssCell);
            double columnTextLowerLeftY = -(renderHeight - clipHeight + renderOffsetY);
            switch (valign) {
                default: {
                    columnTextLowerLeftY += renderHeight - (phraseHeight + 0.0);
                    break;
                }
                case CENTER: {
                    columnTextLowerLeftY += (renderHeight - phraseHeight) / 2.0;
                    break;
                }
                case BOTTOM: {
                    columnTextLowerLeftY += (double)1.4f;
                }
            }
            double columnTextLowerLeftX = renderOffsetX;
            switch (align) {
                default: {
                    columnTextLowerLeftX += 1.5;
                    break;
                }
                case RIGHT: {
                    columnTextLowerLeftX -= 1.5;
                }
            }
            PdfTemplate tmpl = txtCanvas.createTemplate(clipRect.getWidth(), clipRect.getHeight());
            ct = new ColumnText((PdfContentByte)tmpl);
            ct.setLeading(0.0f, 1.325f);
            ct.setSimpleColumn((float)columnTextLowerLeftX, (float)columnTextLowerLeftY, (float)(columnTextLowerLeftX + phraseWidth), (float)(columnTextLowerLeftY + phraseHeight + phraseDecender));
            ct.setAlignment(StyleConversionUtil.getCorrespondingPdfPCellAlignment(align));
            ct.setText(this.phrase);
            ct.go();
            txtCanvas.addTemplate(tmpl, clipRect.getLeft(), clipRect.getBottom());
            this.drawAccountingUnderline(clipRect, cellRect, (float)columnTextLowerLeftX, (float)columnTextLowerLeftY, (float)phraseWidth, (float)realWidth, txtCanvas);
        }
        catch (DocumentException e) {
            throw new ExceptionConverter((Exception)((Object)e));
        }
    }

    private void drawAccountingUnderline(Rectangle clipRect, Rectangle cellRect, float offsetX, float offsetY, float renderWidth, float realWidth, PdfContentByte txtCanvas) {
        if (this.style == null) {
            return;
        }
        SFont sFont = this.style.getFont();
        SFont.Underline under = sFont.getUnderline();
        if (under == SFont.Underline.DOUBLE_ACCOUNTING || under == SFont.Underline.SINGLE_ACCOUNTING) {
            boolean extended = this.renderInfo.isExtended();
            if (extended) {
                clipRect = cellRect;
            }
            float renderL = (float)((double)clipRect.getLeft() + this.renderInfo.getOffsetX());
            float renderB = (float)((double)clipRect.getBottom() + this.renderInfo.getOffsetY());
            float renderR = (float)((double)renderL + this.renderInfo.getWidth());
            BorderStyle lineStyle = new BorderStyle(0.6f, 0, new float[0], 0.0f);
            String lineColor = sFont.getColor().getHtmlColor();
            float l = clipRect.getLeft() + (renderL == clipRect.getLeft() || extended ? 1.5f : 0.0f);
            float r = clipRect.getRight() - (renderR == clipRect.getRight() || extended ? 1.5f : 0.0f);
            boolean number = this.renderInfo.isNumber();
            if (number) {
                float offsetH = 0.0f;
                float realL = 0.0f;
                switch (this.style.getAlignment()) {
                    default: {
                        offsetH = (renderWidth - realWidth) / 2.0f;
                        realL = renderL + offsetH + 1.5f;
                        break;
                    }
                    case FILL: 
                    case JUSTIFY: 
                    case LEFT: {
                        offsetH = 0.0f;
                        realL = renderL + 1.5f;
                        break;
                    }
                    case RIGHT: 
                    case GENERAL: {
                        offsetH = renderWidth - realWidth;
                        realL = renderL + offsetH - 1.5f;
                    }
                }
                l = Math.max(realL, l);
                float realR = realL + realWidth;
                r = Math.min(realR, r);
            }
            float b = renderB + offsetY - 1.0f + 1.4f;
            float t = b + clipRect.getHeight();
            if (clipRect.getBottom() <= b && b <= clipRect.getTop()) {
                Rectangle rect0 = new Rectangle(l, b, r, t);
                this.drawBorder(rect0, txtCanvas, lineStyle, lineColor, BORDER.BOTTOM, null);
            }
            if (under == SFont.Underline.DOUBLE_ACCOUNTING) {
                b -= 1.4f;
                if (clipRect.getBottom() <= b && b <= clipRect.getTop()) {
                    Rectangle rect1 = new Rectangle(l, b, r, t);
                    this.drawBorder(rect1, txtCanvas, lineStyle, lineColor, BORDER.BOTTOM, null);
                }
            }
        }
    }

    private void processBottomBorder(Rectangle rect, PdfContentByte lineCanvas, SCell sCell) {
        this.processBottomBorder0(rect, lineCanvas, sCell);
        this.drawOutline(rect, lineCanvas, BORDER.BOTTOM);
    }

    private void processBottomBorder0(Rectangle rect, PdfContentByte lineCanvas, SCell sCell) {
        int rowIdx = this.clipRegion.getRow();
        if (this.renderRegion == null || rowIdx == this.renderRegion.getLastRow()) {
            BorderInfo info;
            int colIdx = this.clipRegion.getColumn();
            if (sCell != null && (sCell.getColumnIndex() != colIdx || sCell.getRowIndex() != rowIdx)) {
                sCell = this.sheet.getCell(rowIdx, colIdx);
            }
            if ((info = this.getBorderInfo(BORDER.BOTTOM, sCell)) != null) {
                if (info.type != SBorder.BorderType.DOUBLE) {
                    this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.BOTTOM, info.type);
                } else {
                    SCell nextCell = this.sheet.getCell(rowIdx + 1, colIdx);
                    this.drawDoubleBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.BOTTOM, sCell, rowIdx, colIdx, nextCell, rowIdx + 1, colIdx);
                }
                return;
            }
            SCell nextCell = this.sheet.getCell(rowIdx + 1, colIdx);
            info = this.getBorderInfo(BORDER.TOP, nextCell);
            if (info != null) {
                if (info.type != SBorder.BorderType.DOUBLE) {
                    this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.BOTTOM, info.type);
                } else {
                    this.drawDoubleBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.BOTTOM, sCell, rowIdx, colIdx, nextCell, rowIdx + 1, colIdx);
                }
                return;
            }
            info = this.getBorderInfo(BORDER.BACKGROUND, sCell);
            if (info != null) {
                return;
            }
            info = this.getBorderInfo(BORDER.BACKGROUND, nextCell);
            if (info != null) {
                return;
            }
            this.drawGridlines(rect, lineCanvas, BORDER.BOTTOM);
        }
    }

    private void processRightBorder(Rectangle rect, PdfContentByte lineCanvas, SCell sCell) {
        this.processRightBorder0(rect, lineCanvas, sCell);
        this.drawOutline(rect, lineCanvas, BORDER.RIGHT);
    }

    private void processRightBorder0(Rectangle rect, PdfContentByte lineCanvas, SCell sCell) {
        int colIdx = this.clipRegion.getColumn();
        if (this.renderRegion == null || colIdx == this.renderRegion.getLastColumn()) {
            BorderInfo info;
            int rowIdx = this.clipRegion.getRow();
            if (sCell != null && (sCell.getColumnIndex() != colIdx || sCell.getRowIndex() != rowIdx)) {
                sCell = this.sheet.getCell(rowIdx, colIdx);
            }
            if ((info = this.getBorderInfo(BORDER.RIGHT, sCell)) != null) {
                if (info.type != SBorder.BorderType.DOUBLE) {
                    this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.RIGHT, info.type);
                } else {
                    SCell rightCell = this.sheet.getCell(rowIdx, colIdx + 1);
                    this.drawDoubleBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.RIGHT, sCell, rowIdx, colIdx, rightCell, rowIdx, colIdx + 1);
                }
                return;
            }
            SCell rightCell = this.sheet.getCell(rowIdx, colIdx + 1);
            info = this.getBorderInfo(BORDER.LEFT, rightCell);
            if (info != null) {
                if (info.type != SBorder.BorderType.DOUBLE) {
                    this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.RIGHT, info.type);
                } else {
                    this.drawDoubleBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.RIGHT, sCell, rowIdx, colIdx, rightCell, rowIdx, colIdx + 1);
                }
                return;
            }
            info = this.getBorderInfo(BORDER.BACKGROUND, sCell);
            if (info != null) {
                return;
            }
            info = this.getBorderInfo(BORDER.BACKGROUND, rightCell);
            if (info != null) {
                return;
            }
            this.drawGridlines(rect, lineCanvas, BORDER.RIGHT);
        }
    }

    private void processTopBorder(Rectangle rect, PdfContentByte lineCanvas, SCell sCell) {
        if (this.clipRegion.getRow() == this.outlineRegion.getRow()) {
            this.processTopBorder0(rect, lineCanvas, sCell);
            this.drawOutline(rect, lineCanvas, BORDER.TOP);
        }
    }

    private void processTopBorder0(Rectangle rect, PdfContentByte lineCanvas, SCell sCell) {
        int rowIdx = this.clipRegion.getRow();
        if (this.renderRegion == null || rowIdx == this.renderRegion.getRow()) {
            int colIdx = this.clipRegion.getColumn();
            BorderInfo info = null;
            SCell topCell = null;
            if (rowIdx > 0 && (info = this.getBorderInfo(BORDER.BOTTOM, topCell = this.sheet.getCell(rowIdx - 1, colIdx))) != null && info.type != SBorder.BorderType.DOUBLE) {
                this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.TOP, info.type);
                return;
            }
            if (sCell != null && (sCell.getColumnIndex() != colIdx || sCell.getRowIndex() != rowIdx)) {
                sCell = this.sheet.getCell(rowIdx, colIdx);
            }
            if (info != null && info.type == SBorder.BorderType.DOUBLE) {
                this.drawDoubleBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.TOP, sCell, rowIdx, colIdx, topCell, rowIdx - 1, colIdx);
                return;
            }
            info = this.getBorderInfo(BORDER.TOP, sCell);
            if (info != null) {
                if (info.type != SBorder.BorderType.DOUBLE) {
                    this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.TOP, info.type);
                } else {
                    this.drawDoubleBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.TOP, sCell, rowIdx, colIdx, topCell, rowIdx - 1, colIdx);
                }
                return;
            }
            info = this.getBorderInfo(BORDER.BACKGROUND, topCell);
            if (info != null) {
                return;
            }
            info = this.getBorderInfo(BORDER.BACKGROUND, sCell);
            if (info != null) {
                return;
            }
            this.drawGridlines(rect, lineCanvas, BORDER.TOP);
        }
    }

    private void processLeftBorder(Rectangle rect, PdfContentByte lineCanvas, SCell sCell) {
        if (this.clipRegion.getColumn() == this.outlineRegion.getColumn()) {
            this.processLeftBorder0(rect, lineCanvas, sCell);
            this.drawOutline(rect, lineCanvas, BORDER.LEFT);
        }
    }

    private void processLeftBorder0(Rectangle rect, PdfContentByte lineCanvas, SCell sCell) {
        int colIdx = this.clipRegion.getColumn();
        if (this.renderRegion == null || colIdx == this.renderRegion.getColumn()) {
            int rowIdx = this.clipRegion.getRow();
            BorderInfo info = null;
            SCell leftCell = null;
            if (colIdx > 0 && (info = this.getBorderInfo(BORDER.RIGHT, leftCell = this.sheet.getCell(rowIdx, colIdx - 1))) != null && info.type != SBorder.BorderType.DOUBLE) {
                this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.LEFT, info.type);
                return;
            }
            if (sCell != null && (sCell.getColumnIndex() != colIdx || sCell.getRowIndex() != rowIdx)) {
                sCell = this.sheet.getCell(rowIdx, colIdx);
            }
            if (info != null && info.type == SBorder.BorderType.DOUBLE) {
                this.drawDoubleBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.LEFT, sCell, rowIdx, colIdx, leftCell, rowIdx, colIdx - 1);
                return;
            }
            info = this.getBorderInfo(BORDER.LEFT, sCell);
            if (info != null) {
                if (info.type != SBorder.BorderType.DOUBLE) {
                    this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.LEFT, info.type);
                } else {
                    this.drawDoubleBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.LEFT, sCell, rowIdx, colIdx, leftCell, rowIdx, colIdx - 1);
                }
                return;
            }
            info = this.getBorderInfo(BORDER.BACKGROUND, leftCell);
            if (info != null) {
                return;
            }
            info = this.getBorderInfo(BORDER.BACKGROUND, sCell);
            if (info != null) {
                return;
            }
            this.drawGridlines(rect, lineCanvas, BORDER.LEFT);
        }
    }

    private void drawOutline(Rectangle rect, PdfContentByte lineCanvas, BORDER border) {
        boolean printOutline;
        boolean bl = printOutline = this.isPrintGridLines() || this.isPrintOutline();
        if (printOutline) {
            switch (border) {
                case TOP: {
                    printOutline = this.clipRegion.getRow() == this.outlineRegion.getRow();
                    break;
                }
                case LEFT: {
                    printOutline = this.clipRegion.getColumn() == this.outlineRegion.getColumn();
                    break;
                }
                case BOTTOM: {
                    printOutline = this.clipRegion.getRow() == this.outlineRegion.getLastRow();
                    break;
                }
                case RIGHT: {
                    printOutline = this.clipRegion.getColumn() == this.outlineRegion.getLastColumn();
                    break;
                }
                default: {
                    printOutline = false;
                }
            }
        }
        if (printOutline) {
            lineCanvas.saveState();
            lineCanvas.setLineWidth(0.8f);
            lineCanvas.setLineCap(0);
            lineCanvas.setLineDash(new float[0], 0.0f);
            lineCanvas.setColorStroke(Color.BLACK);
            this.setBorderEndPoints(rect, lineCanvas, border);
            lineCanvas.stroke();
            lineCanvas.restoreState();
        }
    }

    private void drawGridlines(Rectangle rect, PdfContentByte lineCanvas, BORDER border) {
        if (this.isPrintGridLines()) {
            lineCanvas.saveState();
            lineCanvas.setLineWidth(0.4f);
            lineCanvas.setLineCap(0);
            lineCanvas.setLineDash(new float[0], 0.0f);
            lineCanvas.setColorStroke(Color.GRAY);
            this.setBorderEndPoints(rect, lineCanvas, border);
            lineCanvas.stroke();
            lineCanvas.restoreState();
        }
    }

    private void drawBorder(Rectangle rect, PdfContentByte lineCanvas, BorderStyle borderStyle, String sBorderColor, BORDER border, Object type) {
        this.drawBorderLine(rect, lineCanvas, borderStyle, sBorderColor, border);
    }

    private void drawDoubleBorder(Rectangle rect, PdfContentByte lineCanvas, BorderStyle borderStyle, String sBorderColor, BORDER border, SCell sCell, int rowIdx, int colIdx, SCell sibling, int sibRowIdx, int sibColIdx) {
        Rectangle innerRect;
        float outerOffsetB;
        float innerOffsetE;
        float innerOffsetB;
        float t = rect.getTop();
        float l = rect.getLeft();
        float r = rect.getRight();
        float b = rect.getBottom();
        boolean[] inner = this.getDoubleBorderCornerInfo(border, sCell, rowIdx, colIdx);
        boolean[] outer = this.getDoubleBorderCornerInfo(border, sibling, sibRowIdx, sibColIdx);
        float f = inner[0] ? 0.7f : (innerOffsetB = outer[0] ? -0.7f : 0.0f);
        float f2 = inner[1] ? 0.7f : (innerOffsetE = outer[1] ? -0.7f : 0.0f);
        float f3 = outer[0] ? 0.7f : (outerOffsetB = inner[0] ? -0.7f : 0.0f);
        float outerOffsetE = outer[1] ? 0.7f : (inner[1] ? -0.7f : 0.0f);
        switch (border) {
            default: {
                if (colIdx == this.outlineRegion.getLastColumn()) {
                    if (outerOffsetE < 0.0f) {
                        outerOffsetE = 0.0f;
                    } else if (innerOffsetE < 0.0f) {
                        innerOffsetE = 0.0f;
                    }
                }
                if (colIdx == this.outlineRegion.getColumn()) {
                    if (outerOffsetB < 0.0f) {
                        outerOffsetB = 0.0f;
                    } else if (innerOffsetB < 0.0f) {
                        innerOffsetB = 0.0f;
                    }
                }
                innerRect = new Rectangle(l + innerOffsetB, b, r - innerOffsetE, t - 0.7f);
                Rectangle outerRect = new Rectangle(l + outerOffsetB, b, r - outerOffsetE, t + 0.7f);
                if (colIdx == this.outlineRegion.getRow()) break;
                this.drawBorderLine(outerRect, lineCanvas, borderStyle, sBorderColor, border);
                break;
            }
            case BOTTOM: {
                if (colIdx == this.outlineRegion.getLastColumn()) {
                    if (outerOffsetE < 0.0f) {
                        outerOffsetE = 0.0f;
                    } else if (innerOffsetE < 0.0f) {
                        innerOffsetE = 0.0f;
                    }
                }
                if (colIdx == this.outlineRegion.getColumn()) {
                    if (outerOffsetB < 0.0f) {
                        outerOffsetB = 0.0f;
                    } else if (innerOffsetB < 0.0f) {
                        innerOffsetB = 0.0f;
                    }
                }
                Rectangle outerRect = new Rectangle(l + outerOffsetB, b - 0.7f, r - outerOffsetE, t);
                innerRect = new Rectangle(l + innerOffsetB, b + 0.7f, r - innerOffsetE, t);
                if (rowIdx == this.outlineRegion.getLastRow()) break;
                this.drawBorderLine(outerRect, lineCanvas, borderStyle, sBorderColor, border);
                break;
            }
            case LEFT: {
                if (rowIdx == this.outlineRegion.getLastRow()) {
                    if (outerOffsetE < 0.0f) {
                        outerOffsetE = 0.0f;
                    } else if (innerOffsetE < 0.0f) {
                        innerOffsetE = 0.0f;
                    }
                }
                if (rowIdx == this.outlineRegion.getRow()) {
                    if (outerOffsetB < 0.0f) {
                        outerOffsetB = 0.0f;
                    } else if (innerOffsetB < 0.0f) {
                        innerOffsetB = 0.0f;
                    }
                }
                Rectangle outerRect = new Rectangle(l - 0.7f, b + outerOffsetE, r, t - outerOffsetB);
                innerRect = new Rectangle(l + 0.7f, b + innerOffsetE, r, t - innerOffsetB);
                if (colIdx == this.outlineRegion.getColumn()) break;
                this.drawBorderLine(outerRect, lineCanvas, borderStyle, sBorderColor, border);
                break;
            }
            case RIGHT: {
                if (rowIdx == this.outlineRegion.getLastRow()) {
                    if (outerOffsetE < 0.0f) {
                        outerOffsetE = 0.0f;
                    } else if (innerOffsetE < 0.0f) {
                        innerOffsetE = 0.0f;
                    }
                }
                if (rowIdx == this.outlineRegion.getRow()) {
                    if (outerOffsetB < 0.0f) {
                        outerOffsetB = 0.0f;
                    } else if (innerOffsetB < 0.0f) {
                        innerOffsetB = 0.0f;
                    }
                }
                innerRect = new Rectangle(l, b + innerOffsetE, r - 0.7f, t - innerOffsetB);
                Rectangle outerRect = new Rectangle(l, b + outerOffsetE, r + 0.7f, t - outerOffsetB);
                if (colIdx == this.outlineRegion.getLastColumn()) break;
                this.drawBorderLine(outerRect, lineCanvas, borderStyle, sBorderColor, border);
            }
        }
        this.drawBorderLine(innerRect, lineCanvas, borderStyle, sBorderColor, border);
    }

    private void drawBorderLine(Rectangle rect, PdfContentByte lineCanvas, BorderStyle borderStyle, String sBorderColor, BORDER border) {
        lineCanvas.saveState();
        lineCanvas.setLineWidth(borderStyle.getLineWidth());
        lineCanvas.setLineCap(borderStyle.getLineCapStyle());
        lineCanvas.setLineDash(borderStyle.getUnits(), borderStyle.getPhase());
        Color borderColor = WebColors.getRGBColor((String)(sBorderColor == null || "AUTO_COLOR".equals(sBorderColor) ? "BLACK" : sBorderColor));
        lineCanvas.setColorStroke(Color.black);
        if (borderColor != null && borderColor != Color.white) {
            lineCanvas.setColorStroke(borderColor);
        }
        this.setBorderEndPoints(rect, lineCanvas, border);
        lineCanvas.stroke();
        lineCanvas.restoreState();
    }

    private void setBorderEndPoints(Rectangle rect, PdfContentByte lineCanvas, BORDER border) {
        switch (border) {
            default: {
                lineCanvas.moveTo(rect.getLeft(), rect.getBottom());
                lineCanvas.lineTo(rect.getRight(), rect.getBottom());
                break;
            }
            case RIGHT: {
                lineCanvas.moveTo(rect.getRight(), rect.getBottom());
                lineCanvas.lineTo(rect.getRight(), rect.getTop());
                break;
            }
            case TOP: {
                lineCanvas.moveTo(rect.getLeft(), rect.getTop());
                lineCanvas.lineTo(rect.getRight(), rect.getTop());
                break;
            }
            case LEFT: {
                lineCanvas.moveTo(rect.getLeft(), rect.getBottom());
                lineCanvas.lineTo(rect.getLeft(), rect.getTop());
            }
        }
    }

    private void setStyle(SCellStyle style) {
        this.style = style;
    }

    private void setPrintGridLines(boolean printGridLines) {
        this.printGridLines = printGridLines;
    }

    private boolean isPrintGridLines() {
        return this.printGridLines;
    }

    private void setPrintOutline(boolean printOutline) {
        this.printOutline = printOutline;
    }

    private boolean isPrintOutline() {
        return this.printOutline;
    }

    private void setPixelInfo(PixelInfo pixelInfo) {
        this.pixelInfo = pixelInfo;
    }

    private void drawFillPattern(Rectangle rect, SFill fill, PdfContentByte canvas) {
        int offsetX = this.pixelInfo.getOffsetX();
        int offsetY = this.pixelInfo.getOffsetY();
        int widthPx = this.pixelInfo.getWidth();
        int heightPx = this.pixelInfo.getHeight();
        byte[] rawData = FillImpl.getFillPatternBytes((SFill)fill, (int)offsetX, (int)offsetY, (int)widthPx, (int)heightPx);
        try {
            Image image = Image.getInstance((byte[])rawData);
            float width = rect.getWidth();
            float height = rect.getHeight();
            float x = rect.getLeft();
            float y = rect.getBottom();
            image.scaleAbsolute(width, height);
            image.setAbsolutePosition(x, y);
            canvas.addImage(image);
        }
        catch (BadElementException e) {
            log.error("Failed to get image instance", (Throwable)e);
        }
        catch (DocumentException e) {
            log.error("Failed to add image to canvas", (Throwable)e);
        }
        catch (IOException e) {
            log.error("Failed to get image instance", (Throwable)e);
        }
    }

    private static enum BORDER {
        TOP,
        RIGHT,
        BOTTOM,
        LEFT,
        BACKGROUND;


        Object getType(SCellStyle cellStyle) {
            switch (this) {
                case TOP: {
                    return cellStyle.getBorderTop();
                }
                case RIGHT: {
                    return cellStyle.getBorderRight();
                }
                case BOTTOM: {
                    return cellStyle.getBorderBottom();
                }
                case LEFT: {
                    return cellStyle.getBorderLeft();
                }
                case BACKGROUND: {
                    return cellStyle.getFillPattern();
                }
            }
            throw new RuntimeException();
        }

        SColor getColor(SCellStyle cellStyle) {
            switch (this) {
                case TOP: {
                    return cellStyle.getBorderTopColor();
                }
                case RIGHT: {
                    return cellStyle.getBorderRightColor();
                }
                case BOTTOM: {
                    return cellStyle.getBorderBottomColor();
                }
                case LEFT: {
                    return cellStyle.getBorderLeftColor();
                }
                case BACKGROUND: {
                    return cellStyle.getBackColor();
                }
            }
            throw new RuntimeException();
        }
    }

    private class BorderInfo {
        final Object type;
        final BorderStyle style;
        final String htmlColor;

        BorderInfo(Object borderType, SColor borderColor) {
            this.type = borderType;
            this.style = borderType instanceof SBorder.BorderType ? StyleConversionUtil.getBorderStyle((SBorder.BorderType)borderType) : null;
            this.htmlColor = borderColor.getHtmlColor();
        }
    }
}

