/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.importer;

import org.apache.poi.ss.util.CellReference;

class ImportPhase {
    static final String XLSX = "xlsx";
    static final String STYLE_SHEET = "stylesheet";
    static final String EXTERNAL_BOOK_REFERENCE = "external book reference";
    static final String WORKBOOK_PROTECTION = "workbook protection";
    static final String NAMED_RANGE = "named range";
    static final String SHEETS = "sheets";
    static final String SHEET = "sheet";
    static final String SHEET_FORMAT = "sheet format";
    static final String SHEET_VIEW = "sheet view";
    static final String TABLE = "table named %s";
    static final String TABLE_STYLE = "style of table named %s";
    static final String TABLE_AUTO_FILTER = "auto filter of table named %s";
    static final String TABLE_COLUMN = "table column %s[%s]";
    static final String HYPERLINK = "hyperlink";
    static final String VML_DRAWING = "VML drawing";
    static final String COMMENT = "comment";
    static final String ROW = "row";
    static final String COL = "column";
    static final String CELL = "cell";
    static final String MERGED_CELL = "merged cell";
    static final String DRAWING = "drawing";
    static final String CHART = "chart";
    static final String PICTURE = "picture";
    static final String DATA_VALIDATION = "data validation";
    static final String AUTO_FILTER = "auto filter";
    static final String SHEET_PROTECTION = "sheet protection";
    static final String CONDITIONAL_FORMATTING = "conditional formatting";
    static final String PRINT_AREA = "print area";
    static final String EXT_LST = "extLst";
    private final String _bookName;
    private String _phase;
    private String _sheetName;
    private String _tableName;
    private String _tableColumnName;
    private int _colIndex = -1;
    private int _rowIndex = -1;

    public ImportPhase(String bookName) {
        this._bookName = bookName;
    }

    void setPhase(String phase) {
        this._phase = phase;
    }

    void setSheetName(String sheetName) {
        this._sheetName = sheetName;
    }

    void setRowIndex(int rowIndex) {
        this._rowIndex = rowIndex;
    }

    void setColIndex(int colIndex) {
        this._colIndex = colIndex;
    }

    void setTableName(String tableName) {
        this._tableName = tableName;
    }

    void setTableColumnName(String tableColumnName) {
        this._tableColumnName = tableColumnName;
    }

    public String toString() {
        return this.appendSheetAndBookName(this.toPhaseMessage()).toString();
    }

    void clear() {
        this._phase = null;
        this._sheetName = null;
        this._tableName = null;
        this._tableColumnName = null;
        this._rowIndex = -1;
        this._colIndex = -1;
    }

    private StringBuilder toPhaseMessage() {
        StringBuilder sb = new StringBuilder();
        if (this._phase == null) {
            return sb.append(XLSX);
        }
        switch (this._phase) {
            case "table named %s": 
            case "auto filter of table named %s": 
            case "style of table named %s": {
                sb.append(String.format(this._phase, this._tableName));
                break;
            }
            case "table column %s[%s]": {
                sb.append(String.format(this._phase, this._tableName, this._tableColumnName));
                break;
            }
            case "column": {
                sb.append(this._phase);
                if (this._colIndex == -1) break;
                sb.append(" ").append(CellReference.convertNumToColString((int)this._colIndex));
                break;
            }
            case "row": {
                sb.append(this._phase);
                if (this._rowIndex == -1) break;
                sb.append(" ").append(this._rowIndex + 1);
                break;
            }
            case "cell": {
                sb.append(this._phase);
                if (this._colIndex != -1) {
                    sb.append(" ").append(CellReference.convertNumToColString((int)this._colIndex));
                }
                if (this._rowIndex == -1) break;
                sb.append(this._rowIndex + 1);
                break;
            }
            default: {
                sb.append(this._phase);
            }
        }
        return sb;
    }

    private StringBuilder appendSheetAndBookName(StringBuilder sb) {
        if (this._sheetName != null) {
            sb.append(" in sheet ");
            sb.append(this._sheetName);
        }
        if (this._bookName != null) {
            sb.append(" from book ");
            sb.append(this._bookName);
        }
        return sb;
    }
}

