/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.CellRegion;
import io.keikai.model.InvalidFormulaException;
import io.keikai.model.SBook;
import io.keikai.model.SBookSeries;
import io.keikai.model.SCFValueObject;
import io.keikai.model.SCell;
import io.keikai.model.SColor;
import io.keikai.model.SColorScale;
import io.keikai.model.SConditionalFormatting;
import io.keikai.model.SConditionalFormattingRule;
import io.keikai.model.SDataBar;
import io.keikai.model.SExtraStyle;
import io.keikai.model.SFill;
import io.keikai.model.SIconSet;
import io.keikai.model.SName;
import io.keikai.model.SSheet;
import io.keikai.model.impl.AbstractBookSeriesAdv;
import io.keikai.model.impl.AbstractCellAdv;
import io.keikai.model.impl.AbstractNameAdv;
import io.keikai.model.impl.CFValueObjectHelper;
import io.keikai.model.impl.CellValue;
import io.keikai.model.impl.ColorImpl;
import io.keikai.model.impl.ColorScaleImpl;
import io.keikai.model.impl.ConditionalRefImpl;
import io.keikai.model.impl.DataBarImpl;
import io.keikai.model.impl.ExtraFillImpl;
import io.keikai.model.impl.IconSetImpl;
import io.keikai.model.impl.ImmutableExtraStyleImpl;
import io.keikai.model.impl.NameRefImpl;
import io.keikai.model.impl.RefImpl;
import io.keikai.model.impl.RuleInfo;
import io.keikai.model.impl.sys.formula.ParsingBook;
import io.keikai.model.sys.EngineFactory;
import io.keikai.model.sys.dependency.DependencyTable;
import io.keikai.model.sys.dependency.Ref;
import io.keikai.model.sys.formula.FormulaEngine;
import io.keikai.model.sys.formula.FormulaExpression;
import io.keikai.model.sys.formula.FormulaParseContext;
import io.keikai.model.sys.formula.FormulaType;
import io.keikai.model.sys.input.InputEngine;
import io.keikai.model.sys.input.InputParseContext;
import io.keikai.model.sys.input.InputResult;
import io.keikai.model.util.Validations;
import io.keikai.range.impl.CellMatch2;
import io.keikai.range.impl.ContainsBlank;
import io.keikai.range.impl.ContainsError;
import io.keikai.range.impl.DatesMatch2;
import io.keikai.range.impl.DuplicateCell;
import io.keikai.range.impl.ExpressionMatch;
import io.keikai.range.impl.Matchable;
import io.keikai.range.impl.NumMatch;
import io.keikai.range.impl.TrueMatch;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.text.Format;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.formula.EvaluationWorkbook;
import org.apache.poi.ss.formula.ptg.Area3DPtg;
import org.apache.poi.ss.formula.ptg.AreaPtg;
import org.apache.poi.ss.formula.ptg.BoolPtg;
import org.apache.poi.ss.formula.ptg.ErrPtg;
import org.apache.poi.ss.formula.ptg.IntPtg;
import org.apache.poi.ss.formula.ptg.NamePtg;
import org.apache.poi.ss.formula.ptg.NumberPtg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.formula.ptg.Ref3DPtg;
import org.apache.poi.ss.formula.ptg.RefPtg;
import org.apache.poi.ss.formula.ptg.StringPtg;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.ZssContext;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.zkoss.lang.Strings;

public class ConditionalFormattingRuleImpl
implements SConditionalFormattingRule,
Serializable {
    private static final long serialVersionUID = 5733467761359067350L;
    private SConditionalFormattingRule.RuleType type;
    private SConditionalFormattingRule.RuleOperator operator;
    private Integer priority;
    private SExtraStyle style;
    private boolean stopIfTrue;
    private SConditionalFormattingRule.RuleTimePeriod timePeriod;
    private Long rank;
    private boolean percent;
    private boolean bottom;
    private SColorScale colorScale;
    private SDataBar dataBar;
    private SIconSet iconSet;
    private String text;
    private boolean notAboveAverage;
    private boolean equalAverage;
    private Integer standardDeviation;
    private FormulaExpression _formula1Expr;
    private FormulaExpression _formula2Expr;
    private FormulaExpression _formula3Expr;
    private Matchable<SCell> _matchable;
    private CFValueObjectHelper _voHelper;
    private boolean _underExt;
    private String _id;
    private String _extId;
    private Double _min;
    private Double _middle;
    private Double _max;
    private IconSetInfo[] _iconSetInfos;
    private Map<Double, SFill> _colorScaleCache;
    private RuleInfo _ruleInfo1;
    private RuleInfo _ruleInfo2;
    private SConditionalFormatting _cfi;

    public ConditionalFormattingRuleImpl(SConditionalFormatting cfi) {
        this._cfi = cfi;
    }

    @Override
    public SConditionalFormatting getFormatting() {
        return this._cfi;
    }

    @Override
    public SSheet getSheet() {
        return this._cfi.getSheet();
    }

    @Override
    public void clearFormulaResultCache() {
        this._matchable = null;
        this._middle = null;
        this._max = null;
        this._min = null;
        this._iconSetInfos = null;
        this._voHelper = null;
        this._colorScaleCache = null;
        this._ruleInfo2 = null;
        this._ruleInfo1 = null;
    }

    @Override
    public SConditionalFormattingRule.RuleType getType() {
        return this.type;
    }

    public void setType(SConditionalFormattingRule.RuleType type) {
        this.type = type;
    }

    @Override
    public SConditionalFormattingRule.RuleOperator getOperator() {
        return this.operator;
    }

    public void setOperator(SConditionalFormattingRule.RuleOperator operator) {
        this.operator = operator;
    }

    @Override
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public SExtraStyle getExtraStyle() {
        return this.style;
    }

    public void setExtraStyle(SExtraStyle style) {
        this.style = style;
    }

    @Override
    public boolean isStopIfTrue() {
        return this.stopIfTrue;
    }

    public void setStopIfTrue(boolean b) {
        this.stopIfTrue = b;
    }

    @Override
    public SConditionalFormattingRule.RuleTimePeriod getTimePeriod() {
        return this.timePeriod;
    }

    public void setTimePeriod(SConditionalFormattingRule.RuleTimePeriod timePeriod) {
        this.timePeriod = timePeriod;
    }

    @Override
    public Long getRank() {
        return this.rank;
    }

    public void setRank(long rank) {
        this.rank = rank;
    }

    @Override
    public boolean isPercent() {
        return this.percent;
    }

    public void setPercent(boolean b) {
        this.percent = b;
    }

    @Override
    public boolean isBottom() {
        return this.bottom;
    }

    public void setBottom(boolean b) {
        this.bottom = b;
    }

    @Override
    public SColorScale getColorScale() {
        return this.colorScale;
    }

    public void setColorScale(SColorScale colorScale) {
        this.colorScale = colorScale;
    }

    @Override
    public SDataBar getDataBar() {
        return this.dataBar;
    }

    public void setDataBar(SDataBar dataBar) {
        this.dataBar = dataBar;
    }

    @Override
    public SIconSet getIconSet() {
        return this.iconSet;
    }

    public void setIconSet(SIconSet iconSet) {
        this.iconSet = iconSet;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public boolean isAboveAverage() {
        return !this.notAboveAverage;
    }

    public void setAboveAverage(boolean b) {
        this.notAboveAverage = !b;
    }

    @Override
    public boolean isEqualAverage() {
        return this.equalAverage;
    }

    public void setEqualAverage(boolean b) {
        this.equalAverage = b;
    }

    @Override
    public Integer getStandardDeviation() {
        return this.standardDeviation;
    }

    public void setStandardDeviation(int s) {
        this.standardDeviation = s;
    }

    public boolean match(SCell cell) {
        if (this._matchable != null) {
            return this._matchable.match(cell);
        }
        SConditionalFormattingRule.RuleOperator op1 = null;
        SConditionalFormattingRule.RuleOperator op2 = null;
        SConditionalFormattingRule.RuleOperator op = this.getOperator();
        boolean isAnd = true;
        List<SCFValueObject> vos = null;
        switch (this.type) {
            case BEGINS_WITH: 
            case ENDS_WITH: 
            case CONTAINS_TEXT: 
            case NOT_CONTAINS_TEXT: {
                op1 = op;
                op2 = null;
                if (this.text != null) {
                    this._matchable = new CellMatch2(op1, this.text);
                    break;
                }
                CellRegion region = this.getRegions().iterator().next();
                int row0 = region.row;
                int col0 = region.column;
                this._ruleInfo1 = new RuleInfo(this.getSheet(), this, this._formula2Expr, row0, col0);
                this._matchable = new CellMatch2(op1, this._ruleInfo1, op2, null, isAnd);
                break;
            }
            case CELL_IS: {
                switch (op) {
                    case BETWEEN: {
                        op1 = SConditionalFormattingRule.RuleOperator.GREATER_THAN_OR_EQUAL;
                        op2 = SConditionalFormattingRule.RuleOperator.LESS_THAN_OR_EQUAL;
                        break;
                    }
                    case NOT_BETWEEN: {
                        op1 = SConditionalFormattingRule.RuleOperator.LESS_THAN;
                        op2 = SConditionalFormattingRule.RuleOperator.GREATER_THAN;
                        isAnd = false;
                        break;
                    }
                    default: {
                        op1 = op;
                        op2 = null;
                    }
                }
                CellRegion region = this.getRegions().iterator().next();
                int row0 = region.row;
                int col0 = region.column;
                this._ruleInfo1 = new RuleInfo(this.getSheet(), this, this._formula1Expr, row0, col0);
                this._ruleInfo2 = op2 == null ? null : new RuleInfo(this.getSheet(), this, this._formula2Expr, row0, col0);
                this._matchable = new CellMatch2(op1, this._ruleInfo1, op2, this._ruleInfo2, isAnd);
                break;
            }
            case CONTAINS_BLANKS: {
                this._matchable = new ContainsBlank(false);
                break;
            }
            case NOT_CONTAINS_BLANKS: {
                this._matchable = new ContainsBlank(true);
                break;
            }
            case CONTAINS_ERRORS: {
                this._matchable = new ContainsError(false);
                break;
            }
            case NOT_CONTAINS_ERRORS: {
                this._matchable = new ContainsError(true);
                break;
            }
            case ABOVE_AVERAGE: {
                double[] avg_stdv = this._calcAverageStdv();
                double avg = avg_stdv[0];
                double stdv = avg_stdv[1] * (double)(this.standardDeviation == null ? 0 : this.standardDeviation);
                SConditionalFormattingRule.RuleOperator opx = this.notAboveAverage ? (this.equalAverage ? SConditionalFormattingRule.RuleOperator.LESS_THAN_OR_EQUAL : SConditionalFormattingRule.RuleOperator.LESS_THAN) : (this.equalAverage ? SConditionalFormattingRule.RuleOperator.GREATER_THAN_OR_EQUAL : SConditionalFormattingRule.RuleOperator.GREATER_THAN);
                double val = this.notAboveAverage ? avg - stdv : avg + stdv;
                CellRegion region = this.getRegions().iterator().next();
                int row0 = region.row;
                int col0 = region.column;
                FormulaExpression expr = this.parseFormula("" + val);
                this._ruleInfo1 = new RuleInfo(this.getSheet(), this, expr, row0, col0);
                this._matchable = new CellMatch2(opx, this._ruleInfo1, null, null, false);
                break;
            }
            case TOP_10: {
                Double top10Val = this._pickTop10();
                SConditionalFormattingRule.RuleOperator opx = !this.bottom ? SConditionalFormattingRule.RuleOperator.GREATER_THAN_OR_EQUAL : SConditionalFormattingRule.RuleOperator.LESS_THAN_OR_EQUAL;
                CellRegion region = this.getRegions().iterator().next();
                int row0 = region.row;
                int col0 = region.column;
                FormulaExpression expr = this.parseFormula("" + top10Val);
                this._ruleInfo1 = new RuleInfo(this.getSheet(), this, expr, row0, col0);
                this._matchable = new CellMatch2(opx, this._ruleInfo1, null, null, false);
                break;
            }
            case DUPLICATE_VALUES: {
                Set<String> dupSet = this._calcDuplicate();
                this._matchable = new DuplicateCell(dupSet, false);
                break;
            }
            case UNIQUE_VALUES: {
                Set<String> dupSet = this._calcDuplicate();
                this._matchable = new DuplicateCell(dupSet, true);
                break;
            }
            case TIME_PERIOD: {
                double[] res = switch (this.timePeriod) {
                    case SConditionalFormattingRule.RuleTimePeriod.TOMORROW -> DateUtil.calcTomorrow();
                    case SConditionalFormattingRule.RuleTimePeriod.TODAY -> DateUtil.calcToday();
                    case SConditionalFormattingRule.RuleTimePeriod.YESTERDAY -> DateUtil.calcYesterday();
                    case SConditionalFormattingRule.RuleTimePeriod.LAST_7_DAYS -> DateUtil.calcLast7Days();
                    case SConditionalFormattingRule.RuleTimePeriod.NEXT_WEEK -> DateUtil.calcNextWeek();
                    case SConditionalFormattingRule.RuleTimePeriod.THIS_WEEK -> DateUtil.calcThisWeek();
                    case SConditionalFormattingRule.RuleTimePeriod.LAST_WEEK -> DateUtil.calcLastWeek();
                    case SConditionalFormattingRule.RuleTimePeriod.NEXT_MONTH -> DateUtil.calcNextMonth();
                    case SConditionalFormattingRule.RuleTimePeriod.THIS_MONTH -> DateUtil.calcThisMonth();
                    case SConditionalFormattingRule.RuleTimePeriod.LAST_MONTH -> DateUtil.calcLastMonth();
                    default -> new double[]{0.0, 0.0};
                };
                this._matchable = new DatesMatch2((int)res[0], (int)res[1]);
                break;
            }
            case EXPRESSION: {
                CellRegion region = this.getRegions().iterator().next();
                int row0 = region.row;
                int col0 = region.column;
                this._ruleInfo1 = new RuleInfo(this.getSheet(), this, this._formula1Expr, row0, col0);
                this._matchable = new ExpressionMatch(this._ruleInfo1);
                break;
            }
            case COLOR_SCALE: {
                if (this._min != null) break;
                vos = this.colorScale.getCFValueObjects();
                if (this._prepareMinMax(vos)) {
                    this._matchable = new NumMatch();
                    break;
                }
                this._matchable = new TrueMatch(false);
                break;
            }
            case DATA_BAR: {
                if (this._min != null) break;
                vos = this.dataBar.getCFValueObjects();
                if (this._prepareMinMax(vos)) {
                    this._matchable = new NumMatch();
                    break;
                }
                this._matchable = new TrueMatch(false);
                break;
            }
            case ICON_SET: {
                if (this._iconSetInfos != null) break;
                vos = this.iconSet.getCFValueObjects();
                this._matchable = this._prepareSteps(vos) ? new NumMatch() : new TrueMatch(false);
            }
        }
        return this._matchable.match(cell);
    }

    private boolean _prepareMinMax(List<SCFValueObject> vos) {
        if (vos != null) {
            this._prepareVoHelper();
            Double[] min_max = this._voHelper.calcMinMax(vos);
            if (min_max == null) {
                return false;
            }
            int len = min_max.length;
            this._min = min_max[0];
            switch (len) {
                case 2: {
                    this._middle = null;
                    this._max = min_max[1];
                    break;
                }
                case 3: {
                    this._middle = min_max[1];
                    this._max = min_max[2];
                }
            }
            return true;
        }
        return false;
    }

    private boolean _prepareSteps(List<SCFValueObject> vos) {
        if (vos != null) {
            this._prepareVoHelper();
            Double[] min_max = this._voHelper.calcMinMax(vos);
            if (min_max == null) {
                return false;
            }
            int len = min_max.length;
            this._iconSetInfos = new IconSetInfo[len];
            for (int j = 0; j < len; ++j) {
                this._iconSetInfos[j] = new IconSetInfo(min_max[j], vos.get(j).isGreaterOrEqual());
            }
            return true;
        }
        return false;
    }

    private void _prepareVoHelper() {
        if (this._voHelper == null) {
            this._voHelper = new CFValueObjectHelper(this);
        }
    }

    private double[] _calcAverageStdv() {
        double a = 0.0;
        double q = 0.0;
        int k = 0;
        for (CellRegion region : this.getRegions()) {
            int left = region.column;
            int right = region.lastColumn;
            int top = region.row;
            int bottom = region.lastRow;
            for (int r = top; r <= bottom; ++r) {
                for (int col = left; col <= right; ++col) {
                    SCell cell = this.getSheet().getCell(r, col);
                    CellValue cellval = ((AbstractCellAdv)cell).getEvalCellValue(true);
                    if (cellval.getType() != SCell.CellType.NUMBER) continue;
                    double x = ((Number)cellval.getValue()).doubleValue();
                    double ak_1 = a;
                    a = ak_1 + (x - ak_1) / (double)(++k);
                    q += (x - ak_1) * (x - a);
                }
            }
        }
        return new double[]{a, Math.sqrt(q / (double)k)};
    }

    private Double _pickTop10() {
        if (this.rank <= 0L) {
            return null;
        }
        boolean isTop = !this.bottom;
        boolean isPercent = this.percent;
        this._prepareVoHelper();
        return this._voHelper.pickTopX(isTop, isPercent, this.rank.longValue());
    }

    private Set<String> _calcDuplicate() {
        HashMap<CellValue, CallSite> values = new HashMap<CellValue, CallSite>();
        HashSet<String> keys = new HashSet<String>();
        for (CellRegion region : this.getRegions()) {
            int left = region.column;
            int right = region.lastColumn;
            int top = region.row;
            int bottom = region.lastRow;
            for (int row = top; row <= bottom; ++row) {
                for (int col = left; col <= right; ++col) {
                    String val;
                    SCell cell = this.getSheet().getCell(row, col);
                    CellValue cellval = ((AbstractCellAdv)cell).getEvalCellValue(true);
                    String string = val = cellval == null ? null : (String)values.get(cellval);
                    if (val != null) {
                        keys.add(val);
                        keys.add(row + "_" + col);
                        continue;
                    }
                    if (cellval == null || cellval.getType() == SCell.CellType.BLANK) continue;
                    values.put(cellval, (CallSite)((Object)(row + "_" + col)));
                }
            }
        }
        return keys;
    }

    @Override
    public void destroy() {
        this.clearFormulaDependency(true);
        this.clearFormulaResultCache();
    }

    @Override
    public Collection<CellRegion> getRegions() {
        return this._cfi.getRegions();
    }

    @Override
    public boolean isFormulaParsingError() {
        boolean r = false;
        if (this._formula1Expr != null) {
            r |= this._formula1Expr.hasError();
        }
        if (!r && this._formula2Expr != null) {
            r |= this._formula2Expr.hasError();
        }
        if (!r && this._formula3Expr != null) {
            r |= this._formula3Expr.hasError();
        }
        return r;
    }

    @Override
    public String getFormula1() {
        return this._unescapeFromPoi(this._formula1Expr);
    }

    @Override
    public String getFormula2() {
        return this._unescapeFromPoi(this._formula2Expr);
    }

    @Override
    public String getFormula3() {
        return this._unescapeFromPoi(this._formula3Expr);
    }

    private void clearFormulaDependency(boolean all) {
        if (this._formula1Expr != null || this._formula2Expr != null || this._formula3Expr != null) {
            Ref dependent = this.getRef();
            DependencyTable dt = ((AbstractBookSeriesAdv)this.getSheet().getBook().getBookSeries()).getDependencyTable();
            dt.clearDependents(dependent);
            if (!all && this.getRegions() != null) {
                for (CellRegion regn : this.getRegions()) {
                    dt.add(dependent, this.newDummyRef(this.getSheet().getSheetName(), regn));
                }
            }
        }
    }

    private Ref getRef() {
        return new ConditionalRefImpl(this._cfi);
    }

    public Ref getRef(String sheetName) {
        return new ConditionalRefImpl(this.getSheet().getBook().getBookName(), sheetName, this._cfi.getId());
    }

    private Ref newDummyRef(String sheetName, CellRegion regn) {
        return new RefImpl(this.getSheet().getBook().getBookName(), sheetName, regn.row, regn.column, regn.lastRow, regn.lastColumn);
    }

    @Override
    public void setFormula1(String formula1) {
        formula1 = this._escapeToPoi(formula1);
        this.setEscapedFormulas(formula1, this.getEscapedFormula2(), this.getEscapedFormula3());
    }

    @Override
    public void setFormula2(String formula2) {
        formula2 = this._escapeToPoi(formula2);
        this.setEscapedFormulas(this.getEscapedFormula1(), formula2, this.getEscapedFormula3());
    }

    @Override
    public void setFormula3(String formula3) {
        formula3 = this._escapeToPoi(formula3);
        this.setEscapedFormulas(this.getEscapedFormula1(), this.getEscapedFormula2(), formula3);
    }

    private boolean isLiteralPtg(Ptg ptg) {
        return ptg instanceof BoolPtg || ptg instanceof IntPtg || ptg instanceof NumberPtg || ptg instanceof StringPtg || ptg instanceof ErrPtg;
    }

    private String _unescapeFromPoi(FormulaExpression expr) {
        if (expr == null) {
            return null;
        }
        String formula = expr.getFormulaString();
        Ptg[] ptgs = expr.getPtgs();
        if (Strings.isBlank((String)formula)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (!(formula.startsWith("\"") || formula.length() <= 1 || ptgs.length <= 1 && this.isLiteralPtg(ptgs[0]))) {
            return sb.append("=").append(formula).toString();
        }
        return "=" + formula;
    }

    private String _escapeToPoi(String formula) {
        if (Strings.isBlank((String)formula)) {
            return null;
        }
        if (!"\"\"".equals(formula) && formula.startsWith("\"\"") && formula.endsWith("\"\"") && !formula.startsWith("\"\"\"") && !formula.endsWith("\"\"\"")) {
            StringBuilder sb = new StringBuilder();
            int pre = -2;
            for (int j = 0; j < formula.length(); ++j) {
                char ch = formula.charAt(j);
                if (ch == '\"') {
                    if (pre == j - 1) continue;
                    pre = j;
                }
                sb.append(ch);
            }
            formula = sb.toString();
        }
        InputResult input = this.parseInput(formula);
        switch (input.getType()) {
            case FORMULA: {
                return formula.substring(1);
            }
            case STRING: {
                return formula;
            }
            case NUMBER: {
                Object val = input.getValue();
                double num = val instanceof Date ? EngineFactory.getInstance().getCalendarUtil().dateToDoubleValue((Date)val) : ((Number)val).doubleValue();
                return this.getNumLocaleString(num);
            }
        }
        return formula;
    }

    private InputResult parseInput(String formula) {
        InputEngine ie = EngineFactory.getInstance().createInputEngine();
        return ie.parseInput(formula == null ? "" : formula, "General", new InputParseContext(ZssContext.getCurrent().getLocale()));
    }

    public FormulaExpression parseFormula(String formula) {
        FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
        Locale locale = ZssContext.getCurrent().getLocale();
        SSheet sheet = this.getSheet();
        FormulaParseContext formulaCtx = new FormulaParseContext(sheet.getBook(), sheet, null, sheet.getSheetName(), null, locale, FormulaType.CELL);
        FormulaExpression expr = fe.parse(formula, formulaCtx);
        if (expr.hasError()) {
            String msg = expr.getErrorMessage();
            throw new InvalidFormulaException((String)(msg == null ? "The formula =" + formula + " contains error" : msg));
        }
        return expr;
    }

    @Override
    public void setFormulas(String formula1, String formula2, String formula3) {
        formula1 = this._escapeToPoi(formula1);
        formula2 = this._escapeToPoi(formula2);
        formula3 = this._escapeToPoi(formula3);
        this.setEscapedFormulas(formula1, formula2, formula3);
    }

    @Override
    public void setEscapedFormulas(String formula1, String formula2, String formula3) {
        this.clearFormulaDependency(false);
        this.clearFormulaResultCache();
        this._formula1Expr = formula1 != null ? this.parseFormula(formula1) : null;
        this._formula2Expr = formula2 != null ? this.parseFormula(formula2) : null;
        this._formula3Expr = formula3 != null ? this.parseFormula(formula3) : null;
    }

    @Override
    public void copyFrom(SConditionalFormattingRule src, int rowOff, int colOff) {
        Validations.argInstance(src, ConditionalFormattingRuleImpl.class);
        ConditionalFormattingRuleImpl srcImpl = (ConditionalFormattingRuleImpl)src;
        SBook book = this.getSheet().getBook();
        this.type = srcImpl.type;
        this.operator = srcImpl.operator;
        this.style = srcImpl.style != null ? (SExtraStyle)((ImmutableExtraStyleImpl)srcImpl.style).cloneCellStyle(book) : null;
        this.timePeriod = srcImpl.timePeriod;
        this.rank = srcImpl.rank;
        this.percent = srcImpl.percent;
        this.bottom = srcImpl.bottom;
        this.colorScale = srcImpl.colorScale != null ? ((ColorScaleImpl)srcImpl.colorScale).cloneColorScale(book) : null;
        this.dataBar = srcImpl.dataBar != null ? ((DataBarImpl)srcImpl.dataBar).cloneDataBar(book) : null;
        this.iconSet = srcImpl.iconSet != null ? ((IconSetImpl)srcImpl.iconSet).cloneIconSet() : null;
        this.text = srcImpl.text;
        this.notAboveAverage = srcImpl.notAboveAverage;
        this.equalAverage = srcImpl.equalAverage;
        this.standardDeviation = srcImpl.standardDeviation;
        if (srcImpl.priority != null) {
            this.priority = srcImpl.priority + 1;
        }
        this.shiftFormulas(srcImpl._formula1Expr, srcImpl._formula2Expr, srcImpl._formula3Expr, rowOff, colOff);
    }

    ConditionalFormattingRuleImpl cloneConditionalFormattingRule(SConditionalFormatting cfi, SSheet sheet) {
        ConditionalFormattingRuleImpl tgt = new ConditionalFormattingRuleImpl(cfi);
        SBook book = sheet.getBook();
        tgt.priority = this.priority;
        tgt.type = this.type;
        tgt.operator = this.operator;
        tgt.style = this.style;
        tgt.timePeriod = this.timePeriod;
        tgt.rank = this.rank;
        tgt.percent = this.percent;
        tgt.bottom = this.bottom;
        if (this.colorScale != null) {
            tgt.colorScale = ((ColorScaleImpl)this.colorScale).cloneColorScale(book);
        }
        if (this.dataBar != null) {
            tgt.dataBar = ((DataBarImpl)this.dataBar).cloneDataBar(book);
        }
        if (this.iconSet != null) {
            tgt.iconSet = ((IconSetImpl)this.iconSet).cloneIconSet();
        }
        tgt.text = this.text;
        tgt.notAboveAverage = this.notAboveAverage;
        tgt.equalAverage = this.equalAverage;
        tgt.standardDeviation = this.standardDeviation;
        String f1 = this.getEscapedFormula1();
        if (f1 != null) {
            String f2 = this.getEscapedFormula2();
            String f3 = this.getEscapedFormula3();
            tgt.setEscapedFormulas(f1, f2, f3);
        }
        return tgt;
    }

    public void setFormulas(FormulaExpression fe1, FormulaExpression fe2, FormulaExpression fe3) {
        this.clearFormulaDependency(false);
        this.clearFormulaResultCache();
        this._formula1Expr = fe1;
        this._formula2Expr = fe2;
        this._formula3Expr = fe3;
    }

    public FormulaExpression getFormulaExpression1() {
        return this._formula1Expr;
    }

    public FormulaExpression getFormulaExpression2() {
        return this._formula2Expr;
    }

    public FormulaExpression getFormulaExpression3() {
        return this._formula3Expr;
    }

    public void setFormula1(FormulaExpression formula1) {
        this.setFormulas(formula1, this._formula2Expr, this._formula3Expr);
    }

    public void setFormula2(FormulaExpression formula2) {
        this.setFormulas(this._formula1Expr, formula2, this._formula3Expr);
    }

    public void setFormula3(FormulaExpression formula3) {
        this.setFormulas(this._formula1Expr, this._formula2Expr, formula3);
    }

    @Override
    public String getEscapedFormula1() {
        return this._formula1Expr == null ? null : this._formula1Expr.getFormulaString();
    }

    @Override
    public String getEscapedFormula2() {
        return this._formula2Expr == null ? null : this._formula2Expr.getFormulaString();
    }

    @Override
    public String getEscapedFormula3() {
        return this._formula3Expr == null ? null : this._formula3Expr.getFormulaString();
    }

    private String getNumLocaleString(final double num) {
        Locale locale = ZssContext.getCurrent().getLocale();
        DataFormatter df = new DataFormatter(locale);
        Format format = df.getDefaultFormat((Cell)new SXSSFCell(null, CellType.NUMERIC){

            public double getNumericCellValue() {
                return num;
            }
        });
        return format.format(num);
    }

    public SFill getColorScaleFill(Double value0) {
        SFill f;
        if (this._colorScaleCache == null) {
            this._colorScaleCache = new HashMap<Double, SFill>();
        }
        if ((f = this._colorScaleCache.get(value0)) != null) {
            return f;
        }
        f = this._getColorScaleFill(value0);
        this._colorScaleCache.put(value0, f);
        return f;
    }

    public double getDataBarPercent(Double value) {
        double min = this._min;
        double max = this._max;
        int maxlen = this.dataBar.getMaxLength();
        int minlen = this.dataBar.getMinLength();
        int difflen = maxlen - minlen;
        double diff0 = max - min;
        if (diff0 == 0.0) {
            return max == 0.0 ? (double)minlen : (double)maxlen;
        }
        if (value <= min) {
            return minlen;
        }
        return (double)minlen + (value - min) / diff0 * (double)difflen;
    }

    public int getIconSetId(Double value) {
        int j = this._iconSetInfos.length;
        while (--j >= 0) {
            IconSetInfo info = this._iconSetInfos[j];
            double val = info.value;
            boolean gte = info.gte;
            if (!(gte ? value >= val : value > val)) continue;
            return j;
        }
        return 0;
    }

    private SFill _getColorScaleFill(double value) {
        double mid;
        SColor color = null;
        List<SColor> colors = this.colorScale.getColors();
        SColor minColor = colors.get(0);
        SColor maxColor = colors.get(colors.size() - 1);
        double min = this._min;
        double max = this._max;
        double d = mid = this._middle == null ? 0.0 : this._middle;
        if (value >= max) {
            color = maxColor;
        } else if (value <= min) {
            color = minColor;
        } else if (this._middle != null) {
            SColor midColor = colors.get(1);
            color = value < mid ? this._calcColor(value, min, mid, minColor, midColor) : (value > mid ? this._calcColor(value, mid, max, midColor, maxColor) : colors.get(1));
        } else {
            color = this._calcColor(value, min, max, minColor, maxColor);
        }
        return color == null ? null : new ExtraFillImpl(SFill.FillPattern.SOLID, color, color);
    }

    private SColor _calcColor(double value, double min, double max, SColor minColor, SColor maxColor) {
        double diff0 = max - min;
        double diff = value - min;
        byte[] maxRgb = maxColor.getRGB();
        byte[] minRgb = minColor.getRGB();
        int r0 = minRgb[0] & 0xFF;
        int g0 = minRgb[1] & 0xFF;
        int b0 = minRgb[2] & 0xFF;
        int r1 = maxRgb[0] & 0xFF;
        int g1 = maxRgb[1] & 0xFF;
        int b1 = maxRgb[2] & 0xFF;
        int rDiff0 = r1 - r0;
        int gDiff0 = g1 - g0;
        int bDiff0 = b1 - b0;
        int r = (int)Math.ceil((double)r0 + (double)rDiff0 * diff / diff0);
        int g = (int)Math.ceil((double)g0 + (double)gDiff0 * diff / diff0);
        int b = (int)Math.ceil((double)b0 + (double)bDiff0 * diff / diff0);
        return new ColorImpl((byte)r, (byte)g, (byte)b);
    }

    @Override
    public void shiftFormulas(int rowOff, int colOff) {
        this.shiftFormulas(this._formula1Expr, this._formula2Expr, this._formula3Expr, rowOff, colOff);
    }

    private void shiftFormulas(FormulaExpression f1, FormulaExpression f2, FormulaExpression f3, int rowOff, int colOff) {
        if (f1 != null) {
            FormulaExpression f1expr = null;
            FormulaExpression f2expr = null;
            FormulaExpression f3expr = null;
            if (rowOff != 0 || colOff != 0) {
                FormulaParseContext context;
                FormulaEngine engine = EngineFactory.getInstance().createFormulaEngine();
                if (f1 != null) {
                    context = new FormulaParseContext(this.getSheet(), this.getSheet().getSheetName(), null);
                    f1expr = engine.shiftPtgs(f1, rowOff, colOff, context);
                }
                if (f2 != null) {
                    context = new FormulaParseContext(this.getSheet(), this.getSheet().getSheetName(), null);
                    f2expr = engine.shiftPtgs(f2, rowOff, colOff, context);
                }
                if (f3 != null) {
                    context = new FormulaParseContext(this.getSheet(), this.getSheet().getSheetName(), null);
                    f3expr = engine.shiftPtgs(f3, rowOff, colOff, context);
                }
                this.setFormulas(f1expr, f2expr, f3expr);
            }
        }
    }

    public void addDependency(FormulaExpression fexpr) {
        String bookName = this.getSheet().getBook().getBookName();
        String sheetName = this.getSheet().getSheetName();
        CellRegion region0 = this.getRegions().iterator().next();
        int row0 = region0.row;
        int col0 = region0.column;
        for (CellRegion region : this.getRegions()) {
            int row1 = region.row;
            int col1 = region.column;
            int row1Off = row1 - row0;
            int col1Off = col1 - col0;
            int row2Off = region.getRowCount() - 1;
            int col2Off = region.getColumnCount() - 1;
            for (Ptg ptg : fexpr.getPtgs()) {
                Ref precedent = this.toPrecedentRef(bookName, sheetName, ptg, row1Off, col1Off, row2Off, col2Off);
                if (precedent == null) continue;
                this.addDependency(precedent);
            }
        }
    }

    private void addDependency(Ref precedent) {
        SBookSeries bs = this.getSheet().getBook().getBookSeries();
        DependencyTable dt = ((AbstractBookSeriesAdv)bs).getDependencyTable();
        Ref dependent = this.getRef();
        dt.add(dependent, precedent);
        dt.add(precedent, dependent);
    }

    private Ref toPrecedentRef(String bookName, String sheetName, Ptg ptg, int row1Off, int col1Off, int row2Off, int col2Off) {
        if (ptg instanceof Ref3DPtg) {
            Ref3DPtg rptg = (Ref3DPtg)ptg;
            boolean colRel = rptg.isColRelative();
            boolean rowRel = rptg.isRowRelative();
            int row1 = rptg.getRow() + (rowRel ? row1Off : 0);
            int col1 = rptg.getColumn() + (colRel ? col1Off : 0);
            int row2 = row1 + (rowRel ? row2Off : 0);
            int col2 = col1 + (colRel ? col2Off : 0);
            SSheet sheet = this._cfi.getSheet();
            SBook book = sheet.getBook();
            ParsingBook parsingBook = new ParsingBook(book);
            EvaluationWorkbook.ExternalSheetRange es = parsingBook.getAnyExternalSheet(rptg.getExternSheetIndex());
            String bookName0 = es.getWorkbookName() != null ? es.getWorkbookName() : sheet.getBook().getBookName();
            String sheetName0 = es.getSheetName();
            String lastSheetName0 = es.getLastSheetName().equals(sheetName0) ? null : es.getLastSheetName();
            return new RefImpl(bookName0, sheetName0, lastSheetName0, Math.min(row1, row2), Math.min(col1, col2), Math.max(row1, row2), Math.max(col1, col2));
        }
        if (ptg instanceof Area3DPtg) {
            Area3DPtg aptg = (Area3DPtg)ptg;
            boolean col1Rel = aptg.isFirstColRelative();
            boolean row1Rel = aptg.isFirstRowRelative();
            boolean col2Rel = aptg.isLastColRelative();
            boolean row2Rel = aptg.isLastRowRelative();
            int row1 = aptg.getFirstRow() + (row1Rel ? row1Off : 0);
            int col1 = aptg.getFirstColumn() + (col1Rel ? col1Off : 0);
            int row2 = aptg.getLastRow() + (row2Rel ? row1Off + row2Off : 0);
            int col2 = aptg.getLastColumn() + (col2Rel ? col1Off + col2Off : 0);
            SSheet sheet = this._cfi.getSheet();
            SBook book = sheet.getBook();
            ParsingBook parsingBook = new ParsingBook(book);
            EvaluationWorkbook.ExternalSheetRange es = parsingBook.getAnyExternalSheet(aptg.getExternSheetIndex());
            String bookName0 = es.getWorkbookName() != null ? es.getWorkbookName() : sheet.getBook().getBookName();
            String sheetName0 = es.getSheetName();
            String lastSheetName0 = es.getLastSheetName().equals(sheetName0) ? null : es.getLastSheetName();
            return new RefImpl(bookName0, sheetName0, lastSheetName0, Math.min(row1, row2), Math.min(col1, col2), Math.max(row1, row2), Math.max(col1, col2));
        }
        if (ptg instanceof RefPtg) {
            RefPtg rptg = (RefPtg)ptg;
            boolean colRel = rptg.isColRelative();
            boolean rowRel = rptg.isRowRelative();
            int row1 = rptg.getRow() + (rowRel ? row1Off : 0);
            int col1 = rptg.getColumn() + (colRel ? col1Off : 0);
            int row2 = row1 + (rowRel ? row2Off : 0);
            int col2 = col1 + (colRel ? col2Off : 0);
            return new RefImpl(bookName, sheetName, Math.min(row1, row2), Math.min(col1, col2), Math.max(row1, row2), Math.max(col1, col2));
        }
        if (ptg instanceof AreaPtg) {
            AreaPtg aptg = (AreaPtg)ptg;
            boolean col1Rel = aptg.isFirstColRelative();
            boolean row1Rel = aptg.isFirstRowRelative();
            boolean col2Rel = aptg.isLastColRelative();
            boolean row2Rel = aptg.isLastRowRelative();
            int row1 = aptg.getFirstRow() + (row1Rel ? row1Off : 0);
            int col1 = aptg.getFirstColumn() + (col1Rel ? col1Off : 0);
            int row2 = aptg.getLastRow() + (row2Rel ? row1Off + row2Off : 0);
            int col2 = aptg.getLastColumn() + (col2Rel ? col1Off + col2Off : 0);
            return new RefImpl(bookName, sheetName, Math.min(row1, row2), Math.min(col1, col2), Math.max(row1, row2), Math.max(col1, col2));
        }
        if (ptg instanceof NamePtg) {
            ParsingBook parsingBook;
            String name;
            SSheet sheet = this._cfi.getSheet();
            SBook book = sheet.getBook();
            SName namename = book.getNameByName(name = (parsingBook = new ParsingBook(book)).getNameText((NamePtg)ptg), sheet.getSheetName());
            if (namename == null) {
                namename = book.getNameByName(name);
            }
            if (namename != null) {
                return new NameRefImpl((AbstractNameAdv)namename);
            }
            return new NameRefImpl(bookName, null, name);
        }
        return null;
    }

    public RuleInfo getRuleInfo1() {
        return this._ruleInfo1;
    }

    public RuleInfo getRuleInfo2() {
        return this._ruleInfo2;
    }

    public boolean isUnderExt() {
        return this._underExt;
    }

    public void setUnderExt(boolean b) {
        this._underExt = b;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public void setId(String id) {
        this._id = id;
    }

    @Override
    public String getExtId() {
        return this._extId;
    }

    @Override
    public void setExtId(String extId) {
        this._extId = extId;
    }

    private static class IconSetInfo {
        public final double value;
        public final boolean gte;

        IconSetInfo(double value, boolean gte) {
            this.value = value;
            this.gte = gte;
        }
    }
}

