/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.CellRegion;
import io.keikai.model.SCFValueObject;
import io.keikai.model.SCell;
import io.keikai.model.impl.AbstractCellAdv;
import io.keikai.model.impl.CFValueObjectImpl;
import io.keikai.model.impl.CellValue;
import io.keikai.model.impl.ConditionalFormattingRuleImpl;
import io.keikai.model.impl.RuleInfo;
import io.keikai.model.sys.formula.EvaluationResult;
import io.keikai.model.sys.formula.FormulaExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.poi.ss.usermodel.DateUtil;

public class CFValueObjectHelper {
    private ConditionalFormattingRuleImpl rule;
    private ArrayList<Double> _sortedList;

    public CFValueObjectHelper(ConditionalFormattingRuleImpl rule) {
        this.rule = rule;
    }

    public Double[] calcMinMax(List<SCFValueObject> vos) {
        Double[] values = new Double[vos.size()];
        int len = vos.size();
        for (int j = 0; j < len; ++j) {
            SCFValueObject vo = vos.get(j);
            Double val = this._calcVo(vo);
            if (val == null) {
                return null;
            }
            values[j] = val;
        }
        return values;
    }

    private Double _calcVo(SCFValueObject vo) {
        switch (vo.getType()) {
            case MIN: {
                this._prepareSortedList();
                return this._sortedList.isEmpty() ? null : this._sortedList.get(0);
            }
            case AUTOMAX: 
            case MAX: {
                this._prepareSortedList();
                return this._sortedList.isEmpty() ? null : this._sortedList.get(this._sortedList.size() - 1);
            }
            case FORMULA: {
                CellRegion region = this.rule.getRegions().iterator().next();
                int row0 = region.row;
                int col0 = region.column;
                String formula = vo.getValue();
                FormulaExpression expr = this.rule.parseFormula(formula);
                ((CFValueObjectImpl)vo).setFormulaExpression(expr);
                RuleInfo rulex = new RuleInfo(this.rule.getSheet(), this.rule, expr, row0, col0);
                EvaluationResult result = rulex.evalFormula(null);
                if (result.getType() == EvaluationResult.ResultType.SUCCESS) {
                    Object val = result.getValue();
                    if (val instanceof Double) {
                        return (Double)val;
                    }
                    if (val instanceof Date) {
                        return DateUtil.getExcelDate((Date)((Date)val));
                    }
                }
                return null;
            }
            case NUM: {
                try {
                    return Double.valueOf(vo.getValue());
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
            case PERCENT: {
                try {
                    double rank0 = Double.valueOf(vo.getValue());
                    return this._pickPercent(rank0);
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
            case PERCENTILE: {
                try {
                    double rank0 = Double.valueOf(vo.getValue());
                    return this._pickPercentileInc(rank0);
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
            case AUTOMIN: {
                return 0.0;
            }
        }
        return null;
    }

    private void _prepareSortedList() {
        if (this._sortedList == null) {
            this._sortedList = new ArrayList();
            for (CellRegion rgn : this.rule.getRegions()) {
                int l = rgn.column;
                int t = rgn.row;
                int r0 = rgn.lastColumn;
                int b = rgn.lastRow;
                for (int row = t; row <= b; ++row) {
                    for (int col = l; col <= r0; ++col) {
                        SCell cell = this.rule.getSheet().getCell(row, col);
                        CellValue cellval = ((AbstractCellAdv)cell).getEvalCellValue(true);
                        if (cellval.getType() != SCell.CellType.NUMBER) continue;
                        this._sortedList.add(((Number)cellval.getValue()).doubleValue());
                    }
                }
            }
            Collections.sort(this._sortedList);
        }
    }

    public Double pickTopX(boolean isTop, boolean isPercent, double rank0) {
        this._prepareSortedList();
        int count = this._sortedList.size();
        if (count == 0) {
            return null;
        }
        if (isPercent) {
            return this._pickPercentileInc(isTop ? 100.0 - rank0 : rank0);
        }
        count = Math.min(count, (int)rank0);
        return isTop ? this._sortedList.get(this._sortedList.size() - count) : this._sortedList.get(count == 0 ? 0 : count - 1);
    }

    private Double _pickPercent(double rank0) {
        this._prepareSortedList();
        int n = this._sortedList.size();
        if (n == 0) {
            return null;
        }
        double min = this._sortedList.get(0);
        double max = this._sortedList.get(this._sortedList.size() - 1);
        return min + rank0 / 100.0 * (max - min);
    }

    private Double _pickPercentileInc(double rank0) {
        this._prepareSortedList();
        int n = this._sortedList.size();
        if (n == 0) {
            return null;
        }
        double x = rank0 / 100.0 * (double)(n - 1) + 1.0;
        int i = (int)Math.floor(x);
        double frac = x - (double)i;
        double vi = this._sortedList.get(i - 1);
        double vi1 = this._sortedList.get(i);
        return vi + frac * (vi1 - vi);
    }
}

