/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.importer;

import io.keikai.model.SBorder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Borders {
    Map<Border, Border> _bordersMap = new HashMap<Border, Border>();
    List<Border> _borders = new ArrayList<Border>();

    public void addBorder(Border border) {
        Border exist = this._bordersMap.get(border);
        if (exist != null) {
            this._borders.add(exist);
        } else {
            this._bordersMap.put(border, border);
            this._borders.add(border);
        }
    }

    public Border getBordreAt(int index) {
        return this._borders.size() > index ? this._borders.get(index) : null;
    }

    public static class Border {
        private boolean diagonalUp;
        private boolean diagonalDown;
        private boolean outline;
        private BorderPr left;
        private BorderPr top;
        private BorderPr right;
        private BorderPr bottom;
        private BorderPr diagonal;
        private BorderPr vertical;
        private BorderPr horizontal;

        public Border(boolean diagonalUp, boolean diagonalDown, boolean outline, BorderPr left, BorderPr top, BorderPr right, BorderPr bottom, BorderPr diagonal, BorderPr vertical, BorderPr horizontal) {
            this.diagonalUp = diagonalUp;
            this.diagonalDown = diagonalDown;
            this.outline = outline;
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
            this.diagonal = diagonal;
            this.vertical = vertical;
            this.horizontal = horizontal;
        }

        public boolean isDiagonalUp() {
            return this.diagonalUp;
        }

        public boolean isDiagonalDown() {
            return this.diagonalDown;
        }

        public boolean isOutline() {
            return this.outline;
        }

        public BorderPr getLeft() {
            return this.left;
        }

        public BorderPr getTop() {
            return this.top;
        }

        public BorderPr getRight() {
            return this.right;
        }

        public BorderPr getBottom() {
            return this.bottom;
        }

        public BorderPr getDiagonal() {
            return this.diagonal;
        }

        public BorderPr getVertical() {
            return this.vertical;
        }

        public BorderPr getHorizontal() {
            return this.horizontal;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Border border = (Border)o;
            return this.diagonalUp == border.diagonalUp && this.diagonalDown == border.diagonalDown && this.outline == border.outline && Objects.equals(this.left, border.left) && Objects.equals(this.top, border.top) && Objects.equals(this.right, border.right) && Objects.equals(this.bottom, border.bottom) && Objects.equals(this.diagonal, border.diagonal) && Objects.equals(this.vertical, border.vertical) && Objects.equals(this.horizontal, border.horizontal);
        }

        public int hashCode() {
            return Objects.hash(this.diagonalUp, this.diagonalDown, this.outline, this.left, this.top, this.right, this.bottom, this.diagonal, this.vertical, this.horizontal);
        }
    }

    public static class BorderPr {
        private SBorder.BorderType style;
        private String color;

        public BorderPr(String style, String color) {
            switch (style = style == null ? "none" : style) {
                case "none": {
                    this.style = SBorder.BorderType.NONE;
                    break;
                }
                case "thin": {
                    this.style = SBorder.BorderType.THIN;
                    break;
                }
                case "medium": {
                    this.style = SBorder.BorderType.MEDIUM;
                    break;
                }
                case "dashed": {
                    this.style = SBorder.BorderType.DASHED;
                    break;
                }
                case "dotted": {
                    this.style = SBorder.BorderType.DOTTED;
                    break;
                }
                case "thick": {
                    this.style = SBorder.BorderType.THICK;
                    break;
                }
                case "double": {
                    this.style = SBorder.BorderType.DOUBLE;
                    break;
                }
                case "hair": {
                    this.style = SBorder.BorderType.HAIR;
                    break;
                }
                case "mediumDashed": {
                    this.style = SBorder.BorderType.MEDIUM_DASHED;
                    break;
                }
                case "dashDot": {
                    this.style = SBorder.BorderType.DASH_DOT;
                    break;
                }
                case "mediumDashDot": {
                    this.style = SBorder.BorderType.MEDIUM_DASH_DOT;
                    break;
                }
                case "dashDotDot": {
                    this.style = SBorder.BorderType.DASH_DOT_DOT;
                    break;
                }
                case "mediumDashDotDot": {
                    this.style = SBorder.BorderType.MEDIUM_DASH_DOT_DOT;
                    break;
                }
                case "slantDashDot": {
                    this.style = SBorder.BorderType.SLANTED_DASH_DOT;
                }
            }
            this.color = color;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BorderPr borderPr = (BorderPr)o;
            return this.style == borderPr.style && Objects.equals(this.color, borderPr.color);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.style, this.color});
        }

        public SBorder.BorderType getStyle() {
            return this.style;
        }

        public String getColor() {
            return this.color;
        }
    }
}

