/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl;

import io.keikai.model.CellStyleHolder;
import io.keikai.model.SBook;
import io.keikai.model.SBorder;
import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SCellStyleBuilder;
import io.keikai.model.SColor;
import io.keikai.model.SConditionalStyle;
import io.keikai.model.SFill;
import io.keikai.model.SFont;
import io.keikai.model.SFontBuilder;
import io.keikai.model.SRichText;
import io.keikai.model.SSheet;
import io.keikai.model.STable;
import io.keikai.model.impl.AbstractCellAdv;
import io.keikai.model.impl.AbstractSheetAdv;
import io.keikai.model.impl.AbstractTableAdv;
import io.keikai.model.impl.RichTextImpl;
import io.keikai.model.util.RichTextHelper;
import java.util.Objects;

public class StyleUtil {
    public static final short BORDER_EDGE_BOTTOM = 1;
    public static final short BORDER_EDGE_RIGHT = 2;
    public static final short BORDER_EDGE_TOP = 4;
    public static final short BORDER_EDGE_LEFT = 8;
    public static final short BORDER_EDGE_ALL = 15;

    public static void setFontColor(SBook book, CellStyleHolder holder, String color) {
        SCellStyle orgStyle = holder.getCellStyle();
        SFont orgFont = orgStyle.getFont();
        SColor orgColor = orgFont.getColor();
        if (Objects.equals(orgColor.getHtmlColor(), color)) {
            return;
        }
        SFont font = (SFont)book.createFont(orgFont).color(color).build();
        SCellStyle style = (SCellStyle)book.addCellStyle(orgStyle).font(font).build();
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setFillColor(SBook book, CellStyleHolder holder, String htmlColor) {
        SColor newColor;
        SCellStyle orgStyle = holder.getCellStyle();
        SColor orgColor = orgStyle.getFillColor();
        if (Objects.equals(orgColor, newColor = book.createColor(htmlColor))) {
            return;
        }
        SCellStyle style = (SCellStyle)book.addCellStyle(orgStyle).fillColor(htmlColor).build();
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setBackColor(SBook book, CellStyleHolder holder, String htmlColor) {
        SCellStyle orgStyle = holder.getCellStyle();
        SColor orgColor = orgStyle.getBackColor();
        if (Objects.equals(orgColor.getHtmlColor(), htmlColor)) {
            return;
        }
        SFill.FillPattern pattern = orgStyle.getFillPattern();
        if (pattern == SFill.FillPattern.NONE && htmlColor != null) {
            pattern = SFill.FillPattern.SOLID;
        }
        SCellStyle style = (SCellStyle)book.addCellStyle(orgStyle).backColor(htmlColor).fillPattern(pattern).build();
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setFillOptions(SBook book, CellStyleHolder holder, String bgColor, String fillColor, SFill.FillPattern pattern) {
        SCellStyle orgStyle = holder.getCellStyle();
        SColor orgBackColor = orgStyle.getBackColor();
        SColor orgFillColor = orgStyle.getFillColor();
        SFill.FillPattern orgPattern = orgStyle.getFillPattern();
        if (Objects.equals(orgBackColor.getHtmlColor(), bgColor) && Objects.equals(orgFillColor.getHtmlColor(), fillColor) && orgPattern == pattern) {
            return;
        }
        SCellStyle style = (SCellStyle)book.addCellStyle(orgStyle).backColor(bgColor).fillColor(fillColor).fillPattern(pattern).build();
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setTextWrap(SBook book, CellStyleHolder holder, boolean wrap) {
        SCellStyle orgStyle = holder.getCellStyle();
        boolean textWrap = orgStyle.isWrapText();
        if (wrap == textWrap) {
            return;
        }
        SCellStyle style = (SCellStyle)book.addCellStyle(orgStyle).wrapText(wrap).build();
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setFontHeightPoints(SBook book, CellStyleHolder holder, int fontHeightPoints) {
        SCellStyle orgStyle = holder.getCellStyle();
        SFont orgFont = orgStyle.getFont();
        int orgSize = orgFont.getHeightPoints();
        if (orgSize == fontHeightPoints) {
            return;
        }
        SFont font = (SFont)book.createFont(orgFont).heightPoints(fontHeightPoints).build();
        SCellStyle style = (SCellStyle)book.addCellStyle(orgStyle).font(font).build();
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setFontStrikethrough(SBook book, CellStyleHolder holder, boolean strikeout) {
        SCellStyle orgStyle = holder.getCellStyle();
        SFont orgFont = orgStyle.getFont();
        boolean orgStrikeout = orgFont.isStrikeout();
        if (orgStrikeout == strikeout) {
            return;
        }
        SFont font = (SFont)book.createFont(orgFont).strikeout(strikeout).build();
        SCellStyle style = (SCellStyle)book.addCellStyle(orgStyle).font(font).build();
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setFontName(SBook book, CellStyleHolder holder, String name) {
        SCellStyle orgStyle = holder.getCellStyle();
        SFont orgFont = orgStyle.getFont();
        String orgName = orgFont.getName();
        if (orgName.equals(name)) {
            return;
        }
        SFont font = (SFont)book.createFont(orgFont).name(name).build();
        SCellStyle style = (SCellStyle)book.addCellStyle(orgStyle).font(font).build();
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setBorder(SBook book, CellStyleHolder holder, String color, SBorder.BorderType linestyle) {
        StyleUtil.setBorder(book, holder, color, linestyle, (short)15);
    }

    public static void setBorderTop(SBook book, CellStyleHolder holder, String color, SBorder.BorderType linestyle) {
        StyleUtil.setBorder(book, holder, color, linestyle, (short)4);
    }

    public static void setBorderLeft(SBook book, CellStyleHolder holder, String color, SBorder.BorderType linestyle) {
        StyleUtil.setBorder(book, holder, color, linestyle, (short)8);
    }

    public static void setBorderBottom(SBook book, CellStyleHolder holder, String color, SBorder.BorderType linestyle) {
        StyleUtil.setBorder(book, holder, color, linestyle, (short)1);
    }

    public static void setBorderRight(SBook book, CellStyleHolder holder, String color, SBorder.BorderType linestyle) {
        StyleUtil.setBorder(book, holder, color, linestyle, (short)2);
    }

    public static void setBorder(SBook book, CellStyleHolder holder, String htmlColor, SBorder.BorderType lineStyle, short at) {
        SCellStyle orgStyle = holder.getCellStyle();
        boolean hasBorder = lineStyle != SBorder.BorderType.NONE;
        SCellStyleBuilder csb = book.addCellStyle(orgStyle);
        if ((at & 8) != 0) {
            if (hasBorder) {
                csb.borderLeftColor(htmlColor);
            }
            csb.borderLeft(lineStyle);
        }
        if ((at & 4) != 0) {
            if (hasBorder) {
                csb.borderTopColor(htmlColor);
            }
            csb.borderTop(lineStyle);
        }
        if ((at & 2) != 0) {
            if (hasBorder) {
                csb.borderRightColor(htmlColor);
            }
            csb.borderRight(lineStyle);
        }
        if ((at & 1) != 0) {
            if (hasBorder) {
                csb.borderBottomColor(htmlColor);
            }
            csb.borderBottom(lineStyle);
        }
        StyleUtil.setNewCellStyle(holder, (SCellStyle)csb.build());
    }

    public static void setFontBoldWeight(SBook book, CellStyleHolder holder, SFont.Boldweight boldWeight) {
        SCellStyle orgStyle = holder.getCellStyle();
        SFont orgFont = orgStyle.getFont();
        SFont.Boldweight orgBoldWeight = orgFont.getBoldweight();
        if (orgBoldWeight.equals((Object)boldWeight)) {
            return;
        }
        SFont font = (SFont)book.createFont(orgFont).boldweight(boldWeight).build();
        SCellStyle style = (SCellStyle)book.addCellStyle(orgStyle).font(font).build();
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setFontItalic(SBook book, CellStyleHolder holder, boolean italic) {
        SCellStyle orgStyle = holder.getCellStyle();
        SFont orgFont = orgStyle.getFont();
        boolean orgItalic = orgFont.isItalic();
        if (orgItalic == italic) {
            return;
        }
        SFont font = (SFont)book.createFont(orgFont).italic(italic).build();
        SCellStyle style = (SCellStyle)book.addCellStyle(orgStyle).font(font).build();
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setFontUnderline(SBook book, CellStyleHolder holder, SFont.Underline underline) {
        SCellStyle orgStyle = holder.getCellStyle();
        SFont orgFont = orgStyle.getFont();
        SFont.Underline orgUnderline = orgFont.getUnderline();
        if (orgUnderline.equals((Object)underline)) {
            return;
        }
        SFont font = (SFont)book.createFont(orgFont).underline(underline).build();
        SCellStyle style = (SCellStyle)book.addCellStyle(orgStyle).font(font).build();
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setTextHAlign(SBook book, CellStyleHolder holder, SCellStyle.Alignment align) {
        SCellStyle orgStyle = holder.getCellStyle();
        SCellStyle.Alignment orgAlign = orgStyle.getAlignment();
        if (align.equals((Object)orgAlign)) {
            return;
        }
        SCellStyle style = (SCellStyle)book.addCellStyle(orgStyle).alignment(align).build();
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setTextVAlign(SBook book, CellStyleHolder holder, SCellStyle.VerticalAlignment valign) {
        SCellStyle orgStyle = holder.getCellStyle();
        SCellStyle.VerticalAlignment orgValign = orgStyle.getVerticalAlignment();
        if (valign.equals((Object)orgValign)) {
            return;
        }
        SCellStyle style = (SCellStyle)book.addCellStyle(orgStyle).verticalAlignment(valign).build();
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setDataFormat(SBook book, CellStyleHolder holder, String format) {
        SCellStyle orgStyle = holder.getCellStyle();
        String orgFormat = orgStyle.getDataFormat();
        if (Objects.equals(format, orgFormat)) {
            return;
        }
        SCellStyle style = (SCellStyle)book.addCellStyle(orgStyle).dataFormat(format).build();
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setFontTypeOffset(SBook book, CellStyleHolder holder, SFont.TypeOffset offset) {
        SCellStyle orgStyle = holder.getCellStyle();
        SFont orgFont = orgStyle.getFont();
        SFont.TypeOffset orgOffset = orgFont.getTypeOffset();
        if (orgOffset.equals((Object)offset)) {
            return;
        }
        SFont font = (SFont)book.createFont(orgFont).typeOffset(offset).build();
        SCellStyle style = (SCellStyle)book.addCellStyle(orgStyle).font(font).build();
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static boolean setRichTextFontTypeOffset(SBook book, SCell cell, SFont.TypeOffset offset) {
        Object value;
        Object object = value = ((AbstractCellAdv)cell).isRichTextValue() ? cell.getValue() : null;
        if (!(value instanceof SRichText)) {
            return false;
        }
        SRichText text = (SRichText)value;
        RichTextImpl newText = new RichTextImpl();
        boolean modified = false;
        for (SRichText.Segment seg : text.getSegments()) {
            SFont font0 = seg.getFont();
            SFont font = RichTextHelper.getRichTextRealFont(font0, cell);
            SFont.TypeOffset orgOffset = font.getTypeOffset();
            if (!orgOffset.equals((Object)offset)) {
                font = (SFont)book.addFont(font).typeOffset(offset).build();
                modified = true;
            }
            if (modified && font0 == null) {
                StyleUtil.updateRichTextCellFont(book, cell, font);
                font = null;
            }
            newText.addSegment(seg.getText(), font);
        }
        if (modified) {
            cell.setValue(newText);
            return true;
        }
        return false;
    }

    private static void updateRichTextCellFont(SBook book, SCell cell, SFont font) {
        SCellStyle cellStyle = cell.getCellStyle();
        cell.setCellStyle((SCellStyle)book.addCellStyle(cellStyle).font(font).build());
    }

    public static boolean setRichTextFontBoldweight(SBook book, SCell cell, SFont.Boldweight bold) {
        Object value;
        Object object = value = cell.isRichTextValue() ? cell.getValue() : null;
        if (!(value instanceof SRichText)) {
            return false;
        }
        SRichText text = (SRichText)value;
        RichTextImpl newText = new RichTextImpl();
        boolean modified = false;
        for (SRichText.Segment seg : text.getSegments()) {
            SFont font0 = seg.getFont();
            SFont font = RichTextHelper.getRichTextRealFont(font0, cell);
            SFont.Boldweight orgBold = font.getBoldweight();
            if (!orgBold.equals((Object)bold)) {
                font = (SFont)book.addFont(font).boldweight(bold).build();
                modified = true;
            }
            if (modified && font0 == null) {
                StyleUtil.updateRichTextCellFont(book, cell, font);
                font = null;
            }
            newText.addSegment(seg.getText(), font);
        }
        if (modified) {
            cell.setValue(newText);
            return true;
        }
        return false;
    }

    public static boolean setRichTextFontItalic(SBook book, SCell cell, boolean italic) {
        Object value;
        Object object = value = cell.isRichTextValue() ? cell.getValue() : null;
        if (!(value instanceof SRichText)) {
            return false;
        }
        SRichText text = (SRichText)value;
        RichTextImpl newText = new RichTextImpl();
        boolean modified = false;
        for (SRichText.Segment seg : text.getSegments()) {
            SFont font0 = seg.getFont();
            SFont font = RichTextHelper.getRichTextRealFont(font0, cell);
            boolean orgItalic = font.isItalic();
            if (orgItalic != italic) {
                font = (SFont)book.addFont(font).italic(italic).build();
                modified = true;
            }
            if (modified && font0 == null) {
                StyleUtil.updateRichTextCellFont(book, cell, font);
                font = null;
            }
            newText.addSegment(seg.getText(), font);
        }
        if (modified) {
            cell.setValue(newText);
            return true;
        }
        return false;
    }

    public static boolean setRichTextFontUnderline(SBook book, SCell cell, SFont.Underline underline) {
        Object value;
        Object object = value = cell.isRichTextValue() ? cell.getValue() : null;
        if (!(value instanceof SRichText)) {
            return false;
        }
        SRichText text = (SRichText)value;
        RichTextImpl newText = new RichTextImpl();
        boolean modified = false;
        for (SRichText.Segment seg : text.getSegments()) {
            SFont font0 = seg.getFont();
            SFont font = RichTextHelper.getRichTextRealFont(font0, cell);
            SFont.Underline orgUnderline = font.getUnderline();
            if (!orgUnderline.equals((Object)underline)) {
                font = (SFont)book.addFont(font).underline(underline).build();
                modified = true;
            }
            if (modified && font0 == null) {
                StyleUtil.updateRichTextCellFont(book, cell, font);
                font = null;
            }
            newText.addSegment(seg.getText(), font);
        }
        if (modified) {
            cell.setValue(newText);
            return true;
        }
        return false;
    }

    public static boolean setRichTextFontName(SBook book, SCell cell, String name) {
        Object value;
        Object object = value = cell.isRichTextValue() ? cell.getValue() : null;
        if (!(value instanceof SRichText)) {
            return false;
        }
        SRichText text = (SRichText)value;
        RichTextImpl newText = new RichTextImpl();
        boolean modified = false;
        for (SRichText.Segment seg : text.getSegments()) {
            SFont font0 = seg.getFont();
            SFont font = RichTextHelper.getRichTextRealFont(font0, cell);
            String orgName = font.getName();
            if (!orgName.equals(name)) {
                font = (SFont)book.addFont(font).name(name).build();
                modified = true;
            }
            if (modified && font0 == null) {
                StyleUtil.updateRichTextCellFont(book, cell, font);
                font = null;
            }
            newText.addSegment(seg.getText(), font);
        }
        if (modified) {
            cell.setValue(newText);
            return true;
        }
        return false;
    }

    public static boolean setRichTextFontHeightPoints(SBook book, SCell cell, int heightPoints) {
        Object value;
        Object object = value = cell.isRichTextValue() ? cell.getValue() : null;
        if (!(value instanceof SRichText)) {
            return false;
        }
        SRichText text = (SRichText)value;
        RichTextImpl newText = new RichTextImpl();
        boolean modified = false;
        for (SRichText.Segment seg : text.getSegments()) {
            SFont font0 = seg.getFont();
            SFont font = RichTextHelper.getRichTextRealFont(font0, cell);
            int orgHeightPoints = font.getHeightPoints();
            if (orgHeightPoints != heightPoints) {
                font = (SFont)book.addFont(font).heightPoints(heightPoints).build();
                modified = true;
            }
            if (modified && font0 == null) {
                StyleUtil.updateRichTextCellFont(book, cell, font);
                font = null;
            }
            newText.addSegment(seg.getText(), font);
        }
        if (modified) {
            cell.setValue(newText);
            return true;
        }
        return false;
    }

    public static boolean setRichTextFontStrikeout(SBook book, SCell cell, boolean strike) {
        Object value;
        Object object = value = cell.isRichTextValue() ? cell.getValue() : null;
        if (!(value instanceof SRichText)) {
            return false;
        }
        SRichText text = (SRichText)value;
        RichTextImpl newText = new RichTextImpl();
        boolean modified = false;
        for (SRichText.Segment seg : text.getSegments()) {
            SFont font0 = seg.getFont();
            SFont font = RichTextHelper.getRichTextRealFont(font0, cell);
            boolean orgStrike = font.isStrikeout();
            if (orgStrike != strike) {
                font = (SFont)book.addFont(font).strikeout(strike).build();
                modified = true;
            }
            if (modified && font0 == null) {
                StyleUtil.updateRichTextCellFont(book, cell, font);
                font = null;
            }
            newText.addSegment(seg.getText(), font);
        }
        if (modified) {
            cell.setValue(newText);
            return true;
        }
        return false;
    }

    public static boolean setRichTextFontColor(SBook book, SCell cell, String htmlColor) {
        Object value;
        Object object = value = cell.isRichTextValue() ? cell.getValue() : null;
        if (!(value instanceof SRichText)) {
            return false;
        }
        SRichText text = (SRichText)value;
        RichTextImpl newText = new RichTextImpl();
        boolean modified = false;
        for (SRichText.Segment seg : text.getSegments()) {
            SFont font0 = seg.getFont();
            SFont font = RichTextHelper.getRichTextRealFont(font0, cell);
            SColor orgColor = font.getColor();
            if (!Objects.equals(orgColor.getHtmlColor(), htmlColor)) {
                font = (SFont)book.addFont(font).color(htmlColor).build();
                modified = true;
            }
            if (modified && font0 == null) {
                StyleUtil.updateRichTextCellFont(book, cell, font);
                font = null;
            }
            newText.addSegment(seg.getText(), font);
        }
        if (modified) {
            cell.setValue(newText);
            return true;
        }
        return false;
    }

    public static void setTextRotation(SBook book, CellStyleHolder holder, int rotation) {
        SCellStyle orgStyle = holder.getCellStyle();
        int rot = orgStyle.getRotation();
        if (rot == rotation) {
            return;
        }
        SCellStyle style = (SCellStyle)book.addCellStyle(orgStyle).rotation(rotation).build();
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setTextIndentionOffset(SBook book, CellStyleHolder holder, int offset) {
        if (offset == 0) {
            return;
        }
        StyleUtil.setTextIndention(book, holder, holder.getCellStyle().getIndention() + offset);
    }

    public static void setTextIndention(SBook book, CellStyleHolder holder, int indent) {
        SCellStyle orgStyle = holder.getCellStyle();
        int ind = orgStyle.getIndention();
        if (indent < 0) {
            indent = 0;
        }
        if (ind == indent) {
            return;
        }
        SCellStyle style = (SCellStyle)book.addCellStyle(orgStyle).indention(indent).build();
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static SFont getFontStyle(SBook book, SCellStyle cellStyle, SCellStyle tbCellStyle, SConditionalStyle cdStyle) {
        if (cdStyle != null && cdStyle.getFont() != null) {
            SFont font = cellStyle.getFont();
            if (font != null) {
                return (SFont)book.createFont(cdStyle.getFont()).name(font.getName()).heightPoints(font.getHeightPoints()).build();
            }
            return cdStyle.getFont();
        }
        SFont font = cellStyle.getFont();
        SFont defaultFont = book.getDefaultFont();
        if (tbCellStyle != null) {
            if (defaultFont.equals(font)) {
                SFont tableFont = tbCellStyle.getFont();
                if (tableFont != null) {
                    font = tableFont;
                }
            } else {
                SFont tableFont = tbCellStyle.getFont();
                if (tableFont != null) {
                    SFontBuilder fb = book.createFont(font);
                    SColor color = font.getColor();
                    SColor defaultColor = defaultFont.getColor();
                    SColor tbColor = tableFont.getColor();
                    if (color != null) {
                        if (color.equals(defaultColor) && tbColor != null && !tbColor.equals(color)) {
                            fb.color(tbColor.getHtmlColor());
                        }
                    } else if (defaultColor == null) {
                        if (tbColor != null) {
                            fb.color(tbColor.getHtmlColor());
                        }
                    } else if (tbColor == null) {
                        fb.color(defaultColor.getHtmlColor());
                    }
                    SFont.Boldweight boldweight = font.getBoldweight();
                    SFont.Boldweight defaultBoldweight = defaultFont.getBoldweight();
                    SFont.Boldweight tbBoldweight = tableFont.getBoldweight();
                    if (boldweight != null) {
                        if (boldweight.equals((Object)defaultBoldweight) && tbBoldweight != null && !tbBoldweight.equals((Object)boldweight)) {
                            fb.boldweight(tbBoldweight);
                        }
                    } else if (defaultBoldweight == null) {
                        if (tbBoldweight != null) {
                            fb.boldweight(tbBoldweight);
                        }
                    } else if (tbBoldweight == null) {
                        fb.boldweight(defaultBoldweight);
                    }
                    boolean italic = font.isItalic();
                    boolean defaultItalic = defaultFont.isItalic();
                    boolean tbItalic = tableFont.isItalic();
                    if (italic) {
                        if (italic == defaultItalic && tbItalic && tbItalic != italic) {
                            fb.italic(tbItalic);
                        }
                    } else if (!defaultItalic) {
                        if (tbItalic && tbItalic != italic) {
                            fb.italic(tbItalic);
                        }
                    } else if (tbItalic) {
                        fb.italic(defaultItalic);
                    }
                    boolean strikeout = font.isStrikeout();
                    boolean defaultStrikeout = defaultFont.isStrikeout();
                    boolean tbStrikeout = tableFont.isStrikeout();
                    if (strikeout) {
                        if (strikeout == defaultStrikeout && tbStrikeout && tbStrikeout != strikeout) {
                            fb.strikeout(tbStrikeout);
                        }
                    } else if (!defaultStrikeout) {
                        if (tbStrikeout && tbStrikeout != strikeout) {
                            fb.strikeout(tbStrikeout);
                        }
                    } else if (tbStrikeout) {
                        fb.strikeout(defaultStrikeout);
                    }
                    SFont.Underline underLine = font.getUnderline();
                    SFont.Underline defaultUnderLine = defaultFont.getUnderline();
                    SFont.Underline tbUnderLine = tableFont.getUnderline();
                    if (underLine != null) {
                        if (underLine.equals((Object)defaultUnderLine) && tbUnderLine != null && !tbUnderLine.equals((Object)underLine)) {
                            fb.underline(tbUnderLine);
                        }
                    } else if (defaultUnderLine == null) {
                        if (tbUnderLine != null && !tbUnderLine.equals((Object)underLine)) {
                            fb.underline(tbUnderLine);
                        }
                    } else if (tbUnderLine == null) {
                        fb.underline(defaultUnderLine);
                    }
                    String name = font.getName();
                    String defaultName = defaultFont.getName();
                    String tbName = tableFont.getName();
                    if (name != null) {
                        if (name.equals(defaultName) && tbName != null && !tbName.equals(name)) {
                            fb.name(tbName);
                        }
                    } else if (defaultName == null) {
                        if (tbName != null && !tbName.equals(name)) {
                            fb.name(tbName);
                        }
                    } else if (tbName == null) {
                        fb.name(defaultName);
                    }
                    font = (SFont)fb.build();
                }
            }
        }
        return font;
    }

    public static SCellStyle getFillStyle(SCellStyle cellStyle, SCellStyle tbStyle, SConditionalStyle cdStyle) {
        return cdStyle != null && cdStyle.getFill() != null ? cdStyle : (cellStyle.getFillPattern() != SFill.FillPattern.NONE ? cellStyle : tbStyle);
    }

    public static SCellStyle getLeftStyle(SCellStyle cellStyle, SCellStyle tbStyle, SConditionalStyle cdStyle) {
        return cdStyle != null && cdStyle.getBorderLeft() != null ? cdStyle : (tbStyle == null || cellStyle.getBorderLeft() != SBorder.BorderType.NONE ? cellStyle : tbStyle);
    }

    public static SCellStyle getTopStyle(SCellStyle cellStyle, SCellStyle tbStyle, SConditionalStyle cdStyle) {
        return cdStyle != null && cdStyle.getBorderTop() != null ? cdStyle : (tbStyle == null || cellStyle.getBorderTop() != SBorder.BorderType.NONE ? cellStyle : tbStyle);
    }

    public static SCellStyle getRightStyle(SCellStyle cellStyle, SCellStyle tbStyle, SConditionalStyle cdStyle) {
        return cdStyle != null && cdStyle.getBorderRight() != null ? cdStyle : (tbStyle == null || cellStyle.getBorderRight() != SBorder.BorderType.NONE ? cellStyle : tbStyle);
    }

    public static SCellStyle getBottomStyle(SCellStyle cellStyle, SCellStyle tbStyle, SConditionalStyle cdStyle) {
        return cdStyle != null && cdStyle.getBorderBottom() != null ? cellStyle : (tbStyle == null || cellStyle.getBorderBottom() != SBorder.BorderType.NONE ? cellStyle : tbStyle);
    }

    public static SCellStyle prepareStyle(SCell srcCell) {
        int row = srcCell.getRowIndex();
        int col = srcCell.getColumnIndex();
        SSheet sheet = srcCell.getSheet();
        SConditionalStyle cdStyle = null;
        STable table = ((AbstractSheetAdv)sheet).getTableByRowCol(row, col);
        SCellStyle tbStyle = table != null ? ((AbstractTableAdv)table).getCellStyle(row, col) : null;
        SCellStyle cellStyle = srcCell.getCellStyle();
        if (tbStyle == null) {
            return cellStyle;
        }
        SBook book = sheet.getBook();
        SFont font = StyleUtil.getFontStyle(book, cellStyle, tbStyle, cdStyle);
        SCellStyle fillStyle = StyleUtil.getFillStyle(cellStyle, tbStyle, cdStyle);
        SCellStyle leftStyle = StyleUtil.getLeftStyle(cellStyle, tbStyle, cdStyle);
        SCellStyle topStyle = StyleUtil.getTopStyle(cellStyle, tbStyle, cdStyle);
        SCellStyle rightStyle = StyleUtil.getRightStyle(cellStyle, tbStyle, cdStyle);
        SCellStyle bottomStyle = StyleUtil.getBottomStyle(cellStyle, tbStyle, cdStyle);
        String backColor = fillStyle.getBackColor().getHtmlColor();
        String fillColor = fillStyle.getFillColor().getHtmlColor();
        return (SCellStyle)book.addCellStyle(cellStyle).backColor(backColor).fillColor(fillColor).fillPattern(fillStyle.getFillPattern()).font(font).borderBottom(bottomStyle.getBorderBottom()).borderBottomColor(bottomStyle.getBorderBottomColor().getHtmlColor()).borderTop(topStyle.getBorderTop()).borderTopColor(topStyle.getBorderTopColor().getHtmlColor()).borderLeft(leftStyle.getBorderLeft()).borderLeftColor(leftStyle.getBorderLeftColor().getHtmlColor()).borderRight(rightStyle.getBorderRight()).borderRightColor(rightStyle.getBorderRightColor().getHtmlColor()).build();
    }

    public static void setNewCellStyle(CellStyleHolder holder, SCellStyle cellStyle) {
        SCell cell;
        SCellStyle cellStyle0 = holder.getCellStyle();
        SFont font0 = cellStyle0.getFont();
        int rotate0 = cellStyle0.getRotation();
        int indent0 = cellStyle0.getIndention();
        boolean wrap0 = cellStyle0.isWrapText();
        SFont font = cellStyle.getFont();
        int rotate = cellStyle.getRotation();
        int indent = cellStyle.getIndention();
        boolean wrap = cellStyle.isWrapText();
        boolean to90 = rotate == 90 || rotate == -90;
        boolean processWrap = wrap != wrap0 && !to90;
        holder.setCellStyle(cellStyle);
        if (holder instanceof SCell && !(cell = (SCell)holder).getSheet().getRow(cell.getRowIndex()).isCustomHeight()) {
            SCell.CellType type = cell.getType();
            if (rotate != rotate0 || indent != indent0 || !font.equals(font0) || type == SCell.CellType.STRING && processWrap) {
                ((AbstractCellAdv)cell).setCalcAutoHeight(true);
            }
        }
    }

    public static void setLocked(SBook book, CellStyleHolder holder, boolean locked) {
        SCellStyle orgStyle = holder.getCellStyle();
        if (locked == orgStyle.isLocked()) {
            return;
        }
        SCellStyle style = (SCellStyle)book.addCellStyle(orgStyle).locked(locked).build();
        StyleUtil.setNewCellStyle(holder, style);
    }
}

