/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl.chart;

import io.keikai.model.SBook;
import io.keikai.model.SSheet;
import io.keikai.model.impl.AbstractChartAdv;
import io.keikai.model.sys.dependency.Ref;
import io.keikai.model.sys.formula.FormulaExpression;
import java.util.Map;

public class ChartUtil {
    public static void evalVisibleInfo(AbstractChartAdv chart, FormulaExpression expr, boolean[] hiddenInfos, Map<Integer, Boolean> cachedRowValues, Map<Integer, Boolean> cachedColumnValues) {
        if (expr == null) {
            return;
        }
        Ref[] refs = expr.getAreaRefs();
        if (refs != null && refs.length > 0) {
            CellPosition p;
            SSheet sheet;
            SBook book;
            Ref ref0 = refs[0];
            String bookName = ref0.getBookName();
            String sheetName = ref0.getSheetName();
            SBook sBook = book = bookName != null ? chart.getSheet().getBook().getBookSeries().getBook(bookName) : chart.getSheet().getBook();
            if (book == null) {
                return;
            }
            SSheet sSheet = sheet = sheetName != null ? book.getSheetByName(sheetName) : chart.getSheet();
            if (sheet == null) {
                return;
            }
            SingleLineAreaIterator iter = new SingleLineAreaIterator(ref0);
            int index = 0;
            while ((p = iter.next()) != null) {
                int row = p.getRow();
                int column = p.getColumn();
                Boolean rowHidden = cachedRowValues.get(row);
                Boolean columnHidden = cachedColumnValues.get(column);
                if (Boolean.TRUE.equals(rowHidden) || Boolean.TRUE.equals(columnHidden)) {
                    hiddenInfos[index++] = Boolean.TRUE.equals(rowHidden) || Boolean.TRUE.equals(columnHidden);
                    continue;
                }
                if (rowHidden == null) {
                    rowHidden = sheet.getRow(row).isHidden();
                    cachedRowValues.put(row, rowHidden);
                }
                if (columnHidden == null) {
                    columnHidden = sheet.getColumn(column).isHidden();
                    cachedColumnValues.put(column, columnHidden);
                }
                hiddenInfos[index++] = rowHidden != false || columnHidden != false;
            }
        }
    }

    static class SingleLineAreaIterator {
        int row;
        int column;
        int lastRow;
        int lastColumn;
        boolean isVertical;

        public SingleLineAreaIterator(Ref ref) {
            this.row = ref.getRow();
            this.column = ref.getColumn();
            this.lastRow = ref.getLastRow();
            this.lastColumn = ref.getLastColumn();
            this.isVertical = this.row != this.lastRow;
        }

        public CellPosition next() {
            CellPosition cellPosition;
            if (this.row > this.lastRow || this.column > this.lastColumn) {
                cellPosition = null;
            } else {
                int n;
                int n2;
                if (this.isVertical) {
                    int n3 = this.row;
                    n2 = n3;
                    this.row = n3 + 1;
                } else {
                    n2 = this.row;
                }
                if (this.isVertical) {
                    n = this.column;
                } else {
                    int n4 = this.column;
                    n = n4;
                    this.column = n4 + 1;
                }
                cellPosition = new CellPosition(n2, n);
            }
            return cellPosition;
        }
    }

    static class CellPosition {
        int row;
        int column;

        public CellPosition(int row, int column) {
            this.row = row;
            this.column = column;
        }

        public int getRow() {
            return this.row;
        }

        public void setRow(int row) {
            this.row = row;
        }

        public int getColumn() {
            return this.column;
        }

        public void setColumn(int column) {
            this.column = column;
        }
    }
}

