/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SBookSeries;
import io.keikai.model.impl.AbstractBookSeriesAdv;
import io.keikai.model.impl.FormulaCacheClearHelper;
import io.keikai.model.sys.dependency.DependencyTable;
import io.keikai.model.sys.dependency.Ref;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;

public class FormulaCacheCleaner
implements Serializable {
    private static final long serialVersionUID = 1832529508263194818L;
    private static ThreadLocal<FormulaCacheCleaner> _current = new ThreadLocal();
    private final SBookSeries _bookSeries;

    public FormulaCacheCleaner(SBookSeries bookSeries) {
        this._bookSeries = bookSeries;
    }

    public static FormulaCacheCleaner setCurrent(FormulaCacheCleaner ctx) {
        FormulaCacheCleaner old = _current.get();
        _current.set(ctx);
        return old;
    }

    public static FormulaCacheCleaner getCurrent() {
        return _current.get();
    }

    public void clear(Set<Ref> dependents) {
        this.clear(dependents, null);
    }

    public void clear(Set<Ref> dependents, Ref precedent) {
        new FormulaCacheClearHelper(this._bookSeries).clear(dependents, precedent);
    }

    public void clearByPrecedent(Ref precedent) {
        DependencyTable table = ((AbstractBookSeriesAdv)this._bookSeries).getDependencyTable();
        LinkedHashSet<Ref> dependents = new LinkedHashSet<Ref>();
        dependents.add(precedent);
        dependents.addAll(table.getEvaluatedDependents(precedent));
        this.clear(dependents, precedent);
        table.clearDependents(precedent);
    }
}

