/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.util;

import io.keikai.util.Ref;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Converter {
    public static String numToAbc(int index) {
        LinkedList<String> sb = new LinkedList<String>();
        while (index >= 0) {
            int j = index % 26 + 65;
            sb.addFirst(String.valueOf((char)j));
            index /= 26;
            --index;
        }
        return String.join((CharSequence)"", sb);
    }

    public static String rangeToA1(int row, int column) {
        return Converter.numToAbc(column) + (row + 1);
    }

    public static Ref rangeToRef(int row, int column) {
        return new Ref(column, row);
    }

    public static Ref areaToRef(int row, int column, int lastRow, int lastColumn) {
        return new Ref(column, row, lastColumn, lastRow);
    }

    public static Ref a1ToRef(String a1notation) {
        String[] a1s = a1notation.split(":");
        if (a1s.length == 0) {
            return null;
        }
        int j = 0;
        int len = a1s.length;
        if (j < len) {
            List cr2;
            List cr1 = Converter.splitA1(a1s[j]);
            if (cr1 == null) {
                return null;
            }
            Integer left = (Integer)cr1.get(0);
            Integer top = (Integer)cr1.get(1);
            if (left != null && top != null) {
                if (j + 1 < len) {
                    List cr22 = Converter.splitA1(a1s[j + 1]);
                    if (cr22 == null) {
                        return null;
                    }
                    Integer right = (Integer)cr22.get(0);
                    Integer bottom = (Integer)cr22.get(1);
                    if (right != null && bottom != null) {
                        return left == right && top == bottom ? new Ref(left, top) : new Ref(left, top, right, bottom);
                    }
                    return new Ref(left, top);
                }
                return new Ref(left, top);
            }
            List list = cr2 = len <= j + 1 ? cr1 : Converter.splitA1(a1s[j + 1]);
            if (cr2 == null) {
                return null;
            }
            Integer right = (Integer)cr2.get(0);
            Integer bottom = (Integer)cr2.get(1);
            if (left == null && top == null) {
                return null;
            }
            if (right == null && bottom == null || right != null && bottom != null) {
                return null;
            }
            if (left == null) {
                if (right == null) {
                    return new Ref(0, top, Ref.MAX_COL - 1, bottom);
                }
                return null;
            }
            if (bottom == null) {
                return new Ref(left, 0, right, Ref.MAX_ROW - 1);
            }
            return null;
        }
        return null;
    }

    private static boolean isAToZ(int code) {
        return 65 <= code && code <= 90;
    }

    private static boolean is0To9(int code) {
        return 48 <= code && code <= 57;
    }

    private static List splitA1(String a1) {
        a1 = a1.trim().toUpperCase();
        boolean absc = a1.startsWith("$");
        boolean absr = false;
        if (absc) {
            a1 = a1.substring(1);
        }
        int len = a1.length();
        int s = -1;
        int m = -1;
        for (int j = 0; j < len; ++j) {
            char code = a1.charAt(j);
            if (Converter.isAToZ(code)) {
                if (m >= 0) {
                    return null;
                }
                if (s >= 0) continue;
                s = j;
                continue;
            }
            if (Converter.is0To9(code) || m < 0 && code == '$') {
                if (m >= 0) continue;
                m = j;
                continue;
            }
            return null;
        }
        Integer n = null;
        Integer a = null;
        if (s < 0) {
            if (m >= 0) {
                n = Integer.parseInt(a1) - 1;
                absr = absc;
                absc = false;
            }
        } else if (m < 0) {
            a = Converter.abcToNum(a1);
        } else {
            String r = a1.substring(m);
            absr = r.startsWith("$");
            if (absr) {
                r = r.substring(1);
            }
            if (r.isEmpty()) {
                return null;
            }
            n = Integer.parseInt(r) - 1;
            a = Converter.abcToNum(a1.substring(s, m));
        }
        if (n != null && (n < 0 || n >= Ref.MAX_ROW)) {
            return null;
        }
        if (a != null && a >= Ref.MAX_COL) {
            return null;
        }
        return Arrays.asList(a, n, absc, absr);
    }

    public static int abcToNum(String val) {
        int index = 0;
        int len = val.length();
        for (int j = 0; j < len; ++j) {
            char code = val.charAt(j);
            if (code < 'A' || code > 'Z') {
                throw new IllegalArgumentException("The char code is ouf of range [" + code + "]");
            }
            int digit = code - 64;
            index = index * 26 + digit;
        }
        return index - 1;
    }

    public static List<Ref> toRefs(String refs) {
        return Converter.toRefs(refs, " ");
    }

    public static List<Ref> toRefs(String refs, String separator) {
        return Stream.of(refs.split(separator)).map(s -> Converter.a1ToRef(s)).collect(Collectors.toList());
    }

    public static String refToA1(Ref ref) {
        if (ref.isCell()) {
            return Converter.numToAbc(ref.getLeft()) + (ref.getTop() + 1);
        }
        return Converter.numToAbc(ref.getLeft()) + (ref.getTop() + 1) + ":" + Converter.numToAbc(ref.getRight()) + (ref.getBottom() + 1);
    }

    public static final <T> List<T> asList(T ... ary) {
        if (ary == null || ary.length == 0) {
            return Collections.EMPTY_LIST;
        }
        return Stream.of(ary).collect(Collectors.toList());
    }

    public static Map asMap(Object ... args) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(args.length / 2);
        for (int i = 0; i < args.length; i += 2) {
            map.put(args[i], args[i + 1]);
        }
        return map;
    }

    public static int ptToPx(Number pt) {
        return (int)(pt.doubleValue() * 4.0 / 3.0);
    }

    public static <T> T getFirst(T ... args) {
        if (args == null || args.length == 0) {
            return null;
        }
        return args[0];
    }

    public static <T> T getLast(T ... args) {
        if (args == null || args.length == 0) {
            return null;
        }
        return args[args.length - 1];
    }
}

