/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl.imexp;

import io.keikai.model.SBook;
import io.keikai.model.SChart;
import io.keikai.model.SColorFilter;
import io.keikai.model.SColumn;
import io.keikai.model.SCustomFilters;
import io.keikai.model.SDynamicFilter;
import io.keikai.model.SSheet;
import io.keikai.model.SSheetProtection;
import io.keikai.model.STop10Filter;
import io.keikai.model.chart.SGeneralChartData;
import io.keikai.model.chart.SSeries;
import io.keikai.model.impl.AbstractBookAdv;
import io.keikai.range.impl.imexp.AbstractExcelImporter;
import io.keikai.range.impl.imexp.HSSFChartDecoder;
import io.keikai.range.impl.imexp.ImExpUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.model.InternalSheet;
import org.apache.poi.hssf.record.chart.BarRecord;
import org.apache.poi.hssf.record.chart.LinkedDataRecord;
import org.apache.poi.hssf.record.chart.PieRecord;
import org.apache.poi.hssf.record.chart.ScatterRecord;
import org.apache.poi.hssf.usermodel.HSSFChart;
import org.apache.poi.hssf.usermodel.HSSFChartShape;
import org.apache.poi.hssf.usermodel.HSSFName;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPatriarchHelper;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.ColorFilter;
import org.apache.poi.ss.usermodel.CustomFilters;
import org.apache.poi.ss.usermodel.DynamicFilter;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetProtection;
import org.apache.poi.ss.usermodel.Top10Filter;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelXlsImporter
extends AbstractExcelImporter {
    private static final long serialVersionUID = 4264381303912394965L;

    @Override
    protected Workbook createPoiBook(InputStream is) throws IOException {
        return new HSSFWorkbook(is);
    }

    @Override
    protected void importExternalBookLinks() {
    }

    protected int getLastChangedColumnIndex(Sheet poiSheet) {
        return ((HSSFSheet)poiSheet).getSheet().getMaxColumnIndex();
    }

    @Override
    protected void importColumn(Sheet poiSheet, SSheet sheet) {
        InternalSheet internalSheet = ((HSSFSheet)poiSheet).getSheet();
        int lastChangedColumnIndex = this.getLastChangedColumnIndex(poiSheet);
        int defaultWidth = sheet.getDefaultColumnWidth();
        int charWidth = ((AbstractBookAdv)this.book).getCharWidth();
        for (int index = 0; index <= lastChangedColumnIndex; ++index) {
            CellStyle columnStyle;
            SColumn column = sheet.getColumn(index);
            boolean hidden = poiSheet.isColumnHidden(index);
            column.setHidden(hidden);
            boolean isCustomWidth = internalSheet.isColumnUserSet(index);
            column.setCustomWidth(isCustomWidth);
            int width = ImExpUtils.getWidthAny(poiSheet, index, charWidth);
            if (!hidden && width != defaultWidth) {
                column.setWidth(width);
            }
            if ((columnStyle = poiSheet.getColumnStyle(index)) == null) continue;
            column.setCellStyle(this.importCellStyle(columnStyle));
        }
    }

    protected void importChart(List<HSSFChartShape> poiCharts, Sheet poiSheet, SSheet sheet) {
        for (HSSFChartShape zssChart : poiCharts) {
            HSSFChart hssfChart = zssChart.getChart();
            SChart.ChartType type = this.convertChartType(hssfChart);
            SChart chart = null;
            if (type == null) continue;
            chart = sheet.addChart(zssChart.getName(), type, this.toViewAnchor(poiSheet, zssChart.getPreferredSize()));
            switch (type) {
                case SCATTER: {
                    this.importXySeries(Arrays.asList(hssfChart.getSeries()), (SGeneralChartData)chart.getData());
                    break;
                }
                case BUBBLE: {
                    this.importXyzSeries(Arrays.asList(hssfChart.getSeries()), (SGeneralChartData)chart.getData());
                    break;
                }
                default: {
                    this.importSeries(Arrays.asList(hssfChart.getSeries()), (SGeneralChartData)chart.getData());
                }
            }
            if (this.getChartTitle(hssfChart) != null) {
                chart.setTitle(hssfChart.getChartTitle());
            }
            chart.setThreeD(hssfChart.getChart3D() != null);
            chart.setLegendPosition(SChart.ChartLegendPosition.RIGHT);
            this.importAxis(hssfChart, chart);
        }
    }

    protected void importAxis(HSSFChart hssfChart, SChart chart) {
    }

    protected SChart.ChartType convertChartType(HSSFChart hssfChart) {
        if (hssfChart.getType() != null) {
            switch (hssfChart.getType()) {
                case Area: {
                    return SChart.ChartType.AREA;
                }
                case Bar: {
                    return ((BarRecord)hssfChart.getShapeRecord()).isHorizontal() ? SChart.ChartType.BAR : SChart.ChartType.COLUMN;
                }
                case Line: {
                    return SChart.ChartType.LINE;
                }
                case Pie: {
                    return ((PieRecord)hssfChart.getShapeRecord()).getPcDonut() == 0 ? SChart.ChartType.PIE : SChart.ChartType.DOUGHNUT;
                }
                case Scatter: {
                    return ((ScatterRecord)hssfChart.getShapeRecord()).isBubbles() ? SChart.ChartType.BUBBLE : SChart.ChartType.SCATTER;
                }
            }
        }
        return null;
    }

    @Override
    protected void importDrawings(Sheet poiSheet, SSheet sheet) {
        LinkedList<HSSFChartShape> poiCharts = new LinkedList<HSSFChartShape>();
        LinkedList<Picture> poiPictures = new LinkedList<Picture>();
        HSSFPatriarch patriarch = ((HSSFSheet)poiSheet).getDrawingPatriarch();
        if (patriarch != null) {
            HSSFPatriarchHelper helper = new HSSFPatriarchHelper(patriarch);
            for (HSSFShape shape : patriarch.getChildren()) {
                if (shape instanceof HSSFPicture) {
                    poiPictures.add((Picture)shape);
                    continue;
                }
                if (!(shape instanceof HSSFChartShape)) continue;
                new HSSFChartDecoder(helper, (HSSFChartShape)shape).decode();
                poiCharts.add((HSSFChartShape)shape);
            }
        }
        this.importChart(poiCharts, poiSheet, sheet);
        this.importPicture(poiPictures, poiSheet, sheet);
    }

    @Override
    protected int getAnchorHeightInPx(ClientAnchor anchor, Sheet poiSheet) {
        int firstRow = anchor.getRow1();
        int firstYoffset = anchor.getDy1();
        int firstRowHeight = ImExpUtils.getHeightAny(poiSheet, firstRow);
        int offsetInFirstRow = (int)Math.round((double)firstRowHeight * (double)firstYoffset / 256.0);
        int anchorHeightInFirstRow = firstYoffset >= 256 ? 0 : firstRowHeight - offsetInFirstRow;
        int lastRow = anchor.getRow2();
        int lastRowHeight = ImExpUtils.getHeightAny(poiSheet, lastRow);
        int anchorHeightInLastRow = (int)Math.round((double)lastRowHeight * (double)anchor.getDy2() / 256.0);
        int height = lastRow == firstRow ? anchorHeightInLastRow - offsetInFirstRow : anchorHeightInFirstRow + anchorHeightInLastRow;
        for (int row = firstRow + 1; row < lastRow; ++row) {
            height += ImExpUtils.getHeightAny(poiSheet, row);
        }
        return height;
    }

    @Override
    protected int getAnchorWidthInPx(ClientAnchor anchor, Sheet sheet) {
        int charWidth = ((AbstractBookAdv)this.book).getCharWidth();
        short firstColumn = anchor.getCol1();
        int firstXoffset = anchor.getDx1();
        int firstColumnWidthPixel = ImExpUtils.getWidthAny(sheet, firstColumn, charWidth);
        int offsetInFirstColumn = (int)Math.round((double)firstColumnWidthPixel * (double)firstXoffset / 1024.0);
        int anchorWidthInFirstColumn = firstXoffset >= 1024 ? 0 : firstColumnWidthPixel - offsetInFirstColumn;
        short lastColumn = anchor.getCol2();
        int lastColumnWidth = ImExpUtils.getWidthAny(sheet, lastColumn, charWidth);
        int anchorWidthInLastColumn = (int)Math.round((double)lastColumnWidth * (double)anchor.getDx2() / 1024.0);
        int width = firstColumn == lastColumn ? anchorWidthInLastColumn - offsetInFirstColumn : anchorWidthInFirstColumn + anchorWidthInLastColumn;
        for (int col = firstColumn + 1; col < lastColumn; ++col) {
            width += ImExpUtils.getWidthAny(sheet, col, charWidth);
        }
        return width;
    }

    protected void importSeries(List<HSSFChart.HSSFSeries> seriesList, SGeneralChartData chartData) {
        HSSFChart.HSSFSeries firstSeries = null;
        firstSeries = seriesList.get(0);
        if (firstSeries != null) {
            chartData.setCategoriesFormula(this.getCategoryFormula(firstSeries.getDataCategoryLabels()));
        }
        for (int i = 0; i < seriesList.size(); ++i) {
            HSSFChart.HSSFSeries sourceSeries = seriesList.get(i);
            String nameExpression = this.getTitleFormula(sourceSeries, i);
            String xValueExpression = this.getValueFormula(sourceSeries.getDataValues());
            SSeries series = chartData.addSeries();
            series.setFormula(nameExpression, xValueExpression);
        }
    }

    protected void importXySeries(List<HSSFChart.HSSFSeries> seriesList, SGeneralChartData chartData) {
        for (int i = 0; i < seriesList.size(); ++i) {
            HSSFChart.HSSFSeries sourceSeries = seriesList.get(i);
            String nameExpression = this.getTitleFormula(sourceSeries, i);
            String xValueExpression = this.getValueFormula(sourceSeries.getDataCategoryLabels());
            String yValueExpression = this.getValueFormula(sourceSeries.getDataValues());
            SSeries series = chartData.addSeries();
            series.setXYFormula(nameExpression, xValueExpression, yValueExpression);
        }
    }

    protected void importXyzSeries(List<HSSFChart.HSSFSeries> seriesList, SGeneralChartData chartData) {
        for (int i = 0; i < seriesList.size(); ++i) {
            HSSFChart.HSSFSeries sourceSeries = seriesList.get(i);
            String nameExpression = this.getTitleFormula(sourceSeries, i);
            String xValueExpression = this.getValueFormula(sourceSeries.getDataCategoryLabels());
            String yValueExpression = this.getValueFormula(sourceSeries.getDataValues());
            String zValueExpression = this.getValueFormula(sourceSeries.getDataSecondaryCategoryLabels());
            SSeries series = chartData.addSeries();
            series.setXYZFormula(nameExpression, xValueExpression, yValueExpression, zValueExpression);
        }
    }

    protected String getValueFormula(LinkedDataRecord dataValues) {
        if (dataValues.getReferenceType() == 2) {
            return HSSFFormulaParser.toFormulaString((HSSFWorkbook)((HSSFWorkbook)this.workbook), (Ptg[])dataValues.getFormulaOfLink());
        }
        return "0";
    }

    protected String getCategoryFormula(LinkedDataRecord dataCategoryLabels) {
        if (dataCategoryLabels.getReferenceType() == 2) {
            return HSSFFormulaParser.toFormulaString((HSSFWorkbook)((HSSFWorkbook)this.workbook), (Ptg[])dataCategoryLabels.getFormulaOfLink());
        }
        return "";
    }

    protected String getTitleFormula(HSSFChart.HSSFSeries series, int index) {
        if (series.getDataName().getReferenceType() == 2) {
            return HSSFFormulaParser.toFormulaString((HSSFWorkbook)((HSSFWorkbook)this.workbook), (Ptg[])series.getDataName().getFormulaOfLink());
        }
        return series.getSeriesTitle() == null ? "\"Series" + index + "\"" : "\"" + series.getSeriesTitle() + "\"";
    }

    protected String getChartTitle(HSSFChart hssfChart) {
        if (!hssfChart.isAutoTitleDeleted()) {
            return hssfChart.getChartTitle();
        }
        return null;
    }

    @Override
    protected int getXoffsetInPixel(ClientAnchor anchor, Sheet poiSheet) {
        int charWidth = ((AbstractBookAdv)this.book).getCharWidth();
        short firstColumn = anchor.getCol1();
        int firstXoffset = anchor.getDx1();
        int columnWidthPixel = ImExpUtils.getWidthAny(poiSheet, firstColumn, charWidth);
        return firstXoffset >= 1024 ? columnWidthPixel : (int)Math.round((double)columnWidthPixel * (double)firstXoffset / 1024.0);
    }

    @Override
    protected int getYoffsetInPixel(ClientAnchor anchor, Sheet poiSheet) {
        int firstRow = anchor.getRow1();
        int firstYoffset = anchor.getDy1();
        int rowHeightPixel = ImExpUtils.getHeightAny(poiSheet, firstRow);
        return firstYoffset >= 256 ? rowHeightPixel : (int)Math.round((double)rowHeightPixel * (double)firstYoffset / 256.0);
    }

    @Override
    protected void importValidation(Sheet poiSheet, SSheet sheet) {
    }

    @Override
    protected boolean skipName(Name definedName) {
        boolean r = super.skipName(definedName);
        if (r) {
            return r;
        }
        return ((HSSFName)definedName).isBuiltInName();
    }

    @Override
    protected void setBookType(SBook book) {
        book.setAttribute(BOOK_TYPE_KEY, "xls");
    }

    @Override
    protected void importPassword(Sheet poiSheet, SSheet sheet) {
        short hashpass = ((HSSFSheet)poiSheet).getPassword();
        sheet.setHashedPassword(hashpass);
    }

    @Override
    protected void importSheetProtection(Sheet poiSheet, SSheet sheet) {
        SheetProtection sp = ((HSSFSheet)poiSheet).getOrCreateSheetProtection();
        SSheetProtection ssp = sheet.getSheetProtection();
        ssp.setAutoFilter(sp.isAutoFilter());
        ssp.setDeleteColumns(sp.isDeleteColumns());
        ssp.setDeleteRows(sp.isDeleteRows());
        ssp.setFormatCells(sp.isFormatCells());
        ssp.setFormatColumns(sp.isFormatColumns());
        ssp.setFormatRows(sp.isFormatRows());
        ssp.setInsertColumns(sp.isInsertColumns());
        ssp.setInsertHyperlinks(sp.isInsertHyperlinks());
        ssp.setInsertRows(sp.isInsertRows());
        ssp.setPivotTables(sp.isPivotTables());
        ssp.setSort(sp.isSort());
        ssp.setObjects(!sp.isObjects() ? false : poiSheet.getProtect());
        ssp.setScenarios(!sp.isScenarios() ? false : poiSheet.getProtect());
        ssp.setSelectLockedCells(sp.isSelectLockedCells());
        ssp.setSelectUnlockedCells(sp.isSelectUnlockedCells());
    }

    @Override
    protected void importTables(Sheet poiSheet, SSheet sheet) {
    }

    @Override
    protected void importConditionalFormatting(SSheet sheet, Sheet poiSheet) {
    }

    protected SColorFilter importColorFilter(ColorFilter colorFilter) {
        return null;
    }

    protected SCustomFilters importCustomFilters(CustomFilters customFilters) {
        return null;
    }

    protected SDynamicFilter importDynamicFilter(DynamicFilter dynamicFilter) {
        return null;
    }

    protected STop10Filter importTop10Filter(Top10Filter top10Filter) {
        return null;
    }
}

