/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.sys.formula;

import io.keikai.model.SBook;
import io.keikai.model.SCell;
import io.keikai.model.SSheet;
import io.keikai.model.sys.AbstractContext;
import io.keikai.model.sys.dependency.Ref;
import io.keikai.model.sys.formula.FormulaType;
import java.io.Serializable;
import java.util.Locale;

public class FormulaParseContext
extends AbstractContext
implements Serializable {
    private static final long serialVersionUID = 156103193833822863L;
    private final Ref _dependent;
    private final SBook _book;
    private final SSheet _sheet;
    private final SCell _cell;
    private final String _sheetName;
    private final FormulaType _formulaType;

    public FormulaParseContext(SCell cell, Ref dependent) {
        this(cell, cell.getSheet().getSheetName(), dependent);
    }

    public FormulaParseContext(SCell cell, Ref dependent, FormulaType formulaType) {
        this(cell, cell.getSheet().getSheetName(), dependent, formulaType);
    }

    public FormulaParseContext(SCell cell, String sheetName, Ref dependent) {
        this(cell.getSheet().getBook(), cell.getSheet(), cell, sheetName, dependent);
    }

    public FormulaParseContext(SCell cell, String sheetName, Ref dependent, FormulaType formulaType) {
        this(cell.getSheet().getBook(), cell.getSheet(), cell, sheetName, dependent, formulaType);
    }

    public FormulaParseContext(SSheet sheet, Ref dependent) {
        this(sheet, sheet.getSheetName(), dependent);
    }

    public FormulaParseContext(SSheet sheet, Ref dependent, FormulaType formulaType) {
        this(sheet, sheet.getSheetName(), dependent, formulaType);
    }

    public FormulaParseContext(SSheet sheet, String sheetName, Ref dependent) {
        this(sheet.getBook(), sheet, null, sheetName, dependent);
    }

    public FormulaParseContext(SSheet sheet, String sheetName, Ref dependent, FormulaType formulaType) {
        this(sheet.getBook(), sheet, null, sheetName, dependent, Locale.US, formulaType);
    }

    public FormulaParseContext(SBook book, Ref dependent) {
        this(book, null, null, null, dependent);
    }

    public FormulaParseContext(SBook book, Ref dependent, FormulaType formulaType) {
        this(book, null, null, null, dependent, formulaType);
    }

    public FormulaParseContext(SBook book, SSheet sheet, SCell cell, String sheetName, Ref dependent) {
        this(book, sheet, cell, sheetName, dependent, Locale.US, FormulaType.CELL);
    }

    public FormulaParseContext(SBook book, SSheet sheet, SCell cell, String sheetName, Ref dependent, FormulaType formulaType) {
        this(book, sheet, cell, sheetName, dependent, Locale.US, formulaType);
    }

    public FormulaParseContext(SBook book, SSheet sheet, SCell cell, String sheetName, Ref dependent, Locale locale, FormulaType formulaType) {
        super(locale);
        this._book = book;
        this._sheet = sheet;
        this._cell = cell;
        this._dependent = dependent;
        this._sheetName = sheetName;
        this._formulaType = formulaType;
    }

    public Ref getDependent() {
        return this._dependent;
    }

    public SBook getBook() {
        return this._book;
    }

    public SSheet getSheet() {
        return this._sheet;
    }

    public SCell getCell() {
        return this._cell;
    }

    public String getSheetName() {
        return this._sheetName;
    }

    public FormulaType getFormulaType() {
        return this._formulaType;
    }
}

