/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.CellRegion;
import io.keikai.model.ModelEventListener;
import io.keikai.model.SCell;
import io.keikai.model.SSheet;
import io.keikai.model.SerializableConsumer;
import io.keikai.model.impl.AbstractCellAdv;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CellValueChangeEventHandler
implements Serializable {
    private static final long serialVersionUID = 20250116143212L;
    private SSheet _sheet;
    private Map<CellRegion, Set<SerializableConsumer<CellRegion>>> _cellRegionValueChangeListeners = new HashMap<CellRegion, Set<SerializableConsumer<CellRegion>>>(1);
    private Map<CellRegion, Object> _cachedCellValues = new HashMap<CellRegion, Object>(1);
    private Map<CellRegion, Object> _cachedCellFormulaResult = new HashMap<CellRegion, Object>(1);
    private final ModelEventListener _modelEventListener;

    CellValueChangeEventHandler(SSheet ss) {
        this._sheet = ss;
        this._modelEventListener = event -> {
            String eventName = event.getName();
            CellRegion region = event.getRegion();
            if ("onBeforeCellValueChange".equals(eventName)) {
                int row = region.getRow();
                int column = region.getColumn();
                SCell cell = this._sheet.getCell(row, column);
                this._cachedCellValues.put(region, cell.getValue());
                if (SCell.CellType.FORMULA == cell.getType()) {
                    this._cachedCellFormulaResult.put(region, ((AbstractCellAdv)cell).getValue(true));
                }
            } else if (eventName.equals("onCellChange")) {
                for (Map.Entry<CellRegion, Set<SerializableConsumer<CellRegion>>> entry : this._cellRegionValueChangeListeners.entrySet()) {
                    CellRegion overlap = entry.getKey().getOverlap(event.getRegion());
                    if (overlap == null) continue;
                    for (SerializableConsumer<CellRegion> consumer : entry.getValue()) {
                        int row = overlap.getRow();
                        int column = overlap.getColumn();
                        for (int r = row; r <= overlap.getLastRow(); ++r) {
                            for (int c = column; c <= overlap.getLastColumn(); ++c) {
                                CellRegion cellRegion = new CellRegion(r, c);
                                if (!this.isCellValueChanged(cellRegion)) continue;
                                consumer.accept(cellRegion);
                            }
                        }
                    }
                }
                this.clearCachedCellValues();
            }
        };
        ss.getBook().addEventListener(this._modelEventListener);
    }

    private boolean isCellValueChanged(CellRegion cellRegion) {
        Object cachedCellValue = this._cachedCellValues.get(cellRegion);
        SCell cell = this._sheet.getCell(cellRegion.getRow(), cellRegion.getColumn());
        Object cellValue = cell.getValue();
        if (cachedCellValue instanceof Number && cellValue instanceof Number) {
            return ((Number)cachedCellValue).doubleValue() != ((Number)cellValue).doubleValue();
        }
        boolean isSame = Objects.equals(cachedCellValue, cellValue);
        if (isSame && SCell.CellType.FORMULA == cell.getType()) {
            return !Objects.equals(this._cachedCellFormulaResult.get(cellRegion), ((AbstractCellAdv)cell).getValue(true));
        }
        return !isSame;
    }

    private void clearCachedCellValues() {
        this._cachedCellValues.clear();
        this._cachedCellFormulaResult.clear();
    }

    void addCellRegionValueChangeListener(CellRegion cellRegion, SerializableConsumer<CellRegion> listener) {
        Set<SerializableConsumer<CellRegion>> consumers = this._cellRegionValueChangeListeners.get(cellRegion);
        if (consumers == null) {
            consumers = new HashSet<SerializableConsumer<CellRegion>>();
            this._cellRegionValueChangeListeners.put(cellRegion, consumers);
        }
        consumers.add(listener);
    }

    boolean removeCellRegionValueChangeListener(CellRegion cellRegion) {
        return this._cellRegionValueChangeListeners.remove(cellRegion) != null;
    }

    boolean removeCellRegionValueChangeListener(SerializableConsumer<CellRegion> listener) {
        Map<CellRegion, Set<SerializableConsumer<CellRegion>>> listeners = this._cellRegionValueChangeListeners;
        boolean found = false;
        for (Map.Entry<CellRegion, Set<SerializableConsumer<CellRegion>>> entry : listeners.entrySet()) {
            boolean removed = entry.getValue().remove(listener);
            if (found || !removed) continue;
            found = true;
        }
        return found;
    }

    void destroy() {
        this._sheet.getBook().removeEventListener(this._modelEventListener);
        this._cellRegionValueChangeListeners.clear();
        this._cachedCellValues.clear();
    }
}

