/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.importer;

import io.keikai.util.Converter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Colors {
    private static final List<String> BUILTIN_INDEXED_COLORS = Converter.asList("ff000000", "ffffffff", "ffff0000", "ff00ff00", "ff0000ff", "ffffff00", "ffff00ff", "ff00ffff", "ff000000", "ffffffff", "ffff0000", "ff00ff00", "ff0000ff", "ffffff00", "ffff00ff", "ff00ffff", "ff800000", "ff008000", "ff000080", "ff808000", "ff800080", "ff008080", "ffc0c0c0", "ff808080", "ff9999ff", "ff993366", "ffffffcc", "ffccffff", "ff660066", "ffff8080", "ff0066cc", "ffccccff", "ff000080", "ffff00ff", "ffffff00", "ff00ffff", "ff800080", "ff800000", "ff008080", "ff0000ff", "ff00ccff", "ffccffff", "ffccffcc", "ffffff99", "ff99ccff", "ffff99cc", "ffcc99ff", "ffffcc99", "ff3366ff", "ff33cccc", "ff99cc00", "ffffcc00", "ffff9900", "ffff6600", "ff666699", "ff969696", "ff003366", "ff339966", "ff003300", "ff333300", "ff993300", "ff993366", "ff333399", "ff333333", "ff000000", "ffffffff");
    private List<String> _indexColors = new ArrayList<String>();
    private Map<String, String> _colorsMap = new HashMap<String, String>();
    private boolean ignoreBuiltin;

    public Colors() {
        this(false);
    }

    public Colors(boolean ignoreBuiltin) {
        this.ignoreBuiltin = ignoreBuiltin;
        if (!this.ignoreBuiltin) {
            for (String argb : BUILTIN_INDEXED_COLORS) {
                this.addIndexedColor(argb);
            }
        }
    }

    public String getIndexColorByIndex(int index) {
        return index >= this._indexColors.size() ? null : this._indexColors.get(index);
    }

    public void addColor(String argb) {
        if (!this._colorsMap.containsKey(argb)) {
            this.addIndexedColor(argb);
        }
    }

    public void addIndexedColor(String argb) {
        String exist = this._colorsMap.get(argb);
        if (exist != null) {
            this._indexColors.add(exist);
        } else {
            this._indexColors.add(argb);
            this._colorsMap.put(argb, argb);
        }
    }
}

