/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl;

import io.keikai.model.CellRegion;
import io.keikai.model.SBook;
import io.keikai.model.SBookSeries;
import io.keikai.model.SConditionalFormatting;
import io.keikai.model.SSheet;
import io.keikai.model.SheetRegion;
import io.keikai.model.impl.CellAttribute;
import io.keikai.model.sys.dependency.ConditionalRef;
import io.keikai.model.sys.dependency.ObjectRef;
import io.keikai.model.sys.dependency.Ref;
import io.keikai.range.impl.NotifyChangeHelper;
import io.keikai.range.impl.RefHelperBase;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RefNotifyContentChangeHelper
extends RefHelperBase
implements Serializable {
    private static final long serialVersionUID = -816763214525819388L;
    private static final Logger _logger = LoggerFactory.getLogger(RefNotifyContentChangeHelper.class);
    private NotifyChangeHelper _notifyHelper = new NotifyChangeHelper();

    public RefNotifyContentChangeHelper(SBookSeries bookSeries) {
        super(bookSeries);
    }

    public void notifyContentChange(Ref notify, CellAttribute cellAttr) {
        if (notify.getType() == Ref.RefType.CELL || notify.getType() == Ref.RefType.AREA) {
            this.handleAreaRef(notify, cellAttr);
        } else if (notify.getType() == Ref.RefType.OBJECT) {
            if (((ObjectRef)notify).getObjectType() == ObjectRef.ObjectType.CHART) {
                this.handleChartRef((ObjectRef)notify);
            } else if (((ObjectRef)notify).getObjectType() == ObjectRef.ObjectType.DATA_VALIDATION) {
                this.handleDataValidationRef((ObjectRef)notify);
            } else if (((ObjectRef)notify).getObjectType() == ObjectRef.ObjectType.AUTO_FILTER) {
                this.handleAutoFilterRef((ObjectRef)notify);
            }
        }
    }

    public void notifyContentChange(Set<Ref> notifySet, CellAttribute cellAttr) {
        block7: {
            Ref notify2;
            LinkedHashMap<String, Ref> chartDependents = new LinkedHashMap<String, Ref>();
            LinkedHashMap<String, Ref> validationDependents = new LinkedHashMap<String, Ref>();
            for (Ref notify2 : notifySet) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Notify Dependent Change : " + String.valueOf(notify2) + " with attibute " + String.valueOf((Object)cellAttr));
                }
                if (notify2.getType() == Ref.RefType.CELL || notify2.getType() == Ref.RefType.AREA) {
                    this.handleAreaRef(notify2, cellAttr);
                    continue;
                }
                if (notify2.getType() == Ref.RefType.OBJECT) {
                    if (((ObjectRef)notify2).getObjectType() == ObjectRef.ObjectType.CHART) {
                        chartDependents.put(((ObjectRef)notify2).getObjectIdPath()[0], notify2);
                        continue;
                    }
                    if (((ObjectRef)notify2).getObjectType() == ObjectRef.ObjectType.DATA_VALIDATION) {
                        validationDependents.put(((ObjectRef)notify2).getObjectIdPath()[0], notify2);
                        continue;
                    }
                    if (((ObjectRef)notify2).getObjectType() != ObjectRef.ObjectType.AUTO_FILTER) continue;
                    this.handleAutoFilterRef((ObjectRef)notify2);
                    continue;
                }
                if (notify2.getType() != Ref.RefType.CONDITIONAL) continue;
                this.handleConditionalRef(notify2, cellAttr);
            }
            for (Ref notify2 : chartDependents.values()) {
                this.handleChartRef((ObjectRef)notify2);
            }
            Iterator<Ref> iterator = validationDependents.values().iterator();
            if (!iterator.hasNext()) break block7;
            notify2 = iterator.next();
            this.handleDataValidationRef((ObjectRef)notify2);
        }
    }

    private void handleChartRef(ObjectRef notify) {
        SBook book = this.bookSeries.getBook(notify.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(notify.getSheetName());
        if (sheet == null) {
            return;
        }
        String[] ids = notify.getObjectIdPath();
        this._notifyHelper.notifyChartChange(sheet, ids[0]);
    }

    private void handleDataValidationRef(ObjectRef notify) {
        SBook book = this.bookSeries.getBook(notify.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(notify.getSheetName());
        if (sheet == null) {
            return;
        }
        String[] ids = notify.getObjectIdPath();
        this._notifyHelper.notifyDataValidationChange(sheet, ids[0]);
    }

    private void handleAutoFilterRef(ObjectRef notify) {
        SBook book = this.bookSeries.getBook(notify.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(notify.getSheetName());
        if (sheet == null) {
            return;
        }
        this._notifyHelper.notifySheetAutoFilterChange(sheet, null);
    }

    private void handleAreaRef(Ref notify, CellAttribute cellAttr) {
        SBook book = this.bookSeries.getBook(notify.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(notify.getSheetName());
        if (sheet == null) {
            return;
        }
        int row1 = notify.getRow();
        int row2 = notify.getLastRow();
        int col1 = notify.getColumn();
        int col2 = notify.getLastColumn();
        this._notifyHelper.notifyCellChange(new SheetRegion(sheet, row1, col1, row2, col2), cellAttr);
    }

    private void handleConditionalRef(Ref notify, CellAttribute cellAttr) {
        SBook book = this.bookSeries.getBook(notify.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(notify.getSheetName());
        if (sheet == null) {
            return;
        }
        List<SConditionalFormatting> conditionalFormattings = sheet.getConditionalFormattings();
        for (SConditionalFormatting conditionalFormatting : conditionalFormattings) {
            if (conditionalFormatting.getId() != ((ConditionalRef)notify).getConditionalId()) continue;
            Set<CellRegion> regions = conditionalFormatting.getRegions();
            for (CellRegion region : regions) {
                this._notifyHelper.notifyCellChange(new SheetRegion(sheet, region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn()), cellAttr);
            }
        }
    }
}

