/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl;

import io.keikai.model.CellRegion;
import io.keikai.model.InvalidModelOpException;
import io.keikai.model.SAutoFilter;
import io.keikai.model.SBook;
import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SColorFilter;
import io.keikai.model.SCustomFilter;
import io.keikai.model.SCustomFilters;
import io.keikai.model.SDynamicFilter;
import io.keikai.model.SExtraStyle;
import io.keikai.model.SFill;
import io.keikai.model.SRow;
import io.keikai.model.STable;
import io.keikai.model.STop10Filter;
import io.keikai.model.impl.AbstractAutoFilterAdv;
import io.keikai.model.impl.AbstractCellAdv;
import io.keikai.model.impl.AutoFilterImpl;
import io.keikai.model.impl.CellStyleImpl;
import io.keikai.model.impl.CellValue;
import io.keikai.model.impl.ColorFilterImpl;
import io.keikai.model.impl.CustomFilterImpl;
import io.keikai.model.impl.CustomFiltersImpl;
import io.keikai.model.impl.DynamicFilterImpl;
import io.keikai.model.impl.ExtraFillImpl;
import io.keikai.model.impl.ImmutableExtraStyleImpl;
import io.keikai.model.impl.Top10FilterImpl;
import io.keikai.range.SRange;
import io.keikai.range.SRanges;
import io.keikai.range.impl.CellMatch;
import io.keikai.range.impl.DataRegionHelper;
import io.keikai.range.impl.DatesMatch;
import io.keikai.range.impl.GreaterThan;
import io.keikai.range.impl.GreaterThanOrEqual;
import io.keikai.range.impl.LessThan;
import io.keikai.range.impl.LessThanOrEqual;
import io.keikai.range.impl.Matchable;
import io.keikai.range.impl.MonthMatch;
import io.keikai.range.impl.QuarterMatch;
import io.keikai.range.impl.RangeHelperBase;
import io.keikai.util.Span;
import io.keikai.util.SpareSpan;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.DateUtil;
import org.zkoss.lang.Integers;
import org.zkoss.lang.Library;
import org.zkoss.zk.ui.Executions;

public class AutoFilterHelper
extends RangeHelperBase {
    private static final long serialVersionUID = 764704415825488241L;
    private static final SCellStyle BLANK_STYLE = CellStyleImpl.BLANK_STYLE;
    private static Date MIN_DATE;
    public static final boolean FILTER_CASE_SENSITIVE;

    public AutoFilterHelper(SRange range) {
        super(range);
    }

    public CellRegion findAutoFilterRegion() {
        return new DataRegionHelper(this.range).findAutoFilterDataRegion();
    }

    private void adjustFilterBottom(SAutoFilter autoFilter) {
        CellRegion result = this.findAutoFilterRegion();
        if (result != null) {
            int lastRow = Math.max(result.getLastRow(), this.getLastRow());
            ((AbstractAutoFilterAdv)autoFilter).setLastRow(lastRow);
        }
    }

    public SAutoFilter enableTableFilter(STable table, boolean enable) {
        SAutoFilter filter = table.getAutoFilter();
        if (filter != null && !enable) {
            CellRegion region = filter.getRegion();
            SRange toUnhide = SRanges.range(this.sheet, region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn()).getRows();
            toUnhide.setHidden(false);
            table.deleteAutoFilter();
            filter = null;
        } else if (filter == null && enable) {
            table.enableAutoFilter(enable);
            filter = table.getAutoFilter();
        }
        return filter;
    }

    public SAutoFilter enableAutoFilter(boolean enable) {
        SAutoFilter filter = this.sheet.getAutoFilter();
        if (filter != null && !enable) {
            CellRegion region = filter.getRegion();
            SRange toUnhide = SRanges.range(this.sheet, region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn()).getRows();
            toUnhide.setHidden(false);
            this.sheet.deleteAutoFilter();
            filter = null;
        } else if (filter == null && enable) {
            CellRegion region = this.findAutoFilterRegion();
            if (region != null) {
                filter = this.sheet.createAutoFilter(region);
            } else {
                throw new InvalidModelOpException("can't find any data in range");
            }
        }
        return filter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SAutoFilter enableAutoFilter(STable table, int field, SAutoFilter.FilterOp filterOp, Object criteria1, Object criteria2, Boolean showButton) {
        SAutoFilter filter;
        SAutoFilter sAutoFilter = filter = table == null ? this.sheet.getAutoFilter() : table.getAutoFilter();
        if (filter == null) {
            if (table != null) {
                table.enableAutoFilter(true);
                filter = table.getAutoFilter();
            } else {
                CellRegion region = new DataRegionHelper(this.range).findAutoFilterDataRegion();
                if (region == null) throw new InvalidModelOpException("can't find any data in range");
                filter = this.sheet.createAutoFilter(region);
            }
        } else if (table == null && criteria1 != null) {
            this.adjustFilterBottom(filter);
        }
        this.enableAutoFilter0(table, filter, field, filterOp, criteria1, criteria2, showButton);
        return filter;
    }

    public SpareSpan scanShallHide(SAutoFilter autoFilter, int field) {
        int index = field - 1;
        SAutoFilter.NFilterColumn fc = autoFilter.getFilterColumn(index, false);
        SpareSpan spareSpan = new SpareSpan();
        if (fc != null && fc.isFiltered()) {
            CellRegion region = autoFilter.getRegion();
            for (int i = region.getRow() + 1; i <= region.getLastRow(); ++i) {
                if (!this.shallHide(fc, i, region.getColumn())) continue;
                spareSpan.addSpan(i, 1);
            }
        }
        return spareSpan;
    }

    private Matchable<Double> getMatchByTop10Filter(STop10Filter top10Filter) {
        boolean isTop = top10Filter.isTop();
        Double filterVal = top10Filter.getFilterValue();
        return isTop ? new GreaterThanOrEqual<Double>(filterVal) : new LessThanOrEqual<Double>(filterVal);
    }

    private Matchable<Double> getMatchByDynamicFilter(SDynamicFilter dynaFilter) {
        boolean isAbove = "aboveAverage".equals(dynaFilter.getType());
        Double avg = dynaFilter.getValue();
        return isAbove ? new GreaterThan<Double>(avg) : new LessThan<Double>(avg);
    }

    private Matchable<Date> getMatchDateByDynamicFilter(SDynamicFilter dynaFilter) {
        SAutoFilter.FilterOp op = SAutoFilter.FilterOp.valueOf(dynaFilter.getType());
        switch (op) {
            case tomorrow: 
            case today: 
            case yesterday: 
            case nextWeek: 
            case thisWeek: 
            case lastWeek: 
            case nextMonth: 
            case thisMonth: 
            case lastMonth: 
            case nextQuarter: 
            case thisQuarter: 
            case lastQuarter: 
            case nextYear: 
            case thisYear: 
            case lastYear: 
            case yearToDate: {
                Double min = dynaFilter.getValue();
                Double max = dynaFilter.getMaxValue();
                return new DatesMatch(min.intValue(), max.intValue());
            }
            case Q1: {
                return new QuarterMatch(0, 3);
            }
            case Q2: {
                return new QuarterMatch(3, 6);
            }
            case Q3: {
                return new QuarterMatch(6, 9);
            }
            case Q4: {
                return new QuarterMatch(9, 12);
            }
            case M1: {
                return new MonthMatch(0);
            }
            case M2: {
                return new MonthMatch(1);
            }
            case M3: {
                return new MonthMatch(2);
            }
            case M4: {
                return new MonthMatch(3);
            }
            case M5: {
                return new MonthMatch(4);
            }
            case M6: {
                return new MonthMatch(5);
            }
            case M7: {
                return new MonthMatch(6);
            }
            case M8: {
                return new MonthMatch(7);
            }
            case M9: {
                return new MonthMatch(8);
            }
            case M10: {
                return new MonthMatch(9);
            }
            case M11: {
                return new MonthMatch(10);
            }
            case M12: {
                return new MonthMatch(11);
            }
        }
        return null;
    }

    private Double _pickTop10(int col, int row, int row2, int value, boolean isTop, boolean isPercent) {
        if (value <= 0) {
            return null;
        }
        int count = 0;
        boolean error = false;
        ArrayList<Double> list = new ArrayList<Double>();
        for (int r = row + 1; r <= row2; ++r) {
            SCell cell = this.sheet.getCell(r, col);
            CellValue cellval = ((AbstractCellAdv)cell).getEvalCellValue(true);
            if (cellval.getType() == SCell.CellType.ERROR) {
                error = true;
                break;
            }
            if (cellval.getType() != SCell.CellType.NUMBER) continue;
            list.add(((Number)cellval.getValue()).doubleValue());
            ++count;
        }
        if (error) {
            return null;
        }
        Collections.sort(list);
        count = isPercent ? Math.min((int)Math.ceil((double)(count * value) / 100.0), count) : Math.min(count, value);
        return isTop ? (Double)list.get(list.size() - count) : (Double)list.get(count - 1);
    }

    private Double _calcAverage(int col, int row, int row2) {
        double total = 0.0;
        int count = 0;
        boolean error = false;
        for (int r = row; r <= row2; ++r) {
            SCell cell = this.sheet.getCell(r, col);
            CellValue cellval = ((AbstractCellAdv)cell).getEvalCellValue(true);
            if (cellval.getType() == SCell.CellType.ERROR) {
                error = true;
                break;
            }
            if (cellval.getType() != SCell.CellType.NUMBER) continue;
            total += ((Number)cellval.getValue()).doubleValue();
            ++count;
        }
        if (error) {
            return null;
        }
        return total / (double)count;
    }

    private Result _filterByTop10Filter(SAutoFilter filter, SAutoFilter.NFilterColumn fc, int field) {
        STop10Filter top10Filter = fc.getTop10Filter();
        Matchable<Double> match = this.getMatchByTop10Filter(top10Filter);
        return this._filterByNumber(filter, fc, field, match);
    }

    private Result _filterByDynamicFilter(SAutoFilter filter, SAutoFilter.NFilterColumn fc, int field) {
        SDynamicFilter dynaFilter = fc.getDynamicFilter();
        SAutoFilter.FilterOp op = SAutoFilter.FilterOp.valueOf(dynaFilter.getType());
        switch (op) {
            case aboveAverage: 
            case belowAverage: {
                Matchable<Double> match = this.getMatchByDynamicFilter(dynaFilter);
                return this._filterByNumber(filter, fc, field, match);
            }
        }
        Matchable<Date> matchDate = this.getMatchDateByDynamicFilter(dynaFilter);
        return this._filterByDate(filter, fc, field, matchDate);
    }

    private Result _filterByNumber(SAutoFilter filter, SAutoFilter.NFilterColumn fc, int field, Matchable<Double> match) {
        CellRegion affectedArea = filter.getRegion();
        int row1 = affectedArea.getRow();
        int col1 = affectedArea.getColumn();
        int col = col1 + field - 1;
        int row = row1 + 1;
        int row2 = affectedArea.getLastRow();
        int lastVisible = row1;
        SpareSpan hiddenSpan = new SpareSpan();
        SpareSpan visibleSpan = new SpareSpan();
        SpareSpan shallHideSpan = new SpareSpan();
        for (int r = row; r <= row2; ++r) {
            SRow rowobj;
            SCell cell = this.sheet.getCell(r, col);
            CellValue cellval = ((AbstractCellAdv)cell).getEvalCellValue(true);
            Object val = cellval.getValue();
            if (val instanceof Date) {
                val = DateUtil.getExcelDate((Date)((Date)val));
            }
            if (cellval.getType() == SCell.CellType.NUMBER && match.match((Double)val)) {
                rowobj = this.sheet.getRow(r);
                if (rowobj.isHidden()) {
                    if (!this.canUnhide(filter, fc, r, col1)) continue;
                    visibleSpan.addSpan(r, 1);
                    lastVisible = r;
                    continue;
                }
                lastVisible = r;
                continue;
            }
            rowobj = this.sheet.getRow(r);
            if (!rowobj.isHidden()) {
                hiddenSpan.addSpan(r, 1);
            }
            shallHideSpan.addSpan(r, 1);
        }
        return new Result(visibleSpan, hiddenSpan, shallHideSpan, lastVisible);
    }

    private Result _filterByDate(SAutoFilter filter, SAutoFilter.NFilterColumn fc, int field, Matchable<Date> match) {
        CellRegion affectedArea = filter.getRegion();
        int row1 = affectedArea.getRow();
        int col1 = affectedArea.getColumn();
        int col = col1 + field - 1;
        int row = row1 + 1;
        int row2 = affectedArea.getLastRow();
        int lastVisible = row1;
        SpareSpan hiddenSpan = new SpareSpan();
        SpareSpan visibleSpan = new SpareSpan();
        SpareSpan shallHideSpan = new SpareSpan();
        for (int r = row; r <= row2; ++r) {
            SRow rowobj;
            SCell cell = this.sheet.getCell(r, col);
            CellValue cellval = ((AbstractCellAdv)cell).getEvalCellValue(true);
            Object val = cellval.getValue();
            if (cellval.getType() == SCell.CellType.NUMBER && !(val instanceof Date)) {
                val = DateUtil.getJavaDate((double)((Double)val), (TimeZone)TimeZone.getTimeZone("UTC"));
            }
            if (cellval.getType() == SCell.CellType.NUMBER && match.match((Date)val)) {
                rowobj = this.sheet.getRow(r);
                if (rowobj.isHidden()) {
                    if (!this.canUnhide(filter, fc, r, col1)) continue;
                    visibleSpan.addSpan(r, 1);
                    lastVisible = r;
                    continue;
                }
                lastVisible = r;
                continue;
            }
            rowobj = this.sheet.getRow(r);
            if (!rowobj.isHidden()) {
                hiddenSpan.addSpan(r, 1);
            }
            shallHideSpan.addSpan(r, 1);
        }
        return new Result(visibleSpan, hiddenSpan, shallHideSpan, lastVisible);
    }

    private STop10Filter _prepareTop10Filter(Object[] criteria, CellRegion region, int field, SAutoFilter.FilterOp op) {
        int row = region.getRow();
        int row2 = region.getLastRow();
        int col = region.getColumn() + field - 1;
        boolean isTop = criteria[1] == Boolean.TRUE;
        boolean isPercent = criteria[2] == Boolean.TRUE;
        int value = (Integer)criteria[0];
        Double filterVal = this._pickTop10(col, row, row2, value, isTop, isPercent);
        return filterVal == null ? null : new Top10FilterImpl(isTop, value, isPercent, filterVal);
    }

    private SDynamicFilter _prepareDynamicFilter(CellRegion region, int field, SAutoFilter.FilterOp op) {
        int row = region.getRow();
        int row2 = region.getLastRow();
        int col = region.getColumn() + field - 1;
        Double maxVal = null;
        Double val = null;
        boolean fail = false;
        switch (op) {
            case aboveAverage: 
            case belowAverage: {
                val = this._calcAverage(col, row, row2);
                if (val != null) break;
                fail = true;
                break;
            }
            case tomorrow: {
                double[] res = DateUtil.calcTomorrow();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case today: {
                double[] res = DateUtil.calcToday();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case yesterday: {
                double[] res = DateUtil.calcYesterday();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case nextWeek: {
                double[] res = DateUtil.calcNextWeek();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case thisWeek: {
                double[] res = DateUtil.calcThisWeek();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case lastWeek: {
                double[] res = DateUtil.calcLastWeek();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case nextMonth: {
                double[] res = DateUtil.calcNextMonth();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case thisMonth: {
                double[] res = DateUtil.calcThisMonth();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case lastMonth: {
                double[] res = DateUtil.calcLastMonth();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case nextQuarter: {
                double[] res = DateUtil.calcNextQuarter();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case thisQuarter: {
                double[] res = DateUtil.calcThisQuarter();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case lastQuarter: {
                double[] res = DateUtil.calcLastQuarter();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case nextYear: {
                double[] res = DateUtil.calcNextYear();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case thisYear: {
                double[] res = DateUtil.calcThisYear();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case lastYear: {
                double[] res = DateUtil.calcLastYear();
                val = res[0];
                maxVal = res[1];
                break;
            }
            case yearToDate: {
                double[] res = DateUtil.calcYearToDate();
                val = res[0];
                maxVal = res[1];
                break;
            }
        }
        return fail ? null : new DynamicFilterImpl(maxVal, val, op.name());
    }

    private SCustomFilters _prepareCustomFilters(String[] criteria1, String[] criteria2, boolean isAnd) {
        String val2;
        SAutoFilter.FilterOp op1 = SAutoFilter.FilterOp.valueOf(criteria1[0]);
        String val1 = criteria1[1];
        CustomFilterImpl f1 = new CustomFilterImpl(val1, op1, criteria1.length > 2 ? criteria1[2] : null);
        SAutoFilter.FilterOp op2 = criteria2 != null ? SAutoFilter.FilterOp.valueOf(criteria2[0]) : null;
        String string = val2 = criteria2 != null ? criteria2[1] : null;
        CustomFilterImpl f2 = op2 == null ? null : new CustomFilterImpl(val2, op2, criteria2.length > 2 ? criteria2[2] : null);
        return new CustomFiltersImpl(f1, f2, isAnd);
    }

    private SColorFilter _prepareColorFilter(String[] criteria, boolean byFontColor) {
        SFill.FillPattern pattern = SFill.FillPattern.valueOf(criteria[0]);
        String fg = criteria[1];
        String bg = criteria[2];
        ExtraFillImpl fill = new ExtraFillImpl(pattern, fg, bg);
        ImmutableExtraStyleImpl src = new ImmutableExtraStyleImpl(null, fill, null, null);
        SBook book = this.range.getSheet().getBook();
        SExtraStyle style = book.getOrAddExtraStyle(src);
        return new ColorFilterImpl(style, byFontColor);
    }

    private Matchable<SCell> getMatchByCustomFilters(SCustomFilters filters, int filterType) {
        SCustomFilter f1 = filters.getCustomFilter1();
        SCustomFilter f2 = filters.getCustomFilter2();
        boolean isAnd = filters.isAnd();
        return new CellMatch(f1, f2, isAnd);
    }

    private Result _filterByCustomFilters(SAutoFilter filter, SAutoFilter.NFilterColumn fc, int field) {
        CellRegion affectedArea = filter.getRegion();
        int row1 = affectedArea.getRow();
        int col1 = affectedArea.getColumn();
        int col = col1 + field - 1;
        int row = row1 + 1;
        int row2 = affectedArea.getLastRow();
        int lastVisible = row1;
        SCustomFilters filters = fc.getCustomFilters();
        int filterType = ((AbstractAutoFilterAdv.FilterColumnImpl)fc).getFilterType();
        Matchable<SCell> match = this.getMatchByCustomFilters(filters, filterType);
        SpareSpan hiddenSpan = new SpareSpan();
        SpareSpan visibleSpan = new SpareSpan();
        SpareSpan shallHideSpan = new SpareSpan();
        for (int r = row; r <= row2; ++r) {
            SRow rowobj;
            if (!match.match(this.sheet.getCell(r, col))) {
                rowobj = this.sheet.getRow(r);
                if (!rowobj.isHidden()) {
                    hiddenSpan.addSpan(r, 1);
                }
                shallHideSpan.addSpan(r, 1);
                continue;
            }
            rowobj = this.sheet.getRow(r);
            if (rowobj.isHidden()) {
                if (!this.canUnhide(filter, fc, r, col1)) continue;
                visibleSpan.addSpan(r, 1);
                lastVisible = r;
                continue;
            }
            lastVisible = r;
        }
        return new Result(visibleSpan, hiddenSpan, shallHideSpan, lastVisible);
    }

    private boolean _match(SCellStyle style, SFill fill, boolean byFontColor) {
        if (byFontColor) {
            return fill.getFillColor().equals(style.getFont().getColor());
        }
        return fill.equals(style.getFill());
    }

    private Result _filterByColor(SAutoFilter filter, SAutoFilter.NFilterColumn fc, int field) {
        CellRegion affectedArea = filter.getRegion();
        int row1 = affectedArea.getRow();
        int col1 = affectedArea.getColumn();
        int col = col1 + field - 1;
        int row = row1 + 1;
        int lastRow = affectedArea.getLastRow();
        int lastVisible = row1;
        SFill fill = fc.getColorFilter().getExtraStyle().getFill();
        boolean byFontColor = fc.getColorFilter().isByFontColor();
        if (!byFontColor && fill.getFillPattern() == SFill.FillPattern.SOLID) {
            fill = new ExtraFillImpl(SFill.FillPattern.SOLID, fill.getFillColor(), fill.getBackColor());
        }
        SpareSpan hiddenSpan = new SpareSpan();
        SpareSpan visibleSpan = new SpareSpan();
        SpareSpan shallHideSpan = new SpareSpan();
        for (int r = row; r <= lastRow; ++r) {
            SRow rowobj;
            SCellStyle style;
            SCell cell = this.sheet.getCell(r, col);
            SCellStyle sCellStyle = style = cell.isNull() ? BLANK_STYLE : cell.getCellStyle();
            if (!this._match(style, fill, byFontColor)) {
                rowobj = this.sheet.getRow(r);
                if (!rowobj.isHidden()) {
                    hiddenSpan.addSpan(r, 1);
                }
                shallHideSpan.addSpan(r, 1);
                continue;
            }
            rowobj = this.sheet.getRow(r);
            if (rowobj.isHidden()) {
                if (!this.canUnhide(filter, fc, r, col1)) continue;
                visibleSpan.addSpan(r, 1);
                lastVisible = r;
                continue;
            }
            lastVisible = r;
        }
        return new Result(visibleSpan, hiddenSpan, shallHideSpan, lastVisible);
    }

    Result _filterByValues(SAutoFilter filter, SAutoFilter.NFilterColumn fc, int field) {
        CellRegion affectedArea = filter.getRegion();
        int row1 = affectedArea.getRow();
        int col1 = affectedArea.getColumn();
        int col = col1 + field - 1;
        int row = row1 + 1;
        int row2 = affectedArea.getLastRow();
        int lastVisible = row1;
        Set cr1 = fc.getCriteria1();
        boolean isEmpty = cr1 == null || cr1.isEmpty();
        Set insensitiveCr1 = !isEmpty ? cr1.stream().map(c -> c instanceof String ? ((String)c).toLowerCase() : c).collect(Collectors.toSet()) : cr1;
        SpareSpan hiddenSpan = new SpareSpan();
        SpareSpan visibleSpan = new SpareSpan();
        SpareSpan shallHideSpan = new SpareSpan();
        for (int r = row; r <= row2; ++r) {
            SCell cell = this.sheet.getCell(r, col);
            String val = AutoFilterHelper.isBlank(cell) ? "=" : this.getFormattedText(cell);
            SRow rowobj = this.sheet.getRow(r);
            if (!isEmpty && (FILTER_CASE_SENSITIVE ? !cr1.contains(val) : !insensitiveCr1.contains(val.toLowerCase()))) {
                if (!rowobj.isHidden()) {
                    hiddenSpan.addSpan(r, 1);
                }
                shallHideSpan.addSpan(r, 1);
                continue;
            }
            if (rowobj.isHidden()) {
                if (!this.canUnhide(filter, fc, r, col1)) continue;
                visibleSpan.addSpan(r, 1);
                lastVisible = r;
                continue;
            }
            lastVisible = r;
        }
        return new Result(visibleSpan, hiddenSpan, shallHideSpan, lastVisible);
    }

    private void enableAutoFilter0(STable table, SAutoFilter filter, int field, SAutoFilter.FilterOp filterOp, Object criteria1, Object criteria2, Boolean showButton) {
        boolean isTable;
        SAutoFilter.NFilterColumn fc = filter.getFilterColumn(field - 1, true);
        HashMap<String, Object> extra = new HashMap<String, Object>();
        SDynamicFilter dynaFilter = null;
        STop10Filter top10Filter = null;
        switch (filterOp) {
            case cellColor: 
            case fontColor: {
                extra.put("colorFilter", this._prepareColorFilter((String[])criteria1, filterOp == SAutoFilter.FilterOp.fontColor));
                criteria1 = null;
                break;
            }
            case and: 
            case or: {
                extra.put("customFilters", this._prepareCustomFilters((String[])criteria1, (String[])criteria2, filterOp == SAutoFilter.FilterOp.and));
                criteria1 = null;
                break;
            }
            case tomorrow: 
            case today: 
            case yesterday: 
            case nextWeek: 
            case thisWeek: 
            case lastWeek: 
            case nextMonth: 
            case thisMonth: 
            case lastMonth: 
            case nextQuarter: 
            case thisQuarter: 
            case lastQuarter: 
            case nextYear: 
            case thisYear: 
            case lastYear: 
            case yearToDate: 
            case Q1: 
            case Q2: 
            case Q3: 
            case Q4: 
            case M1: 
            case M2: 
            case M3: 
            case M4: 
            case M5: 
            case M6: 
            case M7: 
            case M8: 
            case M9: 
            case M10: 
            case M11: 
            case M12: 
            case aboveAverage: 
            case belowAverage: {
                dynaFilter = this._prepareDynamicFilter(filter.getRegion(), field, filterOp);
                extra.put("dynamicFilter", dynaFilter == null ? DynamicFilterImpl.NOOP_DYNAFILTER : dynaFilter);
                criteria1 = null;
                break;
            }
            case top10: {
                top10Filter = this._prepareTop10Filter((Object[])criteria1, filter.getRegion(), field, filterOp);
                extra.put("top10Filter", top10Filter == null ? Top10FilterImpl.NOOP_TOP10FILTER : top10Filter);
                criteria1 = null;
            }
        }
        fc.setProperties(filterOp, criteria1, criteria2, showButton, extra);
        Result affectedRows = null;
        switch (filterOp) {
            case cellColor: 
            case fontColor: {
                affectedRows = this._filterByColor(filter, fc, field);
                break;
            }
            case and: 
            case or: {
                affectedRows = this._filterByCustomFilters(filter, fc, field);
                break;
            }
            case tomorrow: 
            case today: 
            case yesterday: 
            case nextWeek: 
            case thisWeek: 
            case lastWeek: 
            case nextMonth: 
            case thisMonth: 
            case lastMonth: 
            case nextQuarter: 
            case thisQuarter: 
            case lastQuarter: 
            case nextYear: 
            case thisYear: 
            case lastYear: 
            case yearToDate: 
            case Q1: 
            case Q2: 
            case Q3: 
            case Q4: 
            case M1: 
            case M2: 
            case M3: 
            case M4: 
            case M5: 
            case M6: 
            case M7: 
            case M8: 
            case M9: 
            case M10: 
            case M11: 
            case M12: 
            case aboveAverage: 
            case belowAverage: {
                if (dynaFilter == null) break;
                affectedRows = this._filterByDynamicFilter(filter, fc, field);
                break;
            }
            case top10: {
                if (top10Filter == null) break;
                affectedRows = this._filterByTop10Filter(filter, fc, field);
                break;
            }
            default: {
                affectedRows = this._filterByValues(filter, fc, field);
            }
        }
        boolean bl = isTable = table != null;
        if (!affectedRows.visible.isEmpty() || !affectedRows.hidden.isEmpty()) {
            Span span;
            int start;
            int end;
            String key = (isTable ? table.getName() : this.sheet.getId()) + "_KK_AFFECTED_ROWS";
            Executions.getCurrent().setAttribute("CONTAINS_" + key, (Object)true);
            SpareSpan visibleSpan = affectedRows.visible;
            SpareSpan hiddenSpan = affectedRows.hidden;
            int j = 0;
            int sz = hiddenSpan.size() + visibleSpan.size();
            Executions.getCurrent().setAttribute(key, (Object)Integers.ZERO);
            if (!hiddenSpan.isEmpty()) {
                end = hiddenSpan.size();
                for (start = 0; start < end; ++start) {
                    span = hiddenSpan.getSpanAt(start);
                    if (++j == sz) {
                        Executions.getCurrent().setAttribute(key, (Object)new Integer(sz));
                    }
                    SRanges.range(this.sheet, span.getStart(), 0, span.getEnd() - 1, 0).getRows().setHidden(true);
                }
            }
            if (!visibleSpan.isEmpty()) {
                end = visibleSpan.size();
                for (start = 0; start < end; ++start) {
                    span = visibleSpan.getSpanAt(start);
                    if (++j == sz) {
                        Executions.getCurrent().setAttribute(key, (Object)new Integer(sz));
                    }
                    SRanges.range(this.sheet, span.getStart(), 0, span.getEnd() - 1, 0).getRows().setHidden(false);
                }
            }
        }
        if (!isTable) {
            filter.setLastVisibleRow(affectedRows.lastVisible);
        }
        ((AutoFilterImpl)filter).setShallHideCache(field, affectedRows.shallHide);
    }

    private boolean canUnhide(SAutoFilter af, SAutoFilter.NFilterColumn fc, int row, int col) {
        Collection<SAutoFilter.NFilterColumn> fltcs = af.getFilterColumns();
        for (SAutoFilter.NFilterColumn fltc : fltcs) {
            if (fc.equals(fltc) || !this.shallHide(fltc, row, col)) continue;
            return false;
        }
        return true;
    }

    private boolean shallHide(SAutoFilter.NFilterColumn fc, int row, int col) {
        SCell cell = this.sheet.getCell(row, col + fc.getIndex());
        SColorFilter colorFilter = fc.getColorFilter();
        if (colorFilter != null) {
            SCellStyle style = cell.isNull() ? BLANK_STYLE : cell.getCellStyle();
            return !this._match(style, colorFilter.getExtraStyle().getFill(), colorFilter.isByFontColor());
        }
        SCustomFilters custFilters = fc.getCustomFilters();
        int filterType = ((AbstractAutoFilterAdv.FilterColumnImpl)fc).getFilterType();
        if (custFilters != null) {
            Matchable<SCell> match = this.getMatchByCustomFilters(custFilters, filterType);
            return !match.match(cell);
        }
        SDynamicFilter dynaFilter = fc.getDynamicFilter();
        if (dynaFilter != null) {
            String type = dynaFilter.getType();
            if ("aboveAverage".equals(type) || "belowAverage".equals(type)) {
                Matchable<Double> match = this.getMatchByDynamicFilter(dynaFilter);
                CellValue cv = ((AbstractCellAdv)cell).getEvalCellValue(true);
                return cv.getType() != SCell.CellType.NUMBER || !match.match((Double)cv.getValue());
            }
            Matchable<Date> match = this.getMatchDateByDynamicFilter(dynaFilter);
            CellValue cv = ((AbstractCellAdv)cell).getEvalCellValue(true);
            Object val = cv.getValue();
            if (cv.getType() == SCell.CellType.NUMBER && !(val instanceof Date)) {
                val = DateUtil.getJavaDate((double)((Double)val), (TimeZone)TimeZone.getTimeZone("UTC"));
            }
            return cv.getType() != SCell.CellType.NUMBER || !match.match((Date)val);
        }
        STop10Filter top10Filter = fc.getTop10Filter();
        if (top10Filter != null) {
            Matchable<Double> match = this.getMatchByTop10Filter(top10Filter);
            CellValue cv = ((AbstractCellAdv)cell).getEvalCellValue(true);
            return cv.getType() != SCell.CellType.NUMBER || !match.match((Double)cv.getValue());
        }
        boolean blank = AutoFilterHelper.isBlank(cell);
        String val = blank ? "=" : this.getFormattedText(cell);
        Set critera1 = fc.getCriteria1();
        return critera1 != null && !critera1.isEmpty() && !critera1.contains(val);
    }

    private void validFiltered(SAutoFilter af) {
        if (af == null) {
            return;
        }
        Collection<SAutoFilter.NFilterColumn> fcs = af.getFilterColumns();
        if (fcs == null) {
            return;
        }
        boolean hasCriteria1 = false;
        for (SAutoFilter.NFilterColumn fc : fcs) {
            Set criteria1 = fc.getCriteria1();
            if (criteria1 == null || criteria1.isEmpty()) continue;
            hasCriteria1 = true;
            break;
        }
        if (!hasCriteria1) {
            throw new InvalidModelOpException("The filter is not applied any criteria");
        }
    }

    public void resetAutoFilter(STable table) {
        SAutoFilter af;
        SAutoFilter sAutoFilter = af = table == null ? this.sheet.getAutoFilter() : table.getAutoFilter();
        if (af == null) {
            return;
        }
        CellRegion afrng = af.getRegion();
        Collection<SAutoFilter.NFilterColumn> fcs = af.getFilterColumns();
        if (fcs == null) {
            return;
        }
        this.validFiltered(af);
        for (SAutoFilter.NFilterColumn fc : fcs) {
            fc.setProperties(SAutoFilter.FilterOp.values, null, null, null, Collections.EMPTY_MAP);
        }
        int row1 = afrng.getRow();
        int row = row1 + 1;
        int row2 = afrng.getLastRow();
        int col1 = afrng.getColumn();
        int col2 = afrng.getLastColumn();
        for (int r = row; r <= row2; ++r) {
            SRow rowobj = this.sheet.getRow(r);
            if (!rowobj.isHidden()) continue;
            SRange rng = SRanges.range(this.sheet, r, 0, r, 0);
            rng.getRows().setHidden(false);
        }
    }

    public void applyAutoFilter(STable table) {
        SAutoFilter oldFilter;
        SAutoFilter sAutoFilter = oldFilter = table == null ? this.sheet.getAutoFilter() : table.getAutoFilter();
        if (oldFilter == null) {
            return;
        }
        this.validFiltered(oldFilter);
        CellRegion region = oldFilter.getRegion();
        int firstRow = region.getRow();
        int firstColumn = region.getColumn();
        ArrayList<Object[]> originalFilteringColumns = new ArrayList<Object[]>();
        if (oldFilter.getFilterColumns() != null) {
            for (SAutoFilter.NFilterColumn filterColumn : oldFilter.getFilterColumns()) {
                Object[] filterColumnData = new Object[]{filterColumn.getIndex() + 1, filterColumn.getCriteria1().toArray(new String[0]), filterColumn.getOperator(), filterColumn.getCriteria2(), filterColumn.isShowButton()};
                originalFilteringColumns.add(filterColumnData);
            }
        }
        SAutoFilter newFilter = null;
        if (table != null) {
            this.enableTableFilter(table, false);
            newFilter = this.enableTableFilter(table, true);
        } else {
            this.enableAutoFilter(false);
            CellRegion filteringRange = new DataRegionHelper.FilterRegionHelper().findOutlineRegion(this.sheet, firstRow, firstColumn, this.getLastRow(), this.getLastColumn());
            if (filteringRange == null) {
                return;
            }
            newFilter = this.sheet.createAutoFilter(filteringRange);
        }
        for (int nCol = 0; nCol < originalFilteringColumns.size(); ++nCol) {
            Object[] oldFilterColumn = (Object[])originalFilteringColumns.get(nCol);
            int field = (Integer)oldFilterColumn[0];
            Object c1 = oldFilterColumn[1];
            SAutoFilter.FilterOp op = (SAutoFilter.FilterOp)((Object)oldFilterColumn[2]);
            Object c2 = oldFilterColumn[3];
            boolean showBtn = (Boolean)oldFilterColumn[4];
            this.enableAutoFilter0(table, newFilter, field, op, c1, c2, showBtn);
        }
    }

    static {
        Calendar cal = Calendar.getInstance();
        cal.set(0, 0, 0, 0, 0, 0);
        MIN_DATE = cal.getTime();
        FILTER_CASE_SENSITIVE = Boolean.valueOf(Library.getProperty((String)"io.keikai.filter.caseSensitive", (String)"true"));
    }

    private static class Result {
        final SpareSpan visible;
        final SpareSpan hidden;
        final SpareSpan shallHide;
        final int lastVisible;

        public Result(SpareSpan visible, SpareSpan hidden, SpareSpan shallHide, int lastVisible) {
            this.visible = visible;
            this.hidden = hidden;
            this.shallHide = shallHide;
            this.lastVisible = lastVisible;
        }
    }
}

