/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.importer;

import io.keikai.util.Converter;
import io.keikai.util.XlsxJsonHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class VmlDrawing {
    private final Map json;
    private final Map _mapEntry;
    private final byte[] imageData;
    Map<String, VShapeJson> _refIdToShape = new HashMap<String, VShapeJson>(3);
    private List<VShapeJson> _shapes;
    Map _idmap;

    public VmlDrawing(Map jsonMap, byte[] imageData) {
        this.json = jsonMap;
        this.imageData = imageData;
        this._mapEntry = (Map)XlsxJsonHelper.$(jsonMap, "xml");
        this._idmap = (Map)XlsxJsonHelper.$x(this._mapEntry, "o:shapelayout/o:idmap");
        Object shapeJson = XlsxJsonHelper.$(this._mapEntry, "v:shape");
        if (shapeJson != null) {
            List<Map> shapeList = shapeJson instanceof List ? (List<Map>)shapeJson : Converter.asList((Map)shapeJson);
            this._shapes = shapeList.stream().map(entry -> new VShapeJson(this, (Map)entry)).collect(Collectors.toList());
            for (VShapeJson shape : this._shapes) {
                this._addToMap(shape);
            }
        } else {
            this._shapes = Collections.EMPTY_LIST;
        }
    }

    public VShapeJson getShape(String refOrId) {
        return this._refIdToShape.get(refOrId);
    }

    private void _addToMap(VShapeJson shape) {
        String spid;
        if (shape.isNote()) {
            this._refIdToShape.put(Converter.rangeToA1(shape.getRow(), shape.getColumn()), shape);
        }
        if ((spid = (String)shape.shape.get("o:spid")) != null) {
            this._refIdToShape.put(spid, shape);
        }
        this._refIdToShape.put(shape.getId(), shape);
    }

    public static class VShapeJson {
        private final VmlDrawing parent;
        private final Map shape;
        private final Map _clientData;
        private final Map<String, String> _style;

        public VShapeJson(VmlDrawing parent, Map shape) {
            this.parent = parent;
            this.shape = shape;
            this._clientData = (Map)XlsxJsonHelper.$(shape, "x:ClientData");
            this._style = Stream.of(shape.get("style").toString().split(";")).map(v -> v.split(":")).collect(Collectors.toMap(v -> v[0].trim(), v -> v[((String[])v).length - 1].trim()));
        }

        public boolean isFormCtrlType() {
            switch (this.getObjectType()) {
                case "Button": 
                case "Label": 
                case "Radio": 
                case "Checkbox": 
                case "GBox": 
                case "Spin": 
                case "Scroll": 
                case "List": 
                case "Drop": {
                    return true;
                }
            }
            return false;
        }

        public String getObjectType() {
            return (String)XlsxJsonHelper.$(this._clientData, "ObjectType");
        }

        public boolean isNote() {
            return "Note".equals(this.getObjectType());
        }

        public int getColumn() {
            return XlsxJsonHelper.toInt(this._clientData, "x:Column");
        }

        public int getRow() {
            return XlsxJsonHelper.toInt(this._clientData, "x:Row");
        }

        public String getId() {
            return (String)XlsxJsonHelper.$(this.shape, "id");
        }

        public String getSpid() {
            return (String)XlsxJsonHelper.$(this.shape, "o:spid");
        }

        public String getFillColor() {
            String fill = Optional.ofNullable(XlsxJsonHelper.$(this.shape, "fillcolor")).orElse(XlsxJsonHelper.$(this.shape, "v:fill", "color2")).toString();
            return Converter.getFirst(fill.split(" "));
        }

        private int toSize(String size) {
            if (size != null && size.length() > 2) {
                return Converter.ptToPx(Double.parseDouble(size.substring(0, size.length() - 2)));
            }
            return 0;
        }

        public int getWidth() {
            return this.toSize(this._style.get("width"));
        }

        public int getHeight() {
            return this.toSize(this._style.get("height"));
        }

        public int getLeft() {
            return this.toSize(this._style.get("margin-left"));
        }

        public int getTop() {
            return this.toSize(this._style.get("margin-top"));
        }

        public boolean isVisibility() {
            return !"hidden".equals(this._style.get("visibility"));
        }

        public String getFmlaRange() {
            String val = (String)XlsxJsonHelper.$(this._clientData, "x:FmlaRange");
            return val != null ? val.trim() : val;
        }

        public String getFmlaLink() {
            String val = (String)XlsxJsonHelper.$(this._clientData, "x:FmlaLink");
            return val != null ? val.trim() : val;
        }

        public int getVal() {
            return XlsxJsonHelper.toInt(this._clientData, "x:Val");
        }

        public int getMin() {
            return XlsxJsonHelper.toInt(this._clientData, "x:Min");
        }

        public int getMax() {
            return XlsxJsonHelper.toInt(this._clientData, "x:Max");
        }

        public int getIncrement() {
            return XlsxJsonHelper.toInt(this._clientData, "x:Inc");
        }

        public boolean isHorizontal() {
            return this._clientData.containsKey("x:Horiz");
        }

        public int getPage() {
            return XlsxJsonHelper.toInt(this._clientData, "x:Page");
        }
    }
}

