/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl.imexp;

import io.keikai.model.SCellStyle;
import io.keikai.model.SExtraStyle;
import io.keikai.model.SFont;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellStyle;

public class StyleCache {
    private final CellStyleCache cellStyleCache = new CellStyleCache();
    private final ExtraStyleCache extraStyleCache = new ExtraStyleCache();
    private final FontCache fontCache = new FontCache();

    public CellStyleCache getCellStyleCache() {
        return this.cellStyleCache;
    }

    public ExtraStyleCache getExtraStyleCache() {
        return this.extraStyleCache;
    }

    FontCache getFontCache() {
        return this.fontCache;
    }

    public void clear() {
        this.cellStyleCache.clear();
        this.extraStyleCache.clear();
        this.fontCache.clear();
    }

    public static class FontCache {
        private final Map<Integer, SFont> fontMap = new HashMap<Integer, SFont>();

        SFont get(int index) {
            return this.fontMap.get(index);
        }

        void put(Integer index, SFont font) {
            this.fontMap.put(index, font);
        }

        void clear() {
            this.fontMap.clear();
        }
    }

    public static class ExtraStyleCache {
        private final List<SExtraStyle> extraStyleCache = new ArrayList<SExtraStyle>();

        public SExtraStyle get(int index) {
            return this.extraStyleCache.get(index);
        }

        void clear() {
            this.extraStyleCache.clear();
        }

        public void add(SExtraStyle extraStyle) {
            this.extraStyleCache.add(extraStyle);
        }
    }

    static class CellStyleCache {
        private final Map<Integer, SCellStyle> indexMap = new HashMap<Integer, SCellStyle>();
        private final Map<CellStyle, SCellStyle> cellStyleMap = new HashMap<CellStyle, SCellStyle>();

        CellStyleCache() {
        }

        public SCellStyle get(CellStyle poiCellStyle) {
            SCellStyle cellStyle = this.indexMap.get(poiCellStyle.getIndex());
            if (cellStyle == null) {
                cellStyle = this.cellStyleMap.get(poiCellStyle);
            }
            return cellStyle;
        }

        public void put(CellStyle poiCellStyle, SCellStyle zssCellStyle) {
            this.indexMap.put(Integer.valueOf(poiCellStyle.getIndex()), zssCellStyle);
            this.cellStyleMap.put(poiCellStyle, zssCellStyle);
        }

        public void clear() {
            this.indexMap.clear();
            this.cellStyleMap.clear();
        }
    }
}

