/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl;

import io.keikai.model.CellRegion;
import io.keikai.model.ErrorValue;
import io.keikai.model.InvalidModelOpException;
import io.keikai.model.PasteCellRegion;
import io.keikai.model.PasteOption;
import io.keikai.model.PasteSheetRegion;
import io.keikai.model.SAutoFilter;
import io.keikai.model.SBook;
import io.keikai.model.SBookSeries;
import io.keikai.model.SBorder;
import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SChart;
import io.keikai.model.SColumn;
import io.keikai.model.SComment;
import io.keikai.model.SDataValidation;
import io.keikai.model.SDependencyTracer;
import io.keikai.model.SFont;
import io.keikai.model.SHyperlink;
import io.keikai.model.SName;
import io.keikai.model.SPicture;
import io.keikai.model.SRichText;
import io.keikai.model.SRow;
import io.keikai.model.SSheet;
import io.keikai.model.SSheetProtection;
import io.keikai.model.SSheetViewInfo;
import io.keikai.model.STable;
import io.keikai.model.SheetRegion;
import io.keikai.model.ViewAnchor;
import io.keikai.model.impl.AbstractBookAdv;
import io.keikai.model.impl.AbstractBookSeriesAdv;
import io.keikai.model.impl.AbstractCellAdv;
import io.keikai.model.impl.AbstractChartAdv;
import io.keikai.model.impl.AbstractDataValidationAdv;
import io.keikai.model.impl.AbstractNameAdv;
import io.keikai.model.impl.AbstractSheetAdv;
import io.keikai.model.impl.CellAttribute;
import io.keikai.model.impl.FormulaCacheCleaner;
import io.keikai.model.impl.NameRefImpl;
import io.keikai.model.impl.OutlineLevelTree;
import io.keikai.model.impl.RefImpl;
import io.keikai.model.impl.SheetImpl;
import io.keikai.model.impl.sys.DependencyTableAdv;
import io.keikai.model.sys.EngineFactory;
import io.keikai.model.sys.dependency.DependencyTable;
import io.keikai.model.sys.dependency.NameRef;
import io.keikai.model.sys.dependency.Ref;
import io.keikai.model.sys.dependency.StyleRef;
import io.keikai.model.sys.format.FormatContext;
import io.keikai.model.sys.format.FormatEngine;
import io.keikai.model.sys.input.InputEngine;
import io.keikai.model.sys.input.InputParseContext;
import io.keikai.model.sys.input.InputResult;
import io.keikai.model.util.FontMatcher;
import io.keikai.model.util.ReadWriteTask;
import io.keikai.model.util.RichTextHelper;
import io.keikai.model.util.Validations;
import io.keikai.range.SRange;
import io.keikai.range.SRanges;
import io.keikai.range.impl.AutoFilterHelper;
import io.keikai.range.impl.AutoFilterUpdate;
import io.keikai.range.impl.BorderHelper;
import io.keikai.range.impl.ChartDataHelper;
import io.keikai.range.impl.ClearCellHelper;
import io.keikai.range.impl.DataRegionHelper;
import io.keikai.range.impl.DataValidationHelper;
import io.keikai.range.impl.DataValidationVerificationHelper;
import io.keikai.range.impl.EmptyNRange;
import io.keikai.range.impl.InsertDeleteHelper;
import io.keikai.range.impl.InsertDeleteUpdate;
import io.keikai.range.impl.MergeHelper;
import io.keikai.range.impl.MergeUpdate;
import io.keikai.range.impl.ModelUpdate;
import io.keikai.range.impl.ModelUpdateCollector;
import io.keikai.range.impl.NotifyChangeHelper;
import io.keikai.range.impl.RefNotifyContentChangeHelper;
import io.keikai.range.impl.SetCellStyleHelper;
import io.keikai.range.impl.SortHelper;
import io.keikai.range.impl.StyleUtil;
import io.keikai.range.impl.autofill.AutoFillHelper;
import io.keikai.util.Converter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.poi.poifs.crypt.CryptoFunctions;
import org.apache.poi.poifs.crypt.HashAlgorithm;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.ZssContext;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellReference;
import org.zkoss.lang.Strings;

public class RangeImpl
implements SRange,
Serializable {
    private static final long serialVersionUID = -4398318214128960856L;
    private SBook _book;
    private final LinkedHashSet<SheetRegion> _rangeRefs = new LinkedHashSet(2);
    private int _column = Integer.MAX_VALUE;
    private int _row = Integer.MAX_VALUE;
    private int _lastColumn = Integer.MIN_VALUE;
    private int _lastRow = Integer.MIN_VALUE;
    private boolean _autoRefresh = true;
    private static final SRange EMPTY_RANGE = new EmptyNRange();

    public RangeImpl(SBook book) {
        this._book = book;
    }

    public RangeImpl(SSheet sheet) {
        this.addRangeRef(sheet, 0, 0, sheet.getBook().getMaxRowIndex(), sheet.getBook().getMaxColumnIndex());
    }

    public RangeImpl(SSheet sheet, int row, int col) {
        this.addRangeRef(sheet, row, col, row, col);
    }

    public RangeImpl(SSheet sheet, int tRow, int lCol, int bRow, int rCol) {
        this.addRangeRef(sheet, tRow, lCol, bRow, rCol);
    }

    public RangeImpl(SSheet sheet, CellRegion region) {
        this.addRangeRef(sheet, region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn());
    }

    private RangeImpl(Collection<SheetRegion> regions) {
        for (SheetRegion region : regions) {
            this.addRangeRef(region.getSheet(), region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn());
        }
    }

    private boolean isAutoRefresh() {
        return this._autoRefresh && !((AbstractBookAdv)this.getBook()).isPostProcessing();
    }

    private void addRangeRef(SSheet sheet, int tRow, int lCol, int bRow, int rCol) {
        Validations.argNotNull(sheet);
        this._rangeRefs.add(new SheetRegion(sheet, tRow, lCol, bRow, rCol));
        this._column = Math.min(this._column, lCol);
        this._row = Math.min(this._row, tRow);
        this._lastColumn = Math.max(this._lastColumn, rCol);
        this._lastRow = Math.max(this._lastRow, bRow);
    }

    @Override
    public ReadWriteLock getLock() {
        return this.getBookSeries().getLock();
    }

    @Override
    public SBookSeries getBookSeries() {
        return this.getBook().getBookSeries();
    }

    @Override
    public SBook getBook() {
        if (this._book == null) {
            this._book = this.getSheet().getBook();
        }
        return this._book;
    }

    @Override
    public void tracePrecedents() {
        this.trace(SDependencyTracer.Type.PRECEDENT);
    }

    @Override
    public void traceDependents() {
        this.trace(SDependencyTracer.Type.DEPENDENT);
    }

    private void trace(SDependencyTracer.Type type) {
        HashSet<SheetRegion> dpSrs = new HashSet<SheetRegion>(4);
        HashSet<SheetRegion> srs = new HashSet<SheetRegion>(4);
        SSheet sheet = this.getSheet();
        SDependencyTracer sDependencyTracer = sheet.getBook().getDependencyTracer();
        sDependencyTracer.setType(type);
        SheetRegion prevSheetRegion = sDependencyTracer.getSheetRegion();
        if (prevSheetRegion != null) {
            srs.add(prevSheetRegion);
        }
        SheetRegion sheetRegion = new SheetRegion(sheet, this.getRow(), this.getColumn(), this.getRow(), this.getColumn());
        sDependencyTracer.setSheetRegion(sheetRegion);
        srs.add(sheetRegion);
        srs.addAll(sDependencyTracer.getRegions());
        Set<SRange> dp = type == SDependencyTracer.Type.DEPENDENT ? this.getDirectDependents() : this.getDirectPrecedents();
        for (SRange range : dp) {
            SheetRegion sr = new SheetRegion(range.getSheet(), range.getRow(), range.getColumn(), range.getLastRow(), range.getLastColumn());
            srs.add(sr);
            dpSrs.add(sr);
        }
        sDependencyTracer.setRegions(dpSrs);
        this.handleCellNotifyContentChange(srs, CellAttribute.STYLE);
    }

    @Override
    public void clearTrace() {
        SSheet sheet = this.getSheet();
        SDependencyTracer sDependencyTracer = sheet.getBook().getDependencyTracer();
        SheetRegion sheetRegion = sDependencyTracer.getSheetRegion();
        if (sheetRegion == null) {
            return;
        }
        Set<SheetRegion> srs = sDependencyTracer.getRegions();
        srs.add(sheetRegion);
        this.handleCellNotifyContentChange(srs, CellAttribute.STYLE);
        sDependencyTracer.clearRegions();
        sDependencyTracer.setSheetRegion(null);
        sDependencyTracer.setType(null);
    }

    @Override
    public SSheet getSheet() {
        if (this._rangeRefs.isEmpty()) {
            throw new IllegalStateException("can't find any effected sheet or range");
        }
        return ((SheetRegion)this._rangeRefs.iterator().next()).getSheet();
    }

    @Override
    public int getRow() {
        return this._row;
    }

    @Override
    public int getColumn() {
        return this._column;
    }

    @Override
    public int getLastRow() {
        return this._lastRow;
    }

    @Override
    public int getLastColumn() {
        return this._lastColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void travelCells(CellVisitor visitor) {
        ModelUpdateWrapper updateWrap = new ModelUpdateWrapper(this.getBookSeries(), false);
        try {
            block3: for (SheetRegion r : this._rangeRefs) {
                SSheet sheet = r.getSheet();
                CellRegion region = r.getRegion();
                for (int i = region.row; i <= region.lastRow; ++i) {
                    for (int j = region.column; j <= region.lastColumn; ++j) {
                        SCell cell = sheet.getCell(i, j);
                        boolean conti = visitor.visit(cell);
                        if (!conti) continue block3;
                    }
                }
            }
        }
        finally {
            updateWrap.doFinially();
        }
        visitor.afterVisitAll();
    }

    private void handleRefNotifyContentChange(SBookSeries bookSeries, Set<Ref> notifySet, CellAttribute cellAttr) {
        boolean updateStyle = notifySet.remove(StyleRef.inst);
        if (updateStyle && cellAttr != CellAttribute.STYLE) {
            cellAttr = CellAttribute.ALL;
        }
        new RefNotifyContentChangeHelper(bookSeries).notifyContentChange(notifySet, cellAttr);
    }

    private void handleRefNotifyContentChange(SBookSeries bookSeries, Ref notify, CellAttribute cellAttr) {
        new RefNotifyContentChangeHelper(bookSeries).notifyContentChange(notify, cellAttr);
    }

    private boolean equalObjects(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 != null) {
            return obj1.equals(obj2);
        }
        return false;
    }

    @Override
    public void setRichText(String html) {
        this.setValue(new RichTextHelper().parse(this, html));
    }

    @Override
    public String getRichText() {
        final ResultWrap r = new ResultWrap();
        new CellVisitorTask(new CellVisitor(){

            @Override
            public boolean visit(SCell cell) {
                if (cell.isRichTextValue()) {
                    String html = RichTextHelper.getCellRichTextHtml(cell);
                    r.set(html);
                } else {
                    r.set(null);
                }
                return false;
            }
        }).doInReadLock(this.getLock());
        return (String)r.get();
    }

    @Override
    public void setValue(final Object value) {
        new CellVisitorTask(new CellVisitorForUpdate(){

            @Override
            public boolean visit(SCell cell) {
                Object cellval = cell.getValue();
                if (!RangeImpl.this.equalObjects(cellval, value)) {
                    RangeImpl.this.handleCellNotifyBeforeValueChange(new SheetRegion(RangeImpl.this.getSheet(), new CellRegion(cell.getReferenceString())));
                    cell.setValue(value);
                    RangeImpl.this.markRecalcTextWidthHeight(cell);
                }
                return true;
            }

            @Override
            CellAttribute getCellAttr() {
                return CellAttribute.TEXT;
            }
        }).doInWriteLock(this.getLock());
    }

    @Override
    public void setValues(final Object ... values) {
        new CellVisitorTask(new CellVisitorForUpdate(){
            private int index = 0;

            @Override
            public boolean visit(SCell cell) {
                if (values.length == this.index) {
                    return false;
                }
                Object cellval = cell.getValue();
                if (!RangeImpl.this.equalObjects(cellval, values[this.index])) {
                    RangeImpl.this.handleCellNotifyBeforeValueChange(new SheetRegion(RangeImpl.this.getSheet(), new CellRegion(cell.getReferenceString())));
                    cell.setValue(values[this.index]);
                    RangeImpl.this.markRecalcTextWidthHeight(cell);
                }
                ++this.index;
                return true;
            }

            @Override
            CellAttribute getCellAttr() {
                return CellAttribute.TEXT;
            }
        }).doInWriteLock(this.getLock());
    }

    @Override
    public void clearContents() {
        new ModelManipulationTask(){

            @Override
            protected boolean isCollectModelUpdate() {
                return false;
            }

            @Override
            protected Object doInvoke() {
                SBookSeries bookSeries = RangeImpl.this.getSheet().getBook().getBookSeries();
                DependencyTable table = ((AbstractBookSeriesAdv)bookSeries).getDependencyTable();
                for (SheetRegion r : RangeImpl.this._rangeRefs) {
                    SSheet sheet = r.getSheet();
                    SBook book = sheet.getBook();
                    CellRegion region = r.getRegion();
                    boolean deleteTables = new ClearCellHelper(new RangeImpl(sheet, region)).clearCellContentAndTables();
                    RangeImpl.this.handleCellNotifyContentChange(new SheetRegion(sheet, region), deleteTables ? CellAttribute.ALL : CellAttribute.TEXT);
                    boolean wholeSheet = region.row == 0 && region.lastRow >= book.getMaxRowIndex() && region.column == 0 && region.lastColumn >= book.getMaxColumnIndex();
                    if (wholeSheet) continue;
                    RangeImpl.this.handleRefNotifyContentChange(bookSeries, table.getEvaluatedDependents(new RefImpl(sheet.getBook().getBookName(), sheet.getSheetName(), region.row, region.column, region.lastRow, region.lastColumn)), CellAttribute.TEXT);
                }
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void clearCellStyles() {
        new ModelManipulationTask(){

            @Override
            protected boolean isCollectModelUpdate() {
                return false;
            }

            @Override
            protected Object doInvoke() {
                for (SheetRegion r : RangeImpl.this._rangeRefs) {
                    SSheet sheet = r.getSheet();
                    CellRegion region = r.getRegion();
                    new ClearCellHelper(new RangeImpl(sheet, region)).clearCellStyle();
                    RangeImpl.this.handleCellNotifyContentChange(new SheetRegion(sheet, region), CellAttribute.STYLE);
                }
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void clearAll() {
        new ModelManipulationTask(){

            @Override
            protected boolean isCollectModelUpdate() {
                return false;
            }

            @Override
            protected Object doInvoke() {
                SBookSeries bookSeries = RangeImpl.this.getSheet().getBook().getBookSeries();
                DependencyTable table = ((AbstractBookSeriesAdv)bookSeries).getDependencyTable();
                for (SheetRegion r : RangeImpl.this._rangeRefs) {
                    SSheet sheet = r.getSheet();
                    CellRegion region = r.getRegion();
                    sheet.clearCell(region);
                    new ClearCellHelper(new RangeImpl(sheet, region)).clearCellStyle();
                    RangeImpl.this.handleCellNotifyContentChange(new SheetRegion(sheet, region), CellAttribute.ALL);
                    RangeImpl.this.handleRefNotifyContentChange(bookSeries, table.getEvaluatedDependents(new RefImpl(sheet.getBook().getBookName(), sheet.getSheetName(), region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn())), CellAttribute.ALL);
                }
                return null;
            }

            @Override
            protected void doAfterNotify() {
                RangeImpl.this.unmerge();
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void setEditText(final String editText) {
        final InputEngine ie = EngineFactory.getInstance().createInputEngine();
        final ResultWrap input = new ResultWrap();
        final ResultWrap hyperlinkType = new ResultWrap();
        new CellVisitorTask(new CellVisitorForUpdate(){

            @Override
            public boolean visit(SCell cell) {
                Object cellval;
                FormatEngine fe;
                String oldEditText;
                Locale locale = ZssContext.getCurrent().getLocale();
                InputResult result = (InputResult)input.get();
                if (result == null) {
                    SHyperlink.HyperlinkType type;
                    result = ie.parseInput(editText == null ? "" : editText, cell.getCellStyle().getDataFormat(), new InputParseContext(locale));
                    input.set(result);
                    if (result.getType() == SCell.CellType.STRING && ((type = RangeImpl.this.getHyperlinkType((String)result.getValue())) == SHyperlink.HyperlinkType.EMAIL || type == SHyperlink.HyperlinkType.URL)) {
                        hyperlinkType.set(type);
                    }
                }
                Object resultVal = result.getValue();
                if (cell.getType() == result.getType() && (result.getType() == SCell.CellType.FORMULA ? editText.equals(oldEditText = (fe = EngineFactory.getInstance().createFormatEngine()).getEditText(cell, new FormatContext(locale))) : RangeImpl.this.equalObjects(cellval = cell.getValue(), resultVal))) {
                    return true;
                }
                String format = result.getFormat();
                switch (result.getType()) {
                    case BLANK: {
                        cell.clearValue();
                        break;
                    }
                    case BOOLEAN: {
                        cell.setBooleanValue((Boolean)resultVal);
                        break;
                    }
                    case FORMULA: {
                        ((AbstractCellAdv)cell).setFormulaValue((String)resultVal, locale);
                        break;
                    }
                    case NUMBER: {
                        if (resultVal instanceof Date) {
                            cell.setDateValue((Date)resultVal);
                            break;
                        }
                        cell.setNumberValue((Double)resultVal);
                        break;
                    }
                    case STRING: {
                        cell.setStringValue((String)resultVal);
                        if (hyperlinkType.get() == null || RangeImpl.this.getSheet().isProtected() && !RangeImpl.this.getSheetProtection().isInsertHyperlinks()) break;
                        RangeImpl.this.setupHyperlink0(cell, (SHyperlink.HyperlinkType)((Object)hyperlinkType.get()), (String)resultVal, (String)resultVal);
                        break;
                    }
                    case ERROR: {
                        cell.setErrorValue(ErrorValue.valueOf((Byte)resultVal));
                        break;
                    }
                    default: {
                        cell.setValue(resultVal);
                    }
                }
                String oldFormat = cell.getCellStyle().getDataFormat();
                if (format != null && "General".equals(oldFormat)) {
                    StyleUtil.setDataFormat(cell.getSheet().getBook(), cell, format);
                }
                RangeImpl.this.markRecalcTextWidthHeight(cell);
                return true;
            }

            @Override
            CellAttribute getCellAttr() {
                return CellAttribute.ALL;
            }
        }).doInWriteLock(this.getLock());
    }

    @Override
    public void setArrayFormula(final String editText) {
        final InputEngine ie = EngineFactory.getInstance().createInputEngine();
        final ResultWrap input = new ResultWrap();
        final ResultWrap hyperlinkType = new ResultWrap();
        new CellVisitorTask(new CellVisitorForUpdate(){

            @Override
            public boolean visit(SCell cell) {
                Object cellval;
                FormatEngine fe;
                String oldEditText;
                Locale locale = ZssContext.getCurrent().getLocale();
                InputResult result = (InputResult)input.get();
                if (result == null) {
                    SHyperlink.HyperlinkType type;
                    result = ie.parseInput(editText == null ? "" : editText, cell.getCellStyle().getDataFormat(), new InputParseContext(locale));
                    input.set(result);
                    if (result.getType() == SCell.CellType.STRING && ((type = RangeImpl.this.getHyperlinkType((String)result.getValue())) == SHyperlink.HyperlinkType.EMAIL || type == SHyperlink.HyperlinkType.URL)) {
                        hyperlinkType.set(type);
                    }
                }
                Object resultVal = result.getValue();
                if (cell.getType() == result.getType() && (result.getType() == SCell.CellType.FORMULA ? editText.equals(oldEditText = (fe = EngineFactory.getInstance().createFormatEngine()).getEditText(cell, new FormatContext(locale))) : RangeImpl.this.equalObjects(cellval = cell.getValue(), resultVal))) {
                    return true;
                }
                String format = result.getFormat();
                boolean continuing = true;
                switch (result.getType()) {
                    case BLANK: {
                        cell.clearValue();
                        break;
                    }
                    case BOOLEAN: {
                        cell.setBooleanValue((Boolean)resultVal);
                        break;
                    }
                    case FORMULA: {
                        cell.getSheet().setArrayFormula((String)resultVal, new CellRegion(RangeImpl.this._row, RangeImpl.this._column, RangeImpl.this._lastRow, RangeImpl.this._lastColumn));
                        continuing = false;
                        break;
                    }
                    case NUMBER: {
                        if (resultVal instanceof Date) {
                            cell.setDateValue((Date)resultVal);
                            break;
                        }
                        cell.setNumberValue((Double)resultVal);
                        break;
                    }
                    case STRING: {
                        cell.setStringValue((String)resultVal);
                        if (hyperlinkType.get() == null || RangeImpl.this.getSheet().isProtected() && !RangeImpl.this.getSheetProtection().isInsertHyperlinks()) break;
                        RangeImpl.this.setupHyperlink0(cell, (SHyperlink.HyperlinkType)((Object)hyperlinkType.get()), (String)resultVal, (String)resultVal);
                        break;
                    }
                    case ERROR: {
                        cell.setErrorValue(ErrorValue.valueOf((Byte)resultVal));
                        break;
                    }
                    default: {
                        cell.setValue(resultVal);
                    }
                }
                String oldFormat = cell.getCellStyle().getDataFormat();
                if (format != null && "General".equals(oldFormat)) {
                    StyleUtil.setDataFormat(cell.getSheet().getBook(), cell, format);
                }
                RangeImpl.this.markRecalcTextWidthHeight(cell);
                return continuing;
            }

            @Override
            CellAttribute getCellAttr() {
                return CellAttribute.ALL;
            }
        }).doInWriteLock(this.getLock());
    }

    private SHyperlink setupHyperlink0(SCell cell, SHyperlink.HyperlinkType type, String address, String label) {
        SHyperlink.HyperlinkType type0 = this.getHyperlinkType(address);
        if ((type != SHyperlink.HyperlinkType.DOCUMENT || type0 != SHyperlink.HyperlinkType.FILE) && type0 != type) {
            switch (type) {
                case DOCUMENT: {
                    throw new InvalidModelOpException("'" + address + "' is not a valid document");
                }
                case EMAIL: {
                    throw new InvalidModelOpException("'" + address + "' is not a valid E-mail address");
                }
                case URL: {
                    throw new InvalidModelOpException("'" + address + "' is not a valid web page address");
                }
                case FILE: {
                    throw new InvalidModelOpException("'" + address + "' is not a valid file address");
                }
            }
        }
        SBook book = cell.getSheet().getBook();
        SCellStyle linkStyle = book.getOrAddDefaultHyperlinkStyle(cell);
        cell.setCellStyle(linkStyle);
        return cell.setupHyperlink(type, address, label);
    }

    private SHyperlink.HyperlinkType getHyperlinkType(String address) {
        if (address != null) {
            String addr = address.toLowerCase();
            if (addr.startsWith("http://") || addr.startsWith("https://") || address.startsWith("ftp://")) {
                return SHyperlink.HyperlinkType.URL;
            }
            if (addr.startsWith("mailto:")) {
                return SHyperlink.HyperlinkType.EMAIL;
            }
            return SHyperlink.HyperlinkType.FILE;
        }
        return null;
    }

    @Override
    public String getEditText() {
        final ResultWrap r = new ResultWrap();
        new CellVisitorTask(new CellVisitor(){

            @Override
            public boolean visit(SCell cell) {
                FormatEngine fe = EngineFactory.getInstance().createFormatEngine();
                r.set(fe.getEditText(cell, new FormatContext(ZssContext.getCurrent().getLocale())));
                return false;
            }
        }).doInReadLock(this.getLock());
        return (String)r.get();
    }

    @Override
    public void notifyChange() {
        this.notifyChange(CellAttribute.ALL);
    }

    @Override
    public void notifyChange(final CellAttribute cellAttr) {
        new ReadWriteTask(){

            public Object invoke() {
                RangeImpl.this.notifyChangeInLock(true, cellAttr);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    private void notifyChangeInLock(boolean notifyDependent, CellAttribute cellAttr) {
        if (!this.isAutoRefresh()) {
            return;
        }
        SBookSeries bookSeries = this.getBookSeries();
        DependencyTable table = ((AbstractBookSeriesAdv)bookSeries).getDependencyTable();
        LinkedHashSet<Ref> notifySet = new LinkedHashSet<Ref>();
        FormulaCacheCleaner cacheCleaner = new FormulaCacheCleaner(bookSeries);
        for (SheetRegion r : this._rangeRefs) {
            boolean wholeSheet;
            SSheet sheet = r.getSheet();
            SBook book = sheet.getBook();
            String bookName = book.getBookName();
            String sheetName = sheet.getSheetName();
            CellRegion region = r.getRegion();
            RefImpl pre = new RefImpl(bookName, sheetName, region.row, region.column, region.lastRow, region.lastColumn);
            if (cellAttr == CellAttribute.ALL || cellAttr == CellAttribute.TEXT) {
                cacheCleaner.clearByPrecedent(pre);
            }
            notifySet.add(pre);
            boolean bl = wholeSheet = region.row == 0 && region.lastRow >= book.getMaxRowIndex() && region.column == 0 && region.lastColumn >= book.getMaxColumnIndex();
            if (!notifyDependent || wholeSheet) continue;
            notifySet.addAll(table.getEvaluatedDependents(pre));
        }
        this.handleRefNotifyContentChange(bookSeries, notifySet, cellAttr);
    }

    @Override
    public void notifyChange(final String[] variables) {
        SBookSeries bookSeries = this.getBookSeries();
        new ReadWriteTask(){

            public Object invoke() {
                SBookSeries bookSeries = RangeImpl.this.getBookSeries();
                DependencyTable table = ((AbstractBookSeriesAdv)bookSeries).getDependencyTable();
                LinkedHashSet<Ref> notifySet = new LinkedHashSet<Ref>();
                FormulaCacheCleaner cacheCleaner = new FormulaCacheCleaner(bookSeries);
                for (SheetRegion r : RangeImpl.this._rangeRefs) {
                    SSheet sheet = r.getSheet();
                    final String bookName = sheet.getBook().getBookName();
                    String sheetName = sheet.getSheetName();
                    for (final String var : variables) {
                        Set<Ref> precedents = table.searchPrecedents(new DependencyTable.RefFilter(){

                            @Override
                            public boolean accept(Ref ref) {
                                String refNameName;
                                return ref.getBookName().equals(bookName) && ref.getType() == Ref.RefType.NAME && ((refNameName = ((NameRef)ref).getNameName()).equals(var) || refNameName.startsWith(var + "."));
                            }
                        });
                        for (Ref pre : precedents) {
                            cacheCleaner.clearByPrecedent(pre);
                            notifySet.add(pre);
                            notifySet.addAll(table.getEvaluatedDependents(pre));
                        }
                    }
                }
                RangeImpl.this.handleRefNotifyContentChange(bookSeries, notifySet, CellAttribute.ALL);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public boolean isWholeSheet() {
        return this.isWholeRow() && this.isWholeColumn();
    }

    @Override
    public boolean isWholeRow() {
        return this._column <= 0 && this._lastColumn >= this.getBook().getMaxColumnIndex();
    }

    @Override
    public SRange getRows() {
        return new RangeImpl(this.getSheet(), this._row, 0, this._lastRow, this.getBook().getMaxColumnIndex());
    }

    @Override
    public void setRowHeight(int heightPx) {
        this.setRowHeight(heightPx, true);
    }

    @Override
    public void setRowHeight(final int heightPx, final boolean custom) {
        new ReadWriteTask(){

            public Object invoke() {
                RangeImpl.this.setRowHeightInLock(heightPx, null, custom);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    private void setRowHeightInLock(Integer heightPx, Boolean hidden, Boolean custom) {
        LinkedHashSet<SheetRegion> notifySet = new LinkedHashSet<SheetRegion>();
        for (SheetRegion r : this._rangeRefs) {
            SSheet sheet = r.getSheet();
            int maxcol = sheet.getBook().getMaxColumnIndex();
            CellRegion region = r.getRegion();
            for (int i = region.row; i <= region.lastRow; ++i) {
                SRow row = sheet.getRow(i);
                if (heightPx != null) {
                    row.setHeight(heightPx);
                }
                if (hidden != null) {
                    row.setHidden(hidden);
                }
                if (custom != null) {
                    row.setCustomHeight(custom);
                }
                notifySet.add(new SheetRegion(sheet, i, 0, i, maxcol));
            }
        }
        this.handleNotifyRowColumnSizeChange(notifySet);
        this.handleCellNotifyContentChange(notifySet, CellAttribute.ALL);
    }

    @Override
    public boolean isWholeColumn() {
        return this._row <= 0 && this._lastRow >= this.getBook().getMaxRowIndex();
    }

    @Override
    public SRange getColumns() {
        return new RangeImpl(this.getSheet(), 0, this._column, this.getBook().getMaxRowIndex(), this._lastColumn);
    }

    @Override
    public void setColumnWidth(int widthPx) {
        this.setColumnWidth(widthPx, true);
    }

    @Override
    public void setColumnWidth(final int widthPx, final boolean custom) {
        new ReadWriteTask(){

            public Object invoke() {
                RangeImpl.this.setColumnWidthInLock(widthPx, null, custom);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    private void setColumnWidthInLock(Integer widthPx, Boolean hidden, Boolean custom) {
        LinkedHashSet<SheetRegion> notifySet = new LinkedHashSet<SheetRegion>();
        for (SheetRegion r : this._rangeRefs) {
            SSheet sheet = r.getSheet();
            int maxrow = sheet.getBook().getMaxRowIndex();
            CellRegion region = r.getRegion();
            for (int i = region.column; i <= region.lastColumn; ++i) {
                SColumn column = sheet.getColumn(i);
                if (widthPx != null) {
                    if (widthPx != 0) {
                        column.setWidth(widthPx);
                    } else {
                        column.setHidden(true);
                    }
                }
                if (hidden != null) {
                    column.setHidden(hidden);
                }
                if (custom != null) {
                    column.setCustomWidth(true);
                }
                notifySet.add(new SheetRegion(sheet, 0, i, maxrow, i));
            }
        }
        this.handleNotifyRowColumnSizeChange(notifySet);
        this.handleCellNotifyContentChange(notifySet, CellAttribute.ALL);
    }

    @Override
    public SHyperlink getHyperlink() {
        final ResultWrap r = new ResultWrap();
        new CellVisitorTask(new CellVisitor(){

            @Override
            public boolean visit(SCell cell) {
                r.set(cell.getHyperlink());
                return false;
            }
        }).doInReadLock(this.getLock());
        return (SHyperlink)r.get();
    }

    @Override
    public SRange copy(SRange dstRange, boolean cut) {
        PasteOption option = new PasteOption();
        option.setCut(cut);
        return this.pasteSpecial0(dstRange, option);
    }

    @Override
    public SRange copy(SRange dstRange) {
        return this.copy(dstRange, false);
    }

    @Override
    public SRange pasteSpecial(SRange dstRange, SRange.PasteType pasteType, SRange.PasteOperation pasteOp, boolean skipBlanks, boolean transpose) {
        PasteOption option = new PasteOption();
        option.setSkipBlank(skipBlanks);
        option.setTranspose(transpose);
        option.setPasteType(this.toModelPasteType(pasteType));
        option.setPasteOperation(this.toModelPasteOperation(pasteOp));
        return this.pasteSpecial0(dstRange, option);
    }

    private PasteOption.PasteOperation toModelPasteOperation(SRange.PasteOperation pasteOp) {
        switch (pasteOp) {
            case ADD: {
                return PasteOption.PasteOperation.ADD;
            }
            case DIV: {
                return PasteOption.PasteOperation.DIV;
            }
            case MUL: {
                return PasteOption.PasteOperation.MUL;
            }
            case NONE: {
                return PasteOption.PasteOperation.NONE;
            }
            case SUB: {
                return PasteOption.PasteOperation.SUB;
            }
        }
        throw new IllegalStateException("unknow operation " + String.valueOf((Object)pasteOp));
    }

    private PasteOption.PasteType toModelPasteType(SRange.PasteType pasteType) {
        switch (pasteType) {
            case ALL: {
                return PasteOption.PasteType.ALL;
            }
            case ALL_EXCEPT_BORDERS: {
                return PasteOption.PasteType.ALL_EXCEPT_BORDERS;
            }
            case COLUMN_WIDTHS: {
                return PasteOption.PasteType.COLUMN_WIDTHS;
            }
            case COMMENTS: {
                return PasteOption.PasteType.COMMENTS;
            }
            case FORMATS: {
                return PasteOption.PasteType.FORMATS;
            }
            case FORMULAS: {
                return PasteOption.PasteType.FORMULAS;
            }
            case FORMULAS_AND_NUMBER_FORMATS: {
                return PasteOption.PasteType.FORMULAS_AND_NUMBER_FORMATS;
            }
            case VALIDATAION: {
                return PasteOption.PasteType.VALIDATAION;
            }
            case VALUES: {
                return PasteOption.PasteType.VALUES;
            }
            case VALUES_AND_NUMBER_FORMATS: {
                return PasteOption.PasteType.VALUES_AND_NUMBER_FORMATS;
            }
        }
        throw new IllegalStateException("unknow type " + String.valueOf((Object)pasteType));
    }

    public SRange pasteSpecial0(final SRange dstRange, final PasteOption option) {
        final ResultWrap effectedRegion = new ResultWrap();
        return (SRange)new ModelManipulationTask(){

            @Override
            protected Object doInvoke() {
                CellRegion effected = dstRange.getSheet().pasteCell(new PasteSheetRegion(RangeImpl.this.getSheet(), RangeImpl.this.getRow(), RangeImpl.this.getColumn(), RangeImpl.this.getLastRow(), RangeImpl.this.getLastColumn(), RangeImpl.this.isWholeColumn(), RangeImpl.this.isWholeRow()), new PasteCellRegion(dstRange.getRow(), dstRange.getColumn(), dstRange.getLastRow(), dstRange.getLastColumn(), dstRange.isWholeColumn(), dstRange.isWholeRow()), option);
                effectedRegion.set(effected);
                return new RangeImpl(RangeImpl.this.getSheet(), effected.getRow(), effected.getColumn(), effected.getLastRow(), effected.getLastColumn());
            }

            @Override
            protected void doBeforeNotify() {
                int lastCol;
                int col;
                int lastRow;
                int row;
                CellRegion effected;
                boolean wholeRow;
                PasteOption.PasteType ptype = option.getPasteType();
                boolean wholeColumn = dstRange.getRow() == 0 && RangeImpl.this.isWholeColumn();
                boolean bl = wholeRow = dstRange.getColumn() == 0 && RangeImpl.this.isWholeRow();
                if (ptype == PasteOption.PasteType.COLUMN_WIDTHS || (ptype == PasteOption.PasteType.ALL || ptype == PasteOption.PasteType.ALL_EXCEPT_BORDERS) && wholeColumn) {
                    effected = (CellRegion)effectedRegion.get();
                    row = effected.getRow();
                    lastRow = dstRange.getSheet().getBook().getMaxRowIndex();
                    col = effected.getColumn();
                    lastCol = effected.getLastColumn();
                    RangeImpl.this.handleNotifyRowColumnSizeChange(new SheetRegion(dstRange.getSheet(), row, col, lastRow, lastCol));
                } else if (wholeRow) {
                    effected = (CellRegion)effectedRegion.get();
                    row = effected.getRow();
                    lastRow = effected.getLastRow();
                    col = effected.getColumn();
                    lastCol = dstRange.getSheet().getBook().getMaxColumnIndex();
                    RangeImpl.this.handleNotifyRowColumnSizeChange(new SheetRegion(dstRange.getSheet(), row, col, lastRow, lastCol));
                }
                if (option.isCut()) {
                    if (wholeColumn) {
                        int row2 = RangeImpl.this.getRow();
                        SSheet srcSheet = RangeImpl.this.getSheet();
                        lastRow = srcSheet.getBook().getMaxRowIndex();
                        col = RangeImpl.this.getColumn();
                        lastCol = RangeImpl.this.getLastColumn();
                        RangeImpl.this.handleNotifyRowColumnSizeChange(new SheetRegion(srcSheet, row2, col, lastRow, lastCol));
                    } else if (wholeRow) {
                        int row3 = RangeImpl.this.getRow();
                        SSheet srcSheet = RangeImpl.this.getSheet();
                        lastRow = RangeImpl.this.getLastRow();
                        col = RangeImpl.this.getColumn();
                        lastCol = srcSheet.getBook().getMaxColumnIndex();
                        RangeImpl.this.handleNotifyRowColumnSizeChange(new SheetRegion(srcSheet, row3, col, lastRow, lastCol));
                    }
                }
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void insert(final SRange.InsertShift shift, final SRange.InsertCopyOrigin copyOrigin) {
        new ModelManipulationTask(){

            @Override
            protected Object doInvoke() {
                new InsertDeleteHelper(RangeImpl.this).insert(shift, copyOrigin);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void delete(final SRange.DeleteShift shift) {
        new ModelManipulationTask(){

            @Override
            protected Object doInvoke() {
                new InsertDeleteHelper(RangeImpl.this).delete(shift);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void merge(final boolean across) {
        new ModelManipulationTask(){

            @Override
            protected Object doInvoke() {
                new MergeHelper(RangeImpl.this).merge(across);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void unmerge() {
        new ModelManipulationTask(){

            @Override
            protected Object doInvoke() {
                new MergeHelper(RangeImpl.this).unmerge(true);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void setBorders(final SRange.ApplyBorderType borderType, final SBorder.BorderType lineStyle, final String color) {
        new ModelManipulationTask(){

            @Override
            protected Object doInvoke() {
                new BorderHelper(RangeImpl.this).applyBorder(borderType, lineStyle, color);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void move(final int nRow, final int nCol) {
        new ModelManipulationTask(){

            @Override
            protected Object doInvoke() {
                SSheet sheet = RangeImpl.this.getSheet();
                sheet.moveCell(RangeImpl.this.getRow(), RangeImpl.this.getColumn(), RangeImpl.this.getLastRow(), RangeImpl.this.getLastColumn(), nRow, nCol);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void setCellStyle(final SCellStyle style) {
        new ReadWriteTask(){

            public Object invoke() {
                for (SheetRegion r : RangeImpl.this._rangeRefs) {
                    new SetCellStyleHelper(new RangeImpl(r.getSheet(), r.getRegion())).setCellStyle(style);
                }
                RangeImpl.this.notifyChangeInLock(false, CellAttribute.STYLE);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public SCellStyle getCellStyle() {
        final ResultWrap r = new ResultWrap();
        new CellVisitorTask(new CellVisitor(){

            @Override
            public boolean visit(SCell cell) {
                r.set(cell.getCellStyle());
                return false;
            }
        }).doInReadLock(this.getLock());
        return (SCellStyle)r.get();
    }

    @Override
    public void fill(final SRange dstRange, final SRange.FillType fillType) {
        SSheet sheet = this.getSheet();
        if (!dstRange.getSheet().equals(sheet)) {
            throw new InvalidModelOpException("the source sheet and destination sheet aren't the same");
        }
        new ModelManipulationTask(){

            @Override
            protected Object doInvoke() {
                RangeImpl.this.autoFillInLock(new CellRegion(RangeImpl.this.getRow(), RangeImpl.this.getColumn(), RangeImpl.this.getLastRow(), RangeImpl.this.getLastColumn()), new CellRegion(dstRange.getRow(), dstRange.getColumn(), dstRange.getLastRow(), dstRange.getLastColumn()), fillType);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    private void autoFillInLock(CellRegion src, CellRegion dest, SRange.FillType fillType) {
        SSheet sheet = this.getSheet();
        new AutoFillHelper().fill(sheet, src, dest, fillType);
    }

    @Override
    public void fillDown() {
        new ModelManipulationTask(){

            @Override
            protected Object doInvoke() {
                RangeImpl.this.autoFillInLock(new CellRegion(RangeImpl.this.getRow(), RangeImpl.this.getColumn(), RangeImpl.this.getRow(), RangeImpl.this.getLastColumn()), new CellRegion(RangeImpl.this.getRow(), RangeImpl.this.getColumn(), RangeImpl.this.getLastRow(), RangeImpl.this.getLastColumn()), SRange.FillType.COPY);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void fillLeft() {
        new ModelManipulationTask(){

            @Override
            protected Object doInvoke() {
                RangeImpl.this.autoFillInLock(new CellRegion(RangeImpl.this.getRow(), RangeImpl.this.getLastColumn(), RangeImpl.this.getLastRow(), RangeImpl.this.getLastColumn()), new CellRegion(RangeImpl.this.getRow(), RangeImpl.this.getColumn(), RangeImpl.this.getLastRow(), RangeImpl.this.getLastColumn()), SRange.FillType.COPY);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void fillRight() {
        new ModelManipulationTask(){

            @Override
            protected Object doInvoke() {
                RangeImpl.this.autoFillInLock(new CellRegion(RangeImpl.this.getRow(), RangeImpl.this.getColumn(), RangeImpl.this.getLastRow(), RangeImpl.this.getColumn()), new CellRegion(RangeImpl.this.getRow(), RangeImpl.this.getColumn(), RangeImpl.this.getLastRow(), RangeImpl.this.getLastColumn()), SRange.FillType.COPY);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void fillUp() {
        new ModelManipulationTask(){

            @Override
            protected Object doInvoke() {
                RangeImpl.this.autoFillInLock(new CellRegion(RangeImpl.this.getLastRow(), RangeImpl.this.getColumn(), RangeImpl.this.getLastRow(), RangeImpl.this.getLastColumn()), new CellRegion(RangeImpl.this.getRow(), RangeImpl.this.getColumn(), RangeImpl.this.getLastRow(), RangeImpl.this.getLastColumn()), SRange.FillType.COPY);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void setHidden(final boolean hidden) {
        new ModelManipulationTask(){

            @Override
            public Object doInvoke() {
                RangeImpl.this.setHiddenInLock(hidden);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    private boolean isWholeRow(SBook book, CellRegion region) {
        return region.column <= 0 && region.lastColumn >= book.getMaxColumnIndex();
    }

    private boolean isWholeColumn(SBook book, CellRegion region) {
        return region.row <= 0 && region.lastRow >= book.getMaxRowIndex();
    }

    protected void setHiddenInLock(boolean hidden) {
        LinkedHashSet<SheetRegion> notifySet = new LinkedHashSet<SheetRegion>();
        for (SheetRegion r : this._rangeRefs) {
            int i;
            SSheet sheet = r.getSheet();
            SBook book = sheet.getBook();
            int maxcol = book.getMaxColumnIndex();
            int maxrow = book.getMaxRowIndex();
            CellRegion region = r.getRegion();
            if (this.isWholeRow(book, region)) {
                for (i = region.getRow(); i <= region.getLastRow(); ++i) {
                    SRow row = sheet.getRow(i);
                    if (row.isHidden() == hidden) continue;
                    row.setHidden(hidden);
                }
                notifySet.add(new SheetRegion(sheet, region.getRow(), 0, region.getLastRow(), maxcol));
                continue;
            }
            if (!this.isWholeColumn(book, region)) continue;
            for (i = region.getColumn(); i <= region.getLastColumn(); ++i) {
                SColumn col = sheet.getColumn(i);
                if (col.isHidden() == hidden) continue;
                col.setHidden(hidden);
                notifySet.add(new SheetRegion(sheet, 0, i, maxrow, i));
            }
            notifySet.add(new SheetRegion(sheet, 0, region.getColumn(), maxrow, region.getLastColumn()));
        }
        this.handleNotifyRowColumnSizeChange(notifySet);
        if (!this.isAutoRefresh() || this.getSheet().getCharts().isEmpty()) {
            return;
        }
        SBookSeries bookSeries = this.getSheet().getBook().getBookSeries();
        DependencyTable table = ((AbstractBookSeriesAdv)bookSeries).getDependencyTable();
        HashSet<Ref> refSet = new HashSet<Ref>(1);
        for (SheetRegion sheetRegion : notifySet) {
            SSheet sheet = sheetRegion.getSheet();
            refSet.addAll(table.getEvaluatedDependents(new RefImpl(sheet.getBook().getBookName(), sheet.getSheetName(), sheetRegion.getRow(), sheetRegion.getColumn(), sheetRegion.getLastRow(), sheetRegion.getLastColumn())));
        }
        this.handleRefNotifyContentChange(this.getBookSeries(), refSet, CellAttribute.ALL);
    }

    @Override
    public void setDisplayGridlines(final boolean show) {
        new ReadWriteTask(){

            public Object invoke() {
                for (SheetRegion r : RangeImpl.this._rangeRefs) {
                    SSheet sheet = r.getSheet();
                    if (sheet.getViewInfo().isDisplayGridlines() == show) continue;
                    sheet.getViewInfo().setDisplayGridlines(show);
                    new NotifyChangeHelper().notifyDisplayGridlines(sheet, show);
                }
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void setHyperlink(final SHyperlink.HyperlinkType linkType, final String address, final String display) {
        new CellVisitorTask(new CellVisitorForUpdate(){

            @Override
            public boolean visit(SCell cell) {
                SHyperlink link = RangeImpl.this.setupHyperlink0(cell, linkType, address, display);
                String text = display;
                cell.setStringValue(text);
                return true;
            }

            @Override
            CellAttribute getCellAttr() {
                return CellAttribute.ALL;
            }
        }).doInWriteLock(this.getLock());
    }

    @Override
    public Object getValue() {
        final ResultWrap r = new ResultWrap();
        new CellVisitorTask(new CellVisitor(){

            @Override
            public boolean visit(SCell cell) {
                Object val = cell.getValue();
                r.set(val);
                return false;
            }
        }).doInReadLock(this.getLock());
        return r.get();
    }

    @Override
    public List<Object> getValues() {
        final ArrayList<Object> r = new ArrayList<Object>();
        new CellVisitorTask(new CellVisitor(){

            @Override
            public boolean visit(SCell cell) {
                Object val = cell.getValue();
                r.add(val);
                return true;
            }
        }).doInReadLock(this.getLock());
        return r;
    }

    @Override
    public SRange getOffset(int rowOffset, int colOffset) {
        if (rowOffset == 0 && colOffset == 0) {
            return this;
        }
        if (this._rangeRefs != null && !this._rangeRefs.isEmpty()) {
            SBook book = this.getBook();
            int maxCol = book.getMaxColumnIndex();
            int maxRow = book.getMaxRowIndex();
            LinkedHashSet<SheetRegion> nrefs = new LinkedHashSet<SheetRegion>(this._rangeRefs.size());
            for (SheetRegion ref : this._rangeRefs) {
                SheetRegion refAddr;
                int nbottom;
                CellRegion region = ref.getRegion();
                int left = region.getColumn() + colOffset;
                int top = region.getRow() + rowOffset;
                int right = region.getLastColumn() + colOffset;
                int bottom = region.getLastRow() + rowOffset;
                SSheet refSheet = ref.getSheet();
                int nleft = colOffset < 0 ? Math.max(0, left) : left;
                int ntop = rowOffset < 0 ? Math.max(0, top) : top;
                int nright = colOffset > 0 ? Math.min(maxCol, right) : right;
                int n = nbottom = rowOffset > 0 ? Math.min(maxRow, bottom) : bottom;
                if (nleft > nright || ntop > nbottom || nrefs.contains(refAddr = new SheetRegion(refSheet, ntop, nleft, nbottom, nright))) continue;
                nrefs.add(refAddr);
            }
            if (nrefs.isEmpty()) {
                return EMPTY_RANGE;
            }
            return new RangeImpl(nrefs);
        }
        return EMPTY_RANGE;
    }

    @Override
    public boolean isAnyCellProtected() {
        return (Boolean)new ReadWriteTask(){

            public Object invoke() {
                for (SheetRegion r : RangeImpl.this._rangeRefs) {
                    SSheet sheet = r.getSheet();
                    CellRegion region = r.getRegion();
                    if (!sheet.isProtected()) continue;
                    for (int i = region.row; i <= region.lastRow; ++i) {
                        for (int j = region.column; j <= region.lastColumn; ++j) {
                            SCellStyle style = sheet.getCell(i, j).getCellStyle();
                            if (!style.isLocked()) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
        }.doInReadLock(this.getLock());
    }

    @Override
    public void deleteSheet() {
        final ResultWrap toDeleteSheet = new ResultWrap();
        final ResultWrap toDeleteIndex = new ResultWrap();
        new ModelManipulationTask(){

            @Override
            protected Object doInvoke() {
                SBook book = RangeImpl.this.getBook();
                int sheetCount = book.getNumOfSheet();
                if (sheetCount <= 1) {
                    throw new InvalidModelOpException("can't delete last sheet ");
                }
                SSheet toDelete = RangeImpl.this.getSheet();
                int index = book.getSheetIndex(toDelete);
                toDeleteSheet.set(toDelete);
                toDeleteIndex.set(index);
                book.deleteSheet(toDelete);
                return null;
            }

            @Override
            protected void doBeforeNotify() {
                if (toDeleteSheet.get() != null) {
                    new NotifyChangeHelper().notifySheetDelete(RangeImpl.this.getBook(), (SSheet)toDeleteSheet.get(), (Integer)toDeleteIndex.get());
                }
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public SSheet createSheet(final String name) {
        final ResultWrap resultSheet = new ResultWrap();
        return (SSheet)new ModelManipulationTask(){

            @Override
            protected Object doInvoke() {
                SBook book = RangeImpl.this.getBook();
                SSheet sheet = Strings.isBlank((String)name) ? book.createSheet(RangeImpl.this.nextSheetName()) : book.createSheet(name);
                resultSheet.set(sheet);
                return sheet;
            }

            @Override
            protected void doBeforeNotify() {
                if (resultSheet.get() != null) {
                    new NotifyChangeHelper().notifySheetCreate((SSheet)resultSheet.get());
                }
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public SSheet cloneSheet(final String name) {
        final ResultWrap resultSheet = new ResultWrap();
        return (SSheet)new ModelManipulationTask(){

            @Override
            protected Object doInvoke() {
                SBook book = RangeImpl.this.getBook();
                SSheet srcsheet = RangeImpl.this.getSheet();
                SSheet sheet = Strings.isBlank((String)name) ? book.createSheet(RangeImpl.this.nextSheetName(), srcsheet) : book.createSheet(name, srcsheet);
                resultSheet.set(sheet);
                return sheet;
            }

            @Override
            protected void doBeforeNotify() {
                if (resultSheet.get() != null) {
                    new NotifyChangeHelper().notifySheetCreate((SSheet)resultSheet.get());
                }
            }
        }.doInWriteLock(this.getLock());
    }

    private String nextSheetName() {
        SBook book = this.getBook();
        Integer idx = (Integer)book.getAttribute("zss.nextSheetCount");
        int i = idx == null ? 1 : idx;
        HashSet<String> names = new HashSet<String>();
        for (SSheet sheet : this.getBook().getSheets()) {
            names.add(sheet.getSheetName());
        }
        String base = "Sheet";
        String name = base + i;
        while (names.contains(name)) {
            name = base + ++i;
        }
        book.setAttribute("zss.nextSheetCount", i + 1);
        return name;
    }

    @Override
    public void setSheetName(final String newname) {
        final ResultWrap resultSheet = new ResultWrap();
        final ResultWrap oldName = new ResultWrap();
        new ModelManipulationTask(){

            @Override
            protected Object doInvoke() {
                SBook book = RangeImpl.this.getBook();
                SSheet sheet = RangeImpl.this.getSheet();
                String old = sheet.getSheetName();
                if (old.equals(newname)) {
                    return null;
                }
                book.setSheetName(sheet, newname);
                resultSheet.set(sheet);
                oldName.set(old);
                return null;
            }

            @Override
            protected void doBeforeNotify() {
                if (resultSheet.get() != null) {
                    new NotifyChangeHelper().notifySheetNameChange((SSheet)resultSheet.get(), (String)oldName.get());
                }
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void setSheetOrder(final int pos) {
        final ResultWrap resultSheet = new ResultWrap();
        final ResultWrap oldIdx = new ResultWrap();
        new ModelManipulationTask(){

            @Override
            protected Object doInvoke() {
                SSheet sheet;
                SBook book = RangeImpl.this.getBook();
                int old = book.getSheetIndex(sheet = RangeImpl.this.getSheet());
                if (old == pos) {
                    return null;
                }
                book.moveSheetTo(sheet, pos);
                resultSheet.set(sheet);
                oldIdx.set(old);
                return null;
            }

            @Override
            protected void doBeforeNotify() {
                if (resultSheet.get() != null) {
                    new NotifyChangeHelper().notifySheetReorder((SSheet)resultSheet.get(), (Integer)oldIdx.get());
                }
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void setFreezePanel(final int numOfRow, final int numOfColumn) {
        new ReadWriteTask(){

            public Object invoke() {
                SSheetViewInfo viewInfo = RangeImpl.this.getSheet().getViewInfo();
                viewInfo.setNumOfRowFreeze(numOfRow);
                viewInfo.setNumOfColumnFreeze(numOfColumn);
                RangeImpl.this.notifySheetFreezeChange();
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    private void notifySheetFreezeChange() {
        new NotifyChangeHelper().notifySheetFreezeChange(this.getSheet());
    }

    private void notifySheetGroupChange(SSheet sheet) {
        new NotifyChangeHelper().notifySheetGroupChange(sheet);
    }

    @Override
    public String getCellFormatText() {
        final ResultWrap r = new ResultWrap();
        new CellVisitorTask(new CellVisitor(){

            @Override
            public boolean visit(SCell cell) {
                FormatEngine fe = EngineFactory.getInstance().createFormatEngine();
                r.set(fe.format(cell, new FormatContext(ZssContext.getCurrent().getLocale())).getText());
                return false;
            }
        }).doInReadLock(this.getLock());
        return (String)r.get();
    }

    @Override
    public String getCellDataFormat() {
        final ResultWrap r = new ResultWrap();
        new CellVisitorTask(new CellVisitor(){

            @Override
            public boolean visit(SCell cell) {
                FormatEngine fe = EngineFactory.getInstance().createFormatEngine();
                r.set(fe.getFormat(cell, new FormatContext(ZssContext.getCurrent().getLocale())));
                return false;
            }
        }).doInReadLock(this.getLock());
        return (String)r.get();
    }

    @Override
    public boolean isSheetProtected() {
        return (Boolean)new ReadWriteTask(){

            public Object invoke() {
                return RangeImpl.this.getSheet().isProtected();
            }
        }.doInReadLock(this.getLock());
    }

    @Override
    public SDataValidation validate(final String editText) {
        final ResultWrap retrunVal = new ResultWrap();
        new CellVisitorTask(new CellVisitor(){

            @Override
            boolean visit(SCell cell) {
                SDataValidation validation = RangeImpl.this.getSheet().getDataValidation(cell.getRowIndex(), cell.getColumnIndex());
                if (validation != null && !new DataValidationHelper(validation).validate(cell.getRowIndex(), cell.getColumnIndex(), editText, cell.getCellStyle().getDataFormat())) {
                    retrunVal.set(validation);
                    return false;
                }
                return true;
            }
        }).doInReadLock(this.getLock());
        return (SDataValidation)retrunVal.get();
    }

    @Override
    public SRange findAutoFilterRange() {
        return (SRange)new ReadWriteTask(){

            public Object invoke() {
                CellRegion region = new DataRegionHelper(RangeImpl.this).findAutoFilterDataRegion();
                if (region != null) {
                    return SRanges.range(RangeImpl.this.getSheet(), region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn());
                }
                return null;
            }
        }.doInReadLock(this.getLock());
    }

    Ref getSheetRef() {
        return new RefImpl((AbstractSheetAdv)this.getSheet(), this.getSheet().getBook().getSheetIndex(this.getSheet()));
    }

    Ref getBookRef() {
        return new RefImpl((AbstractBookAdv)this.getBook());
    }

    private Set<Ref> toSet(Ref ref) {
        HashSet<Ref> refs = new HashSet<Ref>(1);
        refs.add(ref);
        return refs;
    }

    private STable getFilterTable() {
        int row1 = this.getRow();
        int row2 = this.getLastRow();
        int col1 = this.getColumn();
        int col2 = this.getLastColumn();
        SSheet sheet = this.getSheet();
        STable table = null;
        for (STable tb : sheet.getTables()) {
            CellRegion rgn = tb.getAllRegion().getRegion();
            int tr1 = rgn.getRow();
            int tc1 = rgn.getColumn();
            int tr2 = rgn.getLastRow();
            int tc2 = rgn.getLastColumn();
            if (tr1 <= row1 && row2 <= tr2 && tc1 <= col1 && col2 <= tc2) {
                table = tb;
                break;
            }
            if (tr2 < row1 || tr1 > row2 || tc2 < col1 || tc1 > col2) continue;
            throw new InvalidModelOpException("The operation can only be applied on one table or out of all tables");
        }
        return table;
    }

    @Override
    public SAutoFilter enableAutoFilter(final boolean enable) {
        return (SAutoFilter)new ReadWriteTask(){

            public Object invoke() {
                SAutoFilter filter;
                SSheet sheet = RangeImpl.this.getSheet();
                STable table = RangeImpl.this.getFilterTable();
                SAutoFilter sAutoFilter = filter = table == null ? sheet.getAutoFilter() : table.getAutoFilter();
                if (filter == null && !enable || filter != null && enable) {
                    return filter;
                }
                SAutoFilter filter0 = table != null ? new AutoFilterHelper(RangeImpl.this).enableTableFilter(table, enable) : new AutoFilterHelper(RangeImpl.this).enableAutoFilter(enable);
                RangeImpl.this.notifySheetAutoFilterChange(table, enable ? filter0 : filter);
                return filter0;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public SAutoFilter enableAutoFilter(final int field, final SAutoFilter.FilterOp filterOp, final Object criteria1, final Object criteria2, final Boolean visibleDropDown) {
        return (SAutoFilter)new ReadWriteTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object invoke() {
                long t1 = System.nanoTime();
                AbstractBookAdv book = (AbstractBookAdv)RangeImpl.this._book;
                book.startBatchNotificationMode();
                try {
                    STable table = RangeImpl.this.getFilterTable();
                    SAutoFilter filter = new AutoFilterHelper(RangeImpl.this).enableAutoFilter(table, field, filterOp, criteria1, criteria2, visibleDropDown);
                    SSheet sheet = RangeImpl.this.getSheet();
                    RangeImpl.this.notifySheetAutoFilterChange(table, sheet.getAutoFilter());
                    SAutoFilter sAutoFilter = filter;
                    return sAutoFilter;
                }
                finally {
                    book.stopBatchNotificationMode();
                }
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void resetAutoFilter() {
        new ReadWriteTask(){

            public Object invoke() {
                SSheet sheet = RangeImpl.this.getSheet();
                STable table = ((AbstractSheetAdv)sheet).getTableByRowCol(RangeImpl.this.getRow(), RangeImpl.this.getColumn());
                new AutoFilterHelper(RangeImpl.this).resetAutoFilter(table);
                RangeImpl.this.notifySheetAutoFilterChange(table, RangeImpl.this.getSheet().getAutoFilter());
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void applyAutoFilter() {
        new ReadWriteTask(){

            public Object invoke() {
                SSheet sheet = RangeImpl.this.getSheet();
                STable table = ((AbstractSheetAdv)sheet).getTableByRowCol(RangeImpl.this.getRow(), RangeImpl.this.getColumn());
                new AutoFilterHelper(RangeImpl.this).applyAutoFilter(table);
                RangeImpl.this.notifySheetAutoFilterChange(table, sheet.getAutoFilter());
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    private void notifySheetAutoFilterChange(STable table, SAutoFilter filter) {
        SSheet sheet = this.getSheet();
        new NotifyChangeHelper().notifySheetAutoFilterChange(sheet, table);
        if (table == null && filter != null) {
            this.notifySheetAutoFilterBorderChange(sheet, filter.getRegion(), filter.getLastVisibleRow(), filter.getPrevlastVisibleRow());
        }
    }

    private void notifySheetAutoFilterBorderChange(SSheet sheet, CellRegion rgn, int lastVisibleRow, int prevLastVisibleRow) {
        int left = rgn.getColumn();
        int top = rgn.getRow();
        int right = rgn.getLastColumn();
        int bottom = rgn.getLastRow();
        HashSet<SheetRegion> srs = new HashSet<SheetRegion>(8);
        srs.add(new SheetRegion(sheet, top, left, top, right));
        srs.add(new SheetRegion(sheet, top, left, bottom, left));
        srs.add(new SheetRegion(sheet, top, right, bottom, right));
        srs.add(new SheetRegion(sheet, bottom, left, bottom, right));
        if (prevLastVisibleRow != -1) {
            srs.add(new SheetRegion(sheet, prevLastVisibleRow, left, prevLastVisibleRow, right));
        }
        if (lastVisibleRow != -1) {
            srs.add(new SheetRegion(sheet, lastVisibleRow, left, lastVisibleRow, right));
        }
        this.handleCellNotifyContentChange(srs, CellAttribute.STYLE);
    }

    @Override
    public void notifyCustomEvent(final String customEventName, final Object data, boolean writelock) {
        ReadWriteTask task = new ReadWriteTask(){

            public Object invoke() {
                NotifyChangeHelper notifyHelper = new NotifyChangeHelper();
                for (SheetRegion r : RangeImpl.this._rangeRefs) {
                    SSheet sheet = r.getSheet();
                    notifyHelper.notifyCustomEvent(customEventName, sheet, data);
                }
                return null;
            }
        };
        if (writelock) {
            task.doInWriteLock(this.getLock());
        } else {
            task.doInReadLock(this.getLock());
        }
    }

    @Override
    public SPicture addPicture(final ViewAnchor anchor, final byte[] image, final SPicture.Format format) {
        return (SPicture)new ReadWriteTask(){

            public Object invoke() {
                SPicture picture = RangeImpl.this.getSheet().addPicture(format, image, anchor);
                new NotifyChangeHelper().notifySheetPictureAdd(RangeImpl.this.getSheet(), picture.getId());
                return picture;
            }
        }.doInWriteLock(this.getLock());
    }

    private void handleMergeRemoveNotifyChange(SheetRegion mergeNotify) {
        if (!this.isAutoRefresh()) {
            this.mantainMergeClearCacheState(mergeNotify);
            return;
        }
        new NotifyChangeHelper().notifyMergeRemove(mergeNotify);
    }

    private void handleMergeRemoveNotifyChange(Set<SheetRegion> mergeNotifySet) {
        if (!this.isAutoRefresh()) {
            this.mantainMergeClearCacheState(mergeNotifySet.iterator().next());
            return;
        }
        new NotifyChangeHelper().notifyMergeRemove(mergeNotifySet);
    }

    private void handleMergeAddNotifyChange(SheetRegion mergeNotify) {
        if (!this.isAutoRefresh()) {
            this.mantainMergeClearCacheState(mergeNotify);
            return;
        }
        new NotifyChangeHelper().notifyMergeAdd(mergeNotify);
    }

    private void handleMergeAddNotifyChange(Set<SheetRegion> mergeNotifySet) {
        if (!this.isAutoRefresh()) {
            this.mantainMergeClearCacheState(mergeNotifySet.iterator().next());
            return;
        }
        new NotifyChangeHelper().notifyMergeAdd(mergeNotifySet);
    }

    private void mantainMergeClearCacheState(SheetRegion mergeNotify) {
        AbstractSheetAdv sheet = (AbstractSheetAdv)mergeNotify.getSheet();
        if (sheet != null && sheet.getMergeOutOfSync() == 1) {
            sheet.setMergeOutOfSync(2);
        }
    }

    private void handleCellNotifyContentChange(SheetRegion cellNotify, CellAttribute cellAttr) {
        if (!this.isAutoRefresh()) {
            return;
        }
        new NotifyChangeHelper().notifyCellChange(cellNotify, cellAttr);
    }

    private void handleCellNotifyContentChange(Set<SheetRegion> cellNotifySet, CellAttribute cellAttr) {
        if (!this.isAutoRefresh()) {
            return;
        }
        new NotifyChangeHelper().notifyCellChange(cellNotifySet, cellAttr);
    }

    private void handleNotifyRowColumnSizeChange(SheetRegion region) {
        if (!this.isAutoRefresh()) {
            return;
        }
        new NotifyChangeHelper().notifyRowColumnSizeChange(region);
    }

    private void handleNotifyRowColumnSizeChange(Set<SheetRegion> notifySet) {
        if (!this.isAutoRefresh()) {
            return;
        }
        new NotifyChangeHelper().notifyRowColumnSizeChange(notifySet);
    }

    private void handleInsertDeleteNotifyChange(InsertDeleteUpdate insertDeleteNofity) {
        if (!this.isAutoRefresh()) {
            return;
        }
        new NotifyChangeHelper().notifyInsertDelete(insertDeleteNofity);
    }

    private void handleAutoFitlerNotifyChange(AutoFilterUpdate update) {
        new NotifyChangeHelper().notifySheetAutoFilterChange(update.getSheet(), update.getTable());
    }

    @Override
    public void deletePicture(final SPicture picture) {
        new ReadWriteTask(){

            public Object invoke() {
                String pid = picture.getId();
                RangeImpl.this.getSheet().deletePicture(picture);
                new NotifyChangeHelper().notifySheetPictureDelete(RangeImpl.this.getSheet(), pid);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void movePicture(final SPicture picture, final ViewAnchor anchor) {
        new ReadWriteTask(){

            public Object invoke() {
                if (anchor.getAnchorType().equals((Object)ViewAnchor.AnchorType.MOVE_DONT_RESIZE)) {
                    anchor.setWidth(picture.getAnchor().getWidth());
                    anchor.setHeight(picture.getAnchor().getHeight());
                }
                picture.setAnchor(anchor);
                new NotifyChangeHelper().notifySheetPictureMove(RangeImpl.this.getSheet(), picture.getId());
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public SChart addChart(ViewAnchor anchor, SChart.ChartType type, SChart.ChartGrouping grouping, SChart.ChartLegendPosition pos, boolean isThreeD) {
        return this.addChart(null, anchor, type, grouping, pos, isThreeD);
    }

    @Override
    public SChart addChart(final String name, final ViewAnchor anchor, final SChart.ChartType type, final SChart.ChartGrouping grouping, final SChart.ChartLegendPosition pos, final boolean isThreeD) {
        return (SChart)new ReadWriteTask(){

            public Object invoke() {
                SChart chart = RangeImpl.this.getSheet().addChart(name, type, anchor);
                chart.setThreeD(isThreeD);
                new ChartDataHelper(RangeImpl.this).fillChartData(chart);
                chart.setGrouping(grouping);
                chart.setLegendPosition(pos);
                ((AbstractChartAdv)chart).setSeriesColors(((AbstractBookAdv)RangeImpl.this.getBook()).getDefaultChartSeriesColors());
                new NotifyChangeHelper().notifySheetChartAdd(RangeImpl.this.getSheet(), chart.getId());
                return chart;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void deleteChart(final SChart chart) {
        new ReadWriteTask(){

            public Object invoke() {
                RangeImpl.this.getSheet().deleteChart(chart);
                new NotifyChangeHelper().notifySheetChartDelete(RangeImpl.this.getSheet(), chart.getId());
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void moveChart(final SChart chart, final ViewAnchor anchor) {
        new ReadWriteTask(){

            public Object invoke() {
                chart.setAnchor(anchor);
                new NotifyChangeHelper().notifySheetChartUpdate(RangeImpl.this.getSheet(), chart.getId());
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void updateChart(final SChart chart) {
        new ReadWriteTask(){

            public Object invoke() {
                new NotifyChangeHelper().notifySheetChartUpdate(RangeImpl.this.getSheet(), chart.getId());
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sort(final SRange key1, final boolean descending1, final SRange.SortDataOption dataOption1, final SRange key2, final boolean descending2, final SRange.SortDataOption dataOption2, final SRange key3, final boolean descending3, final SRange.SortDataOption dataOption3, final int hasHeader, final boolean matchCase, final boolean sortByRows) {
        boolean old = this.setAutoRefresh(false);
        try {
            new ModelManipulationTask(){

                @Override
                protected Object doInvoke() {
                    new SortHelper(RangeImpl.this).sort(key1, descending1, dataOption1, key2, descending2, dataOption2, key3, descending3, dataOption3, hasHeader, matchCase, sortByRows);
                    return null;
                }

                @Override
                protected void doBeforeNotify() {
                }
            }.doInWriteLock(this.getLock());
        }
        finally {
            if (old) {
                this.notifyChange();
            }
            this.setAutoRefresh(old);
        }
    }

    @Override
    public void createName(final String nameName) {
        new ModelManipulationTask(){

            @Override
            protected Object doInvoke() {
                RangeImpl.this.createNameInLock(nameName);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    private void createNameInLock(String nameName) {
        SSheet sht = this.getSheet();
        String sn = sht.getSheetName();
        int c1 = this.getColumn();
        int c2 = this.getLastColumn();
        int r1 = this.getRow();
        int r2 = this.getLastRow();
        String refers = null;
        if (c1 == c2 && r1 == r2) {
            CellReference cf = new CellReference(sn, r1, c1, true, true);
            refers = cf.formatAsString();
        } else {
            AreaReference af = new AreaReference(new CellReference(sn, this.getRow(), c1, true, true), new CellReference(sn, this.getLastRow(), this.getLastColumn(), true, true), SpreadsheetVersion.EXCEL2007);
            refers = af.formatAsString();
        }
        SName name = this.getBook().createName(nameName);
        name.setRefersToFormula(refers);
        AbstractBookSeriesAdv series = (AbstractBookSeriesAdv)this.getBookSeries();
        DependencyTable table = series.getDependencyTable();
        this.handleRefNotifyContentChange((SBookSeries)series, table.getEvaluatedDependents(new NameRefImpl((AbstractNameAdv)name)), CellAttribute.ALL);
    }

    @Override
    public boolean isProtected() {
        return (Boolean)new ReadWriteTask(){

            public Object invoke() {
                SSheet sheet;
                SheetRegion r;
                SheetRegion sheetRegion = r = RangeImpl.this._rangeRefs.isEmpty() ? null : (SheetRegion)RangeImpl.this._rangeRefs.iterator().next();
                if (r != null && (sheet = r.getSheet()).isProtected()) {
                    CellRegion region = r.getRegion();
                    for (int i = region.row; i <= region.lastRow; ++i) {
                        for (int j = region.column; j <= region.lastColumn; ++j) {
                            SCellStyle style = sheet.getCell(i, j).getCellStyle();
                            if (!style.isLocked()) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
        }.doInReadLock(this.getLock());
    }

    @Override
    public void protectSheet(String password, final boolean allowSelectingLockedCells, final boolean allowSelectingUnlockedCells, final boolean allowFormattingCells, final boolean allowFormattingColumns, final boolean allowFormattingRows, final boolean allowInsertColumns, final boolean allowInsertRows, final boolean allowInsertingHyperlinks, final boolean allowDeletingColumns, final boolean allowDeletingRows, final boolean allowSorting, final boolean allowFiltering, final boolean allowUsingPivotTables, final boolean drawingObjects, final boolean scenarios) {
        final String pass0 = password == null ? "" : password;
        new ReadWriteTask(){

            public Object invoke() {
                RangeImpl.this.protectSheetInLock(RangeImpl.this.getSheet(), pass0, allowSelectingLockedCells, allowSelectingUnlockedCells, allowFormattingCells, allowFormattingColumns, allowFormattingRows, allowInsertColumns, allowInsertRows, allowInsertingHyperlinks, allowDeletingColumns, allowDeletingRows, allowSorting, allowFiltering, allowUsingPivotTables, drawingObjects, scenarios);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public boolean unprotectSheet(final String password) {
        if (!this.getSheet().isProtected()) {
            return true;
        }
        return (Boolean)new ReadWriteTask(){

            public Object invoke() {
                return RangeImpl.this.unprotectSheetInLock(RangeImpl.this.getSheet(), password);
            }
        }.doInWriteLock(this.getLock());
    }

    private void protectSheetInLock(SSheet sht, String password, boolean allowSelectingLockedCells, boolean allowSelectingUnlockedCells, boolean allowFormattingCells, boolean allowFormattingColumns, boolean allowFormattingRows, boolean allowInsertColumns, boolean allowInsertRows, boolean allowInsertingHyperlinks, boolean allowDeletingColumns, boolean allowDeletingRows, boolean allowSorting, boolean allowFiltering, boolean allowUsingPivotTables, boolean drawingObjects, boolean scenarios) {
        if (sht.isProtected()) {
            short hashpass = sht.getHashedPassword();
            short inputpass = (short)CryptoFunctions.createXorVerifier1((String)password);
            if (inputpass != hashpass) {
                String hashValue = ((SheetImpl)sht).getHashValue();
                if (hashValue == null) {
                    return;
                }
                Base64.Encoder enc64 = Base64.getEncoder();
                Base64.Decoder dec64 = Base64.getDecoder();
                String spinCount = ((SheetImpl)sht).getSpinCount();
                String saltValue = ((SheetImpl)sht).getSaltValue();
                String algName = ((SheetImpl)sht).getAlgName();
                String calcPass = enc64.encodeToString(CryptoFunctions.hashPassword((String)password, (HashAlgorithm)HashAlgorithm.fromString((String)algName), (byte[])dec64.decode(saltValue), (int)Integer.parseInt(spinCount)));
                if (!hashValue.equals(calcPass)) {
                    return;
                }
            }
        }
        SSheetProtection sp = sht.getSheetProtection();
        sp.setSelectLockedCells(allowSelectingLockedCells);
        sp.setSelectUnlockedCells(allowSelectingUnlockedCells);
        sp.setFormatCells(allowFormattingCells);
        sp.setFormatColumns(allowFormattingColumns);
        sp.setFormatRows(allowFormattingRows);
        sp.setInsertColumns(allowInsertColumns);
        sp.setInsertRows(allowInsertRows);
        sp.setInsertHyperlinks(allowInsertingHyperlinks);
        sp.setDeleteColumns(allowDeletingColumns);
        sp.setDeleteRows(allowDeletingRows);
        sp.setSort(allowSorting);
        sp.setAutoFilter(allowFiltering);
        sp.setPivotTables(allowUsingPivotTables);
        sp.setObjects(drawingObjects);
        sp.setScenarios(scenarios);
        this.setPasswordInLock(sht, password);
    }

    private boolean unprotectSheetInLock(SSheet sht, String password) {
        String hashValue = ((SheetImpl)sht).getHashValue();
        if (hashValue != null) {
            if (password == null || password.isEmpty()) {
                return false;
            }
            Base64.Encoder enc64 = Base64.getEncoder();
            Base64.Decoder dec64 = Base64.getDecoder();
            String saltValue = ((SheetImpl)sht).getSaltValue();
            String spinCount = ((SheetImpl)sht).getSpinCount();
            String algName = ((SheetImpl)sht).getAlgName();
            String calcPass = enc64.encodeToString(CryptoFunctions.hashPassword((String)password, (HashAlgorithm)HashAlgorithm.fromString((String)algName), (byte[])dec64.decode(saltValue), (int)Integer.parseInt(spinCount), (boolean)false));
            if (!hashValue.equals(calcPass)) {
                return false;
            }
        } else if ((password == null ? (short)0 : (short)CryptoFunctions.createXorVerifier1((String)password)) != sht.getHashedPassword()) {
            return false;
        }
        this.setPasswordInLock(sht, null);
        SSheetProtection sp = sht.getSheetProtection();
        sp.setObjects(false);
        sp.setScenarios(false);
        return true;
    }

    private void setPasswordInLock(SSheet sheet, String password) {
        if (sheet.isProtected() && password == null) {
            sheet.setPassword(null);
            new NotifyChangeHelper().notifyProtectSheet(sheet, false);
        } else if (!sheet.isProtected() && password != null) {
            sheet.setPassword(password);
            new NotifyChangeHelper().notifyProtectSheet(sheet, true);
        }
    }

    @Override
    public SSheetProtection getSheetProtection() {
        return this.getSheet().getSheetProtection();
    }

    @Override
    public void setValidation(final SDataValidation.ValidationType validationType, final boolean ignoreBlank, final SDataValidation.OperatorType operatorType, final boolean inCellDropDown, final String formula1, final String formula2, final boolean showInput, final String inputTitle, final String inputMessage, final boolean showError, final SDataValidation.AlertStyle alertStyle, final String errorTitle, final String errorMessage) {
        new DataValidationVerificationHelper(validationType, ignoreBlank, operatorType, inCellDropDown, formula1, formula2, showInput, inputTitle, inputMessage, showError, alertStyle, errorTitle, errorMessage).verify();
        new ReadWriteTask(){

            public Object invoke() {
                SDataValidation dv = RangeImpl.this.setValidaitonInLock(validationType, ignoreBlank, operatorType, inCellDropDown, formula1, formula2, showInput, inputTitle, inputMessage, showError, alertStyle, errorTitle, errorMessage);
                new NotifyChangeHelper().notifyDataValidationChange(RangeImpl.this.getSheet(), (String)(dv == null ? null : dv.getId()));
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    private SDataValidation setValidaitonInLock(SDataValidation.ValidationType validationType, boolean ignoreBlank, SDataValidation.OperatorType operatorType, boolean inCellDropDown, String formula1, String formula2, boolean showInput, String inputTitle, String inputMessage, boolean showError, SDataValidation.AlertStyle alertStyle, String errorTitle, String errorMessage) {
        List<SDataValidation> deletedDataValidations = null;
        deletedDataValidations = this.getSheet().deleteDataValidationRegion(new CellRegion(this.getRow(), this.getColumn(), this.getLastRow(), this.getLastColumn()));
        if (this.isDefaultValidationParameter(validationType, ignoreBlank, operatorType, inCellDropDown, formula1, formula2, showInput, inputTitle, inputMessage, showError, alertStyle, errorTitle, errorMessage)) {
            return deletedDataValidations != null && deletedDataValidations.size() > 0 ? deletedDataValidations.get(0) : null;
        }
        SDataValidation dv = this.getSheet().addDataValidation(new CellRegion(this.getRow(), this.getColumn(), this.getLastRow(), this.getLastColumn()));
        dv.setValidationType(validationType);
        dv.setIgnoreBlank(ignoreBlank);
        dv.setOperatorType(operatorType);
        dv.setInCellDropdown(inCellDropDown);
        ((AbstractDataValidationAdv)dv).setFormulas(formula1, formula2);
        dv.setShowInput(showInput);
        dv.setInputTitle(inputTitle);
        dv.setInputMessage(inputMessage);
        dv.setShowError(showError);
        dv.setAlertStyle(alertStyle);
        dv.setErrorTitle(errorTitle);
        dv.setErrorMessage(errorMessage);
        return dv;
    }

    private boolean isDefaultValidationParameter(SDataValidation.ValidationType validationType, boolean ignoreBlank, SDataValidation.OperatorType operatorType, boolean inCellDropDown, String formula1, String formula2, boolean showInput, String inputTitle, String inputMessage, boolean showError, SDataValidation.AlertStyle alertStyle, String errorTitle, String errorMessage) {
        return validationType == SDataValidation.ValidationType.ANY && showInput && inputTitle.isEmpty() && inputMessage.isEmpty() && showError && alertStyle == SDataValidation.AlertStyle.STOP && errorTitle.isEmpty() && errorMessage.isEmpty();
    }

    @Override
    public List<SDataValidation> getValidations() {
        return (List)new ReadWriteTask(){

            public Object invoke() {
                CellRegion region = new CellRegion(RangeImpl.this.getRow(), RangeImpl.this.getColumn(), RangeImpl.this.getLastRow(), RangeImpl.this.getLastColumn());
                ArrayList<SDataValidation> results = new ArrayList<SDataValidation>();
                int cellCount = region.getCellCount();
                for (SDataValidation dv : RangeImpl.this.getSheet().getDataValidations()) {
                    for (CellRegion rgn : dv.getRegions()) {
                        if (!rgn.overlaps(region)) continue;
                        results.add(dv);
                        break;
                    }
                    if (results.size() != cellCount) continue;
                    break;
                }
                return results;
            }
        }.doInReadLock(this.getLock());
    }

    @Override
    public void deleteValidation() {
        new ModelManipulationTask(){

            @Override
            public Object doInvoke() {
                List<SDataValidation> dvs = RangeImpl.this.getSheet().deleteDataValidationRegion(new CellRegion(RangeImpl.this.getRow(), RangeImpl.this.getColumn(), RangeImpl.this.getLastRow(), RangeImpl.this.getLastColumn()));
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public SFont getOrCreateFont(final SFont.Boldweight boldweight, final String htmlColor, final int fontHeight, final String fontName, final boolean italic, final boolean strikeout, final SFont.TypeOffset typeOffset, final SFont.Underline underline) {
        final SBook book = this.getBook();
        return (SFont)new ReadWriteTask(){

            public Object invoke() {
                FontMatcher fm = new FontMatcher();
                fm.setBoldweight(boldweight);
                fm.setColor(htmlColor);
                fm.setHeightPoints(fontHeight);
                fm.setName(fontName);
                fm.setItalic(italic);
                fm.setStrikeout(strikeout);
                fm.setTypeOffset(typeOffset);
                fm.setUnderline(underline);
                SFont font = book.searchFont(fm);
                if (font == null) {
                    font = (SFont)book.addFont().name(fontName).color(htmlColor).heightPoints(fontHeight).boldweight(boldweight).italic(italic).strikeout(strikeout).typeOffset(typeOffset).underline(underline).build();
                }
                return font;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void refresh(boolean includeDependants) {
        this.refresh(includeDependants, false, true);
    }

    @Override
    public void refresh(final boolean includeDependants, final boolean clearCache, final boolean enforceEval) {
        new ModelManipulationTask(){

            @Override
            protected Object doInvoke() {
                SSheet sheet = null;
                SBook book = null;
                SBookSeries bookSeries = RangeImpl.this.getSheet().getBook().getBookSeries();
                DependencyTable table = null;
                LinkedHashSet<Ref> refs = new LinkedHashSet<Ref>();
                if (includeDependants) {
                    table = ((AbstractBookSeriesAdv)bookSeries).getDependencyTable();
                }
                for (SheetRegion r : RangeImpl.this._rangeRefs) {
                    sheet = r.getSheet();
                    book = sheet.getBook();
                    CellRegion region = r.getRegion();
                    RefImpl ref = new RefImpl(book.getBookName(), sheet.getSheetName(), region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn());
                    refs.add(ref);
                    if (!includeDependants) continue;
                    refs.addAll(table.getDependents(ref));
                }
                if (clearCache) {
                    FormulaCacheCleaner.getCurrent().clear(refs);
                }
                if (enforceEval) {
                    for (Ref ref : refs) {
                        if (ref.getType() != Ref.RefType.CELL) continue;
                        SBook bk = bookSeries.getBook(ref.getBookName());
                        SSheet sh = bk.getSheetByName(ref.getSheetName());
                        SCell cell = sh.getCell(ref.getRow(), ref.getColumn());
                        cell.getValue();
                    }
                }
                RangeImpl.this.handleRefNotifyContentChange(bookSeries, refs, CellAttribute.ALL);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public boolean setAutoRefresh(boolean auto) {
        boolean previous = this._autoRefresh;
        this._autoRefresh = auto;
        return previous;
    }

    @Override
    public void setSheetVisible(final SRange.SheetVisible visible) {
        new ModelManipulationTask(){
            final ResultWrap<SSheet> toChangeSheet = new ResultWrap();

            @Override
            protected Object doInvoke() {
                SSheet sheet = null;
                if (!RangeImpl.this._rangeRefs.isEmpty()) {
                    SheetRegion r = (SheetRegion)RangeImpl.this._rangeRefs.iterator().next();
                    sheet = r.getSheet();
                    SSheet.SheetVisible option = null;
                    switch (visible) {
                        case HIDDEN: {
                            option = SSheet.SheetVisible.HIDDEN;
                            break;
                        }
                        case VISIBLE: {
                            option = SSheet.SheetVisible.VISIBLE;
                            break;
                        }
                        case VERY_HIDDEN: {
                            option = SSheet.SheetVisible.VERY_HIDDEN;
                        }
                    }
                    SSheet.SheetVisible old = sheet.getSheetVisible();
                    if (old != option) {
                        SBook book = sheet.getBook();
                        int numOfSheet = book.getNumOfSheet();
                        boolean isTryingToHide = SSheet.SheetVisible.VISIBLE.equals((Object)old);
                        if (isTryingToHide) {
                            boolean onlyOneVisibleSheet = true;
                            for (int i = 0; i < numOfSheet; ++i) {
                                SSheet sheet0 = book.getSheet(i);
                                if (!SSheet.SheetVisible.VISIBLE.equals((Object)sheet0.getSheetVisible()) || sheet0.equals(sheet)) continue;
                                onlyOneVisibleSheet = false;
                                break;
                            }
                            if (onlyOneVisibleSheet) {
                                throw new InvalidModelOpException("A workbook must contain at least one visible worksheet");
                            }
                        }
                        this.toChangeSheet.set(sheet);
                        sheet.setSheetVisible(option);
                        if (isTryingToHide && sheet.getViewInfo().isTabSelected()) {
                            sheet.getViewInfo().setTabSelected(false);
                            SSheet newSelectedSheet = RangeImpl.this.selectNextVisibleSheet(sheet.getBook(), book.getSheetIndex(sheet.getSheetName()), numOfSheet);
                            if (newSelectedSheet != null) {
                                new NotifyChangeHelper().notifySheetSelect(newSelectedSheet);
                            }
                        }
                    }
                }
                return null;
            }

            @Override
            protected void doBeforeNotify() {
                if (this.toChangeSheet.get() != null) {
                    new NotifyChangeHelper().notifySheetVisibleChange(this.toChangeSheet.get());
                }
            }
        }.doInWriteLock(this.getLock());
    }

    private SSheet selectNextVisibleSheet(SBook book, int index, int length) {
        SSheet sheet;
        int i;
        for (i = index + 1; i < length; ++i) {
            sheet = book.getSheet(i);
            if (!sheet.getSheetVisible().equals((Object)SSheet.SheetVisible.VISIBLE)) continue;
            sheet.getViewInfo().setTabSelected(true);
            return sheet;
        }
        for (i = index - 1; i >= 0; --i) {
            sheet = book.getSheet(i);
            if (!sheet.getSheetVisible().equals((Object)SSheet.SheetVisible.VISIBLE)) continue;
            sheet.getViewInfo().setTabSelected(true);
            return sheet;
        }
        return null;
    }

    @Override
    public void setCommentRichText(final String html) {
        new CellVisitorTask(new CellVisitorForUpdate(){

            @Override
            public boolean visit(SCell cell) {
                if (html == null) {
                    cell.deleteComment();
                } else {
                    SRichText text = new RichTextHelper().parse(RangeImpl.this, html);
                    SComment comment = cell.setupComment();
                    comment.setRichText(text);
                }
                return false;
            }

            @Override
            CellAttribute getCellAttr() {
                return CellAttribute.COMMENT;
            }
        }).doInWriteLock(this.getLock());
    }

    @Override
    public String getCommentRichText() {
        final ResultWrap r = new ResultWrap();
        new CellVisitorTask(new CellVisitor(){

            @Override
            public boolean visit(SCell cell) {
                SComment comment = cell.getComment();
                if (comment != null) {
                    SRichText rstr = comment.getRichText();
                    String html = RichTextHelper.getCellRichTextHtml(cell, rstr, true);
                    r.set(html);
                } else {
                    r.set(null);
                }
                return false;
            }
        }).doInReadLock(this.getLock());
        return (String)r.get();
    }

    @Override
    public void setCommentVisible(final boolean visible) {
        new CellVisitorTask(new CellVisitorForUpdate(){

            @Override
            public boolean visit(SCell cell) {
                SComment comment = cell.getComment();
                if (comment != null) {
                    comment.setVisible(visible);
                }
                return false;
            }

            @Override
            CellAttribute getCellAttr() {
                return CellAttribute.COMMENT;
            }
        }).doInWriteLock(this.getLock());
    }

    @Override
    public boolean isCommentVisible() {
        final ResultWrap r = new ResultWrap();
        new CellVisitorTask(new CellVisitor(){

            @Override
            public boolean visit(SCell cell) {
                SComment comment = cell.getComment();
                if (comment != null) {
                    r.set(comment.isVisible());
                } else {
                    r.set(false);
                }
                return false;
            }
        }).doInReadLock(this.getLock());
        return (Boolean)r.get();
    }

    @Override
    public void setNameName(final String namename, final String newname) {
        final ResultWrap resultSheet = new ResultWrap();
        final ResultWrap resultName = new ResultWrap();
        final ResultWrap oldName = new ResultWrap();
        new ModelManipulationTask(){

            @Override
            protected Object doInvoke() {
                String old;
                SBook book = RangeImpl.this.getBook();
                SSheet sheet = RangeImpl.this._rangeRefs.isEmpty() ? null : RangeImpl.this.getSheet();
                String sheetName = sheet == null ? null : sheet.getSheetName();
                SName name = book.getNameByName(namename, sheetName);
                String string = old = name == null ? null : name.getName();
                if (old == null || old.equals(newname)) {
                    return null;
                }
                book.setNameName(name, newname, sheetName);
                resultSheet.set(sheet);
                resultName.set(name);
                oldName.set(old);
                return null;
            }

            @Override
            protected void doBeforeNotify() {
                if (resultName.get() != null) {
                    new NotifyChangeHelper().notifyNameNameChange((SSheet)resultSheet.get(), (SName)resultName.get(), (String)oldName.get());
                }
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void setStringValue(final String value) {
        new CellVisitorTask(new CellVisitorForUpdate(){

            @Override
            public boolean visit(SCell cell) {
                Object cellval = cell.getValue();
                if (!RangeImpl.this.equalObjects(cellval, value)) {
                    ((AbstractCellAdv)cell).setStringValue(value);
                }
                return true;
            }

            @Override
            CellAttribute getCellAttr() {
                return CellAttribute.ALL;
            }
        }).doInWriteLock(this.getLock());
    }

    private void markRecalcTextWidthHeight(SCell cell) {
        SRow row = cell.getSheet().getRow(cell.getRowIndex());
        if (!row.isNull() && !row.isCustomHeight()) {
            ((AbstractCellAdv)cell).setCalcAutoHeight(true);
        }
        ((AbstractCellAdv)cell).setTextWidth(-1);
    }

    @Override
    public CellRegion getMergedRegion() {
        return (CellRegion)new ReadWriteTask(){

            public Object invoke() {
                return RangeImpl.this.getSheet().getMergedRegion(RangeImpl.this._row, RangeImpl.this._column);
            }
        }.doInReadLock(this.getLock());
    }

    @Override
    public CellRegion getDataRegion() {
        return (CellRegion)new ReadWriteTask(){

            public Object invoke() {
                return RangeImpl.this.getSheet().getDataRegion();
            }
        }.doInReadLock(this.getLock());
    }

    @Override
    public SSheet cloneSheetFrom(String name, SSheet sheet) {
        return this.cloneSheetFrom(name, sheet, false);
    }

    @Override
    public SSheet cloneSheetFrom(final String name, final SSheet sheet, final boolean valueOnly) {
        if (this.getBook().equals(sheet.getBook())) {
            RangeImpl rng = new RangeImpl(sheet);
            return rng.cloneSheet(name);
        }
        SBookSeries srcSeries = sheet.getBook().getBookSeries();
        final ReadWriteLock srcLock = srcSeries.equals(this.getBookSeries()) ? null : srcSeries.getLock();
        final ResultWrap resultSheet = new ResultWrap();
        return (SSheet)new ModelManipulationTask(){

            @Override
            protected Object doInvoke() {
                if (srcLock != null) {
                    srcLock.readLock().lock();
                    try {
                        SSheet sSheet = this._cloneSheetFrom(resultSheet, name, sheet);
                        return sSheet;
                    }
                    finally {
                        srcLock.readLock().unlock();
                    }
                }
                return this._cloneSheetFrom(resultSheet, name, sheet);
            }

            SSheet _cloneSheetFrom(ResultWrap<SSheet> resultSheet2, String name2, SSheet srcsheet) {
                SSheet sheet2;
                SBook book = RangeImpl.this.getBook();
                if (Strings.isBlank((String)name2)) {
                    String name0 = srcsheet.getSheetName();
                    String name1 = book.getSheetByName(name0) != null ? RangeImpl.this.nextSheetName() : name0;
                    sheet2 = book.createSheet(name1, srcsheet, valueOnly);
                } else {
                    sheet2 = book.createSheet(name2, srcsheet, valueOnly);
                }
                resultSheet2.set(sheet2);
                return sheet2;
            }

            @Override
            protected void doBeforeNotify() {
                if (resultSheet.get() != null) {
                    new NotifyChangeHelper().notifySheetCreate((SSheet)resultSheet.get());
                }
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public Set<SRange> getDirectPrecedents() {
        SBookSeries bookSeries = this.getBook().getBookSeries();
        DependencyTable dt = ((AbstractBookSeriesAdv)bookSeries).getDependencyTable();
        RefImpl cellRef = new RefImpl(this.getBook().getBookName(), this.getSheet().getSheetName(), this._row, this._column);
        Set<Ref> deps = ((DependencyTableAdv)dt).getDirectRegionPrecedents(cellRef);
        return this.refsToSRangs(deps);
    }

    @Override
    public Set<SRange> getPrecedents() {
        SBookSeries bookSeries = this.getBook().getBookSeries();
        DependencyTable dt = ((AbstractBookSeriesAdv)bookSeries).getDependencyTable();
        RefImpl cellRef = new RefImpl(this.getBook().getBookName(), this.getSheet().getSheetName(), this._row, this._column);
        Set<Ref> deps = ((DependencyTableAdv)dt).getRegionPrecedents(cellRef);
        return this.refsToSRangs(deps);
    }

    @Override
    public Set<SRange> getDirectDependents() {
        SBookSeries bookSeries = this.getBook().getBookSeries();
        DependencyTable dt = ((AbstractBookSeriesAdv)bookSeries).getDependencyTable();
        RefImpl cellRef = new RefImpl(this.getBook().getBookName(), this.getSheet().getSheetName(), this._row, this._column);
        Set<Ref> deps = ((DependencyTableAdv)dt).getDirectRegionDependents(cellRef);
        return this.refsToSRangs(deps);
    }

    @Override
    public Set<SRange> getDependents() {
        SBookSeries bookSeries = this.getBook().getBookSeries();
        DependencyTable dt = ((AbstractBookSeriesAdv)bookSeries).getDependencyTable();
        RefImpl cellRef = new RefImpl(this.getBook().getBookName(), this.getSheet().getSheetName(), this._row, this._column);
        Set<Ref> deps = ((DependencyTableAdv)dt).getRegionDependents(cellRef);
        return this.refsToSRangs(deps);
    }

    private Set<SRange> refsToSRangs(Set<Ref> refs) {
        if (refs == null) {
            return Collections.emptySet();
        }
        SBookSeries bookSeries = this.getBookSeries();
        LinkedHashSet<SRange> sranges = new LinkedHashSet<SRange>(refs.size());
        for (Ref dep : refs) {
            SBook sbook;
            if (dep.getType() == Ref.RefType.NAME) continue;
            String bn = dep.getBookName();
            String snb = dep.getSheetName();
            if (snb == null) {
                snb = this.getSheet().getSheetName();
            }
            String sne = dep.getLastSheetName();
            int l = dep.getColumn();
            int r = dep.getLastColumn();
            int t = dep.getRow();
            int b = dep.getLastRow();
            SBook sBook = sbook = bn == null ? this.getBook() : bookSeries.getBook(bn);
            if (sbook == null) continue;
            RangeImpl rngImpl = null;
            boolean noLastSheet = true;
            for (SSheet s : sbook.getSheets()) {
                if (rngImpl == null) {
                    if (!s.getSheetName().equalsIgnoreCase(snb)) continue;
                    rngImpl = new RangeImpl(s, t, l, b, r);
                    sranges.add(rngImpl);
                    if (sne != null && !sne.equalsIgnoreCase(snb)) continue;
                    noLastSheet = false;
                    break;
                }
                RangeImpl rngImpl0 = new RangeImpl(s, t, l, b, r);
                sranges.add(rngImpl0);
                if (!s.getSheetName().equalsIgnoreCase(sne)) continue;
                noLastSheet = false;
                break;
            }
            if (rngImpl == null) {
                throw new ArrayIndexOutOfBoundsException("Cannot find the 1st sheet: [" + snb + "]");
            }
            if (!noLastSheet) continue;
            throw new ArrayIndexOutOfBoundsException("Cannot find the 2nd sheet: [" + sne + "]");
        }
        return sranges;
    }

    @Override
    public void group() {
        new ReadWriteTask<Void>(){

            @Override
            public Void invoke() {
                if (RangeImpl.this.isWholeColumn()) {
                    RangeImpl.this.setGroupColumnInLock(true);
                } else if (RangeImpl.this.isWholeRow()) {
                    RangeImpl.this.setGroupRowInLock(true);
                } else {
                    RangeImpl.this.getRows().group();
                }
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void ungroup() {
        new ReadWriteTask<Void>(){

            @Override
            public Void invoke() {
                if (RangeImpl.this.isWholeColumn()) {
                    RangeImpl.this.setGroupColumnInLock(false);
                } else if (RangeImpl.this.isWholeRow()) {
                    RangeImpl.this.setGroupRowInLock(false);
                } else {
                    RangeImpl.this.getRows().ungroup();
                }
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    private void setGroupRowInLock(boolean increasing) {
        for (SheetRegion r : this._rangeRefs) {
            boolean hasChanged = false;
            SSheet sheet = r.getSheet();
            CellRegion region = r.getRegion();
            for (int i = region.row; i <= region.lastRow; ++i) {
                SRow row = sheet.getRow(i);
                int outline = row.getOutlineLevel();
                outline += increasing ? 1 : -1;
                outline = Math.max(0, outline);
                if ((outline = Math.min(7, outline)) == row.getOutlineLevel()) continue;
                row.setOutlineLevel(outline);
                hasChanged = true;
            }
            if (!hasChanged) continue;
            ((SheetImpl)sheet).syncOutlineLevelRowTree();
            this.notifySheetGroupChange(sheet);
        }
    }

    private void setGroupColumnInLock(boolean increasing) {
        for (SheetRegion r : this._rangeRefs) {
            boolean hasChanged = false;
            SSheet sheet = r.getSheet();
            CellRegion region = r.getRegion();
            for (int i = region.column; i <= region.lastColumn; ++i) {
                SColumn column = sheet.getColumn(i);
                int outline = column.getOutlineLevel();
                outline += increasing ? 1 : -1;
                outline = Math.max(0, outline);
                if ((outline = Math.min(7, outline)) == column.getOutlineLevel()) continue;
                column.setOutlineLevel(outline);
                hasChanged = true;
            }
            if (!hasChanged) continue;
            ((SheetImpl)sheet).syncOutlineLevelColTree();
            this.notifySheetGroupChange(sheet);
        }
    }

    @Override
    public List<SRange> getRowGroups() {
        return this.getRowGroups(1, 8);
    }

    @Override
    public List<SRange> getRowGroups(int outlineLevel) {
        return this.getRowGroups(outlineLevel, outlineLevel + 1);
    }

    @Override
    public List<SRange> getRowGroups(final int fromOutlineLevel, final int toOutlineLevel) {
        return (List)new ReadWriteTask<List<SRange>>(){

            @Override
            public List<SRange> invoke() {
                ArrayList<SRange> result = new ArrayList<SRange>();
                for (SheetRegion sheetRegion : RangeImpl.this._rangeRefs) {
                    SheetImpl sheet = (SheetImpl)sheetRegion.getSheet();
                    int levelRow = sheet.getOutlineLevelRow();
                    if (levelRow == 0 || levelRow >= toOutlineLevel) continue;
                    OutlineLevelTree outlineLevelTree = sheet.getOutlineLevelRowTree();
                    List<OutlineLevelTree.OutlineLevelNode> search = outlineLevelTree.search(Converter.areaToRef(sheetRegion.getRow(), fromOutlineLevel, sheetRegion.getLastRow(), toOutlineLevel));
                    for (OutlineLevelTree.OutlineLevelNode node : search) {
                        result.add(new RangeImpl(sheet, node.getStart(), 0, node.getEnd(), sheet.getBook().getMaxColumnIndex()));
                    }
                }
                return result;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public List<SRange> getColumnGroups() {
        return this.getColumnGroups(1, 8);
    }

    @Override
    public List<SRange> getColumnGroups(int outlineLevel) {
        return this.getColumnGroups(outlineLevel, outlineLevel + 1);
    }

    @Override
    public List<SRange> getColumnGroups(final int fromOutlineLevel, final int toOutlineLevel) {
        return (List)new ReadWriteTask<List<SRange>>(){

            @Override
            public List<SRange> invoke() {
                ArrayList<SRange> result = new ArrayList<SRange>();
                for (SheetRegion sheetRegion : RangeImpl.this._rangeRefs) {
                    SheetImpl sheet = (SheetImpl)sheetRegion.getSheet();
                    int levelCol = sheet.getOutlineLevelCol();
                    if (levelCol == 0 || levelCol >= toOutlineLevel) continue;
                    OutlineLevelTree outlineLevelTree = sheet.getOutlineLevelColTree();
                    List<OutlineLevelTree.OutlineLevelNode> search = outlineLevelTree.search(Converter.areaToRef(sheetRegion.getColumn(), fromOutlineLevel, sheetRegion.getLastColumn(), toOutlineLevel));
                    for (OutlineLevelTree.OutlineLevelNode node : search) {
                        result.add(new RangeImpl(sheet, 0, node.getStart(), sheet.getBook().getMaxRowIndex(), node.getEnd()));
                    }
                }
                return result;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void setSummaryBelow(final boolean summaryBelow) {
        new ReadWriteTask<Void>(){

            @Override
            public Void invoke() {
                for (SheetRegion sheetRegion : RangeImpl.this._rangeRefs) {
                    SSheet sheet = sheetRegion.getSheet();
                    if (sheet.isSummaryBelow() == summaryBelow) continue;
                    new RangeImpl(sheet).clearOutlineLevel();
                    sheet.setSummaryBelow(summaryBelow);
                }
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public boolean isSummaryBelow() {
        return this.getSheet().isSummaryBelow();
    }

    @Override
    public void setSummaryRight(final boolean summaryRight) {
        new ReadWriteTask<Void>(){

            @Override
            public Void invoke() {
                for (SheetRegion sheetRegion : RangeImpl.this._rangeRefs) {
                    SSheet sheet = sheetRegion.getSheet();
                    if (sheet.isSummaryRight() == summaryRight) continue;
                    new RangeImpl(sheet).clearOutlineLevel();
                    sheet.setSummaryRight(summaryRight);
                }
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public boolean isSummaryRight() {
        return this.getSheet().isSummaryRight();
    }

    @Override
    public void collapse() {
        new ReadWriteTask<Void>(){

            @Override
            public Void invoke() {
                OutlineLevelTree.OutlineLevelNode levelNode = RangeImpl.this.getMatchedOutlineLevelNode((SheetRegion)RangeImpl.this._rangeRefs.iterator().next());
                if (levelNode != null) {
                    SSheet sheet = RangeImpl.this.getSheet();
                    if (RangeImpl.this.isWholeColumn()) {
                        int end = levelNode.getEnd();
                        for (int start = levelNode.getStart(); start <= end; ++start) {
                            sheet.getColumn(start).setHidden(true);
                        }
                        if (sheet.isSummaryRight()) {
                            if (levelNode.getEnd() < RangeImpl.this.getBook().getMaxColumnIndex()) {
                                sheet.getColumn(levelNode.getEnd() + 1).setCollapsed(true);
                            }
                        } else if (levelNode.getStart() > 0) {
                            sheet.getColumn(levelNode.getStart() - 1).setCollapsed(true);
                        }
                    } else {
                        int end = levelNode.getEnd();
                        for (int start = levelNode.getStart(); start <= end; ++start) {
                            sheet.getRow(start).setHidden(true);
                        }
                        if (sheet.isSummaryBelow()) {
                            if (levelNode.getEnd() < RangeImpl.this.getBook().getMaxRowIndex()) {
                                sheet.getRow(levelNode.getEnd() + 1).setCollapsed(true);
                            }
                        } else if (levelNode.getStart() > 0) {
                            sheet.getRow(levelNode.getStart() - 1).setCollapsed(true);
                        }
                    }
                    RangeImpl.this.notifySheetGroupChange(sheet);
                }
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void expand() {
        new ReadWriteTask<Void>(){

            @Override
            public Void invoke() {
                OutlineLevelTree.OutlineLevelNode levelNode = RangeImpl.this.getMatchedOutlineLevelNode((SheetRegion)RangeImpl.this._rangeRefs.iterator().next());
                if (levelNode != null) {
                    SSheet sheet = RangeImpl.this.getSheet();
                    if (RangeImpl.this.isWholeColumn()) {
                        int end = levelNode.getEnd();
                        for (int start = levelNode.getStart(); start <= end; ++start) {
                            sheet.getColumn(start).setHidden(false);
                        }
                        if (sheet.isSummaryRight()) {
                            if (levelNode.getEnd() < RangeImpl.this.getBook().getMaxColumnIndex()) {
                                sheet.getColumn(levelNode.getEnd() + 1).setCollapsed(false);
                            }
                        } else if (levelNode.getStart() > 0) {
                            sheet.getColumn(levelNode.getStart() - 1).setCollapsed(false);
                        }
                    } else {
                        int end = levelNode.getEnd();
                        for (int start = levelNode.getStart(); start <= end; ++start) {
                            sheet.getRow(start).setHidden(false);
                        }
                        if (sheet.isSummaryBelow()) {
                            if (levelNode.getEnd() < RangeImpl.this.getBook().getMaxRowIndex()) {
                                sheet.getRow(levelNode.getEnd() + 1).setCollapsed(false);
                            }
                        } else if (levelNode.getStart() > 0) {
                            sheet.getRow(levelNode.getStart() - 1).setCollapsed(false);
                        }
                    }
                    RangeImpl.this.notifySheetGroupChange(sheet);
                }
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void clearOutlineLevel() {
        new ReadWriteTask<Void>(){

            @Override
            public Void invoke() {
                int outline;
                CellRegion region;
                SSheet sheet;
                boolean hasChanged;
                for (SheetRegion r : RangeImpl.this._rangeRefs) {
                    hasChanged = false;
                    sheet = r.getSheet();
                    if (sheet.getOutlineLevelCol() == 0) continue;
                    region = r.getRegion();
                    for (int i = region.column; i <= region.lastColumn; ++i) {
                        SColumn column = sheet.getColumn(i);
                        outline = column.getOutlineLevel();
                        if (outline > 0) {
                            column.setOutlineLevel(0);
                            hasChanged = true;
                        }
                        if (!column.isCollapsed()) continue;
                        column.setCollapsed(false);
                        hasChanged = true;
                    }
                    if (!hasChanged) continue;
                    SheetImpl sheetImpl = (SheetImpl)sheet;
                    sheetImpl.syncOutlineLevelColTree();
                    RangeImpl.this.notifySheetGroupChange(sheet);
                }
                for (SheetRegion r : RangeImpl.this._rangeRefs) {
                    hasChanged = false;
                    sheet = r.getSheet();
                    if (sheet.getOutlineLevelRow() == 0) continue;
                    region = r.getRegion();
                    for (int i = region.row; i <= region.lastRow; ++i) {
                        SRow row = sheet.getRow(i);
                        outline = row.getOutlineLevel();
                        if (outline > 0) {
                            row.setOutlineLevel(0);
                            hasChanged = true;
                        }
                        if (!row.isCollapsed()) continue;
                        row.setCollapsed(false);
                        hasChanged = true;
                    }
                    if (!hasChanged) continue;
                    SheetImpl sheetImpl = (SheetImpl)sheet;
                    sheetImpl.syncOutlineLevelRowTree();
                    RangeImpl.this.notifySheetGroupChange(sheet);
                }
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public boolean isCollapsed() {
        OutlineLevelTree.OutlineLevelNode levelNode = this.getMatchedOutlineLevelNode((SheetRegion)this._rangeRefs.iterator().next());
        if (levelNode != null) {
            if (this.isWholeRow()) {
                SSheet sheet = this.getSheet();
                if (sheet.isSummaryBelow()) {
                    if (levelNode.getEnd() == this.getBook().getMaxRowIndex()) {
                        return false;
                    }
                    return sheet.getRow(levelNode.getEnd() + 1).isCollapsed();
                }
                if (levelNode.getStart() == 0) {
                    return false;
                }
                return sheet.getRow(levelNode.getStart() - 1).isCollapsed();
            }
            SSheet sheet = this.getSheet();
            if (sheet.isSummaryRight()) {
                if (levelNode.getEnd() == this.getBook().getMaxColumnIndex()) {
                    return false;
                }
                return sheet.getColumn(levelNode.getEnd() + 1).isCollapsed();
            }
            if (levelNode.getStart() == 0) {
                return false;
            }
            return sheet.getColumn(levelNode.getStart() - 1).isCollapsed();
        }
        return false;
    }

    @Override
    public int getOutlineLevel() {
        OutlineLevelTree.OutlineLevelNode matchedOutlineLevelNode = this.getMatchedOutlineLevelNode((SheetRegion)this._rangeRefs.iterator().next());
        return matchedOutlineLevelNode != null ? matchedOutlineLevelNode.getLevel() : 0;
    }

    private OutlineLevelTree.OutlineLevelNode getMatchedOutlineLevelNode(SheetRegion region) {
        OutlineLevelTree outlineLevelRowTree;
        if (this.isWholeColumn()) {
            List<OutlineLevelTree.OutlineLevelNode> search;
            OutlineLevelTree outlineLevelTree = ((SheetImpl)region.getSheet()).getOutlineLevelColTree();
            if (outlineLevelTree != null && !(search = outlineLevelTree.search(Converter.areaToRef(region.getColumn(), 1, region.getLastColumn(), 8))).isEmpty()) {
                return search.stream().filter(node -> node.getStart() == region.getColumn() && node.getEnd() == region.getLastColumn()).findFirst().orElse(null);
            }
        } else if (this.isWholeRow() && (outlineLevelRowTree = ((SheetImpl)region.getSheet()).getOutlineLevelRowTree()) != null) {
            List<OutlineLevelTree.OutlineLevelNode> search = outlineLevelRowTree.search(Converter.areaToRef(region.getRow(), 1, region.getLastRow(), 8));
            return search.stream().filter(node -> node.getStart() == region.getRow() && node.getEnd() == region.getLastRow()).findFirst().orElse(null);
        }
        return null;
    }

    private void handleCellNotifyBeforeValueChange(SheetRegion cellNotify) {
        NotifyChangeHelper.notifyBeforeCellValueChange(cellNotify);
    }

    private class ModelUpdateWrapper {
        SBookSeries bookSeries;
        List<ModelUpdate> modelUpdates;
        ModelUpdateCollector modelUpdateCollector;
        ModelUpdateCollector oldCollector;
        FormulaCacheCleaner oldClearer;

        public ModelUpdateWrapper(SBookSeries bookSeries, boolean collectUpdate) {
            this.bookSeries = bookSeries;
            this.oldCollector = ModelUpdateCollector.setCurrent(collectUpdate ? (this.modelUpdateCollector = new ModelUpdateCollector()) : null);
            this.oldClearer = FormulaCacheCleaner.setCurrent(new FormulaCacheCleaner(bookSeries));
        }

        public void doFinially() {
            if (this.modelUpdateCollector != null) {
                this.modelUpdates = this.modelUpdateCollector.getModelUpdates();
            }
            ModelUpdateCollector.setCurrent(this.oldCollector);
            FormulaCacheCleaner.setCurrent(this.oldClearer);
        }

        public void doNotify() {
            if (this.modelUpdates == null) {
                return;
            }
            for (ModelUpdate update : this.modelUpdates) {
                switch (update.getType()) {
                    case CELL: {
                        RangeImpl.this.handleCellNotifyContentChange((SheetRegion)update.getData(), update.getCellAttr());
                        break;
                    }
                    case CELLS: {
                        RangeImpl.this.handleCellNotifyContentChange((Set)update.getData(), update.getCellAttr());
                        break;
                    }
                    case REF: {
                        RangeImpl.this.handleRefNotifyContentChange(this.bookSeries, (Ref)update.getData(), update.getCellAttr());
                        break;
                    }
                    case REFS: {
                        RangeImpl.this.handleRefNotifyContentChange(this.bookSeries, (Set)update.getData(), update.getCellAttr());
                        break;
                    }
                    case MERGE: {
                        MergeUpdate mu = (MergeUpdate)update.getData();
                        if (mu.getOrigMerge() != null) {
                            RangeImpl.this.handleMergeRemoveNotifyChange(new SheetRegion(mu.getSheet(), mu.getOrigMerge()));
                        }
                        if (mu.getMerge() == null) break;
                        RangeImpl.this.handleMergeAddNotifyChange(new SheetRegion(mu.getSheet(), mu.getMerge()));
                        break;
                    }
                    case INSERT_DELETE: {
                        RangeImpl.this.handleInsertDeleteNotifyChange((InsertDeleteUpdate)update.getData());
                        break;
                    }
                    case FILTER: {
                        RangeImpl.this.handleAutoFitlerNotifyChange((AutoFilterUpdate)update.getData());
                    }
                }
            }
        }
    }

    private abstract class ModelManipulationTask
    extends ReadWriteTask {
        private ModelManipulationTask() {
        }

        protected abstract Object doInvoke();

        protected void doBeforeNotify() {
        }

        protected void doAfterNotify() {
        }

        protected boolean isCollectModelUpdate() {
            return true;
        }

        public Object invoke() {
            ModelUpdateWrapper updateWrap = new ModelUpdateWrapper(RangeImpl.this.getBookSeries(), this.isCollectModelUpdate());
            Object result = null;
            try {
                result = this.doInvoke();
            }
            finally {
                updateWrap.doFinially();
            }
            this.doBeforeNotify();
            updateWrap.doNotify();
            this.doAfterNotify();
            return result;
        }
    }

    static class ResultWrap<T> {
        T obj;

        public ResultWrap() {
        }

        public ResultWrap(T obj) {
            this.obj = obj;
        }

        public T get() {
            return this.obj;
        }

        public void set(T obj) {
            this.obj = obj;
        }
    }

    private abstract class CellVisitorForUpdate
    extends CellVisitor {
        private CellVisitorForUpdate() {
        }

        @Override
        public void afterVisitAll() {
            if (!RangeImpl.this.isAutoRefresh()) {
                return;
            }
            SBookSeries bookSeries = RangeImpl.this.getSheet().getBook().getBookSeries();
            DependencyTable table = ((AbstractBookSeriesAdv)bookSeries).getDependencyTable();
            for (SheetRegion r : RangeImpl.this._rangeRefs) {
                SSheet sheet = r.getSheet();
                CellRegion region = r.getRegion();
                RangeImpl.this.handleCellNotifyContentChange(new SheetRegion(sheet, region), this.getCellAttr());
                RangeImpl.this.handleRefNotifyContentChange(bookSeries, table.getEvaluatedDependents(new RefImpl(sheet.getBook().getBookName(), sheet.getSheetName(), region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn())), this.getCellAttr());
            }
        }

        abstract CellAttribute getCellAttr();
    }

    private abstract class CellVisitor {
        private CellVisitor() {
        }

        abstract boolean visit(SCell var1);

        public void afterVisitAll() {
        }
    }

    private class CellVisitorTask
    extends ReadWriteTask {
        private CellVisitor visitor;
        private boolean stop = false;

        private CellVisitorTask(CellVisitor visitor) {
            this.visitor = visitor;
        }

        public Object invoke() {
            RangeImpl.this.travelCells(this.visitor);
            return null;
        }
    }
}

