/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl;

import io.keikai.model.SCell;
import io.keikai.model.impl.RuleInfo;
import io.keikai.model.sys.formula.EvaluationResult;
import io.keikai.range.impl.Matchable;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.poi.ss.usermodel.DateUtil;

public class ExpressionMatch
implements Matchable<SCell>,
Serializable {
    private static final long serialVersionUID = -1931445210569317355L;
    private final RuleInfo ruleInfo;

    public ExpressionMatch(RuleInfo ruleInfo) {
        this.ruleInfo = ruleInfo;
    }

    @Override
    public boolean match(SCell cell) {
        EvaluationResult result = this.ruleInfo.evalFormula(cell);
        if (result.getType() == EvaluationResult.ResultType.SUCCESS) {
            Object val = result.getValue();
            return this.matchVal(val);
        }
        return false;
    }

    private boolean matchVal(Object val) {
        if (val instanceof Double) {
            return (Double)val != 0.0;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof Date) {
            return DateUtil.getExcelDate((Date)((Date)val)) != 0.0;
        }
        if (val instanceof List && !((List)val).isEmpty()) {
            return this.matchVal(((List)val).get(0));
        }
        return false;
    }
}

