/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl;

import io.keikai.model.CellRegion;
import io.keikai.model.InvalidModelOpException;
import io.keikai.model.SCell;
import io.keikai.model.SRow;
import io.keikai.model.SheetRegion;
import io.keikai.model.impl.CellBuffer;
import io.keikai.model.impl.PasteCellHelper;
import io.keikai.model.sys.formula.FormulaExpression;
import io.keikai.model.sys.formula.FormulaParseContext;
import io.keikai.range.SRange;
import io.keikai.range.impl.RangeHelperBase;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.zk.ui.UiException;

public class SortHelper
extends RangeHelperBase {
    private static final long serialVersionUID = -7415497327961609453L;
    public static final int SORT_HEADER_NO = 0;
    public static final int SORT_HEADER_YES = 1;
    static final Double ZERO = new Double(0.0);
    private CellRegion sortingRegion;
    private List<CellRegion> mergedRegionBeforeSorting = new LinkedList<CellRegion>();
    private List<CellRegion> mergedRegionAfterSorting = new LinkedList<CellRegion>();

    public SortHelper(SRange range) {
        super(range);
    }

    public void sort(SRange key1, boolean descending1, SRange.SortDataOption dataOption1, SRange key2, boolean descending2, SRange.SortDataOption dataOption2, SRange key3, boolean descending3, SRange.SortDataOption dataOption3, int header, boolean matchCase, boolean sortByRows) {
        this.checkMergedRegions(sortByRows);
        this.sortingRegion = this.findSortingRegion(header, sortByRows);
        if (this.sortingRegion == null) {
            return;
        }
        int keyCount = 0;
        if (key1 != null) {
            ++keyCount;
            if (key2 != null) {
                ++keyCount;
                if (key3 != null) {
                    ++keyCount;
                }
            }
        }
        if (keyCount == 0) {
            throw new UiException("Must specify at least the key1");
        }
        SRange.SortDataOption[] dataOptions = new SRange.SortDataOption[keyCount];
        boolean[] descs = new boolean[keyCount];
        int[] keyIndexes = new int[keyCount];
        keyIndexes[0] = this.rangeToIndex(key1, sortByRows);
        descs[0] = descending1;
        dataOptions[0] = dataOption1;
        if (keyCount > 1) {
            keyIndexes[1] = this.rangeToIndex(key2, sortByRows);
            descs[1] = descending2;
            dataOptions[1] = dataOption2;
        }
        if (keyCount > 2) {
            keyIndexes[2] = this.rangeToIndex(key3, sortByRows);
            descs[2] = descending3;
            dataOptions[2] = dataOption3;
        }
        this.validateKeyIndexes(keyIndexes, sortByRows);
        for (CellRegion r : this.sheet.getMergedRegions()) {
            if (!this.sortingRegion.contains(r)) continue;
            this.mergedRegionBeforeSorting.add(r);
        }
        List<SortKey> sortKeys = this.collectKeys(sortByRows, keyCount, dataOptions, keyIndexes);
        Collections.sort(sortKeys, new KeyComparator(descs, matchCase));
        this.sheet.removeMergedRegion(this.sortingRegion, true);
        if (sortByRows) {
            this.repositionColumns(sortKeys);
        } else {
            this.repositionRows(sortKeys);
        }
        for (CellRegion r : this.mergedRegionAfterSorting) {
            this.sheet.addMergedRegion(r);
        }
    }

    private void checkMergedRegions(boolean sortByRows) {
        CellRegion selection = new CellRegion(this.getRow(), this.getColumn(), this.getLastRow(), this.getLastColumn());
        for (CellRegion region : this.sheet.getMergedRegions()) {
            if (selection.contains(region)) {
                if (sortByRows) {
                    if (region.getColumn() == region.getLastColumn()) continue;
                    throw new InvalidModelOpException("Cannot sort a range that conains merged cells across columns.");
                }
                if (region.getRow() == region.getLastRow()) continue;
                throw new InvalidModelOpException("Cannot sort a range that conains merged cells across rows.");
            }
            if (!selection.overlaps(region)) continue;
            throw new InvalidModelOpException("Cannot sort a range that conains part of merged cells.");
        }
    }

    private List<SortKey> collectKeys(boolean sortByRows, int keyCount, SRange.SortDataOption[] dataOptions, int[] keyIndexes) {
        ArrayList<SortKey> sortKeys = new ArrayList<SortKey>(sortByRows ? this.sortingRegion.getColumnCount() : this.sortingRegion.getRowCount());
        if (sortByRows) {
            for (int columnIndex = this.sortingRegion.getColumn(); columnIndex <= this.sortingRegion.getLastColumn(); ++columnIndex) {
                Object[] values = new Object[keyCount];
                for (int j = 0; j < keyCount; ++j) {
                    values[j] = this.getCellValue(this.sheet.getCell(keyIndexes[j], columnIndex), dataOptions[j]);
                }
                SortKey sortKey = new SortKey(columnIndex, values);
                sortKeys.add(sortKey);
            }
        } else {
            for (int rowIndex = this.sortingRegion.getRow(); rowIndex <= this.sortingRegion.getLastRow(); ++rowIndex) {
                SRow row = this.sheet.getRow(rowIndex);
                if (row.isNull()) continue;
                Object[] values = new Object[keyCount];
                for (int j = 0; j < keyCount; ++j) {
                    values[j] = this.getCellValue(this.sheet.getCell(rowIndex, keyIndexes[j]), dataOptions[j]);
                }
                SortKey sortKey = new SortKey(rowIndex, values);
                sortKeys.add(sortKey);
            }
        }
        return sortKeys;
    }

    private CellRegion findSortingRegion(int header, boolean sortByRows) {
        int row = this.getRow();
        int column = this.getColumn();
        int lastRow = this.getLastRow();
        int lastColumn = this.getLastColumn();
        if (header == 1) {
            if (sortByRows) {
                ++column;
            } else {
                ++row;
            }
        }
        row = Math.max(row, this.sheet.getStartRowIndex());
        lastRow = Math.min(lastRow, this.sheet.getEndRowIndex());
        if (sortByRows) {
            int nonBlankColumn = this.range.getSheet().getBook().getMaxColumnIndex();
            int nonBlankLastColumn = 0;
            for (int index = row; index <= lastRow; ++index) {
                nonBlankColumn = Math.min(nonBlankColumn, this.sheet.getStartCellIndex(index));
                nonBlankLastColumn = Math.max(nonBlankLastColumn, this.sheet.getEndCellIndex(index));
            }
            column = Math.max(column, nonBlankColumn);
            lastColumn = Math.min(lastColumn, nonBlankLastColumn);
        }
        if (row > lastRow || column > lastColumn || row < 0 || lastRow < 0 || column < 0 || lastColumn < 0) {
            return null;
        }
        this.sortingRegion = new CellRegion(row, column, lastRow, lastColumn);
        return this.sortingRegion;
    }

    private int rangeToIndex(SRange range, boolean sortByRows) {
        return sortByRows ? range.getRow() : range.getColumn();
    }

    private void validateKeyIndexes(int[] keyIndexes, boolean sortByRows) {
        if (!sortByRows) {
            for (int j = keyIndexes.length - 1; j >= 0; --j) {
                int keyIndex = keyIndexes[j];
                if (keyIndex >= this.sortingRegion.getColumn() && keyIndex <= this.sortingRegion.getLastColumn()) continue;
                throw new UiException("The given key is out of the sorting range: " + keyIndex);
            }
        } else {
            for (int j = keyIndexes.length - 1; j >= 0; --j) {
                int keyIndex = keyIndexes[j];
                if (keyIndex >= this.sortingRegion.getRow() && keyIndex <= this.sortingRegion.getLastRow()) continue;
                throw new UiException("The given key is out of the sorting range: " + keyIndex);
            }
        }
    }

    private void repositionColumns(List<SortKey> sortKeys) {
        int cellCount = this.sortingRegion.getRowCount();
        int columnBufferIndex = 0;
        ArrayList<SortResult> sortResults = new ArrayList<SortResult>(sortKeys.size());
        for (SortKey sortKey : sortKeys) {
            int oldColumnIndex = sortKey.getIndex();
            int newColumnIndex = this.sortingRegion.getColumn() + columnBufferIndex;
            CellBuffer[] cellBuffer = new CellBuffer[cellCount];
            for (int r = 0; r < cellCount; ++r) {
                cellBuffer[r] = CellBuffer.bufferAll(this.sheet.getCell(this.sortingRegion.getRow() + r, oldColumnIndex));
            }
            sortResults.add(new SortResult(oldColumnIndex, newColumnIndex, cellBuffer));
            for (CellRegion r : this.mergedRegionBeforeSorting) {
                if (r.getColumn() != oldColumnIndex) continue;
                int columnOffset = newColumnIndex - oldColumnIndex;
                this.mergedRegionAfterSorting.add(new CellRegion(r.getRow(), r.getColumn() + columnOffset, r.getLastRow(), r.getLastColumn() + columnOffset));
            }
            ++columnBufferIndex;
        }
        PasteCellHelper pasteHelper = new PasteCellHelper(this.sheet);
        for (SortResult result : sortResults) {
            int offset = result.newIndex - result.oldIndex;
            if (offset == 0) continue;
            for (int r = 0; r < result.cellBuffer.length; ++r) {
                SCell cell = this.sheet.getCell(this.sortingRegion.getRow() + r, result.newIndex);
                this.pasteToNewCell(pasteHelper, result.cellBuffer[r], cell, null, 0, offset);
            }
        }
    }

    private void repositionRows(List<SortKey> sortKeys) {
        int cellCount = this.sortingRegion.getColumnCount();
        int rowBufferIndex = 0;
        ArrayList<SortResult> sortResults = new ArrayList<SortResult>(sortKeys.size());
        for (SortKey sortKey : sortKeys) {
            int oldRowIndex = sortKey.getIndex();
            int newRowIndex = this.sortingRegion.getRow() + rowBufferIndex;
            CellBuffer[] cellBuffer = new CellBuffer[cellCount];
            for (int c = 0; c < cellCount; ++c) {
                cellBuffer[c] = CellBuffer.bufferAll(this.sheet.getCell(oldRowIndex, this.sortingRegion.getColumn() + c));
            }
            sortResults.add(new SortResult(oldRowIndex, newRowIndex, cellBuffer));
            for (CellRegion r : this.mergedRegionBeforeSorting) {
                if (r.getRow() != oldRowIndex) continue;
                int rowOffset = newRowIndex - oldRowIndex;
                this.mergedRegionAfterSorting.add(new CellRegion(r.getRow() + rowOffset, r.getColumn(), r.getLastRow() + rowOffset, r.getLastColumn()));
            }
            ++rowBufferIndex;
        }
        PasteCellHelper pasteHelper = new PasteCellHelper(this.sheet);
        for (SortResult result : sortResults) {
            int offset = result.newIndex - result.oldIndex;
            if (offset == 0) continue;
            for (int c = 0; c < result.cellBuffer.length; ++c) {
                int col = this.sortingRegion.getColumn() + c;
                SCell cell = this.sheet.getCell(result.newIndex, col);
                this.pasteToNewCell(pasteHelper, result.cellBuffer[c], cell, null, offset, 0);
            }
        }
    }

    private void pasteToNewCell(PasteCellHelper helper, CellBuffer buffer, SCell cell, SheetRegion cutFrom, int rowOffset, int columnOffset) {
        if (buffer.isNull()) {
            int r = cell.getRowIndex();
            int c = cell.getColumnIndex();
            cell.getSheet().clearCell(r, c, r, c);
        } else {
            helper.pasteValue(buffer, cell, cutFrom, buffer.getType() == SCell.CellType.FORMULA, rowOffset, columnOffset, false, 0, 0, Collections.EMPTY_SET);
            buffer.applyStyle(cell);
            buffer.applyHyperlink(cell);
            buffer.applyComment(cell);
        }
    }

    private Object getCellValue(SCell cell, SRange.SortDataOption dataOption) {
        Object val = cell.getValue();
        if (val instanceof String && dataOption == SRange.SortDataOption.TEXT_AS_NUMBERS) {
            try {
                val = new Double((String)val);
            }
            catch (NumberFormatException ex) {
                val = ZERO;
            }
        }
        return val;
    }

    private SCell getProxyInstance(SCell cell, SheetRegion srcRegion, int rowOffset, int columnOffset) {
        return (SCell)Proxy.newProxyInstance(FormulaMovingCell.class.getClassLoader(), new Class[]{SCell.class}, (InvocationHandler)new FormulaMovingCell(cell, srcRegion, rowOffset, columnOffset));
    }

    private static class KeyComparator
    implements Comparator<SortKey>,
    Serializable {
        private final boolean[] _descs;
        private final boolean _matchCase;

        public KeyComparator(boolean[] descs, boolean matchCase) {
            this._descs = descs;
            this._matchCase = matchCase;
        }

        @Override
        public int compare(SortKey o1, SortKey o2) {
            Object[] values1 = o1.getValues();
            Object[] values2 = o2.getValues();
            return this.compare(values1, values2);
        }

        @Override
        private int compare(Object[] values1, Object[] values2) {
            int len = values1.length;
            for (int j = 0; j < len; ++j) {
                int result = this.compareValue(values1[j], values2[j], this._descs[j]);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }

        private int compareValue(Object val1, Object val2, boolean desc) {
            int order1;
            if (val1 == val2) {
                return 0;
            }
            int n = val1 instanceof Byte ? 4 : (val1 instanceof Boolean ? 3 : (val1 instanceof String ? 2 : (val1 instanceof Number ? 1 : (order1 = desc ? 0 : 5))));
            int order2 = val2 instanceof Byte ? 4 : (val2 instanceof Boolean ? 3 : (val2 instanceof String ? 2 : (val2 instanceof Number ? 1 : (desc ? 0 : 5))));
            int ret = 0;
            if (order1 != order2) {
                ret = order1 - order2;
            } else {
                switch (order1) {
                    case 4: {
                        ret = 0;
                        break;
                    }
                    case 3: {
                        ret = ((Boolean)val1).compareTo((Boolean)val2);
                        break;
                    }
                    case 2: {
                        ret = this.compareString(val1.toString(), val2.toString());
                        break;
                    }
                    case 1: {
                        ret = ((Double)val1).compareTo((Double)val2);
                        break;
                    }
                    default: {
                        throw new UiException("Unknown value type: " + val1.getClass());
                    }
                }
            }
            return desc ? -ret : ret;
        }

        private int compareString(String s1, String s2) {
            return this._matchCase ? this.compareString0(s1, s2) : s1.compareToIgnoreCase(s2);
        }

        private int compareString0(String s1, String s2) {
            int len2;
            int len1 = s1.length();
            int len = len1 > (len2 = s2.length()) ? len2 : len1;
            for (int j = 0; j < len; ++j) {
                int ret = this.compareChar(s1.charAt(j), s2.charAt(j));
                if (ret == 0) continue;
                return ret;
            }
            return len1 - len2;
        }

        private int compareChar(char ch1, char ch2) {
            char uch2;
            char uch1 = Character.toUpperCase(ch1);
            return uch1 == (uch2 = Character.toUpperCase(ch2)) ? ch2 - ch1 : uch1 - uch2;
        }
    }

    public static class SortKey {
        private final int _index;
        private final Object[] _values;

        public SortKey(int index, Object[] values) {
            this._index = index;
            this._values = values;
        }

        public int getIndex() {
            return this._index;
        }

        public Object[] getValues() {
            return this._values;
        }
    }

    class SortResult {
        int oldIndex;
        int newIndex;
        CellBuffer[] cellBuffer;

        SortResult(int oldIndex, int newIndex, CellBuffer[] cellBuffer) {
            this.oldIndex = oldIndex;
            this.newIndex = newIndex;
            this.cellBuffer = cellBuffer;
        }

        public String toString() {
            return this.oldIndex + " -> " + this.newIndex + "(" + this.cellBuffer.length + " cells)";
        }
    }

    class FormulaMovingCell
    implements InvocationHandler {
        private final SCell proxiedCell;
        private final SheetRegion srcRegion;
        private final int rowOffset;
        private final int columnOffset;
        private final FormulaParseContext context;

        public FormulaMovingCell(SCell cell, SheetRegion srcRegion, int rowOffset, int columnOffset) {
            this.proxiedCell = cell;
            this.srcRegion = srcRegion;
            this.rowOffset = rowOffset;
            this.columnOffset = columnOffset;
            this.context = new FormulaParseContext(this.proxiedCell, null);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("setFormulaValue")) {
                FormulaExpression fexpr = SortHelper.this.getFormulaEngine().parse(args[0].toString(), this.context);
                FormulaExpression movedFormula = SortHelper.this.getFormulaEngine().movePtgs(fexpr, this.srcRegion, this.rowOffset, this.columnOffset, this.context);
                this.proxiedCell.setFormulaValue(movedFormula.getFormulaString());
                return null;
            }
            return method.invoke((Object)this.proxiedCell, args);
        }
    }
}

