/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.impl.RefImpl;
import io.keikai.model.sys.dependency.ColumnRef;
import io.keikai.model.sys.dependency.Ref;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.ptg.TablePtg;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellReference;

public class ColumnRefImpl
extends RefImpl
implements ColumnRef {
    private static final long serialVersionUID = 1L;
    private final boolean _withHeaders;
    private final String _tableName;
    private final String _columnName1;
    private final String _columnName2;
    private final TablePtg.Item _item1;
    private final TablePtg.Item _item2;

    public ColumnRefImpl(String bookName, String sheetName, String tableName, TablePtg.Item item1, TablePtg.Item item2, String columnName1, String columnName2, boolean withHeaders, int row, int column, int lastRow, int lastColumn) {
        super(Ref.RefType.TABLE, bookName, sheetName, null, row, column, lastRow, lastColumn);
        this._tableName = tableName;
        this._columnName1 = columnName1;
        this._columnName2 = columnName2;
        this._item1 = item1;
        this._item2 = item2;
        this._withHeaders = withHeaders;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.bookName == null ? 0 : this.bookName.hashCode());
        result = 31 * result + (this._tableName == null ? 0 : this._tableName.hashCode());
        result = 31 * result + (this._columnName1 == null ? 0 : this._columnName1.hashCode());
        result = 31 * result + (this._columnName2 == null ? 0 : this._columnName2.hashCode());
        result = 31 * result + (this._item1 == null ? 0 : this._item1.hashCode());
        result = 31 * result + (this._item2 == null ? 0 : this._item2.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnRefImpl other = (ColumnRefImpl)obj;
        if (this.bookName == null ? other.bookName != null : !this.bookName.equals(other.bookName)) {
            return false;
        }
        if (this._tableName == null ? other._tableName != null : !this._tableName.equals(other._tableName)) {
            return false;
        }
        if (this._columnName1 == null ? other._columnName1 != null : !this._columnName1.equals(other._columnName1)) {
            return false;
        }
        if (this._columnName2 == null ? other._columnName2 != null : !this._columnName2.equals(other._columnName2)) {
            return false;
        }
        if (this._item1 == null ? other._item1 != null : !this._item1.equals((Object)other._item1)) {
            return false;
        }
        return !(this._item2 == null ? other._item2 != null : !this._item2.equals((Object)other._item2));
    }

    @Override
    public String toString() {
        int row1 = this.getRow();
        int row2 = this.getLastRow();
        int col1 = this.getColumn();
        int col2 = this.getLastColumn();
        return this.bookName + ":" + this.sheetName + "!" + TablePtg.formatAsFormulaString((String)this._tableName, (TablePtg.Item)this._item1, (TablePtg.Item)this._item2, (String)this._columnName1, (String)this._columnName2, (boolean)false) + (row1 == row2 && col1 == col2 ? new CellReference(row1, col1).formatAsString() : new AreaReference(new CellReference(row1, col1), new CellReference(row2, col2), SpreadsheetVersion.EXCEL2007).formatAsString());
    }

    @Override
    public String getTableName() {
        return this._tableName;
    }

    @Override
    public String getColumnName1() {
        return this._columnName1;
    }

    @Override
    public String getColumnName2() {
        return this._columnName2;
    }

    @Override
    public boolean isWithHeaders() {
        return this._withHeaders;
    }
}

