/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.importer;

import io.keikai.importer.ChartSpaceJson;
import io.keikai.importer.GroupPictureJson;
import io.keikai.importer.PictureJson;
import io.keikai.importer.ShapeJson;
import io.keikai.importer.VmlDrawing;
import io.keikai.importer.xml.Cell;
import io.keikai.importer.xml.Row;
import io.keikai.importer.xml.SheetData;
import io.keikai.json.JSONArray;
import io.keikai.json.JSONAware;
import io.keikai.json.JSONObject;
import io.keikai.model.SAutoFilter;
import io.keikai.model.SCFValueObject;
import io.keikai.model.SConditionalFormattingRule;
import io.keikai.model.SDataValidation;
import io.keikai.model.SHyperlink;
import io.keikai.model.SIconSet;
import io.keikai.model.SPrintSetup;
import io.keikai.model.STableColumn;
import io.keikai.util.Converter;
import io.keikai.util.XlsxJsonHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.zkoss.util.Pair;

public class XlsxExtractor {
    static final String PrinterRelType = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/printerSettings";
    static final String TableRelType = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/table";
    static final String CommentsRelType = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments";
    static final String VmlDrawingRelType = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/vmlDrawing";
    static final String DrawingRelType = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing";

    private static Map<String, String> _getSheetPrinterRels(String sheetPath, Map bookJson) {
        return XlsxExtractor._getSheetRels(sheetPath, PrinterRelType, bookJson);
    }

    private static Map<String, String> _getSheetTableRels(String sheetPath, Map bookJson) {
        return XlsxExtractor._getSheetRels(sheetPath, TableRelType, bookJson);
    }

    private static Map<String, String> _getSheetCommentsRels(String sheetPath, Map bookJson) {
        return XlsxExtractor._getSheetRels(sheetPath, CommentsRelType, bookJson);
    }

    private static Map<String, String> _getSheetVmlDrawingRels(String sheetPath, Map bookJson) {
        return XlsxExtractor._getSheetRels(sheetPath, VmlDrawingRelType, bookJson);
    }

    private static Map<String, String> _getSheetDrawingRels(String sheetPath, Map bookJson) {
        return XlsxExtractor._getSheetRels(sheetPath, DrawingRelType, bookJson);
    }

    private static Map<String, String> _getSheetRels(String sheetPath, String relType, Map bookJson) {
        String[] strings = sheetPath.split("/");
        Map rels = (Map)XlsxJsonHelper.$(bookJson, "xl/worksheets/_rels/" + strings[strings.length - 1] + ".rels");
        Map sheetRels = null;
        if (rels != null) {
            Map relMap;
            Object relations = XlsxJsonHelper.$(rels, "Relationships", "Relationship");
            if (relations instanceof List) {
                sheetRels = ((List)relations).stream().filter(r -> relType.equals(r.get("Type"))).collect(Collectors.toMap(r -> (String)r.get("Id"), r -> (String)r.get("Target")));
            } else if (relations instanceof Map && relType.equals((relMap = (Map)relations).get("Type"))) {
                sheetRels = Converter.asMap(relMap.get("Id"), relMap.get("Target"));
            }
        }
        return sheetRels;
    }

    private static String _getPath(String path, String relatePath) {
        if (path.startsWith("../")) {
            return relatePath + path.substring(2);
        }
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }

    public static XlsxWorkbookExtractor getWorkbook(Map jsonMap) {
        return new XlsxWorkbookExtractor(jsonMap);
    }

    public static class XlsxWorkbookExtractor {
        private final Map jsonMap;
        private static String _DEFAULT_CONTENT_TYPE = "[Content_Types].xml";
        private Map<String, Object> _filePaths;
        private static Map<String, String> _CONTENT_TYPE_MAPPING = Converter.asMap("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml", "workbooks", "application/vnd.ms-excel.binIndexWs", "TODO", "application/vnd.ms-excel.chartsheet", "TODO", "application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml", "TODO", "application/vnd.ms-excel.dialogsheet", "TODO", "application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml", "TODO", "application/vnd.ms-excel.macrosheet", "TODO", "application/vnd.ms-excel.macrosheet+xml", "TODO", "application/vnd.ms-excel.intlmacrosheet", "TODO", "application/vnd.ms-excel.binIndexMs", "TODO", "application/vnd.openxmlformats-package.core-properties+xml", "coreprops", "application/vnd.openxmlformats-officedocument.custom-properties+xml", "custprops", "application/vnd.openxmlformats-officedocument.extended-properties+xml", "extprops", "application/vnd.openxmlformats-officedocument.customXmlProperties+xml", "TODO", "application/vnd.ms-excel.comments", "comments", "application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml", "comments", "application/vnd.ms-excel.pivotTable", "TODO", "application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml", "TODO", "application/vnd.ms-excel.calcChain", "calcchains", "application/vnd.openxmlformats-officedocument.spreadsheetml.calcChain+xml", "calcchains", "application/vnd.openxmlformats-officedocument.spreadsheetml.printerSettings", "TODO", "application/vnd.ms-office.activeX", "TODO", "application/vnd.ms-office.activeX+xml", "TODO", "application/vnd.ms-excel.attachedToolbars", "TODO", "application/vnd.ms-excel.connections", "TODO", "application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml", "TODO", "application/vnd.ms-excel.externalLink", "externalReferences", "application/vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml", "externalReferences", "application/vnd.ms-excel.sheetMetadata", "TODO", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheetMetadata+xml", "TODO", "application/vnd.ms-excel.pivotCacheDefinition", "TODO", "application/vnd.ms-excel.pivotCacheRecords", "TODO", "application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml", "TODO", "application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheRecords+xml", "TODO", "application/vnd.ms-excel.queryTable", "TODO", "application/vnd.openxmlformats-officedocument.spreadsheetml.queryTable+xml", "TODO", "application/vnd.ms-excel.userNames", "TODO", "application/vnd.ms-excel.revisionHeaders", "TODO", "application/vnd.ms-excel.revisionLog", "TODO", "application/vnd.openxmlformats-officedocument.spreadsheetml.revisionHeaders+xml", "TODO", "application/vnd.openxmlformats-officedocument.spreadsheetml.revisionLog+xml", "TODO", "application/vnd.openxmlformats-officedocument.spreadsheetml.userNames+xml", "TODO", "application/vnd.ms-excel.tableSingleCells", "TODO", "application/vnd.openxmlformats-officedocument.spreadsheetml.tableSingleCells+xml", "TODO", "application/vnd.ms-excel.slicer", "TODO", "application/vnd.ms-excel.slicerCache", "TODO", "application/vnd.ms-excel.slicer+xml", "TODO", "application/vnd.ms-excel.slicerCache+xml", "TODO", "application/vnd.ms-excel.wsSortMap", "TODO", "application/vnd.ms-excel.table", "TODO", "application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml", "tables", "application/vnd.openxmlformats-officedocument.theme+xml", "themes", "application/vnd.ms-excel.Timeline+xml", "TODO", "application/vnd.ms-excel.TimelineCache+xml", "TODO", "application/vnd.ms-office.vbaProject", "vba", "application/vnd.ms-office.vbaProjectSignature", "vba", "application/vnd.ms-office.volatileDependencies", "TODO", "application/vnd.openxmlformats-officedocument.spreadsheetml.volatileDependencies+xml", "TODO", "application/vnd.ms-excel.controlproperties+xml", "TODO", "application/vnd.openxmlformats-officedocument.model+data", "TODO", "application/vnd.ms-excel.Survey+xml", "TODO", "application/vnd.openxmlformats-officedocument.drawing+xml", "TODO", "application/vnd.openxmlformats-officedocument.drawingml.chart+xml", "TODO", "application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml", "TODO", "application/vnd.openxmlformats-officedocument.drawingml.diagramColors+xml", "TODO", "application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml", "TODO", "application/vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml", "TODO", "application/vnd.openxmlformats-officedocument.drawingml.diagramStyle+xml", "TODO", "application/vnd.openxmlformats-officedocument.vmlDrawing", "TODO", "application/vnd.openxmlformats-package.relationships+xml", "rels", "application/vnd.openxmlformats-officedocument.oleObject", "TODO", "sheet", "js", "application/vnd.ms-excel.sheet.macroEnabled.main+xml", "workbooks", "application/vnd.ms-excel.sheet.binary.macroEnabled.main", "workbooks", "application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml", "workbooks", "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml", "strs", "application/vnd.ms-excel.sharedStrings", "strs", "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml", "sheets", "application/vnd.ms-excel.worksheet", "sheets", "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml", "styles", "application/vnd.ms-excel.styles", "styles");
        Map _workbookJson;

        public XlsxWorkbookExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
            this._filePaths = new HashMap<String, Object>();
            ((List)XlsxJsonHelper.$(this.jsonMap, _DEFAULT_CONTENT_TYPE, "Types", "Override")).forEach(k -> {
                String key = _CONTENT_TYPE_MAPPING.get(k.get("ContentType"));
                Object value = this._filePaths.get(key);
                if (value instanceof List) {
                    ((List)value).add(((String)k.get("PartName")).substring(1));
                } else if (value != null) {
                    List<Object> val = Converter.asList(value);
                    this._filePaths.put(key, val);
                    val.add(((String)k.get("PartName")).substring(1));
                } else {
                    this._filePaths.put(key, ((String)k.get("PartName")).substring(1));
                }
            });
        }

        private Map getWorkbookJson() {
            if (this._workbookJson == null) {
                this._workbookJson = (Map)XlsxJsonHelper.$(this.jsonMap, (String)XlsxJsonHelper.$(this._filePaths, "workbooks"), "workbook");
            }
            return this._workbookJson;
        }

        public XlsxStyleSheetExtractor getStyleSheet() {
            return new XlsxStyleSheetExtractor((Map)XlsxJsonHelper.$(this.jsonMap, (String)XlsxJsonHelper.$(this._filePaths, "styles"), "styleSheet"));
        }

        public XlsxThemesExtractor getThemes() {
            String filePath = (String)XlsxJsonHelper.$(this._filePaths, "themes");
            if (filePath != null) {
                return new XlsxThemesExtractor("Win10", (Map)XlsxJsonHelper.$(this.jsonMap, filePath, "a:theme"));
            }
            return null;
        }

        public Map getSst() {
            Map r = (Map)XlsxJsonHelper.$1(this.jsonMap, (String)XlsxJsonHelper.$(this._filePaths, "strs"));
            if (r != null) {
                return (Map)XlsxJsonHelper.$(r, "sst");
            }
            return Collections.EMPTY_MAP;
        }

        public Map getMcAlternateContent() {
            return (Map)XlsxJsonHelper.$(this.getWorkbookJson(), "mc:AlternateContent");
        }

        public Map getXrRevisionPtr() {
            return (Map)XlsxJsonHelper.$(this.getWorkbookJson(), "xr:revisionPtr");
        }

        public List<XlsxExternalLinkExtractor> getExternalReferences() {
            Map workbookJson = this.getWorkbookJson();
            Map extRefsJson = (Map)workbookJson.get("externalReferences");
            if (extRefsJson == null) {
                return Collections.EMPTY_LIST;
            }
            Object extRefs = extRefsJson.get("externalReference");
            if (extRefs == null) {
                return Collections.EMPTY_LIST;
            }
            List<Map> extRefsList = null;
            if (extRefs instanceof Map) {
                extRefsList = Converter.asList((Map)extRefs);
            }
            if (extRefsList == null || extRefsList.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            List workbookRels = (List)XlsxJsonHelper.$(this.jsonMap, "xl/_rels/workbook.xml.rels", "Relationships", "Relationship");
            LinkedHashMap idMap = new LinkedHashMap();
            workbookRels.forEach(rel -> idMap.put(rel.get("Id"), rel.get("Target")));
            ArrayList<Map> result = new ArrayList<Map>();
            Object externalReferences = this._filePaths.get("externalReferences");
            if (externalReferences instanceof List) {
                LinkedHashMap resultMap = new LinkedHashMap();
                ((List)externalReferences).forEach(extRefPath -> {
                    Object extLink = XlsxJsonHelper.$(this.jsonMap, extRefPath);
                    String extRefPath0 = extRefPath.substring(3);
                    resultMap.put(extRefPath0, extLink);
                });
                extRefsList.forEach(extRef -> {
                    String extRefPath = (String)XlsxJsonHelper.$1(idMap, (String)XlsxJsonHelper.$(extRef, "r:id"));
                    String extRefPath0 = extRefPath.replaceFirst("^/?xl/", "");
                    Map extLink = (Map)XlsxJsonHelper.$1(resultMap, extRefPath0);
                    if (extLink != null) {
                        extLink.putAll(extRef);
                        result.add(extLink);
                    } else {
                        result.add((Map)extRef);
                    }
                });
            } else {
                String extRefPath2 = (String)XlsxJsonHelper.$(this._filePaths, "externalReferences");
                Map extLink2 = (Map)XlsxJsonHelper.$(this.jsonMap, extRefPath2);
                Map extRef2 = extRefsList.get(0);
                if (extLink2 != null) {
                    extLink2.putAll(extRef2);
                    result.add(extLink2);
                } else {
                    result.add(extRef2);
                }
            }
            return result.stream().map(extLink -> extLink.get("externalLink") != null ? new XlsxExternalLinkExtractor(this.jsonMap, (Map)extLink) : null).filter(d -> d != null).collect(Collectors.toList());
        }

        public XlsxWorkbookProtectionExtractor getWorkbookProtection() {
            Map sheetProtection = (Map)XlsxJsonHelper.$(this.getWorkbookJson(), "workbookProtection");
            if (sheetProtection != null) {
                return new XlsxWorkbookProtectionExtractor(sheetProtection);
            }
            return null;
        }

        public List<XlsxSheetExtractor> getSheets() {
            List workbookRels = (List)XlsxJsonHelper.$(this.jsonMap, "xl/_rels/workbook.xml.rels", "Relationships", "Relationship");
            Map workbook = this.getWorkbookJson();
            Map sharedStrings = this.getSst();
            LinkedHashMap idMap = new LinkedHashMap();
            workbookRels.forEach(rel -> idMap.put((String)XlsxJsonHelper.$(rel, "Id"), (String)XlsxJsonHelper.$(rel, "Target")));
            Object sheets = XlsxJsonHelper.$(workbook, "sheets", "sheet");
            List<Map> sheetsList = null;
            if (sheets instanceof Map) {
                sheetsList = Converter.asList((Map)sheets);
            } else if (sheets instanceof List) {
                sheetsList = (List<Map>)sheets;
            } else {
                throw new IllegalStateException("Sheets cannot be empty!");
            }
            ArrayList<Map> result = new ArrayList<Map>();
            Object sheetsData = this._filePaths.get("sheets");
            if (sheetsData instanceof List) {
                LinkedHashMap resultMap = new LinkedHashMap();
                ((List)sheetsData).forEach(sheetPath -> {
                    Map ws = (Map)this.jsonMap.get(sheetPath);
                    String sheetPath0 = sheetPath.substring(3);
                    resultMap.put(sheetPath0, ws);
                });
                sheetsList.forEach(sheet -> {
                    String sheetPath = (String)idMap.get(sheet.get("r:id"));
                    String sheetPath0 = sheetPath.replaceFirst("^/?xl/", "");
                    Map ws = (Map)XlsxJsonHelper.$(resultMap, sheetPath0);
                    if (ws != null) {
                        ws.putAll(sheet);
                        result.add(ws);
                    } else {
                        result.add((Map)sheet);
                    }
                });
            } else {
                String sheetPath2 = (String)sheetsData;
                Map ws = (Map)this.jsonMap.get(sheetPath2);
                Map sheet2 = sheetsList.get(0);
                if (ws != null) {
                    ws.putAll(sheet2);
                    result.add(ws);
                } else {
                    result.add(sheet2);
                }
            }
            return result.stream().map(d -> new XlsxSheetExtractor(this.jsonMap, (Map)d, sharedStrings, new HashMap())).collect(Collectors.toList());
        }

        public List<XlsxDefinedNameExtractor> getDefinedNames() {
            return XlsxJsonHelper.toList((Map)XlsxJsonHelper.$(this._workbookJson, "definedNames"), "definedName", XlsxDefinedNameExtractor.class);
        }
    }

    public static class XlsxXmlColumnPrExtractor {
        private final Map jsonMap;

        public XlsxXmlColumnPrExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public boolean isDenormalized() {
            return XlsxJsonHelper.toBool(this.jsonMap, "denormalized");
        }

        public Number getMapId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "mapId");
        }

        public String getXmlDataType() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "xmlDataType");
        }

        public String getXpath() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "xpath");
        }
    }

    public static class XlsxTableFormulaExtractor {
        private final Map jsonMap;

        public XlsxTableFormulaExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public boolean isArray() {
            return XlsxJsonHelper.toBool(this.jsonMap, "array");
        }

        public String getExpression() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "_");
        }
    }

    public static class XlsxTableColumnExtractor {
        private final Map jsonMap;

        public XlsxTableColumnExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public XlsxTableFormulaExtractor getCalculatedColumnFormula() {
            return null;
        }

        public String getDataCellStyle() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "dataCellStyle");
        }

        public Number getDataDxfId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "dataDxfId");
        }

        public String getHeaderRowCellStyle() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "headerRowCellStyle");
        }

        public Number getHeaderRowDxfId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "headerRowDxfId");
        }

        public Number getId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "id");
        }

        public String getName() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "name");
        }

        public Number getQueryTableFieldId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "queryTableFieldId");
        }

        public String getTotalsRowCellStyle() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "totalsRowCellStyle");
        }

        public Number getTotalsRowDxfId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "totalsRowDxfId");
        }

        public XlsxTableFormulaExtractor getTotalsRowFormula() {
            return this.jsonMap.containsKey("totalsRowFormula") ? new XlsxTableFormulaExtractor((Map)this.jsonMap.get("totalsRowFormula")) : null;
        }

        public STableColumn.STotalsRowFunction getTotalsRowFunction() {
            String rfun;
            switch (rfun = XlsxJsonHelper.toStringValue(this.jsonMap, "totalsRowFunction", "none")) {
                case "none": {
                    return STableColumn.STotalsRowFunction.none;
                }
                case "sum": {
                    return STableColumn.STotalsRowFunction.sum;
                }
                case "min": {
                    return STableColumn.STotalsRowFunction.min;
                }
                case "max": {
                    return STableColumn.STotalsRowFunction.max;
                }
                case "average": {
                    return STableColumn.STotalsRowFunction.average;
                }
                case "count": {
                    return STableColumn.STotalsRowFunction.count;
                }
                case "countNums": {
                    return STableColumn.STotalsRowFunction.countNums;
                }
                case "stdDev": {
                    return STableColumn.STotalsRowFunction.stdDev;
                }
                case "var": {
                    return STableColumn.STotalsRowFunction.var;
                }
                case "custom": {
                    return STableColumn.STotalsRowFunction.custom;
                }
            }
            return null;
        }

        public String getTotalsRowLabel() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "totalsRowLabel");
        }

        public String getUniqueName() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "uniqueName");
        }

        public XlsxXmlColumnPrExtractor getXmlColumnPr() {
            return this.jsonMap.containsKey("xmlColumnPr") ? new XlsxXmlColumnPrExtractor((Map)this.jsonMap.get("xmlColumnPr")) : null;
        }
    }

    public static class XlsxTableStyleInfoExtractor {
        private final Map jsonMap;

        public XlsxTableStyleInfoExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public String getName() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "name");
        }

        public boolean isShowColumnStripes() {
            return XlsxJsonHelper.toBool(this.jsonMap, "showColumnStripes", false);
        }

        public boolean isShowFirstColumn() {
            return XlsxJsonHelper.toBool(this.jsonMap, "showFirstColumn", false);
        }

        public boolean isShowLastColumn() {
            return XlsxJsonHelper.toBool(this.jsonMap, "showLastColumn", false);
        }

        public boolean isShowRowStripes() {
            return XlsxJsonHelper.toBool(this.jsonMap, "showRowStripes", false);
        }
    }

    public static class XlsxTableExtractor {
        private final Map jsonMap;
        private final Map _queryTable;

        public XlsxTableExtractor(Map jsonMap, Map queryTable) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
            this._queryTable = queryTable;
        }

        public XlsxAutoFilterExtractor getAutoFilter() {
            if (this.jsonMap.containsKey("autoFilter")) {
                return new XlsxAutoFilterExtractor((Map)this.jsonMap.get("autoFilter"));
            }
            return null;
        }

        public String getComment() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "comment");
        }

        public Number getConnectionId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "connectionId");
        }

        public String getDataCellStyle() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "dataCellStyle");
        }

        public Number getDataDxfId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "dataDxfId");
        }

        public String getDisplayName() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "displayName");
        }

        public Number getHeaderRowBorderDxfId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "headerRowBorderDxfId");
        }

        public String getHeaderRowCellStyle() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "headerRowCellStyle");
        }

        public int getHeaderRowCount() {
            return XlsxJsonHelper.toInt(this.jsonMap, "headerRowCount", 1);
        }

        public Number getHeaderRowDxfId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "headerRowDxfId");
        }

        public Number getId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "id");
        }

        public boolean isInsertRow() {
            return XlsxJsonHelper.toBool(this.jsonMap, "insertRow");
        }

        public boolean isInsertRowShift() {
            return XlsxJsonHelper.toBool(this.jsonMap, "insertRowShift");
        }

        public String getName() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "name");
        }

        public boolean isPublished() {
            return XlsxJsonHelper.toBool(this.jsonMap, "published");
        }

        public String getRef() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "ref");
        }

        public XlsxSortStateExtractor getSortState() {
            return this.jsonMap.containsKey("sortState") ? new XlsxSortStateExtractor((Map)this.jsonMap.get("sortState")) : null;
        }

        public Number getTableBorderDxfId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "tableBorderDxfId");
        }

        public List<XlsxTableColumnExtractor> getTableColumns() {
            return XlsxJsonHelper.toList((Map)XlsxJsonHelper.$(this.jsonMap, "tableColumns"), "tableColumn", XlsxTableColumnExtractor.class);
        }

        public XlsxTableStyleInfoExtractor getTableStyleInfo() {
            return this.jsonMap.containsKey("tableStyleInfo") ? new XlsxTableStyleInfoExtractor((Map)this.jsonMap.get("tableStyleInfo")) : null;
        }

        public String getTableType() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "tableType");
        }

        public Number getTotalsRowBorderDxfId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "totalsRowBorderDxfId");
        }

        public String getTotalsRowCellStyle() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "totalsRowCellStyle");
        }

        public int getTotalsRowCount() {
            return XlsxJsonHelper.toInt(this.jsonMap, "totalsRowCount", 0);
        }

        public Number getTotalsRowDxfId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "totalsRowDxfId");
        }

        public boolean isTotalsRowShown() {
            return XlsxJsonHelper.toBool(this.jsonMap, "totalsRowShown", true);
        }

        public Map getQueryTable() {
            return this._queryTable;
        }
    }

    public static class XlsxPrintOptionsExtractor {
        private final Map jsonMap;

        public XlsxPrintOptionsExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public boolean isGridLines() {
            return XlsxJsonHelper.toBool(this.jsonMap, "gridLines", false);
        }

        public boolean isGridLinesSet() {
            return XlsxJsonHelper.toBool(this.jsonMap, "gridLinesSet", false);
        }

        public boolean isHeadings() {
            return XlsxJsonHelper.toBool(this.jsonMap, "headings", false);
        }

        public boolean isHorizontalCentered() {
            return XlsxJsonHelper.toBool(this.jsonMap, "horizontalCentered", false);
        }

        public boolean isVerticalCentered() {
            return XlsxJsonHelper.toBool(this.jsonMap, "verticalCentered", false);
        }

        public boolean isNotEmpty() {
            return this.jsonMap != null && !this.jsonMap.isEmpty();
        }
    }

    public static class XlsxPageMarginsExtractor {
        private final Map jsonMap;

        public XlsxPageMarginsExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public double getBottom() {
            return XlsxJsonHelper.toDouble(this.jsonMap, "bottom", 0.0);
        }

        public double getFooter() {
            return XlsxJsonHelper.toDouble(this.jsonMap, "footer", 0.0);
        }

        public double getHeader() {
            return XlsxJsonHelper.toDouble(this.jsonMap, "header", 0.0);
        }

        public double getLeft() {
            return XlsxJsonHelper.toDouble(this.jsonMap, "left", 0.0);
        }

        public double getRight() {
            return XlsxJsonHelper.toDouble(this.jsonMap, "right", 0.0);
        }

        public double getTop() {
            return XlsxJsonHelper.toDouble(this.jsonMap, "top", 0.0);
        }
    }

    public static class XlsxPageSetupExtractor {
        private final Map jsonMap;
        public static final short LETTER_PAPERSIZE = 1;
        public static final short LETTER_SMALL_PAGESIZE = 2;
        public static final short TABLOID_PAPERSIZE = 3;
        public static final short LEDGER_PAPERSIZE = 4;
        public static final short LEGAL_PAPERSIZE = 5;
        public static final short STATEMENT_PAPERSIZE = 6;
        public static final short EXECUTIVE_PAPERSIZE = 7;
        public static final short A3_PAPERSIZE = 8;
        public static final short A4_PAPERSIZE = 9;
        public static final short A4_SMALL_PAPERSIZE = 10;
        public static final short A5_PAPERSIZE = 11;
        public static final short B4_PAPERSIZE = 12;
        public static final short B5_PAPERSIZE = 13;
        public static final short FOLIO8_PAPERSIZE = 14;
        public static final short QUARTO_PAPERSIZE = 15;
        public static final short TEN_BY_FOURTEEN_PAPERSIZE = 16;
        public static final short ELEVEN_BY_SEVENTEEN_PAPERSIZE = 17;
        public static final short NOTE8_PAPERSIZE = 18;
        public static final short ENVELOPE_9_PAPERSIZE = 19;
        public static final short ENVELOPE_10_PAPERSIZE = 20;
        public static final short ENVELOPE_DL_PAPERSIZE = 27;
        public static final short ENVELOPE_CS_PAPERSIZE = 28;
        public static final short ENVELOPE_C5_PAPERSIZE = 28;
        public static final short ENVELOPE_C3_PAPERSIZE = 29;
        public static final short ENVELOPE_C4_PAPERSIZE = 30;
        public static final short ENVELOPE_C6_PAPERSIZE = 31;
        public static final short ENVELOPE_MONARCH_PAPERSIZE = 37;
        public static final short A4_EXTRA_PAPERSIZE = 53;
        public static final short A4_TRANSVERSE_PAPERSIZE = 55;
        public static final short A4_PLUS_PAPERSIZE = 60;
        public static final short LETTER_ROTATED_PAPERSIZE = 75;
        public static final short A4_ROTATED_PAPERSIZE = 77;

        public XlsxPageSetupExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public boolean isBlackAndWhite() {
            return XlsxJsonHelper.toBool(this.jsonMap, "blackAndWhite");
        }

        public int getCellComments() {
            switch (XlsxJsonHelper.toStringValue(this.jsonMap, "cellComments", "none")) {
                case "none": {
                    return 0;
                }
                case "asDisplayed": {
                    return 1;
                }
                case "atEnd": {
                    return 2;
                }
            }
            return 0;
        }

        public Number getCopies() {
            return XlsxJsonHelper.toNum(this.jsonMap, "copies");
        }

        public boolean isDraft() {
            return XlsxJsonHelper.toBool(this.jsonMap, "draft");
        }

        public int getErrors() {
            String errors;
            switch (errors = XlsxJsonHelper.toStringValue(this.jsonMap, "errors", "displayed")) {
                case "blank": {
                    return 1;
                }
                case "dash": {
                    return 2;
                }
                case "NA": {
                    return 3;
                }
            }
            return 0;
        }

        public int getFirstPageNumber() {
            return XlsxJsonHelper.toInt(this.jsonMap, "firstPageNumber", 0);
        }

        public int getFitToHeight() {
            return XlsxJsonHelper.toInt(this.jsonMap, "fitToHeight", 0);
        }

        public int getFitToWidth() {
            return XlsxJsonHelper.toInt(this.jsonMap, "fitToWidth", 0);
        }

        public int getHorizontalDpi() {
            return XlsxJsonHelper.toInt(this.jsonMap, "horizontalDpi", 0);
        }

        public String getOrientation() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "orientation");
        }

        public String getPageOrder() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "pageOrder");
        }

        public SPrintSetup.PaperSize getPaperSize() {
            int paperSize = XlsxJsonHelper.toInt(this.jsonMap, "paperSize", 9);
            switch (paperSize) {
                case 8: {
                    return SPrintSetup.PaperSize.A3;
                }
                case 53: {
                    return SPrintSetup.PaperSize.A4_EXTRA;
                }
                case 9: {
                    return SPrintSetup.PaperSize.A4;
                }
                case 60: {
                    return SPrintSetup.PaperSize.A4_PLUS;
                }
                case 77: {
                    return SPrintSetup.PaperSize.A4_ROTATED;
                }
                case 10: {
                    return SPrintSetup.PaperSize.A4_SMALL;
                }
                case 55: {
                    return SPrintSetup.PaperSize.A4_TRANSVERSE;
                }
                case 11: {
                    return SPrintSetup.PaperSize.A5;
                }
                case 12: {
                    return SPrintSetup.PaperSize.B4;
                }
                case 13: {
                    return SPrintSetup.PaperSize.B5;
                }
                case 17: {
                    return SPrintSetup.PaperSize.ELEVEN_BY_SEVENTEEN;
                }
                case 20: {
                    return SPrintSetup.PaperSize.ENVELOPE_10;
                }
                case 19: {
                    return SPrintSetup.PaperSize.ENVELOPE_9;
                }
                case 29: {
                    return SPrintSetup.PaperSize.ENVELOPE_C3;
                }
                case 30: {
                    return SPrintSetup.PaperSize.ENVELOPE_C4;
                }
                case 28: {
                    return SPrintSetup.PaperSize.ENVELOPE_C5;
                }
                case 31: {
                    return SPrintSetup.PaperSize.ENVELOPE_C6;
                }
                case 27: {
                    return SPrintSetup.PaperSize.ENVELOPE_DL;
                }
                case 37: {
                    return SPrintSetup.PaperSize.ENVELOPE_MONARCH;
                }
                case 7: {
                    return SPrintSetup.PaperSize.EXECUTIVE;
                }
                case 14: {
                    return SPrintSetup.PaperSize.FOLIO8;
                }
                case 4: {
                    return SPrintSetup.PaperSize.LEDGER;
                }
                case 1: {
                    return SPrintSetup.PaperSize.LETTER;
                }
                case 75: {
                    return SPrintSetup.PaperSize.LETTER_ROTATED;
                }
                case 2: {
                    return SPrintSetup.PaperSize.LETTER_SMALL;
                }
                case 18: {
                    return SPrintSetup.PaperSize.NOTE8;
                }
                case 15: {
                    return SPrintSetup.PaperSize.QUARTO;
                }
                case 6: {
                    return SPrintSetup.PaperSize.STATEMENT;
                }
                case 3: {
                    return SPrintSetup.PaperSize.TABLOID;
                }
                case 16: {
                    return SPrintSetup.PaperSize.TEN_BY_FOURTEEN;
                }
            }
            return SPrintSetup.PaperSize.A4;
        }

        public int getScale() {
            return XlsxJsonHelper.toInt(this.jsonMap, "scale", 0);
        }

        public boolean isUseFirstPageNumber() {
            return XlsxJsonHelper.toBool(this.jsonMap, "useFirstPageNumber", false);
        }

        public boolean isUsePrinterDefaults() {
            return XlsxJsonHelper.toBool(this.jsonMap, "usePrinterDefaults", false);
        }

        public Number getVerticalDpi() {
            return XlsxJsonHelper.toNum(this.jsonMap, "verticalDpi");
        }
    }

    public static class XlsxHeaderFootersExtractor {
        private final Map jsonMap;

        public XlsxHeaderFootersExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public boolean isAlignWithMargins() {
            return XlsxJsonHelper.toBool(this.jsonMap, "alignWithMargins", false);
        }

        public boolean isDifferentFirst() {
            return XlsxJsonHelper.toBool(this.jsonMap, "differentFirst", false);
        }

        public boolean isDifferentOddEven() {
            return XlsxJsonHelper.toBool(this.jsonMap, "differentOddEven", false);
        }

        public String getEvenFooter() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "evenFooter");
        }

        public String getEvenHeader() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "evenHeader");
        }

        public String getFirstFooter() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "firstFooter");
        }

        public String getFirstHeader() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "firstHeader");
        }

        public String getOddFooter() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "oddFooter");
        }

        public String getOddHeader() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "oddHeader");
        }

        public boolean isScaleWithDoc() {
            return XlsxJsonHelper.toBool(this.jsonMap, "scaleWithDoc", false);
        }
    }

    public static class XlsxIconSetExtractor {
        protected final Map jsonMap;

        public XlsxIconSetExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public SIconSet.IconSetType getIconSet() {
            String iconSet;
            switch (iconSet = XlsxJsonHelper.toStringValue(this.jsonMap, "iconSet", "3TrafficLights1")) {
                case "3Arrows": {
                    return SIconSet.IconSetType.X_3_ARROWS;
                }
                case "3ArrowsGray": {
                    return SIconSet.IconSetType.X_3_ARROWS_GRAY;
                }
                case "3Flags": {
                    return SIconSet.IconSetType.X_3_FLAGS;
                }
                case "3TrafficLights1": {
                    return SIconSet.IconSetType.X_3_TRAFFIC_LIGHTS_1;
                }
                case "3TrafficLights2": {
                    return SIconSet.IconSetType.X_3_TRAFFIC_LIGHTS_2;
                }
                case "3Signs": {
                    return SIconSet.IconSetType.X_3_SIGNS;
                }
                case "3Symbols": {
                    return SIconSet.IconSetType.X_3_SYMBOLS;
                }
                case "3Symbols2": {
                    return SIconSet.IconSetType.X_3_SYMBOLS_2;
                }
                case "4Arrows": {
                    return SIconSet.IconSetType.X_4_ARROWS;
                }
                case "4ArrowsGray": {
                    return SIconSet.IconSetType.X_4_ARROWS_GRAY;
                }
                case "4RedToBlack": {
                    return SIconSet.IconSetType.X_4_RED_TO_BLACK;
                }
                case "4Rating": {
                    return SIconSet.IconSetType.X_4_RATING;
                }
                case "4TrafficLights": {
                    return SIconSet.IconSetType.X_4_TRAFFIC_LIGHTS;
                }
                case "5Arrows": {
                    return SIconSet.IconSetType.X_5_ARROWS;
                }
                case "5ArrowsGray": {
                    return SIconSet.IconSetType.X_5_ARROWS_GRAY;
                }
                case "5Rating": {
                    return SIconSet.IconSetType.X_5_RATING;
                }
                case "5Quarters": {
                    return SIconSet.IconSetType.X_5_QUARTERS;
                }
            }
            return null;
        }

        public boolean isSetPercent() {
            return this.jsonMap.containsKey("percent");
        }

        public boolean isPercent() {
            return XlsxJsonHelper.toBool(this.jsonMap, "percent", false);
        }

        public boolean isSetReverse() {
            return this.jsonMap.containsKey("reverse");
        }

        public boolean isReverse() {
            return XlsxJsonHelper.toBool(this.jsonMap, "reverse", false);
        }

        public boolean isSetShowValue() {
            return this.jsonMap.containsKey("showValue");
        }

        public boolean isShowValue() {
            return XlsxJsonHelper.toBool(this.jsonMap, "showValue", false);
        }

        public List<XlsxCfvoExtractor> getCfvos() {
            return XlsxJsonHelper.toList(this.jsonMap, "cfvo", XlsxCfvoExtractor.class);
        }

        public List<XlsxCfIconExtractor> getCfIcons() {
            return null;
        }
    }

    public static class XlsxCfIconExtractor {
        protected final Map jsonMap;

        public XlsxCfIconExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public Integer getIconId() {
            return XlsxJsonHelper.toInt(this.jsonMap, "iconId");
        }

        public SIconSet.IconSetType getIconSet() {
            String iconSet;
            switch (iconSet = XlsxJsonHelper.toStringValue(this.jsonMap, "iconSet", "NoIcons")) {
                case "3Arrows": {
                    return SIconSet.IconSetType.X_3_ARROWS;
                }
                case "3ArrowsGray": {
                    return SIconSet.IconSetType.X_3_ARROWS_GRAY;
                }
                case "3Flags": {
                    return SIconSet.IconSetType.X_3_FLAGS;
                }
                case "3TrafficLights1": {
                    return SIconSet.IconSetType.X_3_TRAFFIC_LIGHTS_1;
                }
                case "3TrafficLights2": {
                    return SIconSet.IconSetType.X_3_TRAFFIC_LIGHTS_2;
                }
                case "3Signs": {
                    return SIconSet.IconSetType.X_3_SIGNS;
                }
                case "3Symbols": {
                    return SIconSet.IconSetType.X_3_SYMBOLS;
                }
                case "3Symbols2": {
                    return SIconSet.IconSetType.X_3_SYMBOLS_2;
                }
                case "4Arrows": {
                    return SIconSet.IconSetType.X_4_ARROWS;
                }
                case "4ArrowsGray": {
                    return SIconSet.IconSetType.X_4_ARROWS_GRAY;
                }
                case "4RedToBlack": {
                    return SIconSet.IconSetType.X_4_RED_TO_BLACK;
                }
                case "4Rating": {
                    return SIconSet.IconSetType.X_4_RATING;
                }
                case "4TrafficLights": {
                    return SIconSet.IconSetType.X_4_TRAFFIC_LIGHTS;
                }
                case "5Arrows": {
                    return SIconSet.IconSetType.X_5_ARROWS;
                }
                case "5ArrowsGray": {
                    return SIconSet.IconSetType.X_5_ARROWS_GRAY;
                }
                case "5Rating": {
                    return SIconSet.IconSetType.X_5_RATING;
                }
                case "5Quarters": {
                    return SIconSet.IconSetType.X_5_QUARTERS;
                }
            }
            return null;
        }
    }

    public static class XlsxExtIconSetExtractor
    extends XlsxIconSetExtractor {
        public XlsxExtIconSetExtractor(Map jsonMap) {
            super(jsonMap);
        }

        @Override
        public List<XlsxCfvoExtractor> getCfvos() {
            return XlsxJsonHelper.toList(this.jsonMap, "x14:cfvo", XlsxExtCfvoExtractor.class);
        }

        @Override
        public List<XlsxCfIconExtractor> getCfIcons() {
            return XlsxJsonHelper.toList(this.jsonMap, "x14:cfIcon", XlsxCfIconExtractor.class);
        }
    }

    public static class XlsxDataBarExtractor {
        protected final Map jsonMap;

        public XlsxDataBarExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public int getMinLength() {
            return XlsxJsonHelper.toInt(this.jsonMap, "minLength");
        }

        public boolean isSetMinLength() {
            return this.jsonMap.containsKey("minLength");
        }

        public int getMaxLength() {
            return XlsxJsonHelper.toInt(this.jsonMap, "maxLength");
        }

        public boolean isSetMaxLength() {
            return this.jsonMap.containsKey("maxLength");
        }

        public boolean isSetShowValue() {
            return this.jsonMap.containsKey("showValue");
        }

        public boolean isShowValue() {
            return XlsxJsonHelper.toBool(this.jsonMap, "showValue", false);
        }

        public List<XlsxCfvoExtractor> getCfvos() {
            return XlsxJsonHelper.toList(this.jsonMap, "cfvo", XlsxCfvoExtractor.class);
        }

        public XlsxColorExtractor getColor() {
            return this.jsonMap.containsKey("color") ? new XlsxColorExtractor((Map)this.jsonMap.get("color")) : null;
        }
    }

    public static class XlsxExtDataBarExtractor
    extends XlsxDataBarExtractor {
        public XlsxExtDataBarExtractor(Map jsonMap) {
            super(jsonMap);
        }

        @Override
        public List<XlsxCfvoExtractor> getCfvos() {
            return XlsxJsonHelper.toList(this.jsonMap, "x14:cfvo", XlsxExtCfvoExtractor.class);
        }

        public XlsxColorExtractor getBorderColor() {
            return this.jsonMap.containsKey("x14:borderColor") ? new XlsxColorExtractor((Map)this.jsonMap.get("x14:borderColor")) : null;
        }

        public XlsxColorExtractor getNegativeBorderColor() {
            return this.jsonMap.containsKey("x14:negativeBorderColor") ? new XlsxColorExtractor((Map)this.jsonMap.get("x14:negativeBorderColor")) : null;
        }

        public XlsxColorExtractor getNegativeFillColor() {
            return this.jsonMap.containsKey("x14:negativeFillColor") ? new XlsxColorExtractor((Map)this.jsonMap.get("x14:negativeFillColor")) : null;
        }

        public XlsxColorExtractor getAxisColor() {
            return this.jsonMap.containsKey("x14:axisColor") ? new XlsxColorExtractor((Map)this.jsonMap.get("x14:axisColor")) : null;
        }

        public boolean isBorder() {
            return XlsxJsonHelper.toBool(this.jsonMap, "border", false);
        }

        public boolean isGradient() {
            return XlsxJsonHelper.toBool(this.jsonMap, "gradient", true);
        }

        public boolean isNegativeBarColorSameAsPositive() {
            return XlsxJsonHelper.toBool(this.jsonMap, "negativeBarColorSameAsPositive", true);
        }

        public boolean isNegativeBarBorderColorSameAsPositive() {
            return XlsxJsonHelper.toBool(this.jsonMap, "negativeBarBorderColorSameAsPositive", true);
        }

        public String getAxisPosition() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "axisPosition", "auto");
        }

        public String getDirection() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "direction", "leftToRight");
        }
    }

    public static class XlsxCfvoExtractor {
        protected final Map jsonMap;

        public XlsxCfvoExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public SCFValueObject.CFValueObjectType getType() {
            String type;
            switch (type = XlsxJsonHelper.toStringValue(this.jsonMap, "type")) {
                case "num": {
                    return SCFValueObject.CFValueObjectType.NUM;
                }
                case "percent": {
                    return SCFValueObject.CFValueObjectType.PERCENT;
                }
                case "max": {
                    return SCFValueObject.CFValueObjectType.MAX;
                }
                case "min": {
                    return SCFValueObject.CFValueObjectType.MIN;
                }
                case "formula": {
                    return SCFValueObject.CFValueObjectType.FORMULA;
                }
                case "percentile": {
                    return SCFValueObject.CFValueObjectType.PERCENTILE;
                }
                case "autoMin": {
                    return SCFValueObject.CFValueObjectType.AUTOMIN;
                }
                case "autoMax": {
                    return SCFValueObject.CFValueObjectType.AUTOMAX;
                }
            }
            return null;
        }

        public String getVal() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "val");
        }

        public boolean isSetVal() {
            return this.jsonMap.containsKey("val");
        }

        public boolean isGte() {
            return XlsxJsonHelper.toBool(this.jsonMap, "gte", false);
        }

        public boolean isSetGte() {
            return this.jsonMap.containsKey("gte");
        }
    }

    public static class XlsxExtCfvoExtractor
    extends XlsxCfvoExtractor {
        public XlsxExtCfvoExtractor(Map jsonMap) {
            super(jsonMap);
        }

        @Override
        public boolean isSetVal() {
            return this.jsonMap.containsKey("xm:f");
        }

        @Override
        public String getVal() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "xm:f");
        }
    }

    public static class XlsxColorScaleExtractor {
        protected final Map jsonMap;

        public XlsxColorScaleExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public List<XlsxCfvoExtractor> getCfvos() {
            return XlsxJsonHelper.toList(this.jsonMap, "cfvo", XlsxCfvoExtractor.class);
        }

        public List<XlsxColorExtractor> getColors() {
            return XlsxJsonHelper.toList(this.jsonMap, "color", XlsxColorExtractor.class);
        }
    }

    public static class XlsxExtColorScaleExtractor
    extends XlsxColorScaleExtractor {
        public XlsxExtColorScaleExtractor(Map jsonMap) {
            super(jsonMap);
        }

        @Override
        public List<XlsxCfvoExtractor> getCfvos() {
            return XlsxJsonHelper.toList(this.jsonMap, "x14:cfvo", XlsxExtCfvoExtractor.class);
        }

        @Override
        public List<XlsxColorExtractor> getColors() {
            return XlsxJsonHelper.toList(this.jsonMap, "x14:color", XlsxColorExtractor.class);
        }
    }

    public static class XlsxCfRuleExtractor {
        protected final Map jsonMap;

        public XlsxCfRuleExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public List<String> getFormulas() {
            return this.getFormulas0("formula");
        }

        protected List<String> getFormulas0(String key) {
            Object formula = this.jsonMap.get(key);
            if (formula instanceof List) {
                return ((List)formula).stream().map(f -> XlsxJsonHelper.toStringValue(f, "_")).collect(Collectors.toList());
            }
            if (formula instanceof Map) {
                return Converter.asList(XlsxJsonHelper.toStringValue(this.jsonMap, key));
            }
            return Collections.EMPTY_LIST;
        }

        public SConditionalFormattingRule.RuleType getType() {
            String type;
            switch (type = XlsxJsonHelper.toStringValue(this.jsonMap, "type")) {
                case "expression": {
                    return SConditionalFormattingRule.RuleType.EXPRESSION;
                }
                case "cellIs": {
                    return SConditionalFormattingRule.RuleType.CELL_IS;
                }
                case "colorScale": {
                    return SConditionalFormattingRule.RuleType.COLOR_SCALE;
                }
                case "dataBar": {
                    return SConditionalFormattingRule.RuleType.DATA_BAR;
                }
                case "iconSet": {
                    return SConditionalFormattingRule.RuleType.ICON_SET;
                }
                case "top10": {
                    return SConditionalFormattingRule.RuleType.TOP_10;
                }
                case "uniqueValues": {
                    return SConditionalFormattingRule.RuleType.UNIQUE_VALUES;
                }
                case "duplicateValues": {
                    return SConditionalFormattingRule.RuleType.DUPLICATE_VALUES;
                }
                case "containsText": {
                    return SConditionalFormattingRule.RuleType.CONTAINS_TEXT;
                }
                case "notContainsText": {
                    return SConditionalFormattingRule.RuleType.NOT_CONTAINS_TEXT;
                }
                case "beginsWith": {
                    return SConditionalFormattingRule.RuleType.BEGINS_WITH;
                }
                case "endsWith": {
                    return SConditionalFormattingRule.RuleType.ENDS_WITH;
                }
                case "containsBlanks": {
                    return SConditionalFormattingRule.RuleType.CONTAINS_BLANKS;
                }
                case "notContainsBlanks": {
                    return SConditionalFormattingRule.RuleType.NOT_CONTAINS_BLANKS;
                }
                case "containsErrors": {
                    return SConditionalFormattingRule.RuleType.CONTAINS_ERRORS;
                }
                case "notContainsErrors": {
                    return SConditionalFormattingRule.RuleType.NOT_CONTAINS_ERRORS;
                }
                case "timePeriod": {
                    return SConditionalFormattingRule.RuleType.TIME_PERIOD;
                }
                case "aboveAverage": {
                    return SConditionalFormattingRule.RuleType.ABOVE_AVERAGE;
                }
            }
            return null;
        }

        public int getDxfId() {
            return XlsxJsonHelper.toInt(this.jsonMap, "dxfId");
        }

        public boolean isSetDxfId() {
            return this.jsonMap.containsKey("dxfId");
        }

        public int getPriority() {
            return XlsxJsonHelper.toInt(this.jsonMap, "priority", 0);
        }

        public boolean isStopIfTrue() {
            return XlsxJsonHelper.toBool(this.jsonMap, "stopIfTrue");
        }

        public boolean isSetStopIfTrue() {
            return this.jsonMap.containsKey("stopIfTrue");
        }

        public boolean isAboveAverage() {
            return XlsxJsonHelper.toBool(this.jsonMap, "aboveAverage", false);
        }

        public boolean isSetAboveAverage() {
            return this.jsonMap.containsKey("aboveAverage");
        }

        public boolean isPercent() {
            return XlsxJsonHelper.toBool(this.jsonMap, "percent", false);
        }

        public boolean isSetPercent() {
            return this.jsonMap.containsKey("percent");
        }

        public boolean isBottom() {
            return XlsxJsonHelper.toBool(this.jsonMap, "bottom", false);
        }

        public boolean isSetBottom() {
            return this.jsonMap.containsKey("bottom");
        }

        public SConditionalFormattingRule.RuleOperator getOperator() {
            String operator;
            switch (operator = XlsxJsonHelper.toStringValue(this.jsonMap, "operator")) {
                case "lessThan": {
                    return SConditionalFormattingRule.RuleOperator.LESS_THAN;
                }
                case "lessThanOrEqual": {
                    return SConditionalFormattingRule.RuleOperator.LESS_THAN_OR_EQUAL;
                }
                case "equal": {
                    return SConditionalFormattingRule.RuleOperator.EQUAL;
                }
                case "notEqual": {
                    return SConditionalFormattingRule.RuleOperator.NOT_EQUAL;
                }
                case "greaterThanOrEqual": {
                    return SConditionalFormattingRule.RuleOperator.GREATER_THAN_OR_EQUAL;
                }
                case "greaterThan": {
                    return SConditionalFormattingRule.RuleOperator.GREATER_THAN;
                }
                case "between": {
                    return SConditionalFormattingRule.RuleOperator.BETWEEN;
                }
                case "notBetween": {
                    return SConditionalFormattingRule.RuleOperator.NOT_BETWEEN;
                }
                case "containsText": {
                    return SConditionalFormattingRule.RuleOperator.CONTAINS_TEXT;
                }
                case "notContains": {
                    return SConditionalFormattingRule.RuleOperator.NOT_CONTAINS;
                }
                case "beginsWith": {
                    return SConditionalFormattingRule.RuleOperator.BEGINS_WITH;
                }
                case "endsWith": {
                    return SConditionalFormattingRule.RuleOperator.ENDS_WITH;
                }
            }
            return null;
        }

        public boolean isSetOperator() {
            return this.jsonMap.containsKey("operator");
        }

        public String getText() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "text");
        }

        public SConditionalFormattingRule.RuleTimePeriod getTimePeriod() {
            String timePeriod;
            switch (timePeriod = XlsxJsonHelper.toStringValue(this.jsonMap, "timePeriod")) {
                case "today": {
                    return SConditionalFormattingRule.RuleTimePeriod.TODAY;
                }
                case "yesterday": {
                    return SConditionalFormattingRule.RuleTimePeriod.YESTERDAY;
                }
                case "Tomorrow": {
                    return SConditionalFormattingRule.RuleTimePeriod.TOMORROW;
                }
                case "last7Days": {
                    return SConditionalFormattingRule.RuleTimePeriod.LAST_7_DAYS;
                }
                case "thisMonth": {
                    return SConditionalFormattingRule.RuleTimePeriod.THIS_MONTH;
                }
                case "lastMonth": {
                    return SConditionalFormattingRule.RuleTimePeriod.LAST_MONTH;
                }
                case "nextMonth": {
                    return SConditionalFormattingRule.RuleTimePeriod.NEXT_MONTH;
                }
                case "thisWeek": {
                    return SConditionalFormattingRule.RuleTimePeriod.THIS_WEEK;
                }
                case "lastWeek": {
                    return SConditionalFormattingRule.RuleTimePeriod.LAST_WEEK;
                }
                case "nextWeek": {
                    return SConditionalFormattingRule.RuleTimePeriod.NEXT_WEEK;
                }
            }
            return null;
        }

        public int getRank() {
            return XlsxJsonHelper.toInt(this.jsonMap, "rank");
        }

        public boolean isSetRank() {
            return this.jsonMap.containsKey("rank");
        }

        public int getStdDev() {
            return XlsxJsonHelper.toInt(this.jsonMap, "stdDev");
        }

        public boolean isSetStdDev() {
            return this.jsonMap.containsKey("stdDev");
        }

        public boolean isEqualAverage() {
            return XlsxJsonHelper.toBool(this.jsonMap, "equalAverage", false);
        }

        public boolean isSetEqualAverage() {
            return this.jsonMap.containsKey("equalAverage");
        }

        public XlsxColorScaleExtractor getColorScale() {
            return this.jsonMap.containsKey("colorScale") ? new XlsxColorScaleExtractor((Map)this.jsonMap.get("colorScale")) : null;
        }

        public XlsxDataBarExtractor getDataBar() {
            return this.jsonMap.containsKey("dataBar") ? new XlsxDataBarExtractor((Map)this.jsonMap.get("dataBar")) : null;
        }

        public XlsxIconSetExtractor getIconSet() {
            return this.jsonMap.containsKey("iconSet") ? new XlsxIconSetExtractor((Map)this.jsonMap.get("iconSet")) : null;
        }

        public List<Map> getInfo() {
            return this.jsonMap.containsKey("info") ? (List)this.jsonMap.get("info") : Collections.EMPTY_LIST;
        }

        public String getExtId() {
            Object value = null;
            Object v = this.jsonMap.get("extLst");
            value = v;
            if (v != null) {
                Object v2 = ((Map)value).get("ext");
                value = v2;
                if (v2 != null) {
                    return XlsxJsonHelper.toStringValue(value, "x14:id");
                }
            }
            return null;
        }
    }

    public static class XlsxExtCfRuleExtractor
    extends XlsxCfRuleExtractor {
        public XlsxExtCfRuleExtractor(Map jsonMap) {
            super(jsonMap);
        }

        @Override
        public List<String> getFormulas() {
            return this.getFormulas0("xm:f");
        }

        public XlsxDxfExtractor getDxf() {
            return this.jsonMap.containsKey("x14:dxf") ? new XlsxExtDxfExtractor((Map)this.jsonMap.get("x14:dxf")) : null;
        }

        @Override
        public XlsxColorScaleExtractor getColorScale() {
            return this.jsonMap.containsKey("x14:colorScale") ? new XlsxExtColorScaleExtractor((Map)this.jsonMap.get("x14:colorScale")) : null;
        }

        @Override
        public XlsxDataBarExtractor getDataBar() {
            return this.jsonMap.containsKey("x14:dataBar") ? new XlsxExtDataBarExtractor((Map)this.jsonMap.get("x14:dataBar")) : null;
        }

        @Override
        public XlsxIconSetExtractor getIconSet() {
            return this.jsonMap.containsKey("x14:iconSet") ? new XlsxExtIconSetExtractor((Map)this.jsonMap.get("x14:iconSet")) : null;
        }

        @Override
        public List<Map> getInfo() {
            return this.jsonMap.containsKey("x14:info") ? (List)this.jsonMap.get("x14:info") : Collections.EMPTY_LIST;
        }

        public String getId() {
            return this.jsonMap.containsKey("id") ? (String)this.jsonMap.get("id") : null;
        }
    }

    public static class XlsxConditionalFormattingExtractor {
        protected final Map jsonMap;

        public XlsxConditionalFormattingExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public List<XlsxCfRuleExtractor> getCfRules() {
            return XlsxJsonHelper.toList(this.jsonMap, "cfRule", XlsxCfRuleExtractor.class);
        }

        public List<String> getDuplicateList() {
            return this.jsonMap.containsKey("duplicateList") ? (List)this.jsonMap.get("duplicateList") : Collections.EMPTY_LIST;
        }

        public String getSqref() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "sqref");
        }

        public List<Number> getSortedList() {
            return this.jsonMap.containsKey("sortedList") ? (List)this.jsonMap.get("sortedList") : Collections.EMPTY_LIST;
        }
    }

    public static class XlsxExtConditionalFormattingExtractor
    extends XlsxConditionalFormattingExtractor {
        public XlsxExtConditionalFormattingExtractor(Map jsonMap) {
            super(jsonMap);
        }

        @Override
        public List<XlsxCfRuleExtractor> getCfRules() {
            return XlsxJsonHelper.toList(this.jsonMap, "x14:cfRule", XlsxExtCfRuleExtractor.class);
        }

        @Override
        public String getSqref() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "xm:sqref");
        }
    }

    public static class XlsxSortConditionExtractor {
        private final Map jsonMap;

        public XlsxSortConditionExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public String getCustomList() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "customList");
        }

        public boolean isDescending() {
            return XlsxJsonHelper.toBool(this.jsonMap, "descending");
        }

        public Number getDxfId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "dxfId");
        }

        public Number getIconId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "iconId");
        }

        public String getIconSet() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "iconSet");
        }

        public String getRef() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "ref");
        }

        public String getSortBy() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "sortBy");
        }
    }

    public static class XlsxSortStateExtractor {
        private final Map jsonMap;

        public XlsxSortStateExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public boolean isCaseSensitive() {
            return XlsxJsonHelper.toBool(this.jsonMap, "caseSensitive");
        }

        public boolean isColumnSort() {
            return XlsxJsonHelper.toBool(this.jsonMap, "columnSort");
        }

        public String getRef() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "ref");
        }

        public List<XlsxSortConditionExtractor> getSortConditions() {
            Object sortConditions = this.jsonMap.get("sortCondition");
            if (sortConditions instanceof List) {
                return ((List)sortConditions).stream().map(r -> new XlsxSortConditionExtractor((Map)r)).collect(Collectors.toList());
            }
            if (sortConditions instanceof Map) {
                return Converter.asList(new XlsxSortConditionExtractor((Map)sortConditions));
            }
            return Collections.EMPTY_LIST;
        }

        public String getSortMethod() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "sortMethod");
        }
    }

    public static class XlsxDynamicFilterExtractor {
        private final Map jsonMap;

        public XlsxDynamicFilterExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public Number getMaxVal() {
            return XlsxJsonHelper.toNum(this.jsonMap, "maxVal");
        }

        public String getType() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "type");
        }

        public Number getVal() {
            return XlsxJsonHelper.toNum(this.jsonMap, "val");
        }
    }

    public static class XlsxCustomFilterExtractor {
        private final Map jsonMap;

        public XlsxCustomFilterExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public SAutoFilter.FilterOp getOperator() {
            String op = XlsxJsonHelper.toStringValue(this.jsonMap, "operator");
            if (op == null) {
                boolean contains;
                boolean endWith = false;
                boolean beginWith = false;
                String val = XlsxJsonHelper.toStringValue(this.jsonMap, "val");
                if (val.startsWith("*")) {
                    endWith = true;
                }
                if (val.endsWith("*")) {
                    beginWith = true;
                }
                boolean bl = contains = beginWith && endWith;
                if (contains) {
                    return SAutoFilter.FilterOp.contains;
                }
                if (beginWith) {
                    return SAutoFilter.FilterOp.beginWith;
                }
                if (endWith) {
                    return SAutoFilter.FilterOp.endWith;
                }
                return SAutoFilter.FilterOp.equal;
            }
            return SAutoFilter.FilterOp.valueOf("null0".equals(op) ? "null" : op);
        }

        public String getVal() {
            boolean contains;
            String val = XlsxJsonHelper.toStringValue(this.jsonMap, "val");
            boolean endWith = false;
            boolean beginWith = false;
            if (val.startsWith("*")) {
                endWith = true;
            }
            if (val.endsWith("*")) {
                beginWith = true;
            }
            boolean bl = contains = beginWith && endWith;
            if (contains) {
                return val.substring(1, val.length() - 1);
            }
            if (beginWith) {
                return val.substring(0, val.length() - 1);
            }
            if (endWith) {
                return val.substring(1);
            }
            return val;
        }
    }

    public static class XlsxCustomFiltersExtractor {
        private final Map jsonMap;

        public XlsxCustomFiltersExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public boolean isAnd() {
            return XlsxJsonHelper.toBool(this.jsonMap, "and", false);
        }

        public XlsxCustomFilterExtractor getCustomFilter1() {
            Object jsonValue = this.jsonMap.get("customFilter");
            if (jsonValue instanceof List) {
                return new XlsxCustomFilterExtractor((Map)((List)jsonValue).get(0));
            }
            if (jsonValue instanceof Map) {
                return new XlsxCustomFilterExtractor((Map)jsonValue);
            }
            return null;
        }

        public XlsxCustomFilterExtractor getCustomFilter2() {
            Object jsonValue = this.jsonMap.get("customFilter");
            if (jsonValue instanceof List) {
                List jsonList = (List)jsonValue;
                return jsonList.size() == 2 ? new XlsxCustomFilterExtractor((Map)((List)jsonValue).get(1)) : null;
            }
            return null;
        }
    }

    public static class XlsxColorFilterExtractor {
        private final Map jsonMap;

        public XlsxColorFilterExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public Boolean isCellColor() {
            return XlsxJsonHelper.toBool(this.jsonMap, "cellColor");
        }

        public Number getDxfId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "dxfId");
        }
    }

    public static class XlsxFilterColumnExtractor {
        private final Map jsonMap;

        public XlsxFilterColumnExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public Number getColId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "colId");
        }

        public XlsxColorFilterExtractor getColorFilter() {
            if (this.jsonMap.containsKey("colorFilter")) {
                return new XlsxColorFilterExtractor((Map)this.jsonMap.get("colorFilter"));
            }
            return null;
        }

        public XlsxCustomFiltersExtractor getCustomFilters() {
            if (this.jsonMap.containsKey("customFilters")) {
                return new XlsxCustomFiltersExtractor((Map)this.jsonMap.get("customFilters"));
            }
            return null;
        }

        public XlsxDynamicFilterExtractor getDynamicFilter() {
            if (this.jsonMap.containsKey("dynamicFilter")) {
                return new XlsxDynamicFilterExtractor((Map)this.jsonMap.get("dynamicFilter"));
            }
            return null;
        }

        public XlsxFiltersExtractor getFilters() {
            if (this.jsonMap.containsKey("filters")) {
                return new XlsxFiltersExtractor((Map)this.jsonMap.get("filters"));
            }
            return null;
        }

        public Boolean isHiddenButton() {
            return XlsxJsonHelper.toBool(this.jsonMap, "hiddenButton");
        }

        public boolean isSetHiddenButton() {
            return this.jsonMap.containsKey("hiddenButton");
        }

        public XlsxIconFilterExtractor getIconFilter() {
            if (this.jsonMap.containsKey("iconFilter")) {
                return new XlsxIconFilterExtractor((Map)this.jsonMap.get("iconFilter"));
            }
            return null;
        }

        public Boolean isShowButton() {
            return XlsxJsonHelper.toBool(this.jsonMap, "showButton");
        }

        public boolean isSetShowButton() {
            return this.jsonMap.containsKey("showButton");
        }

        public XlsxTop10Extractor getTop10() {
            if (this.jsonMap.containsKey("top10")) {
                return new XlsxTop10Extractor((Map)this.jsonMap.get("top10"));
            }
            return null;
        }
    }

    public static class XlsxIconFilterExtractor {
        private final Map jsonMap;

        public XlsxIconFilterExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public Number getIconId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "iconId");
        }

        public String getIconSet() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "iconSet");
        }
    }

    public static class XlsxTop10Extractor {
        private final Map jsonMap;

        public XlsxTop10Extractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public double getFilterVal() {
            return Optional.ofNullable(XlsxJsonHelper.toNum(this.jsonMap, "filterVal")).orElse(0).doubleValue();
        }

        public boolean isPercent() {
            return XlsxJsonHelper.toBool(this.jsonMap, "percent", false);
        }

        public boolean isTop() {
            return XlsxJsonHelper.toBool(this.jsonMap, "top", false);
        }

        public double getVal() {
            return Optional.ofNullable(XlsxJsonHelper.toNum(this.jsonMap, "val")).orElse(0).doubleValue();
        }
    }

    public static class XlsxDateGroupItemExtractor {
        private final Map jsonMap;

        public XlsxDateGroupItemExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public String getDateTimeGrouping() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "dateTimeGrouping");
        }

        public Number getDay() {
            return XlsxJsonHelper.toNum(this.jsonMap, "day");
        }

        public Number getHour() {
            return XlsxJsonHelper.toNum(this.jsonMap, "hour");
        }

        public Number getMinute() {
            return XlsxJsonHelper.toNum(this.jsonMap, "minute");
        }

        public Number getMonth() {
            return XlsxJsonHelper.toNum(this.jsonMap, "month");
        }

        public Number getSecond() {
            return XlsxJsonHelper.toNum(this.jsonMap, "second");
        }

        public Number getYear() {
            return XlsxJsonHelper.toNum(this.jsonMap, "year");
        }
    }

    public static class XlsxFiltersExtractor {
        private final Map jsonMap;

        public XlsxFiltersExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public boolean isBlank() {
            return XlsxJsonHelper.toBool(this.jsonMap, "blank", false);
        }

        public String getCalendarType() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "calendarType");
        }

        public List<XlsxDateGroupItemExtractor> getDateGroupItems() {
            Object dateGroupItems = this.jsonMap.get("dateGroupItem");
            if (dateGroupItems instanceof List) {
                return ((List)dateGroupItems).stream().map(r -> new XlsxDateGroupItemExtractor((Map)r)).collect(Collectors.toList());
            }
            if (dateGroupItems instanceof Map) {
                return Converter.asList(new XlsxDateGroupItemExtractor((Map)dateGroupItems));
            }
            return Collections.EMPTY_LIST;
        }

        public List<String> getFilters() {
            Object filters = this.jsonMap.get("filter");
            if (filters instanceof List) {
                return ((List)filters).stream().map(r -> XlsxJsonHelper.toStringValue(r, "val")).collect(Collectors.toList());
            }
            if (filters instanceof Map) {
                return Converter.asList(XlsxJsonHelper.toStringValue((Map)filters, "val"));
            }
            return Collections.EMPTY_LIST;
        }
    }

    public static class XlsxAutoFilterExtractor {
        private final Map jsonMap;

        public XlsxAutoFilterExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public List<XlsxFilterColumnExtractor> getFilterColumns() {
            Object filterColumns = XlsxJsonHelper.$(this.jsonMap, "filterColumn");
            if (filterColumns instanceof List) {
                return ((List)filterColumns).stream().map(r -> new XlsxFilterColumnExtractor((Map)r)).collect(Collectors.toList());
            }
            if (filterColumns instanceof Map) {
                return Converter.asList(new XlsxFilterColumnExtractor((Map)filterColumns));
            }
            return Collections.EMPTY_LIST;
        }

        public String getRef() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "ref");
        }

        public XlsxSortStateExtractor getSortState() {
            return this.jsonMap.containsKey("sortState") ? new XlsxSortStateExtractor((Map)this.jsonMap.get("sortState")) : null;
        }
    }

    public static class XlsxDataValidationExtractor {
        protected final Map jsonMap;

        public XlsxDataValidationExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public boolean isAllowBlank() {
            return XlsxJsonHelper.toBool(this.jsonMap, "allowBlank", false);
        }

        public String getError() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "error");
        }

        public SDataValidation.AlertStyle getErrorStyle() {
            String style;
            switch (style = XlsxJsonHelper.toStringValue(this.jsonMap, "errorStyle", "stop")) {
                case "information": {
                    return SDataValidation.AlertStyle.INFO;
                }
                case "warning": {
                    return SDataValidation.AlertStyle.WARNING;
                }
            }
            return SDataValidation.AlertStyle.STOP;
        }

        public String getErrorTitle() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "errorTitle");
        }

        public String getImeMode() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "imeMode");
        }

        public SDataValidation.OperatorType getOperator() {
            String operator;
            switch (operator = XlsxJsonHelper.toStringValue(this.jsonMap, "operator", "between")) {
                case "equal": {
                    return SDataValidation.OperatorType.EQUAL;
                }
                case "greaterThanOrEqual": {
                    return SDataValidation.OperatorType.GREATER_OR_EQUAL;
                }
                case "greaterThan": {
                    return SDataValidation.OperatorType.GREATER_THAN;
                }
                case "lessThanOrEqual": {
                    return SDataValidation.OperatorType.LESS_OR_EQUAL;
                }
                case "lessThan": {
                    return SDataValidation.OperatorType.LESS_THAN;
                }
                case "notBetween": {
                    return SDataValidation.OperatorType.NOT_BETWEEN;
                }
                case "notEqual": {
                    return SDataValidation.OperatorType.NOT_EQUAL;
                }
            }
            return SDataValidation.OperatorType.BETWEEN;
        }

        public String getPrompt() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "prompt");
        }

        public String getPromptTitle() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "promptTitle");
        }

        public boolean isShowDropDown() {
            return this.jsonMap.containsKey("showDropDown") ? !XlsxJsonHelper.toBool(this.jsonMap, "showDropDown").booleanValue() : true;
        }

        public boolean isShowErrorMessage() {
            return XlsxJsonHelper.toBool(this.jsonMap, "showErrorMessage", false);
        }

        public boolean isShowInputMessage() {
            return XlsxJsonHelper.toBool(this.jsonMap, "showInputMessage", false);
        }

        public String getSqref() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "sqref");
        }

        public SDataValidation.ValidationType getType() {
            String type;
            switch (type = XlsxJsonHelper.toStringValue(this.jsonMap, "type", "none")) {
                case "time": {
                    return SDataValidation.ValidationType.TIME;
                }
                case "textLength": {
                    return SDataValidation.ValidationType.TEXT_LENGTH;
                }
                case "list": {
                    return SDataValidation.ValidationType.LIST;
                }
                case "whole": {
                    return SDataValidation.ValidationType.INTEGER;
                }
                case "custom": {
                    return SDataValidation.ValidationType.CUSTOM;
                }
                case "decimal": {
                    return SDataValidation.ValidationType.DECIMAL;
                }
                case "date": {
                    return SDataValidation.ValidationType.DATE;
                }
            }
            return SDataValidation.ValidationType.ANY;
        }

        public String getFormula1() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "formula1");
        }

        public String getFormula2() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "formula2");
        }

        public String getValidator() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "validator");
        }
    }

    public static class XlsxExtDataValidationExtractor
    extends XlsxDataValidationExtractor {
        public XlsxExtDataValidationExtractor(Map jsonMap) {
            super(jsonMap);
        }

        @Override
        public String getSqref() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "xm:sqref");
        }

        @Override
        public String getFormula1() {
            if (this.jsonMap.containsKey("x14:formula1")) {
                return XlsxJsonHelper.toStringValue((Map)this.jsonMap.get("x14:formula1"), "xm:f");
            }
            return null;
        }

        @Override
        public String getFormula2() {
            if (this.jsonMap.containsKey("x14:formula2")) {
                return XlsxJsonHelper.toStringValue((Map)this.jsonMap.get("x14:formula2"), "xm:f");
            }
            return null;
        }
    }

    public static class XlsxDataValidationsExtractor {
        private final Map jsonMap;

        public XlsxDataValidationsExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public int getCount() {
            return Optional.ofNullable(XlsxJsonHelper.toInt(this.jsonMap, "count")).orElse(0);
        }

        public boolean isDisablePrompts() {
            return XlsxJsonHelper.toBool(this.jsonMap, "disablePrompts", false);
        }

        public List<XlsxDataValidationExtractor> getValidations() {
            Object validations = this.jsonMap.get("dataValidation");
            if (validations instanceof List) {
                return ((List)validations).stream().map(r -> new XlsxDataValidationExtractor((Map)r)).collect(Collectors.toList());
            }
            if (validations instanceof Map) {
                return Converter.asList(new XlsxDataValidationExtractor((Map)validations));
            }
            return Collections.EMPTY_LIST;
        }

        public int getXWindow() {
            return Optional.ofNullable(XlsxJsonHelper.toInt(this.jsonMap, "xWindow")).orElse(0);
        }

        public int getYWindow() {
            return Optional.ofNullable(XlsxJsonHelper.toInt(this.jsonMap, "yWindow")).orElse(0);
        }
    }

    public static class XlsxDefinedNameExtractor {
        private final Map jsonMap;

        public XlsxDefinedNameExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public String getComment() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "comment");
        }

        public String getCustomMenu() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "comment");
        }

        public String getDescription() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "description");
        }

        public String getFormula() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "_");
        }

        public boolean isFunction() {
            return XlsxJsonHelper.toBool(this.jsonMap, "function", false);
        }

        public Number getFunctionGroupId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "functionGroupId");
        }

        public String getHelp() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "help");
        }

        public Boolean isHidden() {
            return XlsxJsonHelper.toBool(this.jsonMap, "hidden");
        }

        public String getLocalSheetId() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "localSheetId");
        }

        public String getName() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "name");
        }

        public boolean isPublishToServer() {
            return XlsxJsonHelper.toBool(this.jsonMap, "publishToServer", false);
        }

        public String getShortcutKey() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "shortcutKey");
        }

        public String getStatusBar() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "statusBar");
        }

        public boolean isVbProcedure() {
            return XlsxJsonHelper.toBool(this.jsonMap, "vbProcedure", false);
        }

        public boolean isWorkbookParameter() {
            return XlsxJsonHelper.toBool(this.jsonMap, "workbookParameter", false);
        }

        public boolean isXlm() {
            return XlsxJsonHelper.toBool(this.jsonMap, "xlm");
        }
    }

    public static class XlsxVmlDrawingExtractor {
        private final Map jsonMap;
        private final byte[] imageData;

        public XlsxVmlDrawingExtractor(Map jsonMap, byte[] imageData) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
            this.imageData = imageData;
        }

        public Map getJsonMap() {
            return this.jsonMap;
        }

        public byte[] getImageData() {
            return this.imageData;
        }
    }

    public static abstract class XlsxDrawingFactory {
        private static ChartSpaceJson createChart(Map workbookJson, Map rels, Map viewAnchor, Map data) {
            List relList = XlsxJsonHelper.toList(XlsxJsonHelper.$(rels, "Relationships"), "Relationship");
            String cId = data.get("r:id").toString();
            Map relation = relList.stream().filter(entry -> cId.equals(entry.get("Id").toString())).findAny().orElse(null);
            if (relation != null) {
                String relationTarget = relation.get("Target").toString();
                String chartPath = XlsxExtractor._getPath(relationTarget, "xl");
                String chartFile = chartPath.substring(chartPath.lastIndexOf("/") + 1);
                Map chartData = (Map)XlsxJsonHelper.$(workbookJson, chartPath);
                Map chartColorStyle = null;
                Map chartStyle = null;
                List chartRef = (List)XlsxJsonHelper.$x((Map)XlsxJsonHelper.$(workbookJson, "xl/charts/_rels/" + chartFile + ".rels"), "Relationships/Relationship");
                if (chartRef != null) {
                    String chartColorStyleTarget = (String)chartRef.stream().filter(rel -> "http://schemas.microsoft.com/office/2011/relationships/chartColorStyle".equals(rel.get("Type").toString())).findAny().get().get("Target");
                    String chartStyleTarget = (String)chartRef.stream().filter(rel -> "http://schemas.microsoft.com/office/2011/relationships/chartStyle".equals(rel.get("Type").toString())).findAny().get().get("Target");
                    chartColorStyle = (Map)XlsxJsonHelper.$(workbookJson, "xl", "charts", chartColorStyleTarget);
                    chartStyle = (Map)XlsxJsonHelper.$(workbookJson, "xl", "charts", chartStyleTarget);
                }
                String uuid = XlsxJsonHelper.$x(viewAnchor, "xdr:graphicFrame/xdr:nvGraphicFramePr/xdr:cNvPr/id").toString();
                return new ChartSpaceJson(uuid, viewAnchor, chartData, chartColorStyle, chartStyle);
            }
            return null;
        }

        private static PictureJson createPicture(Map workbookJson, Map rels, Map viewAnchor, Map data) {
            Map relation;
            List relList = XlsxJsonHelper.toList(XlsxJsonHelper.$(rels, "Relationships"), "Relationship");
            Map hlinkClick = (Map)XlsxJsonHelper.$x(viewAnchor, "xdr:grpSp/xdr:nvGrpSpPr/xdr:cNvPr/a:hlinkClick");
            String hlinkTarget = "";
            String hlinkTooltip = "";
            if (hlinkClick != null) {
                String rId = hlinkClick.get("r:id").toString();
                Map relation2 = relList.stream().filter(entry -> rId.equals(entry.get("Id").toString())).findAny().get();
                if (relation2.containsKey("Target")) {
                    hlinkTarget = relation2.get("Target").toString();
                }
                if (relation2.containsKey("tooltip")) {
                    hlinkTooltip = hlinkClick.get("tooltip").toString();
                }
            }
            if ((relation = (Map)relList.stream().filter(entry -> {
                String id = (String)entry.get("Id");
                if (id == null) {
                    return false;
                }
                Map blip = (Map)XlsxJsonHelper.$x(data, "xdr:blipFill/a:blip");
                String embed = (String)blip.get("r:embed");
                return id.equals(embed != null ? embed : (String)blip.get("r:link"));
            }).findAny().orElse(null)) != null) {
                String targetMode;
                String uuid = XlsxJsonHelper.$(data, "xdr:nvPicPr", "xdr:cNvPr", "id").toString();
                String target = relation.get("Target").toString();
                String string = targetMode = relation.containsKey("TargetMode") ? relation.get("TargetMode").toString() : "";
                if ("External".equals(targetMode)) {
                    return new PictureJson(uuid, viewAnchor, data, target, hlinkTarget, hlinkTooltip, true);
                }
                String imagePath = target.substring(3);
                String imageFile = imagePath.substring(imagePath.lastIndexOf("/") + 1);
                byte[] fileContent = (byte[])workbookJson.get("xl/media/" + imageFile);
                String fileType = imagePath.substring(imagePath.lastIndexOf(".") + 1);
                return new PictureJson(uuid, viewAnchor, data, fileContent, fileType, hlinkTarget, hlinkTooltip);
            }
            return null;
        }

        private static GroupPictureJson createGroupPicture(Map workbookJson, Map rels, Map viewAnchor, List<Map> data) {
            Map hlinkClick = (Map)XlsxJsonHelper.$x(viewAnchor, "xdr:grpSp/xdr:nvGrpSpPr/xdr:cNvPr/a:hlinkClick");
            String hlinkTarget = "";
            String hlinkTooltip = "";
            if (hlinkClick != null) {
                String rId = hlinkClick.get("r:id").toString();
                Map relation = XlsxJsonHelper.toList(XlsxJsonHelper.$(rels, "Relationships"), "Relationship").stream().filter(entry -> rId.equals(entry.get("Id").toString())).findAny().get();
                if (relation.containsKey("Target")) {
                    hlinkTarget = relation.get("Target").toString();
                }
                if (relation.containsKey("tooltip")) {
                    hlinkTooltip = hlinkClick.get("tooltip").toString();
                }
            }
            String uuid = XlsxJsonHelper.$x(viewAnchor, "xdr:grpSp/xdr:nvGrpSpPr/xdr:cNvPr/id").toString();
            GroupPictureJson gpicJson = new GroupPictureJson(viewAnchor, uuid, hlinkTarget, hlinkTooltip);
            data.forEach(pic -> gpicJson.addPicture(XlsxDrawingFactory.createPicture(workbookJson, rels, viewAnchor, pic)));
            return gpicJson;
        }

        public static ShapeJson create(Map workbookJson, Map rels, Map data) {
            Map cchartData = (Map)XlsxJsonHelper.$x(data, "xdr:graphicFrame/a:graphic/a:graphicData/c:chart");
            if (cchartData != null) {
                return XlsxDrawingFactory.createChart(workbookJson, rels, data, cchartData);
            }
            Map chartData = (Map)XlsxJsonHelper.$x(data, "xdr:graphicFrame/a:graphic/a:graphicData/chart");
            if (chartData != null) {
                return XlsxDrawingFactory.createChart(workbookJson, rels, data, chartData);
            }
            Map picData = (Map)XlsxJsonHelper.$x(data, "xdr:pic");
            if (picData != null) {
                return XlsxDrawingFactory.createPicture(workbookJson, rels, data, picData);
            }
            List grpSpPicData = XlsxJsonHelper.toList(XlsxJsonHelper.$x(data, "xdr:grpSp"), "xdr:pic");
            if (grpSpPicData != null) {
                return XlsxDrawingFactory.createGroupPicture(workbookJson, rels, data, grpSpPicData);
            }
            return null;
        }
    }

    public static class XlsxDrawingsExtractor {
        private final Map workbookJson;
        private final Map drawingRefs;
        private final Map jsonMap;

        public XlsxDrawingsExtractor(Map workbookJson, Map drawingRefs, Map jsonMap) {
            this.workbookJson = workbookJson;
            this.drawingRefs = drawingRefs;
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public List<ShapeJson> getDrawingsJson() {
            List<ShapeJson> result = XlsxJsonHelper.toList(this.jsonMap, "xdr:twoCellAnchor").stream().filter(data -> !data.isEmpty()).map(data -> XlsxDrawingFactory.create(this.workbookJson, this.drawingRefs, data)).collect(Collectors.toList());
            return result;
        }
    }

    public static class XlsxCommentExtractor {
        private final Map jsonMap;
        private String authorName;
        private VmlDrawing.VShapeJson vShape;

        public XlsxCommentExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public Number getAuthorId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "authorId");
        }

        public XlsxRichTextExtractor getText() {
            return new XlsxRichTextExtractor((Map)XlsxJsonHelper.$(this.jsonMap, "text"));
        }

        public Number getShapeId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "shapeId");
        }

        public String getRef() {
            return (String)XlsxJsonHelper.$(this.jsonMap, "ref");
        }

        public void setAuthorName(String authorName) {
            this.authorName = authorName;
        }

        public String getAuthorName() {
            return this.authorName;
        }

        public void setShape(VmlDrawing.VShapeJson shape) {
            this.vShape = shape;
        }

        public boolean isVisible() {
            return this.vShape != null ? this.vShape.isVisibility() : false;
        }
    }

    public static class XlsxCommentsExtractor {
        private final Map jsonMap;

        public XlsxCommentsExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public List<String> getAuthors() {
            Object author = XlsxJsonHelper.$(this.jsonMap, "authors", "author");
            if (author instanceof List) {
                return ((List)author).stream().map(r -> XlsxJsonHelper.toStringValue(r, "_", "")).collect(Collectors.toList());
            }
            if (author instanceof Map) {
                return Converter.asList((String)((Map)author).get("_"));
            }
            return Collections.EMPTY_LIST;
        }

        public List<XlsxCommentExtractor> getCommentList() {
            return XlsxJsonHelper.toList((Map)XlsxJsonHelper.$(this.jsonMap, "commentList"), "comment", XlsxCommentExtractor.class);
        }
    }

    public static class XlsxHyperlinkExtractor {
        private final Map jsonMap;

        public XlsxHyperlinkExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public String getRef() {
            return (String)XlsxJsonHelper.$(this.jsonMap, "ref");
        }

        public String getTarget() {
            return (String)XlsxJsonHelper.$(this.jsonMap, "r:id");
        }

        public String getLocation() {
            return Optional.ofNullable(Optional.ofNullable(XlsxJsonHelper.$(this.jsonMap, "location")).orElse(this.getTarget())).orElse("").toString();
        }

        public String getTooltip() {
            return (String)XlsxJsonHelper.$(this.jsonMap, "tooltip");
        }

        public String getDisplay() {
            return (String)XlsxJsonHelper.$(this.jsonMap, "display");
        }

        public SHyperlink.HyperlinkType getType() {
            String link = this.getTarget();
            if (link == null || link.isEmpty()) {
                return SHyperlink.HyperlinkType.DOCUMENT;
            }
            if ((link = link.toLowerCase()).startsWith("http://") || link.startsWith("https://") || link.startsWith("ftp://")) {
                return SHyperlink.HyperlinkType.URL;
            }
            if (link.startsWith("mailto:")) {
                return SHyperlink.HyperlinkType.EMAIL;
            }
            return SHyperlink.HyperlinkType.FILE;
        }
    }

    public static class XlsxColExtractor {
        private final Map jsonMap;

        public XlsxColExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public boolean isBestFit() {
            return XlsxJsonHelper.toBool(this.jsonMap, "bestFit", false);
        }

        public boolean isCollapsed() {
            return XlsxJsonHelper.toBool(this.jsonMap, "collapsed", false);
        }

        public boolean isCustomWidth() {
            return XlsxJsonHelper.toBool(this.jsonMap, "customWidth", false);
        }

        public boolean isHidden() {
            return XlsxJsonHelper.toBool(this.jsonMap, "hidden", false);
        }

        public int getMax() {
            return Optional.ofNullable(XlsxJsonHelper.toInt(this.jsonMap, "max")).orElse(0);
        }

        public int getMin() {
            return Optional.ofNullable(XlsxJsonHelper.toInt(this.jsonMap, "min")).orElse(0);
        }

        public Number getOutlineLevel() {
            return XlsxJsonHelper.toNum(this.jsonMap, "outlineLevel");
        }

        public boolean isPhonetic() {
            return XlsxJsonHelper.toBool(this.jsonMap, "phonetic", false);
        }

        public int getStyle() {
            return Optional.ofNullable(XlsxJsonHelper.toInt(this.jsonMap, "style")).orElse(-1);
        }

        public Number getWidth() {
            return XlsxJsonHelper.toNum(this.jsonMap, "width");
        }
    }

    public static class XlsxExternalBookExtractor {
        private final String name;
        private final Map jsonMap;

        public XlsxExternalBookExtractor(String name, Map jsonMap) {
            this.name = name;
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public String getName() {
            return this.name;
        }
    }

    public static class XlsxExternalLinkExtractor {
        private final Map workbookJson;
        private final Map jsonMap;
        private final Map extBookJson;
        private String _extLinkPath;

        public XlsxExternalLinkExtractor(Map workbookJson, Map jsonMap) {
            this.workbookJson = workbookJson;
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
            Map extBookJson = (Map)XlsxJsonHelper.$(jsonMap, "externalLink", "externalBook");
            this.extBookJson = extBookJson == null ? Collections.EMPTY_MAP : extBookJson;
        }

        public String getExternalLinkPath() {
            if (this._extLinkPath == null) {
                List workbookRels = (List)XlsxJsonHelper.$(this.workbookJson, "xl/_rels/workbook.xml.rels", "Relationships", "Relationship");
                LinkedHashMap idMap = new LinkedHashMap();
                workbookRels.forEach(rel -> idMap.put((String)rel.get("Id"), (String)rel.get("Target")));
                String rid = (String)this.jsonMap.get("r:id");
                String[] array = ((String)idMap.get(rid)).split("/");
                this._extLinkPath = array[array.length - 1];
            }
            return this._extLinkPath;
        }

        public XlsxExternalBookExtractor getExternalBook() {
            String extLinkPath = this.getExternalLinkPath();
            Map extLinkRels = (Map)XlsxJsonHelper.$(this.workbookJson, "xl/externalLinks/_rels/" + extLinkPath + ".rels");
            if (extLinkRels != null) {
                Map relationsMap;
                Object type;
                Object relations = XlsxJsonHelper.$(extLinkRels, "Relationships", "Relationship");
                Map extBookNames = relations instanceof List ? ((List)relations).stream().filter(r -> {
                    Object type = r.get("Type");
                    return "http://schemas.openxmlformats.org/officeDocument/2006/relationships/externalLinkPath".equals(type) || "http://schemas.microsoft.com/office/2006/relationships/xlExternalLinkPath/xlPathMissing".equals(type);
                }).collect(Collectors.toMap(r -> r.get("Id"), r -> r.get("Target"))) : ("http://schemas.openxmlformats.org/officeDocument/2006/relationships/externalLinkPath".equals(type = (relationsMap = (Map)relations).get("Type")) || "http://schemas.microsoft.com/office/2006/relationships/xlExternalLinkPath/xlPathMissing".equals(type) ? Converter.asMap(relationsMap.get("Id"), relationsMap.get("Target")) : null);
                String extBookName = (String)extBookNames.get(this.extBookJson.get("r:id"));
                return new XlsxExternalBookExtractor(extBookName, this.extBookJson);
            }
            return null;
        }
    }

    public static class XlsxClrSchemeExtractor {
        private final Map jsonMap;

        public XlsxClrSchemeExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        private static String getColorScheme(Map jsonMap, String key) {
            Map color = (Map)XlsxJsonHelper.$(jsonMap, key);
            if (color.containsKey("a:srgbClr")) {
                return (String)XlsxJsonHelper.$(color, "a:srgbClr", "val");
            }
            if (color.containsKey("a:sysClr")) {
                return (String)XlsxJsonHelper.$(color, "a:sysClr", "lastClr");
            }
            if (color.containsKey("a:schemeClr")) {
                return (String)XlsxJsonHelper.$(color, "a:schemeClr", "val");
            }
            if (color.containsKey("a:prstClr")) {
                return (String)XlsxJsonHelper.$(color, "a:prstClr", "val");
            }
            throw new UnsupportedOperationException("Not implemented yet.");
        }

        public String getName() {
            return (String)XlsxJsonHelper.$(this.jsonMap, "name");
        }

        public String getAccent1() {
            return XlsxClrSchemeExtractor.getColorScheme(this.jsonMap, "a:accent1");
        }

        public String getAccent2() {
            return XlsxClrSchemeExtractor.getColorScheme(this.jsonMap, "a:accent2");
        }

        public String getAccent3() {
            return XlsxClrSchemeExtractor.getColorScheme(this.jsonMap, "a:accent3");
        }

        public String getAccent4() {
            return XlsxClrSchemeExtractor.getColorScheme(this.jsonMap, "a:accent4");
        }

        public String getAccent5() {
            return XlsxClrSchemeExtractor.getColorScheme(this.jsonMap, "a:accent5");
        }

        public String getAccent6() {
            return XlsxClrSchemeExtractor.getColorScheme(this.jsonMap, "a:accent6");
        }

        public String getDk1() {
            return XlsxClrSchemeExtractor.getColorScheme(this.jsonMap, "a:dk1");
        }

        public String getTx1() {
            return XlsxClrSchemeExtractor.getColorScheme(this.jsonMap, "a:dk1");
        }

        public String getDk2() {
            return XlsxClrSchemeExtractor.getColorScheme(this.jsonMap, "a:dk2");
        }

        public String getTx2() {
            return XlsxClrSchemeExtractor.getColorScheme(this.jsonMap, "a:dk2");
        }

        public String getFolHlink() {
            return XlsxClrSchemeExtractor.getColorScheme(this.jsonMap, "a:folHlink");
        }

        public String getHlink() {
            return XlsxClrSchemeExtractor.getColorScheme(this.jsonMap, "a:hlink");
        }

        public String getLt1() {
            return XlsxClrSchemeExtractor.getColorScheme(this.jsonMap, "a:lt1");
        }

        public String getBg1() {
            return XlsxClrSchemeExtractor.getColorScheme(this.jsonMap, "a:lt1");
        }

        public String getLt2() {
            return XlsxClrSchemeExtractor.getColorScheme(this.jsonMap, "a:lt2");
        }

        public String getBg2() {
            return XlsxClrSchemeExtractor.getColorScheme(this.jsonMap, "a:lt2");
        }
    }

    public static class XlsxThemesExtractor {
        final String name;
        final String os;
        private final Map jsonMap;

        XlsxThemesExtractor(String os, Map jsonMap) {
            this.os = os;
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
            this.name = XlsxJsonHelper.toStringValue(jsonMap, "name");
        }

        public XlsxClrSchemeExtractor getClrScheme() {
            return new XlsxClrSchemeExtractor((Map)XlsxJsonHelper.$(this.jsonMap, "a:themeElements", "a:clrScheme"));
        }
    }

    public static class XlsxPhoneticPrExtractor {
        private final Map jsonMap;

        public XlsxPhoneticPrExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public int getFontId() {
            return XlsxJsonHelper.toInt(this.jsonMap, "fontId");
        }

        public String getAlignment() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "alignment");
        }

        public String getPhoneticType() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "type");
        }
    }

    public static class XlsxPhoneticRunExtractor {
        private final Map jsonMap;

        public XlsxPhoneticRunExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public int getStartIndex() {
            return XlsxJsonHelper.toInt(this.jsonMap, "sb");
        }

        public String getText() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "t");
        }

        public int getEndIndex() {
            return XlsxJsonHelper.toInt(this.jsonMap, "eb");
        }
    }

    public static class XlsxREItExtractor {
        private final Map jsonMap;

        public XlsxREItExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public XlsxFontExtractor getFont() {
            Map rPr = (Map)this.jsonMap.get("rPr");
            return rPr != null ? new XlsxFontExtractor(rPr) : null;
        }

        public String getText() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "t", "");
        }
    }

    public static class XlsxRichTextExtractor {
        private final Map jsonMap;

        public XlsxRichTextExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public String getBaseText() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "t", "");
        }

        public List<XlsxREItExtractor> getRuns() {
            Object rs = this.jsonMap.get("r");
            if (rs != null) {
                if (rs instanceof List) {
                    return ((List)rs).stream().map(r -> new XlsxREItExtractor((Map)r)).collect(Collectors.toList());
                }
                return Converter.asList(new XlsxREItExtractor((Map)rs));
            }
            return Collections.EMPTY_LIST;
        }

        public List<XlsxPhoneticRunExtractor> getPhoneticRuns() {
            Object rs = this.jsonMap.get("rPh");
            if (rs != null) {
                if (rs instanceof List) {
                    return ((List)rs).stream().map(r -> new XlsxPhoneticRunExtractor((Map)r)).collect(Collectors.toList());
                }
                return Converter.asList(new XlsxPhoneticRunExtractor((Map)rs));
            }
            return Collections.EMPTY_LIST;
        }

        public XlsxPhoneticPrExtractor getPhoneticPr() {
            return this.jsonMap.containsKey("phoneticPr") ? new XlsxPhoneticPrExtractor((Map)this.jsonMap.get("phoneticPr")) : null;
        }
    }

    public static class XlsxFormulaExtractor {
        final String cref;
        private final Map jsonMap;
        final Map calcChain;

        public XlsxFormulaExtractor(String cref, Map jsonMap, Map calcChain) {
            this.cref = cref;
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
            this.calcChain = calcChain;
        }

        public Boolean isAca() {
            return XlsxJsonHelper.toBool(this.jsonMap, "aca");
        }

        public Boolean isBx() {
            return XlsxJsonHelper.toBool(this.jsonMap, "bx");
        }

        public Boolean isCa() {
            return XlsxJsonHelper.toBool(this.jsonMap, "ca");
        }

        public Boolean isDel1() {
            return XlsxJsonHelper.toBool(this.jsonMap, "del1");
        }

        public Boolean isDel2() {
            return XlsxJsonHelper.toBool(this.jsonMap, "del2");
        }

        public Boolean isDt2D() {
            return XlsxJsonHelper.toBool(this.jsonMap, "dt2D");
        }

        public Boolean isDtr() {
            return XlsxJsonHelper.toBool(this.jsonMap, "dtr");
        }

        public String getR1() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "r1");
        }

        public String getR2() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "r2");
        }

        public String getRef() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "ref");
        }

        public Number getSi() {
            return XlsxJsonHelper.toNum(this.jsonMap, "si");
        }

        public String getType() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "t");
        }

        public Object getValue() {
            Object v = XlsxJsonHelper.toValue(this.jsonMap, "_");
            String type = this.getType();
            if ("shared".equals(type)) {
                String ref0 = this.getRef();
                Number si = this.getSi();
                if (ref0 != null) {
                    this.calcChain.put(si, new Pair((Object)this.cref, v));
                } else {
                    return this.calcChain.get(si);
                }
            }
            return (String)v;
        }

        public String getSharedRef() {
            if ("shared".equals(this.getType()) && this.getRef() == null) {
                return (String)((Pair)this.calcChain.get((Object)this.cref)).y;
            }
            return null;
        }
    }

    public static class XlsxCellExtractor {
        final Cell jsonMap;
        final Map sharedStrings;
        final int index;
        final Map calcChain;
        private List _sharedStrings;

        public XlsxCellExtractor(Cell jsonMap, Map sharedStrings, Map calcChain) {
            this.jsonMap = jsonMap;
            this.sharedStrings = sharedStrings;
            this.calcChain = calcChain;
            this.index = Converter.a1ToRef((String)jsonMap.get("r")).getLeft();
        }

        public Number getCm() {
            Object cm = this.jsonMap.get("cm");
            return cm != null ? Integer.valueOf((int)Double.parseDouble((String)cm)) : null;
        }

        public Boolean isPhonetic() {
            return XlsxJsonHelper.toBoolean(this.jsonMap.get("ph"), null);
        }

        public String getRef() {
            return (String)this.jsonMap.get("r");
        }

        public int getStyle() {
            Object s = this.jsonMap.get("s");
            return s != null ? Integer.parseInt((String)s) : -1;
        }

        public String getType() {
            return (String)this.jsonMap.get("t");
        }

        public Number getVm() {
            Object cm = this.jsonMap.get("vm");
            return cm != null ? Integer.valueOf((int)Double.parseDouble((String)cm)) : null;
        }

        public XlsxFormulaExtractor getFormula() {
            Object f = this.jsonMap.get("f");
            return f != null ? new XlsxFormulaExtractor((String)this.jsonMap.get("r"), (Map)f, this.calcChain) : null;
        }

        public XlsxRichTextExtractor getRichTextInline() {
            Object is = this.jsonMap.get("is");
            return is != null ? new XlsxRichTextExtractor((Map)is) : null;
        }

        public Object getValue() {
            Object v = this.jsonMap.get("v");
            if (v != null) {
                String t = this.getType();
                if (t != null) {
                    if ("s".equals(t)) {
                        if (this._sharedStrings == null) {
                            this._sharedStrings = XlsxJsonHelper.toList(this.sharedStrings, "si");
                        }
                        try {
                            int n = Integer.parseInt((String)v);
                            Map si = (Map)this._sharedStrings.get(n);
                            if (si.containsKey("r") || si.containsKey("rPh")) {
                                return new XlsxRichTextExtractor(si);
                            }
                            return XlsxJsonHelper.toValue(si, "t");
                        }
                        catch (NumberFormatException e) {
                            return v;
                        }
                    }
                    return v;
                }
                return v;
            }
            return null;
        }
    }

    public static class XlsxSpanExtractor {
        private int _first;
        private int _last;

        public XlsxSpanExtractor(String jsonMap) {
            String[] args = jsonMap.split(":");
            this._first = Integer.parseInt(args[0]);
            this._last = Integer.parseInt(args[args.length - 1]);
        }

        public int getFirst() {
            return this._first;
        }

        public int getLast() {
            return this._last;
        }
    }

    public static class XlsxRowExtractor {
        final Row jsonMap;
        final Map sharedStrings;
        final Map calcChain;

        public XlsxRowExtractor(Row jsonMap, Map sharedStrings, Map calcChain) {
            this.jsonMap = jsonMap;
            this.sharedStrings = sharedStrings;
            this.calcChain = calcChain;
        }

        public Boolean isCollapsed() {
            return XlsxJsonHelper.toBoolean(this.jsonMap.get("collapsed"), null);
        }

        public Boolean isCustomFormat() {
            return XlsxJsonHelper.toBoolean(this.jsonMap.get("customFormat"), null);
        }

        public Boolean isCustomHeight() {
            return XlsxJsonHelper.toBoolean(this.jsonMap.get("customHeight"), null);
        }

        public Boolean isHidden() {
            return XlsxJsonHelper.toBoolean(this.jsonMap.get("hidden"), null);
        }

        public int getIndex() {
            return Integer.parseInt((String)this.jsonMap.get("r")) - 1;
        }

        public Number getOutlineLevel() {
            Object outlineLevel = this.jsonMap.get("outlineLevel");
            return outlineLevel != null ? Double.valueOf(Double.parseDouble((String)outlineLevel)) : null;
        }

        public Boolean isPhonetic() {
            return XlsxJsonHelper.toBoolean(this.jsonMap.get("ph"), null);
        }

        public float getRowHeight() {
            Object ht = this.jsonMap.get("ht");
            return ht != null ? Float.parseFloat((String)ht) : -1.0f;
        }

        public XlsxSpanExtractor getSpans() {
            Object spans = this.jsonMap.get("spans");
            return spans instanceof String ? new XlsxSpanExtractor((String)spans) : null;
        }

        public int getStyle() {
            Object s = this.jsonMap.get("s");
            return s != null ? Integer.parseInt((String)s) : -1;
        }

        public Boolean isThickBot() {
            return XlsxJsonHelper.toBoolean(this.jsonMap.get("thickBot"), null);
        }

        public Boolean isThickTop() {
            return XlsxJsonHelper.toBoolean(this.jsonMap.get("thickTop"), null);
        }

        public List<XlsxCellExtractor> getCells() {
            JSONArray<JSONAware> cells = this.jsonMap.getCells();
            if (cells != null) {
                return cells.stream().map(d -> new XlsxCellExtractor((Cell)d, this.sharedStrings, this.calcChain)).collect(Collectors.toList());
            }
            return Collections.EMPTY_LIST;
        }
    }

    public static class XlsxSheetProtectionExtractor {
        private final Map jsonMap;

        public XlsxSheetProtectionExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public String getPassword() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "password");
        }

        public String getHashValue() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "hashValue");
        }

        public String getSpinCount() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "spinCount");
        }

        public String getSaltValue() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "saltValue");
        }

        public String getAlgName() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "algorithmName");
        }

        public boolean isSheet() {
            return XlsxJsonHelper.toBool(this.jsonMap, "sheet", false);
        }

        public boolean isObjects() {
            return this.isSheet() && XlsxJsonHelper.toBool(this.jsonMap, "objects", false) == false;
        }

        public boolean isScenarios() {
            return this.isSheet() && XlsxJsonHelper.toBool(this.jsonMap, "scenarios", false) == false;
        }

        public boolean isFormatCells() {
            return XlsxJsonHelper.toBool(this.jsonMap, "formatCells", true) == false;
        }

        public boolean isFormatColumns() {
            return XlsxJsonHelper.toBool(this.jsonMap, "formatColumns", true) == false;
        }

        public boolean isFormatRows() {
            return XlsxJsonHelper.toBool(this.jsonMap, "formatRows", true) == false;
        }

        public boolean isInsertColumns() {
            return XlsxJsonHelper.toBool(this.jsonMap, "insertColumns", true) == false;
        }

        public boolean isInsertRows() {
            return XlsxJsonHelper.toBool(this.jsonMap, "insertRows", true) == false;
        }

        public boolean isInsertHyperlinks() {
            return XlsxJsonHelper.toBool(this.jsonMap, "insertHyperlinks", true) == false;
        }

        public boolean isDeleteColumns() {
            return XlsxJsonHelper.toBool(this.jsonMap, "deleteColumns", true) == false;
        }

        public boolean isDeleteRows() {
            return XlsxJsonHelper.toBool(this.jsonMap, "deleteRows", true) == false;
        }

        public boolean isSelectLockedCells() {
            return XlsxJsonHelper.toBool(this.jsonMap, "selectLockedCells", false) == false;
        }

        public boolean isSort() {
            return XlsxJsonHelper.toBool(this.jsonMap, "sort", true) == false;
        }

        public boolean isAutoFilter() {
            return XlsxJsonHelper.toBool(this.jsonMap, "autoFilter", true) == false;
        }

        public boolean isPivotTables() {
            return XlsxJsonHelper.toBool(this.jsonMap, "pivotTables", true) == false;
        }

        public boolean isSelectUnlockedCells() {
            return XlsxJsonHelper.toBool(this.jsonMap, "selectUnlockedCells", false) == false;
        }
    }

    public static class XlsxSheetFormatPrExtractor {
        private final Map jsonMap;

        public XlsxSheetFormatPrExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public int getBaseColWidth() {
            return Optional.ofNullable(XlsxJsonHelper.toInt(this.jsonMap, "baseColWidth")).orElse(8);
        }

        public boolean isSetBaseColWidth() {
            return this.jsonMap.containsKey("baseColWidth");
        }

        public Boolean isCustomHeight() {
            return XlsxJsonHelper.toBool(this.jsonMap, "customHeight");
        }

        public Number getDefaultColWidth() {
            return XlsxJsonHelper.toNum(this.jsonMap, "defaultColWidth");
        }

        public boolean isSetDefaultColWidth() {
            return this.jsonMap.containsKey("defaultColWidth");
        }

        public float getDefaultRowHeight() {
            return Optional.ofNullable(XlsxJsonHelper.toFloat(this.jsonMap, "defaultRowHeight")).orElse(Float.valueOf(20.0f)).floatValue();
        }

        public Number getOutlineLevelCol() {
            return XlsxJsonHelper.toNum(this.jsonMap, "outlineLevelCol");
        }

        public Number getOutlineLevelRow() {
            return XlsxJsonHelper.toNum(this.jsonMap, "outlineLevelRow");
        }

        public Boolean isThickBottom() {
            return XlsxJsonHelper.toBool(this.jsonMap, "thickBottom");
        }

        public Boolean isThickTop() {
            return XlsxJsonHelper.toBool(this.jsonMap, "thickTop");
        }

        public Boolean isZeroHeight() {
            return XlsxJsonHelper.toBool(this.jsonMap, "zeroHeight");
        }
    }

    public static class XlsxOutlinePrExtractor {
        private final Map jsonMap;

        public XlsxOutlinePrExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public boolean isApplyStyles() {
            return XlsxJsonHelper.toBool(this.jsonMap, "applyStyles", false);
        }

        public boolean isSummaryBelow() {
            return XlsxJsonHelper.toBool(this.jsonMap, "summaryBelow", true);
        }

        public boolean isSummaryRight() {
            return XlsxJsonHelper.toBool(this.jsonMap, "summaryRight", true);
        }

        public boolean isShowOutlineSymbols() {
            return XlsxJsonHelper.toBool(this.jsonMap, "showOutlineSymbols", true);
        }
    }

    public static class XlsxSheetPropertiesExtractor {
        private final Map jsonMap;

        public XlsxSheetPropertiesExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public XlsxColorExtractor getTabColor() {
            return this.jsonMap.containsKey("tabColor") ? new XlsxColorExtractor((Map)this.jsonMap.get("tabColor")) : null;
        }

        public XlsxOutlinePrExtractor getOutlinePr() {
            return this.jsonMap.containsKey("outlinePr") ? new XlsxOutlinePrExtractor((Map)this.jsonMap.get("outlinePr")) : null;
        }
    }

    public static class XlsxSelectionExtractor {
        private final Map jsonMap;

        public XlsxSelectionExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public String getPane() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "pane");
        }

        public String getActiveCell() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "activeCell");
        }

        public Number getActiveCellId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "activeCellId");
        }

        public String getSqref() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "sqref");
        }
    }

    public static class XlsxPaneExtractor {
        private final Map jsonMap;

        public XlsxPaneExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public int getXSplit() {
            return Optional.ofNullable(XlsxJsonHelper.toNum(this.jsonMap, "xSplit")).orElse(0).intValue();
        }

        public int getYSplit() {
            return Optional.ofNullable(XlsxJsonHelper.toNum(this.jsonMap, "ySplit")).orElse(0).intValue();
        }

        public String getTopLeftCell() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "topLeftCell");
        }

        public String getActivePane() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "activePane");
        }

        public String getState() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "state");
        }
    }

    public static class XlsxSheetViewExtractor {
        private final Map jsonMap;

        public XlsxSheetViewExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public Boolean isWindowProtection() {
            return XlsxJsonHelper.toBool(this.jsonMap, "windowProtection");
        }

        public Boolean isShowFormulas() {
            return XlsxJsonHelper.toBool(this.jsonMap, "showFormulas");
        }

        public Boolean isShowGridLines() {
            return XlsxJsonHelper.toBool(this.jsonMap, "showGridLines");
        }

        public Boolean isShowRowColHeaders() {
            return XlsxJsonHelper.toBool(this.jsonMap, "showRowColHeaders");
        }

        public Boolean isShowZeros() {
            return XlsxJsonHelper.toBool(this.jsonMap, "showZeros");
        }

        public Boolean isRightToLeft() {
            return XlsxJsonHelper.toBool(this.jsonMap, "rightToLeft");
        }

        public Boolean isTabSelected() {
            Boolean tabSelected = XlsxJsonHelper.toBool(this.jsonMap, "tabSelected");
            if (tabSelected == null) {
                return Boolean.FALSE;
            }
            return tabSelected;
        }

        public Boolean isShowRuler() {
            return XlsxJsonHelper.toBool(this.jsonMap, "showRuler");
        }

        public Boolean isShowOutlineSymbols() {
            return XlsxJsonHelper.toBool(this.jsonMap, "showOutlineSymbols");
        }

        public Boolean isDefaultGridColor() {
            return XlsxJsonHelper.toBool(this.jsonMap, "defaultGridColor");
        }

        public Boolean isShowWhiteSpace() {
            return XlsxJsonHelper.toBool(this.jsonMap, "showWhiteSpace");
        }

        public String getView() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "view");
        }

        public String getTopLeftCell() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "topLeftCell");
        }

        public Number getColorId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "colorId");
        }

        public Number getZoomScale() {
            return XlsxJsonHelper.toNum(this.jsonMap, "zoomScale");
        }

        public Number getZoomScaleNormal() {
            return XlsxJsonHelper.toNum(this.jsonMap, "zoomScaleNormal");
        }

        public Number getZoomScaleSheetLayoutView() {
            return XlsxJsonHelper.toNum(this.jsonMap, "zoomScaleSheetLayoutView");
        }

        public Number getZoomScalePageLayoutView() {
            return XlsxJsonHelper.toNum(this.jsonMap, "zoomScalePageLayoutView");
        }

        public Number getWorkbookViewId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "workbookViewId");
        }

        public XlsxPaneExtractor getPane() {
            return this.jsonMap.containsKey("pane") ? new XlsxPaneExtractor((Map)XlsxJsonHelper.$(this.jsonMap, "pane")) : null;
        }

        public List<XlsxSelectionExtractor> getSelections() {
            return XlsxJsonHelper.toList(this.jsonMap, "selection", XlsxSelectionExtractor.class);
        }
    }

    public static class XlsxSparklineExtractor {
        private final Map jsonMap;

        public XlsxSparklineExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public String getF() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "xm:f");
        }

        public String getSqref() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "xm:sqref");
        }
    }

    public static class XlsxSparklinesExtractor {
        private final Map jsonMap;

        public XlsxSparklinesExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public List<XlsxSparklineExtractor> getSparklines() {
            Object sparklines = this.jsonMap.get("x14:sparkline");
            if (sparklines instanceof List) {
                return ((List)sparklines).stream().map(XlsxSparklineExtractor::new).collect(Collectors.toList());
            }
            if (sparklines instanceof Map) {
                return Converter.asList(new XlsxSparklineExtractor((Map)sparklines));
            }
            return Collections.EMPTY_LIST;
        }
    }

    public static class XlsxSparklineGroupExtractor {
        private final Map jsonMap;

        public XlsxSparklineGroupExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public String getType() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "type");
        }

        public XlsxSparklinesExtractor getSparklines() {
            if (this.jsonMap.containsKey("x14:sparklines")) {
                return new XlsxSparklinesExtractor((Map)this.jsonMap.get("x14:sparklines"));
            }
            return null;
        }

        public Boolean isMarkersVisible() {
            return XlsxJsonHelper.toBool(this.jsonMap, "markers");
        }

        public Boolean isNegativeVisible() {
            return XlsxJsonHelper.toBool(this.jsonMap, "negative");
        }

        public Boolean isFirstVisible() {
            return XlsxJsonHelper.toBool(this.jsonMap, "first");
        }

        public Boolean isLastVisible() {
            return XlsxJsonHelper.toBool(this.jsonMap, "last");
        }

        public Boolean isHighVisible() {
            return XlsxJsonHelper.toBool(this.jsonMap, "high");
        }

        public Boolean isLowVisible() {
            return XlsxJsonHelper.toBool(this.jsonMap, "low");
        }

        public XlsxColorExtractor getColorSeries() {
            return new XlsxColorExtractor((Map)XlsxJsonHelper.$(this.jsonMap, "x14:colorSeries"));
        }

        public XlsxColorExtractor getColorMarkers() {
            return new XlsxColorExtractor((Map)XlsxJsonHelper.$(this.jsonMap, "x14:colorMarkers"));
        }

        public XlsxColorExtractor getColorNegative() {
            return new XlsxColorExtractor((Map)XlsxJsonHelper.$(this.jsonMap, "x14:colorNegative"));
        }

        public XlsxColorExtractor getColorFirst() {
            return new XlsxColorExtractor((Map)XlsxJsonHelper.$(this.jsonMap, "x14:colorFirst"));
        }

        public XlsxColorExtractor getColorLast() {
            return new XlsxColorExtractor((Map)XlsxJsonHelper.$(this.jsonMap, "x14:colorLast"));
        }

        public XlsxColorExtractor getColorHigh() {
            return new XlsxColorExtractor((Map)XlsxJsonHelper.$(this.jsonMap, "x14:colorHigh"));
        }

        public XlsxColorExtractor getColorLow() {
            return new XlsxColorExtractor((Map)XlsxJsonHelper.$(this.jsonMap, "x14:colorLow"));
        }
    }

    public static class XlsxSparklineGroupsExtractor {
        private final Map jsonMap;

        public XlsxSparklineGroupsExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public List<XlsxSparklineGroupExtractor> getSparklineGroups() {
            Object sparklineGroup = this.jsonMap.get("x14:sparklineGroup");
            if (sparklineGroup instanceof List) {
                return ((List)sparklineGroup).stream().map(s -> new XlsxSparklineGroupExtractor((Map)s)).collect(Collectors.toList());
            }
            if (sparklineGroup instanceof Map) {
                return Converter.asList(new XlsxSparklineGroupExtractor((Map)sparklineGroup));
            }
            return Collections.EMPTY_LIST;
        }
    }

    public static class XlsxExtExtractor {
        private final Map jsonMap;

        public XlsxExtExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public XlsxSparklineGroupsExtractor getSparklineGroups() {
            if (this.jsonMap.containsKey("x14:sparklineGroups")) {
                return new XlsxSparklineGroupsExtractor((Map)this.jsonMap.get("x14:sparklineGroups"));
            }
            return null;
        }

        public List<XlsxExtConditionalFormattingExtractor> getConditionalFormattings() {
            return XlsxJsonHelper.toList((Map)this.jsonMap.get("x14:conditionalFormattings"), "x14:conditionalFormatting", XlsxExtConditionalFormattingExtractor.class);
        }

        public List<XlsxExtDataValidationExtractor> getDataValidations() {
            return XlsxJsonHelper.toList((Map)this.jsonMap.get("x14:dataValidations"), "x14:dataValidation", XlsxExtDataValidationExtractor.class);
        }
    }

    public static class XlsxExtLstExtractor {
        private final Map jsonMap;

        public XlsxExtLstExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public List<XlsxExtExtractor> getExt() {
            Object ext = this.jsonMap.get("ext");
            if (ext instanceof List) {
                return ((List)ext).stream().map(s -> new XlsxExtExtractor((Map)s)).collect(Collectors.toList());
            }
            if (ext instanceof Map) {
                return Converter.asList(new XlsxExtExtractor((Map)ext));
            }
            return Collections.EMPTY_LIST;
        }
    }

    public static class XlsxSheetExtractor {
        final Map workbookJson;
        private final Map jsonMap;
        final Map sharedStrings;
        final Map worksheetJson;
        final Map calcChain;
        private String _sheetPath;
        private Map sheetRefs;

        public XlsxSheetExtractor(Map workbookJson, Map jsonMap, Map sharedStrings, Map calcChain) {
            this.workbookJson = workbookJson;
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
            this.sharedStrings = sharedStrings;
            this.calcChain = calcChain;
            Map worksheetJson = (Map)jsonMap.get("worksheet");
            this.worksheetJson = worksheetJson == null ? Collections.EMPTY_MAP : worksheetJson;
        }

        public String getSheetPath() {
            if (this._sheetPath == null) {
                List workbookRels = (List)XlsxJsonHelper.$(this.workbookJson, "xl/_rels/workbook.xml.rels", "Relationships", "Relationship");
                LinkedHashMap idMap = new LinkedHashMap();
                workbookRels.forEach(rel -> idMap.put((String)rel.get("Id"), (String)rel.get("Target")));
                String rid = (String)this.jsonMap.get("r:id");
                String[] array = ((String)idMap.get(rid)).split("/");
                this._sheetPath = array[array.length - 1];
            }
            return this._sheetPath;
        }

        public List<XlsxColExtractor> getCols() {
            return XlsxJsonHelper.toList((Map)XlsxJsonHelper.$(this.worksheetJson, "cols"), "col", XlsxColExtractor.class);
        }

        public String getName() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "name");
        }

        public List<XlsxRowExtractor> getRows() {
            SheetData sheetData = (SheetData)XlsxJsonHelper.$(this.worksheetJson, "sheetData");
            if (sheetData != null) {
                Object rows = sheetData.get("row");
                if (rows instanceof List) {
                    return ((List)rows).stream().map(r -> new XlsxRowExtractor((Row)r, this.sharedStrings, this.calcChain)).collect(Collectors.toList());
                }
                if (rows != null) {
                    return Converter.asList(new XlsxRowExtractor((Row)rows, this.sharedStrings, this.calcChain));
                }
            }
            return Collections.EMPTY_LIST;
        }

        public List<XlsxTableExtractor> getTables() {
            String sheetPath = this.getSheetPath();
            Map sheetRels = this.getSheetRefs();
            if (sheetRels != null) {
                Map<String, String> tableRels = XlsxExtractor._getSheetTableRels(sheetPath, this.workbookJson);
                Object tableParts = XlsxJsonHelper.$(this.worksheetJson, "tableParts", "tablePart");
                if (tableParts != null) {
                    Map rel;
                    if (tableParts instanceof List) {
                        return ((List)tableParts).stream().map(part -> {
                            Map rel;
                            String rid = (String)part.get("r:id");
                            String tableRel = tableRels.get(rid).toString();
                            String tablePath = XlsxExtractor._getPath(tableRel, "xl");
                            String tableName = Converter.getLast(tablePath.split("/"));
                            Map rels = (Map)XlsxJsonHelper.$(this.workbookJson, "xl/tables/_rels/" + tableName + ".rels");
                            String queryTablePath = null;
                            if (rels != null && "http://schemas.openxmlformats.org/officeDocument/2006/relationships/queryTable".equals((rel = (Map)XlsxJsonHelper.$(rels, "Relationships", "Relationship")).get("Type"))) {
                                queryTablePath = (String)rel.get("Target");
                            }
                            return new XlsxTableExtractor((Map)XlsxJsonHelper.$(this.workbookJson, tablePath, "table"), queryTablePath != null ? (Map)XlsxJsonHelper.$(this.workbookJson, XlsxExtractor._getPath(queryTablePath, "xl")) : null);
                        }).collect(Collectors.toList());
                    }
                    String tableRel = tableRels.values().iterator().next().toString();
                    String tablePath = XlsxExtractor._getPath(tableRel, "xl");
                    String tableName = Converter.getLast(tablePath.split("/"));
                    Map rels = (Map)XlsxJsonHelper.$(this.workbookJson, "xl/tables/_rels/" + tableName + ".rels");
                    String queryTablePath = null;
                    if (rels != null && "http://schemas.openxmlformats.org/officeDocument/2006/relationships/queryTable".equals((rel = (Map)XlsxJsonHelper.$(rels, "Relationships", "Relationship")).get("Type"))) {
                        queryTablePath = (String)rel.get("Target");
                    }
                    return Converter.asList(new XlsxTableExtractor((Map)XlsxJsonHelper.$(this.workbookJson, tablePath, "table"), queryTablePath != null ? (Map)XlsxJsonHelper.$(this.workbookJson, XlsxExtractor._getPath(queryTablePath, "xl")) : null));
                }
            }
            return Collections.EMPTY_LIST;
        }

        public int getId() {
            String rId = (String)XlsxJsonHelper.toValue(this.jsonMap, "r:id");
            if (rId != null) {
                return Integer.parseInt(rId.substring(3));
            }
            return -1;
        }

        public String getSheetId() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "sheetId");
        }

        public String getState() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "state");
        }

        public String getDimension() {
            return XlsxJsonHelper.toStringValue((Map)XlsxJsonHelper.$(this.worksheetJson, "dimension"), "ref");
        }

        public XlsxDataValidationsExtractor getDataValidations() {
            Map dataValidations = (Map)this.worksheetJson.get("dataValidations");
            if (dataValidations != null) {
                return new XlsxDataValidationsExtractor(dataValidations);
            }
            return null;
        }

        public XlsxSheetProtectionExtractor getSheetProtection() {
            Map sheetProtection = (Map)XlsxJsonHelper.$(this.worksheetJson, "sheetProtection");
            if (sheetProtection != null) {
                return new XlsxSheetProtectionExtractor(sheetProtection);
            }
            return null;
        }

        public XlsxAutoFilterExtractor getAutoFilter() {
            Map autoFilter = (Map)this.worksheetJson.get("autoFilter");
            if (autoFilter != null) {
                return new XlsxAutoFilterExtractor(autoFilter);
            }
            return null;
        }

        public List<XlsxConditionalFormattingExtractor> getConditionalFormattings() {
            return XlsxJsonHelper.toList(this.worksheetJson, "conditionalFormatting", XlsxConditionalFormattingExtractor.class);
        }

        public List<XlsxHyperlinkExtractor> getHyperlinks() {
            Object hyperlink;
            String sheetPath = this.getSheetPath();
            Map sheetRels = (Map)XlsxJsonHelper.$(this.workbookJson, "xl/worksheets/_rels/" + sheetPath + ".rels");
            Map hyperlinkRels = null;
            if (sheetRels != null) {
                Map rels;
                Object relations = XlsxJsonHelper.$(sheetRels, "Relationships", "Relationship");
                if (relations instanceof List) {
                    hyperlinkRels = ((List)relations).stream().filter(r -> "http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink".equals(r.get("Type"))).collect(Collectors.toMap(r -> r.get("Id"), r -> r.get("Target")));
                } else if (relations instanceof Map && "http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink".equals((rels = (Map)relations).get("Type"))) {
                    hyperlinkRels = Converter.asMap(rels.get("Id"), rels.get("Target"));
                }
            }
            if ((hyperlink = XlsxJsonHelper.$(this.worksheetJson, "hyperlinks", "hyperlink")) != null) {
                if (hyperlink instanceof List) {
                    Map finalHyperlinkRels = hyperlinkRels;
                    return ((List)hyperlink).stream().map(e -> {
                        if (e.containsKey("r:id")) {
                            e.put("r:id", XlsxJsonHelper.$(finalHyperlinkRels, (String)e.get("r:id")));
                        }
                        return new XlsxHyperlinkExtractor((Map)e);
                    }).collect(Collectors.toList());
                }
                if (hyperlink instanceof Map) {
                    Map hMap = (Map)hyperlink;
                    String rId = (String)hMap.get("r:id");
                    if (rId != null) {
                        hMap.put("r:id", hyperlinkRels.get(rId));
                    }
                    return Converter.asList(new XlsxHyperlinkExtractor(hMap));
                }
            }
            return Collections.EMPTY_LIST;
        }

        public List<XlsxSheetViewExtractor> getSheetViews() {
            Object sheetView = XlsxJsonHelper.$(this.jsonMap, "worksheet", "sheetViews", "sheetView");
            if (sheetView != null) {
                if (sheetView instanceof List) {
                    return ((List)sheetView).stream().map(e -> new XlsxSheetViewExtractor((Map)e)).collect(Collectors.toList());
                }
                return Converter.asList(new XlsxSheetViewExtractor((Map)sheetView));
            }
            return Collections.EMPTY_LIST;
        }

        public List<String> getMergeCells() {
            Object mergeCell = XlsxJsonHelper.$(this.worksheetJson, "mergeCells", "mergeCell");
            if (mergeCell instanceof List) {
                return ((List)mergeCell).stream().map(e -> (String)e.get("ref")).collect(Collectors.toList());
            }
            if (mergeCell instanceof Map) {
                return Converter.asList((String)((Map)mergeCell).get("ref"));
            }
            return Collections.EMPTY_LIST;
        }

        public XlsxSheetFormatPrExtractor getSheetFormatPr() {
            Map sheetFormatPr = (Map)XlsxJsonHelper.$(this.worksheetJson, "sheetFormatPr");
            if (sheetFormatPr != null) {
                return new XlsxSheetFormatPrExtractor(sheetFormatPr);
            }
            return null;
        }

        public XlsxPageMarginsExtractor getPageMargins() {
            if (this.worksheetJson.containsKey("pageMargins")) {
                return new XlsxPageMarginsExtractor((Map)this.worksheetJson.get("pageMargins"));
            }
            return null;
        }

        public XlsxPageSetupExtractor getPageSetup() {
            if (this.worksheetJson.containsKey("pageSetup")) {
                return new XlsxPageSetupExtractor((Map)this.worksheetJson.get("pageSetup"));
            }
            return null;
        }

        public XlsxPrintOptionsExtractor getPrintOptions() {
            if (this.worksheetJson.containsKey("printOptions")) {
                return new XlsxPrintOptionsExtractor((Map)this.worksheetJson.get("printOptions"));
            }
            return null;
        }

        public XlsxHeaderFootersExtractor getHeaderFooter() {
            if (this.worksheetJson.containsKey("headerFooter")) {
                return new XlsxHeaderFootersExtractor((Map)this.worksheetJson.get("headerFooter"));
            }
            return null;
        }

        public int[] getColBreaks() {
            Object brk = XlsxJsonHelper.$(this.worksheetJson, "colBreaks", "brk");
            if (brk == null) {
                return new int[0];
            }
            if (brk instanceof List) {
                return ((List)brk).stream().mapToInt(b -> XlsxJsonHelper.toInt(b, "id", 0) - 1).toArray();
            }
            Map data = (Map)brk;
            return new int[]{XlsxJsonHelper.toInt(data, "id", 0) - 1};
        }

        public int[] getRowBreaks() {
            Object brk = XlsxJsonHelper.$(this.worksheetJson, "rowBreaks", "brk");
            if (brk == null) {
                return new int[0];
            }
            if (brk instanceof List) {
                return ((List)brk).stream().mapToInt(b -> XlsxJsonHelper.toInt(b, "id", 0) - 1).toArray();
            }
            Map data = (Map)brk;
            return new int[]{XlsxJsonHelper.toInt(data, "id", 0) - 1};
        }

        public XlsxCommentsExtractor getComments() {
            Map<String, String> commentsRels;
            Map sheetRels = this.getSheetRefs();
            if (sheetRels != null && (commentsRels = XlsxExtractor._getSheetCommentsRels(this.getSheetPath(), this.workbookJson)) != null && !commentsRels.isEmpty()) {
                String commentRel = commentsRels.values().iterator().next();
                return new XlsxCommentsExtractor((Map)XlsxJsonHelper.$(this.workbookJson, XlsxExtractor._getPath(commentRel, "xl"), "comments"));
            }
            return null;
        }

        public Map getSheetRefs() {
            if (this.sheetRefs == null) {
                this.sheetRefs = (Map)XlsxJsonHelper.$(this.workbookJson, "xl/worksheets/_rels/" + this.getSheetPath() + ".rels");
            }
            return this.sheetRefs;
        }

        public XlsxDrawingsExtractor getDrawings() {
            Map<String, String> drawingRels;
            String sheetPath = this.getSheetPath();
            Map sheetRels = this.getSheetRefs();
            if (sheetRels != null && (drawingRels = XlsxExtractor._getSheetDrawingRels(sheetPath, this.workbookJson)) != null && !drawingRels.isEmpty()) {
                String drv = drawingRels.values().iterator().next();
                String filePath = XlsxExtractor._getPath(drv, "xl");
                String fileName = Converter.getLast(drv.split("/"));
                Map drawingRefs = (Map)XlsxJsonHelper.$(this.workbookJson, "xl/drawings/_rels/" + fileName + ".rels");
                Map wsDr = (Map)XlsxJsonHelper.$(this.workbookJson, filePath, "xdr:wsDr");
                return new XlsxDrawingsExtractor(this.workbookJson, drawingRefs, wsDr);
            }
            return null;
        }

        public XlsxVmlDrawingExtractor getLegacyDrawing() {
            Map<String, String> vmlDrawingRels;
            String sheetPath = this.getSheetPath();
            Map sheetRels = this.getSheetRefs();
            if (sheetRels != null && (vmlDrawingRels = XlsxExtractor._getSheetVmlDrawingRels(sheetPath, this.workbookJson)) != null && !vmlDrawingRels.isEmpty()) {
                String vmlDrawingRel = vmlDrawingRels.values().iterator().next();
                String filePath = XlsxExtractor._getPath(vmlDrawingRel, "xl");
                Map vmlJson = (Map)XlsxJsonHelper.$(this.workbookJson, filePath);
                Map vImageData = (Map)XlsxJsonHelper.$x(vmlJson, "xml/v:shape/v:imagedata");
                if (vImageData != null) {
                    LinkedList<Map> relations;
                    Object relationsObj = XlsxJsonHelper.$(this.workbookJson, "xl/drawings/_rels/" + Converter.getLast(filePath.split("/")) + ".rels", "Relationships", "Relationship");
                    if (relationsObj instanceof JSONObject) {
                        relations = new LinkedList<Map>();
                        relations.add((Map)relationsObj);
                    } else {
                        relations = (LinkedList<Map>)relationsObj;
                    }
                    Map relation = null;
                    if (relations != null) {
                        relation = relations.stream().filter(entry -> Objects.equals(entry.get("Id"), vImageData.get("o:relid"))).findFirst().get();
                    }
                    if (relation == null) {
                        throw new IllegalStateException("vmlDrawing relation should not be null! [xl/drawings/_rels/" + filePath + ".rels]");
                    }
                    String relationTarget = relation.get("Target").toString();
                    String imagePath = XlsxExtractor._getPath(relationTarget, "xl");
                    return new XlsxVmlDrawingExtractor(vmlJson, (byte[])this.workbookJson.get(imagePath));
                }
                return new XlsxVmlDrawingExtractor(vmlJson, null);
            }
            return null;
        }

        public XlsxSheetPropertiesExtractor getSheetPr() {
            if (this.worksheetJson.containsKey("sheetPr")) {
                return new XlsxSheetPropertiesExtractor((Map)this.worksheetJson.get("sheetPr"));
            }
            return null;
        }

        public Map getAlternateContent() {
            return (Map)XlsxJsonHelper.$(this.worksheetJson, "mc:AlternateContent");
        }

        public XlsxExtLstExtractor getExtLst() {
            if (this.worksheetJson.containsKey("extLst")) {
                return new XlsxExtLstExtractor((Map)this.worksheetJson.get("extLst"));
            }
            return null;
        }
    }

    public static class XlsxWorkbookProtectionExtractor {
        private final Map jsonMap;

        public XlsxWorkbookProtectionExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public Boolean isLockStructure() {
            return XlsxJsonHelper.toBool(this.jsonMap, "lockStructure");
        }

        public Boolean isLockWindows() {
            return XlsxJsonHelper.toBool(this.jsonMap, "lockWindows");
        }

        public String getAlgName() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "workbookAlgorithmName");
        }

        public String getHashValue() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "workbookHashValue");
        }

        public String getSaltValue() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "workbookSaltValue");
        }

        public String getSpinCount() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "workbookSpinCount");
        }
    }

    public static class XlsxBorderPrExtractor {
        public static XlsxBorderPrExtractor EMPTY = new XlsxBorderPrExtractor(Collections.EMPTY_MAP);
        private final Map jsonMap;

        public XlsxBorderPrExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public XlsxColorExtractor getColor() {
            return this.jsonMap.containsKey("color") ? new XlsxColorExtractor((Map)this.jsonMap.get("color")) : null;
        }

        public String getStyle() {
            return (String)this.jsonMap.get("style");
        }
    }

    public static class XlsxBorderExtractor {
        private final Map jsonMap;

        public XlsxBorderExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public XlsxBorderPrExtractor getBottom() {
            if (this.jsonMap.containsKey("bottom")) {
                Object data = this.jsonMap.get("bottom");
                return data == null ? XlsxBorderPrExtractor.EMPTY : new XlsxBorderPrExtractor((Map)data);
            }
            return null;
        }

        public boolean isDiagonalUp() {
            return XlsxJsonHelper.toBool(this.jsonMap, "diagonalUp", false);
        }

        public XlsxBorderPrExtractor getDiagonal() {
            if (this.jsonMap.containsKey("diagonal")) {
                Object data = this.jsonMap.get("diagonal");
                return data == null ? XlsxBorderPrExtractor.EMPTY : new XlsxBorderPrExtractor((Map)data);
            }
            return null;
        }

        public boolean isDiagonalDown() {
            return XlsxJsonHelper.toBool(this.jsonMap, "diagonalDown", false);
        }

        public XlsxBorderPrExtractor getHorizontal() {
            if (this.jsonMap.containsKey("horizontal")) {
                Object data = this.jsonMap.get("horizontal");
                return data == null ? XlsxBorderPrExtractor.EMPTY : new XlsxBorderPrExtractor((Map)data);
            }
            return null;
        }

        public XlsxBorderPrExtractor getLeft() {
            if (this.jsonMap.containsKey("left")) {
                Object data = this.jsonMap.get("left");
                return data == null ? XlsxBorderPrExtractor.EMPTY : new XlsxBorderPrExtractor((Map)data);
            }
            return null;
        }

        public boolean isOutline() {
            return XlsxJsonHelper.toBool(this.jsonMap, "outline", false);
        }

        public XlsxBorderPrExtractor getRight() {
            if (this.jsonMap.containsKey("right")) {
                Object data = this.jsonMap.get("right");
                return data == null ? XlsxBorderPrExtractor.EMPTY : new XlsxBorderPrExtractor((Map)data);
            }
            return null;
        }

        public XlsxBorderPrExtractor getTop() {
            if (this.jsonMap.containsKey("top")) {
                Object data = this.jsonMap.get("top");
                return data == null ? XlsxBorderPrExtractor.EMPTY : new XlsxBorderPrExtractor((Map)data);
            }
            return null;
        }

        public XlsxBorderPrExtractor getVertical() {
            if (this.jsonMap.containsKey("vertical")) {
                Object data = this.jsonMap.get("vertical");
                return data == null ? XlsxBorderPrExtractor.EMPTY : new XlsxBorderPrExtractor((Map)data);
            }
            return null;
        }
    }

    public static class XlsxDxfExtractor {
        private final Map jsonMap;

        public XlsxDxfExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public XlsxAlignmentExtractor getAlignment() {
            return this.jsonMap != null && this.jsonMap.get("alignment") != null ? new XlsxAlignmentExtractor((Map)this.jsonMap.get("alignment"), null) : null;
        }

        public XlsxBorderExtractor getBorder() {
            return this.jsonMap != null && this.jsonMap.get("border") != null ? new XlsxBorderExtractor((Map)this.jsonMap.get("border")) : null;
        }

        public XlsxFontExtractor getFont() {
            return this.jsonMap != null && this.jsonMap.get("font") != null ? new XlsxFontExtractor((Map)this.jsonMap.get("font")) : null;
        }

        public XlsxNumFmtExtractor getNumFmt() {
            return this.jsonMap != null && this.jsonMap.get("numFmt") != null ? new XlsxNumFmtExtractor((Map)this.jsonMap.get("numFmt")) : null;
        }

        public XlsxFillExtractor getFill() {
            return this.jsonMap != null && this.jsonMap.get("fill") != null ? XlsxFillExtractor.getInstance((Map)this.jsonMap.get("fill")) : null;
        }

        public XlsxProtectionExtractor getProtection() {
            return this.jsonMap != null && this.jsonMap.get("protection") != null ? new XlsxProtectionExtractor((Map)this.jsonMap.get("protection")) : null;
        }
    }

    public static class XlsxExtDxfExtractor
    extends XlsxDxfExtractor {
        public XlsxExtDxfExtractor(Map jsonMap) {
            super(jsonMap);
        }
    }

    public static class XlsxAlignmentExtractor {
        private final Map jsonMap;
        private XlsxXfExtractor self;

        public XlsxAlignmentExtractor(Map jsonMap, XlsxXfExtractor self) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
            this.self = self;
        }

        public String getHorizontal() {
            if (this.self != null) {
                XlsxAlignmentExtractor align = this.self.getAlignment();
                if (align != null && align.jsonMap.containsKey("horizontal")) {
                    return align.getHorizontal();
                }
                return null;
            }
            return (String)this.jsonMap.get("horizontal");
        }

        public short getIndent() {
            if (this.self != null) {
                XlsxAlignmentExtractor align = this.self.getAlignment();
                if (align != null && align.jsonMap.containsKey("indent")) {
                    return align.getIndent();
                }
                return 0;
            }
            return Optional.ofNullable(XlsxJsonHelper.toNum(this.jsonMap, "indent")).orElse(0).shortValue();
        }

        public Boolean isJustifyLastLine() {
            if (this.self != null) {
                XlsxAlignmentExtractor align = this.self.getAlignment();
                if (align != null && align.jsonMap.containsKey("justifyLastLine")) {
                    return align.isJustifyLastLine();
                }
                return false;
            }
            return XlsxJsonHelper.toBool(this.jsonMap, "justifyLastLine", false);
        }

        public short getReadingOrder() {
            if (this.self != null) {
                XlsxAlignmentExtractor align = this.self.getAlignment();
                if (align != null && align.jsonMap.containsKey("readingOrder")) {
                    return align.getReadingOrder();
                }
                return 0;
            }
            return Optional.ofNullable(XlsxJsonHelper.toNum(this.jsonMap, "readingOrder")).orElse(0).shortValue();
        }

        public short getRelativeIndent() {
            if (this.self != null) {
                XlsxAlignmentExtractor align = this.self.getAlignment();
                if (align != null && align.jsonMap.containsKey("relativeIndent")) {
                    return align.getRelativeIndent();
                }
                return 0;
            }
            return Optional.ofNullable(XlsxJsonHelper.toNum(this.jsonMap, "relativeIndent")).orElse(0).shortValue();
        }

        public Boolean isShrinkToFit() {
            if (this.self != null) {
                XlsxAlignmentExtractor align = this.self.getAlignment();
                if (align != null && align.jsonMap.containsKey("shrinkToFit")) {
                    return align.isShrinkToFit();
                }
                return false;
            }
            return XlsxJsonHelper.toBool(this.jsonMap, "shrinkToFit", false);
        }

        public short getTextRotation() {
            if (this.self != null) {
                XlsxAlignmentExtractor align = this.self.getAlignment();
                if (align != null && align.jsonMap.containsKey("textRotation")) {
                    return align.getTextRotation();
                }
                return 0;
            }
            return Optional.ofNullable(XlsxJsonHelper.toNum(this.jsonMap, "textRotation")).orElse(0).shortValue();
        }

        public String getVertical() {
            if (this.self != null) {
                XlsxAlignmentExtractor align = this.self.getAlignment();
                if (align != null && align.jsonMap.containsKey("vertical")) {
                    return align.getVertical();
                }
                if (this.self.getApplyAlignment().booleanValue()) {
                    return null;
                }
            }
            if (this.jsonMap != null) {
                return (String)this.jsonMap.get("vertical");
            }
            return null;
        }

        public Boolean isWrapText() {
            if (this.self != null) {
                XlsxAlignmentExtractor align = this.self.getAlignment();
                if (align != null && align.jsonMap.containsKey("wrapText")) {
                    return align.isWrapText();
                }
                return false;
            }
            return XlsxJsonHelper.toBool(this.jsonMap, "wrapText", false);
        }
    }

    public static class XlsxSchemeClrExtractor {
        private final Map jsonMap;
        private final Map _schemeClr;
        private final Map _srgbClr;

        public XlsxSchemeClrExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
            this._schemeClr = (Map)XlsxJsonHelper.$(jsonMap, "a:schemeClr");
            this._srgbClr = (Map)XlsxJsonHelper.$(jsonMap, "a:srgbClr");
        }

        public boolean isSchemeClr() {
            return this._schemeClr != null;
        }

        public boolean isSrgbClr() {
            return this._srgbClr != null;
        }

        public String getVal() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "val");
        }

        public String getColorVal() {
            if (this.isSchemeClr()) {
                return XlsxJsonHelper.toStringValue(this.jsonMap, "a:schemeClr");
            }
            if (this.isSrgbClr()) {
                return XlsxJsonHelper.toStringValue(this.jsonMap, "a:srgbClr");
            }
            return null;
        }

        public Map getColor() {
            return this._schemeClr != null ? this._schemeClr : this._srgbClr;
        }

        public boolean isModified() {
            return this._schemeClr != null ? this._schemeClr.size() > 1 : (this._srgbClr != null ? this._srgbClr.size() > 1 : false);
        }

        public Number getTint() {
            return XlsxJsonHelper.toNum(this.isSchemeClr() ? this._schemeClr : this._srgbClr, "a:tint");
        }

        public Number getShade() {
            return XlsxJsonHelper.toNum(this.isSchemeClr() ? this._schemeClr : this._srgbClr, "a:shade");
        }

        public Number getAlpha() {
            return XlsxJsonHelper.toNum(this.isSchemeClr() ? this._schemeClr : this._srgbClr, "a:alpha");
        }

        public Number getHueMod() {
            return XlsxJsonHelper.toNum(this.isSchemeClr() ? this._schemeClr : this._srgbClr, "a:hueMod");
        }

        public Number getSat() {
            return XlsxJsonHelper.toNum(this.isSchemeClr() ? this._schemeClr : this._srgbClr, "a:sat");
        }

        public Number getSatOff() {
            return XlsxJsonHelper.toNum(this.isSchemeClr() ? this._schemeClr : this._srgbClr, "a:satOff");
        }

        public Number getSatMod() {
            return XlsxJsonHelper.toNum(this.isSchemeClr() ? this._schemeClr : this._srgbClr, "a:satMod");
        }

        public Number getLum() {
            return XlsxJsonHelper.toNum(this.isSchemeClr() ? this._schemeClr : this._srgbClr, "a:lum");
        }

        public Number getLumOff() {
            return XlsxJsonHelper.toNum(this.isSchemeClr() ? this._schemeClr : this._srgbClr, "a:lumOff");
        }

        public Number getLumMod() {
            return XlsxJsonHelper.toNum(this.isSchemeClr() ? this._schemeClr : this._srgbClr, "a:lumMod");
        }
    }

    public static class XlsxColorExtractor {
        private final Map jsonMap;

        public XlsxColorExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public Boolean isAuto() {
            return XlsxJsonHelper.toBool(this.jsonMap, "auto");
        }

        public Number getIndexed() {
            return XlsxJsonHelper.toNum(this.jsonMap, "indexed");
        }

        public Number getTheme() {
            return XlsxJsonHelper.toNum(this.jsonMap, "theme");
        }

        public Number getTint() {
            return XlsxJsonHelper.toNum(this.jsonMap, "tint");
        }

        public String getRgb() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "rgb");
        }
    }

    public static class XlsxProtectionExtractor {
        private final Map jsonMap;
        private static final boolean defaultHidden = false;
        private static final boolean defaultLocked = true;

        public XlsxProtectionExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public Boolean isHidden() {
            return this.jsonMap != null ? XlsxJsonHelper.toBool(this.jsonMap, "hidden", false) : false;
        }

        public Boolean isLocked() {
            return this.jsonMap != null ? XlsxJsonHelper.toBool(this.jsonMap, "locked", true) : true;
        }
    }

    public static class XlsxXfExtractor {
        private final Map jsonMap;

        public XlsxXfExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public Number getXfId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "xfId");
        }

        public Boolean isSetApplyAlignment() {
            return this.jsonMap.containsKey("applyAlignment");
        }

        public Boolean getApplyAlignment() {
            return XlsxJsonHelper.toBool(this.jsonMap, "applyAlignment", false);
        }

        public Boolean isSetAlignment() {
            return this.jsonMap.containsKey("alignment");
        }

        public XlsxAlignmentExtractor getAlignment() {
            return this.jsonMap.containsKey("alignment") ? new XlsxAlignmentExtractor((Map)this.jsonMap.get("alignment"), null) : null;
        }

        public XlsxBorderExtractor getBorder() {
            return this.jsonMap.containsKey("border") ? new XlsxBorderExtractor((Map)this.jsonMap.get("border")) : null;
        }

        public Number getBorderId() {
            return this.jsonMap.containsKey("borderId") ? (Number)XlsxJsonHelper.toNum(this.jsonMap, "borderId") : (Number)null;
        }

        public XlsxFillExtractor getFill() {
            return this.jsonMap.containsKey("fill") ? XlsxFillExtractor.getInstance((Map)this.jsonMap.get("fill")) : null;
        }

        public Number getFillId() {
            return this.jsonMap.containsKey("fillId") ? (Number)XlsxJsonHelper.toNum(this.jsonMap, "fillId") : (Number)null;
        }

        public XlsxFontExtractor getFont() {
            return this.jsonMap.containsKey("font") ? new XlsxFontExtractor((Map)this.jsonMap.get("font")) : null;
        }

        public Number getFontId() {
            return this.jsonMap.containsKey("fontId") ? (Number)XlsxJsonHelper.toNum(this.jsonMap, "fontId") : (Number)null;
        }

        public XlsxNumFmtExtractor getNumFmt() {
            return this.jsonMap.containsKey("numFmt") ? new XlsxNumFmtExtractor((Map)this.jsonMap.get("numFmt")) : null;
        }

        public Number getNumFmtId() {
            return this.jsonMap.containsKey("numFmtId") ? (Number)XlsxJsonHelper.toNum(this.jsonMap, "numFmtId") : (Number)null;
        }

        public XlsxProtectionExtractor getProtection() {
            return this.jsonMap.containsKey("protection") ? new XlsxProtectionExtractor((Map)this.jsonMap.get("protection")) : null;
        }

        public Boolean isPivotButton() {
            return XlsxJsonHelper.toBool(this.jsonMap, "pivotButton");
        }

        public Boolean isQuotePrefix() {
            return XlsxJsonHelper.toBool(this.jsonMap, "quotePrefix");
        }

        public int hashCode() {
            return this.jsonMap.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof XlsxXfExtractor) {
                return this.jsonMap.equals(((XlsxXfExtractor)obj).jsonMap);
            }
            return false;
        }
    }

    public static class XlsxCellXfExtractor
    extends XlsxXfExtractor {
        private XlsxXfExtractor self;
        private XlsxXfExtractor parentXf;

        public XlsxCellXfExtractor(XlsxXfExtractor self, XlsxXfExtractor parentXf) {
            super(parentXf.jsonMap);
            this.parentXf = parentXf;
            this.self = self;
        }

        public Number getParentXfId() {
            return super.getXfId();
        }

        @Override
        public Number getXfId() {
            return this.self.getXfId();
        }

        @Override
        public XlsxAlignmentExtractor getAlignment() {
            if (this.self.isSetAlignment() != null || this.parentXf.isSetAlignment().booleanValue()) {
                return new XlsxAlignmentExtractor((Map)this.parentXf.jsonMap.get("alignment"), this.self);
            }
            return super.getAlignment();
        }

        @Override
        public XlsxBorderExtractor getBorder() {
            return Optional.ofNullable(this.self.getBorder()).orElse(super.getBorder());
        }

        @Override
        public Number getBorderId() {
            return Optional.ofNullable(this.self.getBorderId()).orElse(super.getBorderId());
        }

        @Override
        public XlsxFillExtractor getFill() {
            return Optional.ofNullable(this.self.getFill()).orElse(super.getFill());
        }

        @Override
        public Number getFillId() {
            return Optional.ofNullable(this.self.getFillId()).orElse(super.getFillId());
        }

        @Override
        public XlsxFontExtractor getFont() {
            return Optional.ofNullable(this.self.getFont()).orElse(super.getFont());
        }

        @Override
        public Number getFontId() {
            return Optional.ofNullable(this.self.getFontId()).orElse(super.getFontId());
        }

        @Override
        public XlsxNumFmtExtractor getNumFmt() {
            return Optional.ofNullable(this.self.getNumFmt()).orElse(super.getNumFmt());
        }

        @Override
        public Number getNumFmtId() {
            return Optional.ofNullable(this.self.getNumFmtId()).orElse(super.getNumFmtId());
        }

        @Override
        public XlsxProtectionExtractor getProtection() {
            return Optional.ofNullable(this.self.getProtection()).orElse(super.getProtection());
        }

        @Override
        public Boolean isPivotButton() {
            return Optional.ofNullable(this.self.isPivotButton()).orElse(super.isPivotButton());
        }

        @Override
        public Boolean isQuotePrefix() {
            return Optional.ofNullable(this.self.isQuotePrefix()).orElse(super.isQuotePrefix());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            XlsxCellXfExtractor that = (XlsxCellXfExtractor)o;
            return Objects.equals(this.self, that.self);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.self);
        }
    }

    public static class XlsxCellStyleExtractor {
        private final Map jsonMap;

        public XlsxCellStyleExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public int getBuiltinId() {
            return Optional.ofNullable(XlsxJsonHelper.toInt(this.jsonMap, "builtinId")).orElse(0);
        }

        public boolean isCustomBuiltin() {
            return XlsxJsonHelper.toBool(this.jsonMap, "customBuiltin", false);
        }

        public boolean isHidden() {
            return XlsxJsonHelper.toBool(this.jsonMap, "hidden", false);
        }

        public Number getILevel() {
            return XlsxJsonHelper.toNum(this.jsonMap, "iLevel");
        }

        public String getName() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "name");
        }

        public int getXfId() {
            return XlsxJsonHelper.toInt(this.jsonMap, "xfId");
        }
    }

    public static class XlsxNumFmtExtractor {
        private final Map jsonMap;

        public XlsxNumFmtExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public String getFormatCode() {
            return (String)this.jsonMap.get("formatCode");
        }

        public Number getNumFmtId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "numFmtId");
        }
    }

    public static class XlsxFontExtractor {
        private final Map jsonMap;

        public XlsxFontExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public boolean isOverrideBold() {
            return this.jsonMap.containsKey("b");
        }

        public Boolean isBold() {
            return XlsxJsonHelper.toBoolean(XlsxJsonHelper.toValue(this.jsonMap, "b"), this.jsonMap.containsKey("b"));
        }

        public Number getCharset() {
            return XlsxJsonHelper.toNum(this.jsonMap, "charset");
        }

        public boolean isOverrideColor() {
            return this.jsonMap.containsKey("color");
        }

        public XlsxColorExtractor getColor() {
            return this.jsonMap.containsKey("color") ? new XlsxColorExtractor((Map)this.jsonMap.get("color")) : null;
        }

        public Boolean isCondense() {
            return XlsxJsonHelper.toBool(this.jsonMap, "condense", this.jsonMap.containsKey("condense"));
        }

        public Boolean isExtend() {
            return this.jsonMap.containsKey("extend");
        }

        public Number getFamily() {
            return XlsxJsonHelper.toNum(this.jsonMap, "family");
        }

        public boolean isOverrideItalic() {
            return this.jsonMap.containsKey("i");
        }

        public Boolean isItalic() {
            return XlsxJsonHelper.toBoolean(XlsxJsonHelper.toValue(this.jsonMap, "i"), this.jsonMap.containsKey("i"));
        }

        public boolean isOverrideName() {
            return this.jsonMap.containsKey("name");
        }

        public String getName() {
            return Optional.ofNullable(XlsxJsonHelper.toStringValue(this.jsonMap, "name", XlsxJsonHelper.toStringValue(this.jsonMap, "rFont"))).orElse("Calibri");
        }

        public Boolean isOutline() {
            return XlsxJsonHelper.toBool(this.jsonMap, "outline", this.jsonMap.containsKey("outline"));
        }

        public String getScheme() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "scheme");
        }

        public Boolean isShadow() {
            return XlsxJsonHelper.toBool(this.jsonMap, "shadow", this.jsonMap.containsKey("shadow"));
        }

        public boolean isOverrideStrike() {
            return this.jsonMap.containsKey("strike");
        }

        public Boolean isStrike() {
            return XlsxJsonHelper.toBoolean(XlsxJsonHelper.toValue(this.jsonMap, "strike"), this.jsonMap.containsKey("strike"));
        }

        public boolean isOverrideSize() {
            return this.jsonMap.containsKey("sz");
        }

        public Number getSize() {
            return XlsxJsonHelper.toNum(this.jsonMap, "sz");
        }

        public boolean isOverrideUnderline() {
            return this.jsonMap.containsKey("u");
        }

        public String getUnderline() {
            if (this.jsonMap.containsKey("u")) {
                String v = XlsxJsonHelper.toStringValue(this.jsonMap, "u");
                if (v == null) {
                    return "single";
                }
                return v;
            }
            return null;
        }

        public boolean isOverrideVertAlign() {
            return this.jsonMap.containsKey("vertAlign");
        }

        public String getVertAlign() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "vertAlign");
        }
    }

    public static class XlsxPatternExtractor
    extends XlsxFillExtractor {
        private final Map jsonMap;

        public XlsxPatternExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public XlsxColorExtractor getBgColor() {
            return this.jsonMap.containsKey("bgColor") ? new XlsxColorExtractor((Map)this.jsonMap.get("bgColor")) : null;
        }

        public XlsxColorExtractor getFgColor() {
            return this.jsonMap.containsKey("fgColor") ? new XlsxColorExtractor((Map)this.jsonMap.get("fgColor")) : null;
        }

        public String getPatternType() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "patternType");
        }
    }

    public static class XlsxStopExtractor {
        private final Map jsonMap;

        public XlsxStopExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public XlsxColorExtractor getColor() {
            return this.jsonMap.containsKey("color") ? new XlsxColorExtractor((Map)this.jsonMap.get("color")) : null;
        }

        public Number getPosition() {
            return XlsxJsonHelper.toNum(this.jsonMap, "position");
        }
    }

    public static class XlsxGradientExtractor
    extends XlsxFillExtractor {
        private final Map jsonMap;

        public XlsxGradientExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public Number getBottom() {
            return XlsxJsonHelper.toNum(this.jsonMap, "bottom");
        }

        public Number getDegree() {
            return XlsxJsonHelper.toNum(this.jsonMap, "degree");
        }

        public Number getLeft() {
            return XlsxJsonHelper.toNum(this.jsonMap, "left");
        }

        public Number getRight() {
            return XlsxJsonHelper.toNum(this.jsonMap, "right");
        }

        public List<XlsxStopExtractor> getStop() {
            return XlsxJsonHelper.toList(this.jsonMap, "stop", XlsxStopExtractor.class);
        }

        public Number getTop() {
            return XlsxJsonHelper.toNum(this.jsonMap, "top");
        }

        public String getType() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "type");
        }
    }

    public static class XlsxRGBColorsExtractor {
        Map jsonMap;

        public XlsxRGBColorsExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public List<String> getIndexedColors() {
            Object indexColor = this.jsonMap.get("indexedColors");
            if (indexColor != null) {
                return XlsxJsonHelper.toList(indexColor, "rgbColor").stream().map(data -> ((Map)data).get("rgb")).collect(Collectors.toList());
            }
            return Collections.EMPTY_LIST;
        }

        public List<String> getMruColors() {
            Object indexColor = this.jsonMap.get("mruColors");
            if (indexColor != null) {
                return XlsxJsonHelper.toList(indexColor, "color").stream().map(data -> ((Map)data).get("rgb")).collect(Collectors.toList());
            }
            return Collections.EMPTY_LIST;
        }
    }

    public static class XlsxFillExtractor {
        public static XlsxFillExtractor getInstance(Map jsonMap) {
            if (jsonMap.containsKey("patternFill")) {
                return new XlsxPatternExtractor((Map)jsonMap.get("patternFill"));
            }
            if (jsonMap.containsKey("gradientFill")) {
                return new XlsxGradientExtractor((Map)jsonMap.get("gradientFill"));
            }
            return null;
        }
    }

    public static class XlsxTableStyleElementExtractor {
        private final Map jsonMap;

        public XlsxTableStyleElementExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public Number getDxfId() {
            return XlsxJsonHelper.toNum(this.jsonMap, "dxfId");
        }

        public Number getSize() {
            return XlsxJsonHelper.toNum(this.jsonMap, "size");
        }

        public String getType() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "type");
        }
    }

    public static class XlsxTableStyleExtractor {
        private final Map jsonMap;

        public XlsxTableStyleExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public String getName() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "name");
        }

        public Boolean isPivot() {
            return XlsxJsonHelper.toBool(this.jsonMap, "pivot");
        }

        public Boolean isTable() {
            return XlsxJsonHelper.toBool(this.jsonMap, "table");
        }

        public List<XlsxTableStyleElementExtractor> getTableStyleElements() {
            return XlsxJsonHelper.toList(this.jsonMap, "tableStyleElement", XlsxTableStyleElementExtractor.class);
        }
    }

    public static class XlsxTableStylesExtractor {
        private final Map jsonMap;

        public XlsxTableStylesExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public String getDefaultPivotStyle() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "defaultPivotStyle");
        }

        public String getDefaultTableStyle() {
            return XlsxJsonHelper.toStringValue(this.jsonMap, "defaultTableStyle");
        }

        public List<XlsxTableStyleExtractor> getTableStyles() {
            return XlsxJsonHelper.toList(this.jsonMap, "tableStyle", XlsxTableStyleExtractor.class);
        }
    }

    public static class XlsxStyleSheetExtractor {
        private final Map jsonMap;

        public XlsxStyleSheetExtractor(Map jsonMap) {
            this.jsonMap = Optional.ofNullable(jsonMap).orElse(Collections.EMPTY_MAP);
        }

        public List<XlsxBorderExtractor> getBorders() {
            return this.jsonMap.containsKey("borders") ? XlsxJsonHelper.toList(this.jsonMap.get("borders"), "border").stream().map(data -> new XlsxBorderExtractor((Map)data)).collect(Collectors.toList()) : Collections.EMPTY_LIST;
        }

        public List<XlsxXfExtractor> getCellStyleXfs() {
            return this.jsonMap.containsKey("cellStyleXfs") ? XlsxJsonHelper.toList(this.jsonMap.get("cellStyleXfs"), "xf").stream().map(data -> new XlsxXfExtractor((Map)data)).collect(Collectors.toList()) : Collections.EMPTY_LIST;
        }

        public List<XlsxCellStyleExtractor> getCellStyles() {
            return this.jsonMap.containsKey("cellStyles") ? XlsxJsonHelper.toList(this.jsonMap.get("cellStyles"), "cellStyle").stream().map(data -> new XlsxCellStyleExtractor((Map)data)).collect(Collectors.toList()) : Collections.EMPTY_LIST;
        }

        public List<XlsxXfExtractor> getCellXfs() {
            return this.jsonMap.containsKey("cellXfs") ? XlsxJsonHelper.toList(this.jsonMap.get("cellXfs"), "xf").stream().map(data -> new XlsxXfExtractor((Map)data)).collect(Collectors.toList()) : Collections.EMPTY_LIST;
        }

        public XlsxRGBColorsExtractor getColors() {
            return this.jsonMap.containsKey("colors") ? new XlsxRGBColorsExtractor((Map)this.jsonMap.get("colors")) : null;
        }

        public List<XlsxDxfExtractor> getDxfs() {
            return this.jsonMap.containsKey("dxfs") ? XlsxJsonHelper.toList(this.jsonMap.get("dxfs"), "dxf").stream().map(data -> new XlsxDxfExtractor((Map)data)).collect(Collectors.toList()) : Collections.EMPTY_LIST;
        }

        public List<XlsxFillExtractor> getFills() {
            return this.jsonMap.containsKey("fills") ? XlsxJsonHelper.toList(this.jsonMap.get("fills"), "fill").stream().map(data -> XlsxFillExtractor.getInstance((Map)data)).collect(Collectors.toList()) : Collections.EMPTY_LIST;
        }

        public List<XlsxFontExtractor> getFonts() {
            return this.jsonMap.containsKey("fonts") ? XlsxJsonHelper.toList(this.jsonMap.get("fonts"), "font").stream().map(data -> new XlsxFontExtractor(data == null ? Collections.EMPTY_MAP : (Map)data)).collect(Collectors.toList()) : Collections.EMPTY_LIST;
        }

        public List<XlsxNumFmtExtractor> getNumFmts() {
            return this.jsonMap.containsKey("numFmts") ? XlsxJsonHelper.toList(this.jsonMap.get("numFmts"), "numFmt").stream().map(data -> new XlsxNumFmtExtractor((Map)data)).collect(Collectors.toList()) : Collections.EMPTY_LIST;
        }

        public XlsxTableStylesExtractor getTableStyles() {
            return this.jsonMap.containsKey("tableStyles") ? new XlsxTableStylesExtractor((Map)this.jsonMap.get("tableStyles")) : null;
        }
    }
}

