/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.importer;

import io.keikai.util.XlsxJsonHelper;
import java.util.Map;

class DataSourceJson {
    private final Map _jsonMap;
    private final boolean _isSetNumLit;
    private final boolean _isSetNumRef;
    private final boolean _isSetStrLit;
    private final boolean _isSetStrRef;

    DataSourceJson(Map jsonMap) {
        this._jsonMap = jsonMap;
        this._isSetNumRef = XlsxJsonHelper.$(jsonMap, "c:numRef") != null;
        this._isSetStrRef = XlsxJsonHelper.$(jsonMap, "c:strRef") != null;
        this._isSetNumLit = XlsxJsonHelper.$(jsonMap, "c:numLit") != null;
        this._isSetStrLit = XlsxJsonHelper.$(jsonMap, "c:strLit") != null;
    }

    String getFormatCode() {
        String path = this.getPath();
        if (path == null) {
            return null;
        }
        return XlsxJsonHelper.toStringValue((Map)XlsxJsonHelper.$(this._jsonMap, path), "c:formatCode");
    }

    String getFormula() {
        return this._jsonMap == null ? null : (this.isReference() ? this.getFormulaString() : this.getLiteralString());
    }

    private boolean isReference() {
        return this._isSetNumRef || this._isSetStrRef;
    }

    private String getFormulaString() {
        return XlsxJsonHelper.toStringValue((Map)XlsxJsonHelper.$x(this._jsonMap, this._isSetNumRef ? "c:numRef" : "c:strRef"), "c:f");
    }

    private String getLiteralString() {
        StringBuilder expression = new StringBuilder("{");
        if (this._isSetNumLit) {
            list = XlsxJsonHelper.toList(XlsxJsonHelper.$(this._jsonMap, "c:numLit"), "c:pt");
            if (list == null) {
                return null;
            }
            list.forEach(entry -> {
                Number v = XlsxJsonHelper.toNum(entry, "c:v");
                expression.append((v != null ? (Number)v : (Number)0).toString()).append(",");
            });
        } else if (this._isSetStrLit) {
            list = XlsxJsonHelper.toList(XlsxJsonHelper.$(this._jsonMap, "c:strLit"), "c:pt");
            if (list == null) {
                return null;
            }
            list.forEach(entry -> {
                String v = XlsxJsonHelper.toStringValue(entry, "c:v", "");
                expression.append("\"").append(v).append("\",");
            });
        }
        int lastIndex = expression.length() - 1;
        if (expression.charAt(lastIndex) == ',') {
            expression.delete(lastIndex, lastIndex + 1);
        }
        expression.append("}");
        return expression.toString();
    }

    private String getPath() {
        if (this._isSetNumRef) {
            return "c:numRef";
        }
        if (this._isSetStrRef) {
            return "c:strRef";
        }
        if (this._isSetNumLit) {
            return "c:numLit";
        }
        if (this._isSetStrLit) {
            return "c:strLit";
        }
        return null;
    }
}

