/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl.imexp;

import io.keikai.model.ErrorValue;
import io.keikai.model.SAutoFilter;
import io.keikai.model.SBorder;
import io.keikai.model.SCellStyle;
import io.keikai.model.SChart;
import io.keikai.model.SDataValidation;
import io.keikai.model.SFill;
import io.keikai.model.SFont;
import io.keikai.model.SHyperlink;
import io.keikai.model.SPicture;
import io.keikai.model.SPrintSetup;
import io.keikai.model.impl.AbstractChartAxisAdv;
import io.keikai.model.impl.chart.CategoryAxisImpl;
import io.keikai.model.impl.chart.DateAxisImpl;
import io.keikai.model.impl.chart.ValueAxisImpl;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xddf.usermodel.chart.AxisCrossBetween;
import org.apache.poi.xddf.usermodel.chart.AxisCrosses;
import org.apache.poi.xddf.usermodel.chart.AxisLabelAlignment;
import org.apache.poi.xddf.usermodel.chart.AxisOrientation;
import org.apache.poi.xddf.usermodel.chart.AxisPosition;
import org.apache.poi.xddf.usermodel.chart.AxisTickLabelPosition;
import org.apache.poi.xddf.usermodel.chart.BarDirection;
import org.apache.poi.xddf.usermodel.chart.BarGrouping;
import org.apache.poi.xddf.usermodel.chart.Grouping;
import org.apache.poi.xddf.usermodel.chart.LegendPosition;
import org.apache.poi.xddf.usermodel.chart.XDDFDateAxisHelper;

public class PoiEnumConversion {
    private static final short BOLDWEIGHT_NORMAL = 400;
    public static final short BOLDWEIGHT_BOLD = 700;

    public static HyperlinkType toPoiHyperlinkType(SHyperlink.HyperlinkType type) {
        switch (type) {
            case DOCUMENT: {
                return HyperlinkType.DOCUMENT;
            }
            case EMAIL: {
                return HyperlinkType.EMAIL;
            }
            case FILE: {
                return HyperlinkType.FILE;
            }
        }
        return HyperlinkType.URL;
    }

    public static SHyperlink.HyperlinkType toHyperlinkType(HyperlinkType type) {
        switch (type) {
            case DOCUMENT: {
                return SHyperlink.HyperlinkType.DOCUMENT;
            }
            case EMAIL: {
                return SHyperlink.HyperlinkType.EMAIL;
            }
            case FILE: {
                return SHyperlink.HyperlinkType.FILE;
            }
        }
        return SHyperlink.HyperlinkType.URL;
    }

    public static int toPoiFilterOperator(SAutoFilter.FilterOp operator) {
        switch (operator) {
            case and: {
                return 1;
            }
            case or: {
                return 4;
            }
            case top10: {
                return 5;
            }
            case cellColor: {
                return 8;
            }
            case fontColor: {
                return 9;
            }
        }
        return 7;
    }

    public static short toPoiPaperSize(SPrintSetup.PaperSize paperSize) {
        switch (paperSize) {
            case A3: {
                return 8;
            }
            case A4_EXTRA: {
                return 53;
            }
            case A4_PLUS: {
                return 60;
            }
            case A4_ROTATED: {
                return 77;
            }
            case A4_SMALL: {
                return 10;
            }
            case A4: {
                return 9;
            }
            case A4_TRANSVERSE: {
                return 55;
            }
            case A5: {
                return 11;
            }
            case B4: {
                return 12;
            }
            case B5: {
                return 13;
            }
            case ELEVEN_BY_SEVENTEEN: {
                return 17;
            }
            case ENVELOPE_10: {
                return 20;
            }
            case ENVELOPE_9: {
                return 19;
            }
            case ENVELOPE_C3: {
                return 29;
            }
            case ENVELOPE_C4: {
                return 30;
            }
            case ENVELOPE_C5: {
                return 28;
            }
            case ENVELOPE_C6: {
                return 31;
            }
            case ENVELOPE_CS: {
                return 28;
            }
            case ENVELOPE_DL: {
                return 27;
            }
            case ENVELOPE_MONARCH: {
                return 37;
            }
            case EXECUTIVE: {
                return 7;
            }
            case FOLIO8: {
                return 14;
            }
            case LEDGER: {
                return 4;
            }
            case LEGAL: {
                return 5;
            }
            case LETTER: {
                return 1;
            }
            case LETTER_ROTATED: {
                return 75;
            }
            case LETTER_SMALL: {
                return 2;
            }
            case NOTE8: {
                return 18;
            }
            case QUARTO: {
                return 15;
            }
            case STATEMENT: {
                return 6;
            }
            case TABLOID: {
                return 3;
            }
            case TEN_BY_FOURTEEN: {
                return 16;
            }
        }
        return 9;
    }

    public static SPrintSetup.PaperSize toPaperSize(short paperSize) {
        switch (paperSize) {
            case 8: {
                return SPrintSetup.PaperSize.A3;
            }
            case 53: {
                return SPrintSetup.PaperSize.A4_EXTRA;
            }
            case 9: {
                return SPrintSetup.PaperSize.A4;
            }
            case 60: {
                return SPrintSetup.PaperSize.A4_PLUS;
            }
            case 77: {
                return SPrintSetup.PaperSize.A4_ROTATED;
            }
            case 10: {
                return SPrintSetup.PaperSize.A4_SMALL;
            }
            case 55: {
                return SPrintSetup.PaperSize.A4_TRANSVERSE;
            }
            case 11: {
                return SPrintSetup.PaperSize.A5;
            }
            case 12: {
                return SPrintSetup.PaperSize.B4;
            }
            case 13: {
                return SPrintSetup.PaperSize.B5;
            }
            case 17: {
                return SPrintSetup.PaperSize.ELEVEN_BY_SEVENTEEN;
            }
            case 20: {
                return SPrintSetup.PaperSize.ENVELOPE_10;
            }
            case 19: {
                return SPrintSetup.PaperSize.ENVELOPE_9;
            }
            case 29: {
                return SPrintSetup.PaperSize.ENVELOPE_C3;
            }
            case 30: {
                return SPrintSetup.PaperSize.ENVELOPE_C4;
            }
            case 28: {
                return SPrintSetup.PaperSize.ENVELOPE_C5;
            }
            case 31: {
                return SPrintSetup.PaperSize.ENVELOPE_C6;
            }
            case 27: {
                return SPrintSetup.PaperSize.ENVELOPE_DL;
            }
            case 37: {
                return SPrintSetup.PaperSize.ENVELOPE_MONARCH;
            }
            case 7: {
                return SPrintSetup.PaperSize.EXECUTIVE;
            }
            case 14: {
                return SPrintSetup.PaperSize.FOLIO8;
            }
            case 4: {
                return SPrintSetup.PaperSize.LEDGER;
            }
            case 1: {
                return SPrintSetup.PaperSize.LETTER;
            }
            case 75: {
                return SPrintSetup.PaperSize.LETTER_ROTATED;
            }
            case 2: {
                return SPrintSetup.PaperSize.LETTER_SMALL;
            }
            case 18: {
                return SPrintSetup.PaperSize.NOTE8;
            }
            case 15: {
                return SPrintSetup.PaperSize.QUARTO;
            }
            case 6: {
                return SPrintSetup.PaperSize.STATEMENT;
            }
            case 3: {
                return SPrintSetup.PaperSize.TABLOID;
            }
            case 16: {
                return SPrintSetup.PaperSize.TEN_BY_FOURTEEN;
            }
        }
        return SPrintSetup.PaperSize.A4;
    }

    public static VerticalAlignment toPoiVerticalAlignment(SCellStyle.VerticalAlignment vAlignment) {
        switch (vAlignment) {
            case BOTTOM: {
                return VerticalAlignment.BOTTOM;
            }
            case CENTER: {
                return VerticalAlignment.CENTER;
            }
            case JUSTIFY: {
                return VerticalAlignment.JUSTIFY;
            }
        }
        return VerticalAlignment.TOP;
    }

    public static SCellStyle.VerticalAlignment toVerticalAlignment(VerticalAlignment poiVerticalAlignment) {
        switch (poiVerticalAlignment) {
            case TOP: {
                return SCellStyle.VerticalAlignment.TOP;
            }
            case CENTER: {
                return SCellStyle.VerticalAlignment.CENTER;
            }
            case JUSTIFY: {
                return SCellStyle.VerticalAlignment.JUSTIFY;
            }
        }
        return SCellStyle.VerticalAlignment.BOTTOM;
    }

    public static FillPatternType toPoiFillPattern(SFill.FillPattern fillPattern) {
        switch (fillPattern) {
            case DARK_GRAY: {
                return FillPatternType.ALT_BARS;
            }
            case DARK_GRID: {
                return FillPatternType.BIG_SPOTS;
            }
            case DARK_TRELLIS: {
                return FillPatternType.BRICKS;
            }
            case LIGHT_TRELLIS: {
                return FillPatternType.DIAMONDS;
            }
            case MEDIUM_GRAY: {
                return FillPatternType.FINE_DOTS;
            }
            case GRAY0625: {
                return FillPatternType.LEAST_DOTS;
            }
            case GRAY125: {
                return FillPatternType.LESS_DOTS;
            }
            case SOLID: {
                return FillPatternType.SOLID_FOREGROUND;
            }
            case LIGHT_GRAY: {
                return FillPatternType.SPARSE_DOTS;
            }
            case LIGHT_GRID: {
                return FillPatternType.SQUARES;
            }
            case DARK_DOWN: {
                return FillPatternType.THICK_BACKWARD_DIAG;
            }
            case DARK_UP: {
                return FillPatternType.THICK_FORWARD_DIAG;
            }
            case DARK_HORIZONTAL: {
                return FillPatternType.THICK_HORZ_BANDS;
            }
            case DARK_VERTICAL: {
                return FillPatternType.THICK_VERT_BANDS;
            }
            case LIGHT_DOWN: {
                return FillPatternType.THIN_BACKWARD_DIAG;
            }
            case LIGHT_UP: {
                return FillPatternType.THIN_FORWARD_DIAG;
            }
            case LIGHT_HORIZONTAL: {
                return FillPatternType.THIN_HORZ_BANDS;
            }
            case LIGHT_VERTICAL: {
                return FillPatternType.THIN_VERT_BANDS;
            }
        }
        return FillPatternType.NO_FILL;
    }

    public static SFill.FillPattern toFillPattern(FillPatternType poiFillPattern) {
        if (poiFillPattern == null) {
            return null;
        }
        switch (poiFillPattern) {
            case SOLID_FOREGROUND: {
                return SFill.FillPattern.SOLID;
            }
            case FINE_DOTS: {
                return SFill.FillPattern.MEDIUM_GRAY;
            }
            case ALT_BARS: {
                return SFill.FillPattern.DARK_GRAY;
            }
            case SPARSE_DOTS: {
                return SFill.FillPattern.LIGHT_GRAY;
            }
            case THICK_HORZ_BANDS: {
                return SFill.FillPattern.DARK_HORIZONTAL;
            }
            case THICK_VERT_BANDS: {
                return SFill.FillPattern.DARK_VERTICAL;
            }
            case THICK_BACKWARD_DIAG: {
                return SFill.FillPattern.DARK_DOWN;
            }
            case THICK_FORWARD_DIAG: {
                return SFill.FillPattern.DARK_UP;
            }
            case BIG_SPOTS: {
                return SFill.FillPattern.DARK_GRID;
            }
            case BRICKS: {
                return SFill.FillPattern.DARK_TRELLIS;
            }
            case THIN_HORZ_BANDS: {
                return SFill.FillPattern.LIGHT_HORIZONTAL;
            }
            case THIN_VERT_BANDS: {
                return SFill.FillPattern.LIGHT_VERTICAL;
            }
            case THIN_BACKWARD_DIAG: {
                return SFill.FillPattern.LIGHT_DOWN;
            }
            case THIN_FORWARD_DIAG: {
                return SFill.FillPattern.LIGHT_UP;
            }
            case SQUARES: {
                return SFill.FillPattern.LIGHT_GRID;
            }
            case DIAMONDS: {
                return SFill.FillPattern.LIGHT_TRELLIS;
            }
            case LESS_DOTS: {
                return SFill.FillPattern.GRAY125;
            }
            case LEAST_DOTS: {
                return SFill.FillPattern.GRAY0625;
            }
        }
        return SFill.FillPattern.NONE;
    }

    public static BorderStyle toPoiBorderType(SBorder.BorderType borderType) {
        switch (borderType) {
            case DASH_DOT: {
                return BorderStyle.DASH_DOT;
            }
            case DASHED: {
                return BorderStyle.DASHED;
            }
            case DOTTED: {
                return BorderStyle.DOTTED;
            }
            case DOUBLE: {
                return BorderStyle.DOUBLE;
            }
            case HAIR: {
                return BorderStyle.HAIR;
            }
            case MEDIUM: {
                return BorderStyle.MEDIUM;
            }
            case MEDIUM_DASH_DOT: {
                return BorderStyle.DASH_DOT;
            }
            case MEDIUM_DASH_DOT_DOT: {
                return BorderStyle.DASH_DOT_DOT;
            }
            case MEDIUM_DASHED: {
                return BorderStyle.MEDIUM_DASHED;
            }
            case SLANTED_DASH_DOT: {
                return BorderStyle.SLANTED_DASH_DOT;
            }
            case THICK: {
                return BorderStyle.THICK;
            }
            case THIN: {
                return BorderStyle.THIN;
            }
            case DASH_DOT_DOT: {
                return BorderStyle.DASH_DOT_DOT;
            }
        }
        return BorderStyle.NONE;
    }

    public static SBorder.BorderType toBorderType(BorderStyle poiBorder) {
        if (poiBorder == null) {
            return null;
        }
        switch (poiBorder) {
            case THIN: {
                return SBorder.BorderType.THIN;
            }
            case MEDIUM: {
                return SBorder.BorderType.MEDIUM;
            }
            case DASHED: {
                return SBorder.BorderType.DASHED;
            }
            case HAIR: {
                return SBorder.BorderType.HAIR;
            }
            case THICK: {
                return SBorder.BorderType.THICK;
            }
            case DOUBLE: {
                return SBorder.BorderType.DOUBLE;
            }
            case DOTTED: {
                return SBorder.BorderType.DOTTED;
            }
            case MEDIUM_DASHED: {
                return SBorder.BorderType.MEDIUM_DASHED;
            }
            case DASH_DOT: {
                return SBorder.BorderType.DASH_DOT;
            }
            case MEDIUM_DASH_DOT: {
                return SBorder.BorderType.MEDIUM_DASH_DOT;
            }
            case DASH_DOT_DOT: {
                return SBorder.BorderType.DASH_DOT_DOT;
            }
            case MEDIUM_DASH_DOT_DOT: {
                return SBorder.BorderType.MEDIUM_DASH_DOT_DOT;
            }
            case SLANTED_DASH_DOT: {
                return SBorder.BorderType.SLANTED_DASH_DOT;
            }
        }
        return SBorder.BorderType.NONE;
    }

    public static HorizontalAlignment toPoiHorizontalAlignment(SCellStyle.Alignment alignment) {
        switch (alignment) {
            case CENTER: {
                return HorizontalAlignment.CENTER;
            }
            case FILL: {
                return HorizontalAlignment.FILL;
            }
            case JUSTIFY: {
                return HorizontalAlignment.JUSTIFY;
            }
            case RIGHT: {
                return HorizontalAlignment.RIGHT;
            }
            case LEFT: {
                return HorizontalAlignment.LEFT;
            }
            case CENTER_SELECTION: {
                return HorizontalAlignment.CENTER_SELECTION;
            }
        }
        return HorizontalAlignment.GENERAL;
    }

    public static SCellStyle.Alignment toHorizontalAlignment(HorizontalAlignment poiHorizontalAlignment) {
        switch (poiHorizontalAlignment) {
            case LEFT: {
                return SCellStyle.Alignment.LEFT;
            }
            case RIGHT: {
                return SCellStyle.Alignment.RIGHT;
            }
            case CENTER: {
                return SCellStyle.Alignment.CENTER;
            }
            case CENTER_SELECTION: {
                return SCellStyle.Alignment.CENTER_SELECTION;
            }
            case FILL: {
                return SCellStyle.Alignment.FILL;
            }
            case JUSTIFY: {
                return SCellStyle.Alignment.JUSTIFY;
            }
        }
        return SCellStyle.Alignment.GENERAL;
    }

    public static short toPoiBoldweight(SFont.Boldweight bold) {
        switch (bold) {
            case BOLD: {
                return 700;
            }
        }
        return 400;
    }

    public static SFont.Boldweight toBoldweight(boolean bold) {
        return bold ? SFont.Boldweight.BOLD : SFont.Boldweight.NORMAL;
    }

    public static SFont.Boldweight toBoldweight(short bold) {
        switch (bold) {
            case 700: {
                return SFont.Boldweight.BOLD;
            }
        }
        return SFont.Boldweight.NORMAL;
    }

    public static short toPoiTypeOffset(SFont.TypeOffset typeOffset) {
        switch (typeOffset) {
            case SUPER: {
                return 1;
            }
            case SUB: {
                return 2;
            }
        }
        return 0;
    }

    public static SFont.TypeOffset toTypeOffset(short typeOffset) {
        switch (typeOffset) {
            case 2: {
                return SFont.TypeOffset.SUB;
            }
            case 1: {
                return SFont.TypeOffset.SUPER;
            }
        }
        return SFont.TypeOffset.NONE;
    }

    public static byte toPoiUnderline(SFont.Underline underline) {
        switch (underline) {
            case SINGLE: {
                return 1;
            }
            case DOUBLE: {
                return 2;
            }
            case DOUBLE_ACCOUNTING: {
                return 34;
            }
            case SINGLE_ACCOUNTING: {
                return 33;
            }
        }
        return 0;
    }

    public static SFont.Underline toUnderline(byte underline) {
        switch (underline) {
            case 1: {
                return SFont.Underline.SINGLE;
            }
            case 2: {
                return SFont.Underline.DOUBLE;
            }
            case 33: {
                return SFont.Underline.SINGLE_ACCOUNTING;
            }
            case 34: {
                return SFont.Underline.DOUBLE_ACCOUNTING;
            }
        }
        return SFont.Underline.NONE;
    }

    public static int toPoiPictureFormat(SPicture.Format format) {
        switch (format) {
            case GIF: {
                return 8;
            }
            case JPG: {
                return 5;
            }
        }
        return 6;
    }

    public static Grouping toPoiGrouping(SChart.ChartGrouping grouping) {
        if (grouping == null) {
            return Grouping.STANDARD;
        }
        switch (grouping) {
            case PERCENT_STACKED: {
                return Grouping.PERCENT_STACKED;
            }
            case STACKED: {
                return Grouping.STACKED;
            }
        }
        return Grouping.STANDARD;
    }

    public static BarGrouping toPoiBarGrouping(SChart.ChartGrouping grouping) {
        if (grouping == null) {
            return BarGrouping.STANDARD;
        }
        switch (grouping) {
            case CLUSTERED: {
                return BarGrouping.CLUSTERED;
            }
            case PERCENT_STACKED: {
                return BarGrouping.PERCENT_STACKED;
            }
            case STACKED: {
                return BarGrouping.STACKED;
            }
        }
        return BarGrouping.STANDARD;
    }

    public static BarDirection toPoiBarDirection(SChart.BarDirection direction) {
        switch (direction) {
            case VERTICAL: {
                return BarDirection.COL;
            }
        }
        return BarDirection.BAR;
    }

    public static SChart.BarDirection toBarDirection(BarDirection direction) {
        switch (direction) {
            case COL: {
                return SChart.BarDirection.VERTICAL;
            }
        }
        return SChart.BarDirection.HORIZONTAL;
    }

    public static LegendPosition toPoiLegendPosition(SChart.ChartLegendPosition position) {
        switch (position) {
            case BOTTOM: {
                return LegendPosition.BOTTOM;
            }
            case TOP: {
                return LegendPosition.TOP;
            }
            case TOP_RIGHT: {
                return LegendPosition.TOP_RIGHT;
            }
            case LEFT: {
                return LegendPosition.LEFT;
            }
        }
        return LegendPosition.RIGHT;
    }

    public static SChart.ChartLegendPosition toLengendPosition(LegendPosition position) {
        switch (position) {
            case BOTTOM: {
                return SChart.ChartLegendPosition.BOTTOM;
            }
            case LEFT: {
                return SChart.ChartLegendPosition.LEFT;
            }
            case TOP: {
                return SChart.ChartLegendPosition.TOP;
            }
            case TOP_RIGHT: {
                return SChart.ChartLegendPosition.TOP_RIGHT;
            }
        }
        return SChart.ChartLegendPosition.RIGHT;
    }

    public static AbstractChartAxisAdv.Crosses toAxisCrosses(AxisCrosses crosses) {
        switch (crosses) {
            case MAX: {
                return AbstractChartAxisAdv.Crosses.MAX;
            }
            case MIN: {
                return AbstractChartAxisAdv.Crosses.MIN;
            }
        }
        return AbstractChartAxisAdv.Crosses.AUTO_ZERO;
    }

    public static AxisCrosses toPoiAxisCrosses(AbstractChartAxisAdv.Crosses crosses) {
        switch (crosses) {
            case MAX: {
                return AxisCrosses.MAX;
            }
            case MIN: {
                return AxisCrosses.MIN;
            }
        }
        return AxisCrosses.AUTO_ZERO;
    }

    public static AxisOrientation toPoiAxisOrientation(AbstractChartAxisAdv.Orientation orientation) {
        switch (orientation) {
            case MAX_MIN: {
                return AxisOrientation.MAX_MIN;
            }
        }
        return AxisOrientation.MIN_MAX;
    }

    public static AbstractChartAxisAdv.Orientation toAxisOrientation(AxisOrientation orientation) {
        switch (orientation) {
            case MAX_MIN: {
                return AbstractChartAxisAdv.Orientation.MAX_MIN;
            }
        }
        return AbstractChartAxisAdv.Orientation.MIN_MAX;
    }

    public static AxisPosition toPoiAxisPosition(AbstractChartAxisAdv.Position position) {
        switch (position) {
            case LEFT: {
                return AxisPosition.LEFT;
            }
            case TOP: {
                return AxisPosition.TOP;
            }
            case RIGHT: {
                return AxisPosition.RIGHT;
            }
        }
        return AxisPosition.BOTTOM;
    }

    public static AbstractChartAxisAdv.Position toAxisPosition(AxisPosition position) {
        switch (position) {
            case LEFT: {
                return AbstractChartAxisAdv.Position.LEFT;
            }
            case TOP: {
                return AbstractChartAxisAdv.Position.TOP;
            }
            case RIGHT: {
                return AbstractChartAxisAdv.Position.RIGHT;
            }
        }
        return AbstractChartAxisAdv.Position.BOTTOM;
    }

    public static AxisTickLabelPosition toPoiAxisTickLabelPosition(AbstractChartAxisAdv.TickLabelPosition position) {
        switch (position) {
            case LOW: {
                return AxisTickLabelPosition.LOW;
            }
            case NONE: {
                return AxisTickLabelPosition.NONE;
            }
            case HIGH: {
                return AxisTickLabelPosition.HIGH;
            }
        }
        return AxisTickLabelPosition.NEXT_TO;
    }

    public static AbstractChartAxisAdv.TickLabelPosition toAxisTickLabelPosition(AxisTickLabelPosition tickLabelPosition) {
        switch (tickLabelPosition) {
            case LOW: {
                return AbstractChartAxisAdv.TickLabelPosition.LOW;
            }
            case NONE: {
                return AbstractChartAxisAdv.TickLabelPosition.NONE;
            }
            case HIGH: {
                return AbstractChartAxisAdv.TickLabelPosition.HIGH;
            }
        }
        return AbstractChartAxisAdv.TickLabelPosition.NEXT_TO;
    }

    public static AxisLabelAlignment toPoiAxisLabelAlign(CategoryAxisImpl.LabelAlign labelAlign) {
        switch (labelAlign) {
            case LEFT: {
                return AxisLabelAlignment.LEFT;
            }
            case RIGHT: {
                return AxisLabelAlignment.RIGHT;
            }
        }
        return AxisLabelAlignment.CENTER;
    }

    public static CategoryAxisImpl.LabelAlign toAxisLabelAlign(AxisLabelAlignment labelAlign) {
        switch (labelAlign) {
            case LEFT: {
                return CategoryAxisImpl.LabelAlign.LEFT;
            }
            case RIGHT: {
                return CategoryAxisImpl.LabelAlign.RIGHT;
            }
        }
        return CategoryAxisImpl.LabelAlign.CENTER;
    }

    public static XDDFDateAxisHelper.TimeUnit toPoiTimeUnit(DateAxisImpl.TimeUnit timeUnit) {
        switch (timeUnit) {
            case MONTHS: {
                return XDDFDateAxisHelper.TimeUnit.MONTHS;
            }
            case YEARS: {
                return XDDFDateAxisHelper.TimeUnit.YEARS;
            }
        }
        return XDDFDateAxisHelper.TimeUnit.DAYS;
    }

    public static AxisCrossBetween toPoiAxisBetween(ValueAxisImpl.CrossBetween crossBetween) {
        switch (crossBetween) {
            case MIDPOINT_CATEGORY: {
                return AxisCrossBetween.MIDPOINT_CATEGORY;
            }
        }
        return AxisCrossBetween.BETWEEN;
    }

    public static ValueAxisImpl.CrossBetween toAxisBetween(AxisCrossBetween crossBetween) {
        switch (crossBetween) {
            case MIDPOINT_CATEGORY: {
                return ValueAxisImpl.CrossBetween.MIDPOINT_CATEGORY;
            }
        }
        return ValueAxisImpl.CrossBetween.BETWEEN;
    }

    public static int toPoiOperatorType(SDataValidation.OperatorType type) {
        switch (type) {
            case NOT_EQUAL: {
                return 3;
            }
            case NOT_BETWEEN: {
                return 1;
            }
            case LESS_THAN: {
                return 5;
            }
            case LESS_OR_EQUAL: {
                return 7;
            }
            case GREATER_THAN: {
                return 4;
            }
            case GREATER_OR_EQUAL: {
                return 6;
            }
            case EQUAL: {
                return 2;
            }
        }
        return 0;
    }

    public static SDataValidation.OperatorType toOperatorType(int poiOperator) {
        switch (poiOperator) {
            case 2: {
                return SDataValidation.OperatorType.EQUAL;
            }
            case 6: {
                return SDataValidation.OperatorType.GREATER_OR_EQUAL;
            }
            case 4: {
                return SDataValidation.OperatorType.GREATER_THAN;
            }
            case 7: {
                return SDataValidation.OperatorType.LESS_OR_EQUAL;
            }
            case 5: {
                return SDataValidation.OperatorType.LESS_THAN;
            }
            case 1: {
                return SDataValidation.OperatorType.NOT_BETWEEN;
            }
            case 3: {
                return SDataValidation.OperatorType.NOT_EQUAL;
            }
        }
        return SDataValidation.OperatorType.BETWEEN;
    }

    public static int toPoiErrorStyle(SDataValidation.AlertStyle style) {
        switch (style) {
            case INFO: {
                return 2;
            }
            case WARNING: {
                return 1;
            }
        }
        return 0;
    }

    public static SDataValidation.AlertStyle toErrorStyle(int errorStyle) {
        switch (errorStyle) {
            case 2: {
                return SDataValidation.AlertStyle.INFO;
            }
            case 1: {
                return SDataValidation.AlertStyle.WARNING;
            }
        }
        return SDataValidation.AlertStyle.STOP;
    }

    public static SDataValidation.ValidationType toValidationType(int validationType) {
        switch (validationType) {
            case 5: {
                return SDataValidation.ValidationType.TIME;
            }
            case 6: {
                return SDataValidation.ValidationType.TEXT_LENGTH;
            }
            case 3: {
                return SDataValidation.ValidationType.LIST;
            }
            case 1: {
                return SDataValidation.ValidationType.INTEGER;
            }
            case 7: {
                return SDataValidation.ValidationType.CUSTOM;
            }
            case 2: {
                return SDataValidation.ValidationType.DECIMAL;
            }
            case 4: {
                return SDataValidation.ValidationType.DATE;
            }
        }
        return SDataValidation.ValidationType.ANY;
    }

    public static ErrorValue toErrorCode(byte errorCellValue) {
        return ErrorValue.valueOf(errorCellValue);
    }
}

