/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SBook;
import io.keikai.model.SBorder;
import io.keikai.model.SBorderLine;
import io.keikai.model.SColor;
import io.keikai.model.impl.AbstractBorderAdv;
import io.keikai.model.impl.AbstractBorderLineAdv;
import io.keikai.model.impl.DefaultStyle;
import org.zkoss.lang.Objects;

public class ImmutableBorderImpl
extends AbstractBorderAdv {
    private static final long serialVersionUID = 8668618009034300532L;
    private final SBorderLine leftLine;
    private final SBorderLine topLine;
    private final SBorderLine rightLine;
    private final SBorderLine bottomLine;
    private final SBorderLine diagonalLine;
    private final SBorderLine verticalLine;
    private final SBorderLine horizontalLine;
    private final int hashCode;

    public ImmutableBorderImpl(SBorderLine left, SBorderLine top, SBorderLine right, SBorderLine bottom, SBorderLine diagonal, SBorderLine vertical, SBorderLine horizontal) {
        this.leftLine = left;
        this.topLine = top;
        this.rightLine = right;
        this.bottomLine = bottom;
        this.diagonalLine = diagonal;
        this.verticalLine = vertical;
        this.horizontalLine = horizontal;
        this.hashCode = ImmutableBorderImpl.calcHashCode(this);
    }

    private static SBorder.BorderType getBorderType(SBorderLine borderline) {
        if (borderline == null) {
            return DefaultStyle.BORDER_TYPE;
        }
        return borderline.getBorderType();
    }

    private static SColor getBorderColor(SBorderLine borderline) {
        if (borderline == null) {
            return DefaultStyle.BORDER_COLOR;
        }
        return borderline.getColor();
    }

    private static int calcHashCode(ImmutableBorderImpl impl) {
        int hash = impl.leftLine == null ? 0 : impl.leftLine.hashCode();
        hash = hash * 31 + (impl.topLine == null ? 0 : impl.topLine.hashCode());
        hash = hash * 31 + (impl.rightLine == null ? 0 : impl.rightLine.hashCode());
        hash = hash * 31 + (impl.bottomLine == null ? 0 : impl.bottomLine.hashCode());
        hash = hash * 31 + (impl.diagonalLine == null ? 0 : impl.diagonalLine.hashCode());
        hash = hash * 31 + (impl.verticalLine == null ? 0 : impl.verticalLine.hashCode());
        hash = hash * 31 + (impl.horizontalLine == null ? 0 : impl.horizontalLine.hashCode());
        return hash;
    }

    @Override
    public SBorder.BorderType getBorderLeft() {
        return ImmutableBorderImpl.getBorderType(this.leftLine);
    }

    @Override
    public void setBorderLeft(SBorder.BorderType type) {
        throw new UnsupportedOperationException("doesn't support set border left");
    }

    @Override
    public SBorder.BorderType getBorderTop() {
        return ImmutableBorderImpl.getBorderType(this.topLine);
    }

    @Override
    public void setBorderTop(SBorder.BorderType type) {
        throw new UnsupportedOperationException("doesn't support set border top");
    }

    @Override
    public SBorder.BorderType getBorderRight() {
        return ImmutableBorderImpl.getBorderType(this.rightLine);
    }

    @Override
    public void setBorderRight(SBorder.BorderType type) {
        throw new UnsupportedOperationException("doesn't support set border right");
    }

    @Override
    public SBorder.BorderType getBorderBottom() {
        return ImmutableBorderImpl.getBorderType(this.bottomLine);
    }

    @Override
    public void setBorderBottom(SBorder.BorderType type) {
        throw new UnsupportedOperationException("doesn't support set border bottom");
    }

    @Override
    public SBorder.BorderType getBorderVertical() {
        return ImmutableBorderImpl.getBorderType(this.verticalLine);
    }

    @Override
    public void setBorderVertical(SBorder.BorderType type) {
        throw new UnsupportedOperationException("doesn't support set border vertical");
    }

    @Override
    public SBorder.BorderType getBorderHorizontal() {
        return ImmutableBorderImpl.getBorderType(this.horizontalLine);
    }

    @Override
    public void setBorderHorizontal(SBorder.BorderType type) {
        throw new UnsupportedOperationException("doesn't support set border horizontal");
    }

    @Override
    public SBorder.BorderType getBorderDiagonal() {
        return ImmutableBorderImpl.getBorderType(this.diagonalLine);
    }

    @Override
    public void setBorderDiagonal(SBorder.BorderType type) {
        throw new UnsupportedOperationException("doesn't support set border diagonal");
    }

    @Override
    public SColor getBorderTopColor() {
        return ImmutableBorderImpl.getBorderColor(this.topLine);
    }

    @Override
    public void setBorderTopColor(SColor color) {
        throw new UnsupportedOperationException("doesn't support set border top color");
    }

    @Override
    public SColor getBorderLeftColor() {
        return ImmutableBorderImpl.getBorderColor(this.leftLine);
    }

    @Override
    public void setBorderLeftColor(SColor color) {
        throw new UnsupportedOperationException("doesn't support set border left color");
    }

    @Override
    public SColor getBorderBottomColor() {
        return ImmutableBorderImpl.getBorderColor(this.bottomLine);
    }

    @Override
    public void setBorderBottomColor(SColor color) {
        throw new UnsupportedOperationException("doesn't support set border bottom color");
    }

    @Override
    public SColor getBorderRightColor() {
        return ImmutableBorderImpl.getBorderColor(this.rightLine);
    }

    @Override
    public void setBorderRightColor(SColor color) {
        throw new UnsupportedOperationException("doesn't support set border right color");
    }

    @Override
    public SColor getBorderVerticalColor() {
        return ImmutableBorderImpl.getBorderColor(this.verticalLine);
    }

    @Override
    public void setBorderVerticalColor(SColor color) {
        throw new UnsupportedOperationException("doesn't support set border vertical color");
    }

    @Override
    public SColor getBorderHorizontalColor() {
        return ImmutableBorderImpl.getBorderColor(this.horizontalLine);
    }

    @Override
    public void setBorderHorizontalColor(SColor color) {
        throw new UnsupportedOperationException("doesn't support set border horizontal color");
    }

    @Override
    public SColor getBorderDiagonalColor() {
        return ImmutableBorderImpl.getBorderColor(this.diagonalLine);
    }

    @Override
    public void setBorderDiagonalColor(SColor color) {
        throw new UnsupportedOperationException("doesn't support set border diagonal color");
    }

    @Override
    public boolean isShowDiagonalUpBorder() {
        return this.diagonalLine == null ? false : this.diagonalLine.isShowDiagonalUpBorder();
    }

    @Override
    public void setShowDiagonalUpBorder(boolean show) {
        throw new UnsupportedOperationException("doesn't support set show diagonal up border");
    }

    @Override
    public boolean isShowDiagonalDownBorder() {
        return this.diagonalLine == null ? false : this.diagonalLine.isShowDiagonalDownBorder();
    }

    @Override
    public void setShowDiagonalDownBorder(boolean show) {
        throw new UnsupportedOperationException("doesn't support set show diagonal down border");
    }

    @Override
    String getStyleKey() {
        return (this.leftLine == null ? "" : ((AbstractBorderLineAdv)this.leftLine).getStyleKey()) + (this.topLine == null ? "" : ((AbstractBorderLineAdv)this.topLine).getStyleKey()) + (this.rightLine == null ? "" : ((AbstractBorderLineAdv)this.rightLine).getStyleKey()) + (this.bottomLine == null ? "" : ((AbstractBorderLineAdv)this.bottomLine).getStyleKey()) + (this.diagonalLine == null ? "" : ((AbstractBorderLineAdv)this.diagonalLine).getStyleKey()) + (this.verticalLine == null ? "" : ((AbstractBorderLineAdv)this.verticalLine).getStyleKey()) + (this.horizontalLine == null ? "" : ((AbstractBorderLineAdv)this.horizontalLine).getStyleKey());
    }

    @Override
    public SBorderLine getLeftLine() {
        return this.leftLine;
    }

    @Override
    public SBorderLine getTopLine() {
        return this.topLine;
    }

    @Override
    public SBorderLine getRightLine() {
        return this.rightLine;
    }

    @Override
    public SBorderLine getBottomLine() {
        return this.bottomLine;
    }

    @Override
    public SBorderLine getDiagonalLine() {
        return this.diagonalLine;
    }

    @Override
    public SBorderLine getVerticalLine() {
        return this.verticalLine;
    }

    @Override
    public SBorderLine getHorizontalLine() {
        return this.horizontalLine;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ImmutableBorderImpl)) {
            return false;
        }
        ImmutableBorderImpl o = (ImmutableBorderImpl)other;
        return Objects.equals((Object)this.leftLine, (Object)o.leftLine) && Objects.equals((Object)this.topLine, (Object)o.topLine) && Objects.equals((Object)this.rightLine, (Object)o.rightLine) && Objects.equals((Object)this.bottomLine, (Object)o.bottomLine) && Objects.equals((Object)this.diagonalLine, (Object)o.diagonalLine) && Objects.equals((Object)this.verticalLine, (Object)o.verticalLine) && Objects.equals((Object)this.horizontalLine, (Object)o.horizontalLine);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    SBorder cloneBorder(SBook book) {
        SBorderLine left = this.leftLine == null ? null : ((AbstractBorderLineAdv)this.leftLine).cloneBorderLine(book);
        SBorderLine top = this.topLine == null ? null : ((AbstractBorderLineAdv)this.topLine).cloneBorderLine(book);
        SBorderLine right = this.rightLine == null ? null : ((AbstractBorderLineAdv)this.rightLine).cloneBorderLine(book);
        SBorderLine bottom = this.bottomLine == null ? null : ((AbstractBorderLineAdv)this.bottomLine).cloneBorderLine(book);
        SBorderLine diagonal = this.diagonalLine == null ? null : ((AbstractBorderLineAdv)this.diagonalLine).cloneBorderLine(book);
        SBorderLine vertical = this.verticalLine == null ? null : ((AbstractBorderLineAdv)this.verticalLine).cloneBorderLine(book);
        SBorderLine horizontal = this.horizontalLine == null ? null : ((AbstractBorderLineAdv)this.horizontalLine).cloneBorderLine(book);
        return new ImmutableBorderImpl(left, top, right, bottom, diagonal, vertical, horizontal);
    }
}

