/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SChart;
import io.keikai.model.SChartAxis;
import io.keikai.model.SColor;
import io.keikai.model.SSheet;
import io.keikai.model.ViewAnchor;
import io.keikai.model.chart.SChartData;
import io.keikai.model.chart.SGeneralChartData;
import io.keikai.model.impl.AbstractChartAdv;
import io.keikai.model.impl.AbstractSheetAdv;
import io.keikai.model.impl.chart.AreaChartDataImpl;
import io.keikai.model.impl.chart.BarChartDataImpl;
import io.keikai.model.impl.chart.BubbleChartDataImpl;
import io.keikai.model.impl.chart.CategoryAxisImpl;
import io.keikai.model.impl.chart.ChartDataAdv;
import io.keikai.model.impl.chart.DateAxisImpl;
import io.keikai.model.impl.chart.DoughnutChartDataImpl;
import io.keikai.model.impl.chart.GeneralChartDataImpl;
import io.keikai.model.impl.chart.GroupingChartDataImpl;
import io.keikai.model.impl.chart.LineChartDataImpl;
import io.keikai.model.impl.chart.PieChartDataImpl;
import io.keikai.model.impl.chart.ScatterChartDataImpl;
import io.keikai.model.impl.chart.UnsupportedChartDataImpl;
import io.keikai.model.impl.chart.ValueAxisImpl;
import io.keikai.model.util.Strings;
import io.keikai.model.util.Validations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class ChartImpl
extends AbstractChartAdv {
    private static final long serialVersionUID = 1L;
    private final String _id;
    private final List<SChartAxis> _valueAxises = new ArrayList<SChartAxis>();
    private final List<SChartAxis> _categoryAxises = new ArrayList<SChartAxis>();
    private final List<SChartAxis> _dateAxises = new ArrayList<SChartAxis>();
    private final List<SChartData> _chartSeries = new ArrayList<SChartData>();
    private ViewAnchor _anchor;
    private String _title;
    private String _xAxisTitle;
    private String _yAxisTitle;
    private AbstractSheetAdv _sheet;
    private SChart.ChartLegendPosition _legendPosition;
    private boolean _threeD;
    private boolean _emptyAsGaps;
    private boolean _sparkline;
    private boolean _winlose;
    private boolean _rAngAx = true;
    private int _rotX = 0;
    private int _rotY = 0;
    private int _hPercent = 100;
    private int _depthPercent = 100;
    private int _perspective = 30;
    private int _dataCounter;
    private boolean _showTitle;
    private Boolean _autoTitleDeleted = null;
    private boolean _plotOnlyVisibleCells = true;
    private boolean _showDataLabelsOverMax = true;
    private List<SColor> colors = new ArrayList<SColor>();
    private boolean _sparklineNegativePointVisible;
    private boolean _sparklineFirstPointVisible;
    private boolean _sparklineLastPointVisible;
    private boolean _sparklineHighPointVisible;
    private boolean _sparklineLowPointVisible;
    private boolean _sparklineMarkPointVisible;
    private SColor _sparklineSeriesColor;
    private SColor _sparklineNegativePointColor;
    private SColor _sparklineFirstPointColor;
    private SColor _sparklineLastPointColor;
    private SColor _sparklineHighPointColor;
    private SColor _sparklineLowPointColor;
    private SColor _sparklineMarkPointColor;
    private String _name;
    private static final AtomicLong axisIdCount = new AtomicLong(0L);

    private static long generateAxisId() {
        return axisIdCount.getAndIncrement();
    }

    private static void compareAxisId(long id) {
        if (axisIdCount.get() < id) {
            axisIdCount.set(id + 1L);
        }
    }

    public ChartImpl(AbstractSheetAdv sheet, String id, SChart.ChartType type, ViewAnchor anchor) {
        this(sheet, id, null, type, anchor);
    }

    public ChartImpl(AbstractSheetAdv sheet, String id, String name, SChart.ChartType type, ViewAnchor anchor) {
        this(sheet, id, name, anchor);
        this.addChartData(this.createChartData(type));
    }

    private ChartImpl(AbstractSheetAdv sheet, String id, String name, ViewAnchor anchor) {
        Validations.argNotNull(anchor);
        this._sheet = sheet;
        this._id = id;
        this._anchor = anchor;
        this._name = name;
    }

    @Override
    public SSheet getSheet() {
        this.checkOrphan();
        return this._sheet;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public ViewAnchor getAnchor() {
        return this._anchor;
    }

    @Override
    public void setAnchor(ViewAnchor anchor) {
        Validations.argNotNull(anchor);
        this._anchor = anchor;
    }

    @Override
    public SChart.ChartType getType() {
        SChartData data = this.getData();
        if (data instanceof SGeneralChartData) {
            return ((SGeneralChartData)data).getType();
        }
        return null;
    }

    @Override
    public SChartData getData() {
        if (this._chartSeries.isEmpty()) {
            return null;
        }
        return this._chartSeries.get(0);
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    @Override
    public void setTitle(String title) {
        this._title = title;
    }

    @Override
    public String getXAxisTitle() {
        return this._xAxisTitle;
    }

    @Override
    public void setXAxisTitle(String xAxisTitle) {
        this._xAxisTitle = xAxisTitle;
    }

    @Override
    public String getYAxisTitle() {
        return this._yAxisTitle;
    }

    @Override
    public void setYAxisTitle(String yAxisTitle) {
        this._yAxisTitle = yAxisTitle;
    }

    @Override
    public void destroy() {
        this.checkOrphan();
        ((ChartDataAdv)this.getData()).destroy();
        this._sheet = null;
    }

    @Override
    public void checkOrphan() {
        if (this._sheet == null) {
            throw new IllegalStateException("doesn't connect to parent");
        }
    }

    @Override
    public SChart.ChartLegendPosition getLegendPosition() {
        return this._legendPosition;
    }

    @Override
    public void setLegendPosition(SChart.ChartLegendPosition pos) {
        this._legendPosition = pos;
    }

    @Override
    public SChart.ChartGrouping getGrouping() {
        SChartData data;
        if (!this._chartSeries.isEmpty() && (data = this._chartSeries.get(0)) instanceof GroupingChartDataImpl) {
            return ((GroupingChartDataImpl)data).getGrouping();
        }
        return null;
    }

    @Override
    public void setGrouping(SChart.ChartGrouping grouping) {
        SChartData data;
        if (!this._chartSeries.isEmpty() && (data = this._chartSeries.get(0)) instanceof GroupingChartDataImpl) {
            ((GroupingChartDataImpl)data).setGrouping(grouping);
        }
    }

    @Override
    public SChart.BarDirection getBarDirection() {
        SChartData data;
        if (!this._chartSeries.isEmpty() && (data = this._chartSeries.get(0)) instanceof BarChartDataImpl) {
            return ((BarChartDataImpl)data).getBarDirection();
        }
        return null;
    }

    @Override
    public boolean isThreeD() {
        return this._threeD;
    }

    @Override
    public void setThreeD(boolean threeD) {
        this._threeD = threeD;
    }

    @Override
    public boolean isEmptyAsGaps() {
        return this._emptyAsGaps;
    }

    @Override
    public void setEmptyAsGaps(boolean emptyAsGaps) {
        this._emptyAsGaps = emptyAsGaps;
    }

    @Override
    public boolean isSparkline() {
        return this._sparkline;
    }

    @Override
    public void setSparkline(boolean sparkline) {
        this._sparkline = sparkline;
    }

    @Override
    public boolean isWinloseSpark() {
        return this._winlose;
    }

    @Override
    public void setWinloseSpark(boolean winlose) {
        this._winlose = winlose;
    }

    ChartImpl cloneChartImpl(AbstractSheetAdv sheet) {
        long newId;
        ChartImpl tgt = new ChartImpl(sheet, this._id, this._name, this._anchor.cloneViewAnchor());
        HashMap<Long, Long> catAxMap = new HashMap<Long, Long>();
        HashMap<Long, Long> dateAxMap = new HashMap<Long, Long>();
        HashMap<Long, Long> valAxMap = new HashMap<Long, Long>();
        for (SChartAxis axis : this._valueAxises) {
            newId = ChartImpl.generateAxisId();
            tgt.addValueAxis(((ValueAxisImpl)axis).cloneValueAxisImpl(newId));
            catAxMap.put(axis.getId(), newId);
        }
        for (SChartAxis axis : this._categoryAxises) {
            newId = ChartImpl.generateAxisId();
            tgt.addCategoryAxis(((CategoryAxisImpl)axis).cloneCategoryAxisImpl(newId));
            valAxMap.put(axis.getId(), newId);
        }
        for (SChartAxis axis : this._dateAxises) {
            newId = ChartImpl.generateAxisId();
            tgt.addDateAxis(((DateAxisImpl)axis).cloneDateAxisImpl(newId));
            dateAxMap.put(axis.getId(), newId);
        }
        for (SChartAxis axis : tgt._categoryAxises) {
            CategoryAxisImpl catAx;
            long crossCatAxId;
            if (!(axis instanceof CategoryAxisImpl) || !catAxMap.containsKey(crossCatAxId = (catAx = (CategoryAxisImpl)axis).getCrossAxisId())) continue;
            catAx.setCrossAxisId((Long)catAxMap.get(crossCatAxId));
        }
        for (SChartAxis axis : tgt._dateAxises) {
            DateAxisImpl dateAx;
            long crossDateAxId;
            if (!(axis instanceof DateAxisImpl) || !dateAxMap.containsKey(crossDateAxId = (dateAx = (DateAxisImpl)axis).getCrossAxisId())) continue;
            dateAx.setCrossAxisId((Long)dateAxMap.get(crossDateAxId));
        }
        for (SChartAxis axis : tgt._valueAxises) {
            ValueAxisImpl valAx;
            long crossValAxId;
            if (!(axis instanceof ValueAxisImpl) || !valAxMap.containsKey(crossValAxId = (valAx = (ValueAxisImpl)axis).getCrossAxisId())) continue;
            valAx.setCrossAxisId((Long)valAxMap.get(crossValAxId));
        }
        for (SChartData chartData : this._chartSeries) {
            if (!(chartData instanceof GeneralChartDataImpl)) continue;
            GeneralChartDataImpl dataImpl = (GeneralChartDataImpl)chartData;
            GeneralChartDataImpl cloned = (GeneralChartDataImpl)tgt.createChartData(dataImpl.getType());
            cloned.copyFrom(dataImpl);
            tgt.addChartData(cloned);
        }
        tgt._anchor = this._anchor.cloneViewAnchor();
        tgt._title = this._title;
        tgt._xAxisTitle = this._xAxisTitle;
        tgt._yAxisTitle = this._yAxisTitle;
        tgt._legendPosition = this._legendPosition;
        tgt._threeD = this._threeD;
        tgt._emptyAsGaps = this._emptyAsGaps;
        tgt._sparkline = this._sparkline;
        tgt._winlose = this._winlose;
        tgt._rAngAx = this._rAngAx;
        tgt._rotX = this._rotX;
        tgt._rotY = this._rotY;
        tgt._hPercent = this._hPercent;
        tgt._perspective = this._perspective;
        tgt._autoTitleDeleted = this._autoTitleDeleted;
        tgt._plotOnlyVisibleCells = this._plotOnlyVisibleCells;
        tgt._showDataLabelsOverMax = this._showDataLabelsOverMax;
        if (this.colors != null) {
            tgt.colors = new ArrayList<SColor>(this.colors);
        }
        return tgt;
    }

    @Override
    public void addValueAxis(SChartAxis axis) {
        ChartImpl.compareAxisId(axis.getId());
        this._valueAxises.add(axis);
    }

    @Override
    public void addCategoryAxis(SChartAxis axis) {
        ChartImpl.compareAxisId(axis.getId());
        this._categoryAxises.add(axis);
    }

    @Override
    public void addDateAxis(SChartAxis axis) {
        ChartImpl.compareAxisId(axis.getId());
        this._dateAxises.add(axis);
    }

    @Override
    public List<SChartAxis> getValueAxises() {
        return this._valueAxises;
    }

    @Override
    public List<SChartAxis> getCategoryAxises() {
        return this._categoryAxises;
    }

    @Override
    public List<SChartAxis> getDateAxises() {
        return this._dateAxises;
    }

    @Override
    public int getRotX() {
        return this._rotX;
    }

    @Override
    public void setRotX(int rotX) {
        this._rotX = rotX;
    }

    @Override
    public int getRotY() {
        return this._rotY;
    }

    @Override
    public void setRotY(int rotY) {
        this._rotY = rotY;
    }

    @Override
    public int getPerspective() {
        return this._perspective;
    }

    @Override
    public void setPerspective(int perspective) {
        this._perspective = perspective;
    }

    @Override
    public int getHPercent() {
        return this._hPercent;
    }

    @Override
    public void setHPercent(int percent) {
        this._hPercent = percent;
    }

    @Override
    public int getDepthPercent() {
        return this._depthPercent;
    }

    @Override
    public void setDepthPercent(int percent) {
        this._depthPercent = percent;
    }

    @Override
    public boolean isRightAngleAxes() {
        return this._rAngAx;
    }

    @Override
    public void setRightAngleAxes(boolean b) {
        this._rAngAx = b;
    }

    @Override
    public int getBarOverlap() {
        SChartData data;
        if (!this._chartSeries.isEmpty() && (data = this._chartSeries.get(0)) instanceof BarChartDataImpl) {
            return ((BarChartDataImpl)data).getBarOverlap();
        }
        return 0;
    }

    @Override
    public void setBarOverlap(int overlap) {
        if (this._chartSeries.isEmpty()) {
            return;
        }
        SChartData data = this._chartSeries.get(0);
        if (data instanceof BarChartDataImpl) {
            ((BarChartDataImpl)data).setBarOverlap(overlap);
        }
    }

    @Override
    public boolean isPlotOnlyVisibleCells() {
        return this._plotOnlyVisibleCells;
    }

    @Override
    public void setPlotOnlyVisibleCells(boolean plotOnlyVisibleCells) {
        this._plotOnlyVisibleCells = plotOnlyVisibleCells;
    }

    @Override
    public List<SColor> getSeriesColors() {
        return this.colors;
    }

    @Override
    public void setSeriesColors(List<SColor> colors) {
        this.colors = colors;
    }

    @Override
    public List<SChartData> getChartData() {
        return this._chartSeries;
    }

    @Override
    public SChartData createChartData(SChart.ChartType type) {
        switch (type) {
            case AREA: {
                return new AreaChartDataImpl(this, this.toId());
            }
            case BAR: {
                return new BarChartDataImpl(this, this.toId(), SChart.BarDirection.HORIZONTAL);
            }
            case BUBBLE: {
                return new BubbleChartDataImpl(this, this.toId());
            }
            case COLUMN: {
                return new BarChartDataImpl(this, this.toId(), SChart.BarDirection.VERTICAL);
            }
            case DOUGHNUT: {
                return new DoughnutChartDataImpl(this, this.toId());
            }
            case LINE: {
                return new LineChartDataImpl(this, this.toId());
            }
            case PIE: {
                return new PieChartDataImpl(this, this.toId());
            }
            case SCATTER: {
                return new ScatterChartDataImpl(this, this.toId());
            }
            case OF_PIE: 
            case RADAR: 
            case STOCK: 
            case SURFACE: {
                return new UnsupportedChartDataImpl(this);
            }
        }
        throw new UnsupportedOperationException("Unsupported chart type " + String.valueOf((Object)type));
    }

    @Override
    public void addChartData(SChartData chartData) {
        this._chartSeries.add(chartData);
    }

    @Override
    public Boolean isAutoTitleDeleted() {
        return this._autoTitleDeleted;
    }

    @Override
    public void setAutoTitleDeleted(Boolean autoTitleDeleted) {
        this._autoTitleDeleted = autoTitleDeleted;
    }

    @Override
    public boolean isShowTitle() {
        return this._showTitle;
    }

    @Override
    public void setShowTitle(boolean showTitle) {
        this._showTitle = showTitle;
    }

    @Override
    public boolean isShowDataLabelsOverMax() {
        return this._showDataLabelsOverMax;
    }

    @Override
    public void setShowDataLabelsOverMax(boolean showDataLabelsOverMax) {
        this._showDataLabelsOverMax = showDataLabelsOverMax;
    }

    @Override
    public void setSparklineNegativePointVisible(boolean visible) {
        this._sparklineNegativePointVisible = visible;
    }

    @Override
    public boolean isSparklineNegativePointVisible() {
        return this._sparklineNegativePointVisible;
    }

    @Override
    public void setSparklineFirstPointVisible(boolean visible) {
        this._sparklineFirstPointVisible = visible;
    }

    @Override
    public boolean isSparklineFirstPointVisible() {
        return this._sparklineFirstPointVisible;
    }

    @Override
    public void setSparklineLastPointVisible(boolean visible) {
        this._sparklineLastPointVisible = visible;
    }

    @Override
    public boolean isSparklineLastPointVisible() {
        return this._sparklineLastPointVisible;
    }

    @Override
    public void setSparklineHighPointVisible(boolean visible) {
        this._sparklineHighPointVisible = visible;
    }

    @Override
    public boolean isSparklineHighPointVisible() {
        return this._sparklineHighPointVisible;
    }

    @Override
    public void setSparklineLowPointVisible(boolean visible) {
        this._sparklineLowPointVisible = visible;
    }

    @Override
    public boolean isSparklineLowPointVisible() {
        return this._sparklineLowPointVisible;
    }

    @Override
    public void setSparklineMarkerVisible(boolean visible) {
        this._sparklineMarkPointVisible = visible;
    }

    @Override
    public boolean isSparklineMarkerVisible() {
        return this._sparklineMarkPointVisible;
    }

    @Override
    public void setSparklineSeriesColor(SColor color) {
        this._sparklineSeriesColor = color;
    }

    @Override
    public SColor getSparklineSeriesColor() {
        return this._sparklineSeriesColor;
    }

    @Override
    public void setSparklineNegativePointColor(SColor color) {
        this._sparklineNegativePointColor = color;
    }

    @Override
    public SColor getSparklineNegativePointColor() {
        return this._sparklineNegativePointColor;
    }

    @Override
    public void setSparklineFirstPointColor(SColor color) {
        this._sparklineFirstPointColor = color;
    }

    @Override
    public SColor getSparklineFirstPointColor() {
        return this._sparklineFirstPointColor;
    }

    @Override
    public void setSparklineLastPointColor(SColor color) {
        this._sparklineLastPointColor = color;
    }

    @Override
    public SColor getSparklineLastPointColor() {
        return this._sparklineLastPointColor;
    }

    @Override
    public void setSparklineHighPointColor(SColor color) {
        this._sparklineHighPointColor = color;
    }

    @Override
    public SColor getSparklineHighPointColor() {
        return this._sparklineHighPointColor;
    }

    @Override
    public void setSparklineLowPointColor(SColor color) {
        this._sparklineLowPointColor = color;
    }

    @Override
    public SColor getSparklineLowPointColor() {
        return this._sparklineLowPointColor;
    }

    @Override
    public void setSparklineMarkerColor(SColor color) {
        this._sparklineMarkPointColor = color;
    }

    @Override
    public SColor getSparklineMarkerColor() {
        return this._sparklineMarkPointColor;
    }

    private String toId() {
        return String.format("%s-%s", this._id, this._dataCounter++);
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        if (Strings.isEmpty(name)) {
            throw new IllegalArgumentException("The name of chart should not be empty.");
        }
        this._name = name;
    }
}

