/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.util;

import io.keikai.util.Converter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlsxJsonHelper {
    private static final Logger log = LoggerFactory.getLogger(XlsxJsonHelper.class);

    private XlsxJsonHelper() {
    }

    public static <T> T $1(Map map, String path) {
        return (T)map.get(path);
    }

    public static <T> T $(Map map, String ... paths) {
        if (map == null) {
            return null;
        }
        Map nested = map;
        int j = paths.length;
        for (int i = 0; i < j; ++i) {
            Object r = nested.get(paths[i]);
            if (i + 1 == j) {
                return (T)r;
            }
            if (!(r instanceof Map)) break;
            nested = (Map)r;
        }
        return null;
    }

    public static <T> T $x(Map map, String xpath) {
        return XlsxJsonHelper.$(map, xpath.split("/"));
    }

    public static Boolean toBool(Map jsonMap, String key) {
        return XlsxJsonHelper.toBoolean(jsonMap.get(key), null);
    }

    public static Boolean toBool(Map jsonMap, String key, Boolean nullAs) {
        return XlsxJsonHelper.toBoolean(jsonMap.get(key), nullAs);
    }

    public static Boolean toBoolean(Object val, Boolean nullAs) {
        if (val == null) {
            return nullAs;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof String) {
            String vall = val.toString().toLowerCase();
            return !vall.equals("0") && !vall.equals("false") && !vall.equals("no") && !vall.equals("off") && !vall.isEmpty();
        }
        if (val instanceof Number) {
            double dv = ((Number)val).doubleValue();
            return Double.isNaN(dv) && dv != 0.0;
        }
        return false;
    }

    public static Double toDouble(Map jsonMap, String key) {
        return XlsxJsonHelper.toDouble(jsonMap, key, null);
    }

    public static Double toDouble(Map jsonMap, String key, Double nullAs) {
        if (jsonMap == null) {
            return null;
        }
        Object v = XlsxJsonHelper.getValue(jsonMap, key);
        if (v instanceof String) {
            return Double.parseDouble((String)v);
        }
        return nullAs;
    }

    public static Integer toInt(Map jsonMap, String key) {
        return XlsxJsonHelper.toInt(jsonMap, key, null);
    }

    public static Integer toInt(Map jsonMap, String key, Integer nullAs) {
        if (jsonMap == null) {
            return null;
        }
        Object v = XlsxJsonHelper.getValue(jsonMap, key);
        if (v instanceof String) {
            return Integer.parseInt((String)v);
        }
        return nullAs;
    }

    public static Long toLong(Map jsonMap, String key) {
        return XlsxJsonHelper.toLong(jsonMap, key, null);
    }

    public static Long toLong(Map jsonMap, String key, Long nullAs) {
        if (jsonMap == null) {
            return null;
        }
        Object v = XlsxJsonHelper.getValue(jsonMap, key);
        if (v instanceof String) {
            return Long.parseLong((String)v);
        }
        return nullAs;
    }

    public static Number toNum(Map jsonMap, String key) {
        if (jsonMap == null) {
            return null;
        }
        Object v = XlsxJsonHelper.getValue(jsonMap, key);
        if (v instanceof String) {
            String val = (String)v;
            if (val.contains(".")) {
                return Double.parseDouble(val);
            }
            return Integer.parseInt(val);
        }
        if (v instanceof Number) {
            return (Number)v;
        }
        return null;
    }

    public static Float toFloat(Map jsonMap, String key) {
        if (jsonMap == null) {
            return null;
        }
        Object v = XlsxJsonHelper.getValue(jsonMap, key);
        return v instanceof String ? Float.valueOf(Float.parseFloat((String)v)) : null;
    }

    public static List toList(Object jsonMap, String key) {
        if (!(jsonMap instanceof Map)) {
            return null;
        }
        Map jsonMap0 = (Map)jsonMap;
        Object v = jsonMap0.get(key);
        if (v instanceof List) {
            return (List)v;
        }
        if (v == null) {
            return new ArrayList();
        }
        return Converter.asList(v);
    }

    public static <T> T toValue(Map jsonMap, String key) {
        if (jsonMap == null) {
            return null;
        }
        return (T)XlsxJsonHelper.getValue(jsonMap, key);
    }

    public static String toStringValue(Map jsonMap, String key) {
        return XlsxJsonHelper.toStringValue(jsonMap, key, null);
    }

    public static String toStringValue(Map jsonMap, String key, String nullAs) {
        if (jsonMap == null) {
            return null;
        }
        Object r = XlsxJsonHelper.getValue(jsonMap, key);
        if (r instanceof String) {
            return (String)r;
        }
        if (r != null) {
            return r.toString();
        }
        return nullAs;
    }

    public static Object getValue(Map jsonMap, String key) {
        if (jsonMap.containsKey(key)) {
            Object k = jsonMap.get(key);
            if (k instanceof Map) {
                Map kM = (Map)k;
                if (kM.containsKey("_")) {
                    return (String)kM.get("_");
                }
                if (kM.containsKey("val")) {
                    return (String)kM.get("val");
                }
                return kM;
            }
            return k;
        }
        return null;
    }

    public static <T> List<T> toList(Map jsonMap, String key, Class cls) {
        if (jsonMap == null || jsonMap.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Object value = jsonMap.get(key);
        if (value != null) {
            try {
                Constructor declaredConstructor = cls.getDeclaredConstructor(Map.class);
                if (value instanceof List) {
                    return ((List)value).stream().map(c -> {
                        try {
                            return declaredConstructor.newInstance(c);
                        }
                        catch (Exception e) {
                            log.error("Failed to create instance of " + String.valueOf(cls), (Throwable)e);
                            return null;
                        }
                    }).collect(Collectors.toList());
                }
                if (value instanceof Map) {
                    return Converter.asList(declaredConstructor.newInstance((Map)value));
                }
            }
            catch (Exception e) {
                log.error("Failed to create instance of " + String.valueOf(cls), (Throwable)e);
            }
        }
        return Collections.EMPTY_LIST;
    }

    public static String[] getParts(String text) {
        Object _left = "";
        Object _center = "";
        Object _right = "";
        if (text == null || text.length() == 0) {
            return new String[]{_left, _center, _right};
        }
        block5: while (text.length() > 1) {
            int part = 67;
            int start = 0;
            if (text.charAt(0) == '&') {
                part = text.charAt(1);
                start = 2;
            }
            int pos1 = 0;
            int pos = text.length();
            switch (part) {
                case 76: {
                    pos1 = XlsxJsonHelper.indexOf(text, "&L");
                    if (pos1 >= 0) {
                        pos = Math.min(pos, pos1);
                    }
                    if ((pos1 = XlsxJsonHelper.indexOf(text, "&C")) >= 0) {
                        pos = Math.min(pos, pos1);
                    }
                    if ((pos1 = XlsxJsonHelper.indexOf(text, "&R")) >= 0) {
                        pos = Math.min(pos, pos1);
                    }
                    _left = (String)_left + text.substring(start, pos);
                    text = text.substring(pos);
                    continue block5;
                }
                case 67: {
                    pos1 = XlsxJsonHelper.indexOf(text, "&L");
                    if (pos1 >= 0) {
                        pos = Math.min(pos, pos1);
                    }
                    if ((pos1 = XlsxJsonHelper.indexOf(text, "&C")) >= 0) {
                        pos = Math.min(pos, pos1);
                    }
                    if ((pos1 = XlsxJsonHelper.indexOf(text, "&R")) >= 0) {
                        pos = Math.min(pos, pos1);
                    }
                    _center = (String)_center + text.substring(start, pos);
                    text = text.substring(pos);
                    continue block5;
                }
                case 82: {
                    pos1 = XlsxJsonHelper.indexOf(text, "&L");
                    if (pos1 >= 0) {
                        pos = Math.min(pos, pos1);
                    }
                    if ((pos1 = XlsxJsonHelper.indexOf(text, "&C")) >= 0) {
                        pos = Math.min(pos, pos1);
                    }
                    if ((pos1 = XlsxJsonHelper.indexOf(text, "&R")) >= 0) {
                        pos = Math.min(pos, pos1);
                    }
                    _right = (String)_right + text.substring(start, pos);
                    text = text.substring(pos);
                    continue block5;
                }
            }
            _center = (String)_center + text.substring(start);
            break;
        }
        return new String[]{_left, _center, _right};
    }

    private static int indexOf(String text, String token) {
        int start = 1;
        while ((start = text.indexOf(token, start)) >= 0) {
            int count = 1;
            int j = start;
            while (--j >= 0 && text.charAt(j) == '&') {
                ++count;
            }
            if (count & true) {
                return start;
            }
            ++start;
        }
        return start;
    }
}

