/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl.imexp;

import io.keikai.model.CellRegion;
import io.keikai.model.SAutoFilter;
import io.keikai.model.SBook;
import io.keikai.model.SBookSeries;
import io.keikai.model.SBooks;
import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SCellStyleBuilder;
import io.keikai.model.SComment;
import io.keikai.model.SFill;
import io.keikai.model.SFont;
import io.keikai.model.SFooter;
import io.keikai.model.SHeader;
import io.keikai.model.SHyperlink;
import io.keikai.model.SName;
import io.keikai.model.SPicture;
import io.keikai.model.SPrintSetup;
import io.keikai.model.SRichText;
import io.keikai.model.SRow;
import io.keikai.model.SSheet;
import io.keikai.model.SSheetViewInfo;
import io.keikai.model.ViewAnchor;
import io.keikai.model.impl.AbstractBookAdv;
import io.keikai.model.impl.AbstractCellAdv;
import io.keikai.model.impl.HeaderFooterImpl;
import io.keikai.model.impl.RichTextImpl;
import io.keikai.model.impl.SheetImpl;
import io.keikai.model.sys.formula.FormulaExpression;
import io.keikai.range.impl.imexp.AbstractImporter;
import io.keikai.range.impl.imexp.BookHelper;
import io.keikai.range.impl.imexp.PoiEnumConversion;
import io.keikai.range.impl.imexp.StyleCache;
import io.keikai.range.impl.imexp.UnitUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.model.InternalSheet;
import org.apache.poi.hssf.record.aggregates.PageSettingsBlock;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFEvenFooter;
import org.apache.poi.hssf.usermodel.HSSFEvenHeader;
import org.apache.poi.hssf.usermodel.HSSFFirstFooter;
import org.apache.poi.hssf.usermodel.HSSFFirstHeader;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.eval.BoolEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.ptg.FuncVarPtg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.usermodel.AutoFilter;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Color;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.util.Locales;

public abstract class AbstractExcelImporter
extends AbstractImporter
implements Serializable {
    private static final long serialVersionUID = 6978036306999098019L;
    private static final Logger _logger = LoggerFactory.getLogger(AbstractExcelImporter.class);
    protected StyleCache styleCache = new StyleCache();
    protected SBook book;
    protected Workbook workbook;
    protected Map<PictureData, Integer> importedPictureData = new HashMap<PictureData, Integer>();
    protected boolean _importCache = false;

    protected void importDefaultCellStyles() {
        ((AbstractBookAdv)this.book).clearDefaultCellStyles();
        if (this.book.getDefaultCellStyles().isEmpty()) {
            ((AbstractBookAdv)this.book).initDefaultCellStyles();
        }
        ((AbstractBookAdv)this.book).initDefaultFont();
    }

    protected void importNamedStyles() {
        ((AbstractBookAdv)this.book).clearNamedStyles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SBook imports(InputStream is, String bookName) throws IOException {
        this.styleCache.clear();
        this.workbook = this.createPoiBook(is);
        this.book = SBooks.createBook(bookName);
        Locale old = Locales.setThreadLocal((Locale)Locale.US);
        SBookSeries bookSeries = this.book.getBookSeries();
        boolean isCacheClean = bookSeries.isAutoFormulaCacheClean();
        try {
            int i;
            ((AbstractBookAdv)this.book).setPostProcessing(true);
            this.importDefaultCellStyles();
            this.importNamedStyles();
            this.importExtraStyles();
            this.importTableStyles();
            this.setBookType(this.book);
            bookSeries.setAutoFormulaCacheClean(false);
            this.importExternalBookLinks();
            int numberOfSheet = this.workbook.getNumberOfSheets();
            for (i = 0; i < numberOfSheet; ++i) {
                Sheet poiSheet = this.workbook.getSheetAt(i);
                this.importSheet(poiSheet, i);
                SSheet sheet = this.book.getSheet(i);
                this.importTables(poiSheet, sheet);
            }
            this.importNamedRange();
            for (i = 0; i < numberOfSheet; ++i) {
                SSheet sheet = this.book.getSheet(i);
                Sheet poiSheet = this.workbook.getSheetAt(i);
                for (Row poiRow : poiSheet) {
                    this.importRow(poiRow, sheet);
                }
                this.importColumn(poiSheet, sheet);
                this.importMergedRegions(poiSheet, sheet);
                this.importDrawings(poiSheet, sheet);
                this.importValidation(poiSheet, sheet);
                this.importSheetProtection(poiSheet, sheet);
            }
        }
        finally {
            this.book.getBookSeries().setAutoFormulaCacheClean(isCacheClean);
            Locales.setThreadLocal((Locale)old);
            ((AbstractBookAdv)this.book).setPostProcessing(false);
        }
        return this.book;
    }

    protected abstract Workbook createPoiBook(InputStream var1) throws IOException;

    protected abstract void setBookType(SBook var1);

    public static String getBookType(SBook book) {
        return (String)book.getAttribute(BOOK_TYPE_KEY);
    }

    protected abstract void importColumn(Sheet var1, SSheet var2);

    protected abstract int getAnchorWidthInPx(ClientAnchor var1, Sheet var2);

    protected abstract int getAnchorHeightInPx(ClientAnchor var1, Sheet var2);

    protected void importNamedRange() {
        for (Name definedName : this.workbook.getAllNames()) {
            if (this.skipName(definedName)) continue;
            SName namedRange = null;
            namedRange = definedName.getSheetIndex() == -1 ? this.book.createName(definedName.getNameName()) : this.book.createName(definedName.getNameName(), definedName.getSheetName());
            namedRange.setRefersToFormula(definedName.getRefersToFormula());
        }
    }

    protected boolean skipName(Name definedName) {
        String namename = definedName.getNameName();
        if (namename == null) {
            return true;
        }
        if (definedName.isFunctionName()) {
            return true;
        }
        return definedName.getRefersToFormula() == null;
    }

    protected abstract void importExternalBookLinks();

    protected void importSheetDefaultColumnWidth(Sheet poiSheet, SSheet sheet) {
        int defaultWidth = UnitUtil.defaultColumnWidthToPx(poiSheet.getDefaultColumnWidth(), ((AbstractBookAdv)this.book).getCharWidth());
        sheet.setDefaultColumnWidth(defaultWidth);
    }

    protected SSheet importSheet(Sheet poiSheet, int poiSheetIndex) {
        CellRangeAddress colrng;
        CellRangeAddress rowrng;
        InternalSheet internalSheet;
        PageSettingsBlock pageSettings;
        SFooter footer;
        SSheet sheet = this.book.createSheet(poiSheet.getSheetName());
        sheet.setDefaultRowHeight(UnitUtil.twipToPx(poiSheet.getDefaultRowHeight()));
        this.importSheetDefaultColumnWidth(poiSheet, sheet);
        SSheetViewInfo viewInfo = sheet.getViewInfo();
        viewInfo.setNumOfRowFreeze(BookHelper.getRowFreeze(poiSheet));
        viewInfo.setNumOfColumnFreeze(BookHelper.getColumnFreeze(poiSheet));
        viewInfo.setDisplayGridlines(poiSheet.isDisplayGridlines());
        viewInfo.setColumnBreaks(poiSheet.getColumnBreaks());
        viewInfo.setRowBreaks(poiSheet.getRowBreaks());
        viewInfo.setTabSelected(poiSheet.isSelected());
        SPrintSetup sps = sheet.getPrintSetup();
        SHeader header = viewInfo.getHeader();
        if (header != null) {
            header.setCenterText(poiSheet.getHeader().getCenter());
            header.setLeftText(poiSheet.getHeader().getLeft());
            header.setRightText(poiSheet.getHeader().getRight());
            sps.setHeader(header);
        }
        if ((footer = viewInfo.getFooter()) != null) {
            footer.setCenterText(poiSheet.getFooter().getCenter());
            footer.setLeftText(poiSheet.getFooter().getLeft());
            footer.setRightText(poiSheet.getFooter().getRight());
            sps.setFooter(footer);
        }
        if ((pageSettings = (internalSheet = ((HSSFSheet)poiSheet).getSheet()).getPageSettings()).isDiffOddEven()) {
            HSSFEvenHeader poiEvenHeader = new HSSFEvenHeader(pageSettings);
            HeaderFooterImpl evenHeader = new HeaderFooterImpl();
            evenHeader.setCenterText(poiEvenHeader.getCenter());
            evenHeader.setLeftText(poiEvenHeader.getLeft());
            evenHeader.setRightText(poiEvenHeader.getRight());
            sps.setEvenHeader(evenHeader);
            HSSFEvenFooter poiEvenFooter = new HSSFEvenFooter(pageSettings);
            HeaderFooterImpl evenFooter = new HeaderFooterImpl();
            evenFooter.setCenterText(poiEvenFooter.getCenter());
            evenFooter.setLeftText(poiEvenFooter.getLeft());
            evenFooter.setRightText(poiEvenFooter.getRight());
            sps.setEvenFooter(evenFooter);
        }
        if (pageSettings.isDiffFirst()) {
            HSSFFirstHeader poiFirstHeader = new HSSFFirstHeader(pageSettings);
            HeaderFooterImpl firstHeader = new HeaderFooterImpl();
            firstHeader.setCenterText(poiFirstHeader.getCenter());
            firstHeader.setLeftText(poiFirstHeader.getLeft());
            firstHeader.setRightText(poiFirstHeader.getRight());
            sps.setFirstHeader(firstHeader);
            HSSFFirstFooter poiFirstFooter = new HSSFFirstFooter(pageSettings);
            HeaderFooterImpl firstFooter = new HeaderFooterImpl();
            firstFooter.setCenterText(poiFirstFooter.getCenter());
            firstFooter.setLeftText(poiFirstFooter.getLeft());
            firstFooter.setRightText(poiFirstFooter.getRight());
            sps.setFirstFooter(firstFooter);
        }
        HSSFPrintSetup poips = (HSSFPrintSetup)poiSheet.getPrintSetup();
        sps.setBottomMargin(poiSheet.getMargin((short)3));
        sps.setTopMargin(poiSheet.getMargin((short)2));
        sps.setLeftMargin(poiSheet.getMargin((short)0));
        sps.setRightMargin(poiSheet.getMargin((short)1));
        sps.setHeaderMargin(poiSheet.getMargin((short)4));
        sps.setFooterMargin(poiSheet.getMargin((short)5));
        sps.setAlignWithMargins(pageSettings.isAlignMargins());
        sps.setErrorPrintMode(poips.getErrorsMode());
        sps.setFitHeight(poips.getFitHeight());
        sps.setFitWidth(poips.getFitWidth());
        sps.setHCenter(poiSheet.getHorizontallyCenter());
        sps.setLandscape(poips.getLandscape());
        sps.setLeftToRight(poips.getLeftToRight());
        sps.setPageStart(poips.getUsePage() ? poips.getPageStart() : (short)0);
        sps.setPaperSize(PoiEnumConversion.toPaperSize(poips.getPaperSize()));
        sps.setCommentsMode(poips.getCommentsMode());
        sps.setPrintGridlines(poiSheet.isPrintGridlines());
        sps.setPrintHeadings(internalSheet.getPrintHeaders().getPrintHeaders());
        sps.setScale(poips.getScale());
        sps.setScaleWithDoc(pageSettings.isScaleWithDoc());
        sps.setDifferentOddEvenPage(pageSettings.isDiffOddEven());
        sps.setDifferentFirstPage(pageSettings.isDiffFirst());
        sps.setVCenter(poiSheet.getVerticallyCenter());
        Workbook poiBook = poiSheet.getWorkbook();
        String area = poiBook.getPrintArea(poiSheetIndex);
        if (area != null) {
            sps.setPrintArea(area);
        }
        if ((rowrng = poiSheet.getRepeatingRows()) != null) {
            sps.setRepeatingRowsTitle(rowrng.getFirstRow(), rowrng.getLastRow());
        }
        if ((colrng = poiSheet.getRepeatingColumns()) != null) {
            sps.setRepeatingColumnsTitle(colrng.getFirstColumn(), colrng.getLastColumn());
        }
        sheet.setPassword(poiSheet.getProtect() ? "" : null);
        this.importPassword(poiSheet, sheet);
        if (poiBook.isSheetHidden(poiSheetIndex)) {
            sheet.setSheetVisible(SSheet.SheetVisible.HIDDEN);
        } else if (poiBook.isSheetVeryHidden(poiSheetIndex)) {
            sheet.setSheetVisible(SSheet.SheetVisible.VERY_HIDDEN);
        } else {
            sheet.setSheetVisible(SSheet.SheetVisible.VISIBLE);
        }
        this.importConditionalFormatting(sheet, poiSheet);
        return sheet;
    }

    protected abstract void importPassword(Sheet var1, SSheet var2);

    protected void importMergedRegions(Sheet poiSheet, SSheet sheet) {
        int nMerged = poiSheet.getNumMergedRegions();
        SheetImpl sheetImpl = (SheetImpl)sheet;
        for (int i = nMerged - 1; i >= 0; --i) {
            CellRangeAddress mergedRegion = poiSheet.getMergedRegion(i);
            CellRegion r = new CellRegion(mergedRegion.getFirstRow(), mergedRegion.getFirstColumn(), mergedRegion.getLastRow(), mergedRegion.getLastColumn());
            CellRegion overlapped = sheetImpl.checkMergedRegion(r);
            if (overlapped != null) {
                _logger.warn("Drop the region " + String.valueOf(r) + " which is overlapped with existing merged area " + String.valueOf(overlapped) + ".");
                continue;
            }
            sheetImpl.addDirectlyMergedRegion(r);
        }
    }

    protected abstract void importDrawings(Sheet var1, SSheet var2);

    protected abstract void importValidation(Sheet var1, SSheet var2);

    protected SRow importRow(Row poiRow, SSheet sheet) {
        SRow row = sheet.getRow(poiRow.getRowNum());
        row.setHeight(UnitUtil.twipToPx(poiRow.getHeight()));
        row.setCustomHeight(((HSSFRow)poiRow).isCustomHeight());
        row.setHidden(poiRow.getZeroHeight());
        CellStyle rowStyle = poiRow.getRowStyle();
        if (rowStyle != null) {
            row.setCellStyle(this.importCellStyle(rowStyle));
        }
        for (Cell poiCell : poiRow) {
            this.importCell(poiCell, poiRow.getRowNum(), sheet);
        }
        return row;
    }

    protected SCell importCell(Cell poiCell, int row, SSheet sheet) {
        Comment poiComment;
        SCell cell = sheet.getCell(row, poiCell.getColumnIndex());
        cell.setCellStyle(this.importCellStyle(poiCell.getCellStyle()));
        switch (poiCell.getCellType()) {
            case NUMERIC: {
                cell.setNumberValue(poiCell.getNumericCellValue());
                break;
            }
            case STRING: {
                RichTextString poiRichTextString = poiCell.getRichStringCellValue();
                if (poiRichTextString != null && poiRichTextString.numFormattingRuns() > 0) {
                    SRichText richText = cell.setupRichTextValue();
                    this.importRichText(poiCell, poiRichTextString, richText);
                    break;
                }
                cell.setStringValue(poiCell.getStringCellValue());
                break;
            }
            case BOOLEAN: {
                cell.setBooleanValue(poiCell.getBooleanCellValue());
                break;
            }
            case FORMULA: {
                cell.setFormulaValue(poiCell.getCellFormula());
                if (!this.isImportCache() || ((HSSFCell)poiCell).isCalcOnLoad() || this.mustCalc(cell)) break;
                BoolEval val = null;
                switch (poiCell.getCachedFormulaResultType()) {
                    case NUMERIC: {
                        val = new NumberEval(poiCell.getNumericCellValue());
                        break;
                    }
                    case STRING: {
                        RichTextString poiRichTextString0 = poiCell.getRichStringCellValue();
                        if (poiRichTextString0 != null && poiRichTextString0.numFormattingRuns() > 0) {
                            RichTextImpl richText = new RichTextImpl();
                            this.importRichText(poiCell, poiRichTextString0, richText);
                            val = new StringEval(richText.getText());
                            break;
                        }
                        val = new StringEval(poiCell.getStringCellValue());
                        break;
                    }
                    case BOOLEAN: {
                        val = BoolEval.valueOf((boolean)poiCell.getBooleanCellValue());
                        break;
                    }
                    case ERROR: {
                        val = ErrorEval.valueOf((int)poiCell.getErrorCellValue());
                        break;
                    }
                }
                if (val == null) break;
                ((AbstractCellAdv)cell).setFormulaResultValue((ValueEval)val);
                break;
            }
            case ERROR: {
                cell.setErrorValue(PoiEnumConversion.toErrorCode(poiCell.getErrorCellValue()));
                break;
            }
        }
        Hyperlink poiHyperlink = poiCell.getHyperlink();
        if (poiHyperlink != null) {
            String addr = poiHyperlink.getAddress();
            String label = poiHyperlink.getLabel();
            SHyperlink hyperlink = cell.setupHyperlink(PoiEnumConversion.toHyperlinkType(poiHyperlink.getType()), addr == null ? "" : addr, label == null ? "" : label);
            cell.setHyperlink(hyperlink);
        }
        if ((poiComment = poiCell.getCellComment()) != null) {
            SComment comment = cell.setupComment();
            comment.setAuthor(poiComment.getAuthor());
            comment.setVisible(poiComment.isVisible());
            RichTextString poiRichTextString = poiComment.getString();
            if (poiRichTextString != null && poiRichTextString.numFormattingRuns() > 0) {
                this.importRichText(poiCell, poiComment.getString(), comment.setupRichText());
            } else {
                comment.setText(poiComment.toString());
            }
        }
        return cell;
    }

    protected void importRichText(Cell poiCell, RichTextString poiRichTextString0, SRichText richText) {
        HSSFRichTextString poiRichTextString = (HSSFRichTextString)poiRichTextString0;
        int count = poiRichTextString.numFormattingRuns();
        if (count <= 0) {
            String cellValue = poiRichTextString.getString();
            richText.addSegment(cellValue, null);
        } else {
            String content;
            int i = 0;
            int prevFormattingRunIndex = poiRichTextString.getIndexOfFormattingRun(0);
            if (prevFormattingRunIndex > 0) {
                content = poiRichTextString.getStringAt(i);
                richText.addSegment(content, null);
                ++i;
            }
            while (i < count) {
                content = poiRichTextString.getStringAt(i);
                richText.addSegment(content, this.toZssFont(this.getPoiFontFromRichText(this.workbook, poiCell, (RichTextString)poiRichTextString, i)));
                ++i;
            }
        }
    }

    protected SCellStyle importCellStyle(CellStyle poiCellStyle) {
        return this.importCellStyle(poiCellStyle, true);
    }

    protected SCellStyle importCellStyle(CellStyle poiCellStyle, boolean inStyleTable) {
        SCellStyle cellStyle = this.styleCache.getCellStyleCache().get(poiCellStyle);
        if (cellStyle == null) {
            SCellStyleBuilder builder = inStyleTable ? this.book.createCellStyle() : this.book.addCellStyle();
            builder.dataFormat(poiCellStyle.getDataFormatString()).directFormat(BuiltinFormats.getBuiltinFormat((int)poiCellStyle.getDataFormat()) == null).wrapText(poiCellStyle.getWrapText()).locked(poiCellStyle.getLocked()).alignment(PoiEnumConversion.toHorizontalAlignment(poiCellStyle.getAlignment())).verticalAlignment(PoiEnumConversion.toVerticalAlignment(poiCellStyle.getVerticalAlignment())).rotation(poiCellStyle.getRotation()).indention(poiCellStyle.getIndention());
            SFill.FillPattern fillPattern = PoiEnumConversion.toFillPattern(poiCellStyle.getFillPattern());
            Color fgColor = poiCellStyle.getFillForegroundColorColor();
            Color bgColor = poiCellStyle.getFillBackgroundColorColor();
            String fgColorHtml = BookHelper.colorToForegroundHTML(this.workbook, fgColor);
            String bgColorHtml = BookHelper.colorToBackgroundHTML(this.workbook, bgColor);
            if (fillPattern == SFill.FillPattern.SOLID) {
                String tmp = fgColorHtml;
                fgColorHtml = bgColorHtml;
                bgColorHtml = tmp;
            }
            builder.fillPattern(fillPattern).fillColor(fgColorHtml).backColor(bgColorHtml).borderLeft(PoiEnumConversion.toBorderType(poiCellStyle.getBorderLeft())).borderTop(PoiEnumConversion.toBorderType(poiCellStyle.getBorderTop())).borderRight(PoiEnumConversion.toBorderType(poiCellStyle.getBorderRight())).borderBottom(PoiEnumConversion.toBorderType(poiCellStyle.getBorderBottom())).borderLeftColor(BookHelper.colorToBorderHTML(this.workbook, this.getBorderColor(poiCellStyle, poiCellStyle.getLeftBorderColor()))).borderTopColor(BookHelper.colorToBorderHTML(this.workbook, this.getBorderColor(poiCellStyle, poiCellStyle.getTopBorderColor()))).borderRightColor(BookHelper.colorToBorderHTML(this.workbook, this.getBorderColor(poiCellStyle, poiCellStyle.getRightBorderColor()))).borderBottomColor(BookHelper.colorToBorderHTML(this.workbook, this.getBorderColor(poiCellStyle, poiCellStyle.getBottomBorderColor()))).hidden(poiCellStyle.getHidden()).font(this.importFont(poiCellStyle));
            cellStyle = (SCellStyle)builder.build();
            this.styleCache.getCellStyleCache().put(poiCellStyle, cellStyle);
        }
        return cellStyle;
    }

    private Color getBorderColor(CellStyle poiCellStyle, short xlsBorderSide) {
        return ((HSSFWorkbook)this.workbook).getCustomPalette().getColor(xlsBorderSide);
    }

    protected SFont importFont(CellStyle poiCellStyle) {
        int fontIndex = poiCellStyle.getFontIndex();
        SFont font = this.styleCache.getFontCache().get(fontIndex);
        if (font == null) {
            Font poiFont = this.workbook.getFontAt(fontIndex);
            font = this.createZssFont(poiFont);
            this.styleCache.getFontCache().put(fontIndex, font);
        }
        return font;
    }

    protected SFont toZssFont(Font poiFont) {
        if (poiFont == null) {
            return null;
        }
        int fontIndex = poiFont.getIndex();
        SFont font = this.styleCache.getFontCache().get(fontIndex);
        if (font == null) {
            font = this.createZssFont(poiFont);
            this.styleCache.getFontCache().put(fontIndex, font);
        }
        return font;
    }

    protected SFont createZssFont(Font poiFont) {
        return (SFont)this.book.addFont().name(poiFont.getFontName()).boldweight(PoiEnumConversion.toBoldweight(poiFont.getBold())).italic(poiFont.getItalic()).strikeout(poiFont.getStrikeout()).underline(PoiEnumConversion.toUnderline(poiFont.getUnderline())).heightPoints(poiFont.getFontHeightInPoints()).typeOffset(PoiEnumConversion.toTypeOffset(poiFont.getTypeOffset())).color(BookHelper.getFontHTMLColor(this.workbook, poiFont)).build();
    }

    protected ViewAnchor toViewAnchor(Sheet poiSheet, ClientAnchor clientAnchor) {
        int width = this.getAnchorWidthInPx(clientAnchor, poiSheet);
        int height = this.getAnchorHeightInPx(clientAnchor, poiSheet);
        ViewAnchor viewAnchor = new ViewAnchor(clientAnchor.getRow1(), clientAnchor.getCol1(), width, height);
        viewAnchor.setXOffset(this.getXoffsetInPixel(clientAnchor, poiSheet));
        viewAnchor.setYOffset(this.getYoffsetInPixel(clientAnchor, poiSheet));
        return viewAnchor;
    }

    protected abstract int getXoffsetInPixel(ClientAnchor var1, Sheet var2);

    protected abstract int getYoffsetInPixel(ClientAnchor var1, Sheet var2);

    protected void importPicture(List<Picture> poiPictures, Sheet poiSheet, SSheet sheet) {
        for (Picture poiPicture : poiPictures) {
            PictureData poiPicData = poiPicture.getPictureData();
            Integer picDataIx = this.importedPictureData.get(poiPicData);
            if (picDataIx != null) {
                sheet.addPicture(picDataIx, this.toViewAnchor(poiSheet, poiPicture.getClientAnchor()));
                continue;
            }
            SPicture.Format format = SPicture.Format.valueOfFileExtension(poiPicData.suggestFileExtension());
            if (format == null) continue;
            SPicture pic = sheet.addPicture(format, poiPicData.getData(), this.toViewAnchor(poiSheet, poiPicture.getClientAnchor()));
            this.importedPictureData.put(poiPicData, pic.getPictureData().getIndex());
        }
    }

    protected void importAutoFilter(Sheet poiSheet, SSheet sheet) {
    }

    protected void importAutoFilterColumns(AutoFilter poiFilter, SAutoFilter zssFilter, int numberOfColumn) {
    }

    protected Font getPoiFontFromRichText(Workbook book, Cell cell, RichTextString rstr, int run) {
        Font font;
        if (run < 0) {
            return null;
        }
        Font font2 = font = rstr instanceof HSSFRichTextString ? book.getFontAt((int)((HSSFRichTextString)rstr).getFontOfFormattingRun(run)) : null;
        if (font == null) {
            CellStyle style = cell.getCellStyle();
            int fontIndex = style != null ? style.getFontIndex() : 0;
            return book.getFontAt(fontIndex);
        }
        return font;
    }

    protected abstract void importSheetProtection(Sheet var1, SSheet var2);

    protected abstract void importTables(Sheet var1, SSheet var2);

    @Override
    public void setImportCache(boolean b) {
        this._importCache = b;
    }

    @Override
    protected boolean isImportCache() {
        return this._importCache;
    }

    protected boolean mustCalc(SCell cell) {
        FormulaExpression val = ((AbstractCellAdv)cell).getFormulaExpression();
        for (Ptg ptg : val.getPtgs()) {
            if (!(ptg instanceof FuncVarPtg) || ((FuncVarPtg)ptg).getFunctionIndex() != 148) continue;
            return true;
        }
        return false;
    }

    protected abstract void importConditionalFormatting(SSheet var1, Sheet var2);

    protected void importExtraStyles() {
    }

    protected void importTableStyles() {
    }
}

