/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.sys.formula;

import io.keikai.model.impl.sys.formula.FunctionResolverImpl;
import io.keikai.model.sys.formula.FunctionResolver;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Library;

public class FunctionResolverFactory {
    private static final Logger logger = LoggerFactory.getLogger(FunctionResolverFactory.class);
    private static Class<?> functionResolverClazz;

    public static FunctionResolver createFunctionResolver() {
        try {
            if (functionResolverClazz != null) {
                return (FunctionResolver)functionResolverClazz.newInstance();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            functionResolverClazz = null;
        }
        return new FunctionResolverImpl();
    }

    static {
        String clz = Optional.ofNullable(Library.getProperty((String)"io.keikai.model.FunctionResolver.class")).orElse(Library.getProperty((String)"org.zkoss.zss.model.FunctionResolver.class"));
        if (clz != null) {
            try {
                functionResolverClazz = Class.forName(clz);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

