/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl.chart;

import io.keikai.model.ErrorValue;
import io.keikai.model.SChart;
import io.keikai.model.SChartAxis;
import io.keikai.model.chart.SGeneralChartData;
import io.keikai.model.chart.SSeries;
import io.keikai.model.impl.AbstractBookSeriesAdv;
import io.keikai.model.impl.AbstractChartAdv;
import io.keikai.model.impl.EvaluationUtil;
import io.keikai.model.impl.ObjectRefImpl;
import io.keikai.model.impl.chart.AbstractGeneralChartDataAdv;
import io.keikai.model.impl.chart.ChartUtil;
import io.keikai.model.impl.chart.SeriesImpl;
import io.keikai.model.sys.EngineFactory;
import io.keikai.model.sys.dependency.Ref;
import io.keikai.model.sys.formula.EvaluationResult;
import io.keikai.model.sys.formula.FormulaEngine;
import io.keikai.model.sys.formula.FormulaEvaluationContext;
import io.keikai.model.sys.formula.FormulaExpression;
import io.keikai.model.sys.formula.FormulaParseContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public abstract class GeneralChartDataImpl
extends AbstractGeneralChartDataAdv
implements SGeneralChartData {
    private static final long serialVersionUID = 1L;
    private FormulaExpression _catFormulaExpr;
    private final List<SeriesImpl> _serieses = new LinkedList<SeriesImpl>();
    private AbstractChartAdv _chart;
    private final String _id;
    private Object _evalResult;
    private boolean _evaluated = false;
    private boolean _visibleEvaluated = false;
    private int _seriesCount = 0;
    private boolean[] _hiddenCategoriesInfo;
    private SChartAxis categoryAxis;
    private SChartAxis dateAxis;
    private List<SChartAxis> valueAxes;

    public GeneralChartDataImpl(AbstractChartAdv chart, String id) {
        this._chart = chart;
        this._id = id;
    }

    @Override
    public SChart getChart() {
        return this._chart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void evalFormula() {
        if (this._evaluated) {
            return;
        }
        GeneralChartDataImpl generalChartDataImpl = this;
        synchronized (generalChartDataImpl) {
            if (!this._evaluated) {
                if (this._catFormulaExpr != null) {
                    FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
                    EvaluationResult result = fe.evaluate(this._catFormulaExpr, new FormulaEvaluationContext(this._chart.getSheet(), this.getRef()));
                    Object val = result.getValue();
                    if (result.getType() == EvaluationResult.ResultType.SUCCESS) {
                        this._evalResult = val;
                    } else if (result.getType() == EvaluationResult.ResultType.ERROR) {
                        this._evalResult = val instanceof ErrorValue ? val : ErrorValue.valueOf((byte)29);
                    }
                }
                this._evaluated = true;
            }
        }
    }

    @Override
    public int getNumOfSeries() {
        return this._serieses.size();
    }

    @Override
    public SSeries getSeries(int i) {
        return this._serieses.get(i);
    }

    @Override
    public int getNumOfCategory() {
        this.evalFormula();
        return EvaluationUtil.sizeOf(this._evalResult);
    }

    @Override
    public Object getCategory(int i) {
        this.evalFormula();
        if (i >= EvaluationUtil.sizeOf(this._evalResult)) {
            return String.valueOf(i + 1);
        }
        Object cat = EvaluationUtil.valueOf(this._evalResult, i);
        boolean showCat = false;
        for (SSeries sSeries : this._serieses) {
            Object val = sSeries.getValue(i);
            if (!(val instanceof Integer) || (Integer)val == 0 || "0".equals(val)) continue;
            showCat = true;
            break;
        }
        return cat == null || "".equals(cat) ? (showCat ? String.valueOf(i + 1) : "") : cat;
    }

    @Override
    public SSeries addSeries() {
        SeriesImpl series = new SeriesImpl(this._chart, this._chart.getId() + "-series" + this._seriesCount++);
        this._serieses.add(series);
        return series;
    }

    protected void checkOwnership(SSeries series) {
        if (!this._serieses.contains(series)) {
            throw new IllegalStateException("doesn't has ownership " + String.valueOf(series));
        }
    }

    @Override
    public void removeSeries(SSeries series) {
        this.checkOwnership(series);
        ((SeriesImpl)series).destroy();
        this._serieses.remove(series);
    }

    @Override
    public void setCategoriesFormula(String expr) {
        this.checkOrphan();
        this._evaluated = false;
        this.clearFormulaDependency();
        if (expr != null && expr != "") {
            FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
            this._catFormulaExpr = fe.parse(expr, new FormulaParseContext(this._chart.getSheet(), this.getRef()));
        } else {
            this._catFormulaExpr = null;
        }
    }

    @Override
    public String getCategoriesFormula() {
        return this._catFormulaExpr == null ? null : this._catFormulaExpr.getFormulaString();
    }

    @Override
    public void clearFormulaResultCache() {
        this._evalResult = null;
        this._evaluated = false;
        this._visibleEvaluated = false;
        for (SeriesImpl series : this._serieses) {
            series.clearFormulaResultCache();
        }
    }

    @Override
    public boolean isFormulaParsingError() {
        return this._catFormulaExpr == null ? false : this._catFormulaExpr.hasError();
    }

    private void clearFormulaDependency() {
        if (this._catFormulaExpr != null) {
            ((AbstractBookSeriesAdv)this._chart.getSheet().getBook().getBookSeries()).getDependencyTable().clearDependents(this.getRef());
        }
    }

    private Ref getRef() {
        return new ObjectRefImpl(this._chart, new String[]{this._chart.getId(), this._id});
    }

    @Override
    public void destroy() {
        this.checkOrphan();
        this.clearFormulaDependency();
        this.clearFormulaResultCache();
        for (SeriesImpl series : this._serieses) {
            series.destroy();
        }
        this._chart = null;
    }

    @Override
    public void checkOrphan() {
        if (this._chart == null) {
            throw new IllegalStateException("doesn't connect to parent");
        }
    }

    public void copyFrom(GeneralChartDataImpl src) {
        this.checkOrphan();
        String expr = src.getCategoriesFormula();
        if (expr != null) {
            this.setCategoriesFormula(expr);
        }
        for (SeriesImpl s : src._serieses) {
            this._serieses.add(s.cloneSeriesImpl(this._chart));
        }
        this._seriesCount = src._seriesCount;
        if (src.categoryAxis != null) {
            List<SChartAxis> srcCatAxes = src._chart.getCategoryAxises();
            for (int i = 0; i < srcCatAxes.size(); ++i) {
                if (srcCatAxes.get(i).getId() != src.categoryAxis.getId()) continue;
                List<SChartAxis> catAxes = this._chart.getCategoryAxises();
                this.categoryAxis = catAxes.get(i);
            }
        }
        if (src.dateAxis != null) {
            List<SChartAxis> srcDateAxes = src._chart.getDateAxises();
            for (int i = 0; i < srcDateAxes.size(); ++i) {
                if (srcDateAxes.get(i).getId() != src.dateAxis.getId()) continue;
                List<SChartAxis> dateAxes = this._chart.getDateAxises();
                this.dateAxis = dateAxes.get(i);
            }
        }
        ArrayList<SChartAxis> valueAxes = new ArrayList<SChartAxis>();
        List<SChartAxis> srcValueAxes = src.valueAxes;
        if (srcValueAxes != null) {
            List<SChartAxis> srcChartValAxes = src._chart.getValueAxises();
            for (SChartAxis srcValAx : srcValueAxes) {
                long id = srcValAx.getId();
                for (int j = 0; j < srcChartValAxes.size(); ++j) {
                    if (srcChartValAxes.get(j).getId() != id) continue;
                    valueAxes.add(this._chart.getValueAxises().get(j));
                }
            }
            this.valueAxes = valueAxes;
        }
    }

    @Override
    public FormulaExpression getCategoriesFormulaExpression() {
        return this._catFormulaExpr;
    }

    @Override
    public void setCategoriesFormula(FormulaExpression fexpr) {
        this.checkOrphan();
        this._evaluated = false;
        this.clearFormulaDependency();
        this._catFormulaExpr = fexpr;
        if (fexpr != null) {
            FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
            fe.updateDependencyTable(fexpr, new FormulaParseContext(this._chart.getSheet(), this.getRef()));
        }
    }

    @Override
    public boolean isCategoryHidden(int index) {
        this.evalVisibleInfo();
        return this._hiddenCategoriesInfo == null ? false : (this._hiddenCategoriesInfo.length < index + 1 ? false : this._hiddenCategoriesInfo[index]);
    }

    public SChartAxis getCategoryAxis() {
        return this.categoryAxis;
    }

    public void setCategoryAxis(SChartAxis category) {
        this.categoryAxis = category;
    }

    public SChartAxis getDateAxis() {
        return this.dateAxis;
    }

    public void setDateAxis(SChartAxis dateAxis) {
        this.dateAxis = dateAxis;
    }

    public List<SChartAxis> getValueAxes() {
        return this.valueAxes;
    }

    public void setValueAxes(List<SChartAxis> values) {
        this.valueAxes = values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evalVisibleInfo() {
        if (this._visibleEvaluated) {
            return;
        }
        GeneralChartDataImpl generalChartDataImpl = this;
        synchronized (generalChartDataImpl) {
            if (!this._visibleEvaluated) {
                HashMap<Integer, Boolean> cachedRowValues = new HashMap<Integer, Boolean>(16);
                HashMap<Integer, Boolean> cachedColumnValues = new HashMap<Integer, Boolean>(16);
                this._hiddenCategoriesInfo = new boolean[this.getNumOfCategory()];
                ChartUtil.evalVisibleInfo(this._chart, this._catFormulaExpr, this._hiddenCategoriesInfo, cachedRowValues, cachedColumnValues);
                this._visibleEvaluated = true;
            }
        }
    }
}

