/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.importer.xml;

import io.keikai.importer.xml.JSONNode;
import io.keikai.json.JSONAware;
import io.keikai.json.JSONValue;
import io.keikai.util.Converter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Cell
implements JSONNode {
    private int r = -1;
    private int c = -1;
    private int s = -1;
    private CellType t;
    private int cm = -1;
    private int vm = -1;
    private Boolean ph;
    private JSONAware f;
    private Object v;
    private JSONAware is;
    private JSONAware extLst;

    @Override
    public void addAttributes(Map<String, String> attributes) {
        String v;
        String r = attributes.remove("r");
        if (r != null) {
            int[] colRow = Cell.getIndexes(r);
            this.c = colRow[0];
            this.r = colRow[1];
        }
        if ((v = attributes.remove("s")) != null) {
            this.s = Integer.parseInt(v);
        }
        if ((v = attributes.remove("t")) != null) {
            this.t = CellType.valueOf(v);
        }
        if ((v = attributes.remove("cm")) != null) {
            this.cm = Integer.parseInt(v);
        }
        if ((v = attributes.remove("vm")) != null) {
            this.vm = Integer.parseInt(v);
        }
        if ((v = attributes.remove("ph")) != null) {
            this.ph = Cell.toBoolean(v);
        }
        if (!attributes.isEmpty()) {
            throw new IllegalArgumentException("Unknown attributes [" + String.valueOf(attributes) + "]");
        }
    }

    private static int[] getIndexes(String a1Notation) {
        char code;
        int index;
        int colIndex = 0;
        int len = a1Notation.length();
        for (index = 0; index < len && (code = a1Notation.charAt(index)) >= 'A' && code <= 'Z'; ++index) {
            int digit = code - 64;
            colIndex = colIndex * 26 + digit;
        }
        if (colIndex > 0) {
            // empty if block
        }
        return new int[]{--colIndex, Integer.parseInt(a1Notation.substring(index))};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addElement(String name, JSONAware element) {
        switch (name) {
            case "v": {
                if (element instanceof Map) {
                    this.v = (String)((Map)((Object)element)).get("_");
                    if (this.t == CellType.s) {
                        this.v = Integer.parseInt((String)this.v);
                        return;
                    }
                    if (this.t != null) {
                        if (this.t != CellType.n) return;
                    }
                    String str = (String)this.v;
                    boolean parsed = false;
                    if (str.toLowerCase().indexOf(101) == -1) {
                        if (str.indexOf(46) == -1) {
                            try {
                                this.v = Integer.parseInt(str);
                                return;
                            }
                            catch (NumberFormatException e) {
                                try {
                                    this.v = Long.parseLong(str);
                                    return;
                                }
                                catch (NumberFormatException numberFormatException) {}
                            }
                        } else {
                            try {
                                this.v = Double.parseDouble(str);
                                return;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    if (parsed) return;
                    this.v = new BigDecimal(str);
                    return;
                }
                if (this.v != null) return;
                this.v = "null";
                return;
            }
            case "f": {
                this.f = element;
                return;
            }
            case "is": {
                this.is = element;
                return;
            }
            case "extLst": {
                this.extLst = element;
                return;
            }
            default: {
                throw new IllegalArgumentException("Unknown element [" + name + "]");
            }
        }
    }

    @Override
    public Object get(String key) {
        switch (key) {
            case "r": {
                return Converter.numToAbc(this.c) + this.r;
            }
            case "s": {
                return this.s == -1 ? null : String.valueOf(this.s);
            }
            case "t": {
                return this.t == null ? (this.v == "null" || this.v == null ? null : CellType.n.toString()) : String.valueOf((Object)this.t);
            }
            case "cm": {
                return this.cm == -1 ? null : String.valueOf(this.cm);
            }
            case "vm": {
                return this.vm == -1 ? null : String.valueOf(this.vm);
            }
            case "ph": {
                return this.ph == null ? null : Character.valueOf(this.ph != false ? (char)'1' : '0');
            }
            case "v": {
                return this.v == "null" || this.v == null ? null : String.valueOf(this.v);
            }
            case "f": {
                return this.f;
            }
            case "is": {
                return this.is;
            }
            case "extLst": {
                return this.extLst;
            }
        }
        throw new IllegalArgumentException("Unknown key [" + key + "]");
    }

    @Override
    public void addContent(String text) {
        if (!text.trim().isEmpty()) {
            throw new UnsupportedOperationException("Unsupported content value: [" + text + "]");
        }
    }

    private List getAttributeKeys() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.r != -1) {
            list.add("r");
        }
        if (this.s != -1) {
            list.add("s");
        }
        if (this.t != null) {
            list.add("t");
        }
        if (this.cm != -1) {
            list.add("cm");
        }
        if (this.vm != -1) {
            list.add("vm");
        }
        if (this.ph != null) {
            list.add("ph");
        }
        return list;
    }

    @Override
    public String toJSONString() {
        return JSONValue.toJSONString(new HashMap(6){
            {
                List keys = Cell.this.getAttributeKeys();
                if (!keys.isEmpty()) {
                    this.put("", keys);
                }
                if (Cell.this.r != -1) {
                    this.put("r", Converter.numToAbc(Cell.this.c) + Cell.this.r);
                }
                if (Cell.this.s != -1) {
                    this.put("s", String.valueOf(Cell.this.s));
                }
                if (Cell.this.t != null) {
                    this.put("t", String.valueOf((Object)Cell.this.t));
                }
                if (Cell.this.ph != null) {
                    this.put("ph", Character.valueOf(Cell.this.ph != false ? (char)'1' : '0'));
                }
                if (Cell.this.cm != -1) {
                    this.put("cm", String.valueOf(Cell.this.cm));
                }
                if (Cell.this.vm != -1) {
                    this.put("vm", String.valueOf(Cell.this.vm));
                }
                if (Cell.this.f != null) {
                    this.put("f", Cell.this.f);
                }
                if (Cell.this.v != null) {
                    if (Cell.this.v == "null") {
                        this.put("v", null);
                    } else {
                        this.put("v", new HashMap(1){
                            {
                                this.put("_", String.valueOf(Cell.this.v));
                            }
                        });
                    }
                }
                if (Cell.this.is != null) {
                    this.put("is", Cell.this.is);
                }
            }
        });
    }

    private static boolean toBoolean(String s) {
        return "1".equals(s) || Boolean.parseBoolean(s);
    }

    private static enum CellType {
        b,
        n,
        e,
        s,
        str,
        inlineStr;

    }
}

