/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.importer;

import io.keikai.importer.Borders;
import io.keikai.importer.CategoryAxisJson;
import io.keikai.importer.CategorySeriesJson;
import io.keikai.importer.CellXfs;
import io.keikai.importer.ChartSpaceJson;
import io.keikai.importer.ChartType;
import io.keikai.importer.ChartTypeJson;
import io.keikai.importer.Colors;
import io.keikai.importer.DataPointJson;
import io.keikai.importer.DateAxisJson;
import io.keikai.importer.Drawings;
import io.keikai.importer.Fills;
import io.keikai.importer.Fonts;
import io.keikai.importer.ImportException;
import io.keikai.importer.ImportPhase;
import io.keikai.importer.LegendStyle;
import io.keikai.importer.NumFmts;
import io.keikai.importer.PictureJson;
import io.keikai.importer.SeriesJson;
import io.keikai.importer.ShapeJson;
import io.keikai.importer.ValueAxisJson;
import io.keikai.importer.View3DJson;
import io.keikai.importer.VmlDrawing;
import io.keikai.importer.XYSeriesJson;
import io.keikai.importer.XYZSeriesJson;
import io.keikai.importer.XlsxExtractor;
import io.keikai.importer.XlsxParser;
import io.keikai.json.JSONObject;
import io.keikai.model.CFIconImpl;
import io.keikai.model.CellRegion;
import io.keikai.model.SAutoFilter;
import io.keikai.model.SBook;
import io.keikai.model.SBookSeries;
import io.keikai.model.SBooks;
import io.keikai.model.SBorder;
import io.keikai.model.SCFIcon;
import io.keikai.model.SCFValueObject;
import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SCellStyleBuilder;
import io.keikai.model.SChart;
import io.keikai.model.SChartAxis;
import io.keikai.model.SColor;
import io.keikai.model.SColorFilter;
import io.keikai.model.SColorScale;
import io.keikai.model.SColumn;
import io.keikai.model.SColumnArray;
import io.keikai.model.SComment;
import io.keikai.model.SConditionalFormatting;
import io.keikai.model.SCustomFilters;
import io.keikai.model.SDataBar;
import io.keikai.model.SDataValidation;
import io.keikai.model.SDynamicFilter;
import io.keikai.model.SExtraStyle;
import io.keikai.model.SFill;
import io.keikai.model.SFont;
import io.keikai.model.SFooter;
import io.keikai.model.SHeader;
import io.keikai.model.SHyperlink;
import io.keikai.model.SIconSet;
import io.keikai.model.SName;
import io.keikai.model.SPicture;
import io.keikai.model.SPrintSetup;
import io.keikai.model.SRichText;
import io.keikai.model.SRow;
import io.keikai.model.SSheet;
import io.keikai.model.SSheetProtection;
import io.keikai.model.SSheetViewInfo;
import io.keikai.model.STable;
import io.keikai.model.STableColumn;
import io.keikai.model.STableStyle;
import io.keikai.model.STableStyleElem;
import io.keikai.model.STop10Filter;
import io.keikai.model.SheetRegion;
import io.keikai.model.ViewAnchor;
import io.keikai.model.chart.SChartData;
import io.keikai.model.chart.SGeneralChartData;
import io.keikai.model.chart.SSeries;
import io.keikai.model.impl.AbstractBookAdv;
import io.keikai.model.impl.AbstractCellAdv;
import io.keikai.model.impl.AbstractChartAdv;
import io.keikai.model.impl.AbstractChartAxisAdv;
import io.keikai.model.impl.AbstractDataValidationAdv;
import io.keikai.model.impl.AbstractFontBuilderAdv;
import io.keikai.model.impl.AbstractSeriesAdv;
import io.keikai.model.impl.AbstractSheetAdv;
import io.keikai.model.impl.BorderImpl;
import io.keikai.model.impl.BorderLineImpl;
import io.keikai.model.impl.CFValueObjectImpl;
import io.keikai.model.impl.ChartAxisImpl;
import io.keikai.model.impl.ColorFilterImpl;
import io.keikai.model.impl.ColorImpl;
import io.keikai.model.impl.ColorScaleImpl;
import io.keikai.model.impl.ConditionalFormattingImpl;
import io.keikai.model.impl.ConditionalFormattingRuleImpl;
import io.keikai.model.impl.CustomFilterImpl;
import io.keikai.model.impl.CustomFiltersImpl;
import io.keikai.model.impl.DataBarImpl;
import io.keikai.model.impl.DynamicFilterImpl;
import io.keikai.model.impl.ExtraFillImpl;
import io.keikai.model.impl.HeaderFooterImpl;
import io.keikai.model.impl.IconSetImpl;
import io.keikai.model.impl.ImmutableExtraStyleImpl;
import io.keikai.model.impl.NamedStyleImpl;
import io.keikai.model.impl.RichTextImpl;
import io.keikai.model.impl.SheetImpl;
import io.keikai.model.impl.TableColumnImpl;
import io.keikai.model.impl.TableImpl;
import io.keikai.model.impl.TableStyleElemImpl;
import io.keikai.model.impl.TableStyleImpl;
import io.keikai.model.impl.TableStyleInfoImpl;
import io.keikai.model.impl.Top10FilterImpl;
import io.keikai.model.impl.WorkbookProtectionImpl;
import io.keikai.model.impl.chart.AreaChartDataImpl;
import io.keikai.model.impl.chart.BarChartDataImpl;
import io.keikai.model.impl.chart.CategoryAxisImpl;
import io.keikai.model.impl.chart.DateAxisImpl;
import io.keikai.model.impl.chart.GeneralChartDataImpl;
import io.keikai.model.impl.chart.LineChartDataImpl;
import io.keikai.model.impl.chart.ValueAxisImpl;
import io.keikai.model.impl.sys.formula.FormulaEngineImpl;
import io.keikai.model.impl.sys.formula.ParsingBook;
import io.keikai.model.sys.EngineFactory;
import io.keikai.model.sys.formula.FormulaEngine;
import io.keikai.model.sys.formula.FormulaExpression;
import io.keikai.model.sys.formula.FormulaParseContext;
import io.keikai.model.sys.formula.FormulaType;
import io.keikai.model.util.Strings;
import io.keikai.range.impl.imexp.AbstractImporter;
import io.keikai.range.impl.imexp.BookHelper;
import io.keikai.range.impl.imexp.PoiEnumConversion;
import io.keikai.range.impl.imexp.StyleCache;
import io.keikai.range.impl.imexp.UnitUtil;
import io.keikai.util.Converter;
import io.keikai.util.Ref;
import io.keikai.util.XlsxJsonHelper;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.FormulaRenderer;
import org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import org.apache.poi.ss.formula.SharedFormula;
import org.apache.poi.ss.formula.eval.BoolEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.ptg.FuncVarPtg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.util.CellRangeAddress;
import org.jsoup.nodes.Document;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.util.Locales;
import org.zkoss.util.Pair;

public class XlsxImporter
extends AbstractImporter
implements Serializable {
    private static final long serialVersionUID = 20190918160712L;
    private static final Logger _logger = LoggerFactory.getLogger(XlsxImporter.class);
    protected Map<XlsxExtractor.XlsxXfExtractor, SCellStyle> importedXfs = new HashMap<XlsxExtractor.XlsxXfExtractor, SCellStyle>();
    protected StyleCache styleCaches = new StyleCache();
    protected ImportPhase _importPhase;
    protected Map<PictureJson, Integer> importedPictureJson = new HashMap<PictureJson, Integer>();
    protected Map<String, Ptg[]> _sharedFormulaPtgArray = new HashMap<String, Ptg[]>();
    protected SBook book;
    XlsxExtractor.XlsxThemesExtractor themes;
    XlsxExtractor.XlsxWorkbookExtractor workbookExtractor;
    public static final String BUILTIN_PRINT_AREA = "_xlnm.Print_Area";
    public static final String BUILTIN_PRINT_TITLE = "_xlnm.Print_Titles";
    Map<String, XlsxExtractor.XlsxHyperlinkExtractor> hyperlinksCache;
    VmlDrawing vmlDrawingCache;
    Map<String, XlsxExtractor.XlsxCommentExtractor> commentsCache;
    CellXfs cellXfsCache;
    Colors colorsCache;
    NumFmts numFmtsCache;
    Fonts fontsCache;
    Fills fillsCache;
    Borders bordersCache;
    Drawings drawingsCache;
    public static final int ERROR_NULL = 0;
    public static final int ERROR_DIV_0 = 7;
    public static final int ERROR_VALUE = 15;
    public static final int ERROR_REF = 23;
    public static final int ERROR_NAME = 29;
    public static final int ERROR_NUM = 36;
    public static final int ERROR_NA = 42;
    public static final int ERROR_FORMULA = 127;
    List<XlsxExtractor.XlsxXfExtractor> cellStyleXfsCache = new ArrayList<XlsxExtractor.XlsxXfExtractor>();

    @Override
    public SBook imports(InputStream inputStream, String bookName) throws IOException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("start to import {}", (Object)bookName);
        }
        this.importedXfs.clear();
        this.styleCaches.clear();
        this.book = SBooks.createBook(bookName);
        this.workbookExtractor = this.newXlsxExtractor(inputStream);
        Locale old = Locales.setThreadLocal((Locale)Locale.US);
        SBookSeries bookSeries = this.book.getBookSeries();
        boolean isCacheClean = bookSeries.isAutoFormulaCacheClean();
        try {
            this._importPhase = new ImportPhase(bookName);
            ((AbstractBookAdv)this.book).setPostProcessing(true);
            this._importPhase.setPhase("stylesheet");
            XlsxExtractor.XlsxStyleSheetExtractor styleSheet = this.workbookExtractor.getStyleSheet();
            this.themes = this.workbookExtractor.getThemes();
            this.importDefaultChartSeriesColors();
            this.importStyleSheet(styleSheet);
            this._importPhase.clear();
            this.setBookType(this.book);
            bookSeries.setAutoFormulaCacheClean(false);
            this._importPhase.setPhase("external book reference");
            this.importExternalBookLinks(this.workbookExtractor.getExternalReferences());
            this._importPhase.setPhase("workbook protection");
            this.importWorkbookProtection(this.workbookExtractor, this.book);
            this._importPhase.setPhase("sheets");
            List<XlsxExtractor.XlsxSheetExtractor> sheets = this.workbookExtractor.getSheets();
            this.importSheets(sheets);
            this._importPhase.setPhase("named range");
            this.importNamedRange();
            this._importPhase.clear();
            for (int i = 0; i < sheets.size(); ++i) {
                this._importPhase.setPhase("sheet");
                SSheet sheet = this.book.getSheet(i);
                this._importPhase.setSheetName(sheet.getSheetName());
                XlsxExtractor.XlsxSheetExtractor xSheet = sheets.get(i);
                this._importPhase.setPhase("hyperlink");
                this.importHyperlinks(xSheet);
                this._importPhase.setPhase("VML drawing");
                this.importVmlDrawing(xSheet);
                this._importPhase.setPhase("comment");
                this.importComments(xSheet);
                this._importPhase.setPhase("row");
                for (XlsxExtractor.XlsxRowExtractor xRow : xSheet.getRows()) {
                    this.importRow(xRow, sheet);
                }
                this._importPhase.setRowIndex(-1);
                this._importPhase.setColIndex(-1);
                this.importColumn(xSheet, sheet);
                this._importPhase.setColIndex(-1);
                this._importPhase.setPhase("merged cell");
                this.importMergedRegions(xSheet, sheet);
                this._importPhase.setPhase("extLst");
                XlsxExtractor.XlsxExtLstExtractor extLst = xSheet.getExtLst();
                List<XlsxExtractor.XlsxExtExtractor> extList = extLst != null ? extLst.getExt() : Collections.EMPTY_LIST;
                this._importPhase.setPhase("drawing");
                this.importDrawings(xSheet, sheet);
                this.importSparklines(xSheet, sheet, extList);
                this._importPhase.setPhase("data validation");
                this.importValidation(xSheet, sheet, extList);
                this._importPhase.setPhase("auto filter");
                this.importAutoFilter(xSheet, sheet);
                this._importPhase.setPhase("sheet protection");
                this.importSheetProtection(xSheet, sheet);
                this._importPhase.setPhase("conditional formatting");
                this.importConditionalFormatting(xSheet, sheet, extList);
                this._importPhase.setPhase("print area");
                this.importPrintArea(xSheet, sheet);
            }
        }
        catch (RuntimeException e) {
            throw new ImportException("Fail to import " + this._importPhase.toString(), e);
        }
        finally {
            this.book.getBookSeries().setAutoFormulaCacheClean(isCacheClean);
            Locales.setThreadLocal((Locale)old);
            ((AbstractBookAdv)this.book).setPostProcessing(false);
            this._importPhase.clear();
            if (_logger.isDebugEnabled()) {
                _logger.debug("complete to import {}", (Object)bookName);
            }
        }
        return this.book;
    }

    protected void importPrintArea(XlsxExtractor.XlsxSheetExtractor xSheet, SSheet sheet) {
        String refersToFormula;
        SName printTitle;
        SName printArea = this.book.getNameByName(BUILTIN_PRINT_AREA, sheet.getSheetName());
        SPrintSetup sps = sheet.getPrintSetup();
        XlsxExtractor.XlsxHeaderFootersExtractor headerFooter = xSheet.getHeaderFooter();
        if (headerFooter != null) {
            String[] parts;
            String[] parts2;
            SSheetViewInfo viewInfo = sheet.getViewInfo();
            sps.setAlignWithMargins(headerFooter.isAlignWithMargins());
            String[] oddHeaders = XlsxJsonHelper.getParts(headerFooter.getOddHeader());
            String[] oddFooters = XlsxJsonHelper.getParts(headerFooter.getOddFooter());
            SHeader header = viewInfo.getHeader();
            header.setCenterText(oddHeaders[1]);
            header.setLeftText(oddHeaders[0]);
            header.setRightText(oddHeaders[2]);
            sps.setHeader(header);
            SFooter footer = viewInfo.getFooter();
            footer.setCenterText(oddFooters[1]);
            footer.setLeftText(oddFooters[0]);
            footer.setRightText(oddFooters[2]);
            sps.setFooter(footer);
            if (headerFooter.isDifferentOddEven()) {
                String evenFooter1;
                String evenHeader1 = headerFooter.getEvenHeader();
                if (evenHeader1 != null) {
                    HeaderFooterImpl evenHeader = new HeaderFooterImpl();
                    parts2 = XlsxJsonHelper.getParts(evenHeader1);
                    evenHeader.setCenterText(parts2[1]);
                    evenHeader.setLeftText(parts2[0]);
                    evenHeader.setRightText(parts2[2]);
                    sps.setEvenHeader(evenHeader);
                }
                if ((evenFooter1 = headerFooter.getEvenFooter()) != null) {
                    HeaderFooterImpl evenFooter = new HeaderFooterImpl();
                    parts = XlsxJsonHelper.getParts(evenFooter1);
                    evenFooter.setCenterText(parts[1]);
                    evenFooter.setLeftText(parts[0]);
                    evenFooter.setRightText(parts[2]);
                    sps.setEvenFooter(evenFooter);
                }
            }
            if (headerFooter.isDifferentFirst()) {
                String firstFooter1;
                String firstHeader1 = headerFooter.getFirstHeader();
                if (firstHeader1 != null) {
                    HeaderFooterImpl firstHeader = new HeaderFooterImpl();
                    parts2 = XlsxJsonHelper.getParts(firstHeader1);
                    firstHeader.setCenterText(parts2[1]);
                    firstHeader.setLeftText(parts2[0]);
                    firstHeader.setRightText(parts2[2]);
                    sps.setFirstHeader(firstHeader);
                }
                if ((firstFooter1 = headerFooter.getFirstFooter()) != null) {
                    HeaderFooterImpl firstFooter = new HeaderFooterImpl();
                    parts = XlsxJsonHelper.getParts(firstHeader1);
                    firstFooter.setCenterText(parts[1]);
                    firstFooter.setLeftText(parts[0]);
                    firstFooter.setRightText(parts[2]);
                    sps.setFirstFooter(firstFooter);
                }
            }
            sps.setScaleWithDoc(headerFooter.isScaleWithDoc());
            sps.setDifferentOddEvenPage(headerFooter.isDifferentOddEven());
            sps.setDifferentFirstPage(headerFooter.isDifferentFirst());
        }
        XlsxExtractor.XlsxPageSetupExtractor pageSetup = xSheet.getPageSetup();
        XlsxExtractor.XlsxPageMarginsExtractor pageMargins = xSheet.getPageMargins();
        XlsxExtractor.XlsxPrintOptionsExtractor printOptions = xSheet.getPrintOptions();
        if (pageMargins != null) {
            sps.setBottomMargin(pageMargins.getBottom());
            sps.setTopMargin(pageMargins.getTop());
            sps.setLeftMargin(pageMargins.getLeft());
            sps.setRightMargin(pageMargins.getRight());
            sps.setHeaderMargin(pageMargins.getHeader());
            sps.setFooterMargin(pageMargins.getFooter());
        }
        if (printOptions != null && printOptions.isNotEmpty()) {
            sps.setHCenter(printOptions.isHorizontalCentered());
            sps.setVCenter(printOptions.isVerticalCentered());
            sps.setPrintGridlines(printOptions.isGridLines());
            sps.setPrintHeadings(printOptions.isHeadings());
        }
        if (pageSetup != null) {
            sps.setErrorPrintMode(pageSetup.getErrors());
            sps.setFitHeight(pageSetup.getFitToHeight());
            sps.setFitWidth(pageSetup.getFitToWidth());
            sps.setLandscape("landscape".equals(pageSetup.getOrientation()));
            sps.setLeftToRight("overThenDown".equals(pageSetup.getPageOrder()));
            sps.setPaperSize(pageSetup.getPaperSize());
            sps.setCommentsMode(pageSetup.getCellComments());
            sps.setScale(pageSetup.getScale());
            sps.setPageStart(pageSetup.isUseFirstPageNumber() ? pageSetup.getFirstPageNumber() : 0);
        }
        if (printArea != null) {
            sps.setPrintArea(printArea.getRefersToFormula());
        }
        if ((printTitle = this.book.getNameByName(BUILTIN_PRINT_TITLE, sheet.getSheetName())) != null && (refersToFormula = printTitle.getRefersToFormula()) != null) {
            CellRangeAddress colrng;
            CellRangeAddress rowrng = XlsxImporter.getRepeatingRowsOrColumns(refersToFormula, true);
            if (rowrng != null) {
                sps.setRepeatingRowsTitle(rowrng.getFirstRow(), rowrng.getLastRow());
            }
            if ((colrng = XlsxImporter.getRepeatingRowsOrColumns(refersToFormula, false)) != null) {
                sps.setRepeatingColumnsTitle(colrng.getFirstColumn(), colrng.getLastColumn());
            }
        }
    }

    protected static CellRangeAddress getRepeatingRowsOrColumns(String refs, boolean rows) {
        String[] parts = refs.split(",");
        int maxRowIndex = Ref.MAX_ROW - 1;
        int maxColIndex = Ref.MAX_COL - 1;
        for (String part : parts) {
            CellRangeAddress range = CellRangeAddress.valueOf((String)part);
            if (!(range.getFirstColumn() == 0 && range.getLastColumn() == maxColIndex || range.getFirstColumn() == -1 && range.getLastColumn() == -1 ? rows : (range.getFirstRow() == 0 && range.getLastRow() == maxRowIndex || range.getFirstRow() == -1 && range.getLastRow() == -1) && !rows)) continue;
            return range;
        }
        return null;
    }

    protected void importHyperlinks(XlsxExtractor.XlsxSheetExtractor xSheet) {
        List<XlsxExtractor.XlsxHyperlinkExtractor> hyperlinks = xSheet.getHyperlinks();
        if (hyperlinks.isEmpty()) {
            this.hyperlinksCache = null;
        } else {
            this.hyperlinksCache = new HashMap<String, XlsxExtractor.XlsxHyperlinkExtractor>();
            for (XlsxExtractor.XlsxHyperlinkExtractor extractor : hyperlinks) {
                this.hyperlinksCache.put(extractor.getRef(), extractor);
            }
        }
    }

    protected void importVmlDrawing(XlsxExtractor.XlsxSheetExtractor xSheet) {
        XlsxExtractor.XlsxVmlDrawingExtractor legacyDrawing = xSheet.getLegacyDrawing();
        this.vmlDrawingCache = legacyDrawing != null ? new VmlDrawing(legacyDrawing.getJsonMap(), legacyDrawing.getImageData()) : null;
    }

    protected void importComments(XlsxExtractor.XlsxSheetExtractor xSheet) {
        XlsxExtractor.XlsxCommentsExtractor comments = xSheet.getComments();
        if (comments != null) {
            List<String> authors = comments.getAuthors();
            List<XlsxExtractor.XlsxCommentExtractor> commentList = comments.getCommentList();
            if (commentList.isEmpty()) {
                this.commentsCache = null;
            } else {
                this.commentsCache = new HashMap<String, XlsxExtractor.XlsxCommentExtractor>();
                for (XlsxExtractor.XlsxCommentExtractor extractor : commentList) {
                    Number shapeId;
                    Number authorId = extractor.getAuthorId();
                    if (authorId != null && authorId.intValue() < authors.size()) {
                        extractor.setAuthorName(authors.get(authorId.intValue()));
                    }
                    if ((shapeId = extractor.getShapeId()) != null) {
                        extractor.setShape(this.vmlDrawingCache.getShape(extractor.getRef()));
                    }
                    this.commentsCache.put(extractor.getRef(), extractor);
                }
            }
        } else {
            this.commentsCache = null;
        }
    }

    protected void importDefaultChartSeriesColors() {
        if (this.themes == null) {
            return;
        }
        XlsxExtractor.XlsxClrSchemeExtractor clrScheme = this.themes.getClrScheme();
        if (clrScheme == null) {
            return;
        }
        ArrayList<SColor> list = new ArrayList<SColor>();
        list.add(new ColorImpl(clrScheme.getAccent1()));
        list.add(new ColorImpl(clrScheme.getAccent2()));
        list.add(new ColorImpl(clrScheme.getAccent3()));
        list.add(new ColorImpl(clrScheme.getAccent4()));
        list.add(new ColorImpl(clrScheme.getAccent5()));
        list.add(new ColorImpl(clrScheme.getAccent6()));
        ((AbstractBookAdv)this.book).setDefaultChartSeriesColors(list);
    }

    protected void importStyleSheet(XlsxExtractor.XlsxStyleSheetExtractor extractor) {
        this.importColors(extractor.getColors());
        this.importNumFmts(extractor.getNumFmts());
        this.importFonts(extractor.getFonts());
        this.importFills(extractor.getFills());
        this.importBorders(extractor.getBorders());
        this.importDefaultCellStyles(extractor);
        this.importCellXfs(extractor.getCellXfs());
        this.importNamedStyles(extractor);
        this.importExtraStyles(extractor);
        this.importTableStyles(extractor);
    }

    void importCellXfs(List<XlsxExtractor.XlsxXfExtractor> extractors) {
        this.cellXfsCache = new CellXfs();
        if (!extractors.isEmpty()) {
            for (XlsxExtractor.XlsxXfExtractor extractor : extractors) {
                XlsxExtractor.XlsxXfExtractor parentXf = this.cellStyleXfsCache.get(extractor.getXfId().intValue());
                this.cellXfsCache.addCellXf(new XlsxExtractor.XlsxCellXfExtractor(extractor, parentXf));
            }
        }
    }

    protected void importColors(XlsxExtractor.XlsxRGBColorsExtractor extractor) {
        if (extractor != null) {
            List<String> indexedColorsList = extractor.getIndexedColors();
            boolean ignoreBuiltin = indexedColorsList != null && !indexedColorsList.isEmpty();
            this.colorsCache = new Colors(ignoreBuiltin);
            for (String color : indexedColorsList) {
                this.colorsCache.addIndexedColor(color);
            }
        } else {
            this.colorsCache = new Colors();
        }
    }

    protected void importNumFmts(List<XlsxExtractor.XlsxNumFmtExtractor> extractors) {
        this.numFmtsCache = new NumFmts();
        if (extractors.isEmpty()) {
            this.numFmtsCache.addNumFmt("General", 0);
        } else {
            for (XlsxExtractor.XlsxNumFmtExtractor extractor : extractors) {
                this.numFmtsCache.addNumFmt(extractor.getFormatCode(), extractor.getNumFmtId().intValue());
            }
        }
    }

    protected void importFonts(List<XlsxExtractor.XlsxFontExtractor> extractors) {
        this.fontsCache = new Fonts();
        for (XlsxExtractor.XlsxFontExtractor font : extractors) {
            this.fontsCache.addFont(font, this.createZssFont(font));
        }
    }

    protected void importFills(List<XlsxExtractor.XlsxFillExtractor> extractors) {
        this.fillsCache = new Fills();
        if (!extractors.isEmpty()) {
            for (XlsxExtractor.XlsxFillExtractor extractor : extractors) {
                if (!(extractor instanceof XlsxExtractor.XlsxPatternExtractor)) continue;
                XlsxExtractor.XlsxPatternExtractor fill = (XlsxExtractor.XlsxPatternExtractor)extractor;
                String fgColor = XlsxImporter.getForegroundHTMLColor(fill.getFgColor(), this.themes, this);
                String bgColor = XlsxImporter.getBackgroundHTMLColor(fill.getBgColor(), this.themes, this);
                this.fillsCache.addFill(new Fills.PatternFill(fill.getPatternType(), fgColor, bgColor));
                this.colorsCache.addColor(fgColor);
                this.colorsCache.addColor(bgColor);
            }
        } else if (this.themes != null) {
            XlsxExtractor.XlsxClrSchemeExtractor clrScheme = this.themes.getClrScheme();
            if (clrScheme != null) {
                this.fillsCache.addFill(new Fills.PatternFill("none", clrScheme.getLt1(), clrScheme.getDk1()));
                this.fillsCache.addFill(new Fills.PatternFill("gray125", clrScheme.getLt1(), clrScheme.getDk1()));
            } else {
                this.fillsCache.addFill(new Fills.PatternFill("none", "#ffffff", "#000000"));
                this.fillsCache.addFill(new Fills.PatternFill("gray125", "#ffffff", "#000000"));
            }
        } else {
            this.fillsCache.addFill(new Fills.PatternFill("none", "#ffffff", "#000000"));
            this.fillsCache.addFill(new Fills.PatternFill("gray125", "#ffffff", "#000000"));
        }
    }

    protected void importBorders(List<XlsxExtractor.XlsxBorderExtractor> extractors) {
        this.bordersCache = new Borders();
        if (!extractors.isEmpty()) {
            for (XlsxExtractor.XlsxBorderExtractor extractor : extractors) {
                this.bordersCache.addBorder(this.createBorder(extractor));
            }
        } else {
            Borders.BorderPr defaultBorderPr = new Borders.BorderPr("none", XlsxImporter.getHTMLColorFromHex(this.colorsCache.getIndexColorByIndex(0)));
            this.bordersCache.addBorder(new Borders.Border(false, false, false, defaultBorderPr, defaultBorderPr, defaultBorderPr, defaultBorderPr, defaultBorderPr, null, null));
        }
    }

    protected Borders.Border createBorder(XlsxExtractor.XlsxBorderExtractor extractor) {
        boolean diagonalUp = extractor.isDiagonalUp();
        boolean diagonalDown = extractor.isDiagonalDown();
        boolean outline = extractor.isOutline();
        Borders.BorderPr left = this.createBorderPr(extractor.getLeft());
        Borders.BorderPr top = this.createBorderPr(extractor.getTop());
        Borders.BorderPr right = this.createBorderPr(extractor.getRight());
        Borders.BorderPr bottom = this.createBorderPr(extractor.getBottom());
        Borders.BorderPr diagonal = this.createBorderPr(extractor.getDiagonal());
        Borders.BorderPr vertical = this.createBorderPr(extractor.getVertical());
        Borders.BorderPr horizontal = this.createBorderPr(extractor.getHorizontal());
        return new Borders.Border(diagonalUp, diagonalDown, outline, left, top, right, bottom, diagonal, vertical, horizontal);
    }

    protected Borders.BorderPr createBorderPr(XlsxExtractor.XlsxBorderPrExtractor extractor) {
        if (extractor == null) {
            return null;
        }
        if (extractor.getColor() == null && extractor.getStyle() == null) {
            return new Borders.BorderPr("none", XlsxImporter.getHTMLColorFromHex(this.colorsCache.getIndexColorByIndex(0)));
        }
        String fontHTMLColor = XlsxImporter.getBorderHTMLColor(extractor.getColor(), this.themes, this);
        this.colorsCache.addColor(fontHTMLColor);
        return new Borders.BorderPr(extractor.getStyle(), fontHTMLColor);
    }

    protected void importAutoFilter(XlsxExtractor.XlsxSheetExtractor xSheet, SSheet sheet) {
        XlsxExtractor.XlsxAutoFilterExtractor xAutoFilter = xSheet.getAutoFilter();
        if (xAutoFilter != null) {
            String ref = xAutoFilter.getRef();
            CellRegion cellRegion = new CellRegion(ref);
            SAutoFilter autoFilter = sheet.createAutoFilter(cellRegion);
            this.importAutoFilterColumns(xAutoFilter, autoFilter);
        }
    }

    protected void importSheetProtection(XlsxExtractor.XlsxSheetExtractor xSheet, SSheet sheet) {
        XlsxExtractor.XlsxSheetProtectionExtractor sheetProtection = xSheet.getSheetProtection();
        if (sheetProtection != null) {
            sheet.setPassword(sheetProtection.isSheet() ? "" : null);
            this.importPassword(sheetProtection, sheet);
            SSheetProtection ssp = sheet.getSheetProtection();
            ssp.setAutoFilter(sheetProtection.isAutoFilter());
            ssp.setDeleteColumns(sheetProtection.isDeleteColumns());
            ssp.setDeleteRows(sheetProtection.isDeleteRows());
            ssp.setFormatCells(sheetProtection.isFormatCells());
            ssp.setFormatColumns(sheetProtection.isFormatColumns());
            ssp.setFormatRows(sheetProtection.isFormatRows());
            ssp.setInsertColumns(sheetProtection.isInsertColumns());
            ssp.setInsertHyperlinks(sheetProtection.isInsertHyperlinks());
            ssp.setInsertRows(sheetProtection.isInsertRows());
            ssp.setPivotTables(sheetProtection.isPivotTables());
            ssp.setSort(sheetProtection.isSort());
            ssp.setObjects(sheetProtection.isObjects());
            ssp.setScenarios(sheetProtection.isScenarios());
            ssp.setSelectLockedCells(sheetProtection.isSelectLockedCells());
            ssp.setSelectUnlockedCells(sheetProtection.isSelectUnlockedCells());
        }
    }

    protected void importValidation(XlsxExtractor.XlsxSheetExtractor xSheet, SSheet sheet, List<XlsxExtractor.XlsxExtExtractor> extList) {
        XlsxExtractor.XlsxDataValidationsExtractor dataValidations = xSheet.getDataValidations();
        Consumer<XlsxExtractor.XlsxDataValidationExtractor> func = extractor -> {
            SDataValidation dataValidation = sheet.addDataValidation(null, null);
            dataValidation.setOperatorType(extractor.getOperator());
            dataValidation.setValidationType(extractor.getType());
            ((AbstractDataValidationAdv)dataValidation).setEscapedFormulas(extractor.getFormula1(), extractor.getFormula2());
            dataValidation.setIgnoreBlank(extractor.isAllowBlank());
            dataValidation.setErrorTitle(extractor.getErrorTitle());
            dataValidation.setErrorMessage(extractor.getError());
            dataValidation.setAlertStyle(extractor.getErrorStyle());
            dataValidation.setInputTitle(extractor.getPromptTitle());
            dataValidation.setInputMessage(extractor.getPrompt());
            if (dataValidation.getValidationType() == SDataValidation.ValidationType.LIST) {
                dataValidation.setInCellDropdown(extractor.isShowDropDown());
            }
            dataValidation.setShowError(extractor.isShowErrorMessage());
            dataValidation.setShowInput(extractor.isShowInputMessage());
            LinkedHashSet<CellRegion> regions = new LinkedHashSet<CellRegion>();
            for (String ref : extractor.getSqref().split(" ")) {
                regions.add(new CellRegion(ref));
            }
            dataValidation.setRegions(regions);
        };
        if (dataValidations != null) {
            for (XlsxExtractor.XlsxDataValidationExtractor extractor2 : dataValidations.getValidations()) {
                func.accept(extractor2);
            }
        }
        if (!extList.isEmpty()) {
            extList.forEach(xlsxExtExtractor -> xlsxExtExtractor.getDataValidations().forEach(func));
        }
    }

    protected void importMergedRegions(XlsxExtractor.XlsxSheetExtractor xSheet, SSheet sheet) {
        SheetImpl sheetImpl = (SheetImpl)sheet;
        List<String> mergeCells = xSheet.getMergeCells();
        int i = mergeCells.size();
        while (--i >= 0) {
            Ref ref1 = Converter.a1ToRef(mergeCells.get(i));
            CellRegion r = new CellRegion(ref1.getTop(), ref1.getLeft(), ref1.getBottom(), ref1.getRight());
            CellRegion overlapped = sheetImpl.checkMergedRegion(r);
            if (overlapped != null) {
                _logger.warn("Drop the region " + String.valueOf(r) + " which is overlapped with existing merged area " + String.valueOf(overlapped) + ".");
                continue;
            }
            sheetImpl.addDirectlyMergedRegion(r);
        }
    }

    protected void importSparklines(XlsxExtractor.XlsxSheetExtractor xSheet, SSheet sheet, List<XlsxExtractor.XlsxExtExtractor> extList) {
        if (extList.isEmpty()) {
            return;
        }
        for (XlsxExtractor.XlsxExtExtractor ext : extList) {
            XlsxExtractor.XlsxSparklineGroupsExtractor sparklineGroups = ext.getSparklineGroups();
            if (sparklineGroups == null) {
                return;
            }
            List<XlsxExtractor.XlsxSparklineGroupExtractor> sparklineGroupList = sparklineGroups.getSparklineGroups();
            if (sparklineGroupList.isEmpty()) {
                return;
            }
            for (XlsxExtractor.XlsxSparklineGroupExtractor sparklineGroup : sparklineGroupList) {
                Boolean isMarkersVisible = sparklineGroup.isMarkersVisible();
                Boolean isNegativeVisible = sparklineGroup.isNegativeVisible();
                Boolean isFirstVisible = sparklineGroup.isFirstVisible();
                Boolean isLastVisible = sparklineGroup.isLastVisible();
                Boolean isHighVisible = sparklineGroup.isHighVisible();
                Boolean isLowVisible = sparklineGroup.isLowVisible();
                SColor seriesColor = this.toColor(sparklineGroup.getColorSeries());
                SColor markerColor = this.toColor(sparklineGroup.getColorMarkers());
                SColor negativeColor = this.toColor(sparklineGroup.getColorNegative());
                SColor firstColor = this.toColor(sparklineGroup.getColorFirst());
                SColor lastColor = this.toColor(sparklineGroup.getColorLast());
                SColor highColor = this.toColor(sparklineGroup.getColorHigh());
                SColor lowColor = this.toColor(sparklineGroup.getColorLow());
                List<XlsxExtractor.XlsxSparklineExtractor> sparklineList = sparklineGroup.getSparklines().getSparklines();
                for (XlsxExtractor.XlsxSparklineExtractor sparkline : sparklineList) {
                    String anchorRef = sparkline.getSqref();
                    ViewAnchor viewAnchor = this.toSparklineViewAnchor(anchorRef, sheet);
                    String type = sparklineGroup.getType();
                    boolean winlose = "stacked".equalsIgnoreCase(type);
                    SChart.ChartType chartType = SChart.ChartType.LINE;
                    if (SChart.ChartType.AREA.name().equalsIgnoreCase(type)) {
                        chartType = SChart.ChartType.AREA;
                    } else if (SChart.ChartType.COLUMN.name().equalsIgnoreCase(type) || winlose) {
                        chartType = SChart.ChartType.COLUMN;
                    }
                    SChart chart = sheet.addChart(chartType, viewAnchor);
                    AbstractChartAdv chartAdv = (AbstractChartAdv)chart;
                    SGeneralChartData chartData = (SGeneralChartData)chart.getData();
                    chart.setSparkline(true);
                    if (isMarkersVisible != null) {
                        chartAdv.setSparklineMarkerVisible(isMarkersVisible);
                    }
                    if (isNegativeVisible != null) {
                        chartAdv.setSparklineNegativePointVisible(isNegativeVisible);
                    }
                    if (isFirstVisible != null) {
                        chartAdv.setSparklineFirstPointVisible(isFirstVisible);
                    }
                    if (isLastVisible != null) {
                        chartAdv.setSparklineLastPointVisible(isLastVisible);
                    }
                    if (isHighVisible != null) {
                        chartAdv.setSparklineHighPointVisible(isHighVisible);
                    }
                    if (isLowVisible != null) {
                        chartAdv.setSparklineLowPointVisible(isLowVisible);
                    }
                    if (seriesColor != null) {
                        chartAdv.setSparklineSeriesColor(seriesColor);
                    }
                    if (markerColor != null) {
                        chartAdv.setSparklineMarkerColor(markerColor);
                    }
                    if (negativeColor != null) {
                        chartAdv.setSparklineNegativePointColor(negativeColor);
                    }
                    if (firstColor != null) {
                        chartAdv.setSparklineFirstPointColor(firstColor);
                    }
                    if (lastColor != null) {
                        chartAdv.setSparklineLastPointColor(lastColor);
                    }
                    if (highColor != null) {
                        chartAdv.setSparklineHighPointColor(highColor);
                    }
                    if (lowColor != null) {
                        chartAdv.setSparklineLowPointColor(lowColor);
                    }
                    if (winlose) {
                        chart.setWinloseSpark(true);
                    }
                    SSeries series = chartData.addSeries();
                    series.setFormula(null, sparkline.getF());
                }
            }
        }
    }

    protected SColor toColor(XlsxExtractor.XlsxColorExtractor extractor) {
        String hex = XlsxImporter.getHTMLColor(extractor, this.themes, this, null);
        if (hex == null) {
            return null;
        }
        return new ColorImpl(hex);
    }

    protected ViewAnchor toSparklineViewAnchor(String anchorRef, SSheet sheet) {
        int rowIndex = sheet.getCell(anchorRef).getRowIndex();
        int colIndex = sheet.getCell(anchorRef).getColumnIndex();
        CellRegion cellRegion = sheet.getMergedRegion(rowIndex, colIndex);
        int height = 0;
        int width = 0;
        if (cellRegion != null) {
            int i;
            for (i = 0; i < cellRegion.getColumnCount(); ++i) {
                width += sheet.getColumn(colIndex + i).getWidth();
            }
            for (i = 0; i < cellRegion.getRowCount(); ++i) {
                height += sheet.getRow(rowIndex + i).getHeight();
            }
            width -= 4;
            height -= 4;
        } else {
            SRow row = sheet.getRow(rowIndex);
            height = row.isHidden() ? 0 : row.getHeight() - 4;
            SColumn column = sheet.getColumn(colIndex);
            width = column.isHidden() ? 0 : column.getWidth() - 4;
        }
        ViewAnchor viewAnchor = new ViewAnchor(rowIndex, colIndex, width, height);
        viewAnchor.setXOffset(2);
        viewAnchor.setYOffset(2);
        return viewAnchor;
    }

    protected void importDrawings(XlsxExtractor.XlsxSheetExtractor xSheet, SSheet sheet) {
        XlsxExtractor.XlsxDrawingsExtractor drawings = xSheet.getDrawings();
        if (drawings != null) {
            for (ShapeJson shapeJson : drawings.getDrawingsJson()) {
                if (shapeJson instanceof ChartSpaceJson) {
                    this._importPhase.setPhase("chart");
                    this.importChart((ChartSpaceJson)shapeJson, xSheet, sheet);
                    continue;
                }
                if (!(shapeJson instanceof PictureJson)) continue;
                this._importPhase.setPhase("picture");
                this.importPicture((PictureJson)shapeJson, xSheet, sheet);
            }
        }
    }

    protected void importPicture(PictureJson pictureJson, XlsxExtractor.XlsxSheetExtractor xSheet, SSheet sheet) {
        Integer picDataIx = this.importedPictureJson.get(pictureJson);
        ViewAnchor viewAnchor = this.toViewAnchor(pictureJson, sheet);
        if (picDataIx != null) {
            sheet.addPicture(picDataIx, viewAnchor);
        } else {
            SPicture.Format format = SPicture.Format.valueOfFileExtension(pictureJson.fileType);
            if (format != null) {
                SPicture pic = sheet.addPicture(format, pictureJson.getPictureData(), viewAnchor);
                this.importedPictureJson.put(pictureJson, pic.getPictureData().getIndex());
            } else if (pictureJson.isExternal()) {
                _logger.warn("ignore an external image at ['" + sheet.getSheetName() + "'!" + new CellRegion(viewAnchor.getRowIndex(), viewAnchor.getColumnIndex()).getReferenceString() + "]");
            }
        }
    }

    protected ViewAnchor toViewAnchor(ShapeJson shapeJson, SSheet sheet) {
        int width = this.getAnchorWidthInPx(shapeJson, sheet);
        int height = this.getAnchorHeightInPx(shapeJson, sheet);
        ViewAnchor viewAnchor = new ViewAnchor(shapeJson.getFromRow(), shapeJson.getFromCol(), width, height);
        viewAnchor.setXOffset(this.getXoffsetInPixel(shapeJson));
        viewAnchor.setYOffset(this.getYoffsetInPixel(shapeJson));
        viewAnchor.setAnchorType(shapeJson.getAnchorType());
        return viewAnchor;
    }

    protected int getAnchorWidthInPx(ShapeJson shapeJson, SSheet sheet) {
        int firstColumn = shapeJson.getFromCol();
        SColumn firstSColumn = sheet.getColumn(firstColumn);
        boolean firstSColumnHidden = firstSColumn.isHidden();
        int firstColumnWidth = firstSColumnHidden ? 0 : firstSColumn.getWidth();
        int offsetInFirstColumn = firstSColumnHidden ? 0 : UnitUtil.emuToPx(shapeJson.getFromColOff());
        int anchorWidthInFirstColumn = firstColumnWidth - offsetInFirstColumn;
        int lastColumn = shapeJson.getToCol();
        int anchorWidthInLastColumn = sheet.getColumn(lastColumn).isHidden() ? 0 : UnitUtil.emuToPx(shapeJson.getToColOff());
        int width = firstColumn == lastColumn ? anchorWidthInLastColumn - offsetInFirstColumn : anchorWidthInFirstColumn + anchorWidthInLastColumn;
        width = Math.abs(width);
        for (int j = firstColumn + 1; j < lastColumn; ++j) {
            SColumn scolumn = sheet.getColumn(j);
            if (scolumn.isHidden()) continue;
            width += scolumn.getWidth();
        }
        return width;
    }

    protected int getAnchorHeightInPx(ShapeJson shapeJson, SSheet sheet) {
        int firstRow = shapeJson.getFromRow();
        SRow firstSRow = sheet.getRow(firstRow);
        boolean firstSRowHidden = firstSRow.isHidden();
        int firstRowHeight = firstSRowHidden ? 0 : firstSRow.getHeight();
        int offsetInFirstRow = firstSRowHidden ? 0 : UnitUtil.emuToPx(shapeJson.getFromRowOff());
        int anchorHeightInFirstRow = firstRowHeight - offsetInFirstRow;
        int lastRow = shapeJson.getToRow();
        int anchorHeightInLastRow = sheet.getRow(lastRow).isHidden() ? 0 : UnitUtil.emuToPx(shapeJson.getToRowOff());
        int height = lastRow == firstRow ? anchorHeightInLastRow - offsetInFirstRow : anchorHeightInFirstRow + anchorHeightInLastRow;
        height = Math.abs(height);
        for (int row = firstRow + 1; row < lastRow; ++row) {
            SRow srow = sheet.getRow(row);
            if (srow.isHidden()) continue;
            height += sheet.getRow(row).getHeight();
        }
        return height;
    }

    protected int getXoffsetInPixel(ShapeJson shapeJson) {
        return UnitUtil.emuToPx(shapeJson.getFromColOff());
    }

    protected int getYoffsetInPixel(ShapeJson shapeJson) {
        return UnitUtil.emuToPx(shapeJson.getFromRowOff());
    }

    protected void importChart(ChartSpaceJson chartSpaceJson, XlsxExtractor.XlsxSheetExtractor xSheet, SSheet sheet) {
        LegendStyle legendStyle;
        ViewAnchor viewAnchor = this.toViewAnchor(chartSpaceJson, sheet);
        AbstractChartAdv chart = null;
        for (ChartTypeJson json : chartSpaceJson.getChartTypes()) {
            List<? extends SeriesJson> seriesList;
            SChartData data;
            SChart.ChartType chartType = this.toChartType(json.getChartType());
            if (chartType == null) continue;
            if (chart == null) {
                chart = (AbstractChartAdv)sheet.addChart(chartSpaceJson.getName(), chartType, viewAnchor);
                this.importAxis(chartSpaceJson, chart);
                data = chart.getData();
            } else {
                data = chart.createChartData(chartType);
                chart.addChartData(data);
            }
            if (!(data instanceof SGeneralChartData)) continue;
            GeneralChartDataImpl generalChartData = (GeneralChartDataImpl)data;
            if (data instanceof AreaChartDataImpl) {
                AreaChartDataImpl areaChartData = (AreaChartDataImpl)data;
                areaChartData.setGrouping(this.toChartGrouping(json.getGrouping()));
            } else if (data instanceof BarChartDataImpl) {
                SChart.ChartGrouping chartGrouping = this.toChartGrouping(json.getGrouping());
                BarChartDataImpl barChartData = (BarChartDataImpl)data;
                barChartData.setBarOverlap(this.toBarOverlap(json, chartGrouping));
                barChartData.setGrouping(chartGrouping);
            } else if (data instanceof LineChartDataImpl) {
                LineChartDataImpl lineChartData = (LineChartDataImpl)data;
                lineChartData.setSmooth(json.isSmooth());
                lineChartData.setMarker(json.hasMarker());
                lineChartData.setGrouping(this.toChartGrouping(json.getGrouping()));
            }
            List<Long> axids = json.getAxIds();
            if (!axids.isEmpty()) {
                long id = axids.get(0);
                chart.getCategoryAxises().stream().filter(v -> v.getId() == id).findFirst().ifPresent(generalChartData::setCategoryAxis);
                chart.getDateAxises().stream().filter(v -> v.getId() == id).findFirst().ifPresent(generalChartData::setDateAxis);
                ArrayList<SChartAxis> arrayList = new ArrayList<SChartAxis>();
                for (long valId : axids) {
                    chart.getValueAxises().stream().filter(v -> v.getId() == valId).findAny().ifPresent(arrayList::add);
                }
                generalChartData.setValueAxes(arrayList);
            }
            if ((seriesList = json.getSeriesList()) == null) continue;
            for (SeriesJson seriesJson : seriesList) {
                this.importSeries(seriesJson, generalChartData);
            }
        }
        if (chart == null) {
            return;
        }
        chart.setSeriesColors(((AbstractBookAdv)this.book).getDefaultChartSeriesColors());
        if (chartSpaceJson.hasAutoTitleDeleted()) {
            chart.setAutoTitleDeleted(chartSpaceJson.isAutoTitleDeleted());
        }
        if (chartSpaceJson.hasTitle()) {
            chart.setShowTitle(true);
            chart.setTitle(chartSpaceJson.getTitle());
        } else {
            chart.setShowTitle(false);
        }
        chart.setThreeD(chartSpaceJson.isSetView3D());
        if (chart.isThreeD()) {
            View3DJson view3DJson = chartSpaceJson.getView3D();
            chart.setRotX(view3DJson.getRotX());
            chart.setRotY(view3DJson.getRotY());
            chart.setPerspective(view3DJson.getPerspective());
            chart.setHPercent(view3DJson.getHPercent());
            chart.setDepthPercent(view3DJson.getDepthPercent());
            chart.setRightAngleAxes(view3DJson.isRightAngleAxes());
        }
        if ((legendStyle = chartSpaceJson.getLegendStyle()) != null) {
            chart.setLegendPosition(this.toChartLegendPosition(legendStyle.getLegendPosition()));
        }
        chart.setEmptyAsGaps("gap".equals(chartSpaceJson.getDispBlanksAs()));
        chart.setShowDataLabelsOverMax(chartSpaceJson.isShowDLblsOverMax());
        chart.setPlotOnlyVisibleCells(chartSpaceJson.isPlotOnlyVisibleCells());
    }

    public SChart.ChartGrouping toChartGrouping(String grouping) {
        if (grouping == null) {
            return SChart.ChartGrouping.STANDARD;
        }
        switch (grouping) {
            case "stacked": {
                return SChart.ChartGrouping.STACKED;
            }
            case "percentStacked": {
                return SChart.ChartGrouping.PERCENT_STACKED;
            }
            case "clustered": {
                return SChart.ChartGrouping.CLUSTERED;
            }
        }
        return SChart.ChartGrouping.STANDARD;
    }

    protected int toBarOverlap(ChartTypeJson json, SChart.ChartGrouping chartGrouping) {
        Integer barOverlap = json.getBarOverlap();
        if (barOverlap != null) {
            return barOverlap;
        }
        switch (chartGrouping) {
            case STACKED: 
            case PERCENT_STACKED: {
                return 100;
            }
        }
        return 0;
    }

    protected SChart.ChartLegendPosition toChartLegendPosition(String legendPosition) {
        if (legendPosition == null) {
            return null;
        }
        switch (legendPosition) {
            case "l": {
                return SChart.ChartLegendPosition.LEFT;
            }
            case "t": {
                return SChart.ChartLegendPosition.TOP;
            }
            case "tr": {
                return SChart.ChartLegendPosition.TOP_RIGHT;
            }
            case "b": {
                return SChart.ChartLegendPosition.BOTTOM;
            }
            case "r": {
                return SChart.ChartLegendPosition.RIGHT;
            }
        }
        return null;
    }

    protected AbstractChartAxisAdv.Position toChartAxisPosition(String legendPosition) {
        if (legendPosition == null) {
            return null;
        }
        switch (legendPosition) {
            case "l": {
                return AbstractChartAxisAdv.Position.LEFT;
            }
            case "t": {
                return AbstractChartAxisAdv.Position.TOP;
            }
            case "r": {
                return AbstractChartAxisAdv.Position.RIGHT;
            }
            case "b": {
                return AbstractChartAxisAdv.Position.BOTTOM;
            }
        }
        return null;
    }

    protected AbstractChartAxisAdv.Orientation toChartAxisOrientation(String orientation) {
        if (orientation == null) {
            return null;
        }
        switch (orientation) {
            case "maxMin": {
                return AbstractChartAxisAdv.Orientation.MAX_MIN;
            }
            case "minMax": {
                return AbstractChartAxisAdv.Orientation.MIN_MAX;
            }
        }
        return null;
    }

    protected AbstractChartAxisAdv.TickLabelPosition toChartAxisTickLabelPosition(String tickLabelPosition) {
        if (tickLabelPosition == null) {
            return null;
        }
        switch (tickLabelPosition) {
            case "low": {
                return AbstractChartAxisAdv.TickLabelPosition.LOW;
            }
            case "none": {
                return AbstractChartAxisAdv.TickLabelPosition.NONE;
            }
            case "high": {
                return AbstractChartAxisAdv.TickLabelPosition.HIGH;
            }
            case "nextTo": {
                return AbstractChartAxisAdv.TickLabelPosition.NEXT_TO;
            }
        }
        return null;
    }

    protected AbstractChartAxisAdv.Crosses toChartAxisCrosses(String crosses) {
        if (crosses == null) {
            return null;
        }
        switch (crosses) {
            case "max": {
                return AbstractChartAxisAdv.Crosses.MAX;
            }
            case "min": {
                return AbstractChartAxisAdv.Crosses.MIN;
            }
            case "autoZero": {
                return AbstractChartAxisAdv.Crosses.AUTO_ZERO;
            }
        }
        return null;
    }

    protected CategoryAxisImpl.LabelAlign toChartAxisLabelAlign(String labelAlign) {
        if (labelAlign == null) {
            return null;
        }
        switch (labelAlign) {
            case "l": {
                return CategoryAxisImpl.LabelAlign.LEFT;
            }
            case "r": {
                return CategoryAxisImpl.LabelAlign.RIGHT;
            }
            case "ctr": {
                return CategoryAxisImpl.LabelAlign.CENTER;
            }
        }
        return null;
    }

    protected DateAxisImpl.TimeUnit toChartAxisTimeUnit(String timeUnit) {
        if (timeUnit == null) {
            return null;
        }
        switch (timeUnit) {
            case "days": {
                return DateAxisImpl.TimeUnit.DAYS;
            }
            case "months": {
                return DateAxisImpl.TimeUnit.MONTHS;
            }
            case "years": {
                return DateAxisImpl.TimeUnit.YEARS;
            }
        }
        return null;
    }

    protected ValueAxisImpl.CrossBetween toChartAxisCrossBetween(String crossBetween) {
        if (crossBetween == null) {
            return null;
        }
        switch (crossBetween) {
            case "between": {
                return ValueAxisImpl.CrossBetween.BETWEEN;
            }
            case "midCat": {
                return ValueAxisImpl.CrossBetween.MIDPOINT_CATEGORY;
            }
        }
        return null;
    }

    protected void importCategory(CategorySeriesJson categorySeriesJson, SGeneralChartData chartData) {
        chartData.setCategoriesFormula(categorySeriesJson.getCategoryFormula());
    }

    protected void importSeries(SeriesJson seriesJson, SGeneralChartData chartData) {
        switch (seriesJson.getChartType()) {
            case AREA: 
            case AREA_3D: 
            case BAR: 
            case BAR_3D: 
            case COLUMN: 
            case COLUMN_3D: 
            case DOUGHNUT: 
            case PIE: 
            case PIE_3D: {
                this.importCategorySeries((CategorySeriesJson)seriesJson, chartData, false, false);
                break;
            }
            case LINE: {
                this.importCategorySeries((CategorySeriesJson)seriesJson, chartData, true, true);
                break;
            }
            case LINE_3D: {
                this.importCategorySeries((CategorySeriesJson)seriesJson, chartData, true, false);
                break;
            }
            case BUBBLE: {
                this.importXyzSeries((XYZSeriesJson)seriesJson, chartData);
                break;
            }
            case SCATTER: {
                this.importXySeries((XYSeriesJson)seriesJson, chartData);
                break;
            }
        }
    }

    protected AbstractSeriesAdv createSeries(SeriesJson json, SGeneralChartData chartData) {
        AbstractSeriesAdv series = (AbstractSeriesAdv)chartData.addSeries();
        series.setOrder(json.getOrder());
        return series;
    }

    protected void importCategorySeries(CategorySeriesJson categorySeriesJson, SGeneralChartData chartData, boolean isLine, boolean checkSmooth) {
        AbstractSeriesAdv series = this.createSeries(categorySeriesJson, chartData);
        series.setFormula(this.getTitleFormula(categorySeriesJson), categorySeriesJson.getValueFormula());
        DataPointJson dataPointJson = categorySeriesJson.getDataPoint();
        XlsxExtractor.XlsxSchemeClrExtractor colorExtractor = isLine ? dataPointJson.getLineColor() : dataPointJson.getFillColor();
        series.setDefaultColor(XlsxImporter.getSchemeHTMLColor(colorExtractor, this.themes));
        if (checkSmooth) {
            series.setSmooth(categorySeriesJson.isSmooth());
        }
        series.setDataLabelsVisible(categorySeriesJson.isDataLabelsVisible());
        Map<Integer, XlsxExtractor.XlsxSchemeClrExtractor> map = isLine ? dataPointJson.getDataPointLineColors() : dataPointJson.getDataPointFillColors();
        map.forEach((key, val) -> {
            SColor color = XlsxImporter.getSchemeHTMLColor(val, this.themes);
            if (color != null) {
                series.addDataPointColors((int)key, color);
            }
        });
        if (chartData.getCategoriesFormula() == null) {
            this.importCategory(categorySeriesJson, chartData);
        }
    }

    protected void importXySeries(XYSeriesJson xySeriesJson, SGeneralChartData chartData) {
        AbstractSeriesAdv series = this.createSeries(xySeriesJson, chartData);
        DataPointJson dataPointJson = xySeriesJson.getDataPoint();
        XlsxExtractor.XlsxSchemeClrExtractor colorExtractor = dataPointJson.getMarkerColor();
        series.setDefaultColor(XlsxImporter.getSchemeHTMLColor(colorExtractor, this.themes));
        Map<Integer, XlsxExtractor.XlsxSchemeClrExtractor> map = dataPointJson.getDataPointMarkerColors();
        map.forEach((key, val) -> {
            SColor color = XlsxImporter.getSchemeHTMLColor(val, this.themes);
            if (color != null) {
                series.addDataPointColors((int)key, color);
            }
        });
        series.setXYFormula(this.getTitleFormula(xySeriesJson), xySeriesJson.getXFormula(), xySeriesJson.getYFormula());
        series.setDataLabelsVisible(xySeriesJson.isDataLabelsVisible());
    }

    protected void importXyzSeries(XYZSeriesJson xyzSeriesJson, SGeneralChartData chartData) {
        AbstractSeriesAdv series = this.createSeries(xyzSeriesJson, chartData);
        String nameExpression = this.getTitleFormula(xyzSeriesJson);
        String xValueExpression = xyzSeriesJson.getXFormula();
        String yValueExpression = xyzSeriesJson.getYFormula();
        String zValueExpression = xyzSeriesJson.getZFormula();
        DataPointJson dataPointJson = xyzSeriesJson.getDataPoint();
        XlsxExtractor.XlsxSchemeClrExtractor colorExtractor = dataPointJson.getFillColor();
        series.setDefaultColor(XlsxImporter.getSchemeHTMLColor(colorExtractor, this.themes));
        Map<Integer, XlsxExtractor.XlsxSchemeClrExtractor> map = dataPointJson.getDataPointFillColors();
        map.forEach((key, val) -> series.addDataPointColors((int)key, XlsxImporter.getSchemeHTMLColor(val, this.themes)));
        series.setXYZFormula(nameExpression, xValueExpression, yValueExpression, zValueExpression);
    }

    protected void importAxis(ChartSpaceJson chartSpaceJson, SChart chart) {
        ChartAxisImpl saxis;
        List<CategoryAxisJson> categoryAxises = chartSpaceJson.getCategoryAxises();
        List<DateAxisJson> dateAxisJsons = chartSpaceJson.getDateAxises();
        List<ValueAxisJson> valueAxises = chartSpaceJson.getValueAxises();
        if (categoryAxises != null) {
            for (CategoryAxisJson categoryAxis : categoryAxises) {
                saxis = new CategoryAxisImpl(categoryAxis.getId(), this.toChartAxisPosition(categoryAxis.getPosition()), categoryAxis.getMinimum(), categoryAxis.getMaximum(), categoryAxis.getFormatCode(), this.toChartAxisOrientation(categoryAxis.getOrientation()), this.toChartAxisTickLabelPosition(categoryAxis.getTickLabelPosition()), categoryAxis.getCrossAx(), this.toChartAxisCrosses(categoryAxis.getCrosses()), this.toChartAxisLabelAlign(categoryAxis.getLabelAlign()), categoryAxis.getLabelOffset(), categoryAxis.hasMajorGridlines(), !categoryAxis.isDelete());
                chart.addCategoryAxis(saxis);
            }
        }
        if (dateAxisJsons != null) {
            for (DateAxisJson dateAxis : dateAxisJsons) {
                saxis = new DateAxisImpl(dateAxis.getId(), this.toChartAxisPosition(dateAxis.getPosition()), dateAxis.getMinimum(), dateAxis.getMaximum(), dateAxis.getFormatCode(), this.toChartAxisOrientation(dateAxis.getOrientation()), this.toChartAxisTickLabelPosition(dateAxis.getTickLabelPosition()), dateAxis.getCrossAx(), this.toChartAxisCrosses(dateAxis.getCrosses()), dateAxis.hasMajorGridlines(), !dateAxis.isDelete(), dateAxis.getAuto(), dateAxis.getLabelOffset(), this.toChartAxisTimeUnit(dateAxis.getBaseTimeUnit()), dateAxis.getMajorUnit(), this.toChartAxisTimeUnit(dateAxis.getMajorTimeUnit()), dateAxis.getMinorUnit(), this.toChartAxisTimeUnit(dateAxis.getMinorTimeUnit()));
                chart.addDateAxis(saxis);
            }
        }
        if (valueAxises != null) {
            for (ValueAxisJson valueAxis : valueAxises) {
                saxis = new ValueAxisImpl(valueAxis.getId(), this.toChartAxisPosition(valueAxis.getPosition()), valueAxis.getMinimum(), valueAxis.getMaximum(), valueAxis.getFormatCode(), this.toChartAxisOrientation(valueAxis.getOrientation()), this.toChartAxisTickLabelPosition(valueAxis.getTickLabelPosition()), valueAxis.getCrossAx(), this.toChartAxisCrosses(valueAxis.getCrosses()), this.toChartAxisCrossBetween(valueAxis.getCrossBetween()), valueAxis.hasMajorGridlines(), !valueAxis.isDelete());
                chart.addValueAxis(saxis);
            }
        }
    }

    protected String getTitleFormula(SeriesJson seriesJson) {
        if (seriesJson.hasTitle()) {
            if (seriesJson.isReference()) {
                return seriesJson.getTitleFormula();
            }
            return "\"" + seriesJson.getTitleText() + "\"";
        }
        return "\"\"";
    }

    protected SChart.ChartType toChartType(ChartType chartType) {
        switch (chartType) {
            case AREA: 
            case AREA_3D: {
                return SChart.ChartType.AREA;
            }
            case BAR: 
            case BAR_3D: {
                return SChart.ChartType.BAR;
            }
            case COLUMN: 
            case COLUMN_3D: {
                return SChart.ChartType.COLUMN;
            }
            case DOUGHNUT: {
                return SChart.ChartType.DOUGHNUT;
            }
            case LINE: 
            case LINE_3D: {
                return SChart.ChartType.LINE;
            }
            case PIE: 
            case PIE_3D: {
                return SChart.ChartType.PIE;
            }
            case BUBBLE: {
                return SChart.ChartType.BUBBLE;
            }
            case SCATTER: {
                return SChart.ChartType.SCATTER;
            }
        }
        return null;
    }

    protected void importColumn(XlsxExtractor.XlsxSheetExtractor xSheet, SSheet sheet) {
        List<XlsxExtractor.XlsxColExtractor> cols = xSheet.getCols();
        if (cols.isEmpty()) {
            return;
        }
        int charWidth = ((AbstractBookAdv)this.book).getCharWidth();
        double defaultColWidth = this.getXlsxDefaultColumnWidth(xSheet, charWidth);
        int defaultWidth = UnitUtil.xssfDefaultColumnWidthToPx(defaultColWidth, charWidth);
        this._importPhase.setPhase("column");
        Collections.sort(cols, Comparator.comparingInt(XlsxExtractor.XlsxColExtractor::getMin));
        for (XlsxExtractor.XlsxColExtractor col : cols) {
            Number outlineLevel;
            Boolean collapsed;
            int width;
            int min = col.getMin();
            int max = col.getMax();
            int columnIndex = min - 1;
            this._importPhase.setColIndex(columnIndex);
            SColumnArray columnArray = sheet.setupColumnArray(columnIndex, max - 1);
            boolean hidden = col.isHidden();
            columnArray.setHidden(hidden);
            Number colWdh = col.getWidth();
            colWdh = colWdh == null ? Double.valueOf(defaultColWidth * 256.0) : Double.valueOf(colWdh.doubleValue() * 256.0);
            int n = width = colWdh.doubleValue() == defaultColWidth * 256.0 ? UnitUtil.xssfDefaultColumnWidthToPx(colWdh.doubleValue() / 256.0, charWidth) : UnitUtil.fileChar256ToPx(colWdh.intValue(), charWidth);
            if (width > 0 && width != defaultWidth) {
                columnArray.setWidth(width);
            }
            columnArray.setCustomWidth(col.isCustomWidth() || width != defaultWidth);
            int style = col.getStyle();
            if (style >= 0) {
                columnArray.setCellStyle(this.importCellXf(this.cellXfsCache.getCellXfAt(style), false));
            }
            if (col.isBestFit()) {
                columnArray.setBestFit(true);
            }
            if ((collapsed = Boolean.valueOf(col.isCollapsed())) != null) {
                columnArray.setCollapsed(collapsed);
            }
            if ((outlineLevel = col.getOutlineLevel()) == null) continue;
            columnArray.setOutlineLevel(outlineLevel.intValue());
        }
    }

    protected double getXlsxDefaultColumnWidth(XlsxExtractor.XlsxSheetExtractor extractor, int charWidth) {
        XlsxExtractor.XlsxSheetFormatPrExtractor sheetFormatPr = extractor.getSheetFormatPr();
        double XSSF_DEFAULT_COL_WIDTH = 9.142857;
        if (sheetFormatPr == null) {
            return 9.142857;
        }
        Number defaultColWidth = sheetFormatPr.getDefaultColWidth();
        if (defaultColWidth != null) {
            return defaultColWidth.doubleValue();
        }
        return sheetFormatPr.isSetBaseColWidth() ? this.geDefaultColumnWidthPerBaseColWidth(sheetFormatPr.getBaseColWidth(), charWidth) : 9.142857;
    }

    public double geDefaultColumnWidthPerBaseColWidth(int baseWidth, int charWidth) {
        int defaultPx = UnitUtil.defaultColumnWidthToPx(baseWidth, charWidth);
        return UnitUtil.fileChar256ToPx(defaultPx, charWidth);
    }

    protected SRow importRow(XlsxExtractor.XlsxRowExtractor xRow, SSheet sheet) {
        int sIndex;
        Boolean collapsed;
        Number outlineLevel;
        Boolean isHidden;
        Boolean isCustomHeight;
        int rowIndex = xRow.getIndex();
        this._importPhase.setRowIndex(rowIndex);
        SRow row = sheet.getRow(rowIndex);
        float rh = xRow.getRowHeight();
        if (rh != -1.0f) {
            row.setHeight(UnitUtil.twipToPx((short)(rh * 20.0f)));
        }
        if ((isCustomHeight = xRow.isCustomHeight()) != null) {
            row.setCustomHeight(isCustomHeight);
        }
        if ((isHidden = xRow.isHidden()) != null) {
            row.setHidden(isHidden);
        }
        if ((outlineLevel = xRow.getOutlineLevel()) != null) {
            row.setOutlineLevel(outlineLevel.intValue());
        }
        if ((collapsed = xRow.isCollapsed()) != null) {
            row.setCollapsed(collapsed);
        }
        if ((sIndex = xRow.getStyle()) > -1) {
            row.setCellStyle(this.importCellXf(this.cellXfsCache.getCellXfAt(sIndex), false));
        }
        this._importPhase.setPhase("cell");
        for (XlsxExtractor.XlsxCellExtractor xCell : xRow.getCells()) {
            this.importCell(xCell, xRow.getIndex(), sheet);
        }
        this._importPhase.setPhase("row");
        return row;
    }

    protected SCell importCell(XlsxExtractor.XlsxCellExtractor xCell, int row, SSheet sheet) {
        XlsxExtractor.XlsxCommentExtractor xComment;
        XlsxExtractor.XlsxHyperlinkExtractor hyperlinkExtractor;
        String cellType;
        int cellIndex = xCell.index;
        this._importPhase.setColIndex(cellIndex);
        SCell cell = sheet.getCell(row, cellIndex);
        int sIndex = xCell.getStyle();
        if (sIndex > -1) {
            cell.setCellStyle(this.importCellXf(this.cellXfsCache.getCellXfAt(sIndex), true));
        }
        XlsxExtractor.XlsxFormulaExtractor xCellFormula = xCell.getFormula();
        String xCellType = xCell.getType();
        String string = cellType = xCellFormula != null ? "f" : xCellType;
        if (cellType != null) {
            switch (cellType) {
                case "n": {
                    if (xCell.getValue() == null) break;
                    cell.setNumberValue(Double.parseDouble((String)xCell.getValue()));
                    break;
                }
                case "inlineStr": {
                    XlsxExtractor.XlsxRichTextExtractor xRichText = xCell.getRichTextInline();
                    if (xRichText == null) break;
                    SRichText richText = cell.setupRichTextValue();
                    this.importRichText(xRichText, richText);
                    break;
                }
                case "s": 
                case "str": {
                    Object xCellValue = xCell.getValue();
                    if (xCellValue instanceof XlsxExtractor.XlsxRichTextExtractor) {
                        SRichText richText = cell.setupRichTextValue();
                        this.importRichText((XlsxExtractor.XlsxRichTextExtractor)xCellValue, richText);
                        break;
                    }
                    cell.setStringValue((String)xCellValue);
                    break;
                }
                case "b": {
                    cell.setBooleanValue(XlsxJsonHelper.toBoolean(xCell.getValue(), false));
                    break;
                }
                case "f": {
                    FormulaType formulaType;
                    Object formulaValue = xCellFormula.getValue();
                    String type = xCellFormula.getType();
                    FormulaType formulaType2 = formulaType = "array".equals(type) ? FormulaType.ARRAY : FormulaType.CELL;
                    if (formulaValue instanceof String) {
                        if (formulaType != FormulaType.ARRAY) {
                            cell.setFormulaValue((String)formulaValue);
                        } else {
                            sheet.setArrayFormula((String)formulaValue, new CellRegion(xCellFormula.getRef()));
                        }
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("imported a formula: {} at {}", formulaValue, (Object)new SheetRegion(sheet, cell.getRowIndex(), cell.getColumnIndex()).getReferenceString());
                        }
                    } else if (formulaValue != null) {
                        String ref0 = (String)((Pair)formulaValue).x;
                        String formula = (String)((Pair)formulaValue).y;
                        if (formulaType != FormulaType.ARRAY) {
                            Ref ref1 = Converter.a1ToRef(ref0);
                            ParsingBook fpb = new ParsingBook(this.book);
                            SharedFormula sf = new SharedFormula(SpreadsheetVersion.EXCEL2007);
                            FormulaParseContext formulaCtx = new FormulaParseContext(this.book, sheet, cell, sheet.getSheetName(), null, Locale.US, formulaType);
                            FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
                            Ptg[] ptgs = this._sharedFormulaPtgArray.get(formula);
                            if (ptgs == null) {
                                ptgs = ((FormulaEngineImpl)fe).parse(formula, fpb, this.book.getSheetIndex(sheet), formulaCtx);
                                this._sharedFormulaPtgArray.put(formula, ptgs);
                            }
                            Ptg[] fmla = sf.convertSharedFormulas(ptgs, row - ref1.getTop(), cellIndex - ref1.getLeft());
                            formula = FormulaRenderer.toFormulaString((FormulaRenderingWorkbook)fpb, (Ptg[])fmla);
                            cell.setFormulaValue(formula);
                            if (_logger.isDebugEnabled()) {
                                _logger.debug("imported a shared formula: {} at {}", (Object)formula, (Object)new SheetRegion(sheet, cell.getRowIndex(), cell.getColumnIndex()).getReferenceString());
                            }
                        } else {
                            sheet.setArrayFormula(formula, new CellRegion(ref0));
                        }
                    } else {
                        if (xCell.getValue() != null) {
                            cell.setNumberValue(Double.parseDouble((String)xCell.getValue()));
                        }
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("unsupported formula, imported cell cache instead at {}", (Object)new SheetRegion(sheet, cell.getRowIndex(), cell.getColumnIndex()).getReferenceString());
                        }
                    }
                    if (!this.isImportCache() || this.mustCalc(cell) || xCellType == null) break;
                    BoolEval val = null;
                    switch (xCellType) {
                        case "n": {
                            if (xCell.getValue() == null) break;
                            val = new NumberEval(Double.parseDouble((String)xCell.getValue()));
                            break;
                        }
                        case "inlineStr": {
                            XlsxExtractor.XlsxRichTextExtractor richTextInline0 = xCell.getRichTextInline();
                            if (richTextInline0 == null) break;
                            RichTextImpl richText = new RichTextImpl();
                            this.importRichText(richTextInline0, richText);
                            val = new StringEval(richText.getText());
                            break;
                        }
                        case "s": 
                        case "str": {
                            Object xCellValue0 = xCell.getValue();
                            if (xCellValue0 instanceof XlsxExtractor.XlsxRichTextExtractor) {
                                RichTextImpl richText = new RichTextImpl();
                                this.importRichText((XlsxExtractor.XlsxRichTextExtractor)xCellValue0, richText);
                                val = new StringEval(richText.getText());
                                break;
                            }
                            if (xCellValue0 == null && xCell.getFormula() != null) {
                                xCellValue0 = "";
                            }
                            val = new StringEval((String)xCellValue0);
                            break;
                        }
                        case "b": {
                            val = BoolEval.valueOf((boolean)Boolean.parseBoolean((String)xCell.getValue()));
                            break;
                        }
                        case "e": {
                            if (xCell.getValue() == null) break;
                            val = ErrorEval.valueOf((int)XlsxImporter.getErrorCode((String)xCell.getValue()));
                            break;
                        }
                    }
                    if (val == null) break;
                    ((AbstractCellAdv)cell).setFormulaResultValue((ValueEval)val);
                    break;
                }
                case "e": {
                    if (xCell.getValue() == null) break;
                    cell.setErrorValue(PoiEnumConversion.toErrorCode(XlsxImporter.getErrorCode((String)xCell.getValue())));
                    break;
                }
                default: {
                    Object val = xCell.getValue();
                    if (val != null) {
                        cell.setNumberValue(Double.parseDouble((String)val));
                    }
                    if (!_logger.isDebugEnabled()) break;
                    _logger.debug("treat a cell type: {} as a number value: {}", (Object)cellType, val);
                }
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("imported a cell type: {} at {}", (Object)cellType, (Object)new SheetRegion(sheet, cell.getRowIndex(), cell.getColumnIndex()).getReferenceString());
        }
        if (this.hyperlinksCache != null && !this.hyperlinksCache.isEmpty() && (hyperlinkExtractor = this.hyperlinksCache.get(Converter.rangeToA1(row, cellIndex))) != null) {
            String addr = hyperlinkExtractor.getLocation();
            String label = hyperlinkExtractor.getDisplay();
            SHyperlink hyperlink = cell.setupHyperlink(hyperlinkExtractor.getType(), addr == null ? "" : addr, label == null ? "" : label);
            cell.setHyperlink(hyperlink);
        }
        if (this.commentsCache != null && !this.commentsCache.isEmpty() && (xComment = this.commentsCache.get(Converter.rangeToA1(row, cellIndex))) != null) {
            SComment comment = cell.setupComment();
            comment.setAuthor(xComment.getAuthorName());
            comment.setVisible(xComment.isVisible());
            XlsxExtractor.XlsxRichTextExtractor richTextExtractor = xComment.getText();
            if (richTextExtractor != null) {
                List<XlsxExtractor.XlsxREItExtractor> runs = richTextExtractor.getRuns();
                if (!runs.isEmpty()) {
                    this.importRichText(richTextExtractor, comment.setupRichText());
                } else {
                    comment.setText(richTextExtractor.getBaseText());
                }
            } else {
                comment.setText(richTextExtractor.getBaseText());
            }
        }
        return cell;
    }

    public static final String getErrorText(int errorCode) {
        switch (errorCode) {
            case 0: {
                return "#NULL!";
            }
            case 7: {
                return "#DIV/0!";
            }
            case 15: {
                return "#VALUE!";
            }
            case 23: {
                return "#REF!";
            }
            case 29: {
                return "#NAME?";
            }
            case 36: {
                return "#NUM!";
            }
            case 42: {
                return "#N/A";
            }
            case 127: {
                return "#ERROR!";
            }
        }
        throw new IllegalArgumentException("Bad error code (" + errorCode + ")");
    }

    public static final byte getErrorCode(String errorText) {
        switch (errorText) {
            case "#NULL!": {
                return 0;
            }
            case "#DIV/0!": {
                return 7;
            }
            case "#VALUE!": {
                return 15;
            }
            case "#REF!": {
                return 23;
            }
            case "#NAME?": {
                return 29;
            }
            case "#NUM!": {
                return 36;
            }
            case "#N/A": {
                return 42;
            }
            case "#ERROR!": {
                return 127;
            }
        }
        throw new IllegalArgumentException("Bad error text (" + errorText + ")");
    }

    protected boolean mustCalc(SCell cell) {
        FormulaExpression val = ((AbstractCellAdv)cell).getFormulaExpression();
        for (Ptg ptg : val.getPtgs()) {
            if (!(ptg instanceof FuncVarPtg) || ((FuncVarPtg)ptg).getFunctionIndex() != 148) continue;
            return true;
        }
        return false;
    }

    protected void importRichText(XlsxExtractor.XlsxRichTextExtractor xRichText, SRichText richText) {
        List<XlsxExtractor.XlsxREItExtractor> runs = xRichText.getRuns();
        String cellValue = xRichText.getBaseText();
        richText.addSegment(cellValue != null ? cellValue : "", null);
        for (XlsxExtractor.XlsxREItExtractor run : runs) {
            XlsxExtractor.XlsxFontExtractor runFont = run.getFont();
            richText.addSegment(run.getText(), runFont == null ? null : Optional.ofNullable(this.fontsCache.getFont(runFont)).orElse(this.createZssFont(runFont)));
        }
    }

    protected SFont createDxfZssFont(XlsxExtractor.XlsxFontExtractor xFont) {
        Number size;
        AbstractFontBuilderAdv fb = (AbstractFontBuilderAdv)this.book.createFont();
        if (xFont.isOverrideName()) {
            fb.overrideName(true).name(xFont.getName());
        }
        if (xFont.isOverrideBold()) {
            fb.overrideBold(true).boldweight(PoiEnumConversion.toBoldweight((short)(xFont.isBold() != false ? 700 : 400)));
        }
        if (xFont.isOverrideItalic()) {
            fb.overrideItalic(true).italic(xFont.isItalic());
        }
        if (xFont.isOverrideStrike()) {
            fb.overrideStrikeout(true).strikeout(xFont.isStrike());
        }
        if (xFont.isOverrideUnderline()) {
            fb.overrideUnderline(true).underline(XlsxImporter.toUnderline(xFont.getUnderline()));
        }
        if ((size = xFont.getSize()) != null) {
            fb.overrideHeightPoints(true).heightPoints(size.intValue());
        } else {
            fb.heightPoints(11);
        }
        if (xFont.isOverrideVertAlign()) {
            fb.overrideTypeOffset(true).typeOffset(XlsxImporter.toTypeOffset(xFont.getVertAlign()));
        }
        if (xFont.isOverrideColor()) {
            fb.overrideColor(true).color(XlsxImporter.getFontHTMLColor(xFont.getColor(), this.themes, this));
        }
        return (SFont)fb.build();
    }

    protected SFont createZssFont(XlsxExtractor.XlsxFontExtractor xFont) {
        Number size = xFont.getSize();
        return (SFont)this.book.addFont().name(xFont.getName()).boldweight(PoiEnumConversion.toBoldweight((short)(xFont.isBold() != false ? 700 : 400))).italic(xFont.isItalic()).strikeout(xFont.isStrike()).underline(XlsxImporter.toUnderline(xFont.getUnderline())).heightPoints(size != null ? size.intValue() : 11).typeOffset(XlsxImporter.toTypeOffset(xFont.getVertAlign())).color(XlsxImporter.getFontHTMLColor(xFont.getColor(), this.themes, this)).build();
    }

    protected static String getHTMLColorFromHex(String colorHax) {
        byte[] argb = UnitUtil.hexToArgbColor(colorHax);
        return argb.length > 3 ? "#" + BookHelper.toHex(argb[1]) + BookHelper.toHex(argb[2]) + BookHelper.toHex(argb[3]) : "#" + BookHelper.toHex(argb[0]) + BookHelper.toHex(argb[1]) + BookHelper.toHex(argb[2]);
    }

    public static String getBorderHTMLColor(XlsxExtractor.XlsxColorExtractor color, XlsxExtractor.XlsxThemesExtractor themes, XlsxImporter xlsxImporter) {
        return XlsxImporter.getHTMLColor(color, themes, xlsxImporter, "#000000");
    }

    public static String getFontHTMLColor(XlsxExtractor.XlsxColorExtractor color, XlsxExtractor.XlsxThemesExtractor themes, XlsxImporter xlsxImporter) {
        return XlsxImporter.getHTMLColor(color, themes, xlsxImporter, "#000000");
    }

    public static String getForegroundHTMLColor(XlsxExtractor.XlsxColorExtractor color, XlsxExtractor.XlsxThemesExtractor themes, XlsxImporter xlsxImporter) {
        return XlsxImporter.getHTMLColor(color, themes, xlsxImporter, "#000000");
    }

    public static String getBackgroundHTMLColor(XlsxExtractor.XlsxColorExtractor color, XlsxExtractor.XlsxThemesExtractor themes, XlsxImporter xlsxImporter) {
        return XlsxImporter.getHTMLColor(color, themes, xlsxImporter, "#ffffff");
    }

    protected static String getHTMLColor(XlsxExtractor.XlsxColorExtractor color, XlsxExtractor.XlsxThemesExtractor themes, XlsxImporter xlsxImporter, String nullAs) {
        if (color != null) {
            XlsxExtractor.XlsxClrSchemeExtractor clrScheme;
            byte[] argb;
            Number indexed = color.getIndexed();
            if (indexed != null && (argb = UnitUtil.hexToArgbColor(xlsxImporter.colorsCache.getIndexColorByIndex(indexed.intValue()))) != null) {
                return argb.length > 3 ? "#" + BookHelper.toHex(argb[1]) + BookHelper.toHex(argb[2]) + BookHelper.toHex(argb[3]) : "#" + BookHelper.toHex(argb[0]) + BookHelper.toHex(argb[1]) + BookHelper.toHex(argb[2]);
            }
            Object colorRgb = color.getRgb();
            Number colorTint = color.getTint();
            if (colorRgb != null) {
                if (((String)(colorRgb = ((String)colorRgb).toLowerCase())).length() == 6) {
                    colorRgb = "ff" + (String)colorRgb;
                }
                argb = colorTint != null ? BookHelper.getRgbWithTint(UnitUtil.hexToArgbColor((String)colorRgb), colorTint.doubleValue()) : UnitUtil.hexToArgbColor((String)colorRgb);
                return argb.length > 3 ? "#" + BookHelper.toHex(argb[1]) + BookHelper.toHex(argb[2]) + BookHelper.toHex(argb[3]) : "#" + BookHelper.toHex(argb[0]) + BookHelper.toHex(argb[1]) + BookHelper.toHex(argb[2]);
            }
            Number colorTheme = color.getTheme();
            if (colorTheme != null && themes != null && (clrScheme = themes.getClrScheme()) != null) {
                String rgb = null;
                switch (colorTheme.intValue()) {
                    case 0: {
                        rgb = clrScheme.getLt1();
                        break;
                    }
                    case 1: {
                        rgb = clrScheme.getDk1();
                        break;
                    }
                    case 2: {
                        rgb = clrScheme.getLt2();
                        break;
                    }
                    case 3: {
                        rgb = clrScheme.getDk2();
                        break;
                    }
                    case 4: {
                        rgb = clrScheme.getAccent1();
                        break;
                    }
                    case 5: {
                        rgb = clrScheme.getAccent2();
                        break;
                    }
                    case 6: {
                        rgb = clrScheme.getAccent3();
                        break;
                    }
                    case 7: {
                        rgb = clrScheme.getAccent4();
                        break;
                    }
                    case 8: {
                        rgb = clrScheme.getAccent5();
                        break;
                    }
                    case 9: {
                        rgb = clrScheme.getAccent6();
                        break;
                    }
                    case 10: {
                        rgb = clrScheme.getHlink();
                        break;
                    }
                    case 11: {
                        rgb = clrScheme.getFolHlink();
                    }
                }
                if (rgb != null) {
                    argb = colorTint != null ? BookHelper.getRgbWithTint(UnitUtil.hexToArgbColor(rgb), colorTint.doubleValue()) : UnitUtil.hexToArgbColor(rgb);
                    return argb.length > 3 ? "#" + BookHelper.toHex(argb[1]) + BookHelper.toHex(argb[2]) + BookHelper.toHex(argb[3]) : "#" + BookHelper.toHex(argb[0]) + BookHelper.toHex(argb[1]) + BookHelper.toHex(argb[2]);
                }
            }
        }
        return nullAs;
    }

    protected static SColor getSchemeHTMLColor(XlsxExtractor.XlsxSchemeClrExtractor color, XlsxExtractor.XlsxThemesExtractor themes) {
        String colorVal = color.getColorVal();
        String rgb = null;
        if (color.isSchemeClr()) {
            XlsxExtractor.XlsxClrSchemeExtractor clrScheme;
            if (themes != null && (clrScheme = themes.getClrScheme()) != null) {
                switch (colorVal) {
                    case "lt1": 
                    case "bg1": {
                        rgb = clrScheme.getLt1();
                        break;
                    }
                    case "dk1": 
                    case "tx1": {
                        rgb = clrScheme.getDk1();
                        break;
                    }
                    case "lt2": 
                    case "bg2": {
                        rgb = clrScheme.getLt2();
                        break;
                    }
                    case "dk2": 
                    case "tx2": {
                        rgb = clrScheme.getDk2();
                        break;
                    }
                    case "accent1": {
                        rgb = clrScheme.getAccent1();
                        break;
                    }
                    case "accent2": {
                        rgb = clrScheme.getAccent2();
                        break;
                    }
                    case "accent3": {
                        rgb = clrScheme.getAccent3();
                        break;
                    }
                    case "accent4": {
                        rgb = clrScheme.getAccent4();
                        break;
                    }
                    case "accent5": {
                        rgb = clrScheme.getAccent5();
                        break;
                    }
                    case "accent6": {
                        rgb = clrScheme.getAccent6();
                        break;
                    }
                    case "hlink": {
                        rgb = clrScheme.getHlink();
                        break;
                    }
                    case "folhlink": {
                        rgb = clrScheme.getFolHlink();
                    }
                }
            }
        } else if (color.isSrgbClr()) {
            rgb = colorVal;
        }
        if (rgb != null) {
            byte[] argb = UnitUtil.hexToArgbColor(rgb);
            if (color.isModified()) {
                Map modifies = color.getColor();
                boolean _hasAlpha = false;
                for (Object tag : modifies.keySet()) {
                    if (!(tag instanceof String)) continue;
                    switch ((String)tag) {
                        case "a:tint": {
                            argb = BookHelper.getRgbWithSchemeTint(argb, (double)color.getTint().intValue() / 100000.0);
                            break;
                        }
                        case "a:shade": {
                            argb = BookHelper.getRgbWithSchemeShade(argb, (double)color.getShade().intValue() / 100000.0);
                            break;
                        }
                        case "a:alpha": {
                            _hasAlpha = true;
                            break;
                        }
                        case "a:hueMod": {
                            argb = BookHelper.getRgbWithSchemeHueMod(argb, (double)color.getHueMod().intValue() / 100000.0);
                            break;
                        }
                        case "a:sat": {
                            argb = BookHelper.getRgbWithSchemeSat(argb, (double)color.getSat().intValue() / 100000.0);
                            break;
                        }
                        case "a:satOff": {
                            argb = BookHelper.getRgbWithSchemeSatOff(argb, (double)color.getSatOff().intValue() / 100000.0);
                            break;
                        }
                        case "a:satMod": {
                            argb = BookHelper.getRgbWithSchemeSatMod(argb, (double)color.getSatMod().intValue() / 100000.0);
                            break;
                        }
                        case "a:lum": {
                            argb = BookHelper.getRgbWithSchemeLum(argb, (double)color.getLum().intValue() / 100000.0);
                            break;
                        }
                        case "a:lumOff": {
                            argb = BookHelper.getRgbWithSchemeLumOff(argb, (double)color.getLumOff().intValue() / 100000.0);
                            break;
                        }
                        case "a:lumMod": {
                            argb = BookHelper.getRgbWithSchemeLumMod(argb, (double)color.getLumMod().intValue() / 100000.0);
                        }
                    }
                }
            }
            String hex = argb.length > 3 ? BookHelper.toHex(argb[1]) + BookHelper.toHex(argb[2]) + BookHelper.toHex(argb[3]) : BookHelper.toHex(argb[0]) + BookHelper.toHex(argb[1]) + BookHelper.toHex(argb[2]);
            return new ColorImpl(hex);
        }
        return null;
    }

    public static SFont.Underline toUnderline(String underline) {
        switch (underline = underline == null ? "none" : underline) {
            case "single": {
                return SFont.Underline.SINGLE;
            }
            case "double": {
                return SFont.Underline.DOUBLE;
            }
            case "singleAccounting": {
                return SFont.Underline.SINGLE_ACCOUNTING;
            }
            case "doubleAccounting": {
                return SFont.Underline.DOUBLE_ACCOUNTING;
            }
        }
        return SFont.Underline.NONE;
    }

    public static SFont.TypeOffset toTypeOffset(String typeOffset) {
        switch (typeOffset = typeOffset == null ? "baseline" : typeOffset) {
            case "subscript": {
                return SFont.TypeOffset.SUB;
            }
            case "superscript": {
                return SFont.TypeOffset.SUPER;
            }
        }
        return SFont.TypeOffset.NONE;
    }

    protected boolean skipName(XlsxExtractor.XlsxDefinedNameExtractor definedName) {
        String namename = definedName.getName();
        if (namename == null) {
            return true;
        }
        if (definedName.isFunction()) {
            return true;
        }
        if (definedName.getFormula() == null) {
            return true;
        }
        Boolean hidden = definedName.isHidden();
        return hidden == Boolean.TRUE;
    }

    protected void importNamedRange() {
        List<XlsxExtractor.XlsxDefinedNameExtractor> definedNames = this.workbookExtractor.getDefinedNames();
        for (XlsxExtractor.XlsxDefinedNameExtractor definedName : definedNames) {
            if (this.skipName(definedName)) continue;
            SName namedRange = null;
            namedRange = definedName.getLocalSheetId() == null ? this.book.createName(definedName.getName()) : this.book.createName(definedName.getName(), this.book.getSheet(Integer.parseInt(definedName.getLocalSheetId())).getSheetName());
            namedRange.setRefersToFormula(definedName.getFormula());
        }
    }

    protected static InputStream convertZipInputStreamToInputStream(ZipInputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)out);
        ByteArrayInputStream is = new ByteArrayInputStream(out.toByteArray());
        return is;
    }

    protected XlsxExtractor.XlsxWorkbookExtractor newXlsxExtractor(InputStream inputStream) throws IOException {
        ZipEntry entry;
        ZipInputStream zipFile = inputStream instanceof ZipInputStream ? (ZipInputStream)inputStream : new ZipInputStream(inputStream);
        HashMap<String, InputStream> mapping = new HashMap<String, InputStream>(12);
        while ((entry = zipFile.getNextEntry()) != null) {
            mapping.put(entry.getName(), XlsxImporter.convertZipInputStreamToInputStream(zipFile));
        }
        JSONObject<String, Object> xlsxMap = new JSONObject<String, Object>();
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        factory.setProperty("javax.xml.stream.supportDTD", false);
        try {
            for (Map.Entry me : mapping.entrySet()) {
                String key = (String)me.getKey();
                InputStream is = (InputStream)me.getValue();
                if (key.endsWith(".rels") || key.endsWith(".xml")) {
                    if (key.endsWith("calcChain.xml") || key.startsWith("docProps/")) continue;
                    XMLStreamReader reader = factory.createXMLStreamReader(is);
                    xlsxMap.put(key, XlsxParser.parseXML(reader));
                } else if (key.endsWith(".vml")) {
                    BufferedInputStream bufferedInputStream = null;
                    try {
                        bufferedInputStream = new BufferedInputStream(is);
                        bufferedInputStream.mark(bufferedInputStream.available());
                        XMLStreamReader reader = factory.createXMLStreamReader(bufferedInputStream);
                        xlsxMap.put(key, XlsxParser.parseXML(reader));
                    }
                    catch (XMLStreamException e) {
                        Parser parser = Parser.htmlParser();
                        parser.settings(new ParseSettings(true, true));
                        inputStream.reset();
                        Document document = parser.parseInput(IOUtils.toString((InputStream)inputStream, (String)"UTF-8"), "");
                        document.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
                        StringReader sreader = new StringReader(document.body().html());
                        XMLStreamReader reader = factory.createXMLStreamReader(sreader);
                        xlsxMap.put(key, XlsxParser.parseXML(reader));
                    }
                } else {
                    xlsxMap.put(key, IOUtils.toByteArray((InputStream)is));
                }
                is.close();
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        return XlsxExtractor.getWorkbook(xlsxMap);
    }

    protected void importDefaultCellStyles(XlsxExtractor.XlsxStyleSheetExtractor styleSheet) {
        ((AbstractBookAdv)this.book).clearDefaultCellStyles();
        for (XlsxExtractor.XlsxXfExtractor cellStyleXf : styleSheet.getCellStyleXfs()) {
            this.book.addDefaultCellStyle(this.importCellStyleXf(cellStyleXf, false));
        }
        if (this.book.getDefaultCellStyles().isEmpty()) {
            ((AbstractBookAdv)this.book).initDefaultCellStyles();
        }
        ((AbstractBookAdv)this.book).initDefaultFont();
    }

    protected String getNumberFormat(XlsxExtractor.XlsxNumFmtExtractor extractor) {
        if (extractor == null) {
            return this.numFmtsCache.getNumFmtAt(0);
        }
        String formatCode = extractor.getFormatCode();
        if (formatCode != null) {
            return formatCode;
        }
        return this.numFmtsCache.getNumFmtAt(extractor.getNumFmtId().intValue());
    }

    protected SCellStyle.Alignment toHorizontalAlignment(String align) {
        switch (align = align == null ? "general" : align) {
            case "left": {
                return SCellStyle.Alignment.LEFT;
            }
            case "right": {
                return SCellStyle.Alignment.RIGHT;
            }
            case "center": {
                return SCellStyle.Alignment.CENTER;
            }
            case "centerContinuous": {
                return SCellStyle.Alignment.CENTER_SELECTION;
            }
            case "fill": {
                return SCellStyle.Alignment.FILL;
            }
            case "justify": {
                return SCellStyle.Alignment.JUSTIFY;
            }
        }
        return SCellStyle.Alignment.GENERAL;
    }

    protected SCellStyle.VerticalAlignment toVerticalAlignment(String align) {
        switch (align = align == null ? "bottom" : align) {
            case "top": {
                return SCellStyle.VerticalAlignment.TOP;
            }
            case "center": {
                return SCellStyle.VerticalAlignment.CENTER;
            }
            case "justify": {
                return SCellStyle.VerticalAlignment.JUSTIFY;
            }
        }
        return SCellStyle.VerticalAlignment.BOTTOM;
    }

    protected short convertToUIRotation(short rotation) {
        if (90 < rotation && rotation <= 180) {
            rotation = (short)(90 - rotation);
        }
        return rotation;
    }

    protected SCellStyle importCellStyleXf(XlsxExtractor.XlsxXfExtractor xCellXf, boolean inStyleTable) {
        this.cellStyleXfsCache.add(xCellXf);
        return this.importCellXf(xCellXf, inStyleTable);
    }

    protected SCellStyle importCellXf(XlsxExtractor.XlsxXfExtractor xCellXf, boolean inStyleTable) {
        SCellStyle cellStyle = this.importedXfs.get(xCellXf);
        if (cellStyle == null) {
            Number fontId;
            Borders.Border border;
            Number borderId;
            Object fill;
            Number fillId;
            XlsxExtractor.XlsxProtectionExtractor protection;
            XlsxExtractor.XlsxAlignmentExtractor alignment;
            SCellStyleBuilder csb = inStyleTable ? this.book.addCellStyle() : this.book.createCellStyle();
            Number numFmtId = xCellXf.getNumFmtId();
            if (numFmtId != null) {
                String dataFormat = this.numFmtsCache.getNumFmtAt(numFmtId.intValue());
                if (dataFormat == null) {
                    dataFormat = "General";
                }
                csb.dataFormat(dataFormat).directFormat(!NumFmts.isBuiltIn(numFmtId.intValue()));
            }
            if ((alignment = xCellXf.getAlignment()) != null) {
                csb.wrapText(alignment.isWrapText()).alignment(this.toHorizontalAlignment(alignment.getHorizontal())).verticalAlignment(this.toVerticalAlignment(alignment.getVertical())).rotation(this.convertToUIRotation(alignment.getTextRotation())).indention(alignment.getIndent());
            }
            if ((protection = xCellXf.getProtection()) != null) {
                csb.locked(protection.isLocked()).hidden(protection.isHidden());
            }
            if ((fillId = xCellXf.getFillId()) != null && (fill = this.fillsCache.getFillAt(fillId.intValue())) instanceof Fills.PatternFill) {
                Fills.PatternFill patternFill = (Fills.PatternFill)fill;
                String fgColor = patternFill.getFgColor();
                String bgColor = patternFill.getBgColor();
                if (patternFill.getType() == SFill.FillPattern.SOLID) {
                    String tmp = fgColor;
                    fgColor = bgColor;
                    bgColor = tmp;
                }
                csb.fillPattern(patternFill.getType()).fillColor(fgColor).backColor(bgColor);
            }
            if ((borderId = xCellXf.getBorderId()) != null && (border = this.bordersCache.getBordreAt(borderId.intValue())) != null) {
                Borders.BorderPr borderPr = border.getLeft();
                if (borderPr != null) {
                    csb.borderLeft(borderPr.getStyle()).borderLeftColor(borderPr.getColor());
                }
                if ((borderPr = border.getRight()) != null) {
                    csb.borderRight(borderPr.getStyle()).borderRightColor(borderPr.getColor());
                }
                if ((borderPr = border.getTop()) != null) {
                    csb.borderTop(borderPr.getStyle()).borderTopColor(borderPr.getColor());
                }
                if ((borderPr = border.getBottom()) != null) {
                    csb.borderBottom(borderPr.getStyle()).borderBottomColor(borderPr.getColor());
                }
            }
            if ((fontId = xCellXf.getFontId()) != null) {
                csb.font(this.fontsCache.getFontAt(fontId.intValue()));
            }
            cellStyle = (SCellStyle)csb.build();
            this.importedXfs.put(xCellXf, cellStyle);
        }
        return cellStyle;
    }

    protected void importNamedStyles(XlsxExtractor.XlsxStyleSheetExtractor styleSheet) {
        ((AbstractBookAdv)this.book).clearNamedStyles();
        for (XlsxExtractor.XlsxCellStyleExtractor extractor : styleSheet.getCellStyles()) {
            NamedStyleImpl namedStyle = new NamedStyleImpl(extractor.getName(), extractor.isCustomBuiltin(), extractor.getBuiltinId(), this.book, extractor.getXfId());
            this.book.addNamedCellstyle(namedStyle);
        }
    }

    protected void importTables(XlsxExtractor.XlsxSheetExtractor xSheet, SSheet sheet) {
        for (XlsxExtractor.XlsxTableExtractor xTable : xSheet.getTables()) {
            String displayName = xTable.getDisplayName();
            this._importPhase.setPhase("table named %s");
            this._importPhase.setTableName(displayName);
            CellRegion region0 = new CellRegion(xTable.getRef());
            SheetRegion region = new SheetRegion(sheet, region0);
            this._importPhase.setPhase("style of table named %s");
            XlsxExtractor.XlsxTableStyleInfoExtractor tableStyleInfo = xTable.getTableStyleInfo();
            TableStyleInfoImpl info = new TableStyleInfoImpl(tableStyleInfo.getName(), tableStyleInfo.isShowColumnStripes(), tableStyleInfo.isShowRowStripes(), tableStyleInfo.isShowFirstColumn(), tableStyleInfo.isShowLastColumn());
            this._importPhase.setPhase("table named %s");
            TableImpl table = new TableImpl((AbstractBookAdv)this.book, xTable.getName(), displayName, region, xTable.getHeaderRowCount(), xTable.getTotalsRowCount(), info, xTable.isTotalsRowShown());
            for (XlsxExtractor.XlsxTableColumnExtractor xTableColumn : xTable.getTableColumns()) {
                XlsxExtractor.XlsxTableFormulaExtractor totalsRowFormula;
                this._importPhase.setPhase("table column %s[%s]");
                String name = xTableColumn.getName();
                this._importPhase.setTableColumnName(name);
                TableColumnImpl tbCol = new TableColumnImpl(xTableColumn.getName());
                tbCol.setTotalsRowFunction(xTableColumn.getTotalsRowFunction());
                if (tbCol.getTotalsRowFunction() == STableColumn.STotalsRowFunction.none) {
                    tbCol.setTotalsRowLabel(xTableColumn.getTotalsRowLabel());
                } else if (tbCol.getTotalsRowFunction() == STableColumn.STotalsRowFunction.custom && (totalsRowFormula = xTableColumn.getTotalsRowFormula()) != null) {
                    tbCol.setTotalsRowFormula(totalsRowFormula.getExpression());
                }
                table.addColumn(tbCol);
            }
            this._importPhase.setPhase("table named %s");
            XlsxExtractor.XlsxAutoFilterExtractor autoFilter = xTable.getAutoFilter();
            table.enableAutoFilter(autoFilter != null);
            sheet.addTable(table);
            if (autoFilter != null) {
                this._importPhase.setPhase("auto filter of table named %s");
                SAutoFilter zssFilter = table.getAutoFilter();
                this.importAutoFilterColumns(autoFilter, zssFilter);
                this._importPhase.setPhase("table named %s");
            }
            this.importTableName(table);
            ((AbstractBookAdv)this.book).addTable(table);
            this._importPhase.clear();
        }
    }

    protected void importTableName(STable table) {
        SName namedRange = ((AbstractBookAdv)this.book).createTableName(table);
        SheetRegion rgn = table.getDataRegion();
        namedRange.setRefersToFormula(rgn.getReferenceString());
    }

    protected SColorFilter importColorFilter(XlsxExtractor.XlsxColorFilterExtractor colorFilter) {
        if (colorFilter == null) {
            return null;
        }
        SExtraStyle src = this.styleCaches.getExtraStyleCache().get(colorFilter.getDxfId().intValue());
        if (src == null) {
            return null;
        }
        SExtraStyle style = this.book.getOrAddExtraStyle(src);
        Boolean cellColor = colorFilter.isCellColor();
        return new ColorFilterImpl(style, cellColor != null && cellColor == false);
    }

    protected void importAutoFilterColumns(XlsxExtractor.XlsxAutoFilterExtractor xFilter, SAutoFilter zssFilter) {
        List<XlsxExtractor.XlsxFilterColumnExtractor> filterColumns = xFilter.getFilterColumns();
        HashMap<String, Object> extra = new HashMap<String, Object>();
        for (XlsxExtractor.XlsxFilterColumnExtractor extractor : filterColumns) {
            List<String> filters1;
            SAutoFilter.NFilterColumn destColumn = zssFilter.getFilterColumn(extractor.getColId().intValue(), true);
            SColorFilter destColorFilter = this.importColorFilter(extractor.getColorFilter());
            extra.put("colorFilter", destColorFilter);
            SCustomFilters destCustomFilters = this.importCustomFilters(extractor.getCustomFilters());
            extra.put("customFilters", destCustomFilters);
            SDynamicFilter destDynamicFilter = this.importDynamicFilter(extractor.getDynamicFilter());
            extra.put("dynamicFilter", destDynamicFilter);
            STop10Filter destTop10Filter = this.importTop10Filter(extractor.getTop10());
            extra.put("top10Filter", destTop10Filter);
            SAutoFilter.FilterOp operator = SAutoFilter.FilterOp.values;
            Set criteria1 = null;
            Object criteria2 = null;
            XlsxExtractor.XlsxFiltersExtractor filters = extractor.getFilters();
            if (filters != null && (filters1 = filters.getFilters()) != null) {
                criteria1 = filters1.stream().collect(Collectors.toSet());
                if (filters.isBlank()) {
                    criteria1.add("=");
                }
                operator = SAutoFilter.FilterOp.values;
            }
            if (destColorFilter != null) {
                SAutoFilter.FilterOp filterOp = operator = destColorFilter.isByFontColor() ? SAutoFilter.FilterOp.fontColor : SAutoFilter.FilterOp.cellColor;
            }
            if (destDynamicFilter != null) {
                String dynamicFilterType = destDynamicFilter.getType();
                if ("aboveAverage".equals(dynamicFilterType)) {
                    operator = SAutoFilter.FilterOp.aboveAverage;
                } else if ("belowAverage".equals(dynamicFilterType)) {
                    operator = SAutoFilter.FilterOp.belowAverage;
                }
            }
            if (destTop10Filter != null) {
                operator = SAutoFilter.FilterOp.top10;
            }
            destColumn.setProperties(operator, criteria1, criteria2, extractor.isSetHiddenButton() ? !extractor.isHiddenButton().booleanValue() : (extractor.isSetShowButton() ? extractor.isShowButton() : true), extra);
        }
    }

    protected SCustomFilters importCustomFilters(XlsxExtractor.XlsxCustomFiltersExtractor xCustomFilters) {
        if (xCustomFilters == null) {
            return null;
        }
        boolean and = xCustomFilters.isAnd();
        XlsxExtractor.XlsxCustomFilterExtractor poiFilter1 = xCustomFilters.getCustomFilter1();
        XlsxExtractor.XlsxCustomFilterExtractor poiFilter2 = xCustomFilters.getCustomFilter2();
        CustomFilterImpl filter1 = poiFilter1 != null ? new CustomFilterImpl(poiFilter1.getVal(), poiFilter1.getOperator()) : null;
        CustomFilterImpl filter2 = poiFilter2 == null ? null : new CustomFilterImpl(poiFilter2.getVal(), poiFilter2.getOperator());
        return new CustomFiltersImpl(filter1, filter2, and);
    }

    protected SDynamicFilter importDynamicFilter(XlsxExtractor.XlsxDynamicFilterExtractor xDynamicFilter) {
        if (xDynamicFilter == null) {
            return null;
        }
        Number maxval = xDynamicFilter.getMaxVal();
        Number val = xDynamicFilter.getVal();
        String type = xDynamicFilter.getType();
        return new DynamicFilterImpl(maxval != null ? Double.valueOf(maxval.doubleValue()) : null, val != null ? Double.valueOf(val.doubleValue()) : null, type);
    }

    protected STop10Filter importTop10Filter(XlsxExtractor.XlsxTop10Extractor xTop10Filter) {
        if (xTop10Filter == null) {
            return null;
        }
        return new Top10FilterImpl(xTop10Filter.isTop(), xTop10Filter.getVal(), xTop10Filter.isPercent(), xTop10Filter.getFilterVal());
    }

    protected void importExtraStyles(XlsxExtractor.XlsxStyleSheetExtractor styleSheet) {
        ((AbstractBookAdv)this.book).clearExtraStyles();
        for (XlsxExtractor.XlsxDxfExtractor extractor : styleSheet.getDxfs()) {
            this.styleCaches.getExtraStyleCache().add(this.importExtraStyle(extractor));
        }
    }

    protected SExtraStyle importExtraStyle(XlsxExtractor.XlsxDxfExtractor xDxf) {
        XlsxExtractor.XlsxNumFmtExtractor xNumFmt = xDxf.getNumFmt();
        String dataFormat = xNumFmt != null ? this.getNumberFormat(xDxf.getNumFmt()) : null;
        XlsxExtractor.XlsxFillExtractor xDxfFill = xDxf.getFill();
        ExtraFillImpl fill = null;
        if (xDxfFill instanceof XlsxExtractor.XlsxPatternExtractor) {
            XlsxExtractor.XlsxPatternExtractor dxfFill = (XlsxExtractor.XlsxPatternExtractor)xDxfFill;
            XlsxExtractor.XlsxColorExtractor xFgColor = dxfFill.getFgColor();
            XlsxExtractor.XlsxColorExtractor xBgColor = dxfFill.getBgColor();
            String fgColor = xFgColor != null ? XlsxImporter.getForegroundHTMLColor(dxfFill.getFgColor(), this.themes, this) : null;
            String bgColor = xBgColor != null ? XlsxImporter.getBackgroundHTMLColor(dxfFill.getBgColor(), this.themes, this) : null;
            String patternType = dxfFill.getPatternType();
            SFill.FillPattern fillPattern = patternType != null ? new Fills.PatternFill(patternType, fgColor, bgColor).getType() : null;
            SColor fgSColor = fgColor == null ? null : this.book.createColor(fgColor);
            SColor bgSColor = bgColor == null ? null : this.book.createColor(bgColor);
            fill = new ExtraFillImpl(fillPattern, fgSColor, bgSColor);
        }
        XlsxExtractor.XlsxBorderExtractor xBorder = xDxf.getBorder();
        SBorder border = null;
        if (xBorder != null) {
            Borders.Border border1 = this.createBorder(xBorder);
            border = this.createSBorder(border1);
        }
        SFont font = null;
        XlsxExtractor.XlsxFontExtractor xDxfFont = xDxf.getFont();
        if (xDxfFont != null) {
            font = this.createDxfZssFont(xDxfFont);
        }
        return new ImmutableExtraStyleImpl(font, fill, border, dataFormat);
    }

    protected SBorder createSBorder(Borders.Border border) {
        BorderLineImpl vertical;
        BorderLineImpl diagonal;
        BorderLineImpl bottom;
        BorderLineImpl right;
        BorderLineImpl top;
        BorderLineImpl left;
        Borders.BorderPr borderLeft = border.getLeft();
        Borders.BorderPr borderRight = border.getRight();
        Borders.BorderPr borderTop = border.getTop();
        Borders.BorderPr borderBottom = border.getBottom();
        Borders.BorderPr borderDiagonal = border.getDiagonal();
        Borders.BorderPr borderVertical = border.getVertical();
        Borders.BorderPr borderHorizontal = border.getHorizontal();
        BorderLineImpl borderLineImpl = borderLeft == null ? null : (left = new BorderLineImpl(borderLeft.getStyle(), borderLeft.getColor() == null ? null : this.book.createColor(borderLeft.getColor())));
        BorderLineImpl borderLineImpl2 = borderTop == null ? null : (top = new BorderLineImpl(borderTop.getStyle(), borderTop.getColor() == null ? null : this.book.createColor(borderTop.getColor())));
        BorderLineImpl borderLineImpl3 = borderRight == null ? null : (right = new BorderLineImpl(borderRight.getStyle(), borderRight.getColor() == null ? null : this.book.createColor(borderRight.getColor())));
        BorderLineImpl borderLineImpl4 = borderBottom == null ? null : (bottom = new BorderLineImpl(borderBottom.getStyle(), borderBottom.getColor() == null ? null : this.book.createColor(borderBottom.getColor())));
        BorderLineImpl borderLineImpl5 = borderDiagonal == null ? null : (diagonal = new BorderLineImpl(borderDiagonal.getStyle(), borderDiagonal.getColor() == null ? null : this.book.createColor(borderDiagonal.getColor())));
        BorderLineImpl borderLineImpl6 = borderVertical == null ? null : (vertical = new BorderLineImpl(borderVertical.getStyle(), borderVertical.getColor() == null ? null : this.book.createColor(borderVertical.getColor())));
        BorderLineImpl horizontal = borderHorizontal == null ? null : new BorderLineImpl(borderHorizontal.getStyle(), borderHorizontal.getColor() == null ? null : this.book.createColor(borderHorizontal.getColor()));
        return new BorderImpl(left, top, right, bottom, diagonal, vertical, horizontal);
    }

    protected void importTableStyles(XlsxExtractor.XlsxStyleSheetExtractor extractor) {
        ((AbstractBookAdv)this.book).clearTableStyles();
        XlsxExtractor.XlsxTableStylesExtractor tableStyles = extractor.getTableStyles();
        if (tableStyles != null) {
            for (XlsxExtractor.XlsxTableStyleExtractor tableStyle : tableStyles.getTableStyles()) {
                this.book.addTableStyle(this.importTableStyle(tableStyle));
            }
            this.book.setDefaultPivotStyleName(tableStyles.getDefaultPivotStyle());
            this.book.setDefaultTableStyleName(tableStyles.getDefaultTableStyle());
        }
    }

    protected STableStyleElem importTableStyleElem(XlsxExtractor.XlsxTableStyleElementExtractor styleElement) {
        SExtraStyle extraStyle = this.styleCaches.getExtraStyleCache().get(styleElement.getDxfId().intValue());
        if (extraStyle == null) {
            return null;
        }
        SExtraStyle style = this.book.getOrAddExtraStyle(extraStyle);
        return new TableStyleElemImpl(style.getFont(), style.getFill(), style.getBorder());
    }

    protected STableStyle importTableStyle(XlsxExtractor.XlsxTableStyleExtractor tableStyle) {
        String name = tableStyle.getName();
        HashMap<String, STableStyleElem> map = new HashMap<String, STableStyleElem>(13);
        for (XlsxExtractor.XlsxTableStyleElementExtractor styleElement : tableStyle.getTableStyleElements()) {
            map.put(styleElement.getType(), this.importTableStyleElem(styleElement));
        }
        return new TableStyleImpl(name, (STableStyleElem)map.get("wholeTable"), (STableStyleElem)map.get("firstColumnStripe"), 1, (STableStyleElem)map.get("secondColumnStripe"), 1, (STableStyleElem)map.get("firstRowStripe"), 1, (STableStyleElem)map.get("secondRowStripe"), 1, (STableStyleElem)map.get("lastColumn"), (STableStyleElem)map.get("firstColumn"), (STableStyleElem)map.get("headerRow"), (STableStyleElem)map.get("totalRow"), (STableStyleElem)map.get("firstHeaderCell"), (STableStyleElem)map.get("lastHeaderCell"), (STableStyleElem)map.get("firstTotalCell"), (STableStyleElem)map.get("lastTotalCell"));
    }

    protected void setBookType(SBook book) {
        book.setAttribute(BOOK_TYPE_KEY, "xlsx");
    }

    protected void importExternalBookLinks(List<XlsxExtractor.XlsxExternalLinkExtractor> externalReferences) {
        if (!externalReferences.isEmpty()) {
            ArrayList<String> bookNames = new ArrayList<String>();
            for (XlsxExtractor.XlsxExternalLinkExtractor exRef : externalReferences) {
                XlsxExtractor.XlsxExternalBookExtractor externalBook = exRef.getExternalBook();
                if (externalBook == null) continue;
                bookNames.add(externalBook.getName());
            }
            if (bookNames.size() > 0) {
                this.book.setAttribute("$KEIKAI_EXTERNAL_BOOK_NAMES$", bookNames);
            }
        }
    }

    protected void importWorkbookProtection(XlsxExtractor.XlsxWorkbookExtractor xBook, SBook book) {
        XlsxExtractor.XlsxWorkbookProtectionExtractor xBookProtection = xBook.getWorkbookProtection();
        if (xBookProtection != null) {
            WorkbookProtectionImpl bookProtection = (WorkbookProtectionImpl)book.getWorkbookProtection();
            bookProtection.setLockStructure(xBookProtection.isLockStructure());
            bookProtection.setLockWindows(xBookProtection.isLockWindows());
            bookProtection.setAlgName(xBookProtection.getAlgName());
            bookProtection.setHashValue(xBookProtection.getHashValue());
            bookProtection.setSaltValue(xBookProtection.getSaltValue());
            bookProtection.setSpinCount(xBookProtection.getSpinCount());
        }
    }

    protected void importSheets(List<XlsxExtractor.XlsxSheetExtractor> sheets) {
        sheets.forEach(xSheet -> {
            SSheet sheet = this.importSheet((XlsxExtractor.XlsxSheetExtractor)xSheet);
            this.importTables((XlsxExtractor.XlsxSheetExtractor)xSheet, sheet);
        });
    }

    protected SSheet importSheet(XlsxExtractor.XlsxSheetExtractor xSheet) {
        XlsxExtractor.XlsxSheetPropertiesExtractor sheetPr;
        String sheetName = xSheet.getName();
        this._importPhase.setPhase("sheet");
        this._importPhase.setSheetName(sheetName);
        SSheet sheet = this.book.createSheet(sheetName);
        List<XlsxExtractor.XlsxSheetViewExtractor> sheetViews = xSheet.getSheetViews();
        XlsxExtractor.XlsxSheetFormatPrExtractor sheetFormatPr = xSheet.getSheetFormatPr();
        this._importPhase.setPhase("sheet format");
        if (sheetFormatPr != null) {
            sheet.setDefaultRowHeight(UnitUtil.twipToPx((short)(sheetFormatPr.getDefaultRowHeight() * 20.0f)));
            int charWidth = ((AbstractBookAdv)this.book).getCharWidth();
            double defaultColWidth = 9.142857;
            if (sheetFormatPr.isSetDefaultColWidth()) {
                defaultColWidth = sheetFormatPr.getDefaultColWidth().doubleValue();
            } else if (sheetFormatPr.isSetBaseColWidth()) {
                defaultColWidth = UnitUtil.pxToCTChar(UnitUtil.defaultColumnWidthToPx(sheetFormatPr.getBaseColWidth(), charWidth), charWidth);
            }
            Number outlineLevelCol = sheetFormatPr.getOutlineLevelCol();
            Number outlineLevelRow = sheetFormatPr.getOutlineLevelRow();
            if (outlineLevelCol != null) {
                sheet.setOutlineLevelCol(outlineLevelCol.intValue());
            }
            if (outlineLevelRow != null) {
                sheet.setOutlineLevelRow(outlineLevelRow.intValue());
            }
            sheet.setDefaultColumnWidth(UnitUtil.xssfDefaultColumnWidthToPx(defaultColWidth, charWidth));
            this._importPhase.setPhase("sheet");
        } else {
            sheet.setDefaultColumnWidth(UnitUtil.xssfDefaultColumnWidthToPx(9.142857, ((AbstractBookAdv)this.book).getCharWidth()));
        }
        SSheetViewInfo viewInfo = sheet.getViewInfo();
        if (sheetViews != null && !sheetViews.isEmpty()) {
            Boolean showGridLines;
            this._importPhase.setPhase("sheet view");
            XlsxExtractor.XlsxSheetViewExtractor xlsxSheetViewExtractor = sheetViews.get(0);
            XlsxExtractor.XlsxPaneExtractor pane = xlsxSheetViewExtractor.getPane();
            if (pane != null) {
                viewInfo.setNumOfRowFreeze(pane.getYSplit());
                viewInfo.setNumOfColumnFreeze(pane.getXSplit());
            }
            if ((showGridLines = xlsxSheetViewExtractor.isShowGridLines()) != null) {
                viewInfo.setDisplayGridlines(showGridLines);
            }
            viewInfo.setColumnBreaks(xSheet.getColBreaks());
            viewInfo.setRowBreaks(xSheet.getRowBreaks());
            viewInfo.setTabSelected(xlsxSheetViewExtractor.isTabSelected());
            List<XlsxExtractor.XlsxSelectionExtractor> selections = xlsxSheetViewExtractor.getSelections();
            if (selections != null && !selections.isEmpty()) {
                XlsxExtractor.XlsxSelectionExtractor xlsxSelectionExtractor = selections.get(0);
                if (pane != null && pane.getActivePane() != null) {
                    String activePane = pane.getActivePane();
                    for (XlsxExtractor.XlsxSelectionExtractor selection : selections) {
                        if (!activePane.equals(selection.getPane())) continue;
                        xlsxSelectionExtractor = selection;
                        break;
                    }
                }
                String activeCell = xlsxSelectionExtractor.getActiveCell();
                String selectionAreas = xlsxSelectionExtractor.getSqref();
                viewInfo.setActiveCell(Strings.isBlank(activeCell) ? "A1" : activeCell);
                viewInfo.setSelectionAreas(Strings.isBlank(selectionAreas) ? "A1" : selectionAreas);
            }
        }
        if ((sheetPr = xSheet.getSheetPr()) != null) {
            XlsxExtractor.XlsxColorExtractor xTabColor = sheetPr.getTabColor();
            String tabColor = xTabColor != null ? XlsxImporter.getHTMLColor(xTabColor, this.themes, this, null) : null;
            sheet.setTabColor(tabColor);
            XlsxExtractor.XlsxOutlinePrExtractor xOutlinePrExtractor = sheetPr.getOutlinePr();
            if (xOutlinePrExtractor != null) {
                if (xOutlinePrExtractor.isApplyStyles()) {
                    sheet.setApplyStyles(true);
                }
                if (!xOutlinePrExtractor.isSummaryBelow()) {
                    sheet.setSummaryBelow(false);
                }
                if (!xOutlinePrExtractor.isSummaryRight()) {
                    sheet.setSummaryRight(false);
                }
                if (!xOutlinePrExtractor.isShowOutlineSymbols()) {
                    sheet.setShowOutlineSymbols(false);
                }
            }
        }
        this._importPhase.setPhase("sheet");
        String state = xSheet.getState();
        if ("hidden".equals(state)) {
            sheet.setSheetVisible(SSheet.SheetVisible.HIDDEN);
        } else if ("veryHidden".equals(state)) {
            sheet.setSheetVisible(SSheet.SheetVisible.VERY_HIDDEN);
        } else {
            sheet.setSheetVisible(SSheet.SheetVisible.VISIBLE);
        }
        return sheet;
    }

    protected void importPassword(XlsxExtractor.XlsxSheetProtectionExtractor protectionExtractor, SSheet sheet) {
        String password = protectionExtractor.getPassword();
        if (password != null) {
            short hashpass = this.getPasswordHash(password);
            sheet.setHashedPassword(hashpass);
        }
        String hashValue = protectionExtractor.getHashValue();
        sheet.setHashValue(hashValue);
        String spinCount = protectionExtractor.getSpinCount();
        sheet.setSpinCount(spinCount);
        String saltValue = protectionExtractor.getSaltValue();
        sheet.setSaltValue(saltValue);
        String algName = protectionExtractor.getAlgName();
        sheet.setAlgName(algName);
    }

    protected short getPasswordHash(String password) {
        return (short)Integer.parseInt(password, 16);
    }

    protected void importConditionalFormatting(XlsxExtractor.XlsxSheetExtractor xSheet, SSheet sheet, List<XlsxExtractor.XlsxExtExtractor> extList) {
        List<XlsxExtractor.XlsxConditionalFormattingExtractor> conditionalFormattings = xSheet.getConditionalFormattings();
        if (!conditionalFormattings.isEmpty()) {
            for (XlsxExtractor.XlsxConditionalFormattingExtractor cf : conditionalFormattings) {
                ConditionalFormattingImpl scf = this.prepareConditionalFormattingImpl(sheet, cf);
                ((AbstractSheetAdv)sheet).addConditionalFormatting(scf);
            }
        }
        if (!extList.isEmpty()) {
            for (XlsxExtractor.XlsxExtExtractor ext : extList) {
                List<XlsxExtractor.XlsxExtConditionalFormattingExtractor> extConditionalFormattings = ext.getConditionalFormattings();
                if (extConditionalFormattings.isEmpty()) continue;
                for (XlsxExtractor.XlsxExtConditionalFormattingExtractor cf : extConditionalFormattings) {
                    ConditionalFormattingImpl scf = this.prepareConditionalFormattingImpl(sheet, cf);
                    ((AbstractSheetAdv)sheet).addConditionalFormatting(scf);
                }
            }
        }
    }

    protected ConditionalFormattingImpl prepareConditionalFormattingImpl(SSheet sheet, XlsxExtractor.XlsxConditionalFormattingExtractor cf) {
        ConditionalFormattingImpl cfi = new ConditionalFormattingImpl(sheet);
        for (Ref ref : Converter.toRefs(cf.getSqref())) {
            int r1 = ref.getTop();
            int c1 = ref.getLeft();
            int r2 = ref.getBottom();
            int c2 = ref.getRight();
            cfi.addRegion(new CellRegion(r1, c1, r2, c2));
        }
        for (XlsxExtractor.XlsxCfRuleExtractor cfRule : cf.getCfRules()) {
            cfi.addRule(this.prepareConditonalFormattingRuleImpl(cfi, cfRule));
        }
        if (cf instanceof XlsxExtractor.XlsxExtConditionalFormattingExtractor) {
            cfi.setUnderExt(true);
        }
        return cfi;
    }

    protected ConditionalFormattingRuleImpl prepareConditonalFormattingRuleImpl(SConditionalFormatting cfi, XlsxExtractor.XlsxCfRuleExtractor xRule) {
        ConditionalFormattingRuleImpl cfri = new ConditionalFormattingRuleImpl(cfi);
        cfri.setPriority(xRule.getPriority());
        cfri.setType(xRule.getType());
        cfri.setExtId(xRule.getExtId());
        if (xRule.isSetStopIfTrue()) {
            cfri.setStopIfTrue(xRule.isStopIfTrue());
        }
        if (xRule.isSetDxfId()) {
            SExtraStyle extraStyle = this.styleCaches.getExtraStyleCache().get(xRule.getDxfId());
            if (extraStyle != null) {
                cfri.setExtraStyle(this.book.getOrAddExtraStyle(extraStyle));
            }
        } else if (xRule instanceof XlsxExtractor.XlsxExtCfRuleExtractor) {
            XlsxExtractor.XlsxExtCfRuleExtractor xExtRule = (XlsxExtractor.XlsxExtCfRuleExtractor)xRule;
            XlsxExtractor.XlsxDxfExtractor dxfExtractor = xExtRule.getDxf();
            if (dxfExtractor != null) {
                SExtraStyle extraStyle = this.importExtraStyle(dxfExtractor);
                cfri.setExtraStyle(extraStyle);
                cfri.setUnderExt(true);
            }
            cfri.setId(xExtRule.getId());
        }
        switch (cfri.getType()) {
            case ABOVE_AVERAGE: {
                if (xRule.isSetAboveAverage()) {
                    cfri.setAboveAverage(xRule.isAboveAverage());
                }
                if (xRule.isSetEqualAverage()) {
                    cfri.setEqualAverage(xRule.isEqualAverage());
                }
                if (!xRule.isSetStdDev()) break;
                cfri.setStandardDeviation(xRule.getStdDev());
                break;
            }
            case CELL_IS: {
                if (xRule.isSetOperator()) {
                    cfri.setOperator(xRule.getOperator());
                }
                this.prepareFormulas(cfri, xRule);
                break;
            }
            case COLOR_SCALE: {
                cfri.setColorScale(this.prepareColorScale(xRule));
                break;
            }
            case CONTAINS_BLANKS: 
            case NOT_CONTAINS_BLANKS: 
            case EXPRESSION: 
            case CONTAINS_ERRORS: 
            case NOT_CONTAINS_ERRORS: {
                this.prepareFormulas(cfri, xRule);
                break;
            }
            case CONTAINS_TEXT: 
            case NOT_CONTAINS_TEXT: 
            case BEGINS_WITH: 
            case ENDS_WITH: {
                cfri.setText(xRule.getText());
                cfri.setOperator(xRule.getOperator());
                this.prepareFormulas(cfri, xRule);
                break;
            }
            case DATA_BAR: {
                cfri.setDataBar(this.prepareDataBar(xRule));
                break;
            }
            case ICON_SET: {
                cfri.setIconSet(this.prepareIconSet(xRule));
                break;
            }
            case TIME_PERIOD: {
                cfri.setTimePeriod(xRule.getTimePeriod());
                this.prepareFormulas(cfri, xRule);
                break;
            }
            case TOP_10: {
                if (xRule.isSetRank()) {
                    cfri.setRank(xRule.getRank());
                }
                if (xRule.isSetPercent()) {
                    cfri.setPercent(xRule.isPercent());
                }
                if (!xRule.isSetBottom()) break;
                cfri.setBottom(xRule.isBottom());
                break;
            }
        }
        return cfri;
    }

    protected SColorScale prepareColorScale(XlsxExtractor.XlsxCfRuleExtractor ctRule) {
        XlsxExtractor.XlsxColorScaleExtractor colorScale1 = ctRule.getColorScale();
        ColorScaleImpl colorScale = new ColorScaleImpl();
        for (XlsxExtractor.XlsxCfvoExtractor ctvo : colorScale1.getCfvos()) {
            colorScale.addValueObject(this.prepareValueObject(ctvo));
        }
        for (XlsxExtractor.XlsxColorExtractor xColor : colorScale1.getColors()) {
            ColorImpl color = new ColorImpl(XlsxImporter.getFontHTMLColor(xColor, this.themes, this));
            colorScale.addColor(color);
        }
        return colorScale;
    }

    protected SIconSet prepareIconSet(XlsxExtractor.XlsxCfRuleExtractor ctRule) {
        IconSetImpl iconSet = new IconSetImpl();
        XlsxExtractor.XlsxIconSetExtractor iconSet1 = ctRule.getIconSet();
        for (XlsxExtractor.XlsxCfvoExtractor ctvo : iconSet1.getCfvos()) {
            iconSet.addValueObject(this.prepareValueObject(ctvo));
        }
        iconSet.setType(iconSet1.getIconSet());
        if (iconSet1.isSetPercent()) {
            iconSet.setPercent(iconSet1.isPercent());
        }
        if (iconSet1.isSetReverse()) {
            iconSet.setReverse(iconSet1.isReverse());
        }
        if (iconSet1.isSetShowValue()) {
            iconSet.setShowValue(iconSet1.isShowValue());
        }
        if (iconSet1.getCfIcons() != null) {
            for (XlsxExtractor.XlsxCfIconExtractor icon : iconSet1.getCfIcons()) {
                iconSet.addCfIcon(this.prepareCFIcon(icon));
            }
        }
        return iconSet;
    }

    protected void prepareFormulas(ConditionalFormattingRuleImpl cfri, XlsxExtractor.XlsxCfRuleExtractor xRule) {
        Iterator<String> it = xRule.getFormulas().iterator();
        if (!it.hasNext()) {
            return;
        }
        cfri.setFormula1(it.next());
        if (!it.hasNext()) {
            return;
        }
        cfri.setFormula2(it.next());
        if (!it.hasNext()) {
            return;
        }
        cfri.setFormula3(it.next());
    }

    protected SDataBar prepareDataBar(XlsxExtractor.XlsxCfRuleExtractor ctRule) {
        DataBarImpl dataBar = new DataBarImpl();
        XlsxExtractor.XlsxDataBarExtractor xDataBar = ctRule.getDataBar();
        for (XlsxExtractor.XlsxCfvoExtractor ctvo : xDataBar.getCfvos()) {
            dataBar.addValueObject(this.prepareValueObject(ctvo));
        }
        ColorImpl color = new ColorImpl(XlsxImporter.getFontHTMLColor(xDataBar.getColor(), this.themes, this));
        dataBar.setColor(color);
        if (xDataBar.isSetMaxLength()) {
            dataBar.setMaxLength(xDataBar.getMaxLength());
        }
        if (xDataBar.isSetMinLength()) {
            dataBar.setMinLength(xDataBar.getMinLength());
        }
        if (xDataBar.isSetShowValue()) {
            dataBar.setShowValue(xDataBar.isShowValue());
        }
        if (xDataBar instanceof XlsxExtractor.XlsxExtDataBarExtractor) {
            XlsxExtractor.XlsxExtDataBarExtractor extDataBar = (XlsxExtractor.XlsxExtDataBarExtractor)xDataBar;
            XlsxExtractor.XlsxColorExtractor colorValue = extDataBar.getBorderColor();
            if (colorValue != null) {
                dataBar.setBorderColor(new ColorImpl(XlsxImporter.getFontHTMLColor(colorValue, this.themes, this)));
            }
            if ((colorValue = extDataBar.getNegativeBorderColor()) != null) {
                dataBar.setNegativeBorderColor(new ColorImpl(XlsxImporter.getFontHTMLColor(colorValue, this.themes, this)));
            }
            if ((colorValue = extDataBar.getNegativeFillColor()) != null) {
                dataBar.setNegativeFillColor(new ColorImpl(XlsxImporter.getFontHTMLColor(colorValue, this.themes, this)));
            }
            if ((colorValue = extDataBar.getAxisColor()) != null) {
                dataBar.setAxisColor(new ColorImpl(XlsxImporter.getFontHTMLColor(colorValue, this.themes, this)));
            }
            dataBar.setBorder(extDataBar.isBorder());
            dataBar.setGradient(extDataBar.isGradient());
            dataBar.setNegativeBarBorderColorSameAsPositive(extDataBar.isNegativeBarBorderColorSameAsPositive());
            dataBar.setNegativeBarColorSameAsPositive(extDataBar.isNegativeBarColorSameAsPositive());
            dataBar.setAxisPosition(extDataBar.getAxisPosition());
            dataBar.setDirection(extDataBar.getDirection());
        }
        return dataBar;
    }

    protected SCFValueObject prepareValueObject(XlsxExtractor.XlsxCfvoExtractor ctvo) {
        CFValueObjectImpl vo = new CFValueObjectImpl();
        if (ctvo.isSetGte()) {
            vo.setGreaterOrEqual(ctvo.isGte());
        }
        vo.setType(ctvo.getType());
        if (ctvo.isSetVal()) {
            vo.setValue(ctvo.getVal());
        }
        return vo;
    }

    protected SCFIcon prepareCFIcon(XlsxExtractor.XlsxCfIconExtractor cfIcon) {
        CFIconImpl icon = new CFIconImpl();
        icon.setType(cfIcon.getIconSet());
        icon.setIconId(cfIcon.getIconId());
        return icon;
    }
}

