/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.importer;

import io.keikai.importer.CategoryAxisJson;
import io.keikai.importer.ChartType;
import io.keikai.importer.ChartTypeJson;
import io.keikai.importer.DateAxisJson;
import io.keikai.importer.LegendStyle;
import io.keikai.importer.ShapeJson;
import io.keikai.importer.ValueAxisJson;
import io.keikai.importer.View3DJson;
import io.keikai.util.Converter;
import io.keikai.util.Oid;
import io.keikai.util.XlsxJsonHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ChartSpaceJson
extends ShapeJson {
    private final String _uuid;
    private final Map _chartEntry;
    private final Map _plotAreaEntry;
    private final List<ChartTypeJson> chartTypes;

    ChartSpaceJson(String uuid, Map viewAnchor, Map chartSpace, Map chartColor, Map chartStyle) {
        super(viewAnchor);
        this._uuid = uuid != null ? uuid : Oid.nextOid();
        this._chartEntry = (Map)XlsxJsonHelper.$(chartSpace, "c:chartSpace", "c:chart");
        this._plotAreaEntry = (Map)XlsxJsonHelper.$x(this._chartEntry, "c:plotArea");
        this.chartTypes = this.findChartTypes();
    }

    @Override
    String getName() {
        Map map = (Map)XlsxJsonHelper.$x(this.viewAnchor, "xdr:graphicFrame/xdr:nvGraphicFramePr/xdr:cNvPr");
        return map == null ? null : XlsxJsonHelper.toStringValue(map, "name");
    }

    @Override
    String getUuid() {
        return this._uuid;
    }

    List<CategoryAxisJson> getCategoryAxises() {
        Object result = XlsxJsonHelper.$(this._plotAreaEntry, "c:catAx");
        if (result instanceof Map) {
            return Converter.asList(new CategoryAxisJson((Map)result));
        }
        if (result instanceof List) {
            return ((List)result).stream().map(CategoryAxisJson::new).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    List<ValueAxisJson> getValueAxises() {
        Object result = XlsxJsonHelper.$(this._plotAreaEntry, "c:valAx");
        if (result instanceof Map) {
            return Converter.asList(new ValueAxisJson((Map)result));
        }
        if (result instanceof List) {
            return ((List)result).stream().map(ValueAxisJson::new).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    List<DateAxisJson> getDateAxises() {
        Object result = XlsxJsonHelper.$(this._plotAreaEntry, "c:dateAx");
        if (result instanceof Map) {
            return Converter.asList(new DateAxisJson((Map)result));
        }
        if (result instanceof List) {
            return ((List)result).stream().map(DateAxisJson::new).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    boolean isSetView3D() {
        return this._chartEntry.containsKey("c:view3D");
    }

    View3DJson getView3D() {
        return new View3DJson((Map)XlsxJsonHelper.$(this._chartEntry, "c:view3D"));
    }

    String getDispBlanksAs() {
        return XlsxJsonHelper.toStringValue(this._chartEntry, "c:dispBlanksAs", "zero");
    }

    boolean hasAutoTitleDeleted() {
        return XlsxJsonHelper.$(this._chartEntry, "c:autoTitleDeleted") != null;
    }

    boolean isAutoTitleDeleted() {
        return XlsxJsonHelper.toBoolean(XlsxJsonHelper.getValue(this._chartEntry, "c:autoTitleDeleted"), true);
    }

    private boolean isColumn(Map jsonMap) {
        return "col".equals(XlsxJsonHelper.toStringValue(jsonMap, "c:barDir"));
    }

    boolean isRoundedCorners() {
        return XlsxJsonHelper.toBoolean(XlsxJsonHelper.toValue(this._chartEntry, "c:roundedCorners "), true);
    }

    boolean isPlotOnlyVisibleCells() {
        return XlsxJsonHelper.toBoolean(XlsxJsonHelper.toValue(this._chartEntry, "c:plotVisOnly"), true);
    }

    boolean isShowDLblsOverMax() {
        return XlsxJsonHelper.toBoolean(XlsxJsonHelper.toValue(this._chartEntry, "c:showDLblsOverMax"), true);
    }

    boolean hasTitle() {
        return XlsxJsonHelper.$(this._chartEntry, "c:title") != null;
    }

    String getTitle() {
        Stream<String> stream;
        Object cp = XlsxJsonHelper.$x(this._chartEntry, "c:title/c:tx/c:rich/a:p");
        if (cp == null) {
            cp = XlsxJsonHelper.$x(this._chartEntry, "c:title/c:txPr/a:p");
        }
        if (cp instanceof List) {
            stream = ((List)cp).stream().map(entry -> XlsxJsonHelper.toStringValue((Map)XlsxJsonHelper.$(entry, "a:r"), "a:t", ""));
        } else if (cp instanceof Map) {
            stream = XlsxJsonHelper.toList(cp, "a:r").stream().map(entry -> XlsxJsonHelper.toStringValue(entry, "a:t", ""));
        } else {
            return null;
        }
        return stream.filter(Objects::nonNull).reduce("", (result, curr) -> result + curr);
    }

    LegendStyle getLegendStyle() {
        Map legend = (Map)XlsxJsonHelper.$(this._chartEntry, "c:legend");
        if (legend != null) {
            return new LegendStyle(legend);
        }
        return null;
    }

    List<ChartTypeJson> getChartTypes() {
        return this.chartTypes;
    }

    private List<ChartTypeJson> findChartTypes() {
        List stockChartList;
        List surface3DChartList;
        List surfaceChartList;
        List bubbleChartList;
        List scatterChartList;
        List radarChartList;
        List line3DChartList;
        List lineChartList;
        List bar3DChartList;
        List barChartList;
        List area3DChartList;
        List areaChartList;
        List doughnutChartList;
        List ofPieChartList;
        List pie3DChartList;
        ArrayList<ChartTypeJson> result = new ArrayList<ChartTypeJson>();
        List pieChartList = XlsxJsonHelper.toList(this._plotAreaEntry, "c:pieChart");
        if (pieChartList != null) {
            pieChartList.forEach(json -> result.add(new ChartTypeJson(ChartType.PIE, (Map)json)));
        }
        if ((pie3DChartList = XlsxJsonHelper.toList(this._plotAreaEntry, "c:pie3DChart")) != null) {
            pie3DChartList.forEach(json -> result.add(new ChartTypeJson(ChartType.PIE_3D, (Map)json)));
        }
        if ((ofPieChartList = XlsxJsonHelper.toList(this._plotAreaEntry, "c:ofPieChart")) != null) {
            ofPieChartList.forEach(json -> result.add(new ChartTypeJson(ChartType.OF_PIE, (Map)json)));
        }
        if ((doughnutChartList = XlsxJsonHelper.toList(this._plotAreaEntry, "c:doughnutChart")) != null) {
            doughnutChartList.forEach(json -> result.add(new ChartTypeJson(ChartType.DOUGHNUT, (Map)json)));
        }
        if ((areaChartList = XlsxJsonHelper.toList(this._plotAreaEntry, "c:areaChart")) != null) {
            areaChartList.forEach(json -> result.add(new ChartTypeJson(ChartType.AREA, (Map)json)));
        }
        if ((area3DChartList = XlsxJsonHelper.toList(this._plotAreaEntry, "c:area3DChart")) != null) {
            area3DChartList.forEach(json -> result.add(new ChartTypeJson(ChartType.AREA_3D, (Map)json)));
        }
        if ((barChartList = XlsxJsonHelper.toList(this._plotAreaEntry, "c:barChart")) != null) {
            barChartList.forEach(json -> result.add(new ChartTypeJson(this.isColumn((Map)json) ? ChartType.COLUMN : ChartType.BAR, (Map)json)));
        }
        if ((bar3DChartList = XlsxJsonHelper.toList(this._plotAreaEntry, "c:bar3DChart")) != null) {
            bar3DChartList.forEach(json -> result.add(new ChartTypeJson(this.isColumn((Map)json) ? ChartType.COLUMN_3D : ChartType.BAR_3D, (Map)json)));
        }
        if ((lineChartList = XlsxJsonHelper.toList(this._plotAreaEntry, "c:lineChart")) != null) {
            lineChartList.forEach(json -> result.add(new ChartTypeJson(ChartType.LINE, (Map)json)));
        }
        if ((line3DChartList = XlsxJsonHelper.toList(this._plotAreaEntry, "c:line3DChart")) != null) {
            line3DChartList.forEach(json -> result.add(new ChartTypeJson(ChartType.LINE_3D, (Map)json)));
        }
        if ((radarChartList = XlsxJsonHelper.toList(this._plotAreaEntry, "c:radarChart")) != null) {
            radarChartList.forEach(json -> result.add(new ChartTypeJson(ChartType.RADAR, (Map)json)));
        }
        if ((scatterChartList = XlsxJsonHelper.toList(this._plotAreaEntry, "c:scatterChart")) != null) {
            scatterChartList.forEach(json -> result.add(new ChartTypeJson(ChartType.SCATTER, (Map)json)));
        }
        if ((bubbleChartList = XlsxJsonHelper.toList(this._plotAreaEntry, "c:bubbleChart")) != null) {
            bubbleChartList.forEach(json -> result.add(new ChartTypeJson(ChartType.BUBBLE, (Map)json)));
        }
        if ((surfaceChartList = XlsxJsonHelper.toList(this._plotAreaEntry, "c:surfaceChart")) != null) {
            surfaceChartList.forEach(json -> result.add(new ChartTypeJson(ChartType.SURFACE, (Map)json)));
        }
        if ((surface3DChartList = XlsxJsonHelper.toList(this._plotAreaEntry, "c:surface3DChart")) != null) {
            surface3DChartList.forEach(json -> result.add(new ChartTypeJson(ChartType.SURFACE_3D, (Map)json)));
        }
        if ((stockChartList = XlsxJsonHelper.toList(this._plotAreaEntry, "c:stockChart")) != null) {
            stockChartList.forEach(json -> result.add(new ChartTypeJson(ChartType.STOCK, (Map)json)));
        }
        return result;
    }
}

