/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.util;

import io.keikai.util.Span;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

public class SpareSpan {
    private int start;
    private int end;
    private List<Span> spans = new ArrayList<Span>();
    private static Comparator _ReadSpanComparator = new Comparator<Span>(){

        @Override
        public int compare(Span inSpansSpan, Span keySpan) {
            int key = keySpan.getStart();
            return key < inSpansSpan.getStart() ? -1 : (key >= inSpansSpan.getEnd() ? 1 : 0);
        }
    };
    private static Comparator _SplitSpanComparator = new Comparator<Span>(){

        @Override
        public int compare(Span inSpansSpan, Span keySpan) {
            int key = keySpan.getStart();
            return key <= inSpansSpan.getStart() ? -1 : (key >= inSpansSpan.getEnd() ? 1 : 0);
        }
    };
    private static Comparator _WriteSpanComparator;
    private static Comparator _MergeSpanComparator;

    public boolean isEmpty() {
        return this.spans.isEmpty();
    }

    public int size() {
        return this.spans.size();
    }

    public Stream<Span> stream() {
        return this.spans.stream();
    }

    public void clear() {
        this.spans.clear();
    }

    private static <T> int intBinarySearch(List<? extends T> l, T key, Comparator<? super T> c) {
        int low = 0;
        int hgh = l.size() - 1;
        while (low <= hgh) {
            int mid = low + hgh >>> 1;
            T midVal = l.get(mid);
            int cmp = c.compare(midVal, key);
            if (cmp == 0) {
                return mid;
            }
            if (cmp < 0) {
                hgh = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return -(low + 1);
    }

    public Span getSpan(int index) {
        int j = SpareSpan.intBinarySearch(this.spans, new Span(index, 1), _ReadSpanComparator);
        return j < 0 ? null : this.spans.get(j);
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public void extend(int index, int size) {
        int j = SpareSpan.intBinarySearch(this.spans, new Span(index, 1), _SplitSpanComparator);
        int len = this.spans.size();
        if (j < 0) {
            for (int k = -j - 1; k < len; ++k) {
                Span span0 = this.spans.get(k);
                span0.start += size;
            }
        } else {
            Span span = this.spans.get(j);
            Span span2 = span.split(index);
            this.spans.add(++j, span2);
            for (int k = j; k <= len; ++k) {
                Span span1 = this.spans.get(k);
                span1.start += size;
            }
        }
    }

    public void extendAndMerge(int index, int size) {
        int j = SpareSpan.intBinarySearch(this.spans, new Span(index, 1), _MergeSpanComparator);
        int len = this.spans.size();
        if (j < 0) {
            for (int k = -j - 1; k < len; ++k) {
                Span span0 = this.spans.get(k);
                span0.start += size;
            }
        } else {
            Span span = this.spans.get(j);
            span.length += size;
            int len0 = this.spans.size();
            for (int k = ++j; k < len0; ++k) {
                Span span0 = this.spans.get(k);
                span0.start += size;
            }
        }
    }

    public void shrink(int startIdx, int size) {
        List<Integer> rng = this.removeSpans(startIdx, size);
        Integer sj = rng.get(0);
        if (sj != null) {
            int len = this.spans.size();
            int size0 = -size;
            for (int k = sj.intValue(); k < len; ++k) {
                Span span = this.spans.get(k);
                span.start += size0;
            }
        }
    }

    public List<Integer> removeSpans(int startIdx, int size) {
        Span span;
        int endIdx = startIdx + size;
        int sj = SpareSpan.intBinarySearch(this.spans, new Span(startIdx, 1), _SplitSpanComparator);
        int ej = SpareSpan.intBinarySearch(this.spans, new Span(endIdx, 1), _SplitSpanComparator);
        if (ej < 0) {
            ej = -ej - 1;
        } else {
            span = this.spans.get(ej);
            Span span2 = span.split(endIdx);
            this.spans.add(++ej, span2);
        }
        if (sj < 0) {
            sj = -sj - 1;
        } else {
            span = this.spans.get(sj);
            span.split(startIdx);
            ++sj;
        }
        if (sj < ej) {
            this.spans.subList(sj, ej).clear();
        }
        return Arrays.asList(sj, ej);
    }

    public Span getSpanAt(int sj) {
        return this.spans.get(sj);
    }

    public Span deleteSpanAt(int sj) {
        return this.spans.remove(sj);
    }

    public void addSpan(int start, int length) {
        this._addSpanMerge(start, length);
    }

    public void deleteSpan(int start, int length) {
        int s;
        List<Integer> affected = this._addSpanSplit(start, length);
        int e = affected.get(1);
        for (int it = s = affected.get(0).intValue(); it < e; ++it) {
            this.deleteSpanAt(s);
        }
    }

    private List<Integer> _addSpanMerge(int start, int length) {
        int e;
        int s;
        int ej;
        int end = start + length;
        int sj = SpareSpan.intBinarySearch(this.spans, new Span(start, 1), _WriteSpanComparator);
        if (sj == (ej = SpareSpan.intBinarySearch(this.spans, new Span(end, 1), _WriteSpanComparator))) {
            if (sj < 0) {
                sj = -sj - 1;
                this.spans.add(sj, new Span(start, length));
            }
            return Arrays.asList(sj, sj + 1);
        }
        if (sj < 0) {
            s = start;
            sj = -sj - 1;
        } else {
            s = this.spans.get((int)sj).start;
        }
        if (ej < 0) {
            e = end;
            ej = -ej - 1;
        } else {
            e = this.spans.get(ej).getEnd();
            ++ej;
        }
        if (sj < ej) {
            this.spans.subList(sj, ej).clear();
        }
        this.spans.add(sj, new Span(s, e - s));
        return Arrays.asList(sj, sj + 1);
    }

    private List<Integer> _addSpanSplit(int start, int length) {
        int asj;
        Span span2;
        Span span1;
        int aej;
        int end = start + length;
        int sj = SpareSpan.intBinarySearch(this.spans, new Span(start, 1), _SplitSpanComparator);
        int ej = SpareSpan.intBinarySearch(this.spans, new Span(end, 1), _SplitSpanComparator);
        int end0 = end;
        int start0 = start;
        if (ej < 0) {
            aej = ej = -ej - 1;
        } else {
            span1 = this.spans.get(ej);
            span2 = span1.split(end);
            this.spans.add(ej + 1, span2);
            aej = ej + 1;
            end0 = span1.start;
        }
        if (sj < 0) {
            asj = sj = -sj - 1;
        } else {
            span1 = this.spans.get(sj);
            span2 = span1.split(start);
            this.spans.add(++sj, span2);
            asj = sj++;
            ++ej;
            ++aej;
            start0 = span2.getEnd();
        }
        int j = ej;
        while (--j >= sj) {
            Span span12 = this.spans.get(j);
            int end1 = span12.getEnd();
            if (end1 < end0) {
                this.spans.add(j + 1, new Span(end1, end0 - end1));
                ++aej;
            }
            end0 = span12.start;
        }
        if (start0 < end0) {
            this.spans.add(j + 1, new Span(start0, end0 - start0));
            ++aej;
        }
        return Arrays.asList(asj, aej);
    }

    static {
        _MergeSpanComparator = _WriteSpanComparator = new Comparator<Span>(){

            @Override
            public int compare(Span inSpansSpan, Span keySpan) {
                int key = keySpan.getStart();
                return key < inSpansSpan.getStart() ? -1 : (key > inSpansSpan.getEnd() ? 1 : 0);
            }
        };
    }
}

